-- This file is automatically generated, do not edit!
-- Path of Building
--
-- Other active skills
-- Skill data (c) Grinding Gear Games
--
local skills, mod, flag, skill = ...

skills["RepeatingShockwave"] = {
	name = "Abberath's Fury",
	hidden = true,
	color = 4,
	description = "While you run, this skill creates a small explosion with each step, dealing fire damage in an area around you.",
	skillTypes = { [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Fire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_chance_to_ignite_%",
		"cast_on_gain_skill",
		"cannot_knockback",
		"spell_uncastable_if_triggerable",
		"is_area_damage",
		"skill_can_add_multiple_charges_per_action",
		"no_cost",
	},
	levels = {
		[7] = { 50, 75, 10, critChance = 5, levelRequirement = 1, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["AnimateGuardianWeapon"] = {
	name = "Animate Guardian's Weapon",
	hidden = true,
	color = 2,
	description = "Animates a copy of your Animated Guardian's main-hand weapon to fight by your side.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Duration] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Triggered] = true, [SkillType.CreatesMinion] = true, [SkillType.Physical] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.ThresholdJewelProjectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.ThresholdJewelRangedAttack] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 0.8,
	fromItem = true,
	minionHasItemSet = true,
	minionUses = {
		["Weapon 1"] = true,
	},
	minionList = {
		"AnimatedWeapon",
	},
	statMap = {
		["active_skill_damage_+%_final"] = {
			mod("MinionModifier", "LIST", { mod = mod("Damage", "MORE", nil) }),
		},
		["attack_minimum_added_physical_damage"] = {
			mod("MinionModifier", "LIST", { mod = mod("PhysicalMin", "BASE", nil, 0, KeywordFlag.Attack) }),
		},
		["attack_maximum_added_physical_damage"] = {
			mod("MinionModifier", "LIST", { mod = mod("PhysicalMax", "BASE", nil, 0, KeywordFlag.Attack) }),
		},
		["number_of_animated_weapons_allowed"] = {
			mod("Multiplier:AnimatedWeapon", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true })
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"chance_to_trigger_on_animate_weapon_kill_%",
		"active_skill_minion_damage_+%_final",
		"active_skill_minion_attack_speed_+%_final",
		"base_skill_effect_duration",
		"attack_minimum_added_physical_damage",
		"attack_maximum_added_physical_damage",
		"number_of_animated_weapons_allowed",
		"chance_to_trigger_on_animate_guardian_kill_%",
	},
	levels = {
		[18] = { 10, 0, 0, 20000, 108, 159, 13, cooldown = 0.05, levelRequirement = 64, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[20] = { 100, 0, 0, 20000, 126, 184, 14, cooldown = 0.05, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["SupportTriggerSpellOnBowAttack"] = {
	name = "Asenath's Chant",
	hidden = true,
	color = 4,
	support = true,
	requireSkillTypes = { SkillType.Spell, SkillType.Triggerable, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.Trapped, SkillType.RemoteMined, SkillType.SummonsTotem, SkillType.Aura, SkillType.InbuiltTrigger, },
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_has_trigger_from_unique_item",
		"triggered_skill_uses_main_hand_or_averaged_attack_time_for_pvp_scaling",
	},
	levels = {
		[1] = { 1, cooldown = 0.3, levelRequirement = 1, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["BirdAspect"] = {
	name = "Aspect of the Avian",
	hidden = true,
	color = 4,
	description = "While active, grants the Avian's Might and Avian's Flight buffs in sequence. Avian's Might grants you and your minions a chance to deal Double Damage with hits for a duration. Avian's Flight grants you and your minions increased Movement Speed for a secondary duration.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Spell] = true, [SkillType.HasReservation] = true, [SkillType.Duration] = true, [SkillType.Instant] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	fromItem = true,
	statMap = {
		["chance_to_deal_double_damage_%"] = {
			mod("DoubleDamageChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Avian's Might", effectCond = "AviansMightActive" }),
		},
		["base_movement_velocity_+%"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Avian's Flight", effectCond = "AviansFlightActive" }),
		},
		["minion_movement_speed_+%"] = {
		},
	},
	baseFlags = {
		cast = true,
		duration = true,
	},
	baseMods = {
		skill("buffMinions", true),
	},
	qualityStats = {
	},
	stats = {
		"chance_to_deal_double_damage_%",
		"minion_chance_to_deal_double_damage_%",
		"base_movement_velocity_+%",
		"minion_movement_speed_+%",
		"base_skill_effect_duration",
		"base_secondary_skill_effect_duration",
	},
	levels = {
		[20] = { 10, 10, 10, 10, 4000, 4000, manaReservationPercent = 25, cooldown = 0.5, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["CatAspect"] = {
	name = "Aspect of the Cat",
	hidden = true,
	color = 4,
	description = "While active, grants the Cat's Stealth and Cat's Agility buffs in sequence. Cat's Stealth increases your critical strike chance, makes you harder to see, and gives you a chance to avoid damage for a short duration. Cat's Agility increases your attack and cast speed for a longer secondary duration.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Spell] = true, [SkillType.HasReservation] = true, [SkillType.Duration] = true, [SkillType.Instant] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	fromItem = true,
	statMap = {
		["critical_strike_chance_+%"] = {
			mod("CritChance", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Cat's Stealth", effectCond = "CatsStealthActive" }),
		},
		["attack_speed_+%_granted_from_skill"] = {
			mod("Speed", "INC", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Cat's Agility", effectCond = "CatsAgilityActive" }),
		},
		["cast_speed_+%_granted_from_skill"] = {
			mod("Speed", "INC", nil, ModFlag.Cast, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Cat's Agility", effectCond = "CatsAgilityActive" }),
		},
	},
	baseFlags = {
		cast = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"critical_strike_chance_+%",
		"avoid_damage_%",
		"stealth_+%",
		"attack_speed_+%_granted_from_skill",
		"cast_speed_+%_granted_from_skill",
		"base_skill_effect_duration",
		"base_secondary_skill_effect_duration",
	},
	levels = {
		[20] = { 100, 15, 100, 10, 10, 4000, 6000, manaReservationPercent = 25, cooldown = 0.5, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["CrabAspect"] = {
	name = "Aspect of the Crab",
	hidden = true,
	color = 4,
	description = "While active, periodically adds Crab Barriers to you, and grants additional Physical Damage reduction for each Crab Barrier you have. All Crab Barriers are lost when you take physical damage from a hit.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Spell] = true, [SkillType.HasReservation] = true, [SkillType.Instant] = true, [SkillType.Physical] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	fromItem = true,
	statMap = {
		["physical_damage_reduction_%_per_crab_aspect_stack"] = {
			mod("PhysicalDamageReduction", "BASE", nil, 0, 0, { type = "Multiplier", var = "CrabBarrier" }, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["max_crab_aspect_stacks"] = {
			mod("CrabBarriersMax", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", unscalable = true }),
		},
	},
	baseFlags = {
		cast = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"physical_damage_reduction_%_per_crab_aspect_stack",
		"max_crab_aspect_stacks",
	},
	levels = {
		[20] = { 2, 10, manaReservationPercent = 25, cooldown = 0.5, levelRequirement = 1, statInterpolation = { 1, 1, }, cost = { }, },
	},
}
skills["SpiderAspect"] = {
	name = "Aspect of the Spider",
	hidden = true,
	color = 4,
	description = "While active, periodically applies a Spider's Web debuff to nearby Enemies, and Hinders them. Each Spider's Web on an Enemy increases the Damage they take. Hinder reduces their movement speed.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Spell] = true, [SkillType.HasReservation] = true, [SkillType.Duration] = true, [SkillType.Instant] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 0,
	fromItem = true,
	statMap = {
		["base_damage_taken_+%"] = {
			mod("DamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Debuff", effectName = "Spider's Web" })
		},
		["spider_aspect_max_web_count"] = {
			mod("Multiplier:SpiderWebApplyStackMax", "BASE", nil),
		},
	},
	baseFlags = {
		cast = true,
		duration = true,
	},
	baseMods = {
		skill("debuff", true),
		skill("stackCount", 1, { type = "Multiplier", var = "SpiderWebApplyStack", limitVar = "SpiderWebApplyStackMax" }),
	},
	qualityStats = {
	},
	stats = {
		"base_damage_taken_+%",
		"base_skill_effect_duration",
		"spider_aspect_web_interval_ms",
		"spider_aspect_max_web_count",
	},
	levels = {
		[20] = { 5, 6000, 1000, 3, manaReservationPercent = 25, cooldown = 0.5, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["SupportBloodMagicUniquePrismGuardian"] = {
	name = "Blood Magic",
	hidden = true,
	color = 1,
	support = true,
	requireSkillTypes = { },
	addSkillTypes = { },
	excludeSkillTypes = { },
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_reserve_life_instead_of_mana",
		"base_skill_cost_life_instead_of_mana",
	},
	levels = {
		[1] = { levelRequirement = 0, statInterpolation = { }, cost = { }, },
	},
}
skills["BloodOffering"] = {
	name = "Blood Offering",
	hidden = true,
	color = 3,
	description = "Consumes a corpse, and sacrifices a portion of your life, granting your minions life regeneration based on the life sacrificed, and a bonus to damage. The skill consumes other nearby corpses, increasing the duration and life regeneration for each corpse consumed.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.Minion] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, },
	statDescriptionScope = "offering_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	statMap = {
		["damage_+%"] = {
			mod("Damage", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
		skill("buffMinions", true),
		skill("buffNotPlayer", true),
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"offering_skill_effect_duration_per_corpse",
		"blood_offering_%_of_life_to_lose",
		"blood_offering_%_of_lost_life_to_regenerate_as_life_per_second",
		"blood_offering_life_regenerated_+%_final_per_corpse",
		"damage_+%",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 5000, 1000, 20, 35, 10, 50, levelRequirement = 12, statInterpolation = { 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[15] = { 5000, 1000, 20, 35, 10, 50, levelRequirement = 12, statInterpolation = { 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["BloodSacramentUnique"] = {
	name = "Blood Sacrament",
	hidden = true,
	color = 4,
	baseEffectiveness = 4.8000001907349,
	description = "Channel this skill to reserve more and more of your life, building up power in a marker on the ground under you. Release to deal physical damage in an area based on how much life you reserved. Cannot be cast by Totems.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Channel] = true, [SkillType.AreaSpell] = true, [SkillType.HasReservation] = true, [SkillType.Physical] = true, [SkillType.Nova] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.24,
	fromItem = true,
	initialFunc = function(activeSkill, output)
		local lifeReservedPercent = activeSkill.skillData["LifeReservedPercent"] or 3
		local lifeReserved = activeSkill.skillData["LifeReservedBase"] or math.huge
		activeSkill.skillModList:NewMod("Multiplier:ChannelledLifeReservedPercentPerStage", "BASE", lifeReservedPercent, "Blood Sacrament")
		activeSkill.skillModList:NewMod("Multiplier:ChannelledLifeReservedPerStage", "BASE", lifeReserved, "Blood Sacrament")
	end,
	statMap = {
		["flameblast_hundred_times_radius_+_per_1%_life_reserved"] = {
			skill("radiusExtra", nil, { type = "Multiplier", var = "ChannelledLifeReservedPercentPerStage" }, { type = "Multiplier", var = "BloodSacramentStage" }),
			div = 100,
		},
		["flameblast_damage_+%_final_per_10_life_reserved"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "Multiplier", var = "ChannelledLifeReservedPerStage", div = 10 }, { type = "ModFlagOr", modFlags = bit.bor(ModFlag.Hit, ModFlag.Ailment) }, { type = "Multiplier", var = "BloodSacramentStage" }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("radius", 5),
		mod("Multiplier:BloodSacramentMaxStages", "BASE", 33),
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"flameblast_hundred_times_radius_+_per_1%_life_reserved",
		"flameblast_damage_+%_final_per_10_life_reserved",
		"life_leech_from_any_damage_permyriad",
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 40, 80, 200, damageEffectiveness = 0.03, lifeReservationPercent = 3, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
	},
}
skills["BoneArmour"] = {
	name = "Bone Armour",
	hidden = true,
	color = 3,
	baseEffectiveness = 10,
	incrementalEffectiveness = 0.029999999329448,
	description = "Applies a buff to you and each of your minions, which will take some of the damage from enemy hits before being depleted. The buff also grants immunity to bleeding. Shares a cooldown with other Guard skills.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Instant] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.Guard] = true, [SkillType.Minion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 0,
	fromTree = true,
	statMap = {
		["quick_guard_damage_absorbed_%"] = {
			mod("GuardAbsorbRate", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Guard" }),
		},
		["quick_guard_damage_absorb_limit"] = {
			mod("GuardAbsorbLimit", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Guard", unscalable = true }),
		},
	},
	baseFlags = {
		duration = true,
		spell = true,
	},
	baseMods = {
		mod("AvoidBleed", "BASE", 100, 0, 0, { type = "GlobalEffect", effectType = "Guard" }),
	},
	qualityStats = {
	},
	stats = {
		"quick_guard_damage_absorbed_%",
		"quick_guard_damage_absorb_limit",
		"base_deal_no_damage",
		"display_this_skill_cooldown_does_not_recover_during_buff",
		"display_skill_buff_grants_bleeding_immunity",
	},
	levels = {
		[20] = { 70, 1, levelRequirement = 70, duration = 3, cooldown = 3, statInterpolation = { 1, 3, }, cost = { }, },
	},
}
skills["TriggeredBoneNova"] = {
	name = "Bone Nova",
	hidden = true,
	color = 4,
	description = "Bones erupt around enemies you hit, dealing physical damage.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"number_of_additional_projectiles",
		"attack_trigger_on_hitting_bleeding_enemy_%",
		"monster_projectile_variation",
		"projectiles_nova",
		"spell_uncastable_if_triggerable",
		"base_is_projectile",
		"cannot_cause_bleeding",
	},
	levels = {
		[20] = { 8, 100, 15, cooldown = 0.5, levelRequirement = 1, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["BrandDetonate"] = {
	name = "Brandsurge",
	hidden = true,
	color = 3,
	baseEffectiveness = 6.5999999046326,
	incrementalEffectiveness = 0.03999999910593,
	description = "Overcharges your brands near the targeted area, causing them to accelerate how quickly they activate and expire. Deals damage in an area around each overcharged brand when it expires.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, [SkillType.Physical] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, [SkillType.Multicastable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.6,
	fromItem = true,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"brand_detonate_faster_activation_%_per_second",
		"brand_detonate_faster_duration_%_per_second",
		"display_brand_deonate_tag_conversion",
	},
	levels = {
		[20] = { 0.80000001192093, 1.2000000476837, 35, 150, damageEffectiveness = 5.1, cooldown = 1.5, critChance = 5, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, }, cost = { Mana = 20, }, },
	},
}
skills["ColdAegis"] = {
	name = "Cold Aegis",
	hidden = true,
	color = 4,
	description = "Calls forth a protective aegis which takes cold damage from hits for you until depleted. The aegis will be restored to its full value after a short delay if you stop taking cold damage from hits, or if depleted.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Aegis] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"aegis_unique_shield_max_value",
		"active_skill_display_aegis_variation",
		"aegis_recharge_delay_ms",
		"cast_on_gain_skill",
		"spell_uncastable_if_triggerable",
		"no_cost",
	},
	levels = {
		[20] = { 1000, 1, 10000, levelRequirement = 1, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["TriggeredConsecrate"] = {
	name = "Consecrate",
	hidden = true,
	color = 4,
	description = "Creates an area of Consecrated Ground, providing life regeneration and reducing the effect of curses for you and allies who stand in it.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.Area] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.AreaSpell] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		spell = true,
		duration = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"life_regeneration_rate_per_minute_%",
		"cast_on_crit_%",
		"spell_uncastable_if_triggerable",
	},
	levels = {
		[10] = { 5000, 360, 100, cooldown = 5, levelRequirement = 1, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["CreateFungalGroundOnKill"] = {
	name = "Contaminate",
	hidden = true,
	color = 4,
	description = "Creates a patch of Fungal Ground at the targeted location.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Cooldown] = true, [SkillType.Triggered] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		duration = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"chance_to_cast_on_kill_%",
		"base_deal_no_damage",
		"spell_uncastable_if_triggerable",
	},
	levels = {
		[10] = { 100, levelRequirement = 1, duration = 5, cooldown = 1, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["CorpseWalk"] = {
	name = "Corpse Walk",
	hidden = true,
	color = 4,
	description = "Spawns corpses around you while you move.",
	skillTypes = { [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"cast_on_gain_skill",
		"spell_uncastable_if_triggerable",
		"no_cost",
	},
	levels = {
		[20] = { levelRequirement = 60, statInterpolation = { }, cost = { }, },
	},
}
skills["SupportUniqueCosprisMaliceColdSpellsCastOnMeleeCriticalStrike"] = {
	name = "Cospri's Malice",
	hidden = true,
	color = 4,
	support = true,
	requireSkillTypes = { SkillType.Spell, SkillType.Cold, SkillType.Triggerable, SkillType.AND, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.Trapped, SkillType.RemoteMined, SkillType.SummonsTotem, SkillType.Aura, SkillType.InbuiltTrigger, },
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"unique_cospris_malice_cold_spells_triggered",
		"socketed_triggered_skills_use_weapon_attack_time_for_pvp_scaling",
	},
	levels = {
		[1] = { cooldown = 0.25, levelRequirement = 1, statInterpolation = { }, cost = { }, },
	},
}
skills["TriggeredSummonLesserShrine"] = {
	name = "Create Lesser Shrine",
	hidden = true,
	color = 4,
	description = "Creates a Lesser Shrine, which will grant a bonus when touched. The Lesser Shrine will disappear after a short duration, or when used. This skill starts on cooldown.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Duration] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"chance_to_cast_on_kill_%",
		"base_skill_effect_duration",
		"spell_uncastable_if_triggerable",
	},
	levels = {
		[1] = { 100, 10000, cooldown = 20, levelRequirement = 1, statInterpolation = { 1, 1, }, cost = { }, },
	},
}
skills["ChaosDegenAuraUnique"] = {
	name = "Death Aura",
	hidden = true,
	color = 4,
	description = "Casts an aura that deals Chaos Damage over Time to nearby Enemies. This skill cannot be cast by Totems.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.DamageOverTime] = true, [SkillType.Aura] = true, [SkillType.AuraAffectsEnemies] = true, [SkillType.Chaos] = true, [SkillType.AreaSpell] = true, [SkillType.HasReservation] = true, [SkillType.CanHaveBlessing] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("dotIsArea", true),
		skill("radius", 30),
	},
	qualityStats = {
	},
	stats = {
		"base_chaos_damage_to_deal_per_minute",
		"cast_on_gain_skill",
		"spell_uncastable_if_triggerable",
		"no_cost",
	},
	levels = {
		[1] = { 45500, levelRequirement = 62, statInterpolation = { 1, }, cost = { }, },
		[20] = { 45500, levelRequirement = 62, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["DeathWalk"] = {
	name = "Death Walk",
	hidden = true,
	color = 4,
	description = "While you walk, this skill causes corpses near your steps to explode, dealing fire damage in an area. The explosions of the corpses are not affected by modifiers to spell damage, and cannot be reflected.",
	skillTypes = { [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Fire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		cast = true,
		area = true,
	},
	baseMods = {
		skill("explodeCorpse", true),
		skill("showAverage", true),
	},
	qualityStats = {
	},
	stats = {
		"corpse_explosion_monster_life_%",
		"cast_on_gain_skill",
		"cannot_knockback",
		"spell_uncastable_if_triggerable",
		"is_area_damage",
		"skill_can_add_multiple_charges_per_action",
		"damage_cannot_be_reflected",
		"no_cost",
	},
	levels = {
		[20] = { 5, levelRequirement = 60, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["DeathWish"] = {
	name = "Death Wish",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.1530001163483,
	incrementalEffectiveness = 0.032299999147654,
	description = "As you channel this spell, it spreads its effect to more of your minions. When you stop channelling, each affected minion explodes, and this skill deals spell damage around them.  The explosion of the minion is not affected by modifiers to spell damage, and cannot be reflected.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Channel] = true, [SkillType.AreaSpell] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Minion] = true, [SkillType.Fire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.2,
	fromItem = true,
	parts = {
		{
			name = "Channelling",
			spell = true,
			cast = false,
		},
		{
			name = "Minion Explosion",
			spell = false,
			cast = true,
			stages = true,
		},
	},
	preDamageFunc = function(activeSkill, output)
		if activeSkill.skillPart == 2 then
			local skillData = activeSkill.skillData
			skillData.FireBonusMin = output.Life * skillData.selfFireExplosionLifeMultiplier
			skillData.FireBonusMax = output.Life * skillData.selfFireExplosionLifeMultiplier
		end
	end,
	statMap = {
		["spell_minimum_base_fire_damage"] = {
			skill("FireMin", nil, { type = "SkillPart", skillPart = 2 }),
		},
		["spell_maximum_base_fire_damage"] = {
			skill("FireMax", nil, { type = "SkillPart", skillPart = 2 }),
		},
		["death_wish_attack_speed_+%"] = {
			mod("Speed", "INC", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["death_wish_cast_speed_+%"] = {
			mod("Speed", "INC", nil, ModFlag.Cast, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["death_wish_movement_speed_+%"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		},
		["death_wish_hit_and_ailment_damage_+%_final_per_stage"] = {
			mod("Damage", "MORE", nil, 0, bit.bor(KeywordFlag.Hit, KeywordFlag.Ailment), { type = "Multiplier", var = "DeathWishStage" }, { type = "SkillPart", skillPart = 2 }),
		},
		["death_wish_max_stages"] = {
			mod("Multiplier:DeathWishMaxStages", "BASE", nil, 0, 0, { type = "SkillPart", skillPart = 2 }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("explodeCorpse", true, { type = "SkillPart", skillPart = 2 }),
		skill("radius", 10, { type = "SkillPart", skillPart = 2 }),
		skill("buffMinions", true),
		skill("buffNotPlayer", true),
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"skill_minion_explosion_life_%",
		"death_wish_hit_and_ailment_damage_+%_final_per_stage",
		"death_wish_attack_speed_+%",
		"death_wish_cast_speed_+%",
		"death_wish_movement_speed_+%",
		"death_wish_max_stages",
		"is_area_damage",
	},
	levels = {
		[20] = { 0.80000001192093, 1.2000000476837, 19, 10, 40, 40, 40, 13, critChance = 6, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 7, }, },
	},
}
skills["Melee"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
	},
	levels = {
		[1] = { 1, 1, levelRequirement = 1, statInterpolation = { 1, 1, }, cost = { }, },
	},
}
skills["MeleeUseContactPoint"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"use_scaled_contact_offset",
		"projectile_uses_contact_position",
	},
	levels = {
		[1] = { levelRequirement = 1, statInterpolation = { }, cost = { }, },
	},
}
skills["GemDetonateMines"] = {
	name = "Detonate Mines",
	color = 4,
	description = "Detonates a Mine, starting a Detonation Sequence which will detonate other Mines around it.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Triggerable] = true, [SkillType.Instant] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	baseFlags = {
		spell = true,
	},
	baseMods = {
	},
	qualityStats = {
		Default = {
			{ "mine_detonation_speed_+%", 1 },
		},
		Alternate1 = {
			{ "detonate_mines_recover_permyriad_of_life_per_mine_detonated", 1 },
		},
	},
	stats = {
		"display_mine_deontation_mechanics_detonation_speed_+%_final_per_sequence_mine",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 10, cooldown = 0.2, levelRequirement = 8, statInterpolation = { 1, }, cost = { }, },
		[2] = { 10, cooldown = 0.2, levelRequirement = 8, statInterpolation = { 1, }, cost = { }, },
		[3] = { 10, cooldown = 0.2, levelRequirement = 8, statInterpolation = { 1, }, cost = { }, },
		[4] = { 10, cooldown = 0.2, levelRequirement = 8, statInterpolation = { 1, }, cost = { }, },
		[5] = { 10, cooldown = 0.2, levelRequirement = 8, statInterpolation = { 1, }, cost = { }, },
		[6] = { 10, cooldown = 0.2, levelRequirement = 8, statInterpolation = { 1, }, cost = { }, },
		[7] = { 10, cooldown = 0.2, levelRequirement = 8, statInterpolation = { 1, }, cost = { }, },
		[8] = { 10, cooldown = 0.2, levelRequirement = 8, statInterpolation = { 1, }, cost = { }, },
		[9] = { 10, cooldown = 0.2, levelRequirement = 8, statInterpolation = { 1, }, cost = { }, },
		[10] = { 10, cooldown = 0.2, levelRequirement = 8, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["TouchOfGod"] = {
	name = "Doryani's Touch",
	hidden = true,
	color = 1,
	description = "The character uses their fist to slam the ground in front of them, with less attack speed, but more damage. This attack deals Lightning Damage to enemies in a large area, with a chance to Shock them. Cannot be used while wielding a Weapon. Cannot be Evaded.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Lightning] = true, [SkillType.Melee] = true, [SkillType.Multistrikeable] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		attack = true,
		area = true,
		melee = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_lightning",
		"active_skill_attack_speed_+%_final",
		"base_chance_to_shock_%",
		"is_area_damage",
		"global_always_hit",
	},
	levels = {
		[1] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 28, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[2] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 31, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[3] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 34, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[4] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 37, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[5] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 40, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[6] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 42, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[7] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 44, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[8] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 46, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[9] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 48, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[10] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 50, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[11] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 52, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[12] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 54, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[13] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 56, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[14] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 58, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[15] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 60, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[16] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 62, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[17] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 64, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[18] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 66, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[19] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 68, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[20] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 70, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[21] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 72, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[22] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 74, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[23] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 76, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[24] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 78, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[25] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 80, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[26] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 82, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[27] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 84, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[28] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 86, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[29] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 88, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[30] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 90, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[31] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 91, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[32] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 92, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[33] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 93, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[34] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 94, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[35] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 95, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[36] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 96, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[37] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 97, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[38] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 98, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[39] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 99, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
		[40] = { 100, -30, 40, damageEffectiveness = 6, levelRequirement = 100, statInterpolation = { 1, 1, 1, }, cost = { Mana = 8, }, },
	},
}
skills["ElementalAegis"] = {
	name = "Elemental Aegis",
	hidden = true,
	color = 4,
	description = "Calls forth a protective aegis which takes elemental damage from hits for you until depleted. The aegis will be restored to its full value after a short delay if you stop taking elemental damage from hits, or if depleted.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Aegis] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"aegis_unique_shield_max_value",
		"active_skill_display_aegis_variation",
		"aegis_recharge_delay_ms",
		"cast_on_gain_skill",
		"spell_uncastable_if_triggerable",
		"no_cost",
	},
	levels = {
		[1] = { 50, 2, 10000, levelRequirement = 1, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[20] = { 1000, 2, 10000, levelRequirement = 1, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["SupportElementalPenetration"] = {
	name = "Elemental Penetration",
	description = "Supports any skill that hits enemies, making those hits penetrate enemy elemental resistances.",
	color = 3,
	support = true,
	requireSkillTypes = { SkillType.Damage, SkillType.Attack, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	baseMods = {
	},
	qualityStats = {
		Default = {
			{ "elemental_damage_+%", 0.5 },
		},
		Alternate1 = {
			{ "non_damaging_ailment_effect_+%", 0.5 },
		},
	},
	stats = {
		"reduce_enemy_elemental_resistance_%",
	},
	levels = {
		[1] = { 14, manaMultiplier = 30, levelRequirement = 31, statInterpolation = { 1, }, cost = { }, },
		[2] = { 14, manaMultiplier = 30, levelRequirement = 34, statInterpolation = { 1, }, cost = { }, },
		[3] = { 15, manaMultiplier = 30, levelRequirement = 36, statInterpolation = { 1, }, cost = { }, },
		[4] = { 16, manaMultiplier = 30, levelRequirement = 38, statInterpolation = { 1, }, cost = { }, },
		[5] = { 17, manaMultiplier = 30, levelRequirement = 40, statInterpolation = { 1, }, cost = { }, },
		[6] = { 17, manaMultiplier = 30, levelRequirement = 42, statInterpolation = { 1, }, cost = { }, },
		[7] = { 18, manaMultiplier = 30, levelRequirement = 44, statInterpolation = { 1, }, cost = { }, },
		[8] = { 19, manaMultiplier = 30, levelRequirement = 46, statInterpolation = { 1, }, cost = { }, },
		[9] = { 20, manaMultiplier = 30, levelRequirement = 48, statInterpolation = { 1, }, cost = { }, },
		[10] = { 20, manaMultiplier = 30, levelRequirement = 50, statInterpolation = { 1, }, cost = { }, },
		[11] = { 21, manaMultiplier = 30, levelRequirement = 52, statInterpolation = { 1, }, cost = { }, },
		[12] = { 22, manaMultiplier = 30, levelRequirement = 54, statInterpolation = { 1, }, cost = { }, },
		[13] = { 23, manaMultiplier = 30, levelRequirement = 56, statInterpolation = { 1, }, cost = { }, },
		[14] = { 23, manaMultiplier = 30, levelRequirement = 58, statInterpolation = { 1, }, cost = { }, },
		[15] = { 24, manaMultiplier = 30, levelRequirement = 60, statInterpolation = { 1, }, cost = { }, },
		[16] = { 25, manaMultiplier = 30, levelRequirement = 62, statInterpolation = { 1, }, cost = { }, },
		[17] = { 26, manaMultiplier = 30, levelRequirement = 64, statInterpolation = { 1, }, cost = { }, },
		[18] = { 26, manaMultiplier = 30, levelRequirement = 66, statInterpolation = { 1, }, cost = { }, },
		[19] = { 27, manaMultiplier = 30, levelRequirement = 68, statInterpolation = { 1, }, cost = { }, },
		[20] = { 28, manaMultiplier = 30, levelRequirement = 70, statInterpolation = { 1, }, cost = { }, },
		[21] = { 29, manaMultiplier = 30, levelRequirement = 72, statInterpolation = { 1, }, cost = { }, },
		[22] = { 29, manaMultiplier = 30, levelRequirement = 74, statInterpolation = { 1, }, cost = { }, },
		[23] = { 30, manaMultiplier = 30, levelRequirement = 76, statInterpolation = { 1, }, cost = { }, },
		[24] = { 31, manaMultiplier = 30, levelRequirement = 78, statInterpolation = { 1, }, cost = { }, },
		[25] = { 32, manaMultiplier = 30, levelRequirement = 80, statInterpolation = { 1, }, cost = { }, },
		[26] = { 32, manaMultiplier = 30, levelRequirement = 82, statInterpolation = { 1, }, cost = { }, },
		[27] = { 33, manaMultiplier = 30, levelRequirement = 84, statInterpolation = { 1, }, cost = { }, },
		[28] = { 34, manaMultiplier = 30, levelRequirement = 86, statInterpolation = { 1, }, cost = { }, },
		[29] = { 35, manaMultiplier = 30, levelRequirement = 88, statInterpolation = { 1, }, cost = { }, },
		[30] = { 35, manaMultiplier = 30, levelRequirement = 90, statInterpolation = { 1, }, cost = { }, },
		[31] = { 36, manaMultiplier = 30, levelRequirement = 91, statInterpolation = { 1, }, cost = { }, },
		[32] = { 36, manaMultiplier = 30, levelRequirement = 92, statInterpolation = { 1, }, cost = { }, },
		[33] = { 36, manaMultiplier = 30, levelRequirement = 93, statInterpolation = { 1, }, cost = { }, },
		[34] = { 37, manaMultiplier = 30, levelRequirement = 94, statInterpolation = { 1, }, cost = { }, },
		[35] = { 37, manaMultiplier = 30, levelRequirement = 95, statInterpolation = { 1, }, cost = { }, },
		[36] = { 38, manaMultiplier = 30, levelRequirement = 96, statInterpolation = { 1, }, cost = { }, },
		[37] = { 38, manaMultiplier = 30, levelRequirement = 97, statInterpolation = { 1, }, cost = { }, },
		[38] = { 38, manaMultiplier = 30, levelRequirement = 98, statInterpolation = { 1, }, cost = { }, },
		[39] = { 39, manaMultiplier = 30, levelRequirement = 99, statInterpolation = { 1, }, cost = { }, },
		[40] = { 39, manaMultiplier = 30, levelRequirement = 100, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["OnHitWhileCursedTriggeredCurseNova"] = {
	name = "Elemental Warding",
	hidden = true,
	color = 4,
	baseEffectiveness = 3,
	incrementalEffectiveness = 0.050000000745058,
	description = "Fires projectiles in all directions, converting all their physical damage to a random element, and grants a buff which makes you unaffected by curses for a duration. Removes curses on you when used.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Fire] = true, [SkillType.Cold] = true, [SkillType.Lightning] = true, [SkillType.Duration] = true, [SkillType.Buff] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	parts = {
		{
			name = "Convert to fire",
		},
		{
			name = "Convert to cold",
		},
		{
			name = "Convert to lightning",
		},
	},
	baseFlags = {
		spell = true,
		projectile = true,
		duration = true,
	},
	baseMods = {
		mod("SkillPhysicalDamageConvertToFire", "BASE", 100, 0, 0, { type = "SkillPart", skillPart = 1 }),
		mod("SkillPhysicalDamageConvertToCold", "BASE", 100, 0, 0, { type = "SkillPart", skillPart = 2 }),
		mod("SkillPhysicalDamageConvertToLightning", "BASE", 100, 0, 0, { type = "SkillPart", skillPart = 3 }),
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"number_of_additional_projectiles",
		"elemental_strike_physical_damage_%_to_convert",
		"cast_on_melee_hit_if_cursed_%",
		"base_skill_effect_duration",
		"base_is_projectile",
		"projectiles_nova",
		"spell_uncastable_if_triggerable",
		"disable_visual_hit_effect",
	},
	levels = {
		[20] = { 0.80000001192093, 1.2000000476837, 16, 100, 100, 3000, critChance = 7, cooldown = 1, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["EmbraceMadness"] = {
	name = "Embrace Madness",
	hidden = true,
	color = 4,
	description = "Grants Glorious Madness. Using this skill again will remove Glorious Madness and the Touched Debuffs it inflicts, but you will be unable to Embrace Madness again until the cooldown expires.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Instant] = true, [SkillType.Cooldown] = true, [SkillType.HasReservation] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"embrace_madness_amount_of_cooldown_to_gain_ms",
		"glorious_madness_timer_ms",
	},
	levels = {
		[1] = { 8000, 1000, cooldown = 1, levelRequirement = 1, statInterpolation = { 1, 1, }, cost = { }, },
	},
}
skills["Envy"] = {
	name = "Envy",
	hidden = true,
	color = 3,
	baseEffectiveness = 2.0999999046326,
	incrementalEffectiveness = 0.023000000044703,
	description = "Casts an aura that adds chaos damage to the attacks and spells of you and your allies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.HasReservation] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Totemable] = true, [SkillType.Aura] = true, [SkillType.Chaos] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, [SkillType.CanHaveBlessing] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	fromItem = true,
	statMap = {
		["attack_minimum_added_chaos_damage"] = {
			mod("ChaosMin", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["attack_maximum_added_chaos_damage"] = {
			mod("ChaosMax", "BASE", nil, 0, KeywordFlag.Attack, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["spell_minimum_added_chaos_damage"] = {
			mod("ChaosMin", "BASE", nil, 0, KeywordFlag.Spell, { type = "GlobalEffect", effectType = "Aura" }),
		},
		["spell_maximum_added_chaos_damage"] = {
			mod("ChaosMax", "BASE", nil, 0, KeywordFlag.Spell, { type = "GlobalEffect", effectType = "Aura" }),
		},
	},
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	qualityStats = {
	},
	stats = {
		"attack_minimum_added_chaos_damage",
		"attack_maximum_added_chaos_damage",
		"active_skill_base_radius_+",
		"spell_minimum_added_chaos_damage",
		"spell_maximum_added_chaos_damage",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 0.5, 0.69999998807907, 14, 0.44999998807907, 0.60000002384186, manaReservationPercent = 50, cooldown = 1.2, levelRequirement = 60, statInterpolation = { 3, 3, 1, 3, 3, }, cost = { }, },
		[15] = { 0.5, 0.69999998807907, 14, 0.44999998807907, 0.60000002384186, manaReservationPercent = 50, cooldown = 1.2, levelRequirement = 60, statInterpolation = { 3, 3, 1, 3, 3, }, cost = { }, },
		[25] = { 0.5, 0.69999998807907, 24, 0.44999998807907, 0.60000002384186, manaReservationPercent = 50, cooldown = 1.2, levelRequirement = 80, statInterpolation = { 3, 3, 1, 3, 3, }, cost = { }, },
	},
}
skills["FireAegis"] = {
	name = "Fire Aegis",
	hidden = true,
	color = 4,
	description = "Calls forth a protective aegis which takes fire damage from hits for you until depleted. The aegis will be restored to its full value after a short delay if you stop taking fire damage from hits, or if depleted.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Aegis] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"aegis_unique_shield_max_value",
		"active_skill_display_aegis_variation",
		"aegis_recharge_delay_ms",
		"cast_on_gain_skill",
		"spell_uncastable_if_triggerable",
		"no_cost",
	},
	levels = {
		[20] = { 1000, 0, 10000, levelRequirement = 1, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["FireBurstOnHit"] = {
	name = "Fire Burst",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.5199999809265,
	incrementalEffectiveness = 0.043999999761581,
	description = "A burst of flame errupts from the location of a hit, dealing fire damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Fire] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("radius", 24),
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"cast_on_hit_%",
		"is_area_damage",
		"spell_uncastable_if_triggerable",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 1, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[2] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 2, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[3] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 4, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[4] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 7, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[5] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 11, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[6] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 16, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[7] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 20, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[8] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 24, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[9] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 28, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[10] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 32, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[11] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 36, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[12] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 40, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[13] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 44, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[14] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 48, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[15] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 52, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[16] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 56, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[17] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 60, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[18] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 64, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[19] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 67, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[20] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 70, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[21] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 72, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[22] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 74, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[23] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 76, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[24] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 78, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[25] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 80, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[26] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 82, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[27] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 84, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[28] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 86, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[29] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 88, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[30] = { 0.80000001192093, 1.2000000476837, 100, damageEffectiveness = 2.5, cooldown = 1.5, critChance = 6, levelRequirement = 90, statInterpolation = { 3, 3, 1, }, cost = { }, },
	},
}
skills["AtziriUniqueStaffFlameblast"] = {
	name = "Flames of Judgement",
	hidden = true,
	color = 3,
	baseEffectiveness = 4.0500001907349,
	incrementalEffectiveness = 0.055500000715256,
	description = "Creates markers at your location and a targeted location, which grow over time based on cast speed, then explode, dealing fire damage. Cannot be supported by Spell Cascade.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Duration] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Fire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	fromItem = true,
	baseFlags = {
		area = true,
	},
	baseMods = {
		skill("triggerSource", "Queen's Demand"),
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_chance_to_ignite_%",
		"base_reduce_enemy_fire_resistance_%",
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"skill_has_trigger_from_unique_item",
	},
	levels = {
		[20] = { 0.80000001192093, 1.2000000476837, 50, 25, critChance = 6, duration = 2, cooldown = 1.5, damageEffectiveness = 8.5, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, }, cost = { }, },
	},
}
skills["Focus"] = {
	name = "Focus",
	hidden = true,
	color = 2,
	description = "Focus your power, granting yourself the Focused buff.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Spell] = true, [SkillType.Instant] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	cannotBeSupported = true,
	baseFlags = {
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"base_skill_is_instant",
		"fixed_skill_effect_duration",
		"display_skill_fixed_duration_buff",
		"display_this_skill_cooldown_does_not_recover_during_buff",
	},
	levels = {
		[1] = { 4000, cooldown = 8, levelRequirement = 1, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["SupportTriggerSpellFromHelmet"] = {
	name = "Focus",
	hidden = true,
	color = 4,
	support = true,
	requireSkillTypes = { SkillType.Spell, SkillType.Triggerable, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.Trapped, SkillType.RemoteMined, SkillType.SummonsTotem, SkillType.Aura, SkillType.InbuiltTrigger, },
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_triggered_when_you_focus_chance_%",
	},
	levels = {
		[1] = { 100, cooldown = 0.25, levelRequirement = 1, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["CreateSmokeCloud"] = {
	name = "Fog of War",
	hidden = true,
	color = 4,
	description = "Creates a Smoke Cloud in an area, which blinds enemies within it.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Area] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, [SkillType.Cooldown] = true, [SkillType.Triggered] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		spell = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"chance_to_cast_when_your_trap_is_triggered_%",
	},
	levels = {
		[20] = { 3000, 100, cooldown = 1, levelRequirement = 65, statInterpolation = { 1, 1, }, cost = { }, },
	},
}
skills["VaalAuraElementalDamageHealing"] = {
	name = "Gluttony of Elements",
	hidden = true,
	color = 4,
	description = "Casts an aura that causes taking elemental damage to heal you and nearby allies instead.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.Vaal] = true, [SkillType.Aura] = true, [SkillType.AreaSpell] = true, [SkillType.Instant] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "aura_skill_stat_descriptions",
	castTime = 0,
	fromItem = true,
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 40),
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"base_elemental_damage_heals",
		"cannot_gain_souls",
		"modifiers_to_buff_effect_duration_also_affect_soul_prevention_duration",
		"immune_to_curses",
	},
	levels = {
		[1] = { 5000, cooldown = 0.5, levelRequirement = 1, statInterpolation = { 1, }, cost = { }, },
		[20] = { 5000, cooldown = 0.5, levelRequirement = 1, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["GoreShockwave"] = {
	name = "Gore Shockwave",
	hidden = true,
	color = 1,
	description = "Deals attack damage in an area.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.Melee] = true, },
	weaponTypes = {
		["Two Handed Axe"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	preDamageFunc = function(activeSkill, output)
		activeSkill.skillData.timeOverride = output.Cooldown
	end,
	baseFlags = {
		attack = true,
		area = true,
		melee = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"active_skill_base_radius_+",
		"base_cooldown_speed_+%",
		"attack_trigger_on_melee_hit_with_atleast_150_strength_%",
		"is_area_damage",
	},
	levels = {
		[1] = { 1, 0, 100, damageEffectiveness = 1.6, cooldown = 1, baseMultiplier = 1.6, levelRequirement = 1, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[5] = { 2, 8, 100, damageEffectiveness = 1.81, cooldown = 1, baseMultiplier = 1.81, levelRequirement = 1, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["SupportGreaterSpellEcho"] = {
	name = "Greater Spell Echo",
	hidden = true,
	color = 3,
	support = true,
	requireSkillTypes = { SkillType.Multicastable, },
	addSkillTypes = { },
	excludeSkillTypes = { SkillType.SummonsTotem, SkillType.Trapped, SkillType.RemoteMined, SkillType.Triggered, SkillType.HasReservation, SkillType.Vaal, SkillType.Instant, SkillType.NonRepeatable, SkillType.CreatesMinion, SkillType.NOT, SkillType.AND, },
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	statMap = {
		["support_greater_spell_echo_area_of_effect_+%_per_repeat"] = {
			mod("AreaOfEffect", "INC", nil),
		},
	},
	baseMods = {
		flag("Condition:HaveGreaterSpellEcho"),
		mod("Damage", "MORE", 30, ModFlag.Spell, 0, { type = "Condition", var = "HaveSpellEcho", neg = true }, { type = "Condition", var = "HaveBladeVortex", neg = true }),
		mod("Damage", "MORE", 45, ModFlag.Spell, 0, { type = "Condition", var = "HaveSpellEcho" }, { type = "Condition", var = "HaveBladeVortex", neg = true }),
	},
	qualityStats = {
	},
	stats = {
		"base_spell_repeat_count",
		"support_greater_spell_echo_spell_damage_+%_final_per_repeat",
		"support_greater_spell_echo_area_of_effect_+%_per_repeat",
	},
	levels = {
		[30] = { 2, 30, 50, manaMultiplier = 50, levelRequirement = 90, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["IcestormUniqueStaff12"] = {
	name = "Icestorm",
	hidden = true,
	color = 3,
	baseEffectiveness = 0,
	description = "Icy bolts rain down over the targeted area. They explode when landing, dealing damage to nearby enemies and chilling them, as well as causing patches of chilled ground. Skill damage is based on Intelligence.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cold] = true, [SkillType.Cascadable] = true, [SkillType.ChillingArea] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.75,
	fromItem = true,
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("duration", 0.1, { type = "PerStat", stat = "Int", div = 100, base = 1 }),
		skill("radius", 22),
		skill("radiusSecondary", 16),
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_cold_damage_+_per_10_intelligence",
		"spell_maximum_base_cold_damage_+_per_10_intelligence",
		"base_skill_effect_duration",
		"fire_storm_fireball_delay_ms",
		"skill_override_pvp_scaling_time_ms",
		"firestorm_drop_ground_ice_duration_ms",
		"skill_effect_duration_per_100_int",
		"firestorm_max_number_of_storms",
		"base_skill_show_average_damage_instead_of_dps",
		"is_area_damage",
		"skill_is_ice_storm",
	},
	levels = {
		[1] = { 5, 7, 1000, 200, 450, 500, 100, 5, critChance = 6, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, 1, }, cost = { Mana = 22, }, },
	},
}
skills["TriggeredIcicleNova"] = {
	name = "Icicle Burst",
	hidden = true,
	color = 4,
	description = "This attack fires icy projectiles in a circle around enemies you kill, dealing attack damage with all physical damage converted to cold.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Cold] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	qualityStats = {
	},
	stats = {
		"number_of_additional_projectiles",
		"trigger_on_hit_vs_frozen_enemy_%",
		"monster_projectile_variation",
		"skill_physical_damage_%_to_convert_to_cold",
		"projectiles_nova",
		"spell_uncastable_if_triggerable",
		"base_is_projectile",
		"never_freeze",
	},
	levels = {
		[20] = { 8, 100, 38, 100, cooldown = 0.5, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["MerveilWarp"] = {
	name = "Illusory Warp",
	hidden = true,
	color = 4,
	description = "Teleport to a target destination. Chilled ground is spread in an area around both where the caster was and where they teleported to.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Movement] = true, [SkillType.Duration] = true, [SkillType.Cold] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.6,
	fromItem = true,
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
	},
	levels = {
		[20] = { 1500, cooldown = 3, levelRequirement = 1, statInterpolation = { 1, }, cost = { Mana = 20, }, },
	},
}
skills["CatsStealthTriggeredIntimidatingCry"] = {
	name = "Intimidating Cry",
	hidden = true,
	color = 1,
	description = "Performs a warcry, taunting nearby enemies to attack the user and exerting subsequent attacks. Grants a buff which lowers the effect of enemy physical damage reduction against your hits.",
	skillTypes = { [SkillType.Area] = true, [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Warcry] = true, [SkillType.Cooldown] = true, [SkillType.Physical] = true, [SkillType.Triggered] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.25,
	fromItem = true,
	statMap = {
		["skill_empowers_next_x_melee_attacks"] = {
			mod("IntimidatingExertedAttacks", "BASE", nil),
		},
		["intimidating_cry_enemy_phys_reduction_%_penalty_vs_hit_per_5_MP"] = {
			mod("IntimidatingPDRPer5MP", "BASE", nil),
		},
	},
	baseFlags = {
		warcry = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 60),
	},
	qualityStats = {
	},
	stats = {
		"intimidating_cry_enemy_phys_reduction_%_penalty_vs_hit_per_5_MP",
		"skill_empowers_next_x_melee_attacks",
		"warcry_speed_+%",
		"empowered_attack_accuracy_rating_+%",
		"base_deal_no_damage",
		"cannot_cancel_skill_before_contact_point",
		"warcry_count_power_from_enemies",
		"cast_on_lose_cats_stealth",
		"intimidating_cry_empowerd_attacks_deal_double_damage_display",
		"enemies_taunted_by_your_warcies_are_intimidated",
		"use_intimidating_cry_buff_visual_for_intimidate",
	},
	levels = {
		[20] = { 5, 2, 38, 0, levelRequirement = 70, duration = 4.9, cooldown = 8, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 19, }, },
	},
}
skills["SupportCastOnManaSpent"] = {
	name = "Kitava's Thirst",
	hidden = true,
	color = 3,
	support = true,
	requireSkillTypes = { SkillType.Spell, SkillType.Triggerable, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.Trapped, SkillType.RemoteMined, SkillType.SummonsTotem, SkillType.Aura, SkillType.InbuiltTrigger, },
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"support_cast_on_mana_spent",
	},
	levels = {
		[1] = { cooldown = 0.1, levelRequirement = 1, statInterpolation = { }, cost = { }, },
	},
}
skills["LightningAegis"] = {
	name = "Lightning Aegis",
	hidden = true,
	color = 4,
	description = "Calls forth a protective aegis which takes lightning damage from hits for you until depleted. The aegis will be restored to its full value after a short delay if you stop taking lightning damage from hits, or if depleted.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Aegis] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"aegis_unique_shield_max_value",
		"active_skill_display_aegis_variation",
		"aegis_recharge_delay_ms",
		"cast_on_gain_skill",
		"spell_uncastable_if_triggerable",
		"no_cost",
	},
	levels = {
		[20] = { 1000, 3, 10000, levelRequirement = 1, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["LightningSpell"] = {
	name = "Lightning Bolt",
	hidden = true,
	color = 3,
	baseEffectiveness = 5,
	incrementalEffectiveness = 0.029999999329448,
	description = "A bolt of lightning strikes an area, dealing lightning damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggered] = true, [SkillType.Lightning] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.InbuiltTrigger] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	preDamageFunc = function(activeSkill, output)
		activeSkill.skillData.hitTimeOverride = output.Cooldown
	end,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"cast_on_crit_%",
		"is_area_damage",
		"spell_uncastable_if_triggerable",
	},
	levels = {
		[1] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 1, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[2] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 2, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[3] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 4, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[4] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 7, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[5] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 11, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[6] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 16, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[7] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 20, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[8] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 24, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[9] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 28, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[10] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 32, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[11] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 36, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[12] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 40, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[13] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 44, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[14] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 48, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[15] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 52, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[16] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 56, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[17] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 60, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[18] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 64, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[19] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 67, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[20] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 70, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[21] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 72, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[22] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 74, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[23] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 76, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[24] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 78, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[25] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 80, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[26] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 82, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[27] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 84, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[28] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 86, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[29] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 88, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[30] = { 0.5, 1.5, 100, damageEffectiveness = 2, cooldown = 0.2, critChance = 7.5, levelRequirement = 90, statInterpolation = { 3, 3, 1, }, cost = { }, },
	},
}
skills["SupportTriggerBowSkillOnBowAttack"] = {
	name = "Maloney's Mechanism",
	hidden = true,
	color = 4,
	support = true,
	requireSkillTypes = { SkillType.RangedAttack, SkillType.Triggerable, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.SummonsTotem, SkillType.Trapped, SkillType.RemoteMined, SkillType.Vaal, SkillType.InbuiltTrigger, },
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_has_trigger_from_unique_item",
	},
	levels = {
		[1] = { 1, cooldown = 1, levelRequirement = 1, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["UniqueAnimateWeapon"] = {
	name = "Manifest Dancing Dervishes",
	hidden = true,
	color = 4,
	description = "Manifests two Dancing Dervishes to fight by your side. While a Dancing Dervish is manifested, you have Onslaught and cannot use Weapons. Cannot be supported by supports that would create other minions.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Triggerable] = true, [SkillType.InbuiltTrigger] = true, [SkillType.MinionsPersistWhenSkillRemoved] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, [SkillType.Triggered] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Area] = true, [SkillType.Movement] = true, [SkillType.Multistrikeable] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	minionList = {
		"UniqueAnimatedWeapon",
	},
	minionUses = {
		["Weapon 1"] = true,
	},
	statMap = {
		["attack_damage_+%"] = {
			mod("MinionModifier", "LIST", { mod = mod("Damage", "INC", nil, ModFlag.Attack) }),
		},
		["attack_speed_+%"] = {
			mod("MinionModifier", "LIST", { mod = mod("Speed", "INC", nil, ModFlag.Attack) }),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
		mod("DisableWeapons", "FLAG", true, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		mod("Condition:Onslaught", "FLAG", true, 0, 0, { type = "GlobalEffect", effectType = "Buff" }),
		skill("minionLevel", 59),
	},
	qualityStats = {
	},
	stats = {
		"disable_weapons",
		"attack_speed_+%",
		"attack_damage_+%",
		"chance_to_cast_on_rampage_tier_%",
		"minion_movement_speed_+%",
		"minion_grants_rampage_kill_to_parent_on_hitting_unique_enemy_%",
	},
	levels = {
		[15] = { 1, 25, 110, 100, 30, 25, cooldown = 0.5, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["SupportUniqueMjolnerLightningSpellsCastOnHit"] = {
	name = "Mjolner",
	hidden = true,
	color = 4,
	support = true,
	requireSkillTypes = { SkillType.Spell, SkillType.Lightning, SkillType.Triggerable, SkillType.AND, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.Trapped, SkillType.RemoteMined, SkillType.SummonsTotem, SkillType.Aura, SkillType.InbuiltTrigger, },
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"unique_mjolner_lightning_spells_triggered",
		"socketed_triggered_skills_use_weapon_attack_time_for_pvp_scaling",
		"no_cost",
	},
	levels = {
		[1] = { cooldown = 0.25, levelRequirement = 0, manaMultiplier = -100, statInterpolation = { }, cost = { }, },
	},
}
skills["TriggeredMoltenStrike"] = {
	name = "Molten Burst",
	hidden = true,
	color = 1,
	description = "Launch molten projectiles from the point of impact, causing AoE attack damage to enemies where they land.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Fire] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.RangedAttack] = true, [SkillType.ProjectilesNotFromUser] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"number_of_additional_projectiles",
		"attack_trigger_on_melee_hit_%",
		"show_number_of_projectiles",
		"base_is_projectile",
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
	},
	levels = {
		[16] = { 3, 20, damageEffectiveness = 1.15, cooldown = 0.15, baseMultiplier = 1.15, levelRequirement = 1, statInterpolation = { 1, 1, }, cost = { }, },
	},
}
skills["PhysicalAegis"] = {
	name = "Physical Aegis",
	hidden = true,
	color = 4,
	description = "Calls forth a protective aegis which takes physical damage from hits for you until depleted. The aegis will be restored to its full value after a short delay if you stop taking physical damage from hits, or if depleted.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Aegis] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"aegis_unique_shield_max_value",
		"active_skill_display_aegis_variation",
		"aegis_recharge_delay_ms",
		"cast_on_gain_skill",
		"spell_uncastable_if_triggerable",
		"no_cost",
	},
	levels = {
		[20] = { 1000, 4, 10000, levelRequirement = 1, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["SupportTriggerSpellOnAttack"] = {
	name = "Poet's Pen",
	hidden = true,
	color = 4,
	support = true,
	requireSkillTypes = { SkillType.Spell, SkillType.Triggerable, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.Trapped, SkillType.RemoteMined, SkillType.SummonsTotem, SkillType.Aura, SkillType.InbuiltTrigger, },
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_has_trigger_from_unique_item",
		"socketed_triggered_skills_use_weapon_attack_time_for_pvp_scaling",
	},
	levels = {
		[1] = { 1, cooldown = 0.25, levelRequirement = 1, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["Portal"] = {
	name = "Portal",
	color = 4,
	baseEffectiveness = 0,
	description = "Creates a portal to the current area's town.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Triggerable] = true, [SkillType.TotemCastsAlone] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.5,
	baseFlags = {
		spell = true,
	},
	baseMods = {
	},
	qualityStats = {
		Default = {
			{ "base_cast_speed_+%", 3 },
		},
		Alternate1 = {
			{ "portal_alternate_destination_chance_permyriad", 1 },
		},
	},
	stats = {
		"base_deal_no_damage",
	},
	levels = {
		[1] = { levelRequirement = 10, statInterpolation = { }, cost = { }, },
		[2] = { levelRequirement = 10, statInterpolation = { }, cost = { }, },
		[3] = { levelRequirement = 10, statInterpolation = { }, cost = { }, },
		[4] = { levelRequirement = 10, statInterpolation = { }, cost = { }, },
		[5] = { levelRequirement = 10, statInterpolation = { }, cost = { }, },
		[6] = { levelRequirement = 10, statInterpolation = { }, cost = { }, },
		[7] = { levelRequirement = 10, statInterpolation = { }, cost = { }, },
		[8] = { levelRequirement = 10, statInterpolation = { }, cost = { }, },
		[9] = { levelRequirement = 10, statInterpolation = { }, cost = { }, },
		[10] = { levelRequirement = 10, statInterpolation = { }, cost = { }, },
	},
}
skills["QueensDemand"] = {
	name = "Queen's Demand",
	hidden = true,
	color = 4,
	description = "Alternates triggering Flames of Judgement and Storm of Judgement",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Multicastable] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"queens_demand_effect",
	},
	levels = {
		[20] = { levelRequirement = 70, statInterpolation = { }, cost = { Mana = 64, }, },
	},
}
skills["TriggeredSummonSpider"] = {
	name = "Raise Spiders",
	hidden = true,
	color = 3,
	description = "Raise two spectral spiders from each nearby corpse that will attack your enemies with Viper Strike. Each raised spider grants you increased Attack Speed and increased Damage with Poison. Enemies will not engage the spiders directly, and they are immune to damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.CreatesMinion] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	minionList = {
		"SpiderMinion",
	},
	statMap = {
		["summoned_spider_grants_attack_speed_+%"] = {
			mod("Speed", "INC", nil, ModFlag.Attack, 0, { type = "Multiplier", var = "RaisedSpider" }, { type = "GlobalEffect", effectType = "Buff", effectName = "Raised Spider" }),
		},
		["summoned_spider_grants_poison_damage_+%"] = {
			mod("Damage", "INC", nil, 0, KeywordFlag.Poison, { type = "Multiplier", var = "RaisedSpider" }, { type = "GlobalEffect", effectType = "Buff", effectName = "Raised Spider" }),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"chance_to_cast_on_kill_%_target_self",
		"base_skill_effect_duration",
		"number_of_spider_minions_allowed",
		"summoned_spider_grants_attack_speed_+%",
		"summoned_spider_grants_poison_damage_+%",
		"damage_+%_vs_players",
		"spell_uncastable_if_triggerable",
		"take_no_actions_while_parent_dead",
		"minion_dies_when_parent_dies",
		"minions_cannot_taunt_enemies",
	},
	levels = {
		[1] = { 100, 30000, 20, 2, 12, -85, cooldown = 2, levelRequirement = 75, statInterpolation = { 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["UniqueMirageWarriors"] = {
	name = "Reflection",
	hidden = true,
	color = 4,
	description = "When you attack with The Saviour and deal a critical strike, this skill can summon a Mirage Saviour. Summoned Mirage Saviours will fight for you using whichever of your attack skills you dealt the critical strike with that caused them to be summoned. Mirage Saviours will not be resummoned using the same skills if you already have the maximum number of them.",
	skillTypes = { [SkillType.Duration] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	fromItem = true,
	statMap = {
		["skill_used_by_mirage_warrior_damage_+%_final"] = {
			mod("SaviourMirageWarriorLessDamage", "BASE", nil),
		},
		["maximum_number_of_mirage_warriors"] = {
			mod("SaviourMirageWarriorMaxCount", "BASE", nil),
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
		minion = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"maximum_number_of_mirage_warriors",
		"skill_used_by_mirage_warrior_damage_+%_final",
		"cast_on_gain_skill",
		"spell_uncastable_if_triggerable",
		"display_mirage_warriors_no_spirit_strikes",
		"force_lite_skill_effects",
		"no_cost",
	},
	levels = {
		[20] = { 10000, 2, -50, levelRequirement = 1, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["ShadeForm"] = {
	name = "Shade Form",
	hidden = true,
	color = 4,
	description = "Makes you immune to physical damage, and harder for enemies to detect, for a duration.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Buff] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"stealth_+%",
		"trigger_on_skill_use_from_chest_%",
		"display_this_skill_cooldown_does_not_recover_during_buff",
	},
	levels = {
		[20] = { 3000, 100, 20, cooldown = 40, levelRequirement = 1, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["ShieldShatter"] = {
	name = "Shield Shatter",
	hidden = true,
	color = 1,
	baseEffectiveness = 0.34000000357628,
	incrementalEffectiveness = 0.045000001788139,
	description = "Your shield shatters, dealing physical spell damage to enemies in an area, based on the shield's quality. For a short duration after this, you will be unable to block and will gain no defences from your shield, but your spells will deal added physical damage.",
	skillTypes = { [SkillType.Damage] = true, [SkillType.Physical] = true, [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, [SkillType.Nova] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Duration] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	statMap = {
		["spell_minimum_base_physical_damage_per_shield_quality"] = {
			skill("PhysicalMin", nil, { type = "Multiplier", var = "QualityOnWeapon 2" }),
		},
		["spell_maximum_base_physical_damage_per_shield_quality"] = {
			skill("PhysicalMax", nil, { type = "Multiplier", var = "QualityOnWeapon 2" }),
		},
		["buff_added_spell_minimum_base_physical_damage_per_shield_quality"] = {
			mod("PhysicalMin", "BASE", nil, ModFlag.Spell, 0, { type = "Multiplier", var = "QualityOnWeapon 2" }, { type = "Condition", var = "BlockedRecently"}, { type = "GlobalEffect", effectType = "Buff"}),
		},
		["buff_added_spell_maximum_base_physical_damage_per_shield_quality"] = {
			mod("PhysicalMax", "BASE", nil, ModFlag.Spell, 0, { type = "Multiplier", var = "QualityOnWeapon 2" }, { type = "Condition", var = "BlockedRecently"}, { type = "GlobalEffect", effectType = "Buff"}),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	qualityStats = {
	},
	stats = {
		"trigger_on_block_%_chance",
		"spell_minimum_base_physical_damage_per_shield_quality",
		"spell_maximum_base_physical_damage_per_shield_quality",
		"buff_added_spell_minimum_base_physical_damage_per_shield_quality",
		"buff_added_spell_maximum_base_physical_damage_per_shield_quality",
	},
	levels = {
		[1] = { 100, 0.80000001192093, 1.2000000476837, 1, 2, duration = 4, levelRequirement = 4, statInterpolation = { 1, 3, 3, 1, 1, }, cost = { }, },
		[20] = { 100, 0.80000001192093, 1.2000000476837, 10, 16, duration = 4, levelRequirement = 70, statInterpolation = { 1, 3, 3, 1, 1, }, cost = { }, },
	},
}
skills["TriggeredShockedGround"] = {
	name = "Shock Ground",
	hidden = true,
	color = 4,
	description = "Creates a patch of Shocked Ground in a radius around you.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.Duration] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Lightning] = true, [SkillType.AreaSpell] = true, [SkillType.Nova] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
		mod("ShockedGroundEffect", "BASE", 15),
	},
	qualityStats = {
	},
	stats = {
		"cast_when_hit_%",
		"skill_art_variation",
		"base_skill_effect_duration",
		"spell_uncastable_if_triggerable",
	},
	levels = {
		[10] = { 100, 7, 5000, cooldown = 5, levelRequirement = 1, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["ChannelledSnipe"] = {
	name = "Snipe",
	hidden = true,
	color = 2,
	description = "Channel to charge up your bow, gaining stages. Release to trigger one linked bow skill for each stage gained. Channelled Skills cannot be triggered this way. If there are no skills linked, but at least one stage was gained, this skill will fire its own arrow instead. Cannot be used by Totems.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Channel] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	initialFunc = function(activeSkill, output)
		activeSkill.skillData.dpsMultiplier = 1 / math.max(activeSkill.skillModList:Sum("BASE", cfg, "Multiplier:SnipeStage"), 1)
	end,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"snipe_max_stacks",
		"override_turn_duration_ms",
		"snipe_triggered_skill_ailment_damage_+%_final_per_stage",
		"snipe_triggered_skill_hit_damage_+%_final_per_stage",
		"skill_can_fire_arrows",
		"is_snipe_default_projectile",
		"is_snipe_default_projectile_2",
	},
	levels = {
		[20] = { 6, 100, 120, 165, attackSpeedMultiplier = 80, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, }, cost = { Mana = 4, }, },
	},
}
skills["ChannelledSnipeSupport"] = {
	name = "ChannelledSnipeSupport",
	hidden = true,
	color = 2,
	support = true,
	requireSkillTypes = { SkillType.RangedAttack, SkillType.ThresholdJewelRangedAttack, SkillType.OR, SkillType.Triggerable, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.SummonsTotem, SkillType.Trapped, SkillType.RemoteMined, SkillType.HasReservation, SkillType.Vaal, SkillType.Instant, SkillType.Channel, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	baseMods = {
		flag("TriggeredBySnipe"),
	},
	qualityStats = {
	},
	stats = {
		"snipe_triggered_skill_damage_+%_final",
		"snipe_triggered_skill_ailment_damage_+%_final_per_stage",
		"snipe_triggered_skill_hit_damage_+%_final_per_stage",
		"skill_triggered_by_snipe",
	},
	levels = {
		[20] = { 0, 120, 165, cooldown = 0.05, levelRequirement = 0, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["SummonEssenceSpirits"] = {
	name = "Spectral Spirits",
	hidden = true,
	color = 3,
	description = "Summons three invulnerable spectral skulls that rush at nearby enemies and attack them rapidly. Enemies will not engage these spirits, and can pass through them.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.CreatesMinion] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	minionList = {
		"SummonedEssenceSpirit",
	},
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"active_skill_minion_added_damage_+%_final",
		"number_of_monsters_to_summon",
		"cast_on_gain_skill",
		"spell_uncastable_if_triggerable",
		"take_no_actions_while_parent_dead",
		"minion_dies_when_parent_dies",
		"minions_cannot_taunt_enemies",
		"no_cost",
	},
	levels = {
		[1] = { -15, 3, levelRequirement = 1, statInterpolation = { 1, 1, }, cost = { }, },
		[2] = { -15, 3, levelRequirement = 2, statInterpolation = { 1, 1, }, cost = { }, },
		[3] = { -15, 3, levelRequirement = 4, statInterpolation = { 1, 1, }, cost = { }, },
		[4] = { -15, 3, levelRequirement = 7, statInterpolation = { 1, 1, }, cost = { }, },
		[5] = { -15, 3, levelRequirement = 11, statInterpolation = { 1, 1, }, cost = { }, },
		[6] = { -15, 3, levelRequirement = 16, statInterpolation = { 1, 1, }, cost = { }, },
		[7] = { -15, 3, levelRequirement = 20, statInterpolation = { 1, 1, }, cost = { }, },
		[8] = { -15, 3, levelRequirement = 24, statInterpolation = { 1, 1, }, cost = { }, },
		[9] = { -15, 3, levelRequirement = 28, statInterpolation = { 1, 1, }, cost = { }, },
		[10] = { -15, 3, levelRequirement = 32, statInterpolation = { 1, 1, }, cost = { }, },
		[11] = { -15, 3, levelRequirement = 36, statInterpolation = { 1, 1, }, cost = { }, },
		[12] = { -15, 3, levelRequirement = 40, statInterpolation = { 1, 1, }, cost = { }, },
		[13] = { -15, 3, levelRequirement = 44, statInterpolation = { 1, 1, }, cost = { }, },
		[14] = { -15, 3, levelRequirement = 48, statInterpolation = { 1, 1, }, cost = { }, },
		[15] = { -15, 3, levelRequirement = 52, statInterpolation = { 1, 1, }, cost = { }, },
		[16] = { -15, 3, levelRequirement = 56, statInterpolation = { 1, 1, }, cost = { }, },
		[17] = { -15, 3, levelRequirement = 60, statInterpolation = { 1, 1, }, cost = { }, },
		[18] = { -15, 3, levelRequirement = 64, statInterpolation = { 1, 1, }, cost = { }, },
		[19] = { -15, 3, levelRequirement = 67, statInterpolation = { 1, 1, }, cost = { }, },
		[20] = { -15, 3, levelRequirement = 70, statInterpolation = { 1, 1, }, cost = { }, },
		[21] = { -15, 3, levelRequirement = 72, statInterpolation = { 1, 1, }, cost = { }, },
		[22] = { -15, 3, levelRequirement = 74, statInterpolation = { 1, 1, }, cost = { }, },
		[23] = { -15, 3, levelRequirement = 76, statInterpolation = { 1, 1, }, cost = { }, },
		[24] = { -15, 3, levelRequirement = 78, statInterpolation = { 1, 1, }, cost = { }, },
		[25] = { -15, 3, levelRequirement = 80, statInterpolation = { 1, 1, }, cost = { }, },
		[26] = { -15, 3, levelRequirement = 82, statInterpolation = { 1, 1, }, cost = { }, },
		[27] = { -15, 3, levelRequirement = 84, statInterpolation = { 1, 1, }, cost = { }, },
		[28] = { -15, 3, levelRequirement = 86, statInterpolation = { 1, 1, }, cost = { }, },
		[29] = { -15, 3, levelRequirement = 88, statInterpolation = { 1, 1, }, cost = { }, },
		[30] = { -15, 3, levelRequirement = 90, statInterpolation = { 1, 1, }, cost = { }, },
	},
}
skills["SpiritBurst"] = {
	name = "Spirit Burst",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.875,
	incrementalEffectiveness = 0.03999999910593,
	description = "Consumes a spirit charge to fire projectiles which deals physical damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	qualityStats = {
	},
	stats = {
		"trigger_on_skill_use_%_if_you_have_a_spirit_charge",
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"number_of_additional_projectiles",
		"spell_uncastable_if_triggerable",
		"base_is_projectile",
		"projectiles_nova",
	},
	levels = {
		[20] = { 100, 0.80000001192093, 1.2000000476837, 6, damageEffectiveness = 1.2, critChance = 6, levelRequirement = 70, statInterpolation = { 1, 3, 3, 1, }, cost = { }, },
	},
}
skills["VolatileDeadChaos"] = {
	name = "Stalking Pustule",
	hidden = true,
	color = 2,
	baseEffectiveness = 3,
	incrementalEffectiveness = 0.0337999984622,
	description = "A corpse near the targeted location explodes, dealing damage in a small area and creating an orb which moves towards nearby enemies before dealing spell damage in a larger area. The explosion of the corpse is not affected by modifiers to spell damage, and cannot be reflected.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Chaos] = true, [SkillType.Cascadable] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Cooldown] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Triggered] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	fromItem = true,
	statMap = {
		["volatile_dead_core_explosion_radius_+"] = {
			skill("radius", "BASE", nil),
		},
	},
	baseFlags = {
		spell = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_chaos_damage",
		"spell_maximum_base_chaos_damage",
		"volatile_dead_base_number_of_corpses_to_consume",
		"corpse_explosion_monster_life_%_chaos",
		"volatile_dead_core_explosion_radius_+",
		"volatile_dead_max_cores_allowed",
		"chance_to_cast_on_kill_%",
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"spell_uncastable_if_triggerable",
	},
	levels = {
		[15] = { 0.80000001192093, 1.2000000476837, 1, 9, 13, 10, 100, damageEffectiveness = 1.4, cooldown = 2, critChance = 5, levelRequirement = 59, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["StormCascadeTriggered"] = {
	name = "Storm Cascade",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.7555999755859,
	incrementalEffectiveness = 0.034600000828505,
	description = "Lightning crackles in a series of small bursts, each damaging enemies caught in the area.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.Physical] = true, [SkillType.InbuiltTrigger] = true, [SkillType.AreaSpell] = true, [SkillType.Cooldown] = true, [SkillType.Triggered] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	fromItem = true,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"upheaval_number_of_spikes",
		"skill_physical_damage_%_to_convert_to_lightning",
		"active_skill_base_radius_+",
		"cast_on_attack_use_%",
		"is_area_damage",
		"spell_uncastable_if_triggerable",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 28, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[2] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 31, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[3] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 34, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[4] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 37, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[5] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 40, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[6] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 42, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[7] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 44, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[8] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 46, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[9] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 48, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[10] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 50, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[11] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 52, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[12] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 54, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[13] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 56, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[14] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 58, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[15] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 60, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[16] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 62, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[17] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 64, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[18] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 66, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[19] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[20] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[21] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 72, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[22] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 74, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[23] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 76, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[24] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 78, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[25] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 80, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[26] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 82, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[27] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 84, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[28] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 86, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[29] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 88, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[30] = { 0.80000001192093, 1.2000000476837, 5, 100, 3, 100, critChance = 5, cooldown = 0.25, levelRequirement = 90, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["AtziriUniqueStaffStormCall"] = {
	name = "Storm of Judgement",
	hidden = true,
	color = 3,
	baseEffectiveness = 4.0549998283386,
	incrementalEffectiveness = 0.040500000119209,
	description = "Creates a number of markers around the targeted location, which will explode after a duration, dealing lightning damage. Cannot be supported by Spell Cascade.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Duration] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Lightning] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	fromItem = true,
	baseFlags = {
		area = true,
	},
	baseMods = {
		skill("triggerSource", "Queen's Demand"),
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_chance_to_shock_%",
		"atziri_unique_staff_storm_call_number_of_markers_to_place",
		"shock_effect_+%",
		"base_reduce_enemy_lightning_resistance_%",
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"console_skill_dont_chase",
		"atziri_do_not_gain_skill_charges",
		"skill_has_trigger_from_unique_item",
	},
	levels = {
		[20] = { 0.69999998807907, 1.2999999523163, 50, 12, 50, 25, critChance = 6, duration = 2, cooldown = 1.5, damageEffectiveness = 3.2, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["SummonBeastialRhoa"] = {
	name = "Summon Bestial Rhoa",
	hidden = true,
	color = 3,
	description = "Summons a Bestial Rhoa. In addition to its melee attack, the Bestial Rhoa uses a charge and has an aura that intimidates enemies. This minion's hits cannot be evaded.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	minionList = {
		"RhoaUniqueSummoned",
	},
	statMap = {
		["base_number_of_beast_minions_allowed"] = {
			mod("ActiveBeastMinionLimit", "BASE", nil),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
		skill("allowTotemBuff", true),
		flag("Condition:HaveBestialMinion", { type = "GlobalEffect", effectType = "Buff" }),
	},
	qualityStats = {
	},
	stats = {
		"base_actor_scale_+%",
		"base_number_of_beast_minions_allowed",
		"minion_maximum_life_+%",
		"display_minion_monster_type",
		"display_minion_monster_level",
		"alternate_minion",
	},
	levels = {
		[20] = { 0, 1, 30, 12, 70, 0, cooldown = 5, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, 1, 1, }, cost = { Mana = 30, }, },
	},
}
skills["SummonBeastialSnake"] = {
	name = "Summon Bestial Snake",
	hidden = true,
	color = 3,
	description = "Summons a Bestial Snake. The Bestial Snake fires powerful chaos projectile attacks. This minion's hits cannot be evaded.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Chains] = true, [SkillType.RangedAttack] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	minionList = {
		"SnakeSpitUniqueSummoned",
	},
	statMap = {
		["base_number_of_beast_minions_allowed"] = {
			mod("ActiveBeastMinionLimit", "BASE", nil),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
		skill("allowTotemBuff", true),
		flag("Condition:HaveBestialMinion", { type = "GlobalEffect", effectType = "Buff" }),
	},
	qualityStats = {
	},
	stats = {
		"base_actor_scale_+%",
		"base_number_of_beast_minions_allowed",
		"minion_maximum_life_+%",
		"display_minion_monster_type",
		"display_minion_monster_level",
		"alternate_minion",
	},
	levels = {
		[20] = { 0, 1, 30, 14, 70, 2, cooldown = 5, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, 1, 1, }, cost = { Mana = 30, }, },
	},
}
skills["SummonBeastialUrsa"] = {
	name = "Summon Bestial Ursa",
	hidden = true,
	color = 3,
	description = "Summons a Bestial Ursa. In addition to its melee attack, the Bestial Ursa uses a powerful Ground Slam and Rallying Cry. This minion's hits cannot be evaded.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	minionList = {
		"DropBearUniqueSummoned",
	},
	statMap = {
		["base_number_of_beast_minions_allowed"] = {
			mod("ActiveBeastMinionLimit", "BASE", nil),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
		skill("allowTotemBuff", true),
		flag("Condition:HaveBestialMinion", { type = "GlobalEffect", effectType = "Buff" }),
	},
	qualityStats = {
	},
	stats = {
		"base_actor_scale_+%",
		"base_number_of_beast_minions_allowed",
		"minion_maximum_life_+%",
		"display_minion_monster_type",
		"display_minion_monster_level",
		"alternate_minion",
	},
	levels = {
		[20] = { 0, 1, 30, 13, 70, 1, cooldown = 5, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, 1, 1, }, cost = { Mana = 30, }, },
	},
}
skills["CursePillar"] = {
	name = "Summon Doedre's Effigy",
	hidden = true,
	color = 4,
	description = "Summons an effigy of Doedre, which will project auras of all the curse skill gems socketed in Doedre's Skin. These curses have less effectiveness.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, [SkillType.Instant] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.5,
	fromItem = true,
	baseFlags = {
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"base_number_of_effigies_allowed",
	},
	levels = {
		[20] = { 10000, 3, levelRequirement = 70, statInterpolation = { 1, 1, }, cost = { Mana = 50, }, },
	},
}
skills["SupportCursePillarTriggerCurses"] = {
	name = "Doedre's Effigy",
	hidden = true,
	color = 4,
	support = true,
	requireSkillTypes = { SkillType.AppliesCurse, SkillType.Hex, SkillType.AND, },
	addSkillTypes = { SkillType.InbuiltTrigger, SkillType.Area, SkillType.Aura, SkillType.AuraAffectsEnemies, },
	excludeSkillTypes = { SkillType.SummonsTotem, SkillType.RemoteMined, SkillType.Trapped, },
	ignoreMinionTypes = true,
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	baseMods = {
		skill("manaReservationPercent", 0),
	},
	qualityStats = {
	},
	stats = {
		"skill_has_trigger_from_unique_item",
		"number_of_additional_curses_allowed",
	},
	levels = {
		[20] = { 1, 5, levelRequirement = 70, statInterpolation = { 1, 1, }, cost = { }, },
	},
}
skills["SummonHarbingerOfTheArcaneUber"] = {
	name = "Summon Greater Harbinger of the Arcane",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. The minion has two buff spells it will cast on you: Arcane Surge, granting More Spell Damage and increased Mana Regeneration, and a buff that grants Chance to Shock and Lightning Penetration.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"alternate_minion",
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { 6, cooldown = 6, levelRequirement = 1, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["SummonHarbingerOfBrutalityUber"] = {
	name = "Summon Greater Harbinger of Brutality",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. When you are near a rare or unique enemy, the minion will occasionally grant you a buff giving significantly increased Damage, Attack Speed, and Movement Speed, reducing the Damage you take, and causing Bleeding Enemies that you Kill to Explode, dealing 10% of their maximum Life as Physical Damage.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"alternate_minion",
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { 11, cooldown = 6, levelRequirement = 1, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["SummonHarbingerOfDirectionsUber"] = {
	name = "Summon Greater Harbinger of Directions",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. The minion will cast a random buff on you that grants one or all of the following: Fire 2 additional Projectiles, Chain 2 additional times, Projectiles Pierce 2 additional targets, or Projectiles Fork then Fork an additional time.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"alternate_minion",
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { 9, cooldown = 6, levelRequirement = 1, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["SummonHarbingerOfFocusUber"] = {
	name = "Summon Greater Harbinger of Focus",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. While you are channelling, the minion will occasionally cast a buff on you that reduces the Damage you take, makes you avoid all Stuns and Elemental Ailments, and prevents Curses affecting you.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"alternate_minion",
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { 8, cooldown = 6, levelRequirement = 1, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["SummonHarbingerOfStormsUber"] = {
	name = "Summon Greater Harbinger of Storms",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. The minion will occasionally apply a Chill or Shock with increased effect to an enemy that chains to other nearby enemies.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	minionSkillTypes = { [SkillType.NonHitChill] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"alternate_minion",
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { 10, cooldown = 6, levelRequirement = 1, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["SummonHarbingerOfTimeUber"] = {
	name = "Summon Greater Harbinger of Time",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. The minion will occasionally create an aura on you that increases the Action Speed of you and all allies near you.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
		mod("ActionSpeed", "INC", 10, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Greater Harbinger of Time", modCond = "GreaterHarbingerOfTime" }),
		skill("buffMinions", true),
	},
	qualityStats = {
	},
	stats = {
		"alternate_minion",
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { 7, cooldown = 6, levelRequirement = 1, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["SummonHarbingerOfTheArcane"] = {
	name = "Summon Harbinger of the Arcane",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. The minion will occasionally cast Arcane Surge on you, granting More Spell Damage and increased Mana Regeneration.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"alternate_minion",
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { 0, cooldown = 6, levelRequirement = 1, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["SummonHarbingerOfBrutality"] = {
	name = "Summon Harbinger of Brutality",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. When you are near a rare or unique enemy, the minion will occasionally grant you a buff giving significantly increased Damage, Attack Speed, and Movement Speed, and reducing the Damage you take.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"alternate_minion",
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { 5, cooldown = 6, levelRequirement = 1, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["SummonHarbingerOfDirections"] = {
	name = "Summon Harbinger of Directions",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. The minion will cast a random buff on you that grants one or all of the following: 1 additional Projectile, +1 Chain, Pierce 1 additional Target, or Projectiles Fork.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"alternate_minion",
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { 3, cooldown = 6, levelRequirement = 1, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["SummonHarbingerOfFocus"] = {
	name = "Summon Harbinger of Focus",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. While you are channelling, the minion will occasionally cast a buff on you that reduces the Damage you take, and makes you avoid all Stuns and Elemental Ailments.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"alternate_minion",
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { 2, cooldown = 6, levelRequirement = 1, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["SummonHarbingerOfStorms"] = {
	name = "Summon Harbinger of Storms",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. The minion will occasionally apply a Chill or Shock to an enemy that chains to other nearby enemies.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	minionSkillTypes = { [SkillType.NonHitChill] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"alternate_minion",
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { 4, cooldown = 6, levelRequirement = 1, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["SummonHarbingerOfTime"] = {
	name = "Summon Harbinger of Time",
	hidden = true,
	color = 4,
	description = "Summons an immortal Harbinger minion. The minion will occasionally create an aura on you that increases the Action Speed of you, and all allies and enemies near you.",
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Mineable] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Multicastable] = true, [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.CreatesMinion] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
		mod("ActionSpeed", "INC", 10, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Harbinger of Time", modCond = "HarbingerOfTime" }),
		skill("buffMinions", true),
	},
	qualityStats = {
	},
	stats = {
		"alternate_minion",
		"display_one_harbinger_allowed",
	},
	levels = {
		[1] = { 1, cooldown = 6, levelRequirement = 1, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["TriggeredSummonGhostOnKill"] = {
	name = "Triggered Summon Phantasm",
	hidden = true,
	color = 3,
	description = "Summons a Phantasm minion, which uses a piercing projectile spell that deals physical damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.Duration] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.CreatesMinion] = true, },
	minionSkillTypes = { [SkillType.Duration] = true, [SkillType.Projectile] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	minionList = {
		"SummonedPhantasm",
	},
	statMap = {
		["base_number_of_support_ghosts_allowed"] = {
			mod("ActivePhantasmLimit", "BASE", nil),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"trigger_on_corpse_consume_%_chance",
		"base_skill_effect_duration",
		"base_number_of_support_ghosts_allowed",
		"phantasm_minimum_added_physical_damage_to_grant",
		"phantasm_maximum_added_physical_damage_to_grant",
		"skill_can_own_support_ghosts",
		"skill_has_trigger_from_unique_item",
	},
	levels = {
		[20] = { 100, 15000, 10, 42, 65, manaMultiplier = 20, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["SummonRigwaldsPack"] = {
	name = "Summon Spectral Wolf",
	hidden = true,
	color = 4,
	description = "Summons a spectral wolf companion that attacks nearby enemies and dies after a duration. Each spectral wolf grants you a buff that adds damage to your attacks. If you have the maximum number of them, refreshes the duration and life of an existing one instead.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.Duration] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.CreatesMinion] = true, [SkillType.Buff] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	minionList = {
		"SummonedSpectralWolf",
	},
	statMap = {
		["spectral_wolf_grants_attack_minimum_added_physical_damage"] = {
			mod("PhysicalMin", "BASE", nil, 0, KeywordFlag.Attack, { type = "Multiplier", var = "SpectralWolfCount" }, { type = "GlobalEffect", effectType = "Buff", effectName = "Spectral Wolf" }),
		},
		["spectral_wolf_grants_attack_maximum_added_physical_damage"] = {
			mod("PhysicalMax", "BASE", nil, 0, KeywordFlag.Attack, { type = "Multiplier", var = "SpectralWolfCount" }, { type = "GlobalEffect", effectType = "Buff", effectName = "Spectral Wolf" }),
		},
		["modifiers_to_claw_critical_strike_chance_apply_minion_critical_strike_chance"] = {
			flag("ClawCritChanceAppliesToMinions"),
		},
		["modifiers_to_claw_critical_strike_multiplier_apply_minion_critical_strike_multiplier"] = {
			flag("ClawCritMultiplierAppliesToMinions"),
		},
	},
	baseFlags = {
		spell = true,
		minion = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"number_of_wolves_allowed",
		"chance_to_cast_on_kill_%_target_self",
		"display_minion_monster_type",
		"display_minion_monster_level",
		"spectral_wolf_grants_attack_minimum_added_physical_damage",
		"spectral_wolf_grants_attack_maximum_added_physical_damage",
		"spell_uncastable_if_triggerable",
		"modifiers_to_claw_critical_strike_chance_apply_minion_critical_strike_chance",
		"modifiers_to_claw_critical_strike_multiplier_apply_minion_critical_strike_multiplier",
		"skill_has_trigger_from_unique_item",
	},
	levels = {
		[10] = { 30000, 10, 10, 8, 65, 3, 6, levelRequirement = 55, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[25] = { 30000, 10, 10, 8, 65, 8, 16, levelRequirement = 78, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["SummonTauntingContraption"] = {
	name = "Summon Taunting Contraption",
	hidden = true,
	color = 4,
	description = "Summons a Taunting Contraption that taunts nearby enemies to attack it.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.CreatesMinion] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Buff] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 0,
	fromItem = true,
	baseFlags = {
		spell = true,
		minion = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"cast_on_flask_use_%",
		"display_minion_monster_type",
		"display_minion_monster_level",
		"minion_maximum_life_+%",
		"base_deal_no_damage",
		"spell_uncastable_if_triggerable",
	},
	levels = {
		[20] = { 100, 17, 70, 150, levelRequirement = 70, duration = 4, cooldown = 8, statInterpolation = { 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["SummonVoidSphere"] = {
	name = "Summon Volatile Anomaly",
	hidden = true,
	color = 3,
	baseEffectiveness = 3.4818000793457,
	incrementalEffectiveness = 0.035599999129772,
	description = "Creates an orb which moves towards nearby enemies, exploding after a duration or when it gets close enough. The explosion deals cold spell damage in an area, and leaves behind a Vortex on the ground for a secondary duration which continues to deal cold damage over time and chill enemies caught in it.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Duration] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Cold] = true, [SkillType.ChillingArea] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("dotIsArea", true),
	},
	qualityStats = {
	},
	stats = {
		"chance_to_cast_on_kill_%",
		"base_skill_effect_duration",
		"base_secondary_skill_effect_duration",
		"ground_maelstrom_art_variation",
		"chilled_ground_base_magnitude_override",
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"base_cold_damage_to_deal_per_minute",
		"is_area_damage",
		"base_skill_show_average_damage_instead_of_dps",
		"spell_damage_modifiers_apply_to_skill_dot",
		"spell_uncastable_if_triggerable",
	},
	levels = {
		[20] = { 20, 8000, 4000, 5, 10, 0.80000001192093, 1.2000000476837, 83.333335195979, cooldown = 2, levelRequirement = 70, statInterpolation = { 1, 1, 1, 1, 1, 3, 3, 3, }, cost = { }, },
	},
}
skills["SummonMirageChieftain"] = {
	name = "Tawhoa's Chosen",
	hidden = true,
	color = 1,
	description = "This skill is triggered when you use a Slam skill, and summons a Mirage Chieftain who will use that Slam skill once before dissipating.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Instant] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	fromTree = true,
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"trigger_on_slam_%_chance",
		"skill_used_by_mirage_chieftain_damage_+%_final",
		"spell_uncastable_if_triggerable",
	},
	levels = {
		[1] = { 100, -40, levelRequirement = 1, duration = 3, cooldown = 2, statInterpolation = { 1, 1, }, cost = { }, },
		[20] = { 100, 50, levelRequirement = 1, duration = 3, cooldown = 2, statInterpolation = { 1, 1, }, cost = { }, },
	},
}
skills["TentacleSmash"] = {
	name = "Tentacle Whip",
	hidden = true,
	color = 4,
	description = "This attack causes three otherworldly tentacles to strike the ground around you, each dealing your attack damage in an area.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		attack = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"attack_trigger_on_kill_%",
		"is_area_damage",
		"attack_unusable_if_triggerable",
	},
	levels = {
		[20] = { 20, baseMultiplier = 2.5, cooldown = 2, levelRequirement = 70, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["VampiricIcon"] = {
	name = "Thirst for Blood",
	hidden = true,
	color = 4,
	description = "Reserves some of your life to cause bleeding you inflict to be stronger, and grant life regeneration based on the number bleeding enemies nearby.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.HasReservation] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 0,
	fromItem = true,
	statMap = {
		["vampiric_icon_max_bleeding_beam_targets"] = {
			mod("Multiplier:ThirstForBloodMaxTargets", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff" })
		},
		["skill_life_regeneration_per_minute_per_affected_enemy"] = {
			mod("LifeRegen", "BASE", nil, 0, 0, { type = "Multiplier", var = "NearbyBleedingEnemies", limitVar = "ThirstForBloodMaxTargets" }, { type = "GlobalEffect", effectType = "Buff" }),
			div = 60,
		},
		["vampiric_icon_bleeding_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, KeywordFlag.Bleed, { type = "GlobalEffect", effectType = "Buff" }),
		},
	},
	baseFlags = {
		spell = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"vampiric_icon_max_bleeding_beam_targets",
		"skill_life_regeneration_per_minute_per_affected_enemy",
		"vampiric_icon_bleeding_damage_+%_final",
	},
	levels = {
		[20] = { 5, 24000, 20, lifeReservationPercent = 10, cooldown = 1.2, levelRequirement = 70, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["AvianTornado"] = {
	name = "Twister",
	hidden = true,
	color = 3,
	baseEffectiveness = 2.1300001144409,
	incrementalEffectiveness = 0.02559999935329,
	description = "Launches an unpredictable, piercing twister projectile that moves randomly for a duration, repeatedly dealing damage to enemies it intersects.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.65,
	fromItem = true,
	baseFlags = {
		spell = true,
		projectile = true,
		duration = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_skill_effect_duration",
		"cast_on_gain_avians_flight_or_avians_might_%",
		"global_chance_to_blind_on_hit_%",
		"base_is_projectile",
		"projectiles_nova",
		"always_pierce",
		"spell_uncastable_if_triggerable",
	},
	levels = {
		[20] = { 0.80000001192093, 1.2000000476837, 2500, 100, 25, critChance = 6, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
	},
}
skills["SupportTriggerSpellOnSkillUse"] = {
	name = "Trigger Craft",
	hidden = true,
	color = 4,
	support = true,
	requireSkillTypes = { SkillType.Spell, SkillType.Triggerable, SkillType.AND, },
	addSkillTypes = { SkillType.Triggered, SkillType.Cooldown, },
	excludeSkillTypes = { SkillType.Trapped, SkillType.RemoteMined, SkillType.SummonsTotem, SkillType.Aura, SkillType.InbuiltTrigger, },
	statDescriptionScope = "gem_stat_descriptions",
	fromItem = true,
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_has_trigger_from_crafted_item_mod",
	},
	levels = {
		[1] = { 1, cooldown = 8, levelRequirement = 1, manaMultiplier = 150, statInterpolation = { 1, }, cost = { }, },
		[2] = { 1, cooldown = 4, levelRequirement = 1, manaMultiplier = 150, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["Unhinge"] = {
	name = "Unhinge",
	hidden = true,
	color = 4,
	description = "Relinquish your grip on reality.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Instant] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.HasReservation] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0,
	fromItem = true,
	baseFlags = {
		spell = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"display_unhinge_grant_insane",
	},
	levels = {
		[20] = { cooldown = 5, levelRequirement = 70, statInterpolation = { }, cost = { }, },
	},
}
skills["HiddenBlade"] = {
	name = "Unseen Strike",
	hidden = true,
	color = 2,
	description = "Launches a spinning blade that deals weapon damage to enemies. If firing multiple projectiles, they will be fired in a circle.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Triggerable] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Physical] = true, [SkillType.Cooldown] = true, },
	weaponTypes = {
		["Claw"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["One Handed Axe"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_has_trigger_from_unique_item",
		"projectiles_nova",
		"base_is_projectile",
	},
	levels = {
		[20] = { damageEffectiveness = 2.5, cooldown = 0.5, baseMultiplier = 2.5, levelRequirement = 70, statInterpolation = { }, cost = { }, },
	},
}
skills["VaalBreach"] = {
	name = "Vaal Breach",
	color = 4,
	baseEffectiveness = 0,
	description = "Creates a breach, making you vulnerable to its powerful inhabitants.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.TotemCastsAlone] = true, [SkillType.Vaal] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.5,
	baseFlags = {
		spell = true,
	},
	baseMods = {
	},
	qualityStats = {
		Default = {
			{ "base_cast_speed_+%", 3 },
		},
	},
	stats = {
		"base_deal_no_damage",
		"display_vaal_breach_no_drops_xp",
		"cannot_cancel_skill_before_contact_point",
	},
	levels = {
		[1] = { levelRequirement = 10, statInterpolation = { }, cost = { }, },
		[2] = { levelRequirement = 10, statInterpolation = { }, cost = { }, },
		[3] = { levelRequirement = 10, statInterpolation = { }, cost = { }, },
		[4] = { levelRequirement = 10, statInterpolation = { }, cost = { }, },
		[5] = { levelRequirement = 10, statInterpolation = { }, cost = { }, },
		[6] = { levelRequirement = 10, statInterpolation = { }, cost = { }, },
		[7] = { levelRequirement = 10, statInterpolation = { }, cost = { }, },
		[8] = { levelRequirement = 10, statInterpolation = { }, cost = { }, },
		[9] = { levelRequirement = 10, statInterpolation = { }, cost = { }, },
		[10] = { levelRequirement = 10, statInterpolation = { }, cost = { }, },
	},
}
skills["VoidGaze"] = {
	name = "Void Gaze",
	hidden = true,
	color = 3,
	description = "Applies a debuff to Enemies, removing some of their resistance to Chaos damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Chaos] = true, [SkillType.Area] = true, [SkillType.Totemable] = true, [SkillType.Duration] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, [SkillType.Cooldown] = true, [SkillType.Triggered] = true, },
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 0.21,
	fromItem = true,
	statMap = {
		["base_chaos_damage_resistance_%"] = {
			mod("ChaosResist", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Debuff" }),
		},
	},
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_chaos_damage_resistance_%",
		"base_skill_effect_duration",
		"cast_on_skill_use_%",
		"spell_uncastable_if_triggerable",
	},
	levels = {
		[10] = { -20, 10000, 100, cooldown = 2, levelRequirement = 40, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["VoidShot"] = {
	name = "Void Shot",
	hidden = true,
	color = 4,
	description = "Fires an arrow which decelerates to the target location, the arrow will then become unstable and explode dealing weapon damage in an area, converting half of the physical damage to cold damage.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.InbuiltTrigger] = true, [SkillType.Cold] = true, [SkillType.ProjectilesFromUser] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"trigger_on_skill_use_%_if_you_have_a_void_arrow",
		"skill_physical_damage_%_to_convert_to_cold",
		"active_skill_area_damage_+%_final",
		"base_is_projectile",
		"skill_can_fire_arrows",
		"base_skill_show_average_damage_instead_of_dps",
		"attack_unusable_if_triggerable",
	},
	levels = {
		[20] = { 100, 50, 25, damageEffectiveness = 0.65, baseMultiplier = 0.65, levelRequirement = 70, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["UniqueEnchantmentOfInfernoOnCrit"] = {
	name = "Commandment of Inferno",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.5555999279022,
	incrementalEffectiveness = 0.035000000149012,
	description = "Drops a meteor from above on a nearby foe, dealing fire damage in an area around them.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Fire] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.AreaSpell] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	cannotBeSupported = true,
	fromItem = true,
	baseFlags = {
		spell = true,
		area = true,
		hit = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_skill_effect_duration",
		"fire_storm_fireball_delay_ms",
		"skill_override_pvp_scaling_time_ms",
		"cast_on_crit_%",
		"base_skill_show_average_damage_instead_of_dps",
		"is_area_damage",
		"damage_cannot_be_reflected",
	},
	levels = {
		[1] = { 2.4000000953674, 3.7999999523163, 2000, 100, 450, 100, critChance = 5, cooldown = 3, levelRequirement = 75, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["FieryImpactHeistMaceImplicit"] = {
	name = "Fiery Impact",
	hidden = true,
	color = 4,
	description = "Deals attack damage in an area.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, [SkillType.Triggered] = true, [SkillType.Melee] = true, [SkillType.InbuiltTrigger] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	fromItem = true,
	baseFlags = {
		attack = true,
		area = true,
		melee = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_fire",
		"is_area_damage",
		"skill_has_trigger_from_unique_item",
	},
	levels = {
		[10] = { 60, damageEffectiveness = 2, cooldown = 2, baseMultiplier = 2, levelRequirement = 30, statInterpolation = { 1, }, cost = { }, },
		[15] = { 60, damageEffectiveness = 2.5, cooldown = 2, baseMultiplier = 2.5, levelRequirement = 50, statInterpolation = { 1, }, cost = { }, },
		[20] = { 60, damageEffectiveness = 3, cooldown = 2, baseMultiplier = 3, levelRequirement = 70, statInterpolation = { 1, }, cost = { }, },
	},
}