-- This file is automatically generated, do not edit!
-- Path of Building
--
-- Spectre active skills
-- Skill data (c) Grinding Gear Games
--
local skills, mod, flag, skill = ...

skills["AxisCasterGlacialCascade"] = {
	name = "Glacial Cascade",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.5750000476837,
	incrementalEffectiveness = 0.025000000372529,
	description = "Icicles emerge from the ground in a series of small bursts, each damaging enemies caught in the area.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cold] = true, [SkillType.Physical] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("radius", 12),
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"upheaval_number_of_spikes",
		"pvp_damage_+%_final_scale",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.25999999046326, 0.40000000596046, 0.47999998927116, 0.73000001907349, 6, 0, damageEffectiveness = 0.8, critChance = 6, levelRequirement = 4, statInterpolation = { 3, 3, 3, 3, 1, 1, }, cost = { }, },
		[2] = { 0.25999999046326, 0.40000000596046, 0.47999998927116, 0.73000001907349, 6, 0, damageEffectiveness = 0.8, critChance = 6, levelRequirement = 75, statInterpolation = { 3, 3, 3, 3, 1, 1, }, cost = { }, },
	},
}
skills["AxisDoubleStrikeTrigger"] = {
	name = "Double Strike",
	hidden = true,
	color = 2,
	baseEffectiveness = 0,
	description = "Performs two fast strikes with a melee weapon.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Physical] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	baseMods = {
		skill("dpsMultiplier", 2),
	},
	qualityStats = {
	},
	stats = {
		"physical_damage_+%",
		"base_skill_number_of_additional_hits",
	},
	levels = {
		[1] = { 0, 1, cooldown = 2, levelRequirement = 1, statInterpolation = { 1, 1, }, cost = { }, },
	},
}
skills["BanditExplosiveArrowAtAnimationSpeed"] = {
	name = "Explosive Arrow",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.866700053215,
	incrementalEffectiveness = 0.037999998778105,
	description = "Fires an arrow which acts as a short duration fuse. Applying additional arrows to an enemy extends the duration. When the target dies or the fuses expire, the arrows explode, dealing fire AoE damage to nearby enemies. The AoE radius is proportional to the number of arrows upon death.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Fire] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["minimum_fire_damage_per_fuse_arrow_orb"] = {
			skill("FireMin", nil, { type = "Multiplier", var = "ExplosiveArrowFuse" }),
		},
		["maximum_fire_damage_per_fuse_arrow_orb"] = {
			skill("FireMax", nil, { type = "Multiplier", var = "ExplosiveArrowFuse" }),
		},
		["fuse_arrow_explosion_radius_+_per_fuse_arrow_orb"] = {
			skill("radiusExtra", nil, { type = "Multiplier", var = "ExplosiveArrowFuse" }),
		},
	},
	baseFlags = {
		cast = true,
		projectile = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("radius", 15),
		skill("showAverage", true),
		mod("Multiplier:ExplosiveArrowFuse", "BASE", 1, 0, 0),
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"minimum_fire_damage_per_fuse_arrow_orb",
		"maximum_fire_damage_per_fuse_arrow_orb",
		"fuse_arrow_explosion_radius_+_per_fuse_arrow_orb",
		"active_skill_attack_damage_+%_final",
		"action_attack_or_cast_time_uses_animation_length",
		"skill_can_fire_arrows",
		"base_is_projectile",
	},
	levels = {
		[1] = { 1000, 0.80000001192093, 1.2000000476837, 2, 0, critChance = 6, levelRequirement = 2, statInterpolation = { 1, 3, 3, 1, 1, }, cost = { }, },
	},
}
skills["BanditChampionBlastRainSpectre"] = {
	name = "Blast Rain",
	hidden = true,
	color = 2,
	description = "Fires arrows up in the air, to rain down in an area. Each arrow deals area damage around where it lands, and they will all overlap on the targeted location.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Fire] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Area] = true, [SkillType.ProjectileSpeed] = true, [SkillType.ProjectileNumber] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Triggerable] = true, [SkillType.Rain] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	baseMods = {
		skill("radius", 24),
		skill("dpsMultiplier", 4),
	},
	qualityStats = {
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_fire",
		"active_skill_area_of_effect_radius_+%_final",
		"base_number_of_additional_arrows",
		"blast_rain_arrow_delay_ms",
		"base_is_projectile",
		"is_area_damage",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { 50, 0, 4, 80, damageEffectiveness = 0.5, baseMultiplier = 0.5, levelRequirement = 15, statInterpolation = { 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["GABeastCleave"] = {
	name = "Cleave",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.333,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"is_area_damage",
		"action_attack_or_cast_time_uses_animation_length",
	},
	levels = {
		[1] = { baseMultiplier = 1.475, cooldown = 5, levelRequirement = 1, statInterpolation = { }, cost = { }, },
	},
}
skills["BirdmanBloodProjectileMortar"] = {
	name = "Blood Projectile",
	hidden = true,
	color = 4,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Attack] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_repeat_count",
		"active_skill_damage_+%_final",
		"active_skill_area_of_effect_radius_+%_final",
		"projectile_spread_radius",
		"main_hand_base_maximum_attack_distance",
		"attack_speed_+%",
		"base_is_projectile",
		"projectile_uses_contact_position",
	},
	levels = {
		[1] = { 2, 10, 0, 15, 40, 100, baseMultiplier = 1.15, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["BirdmanConsumeCorpse"] = {
	name = "Consume Corpse",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Spell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.67,
	baseFlags = {
		spell = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
	},
	levels = {
		[1] = { levelRequirement = 0, statInterpolation = { }, cost = { }, },
	},
}
skills["BoneStalkerEarthquake"] = {
	name = "Earthquake",
	hidden = true,
	color = 1,
	description = "Smashes the ground, dealing damage in an area and cracking the earth. The crack will erupt in a powerful aftershock after a short duration. Cracks created before the first one has erupted will not generate their own aftershocks. Requires an Axe, Mace, Sceptre, Staff or Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Multistrikeable] = true, [SkillType.Duration] = true, [SkillType.Slam] = true, [SkillType.Triggerable] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Two Handed Axe"] = true,
		["Staff"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"quake_slam_fully_charged_explosion_damage_+%_final",
		"is_area_damage",
	},
	levels = {
		[1] = { 1800, 25, damageEffectiveness = 0.5, cooldown = 5, levelRequirement = 1, statInterpolation = { 1, 1, }, cost = { }, },
	},
}
skills["BreachCleave"] = {
	name = "Cleave",
	hidden = true,
	color = 1,
	description = "The character swings their weapon (or both weapons if dual wielding) in an arc, damaging monsters in an area in front of them. Only works with Axes and Swords.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ThresholdJewelArea] = true, [SkillType.Physical] = true, },
	weaponTypes = {
		["Two Handed Axe"] = true,
		["Thrusting One Handed Sword"] = true,
		["One Handed Axe"] = true,
		["Two Handed Sword"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"cleave_damage_+%_final_while_dual_wielding",
		"physical_damage_+%",
		"monster_penalty_against_minions_damage_+%_final_vs_player_minions",
		"skill_physical_damage_%_to_convert_to_fire",
		"melee_range_+",
		"is_area_damage",
		"skill_double_hits_when_dual_wielding",
		"action_attack_or_cast_time_uses_animation_length",
	},
	levels = {
		[1] = { -40, 29, -20, 50, 4, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["BullCharge"] = {
	name = "Charge",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.75,
	baseFlags = {
		attack = true,
		melee = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_art_variation",
		"active_skill_damage_+%_final",
	},
	levels = {
		[1] = { 1, cooldown = 4, levelRequirement = 2, statInterpolation = { 1, }, cost = { }, },
		[2] = { 1, 15, cooldown = 4, levelRequirement = 68, statInterpolation = { 1, 1, }, cost = { }, },
	},
}
skills["CageSpiderCycloneTriggerSandstorms"] = {
	name = "Cyclone",
	hidden = true,
	color = 2,
	description = "Damage enemies around you, then perform a spinning series of attacks as you travel to a target location. Cannot be supported by Ruthless or Multistrike.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"active_skill_attack_speed_+%_final",
		"cyclone_movement_speed_+%_final",
		"active_skill_damage_+%_final",
		"monster_penalty_against_minions_damage_+%_final_vs_player_minions",
		"cyclone_extra_distance",
		"is_area_damage",
		"cyclone_has_triggered_skill",
	},
	levels = {
		[1] = { 150, 0, -60, -40, 40, levelRequirement = 2, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["CageSpiderSandSpark"] = {
	name = "Sandstorm",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.64999997615814,
	incrementalEffectiveness = 0.031399998813868,
	description = "Launches unpredictable sparks that move randomly until they hit an enemy or expire.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.65,
	baseFlags = {
		spell = true,
		projectile = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_skill_effect_duration",
		"base_projectile_speed_+%",
		"cast_on_cyclone_contact_%",
		"base_is_projectile",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 2000, -50, 100, levelRequirement = 61, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
	},
}
skills["ChaosDegenAura"] = {
	name = "Chaos Aura",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.93330001831055,
	incrementalEffectiveness = 0.036499999463558,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.HasReservation] = true, [SkillType.DamageOverTime] = true, [SkillType.Aura] = true, [SkillType.Chaos] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		aura = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_chaos_damage_to_deal_per_minute",
	},
	levels = {
		[1] = { 16.666667039196, levelRequirement = 3, statInterpolation = { 3, }, cost = { }, },
	},
}
skills["DelayedBlastSpectre"] = {
	name = "Delayed Blast",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.77999997138977,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 1.3, levelRequirement = 3, statInterpolation = { 3, 3, }, cost = { }, },
	},
}
skills["DelveProtovaalWhirlingCharge"] = {
	name = "Whirling Charge",
	hidden = true,
	color = 4,
	skillTypes = { },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		hit = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"active_skill_attack_speed_+%_final",
		"combo_attack_first_hit_damage_+%_final",
		"is_area_damage",
	},
	levels = {
		[1] = { 100, 150, baseMultiplier = 0.56, cooldown = 10, levelRequirement = 1, statInterpolation = { 1, 1, }, cost = { }, },
	},
}
skills["DemonFemaleRangedProjectile"] = {
	name = "Ranged Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.85000002384186,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesNotFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_maximum_action_distance_+%",
		"active_skill_damage_+%_final",
		"monster_reverse_point_blank_damage_-%_at_minimum_range",
		"base_is_projectile",
	},
	levels = {
		[1] = { -60, -60, 30, levelRequirement = 30, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["DemonFemaleRangedProjectile2"] = {
	name = "Ranged Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.85000002384186,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesNotFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_maximum_action_distance_+%",
		"active_skill_damage_+%_final",
		"monster_reverse_point_blank_damage_-%_at_minimum_range",
		"monster_projectile_variation",
		"base_is_projectile",
		"cannot_freeze_shock_ignite_on_critical",
	},
	levels = {
		[1] = { -60, -60, 30, 1, levelRequirement = 60, statInterpolation = { 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["DemonModularBladeVortexSpectre"] = {
	name = "Blade Vortex",
	hidden = true,
	color = 2,
	baseEffectiveness = 0.59500002861023,
	incrementalEffectiveness = 0.035999998450279,
	description = "An ethereal blade spins around you for a duration, repeatedly damaging enemies that it passes through.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.TotemCastsAlone] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.5,
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("hitTimeOverride", 1),
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_skill_effect_duration",
		"maximum_number_of_spinning_blades",
		"active_skill_area_of_effect_radius_+%_final",
		"skill_repeat_count",
		"is_area_damage",
		"skill_can_add_multiple_charges_per_action",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 5000, 5, 0, 2, critChance = 6, levelRequirement = 3, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["ElementalHitSkeletonKnight"] = {
	name = "Elemental Hit Fire",
	hidden = true,
	color = 2,
	baseEffectiveness = 1.1667000055313,
	incrementalEffectiveness = 0.04280000180006,
	description = "Each attack with this skill will choose an element at random, and will only be able to deal damage of that element. If the attack hits an enemy, it will also deal damage in an area around them, with the radius being larger if that enemy is suffering from an ailment of the chosen element. It will avoid choosing the same element twice in a row.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Fire] = true, [SkillType.Cold] = true, [SkillType.Lightning] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.RandomElement] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		melee = true,
	},
	baseMods = {
		flag("DealNoPhysical"),
		flag("DealNoChaos"),
		flag("DealNoCold"),
		flag("DealNoLightning"),
		mod("AreaOfEffect", "MORE", 80, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Ignited" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Ignited" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Chilled" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Frozen" }),
		mod("Multiplier:ElementalHitAilmentOnEnemy", "BASE", 1, 0, 0, { type = "ActorCondition", actor = "enemy", var = "Shocked" }),
		mod("Damage", "MORE", 10, 0, 0, { type = "Multiplier", var = "ElementalHitAilmentOnEnemy" }),
	},
	qualityStats = {
	},
	stats = {
		"active_skill_damage_+%_final",
		"chance_to_freeze_shock_ignite_%",
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"action_attack_or_cast_time_uses_animation_length",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
		"is_area_damage",
	},
	levels = {
		[1] = { 150, 50, baseMultiplier = 1.5, levelRequirement = 1, statInterpolation = { 2, 1, }, cost = { }, },
		[3] = { 300, 50, baseMultiplier = 1.5, levelRequirement = 45, statInterpolation = { 2, 1, }, cost = { }, },
		[4] = { 400, 50, baseMultiplier = 1.5, levelRequirement = 84, statInterpolation = { 2, 1, }, cost = { }, },
	},
}
skills["ElementalHitSkeletonKnightIncursion"] = {
	name = "Elemental Hit",
	hidden = true,
	color = 2,
	description = "Each attack with this skill will choose an element at random, and will only be able to deal damage of that element. If the attack hits an enemy, it will also deal damage in an area around them, with the radius being larger if that enemy is suffering from an ailment of the chosen element. It will avoid choosing the same element twice in a row.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.Fire] = true, [SkillType.Cold] = true, [SkillType.Lightning] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, [SkillType.RandomElement] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"active_skill_damage_+%_final",
		"chance_to_freeze_shock_ignite_%",
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"action_attack_or_cast_time_uses_animation_length",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
		"is_area_damage",
	},
	levels = {
		[1] = { 0, 25, baseMultiplier = 1.5, levelRequirement = 1, statInterpolation = { 2, 1, }, cost = { }, },
		[3] = { 1, 25, baseMultiplier = 1.5, levelRequirement = 45, statInterpolation = { 2, 1, }, cost = { }, },
		[4] = { 200, 25, baseMultiplier = 1.5, levelRequirement = 84, statInterpolation = { 2, 1, }, cost = { }, },
	},
}
skills["ExperimenterDetonateDead"] = {
	name = "Detonate Dead",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.5111000537872,
	incrementalEffectiveness = 0.014299999922514,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	baseFlags = {
		cast = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"corpse_explosion_monster_life_%",
		"secondary_minimum_base_fire_damage",
		"secondary_maximum_base_fire_damage",
		"is_area_damage",
		"spell_maximum_action_distance_+%",
		"active_skill_area_of_effect_radius_+%_final",
		"monster_penalty_against_minions_damage_+%_final_vs_player_minions",
	},
	levels = {
		[1] = { 7, 0.80000001192093, 1.2000000476837, 1, -70, 0, -25, critChance = 5, levelRequirement = 3, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[2] = { 5, 0.80000001192093, 1.2000000476837, 1, -70, 0, -25, critChance = 5, levelRequirement = 33, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[3] = { 4, 0.80000001192093, 1.2000000476837, 1, -70, 0, -25, critChance = 5, levelRequirement = 60, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["FireballIncursionChaos"] = {
	name = "Chaos Ball",
	hidden = true,
	color = 3,
	baseEffectiveness = 2,
	incrementalEffectiveness = 0.025000000372529,
	description = "Unleashes a ball of fire towards a target which explodes, damaging nearby foes.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.2,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_chaos_damage",
		"spell_maximum_base_chaos_damage",
		"spell_maximum_action_distance_+%",
		"base_is_projectile",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, -40, critChance = 6, levelRequirement = 0, statInterpolation = { 3, 3, 1, }, cost = { }, },
	},
}
skills["FireballIncusionFire"] = {
	name = "Fireball",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.97219997644424,
	incrementalEffectiveness = 0.050000000745058,
	description = "Unleashes a ball of fire towards a target which explodes, damaging nearby foes.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.2,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"spell_maximum_action_distance_+%",
		"base_is_projectile",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, -40, critChance = 6, levelRequirement = 0, statInterpolation = { 3, 3, 1, }, cost = { }, },
	},
}
skills["FireballIncusionLightning"] = {
	name = "Lightning Ball",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.0937999486923,
	incrementalEffectiveness = 0.050000000745058,
	description = "Unleashes a ball of fire towards a target which explodes, damaging nearby foes.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.2,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"spell_maximum_action_distance_+%",
		"base_is_projectile",
	},
	levels = {
		[1] = { 0.5, 1.5, -40, critChance = 6, levelRequirement = 0, statInterpolation = { 3, 3, 1, }, cost = { }, },
	},
}
skills["FireMonsterWhirlingBlades"] = {
	name = "Fire Roll",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.0888999700546,
	incrementalEffectiveness = 0.064599998295307,
	description = "Dive through enemies, dealing weapon damage. Only works with daggers, claws and one handed swords. Cannot be supported by Multistrike.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, },
	weaponTypes = {
		["Thrusting One Handed Sword"] = true,
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.43,
	statMap = {
		["whirling_blades_base_ground_fire_damage_to_deal_per_minute"] = {
			skill("FireDot", nil),
			div = 60,
		},
	},
	baseFlags = {
		attack = true,
		melee = true,
		movement = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"whirling_blades_base_ground_fire_damage_to_deal_per_minute",
		"base_skill_effect_duration",
		"attack_speed_+%",
		"monster_flurry",
		"cast_time_overrides_attack_duration",
		"ignores_proximity_shield",
	},
	levels = {
		[1] = { 16.666667039196, 6000, -50, 1, levelRequirement = 3, statInterpolation = { 3, 1, 1, 1, }, cost = { }, },
	},
}
skills["FlamebearerFlameBlue"] = {
	name = "Blue Flame",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.17000000178814,
	incrementalEffectiveness = 0.041000001132488,
	description = "Summons a totem that fires a stream of flame at nearby enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.SummonsTotem] = true, [SkillType.Fire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	skillTotemId = 8,
	castTime = 0.25,
	baseFlags = {
		spell = true,
		projectile = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"skill_repeat_count",
		"skill_art_variation",
		"spell_maximum_action_distance_+%",
		"active_skill_cast_speed_+%_final",
		"monster_penalty_against_minions_damage_+%_final_vs_player_minions",
		"base_is_projectile",
		"always_pierce",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 9, 1, -78, 25, -25, damageEffectiveness = 0.25, cooldown = 4, levelRequirement = 4, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, cost = { }, },
		[2] = { 0.80000001192093, 1.2000000476837, 9, 1, -75, 25, -25, damageEffectiveness = 0.25, cooldown = 4, levelRequirement = 8, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, cost = { }, },
		[3] = { 1.2400000095367, 1.8600000143051, 9, 1, -75, 25, -25, damageEffectiveness = 0.25, cooldown = 4, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["GhostPirateBladeVortexSpectre"] = {
	name = "Blade Vortex",
	hidden = true,
	color = 2,
	baseEffectiveness = 0.59500002861023,
	incrementalEffectiveness = 0.035999998450279,
	description = "An ethereal blade spins around you for a duration, repeatedly damaging enemies that it passes through.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.TotemCastsAlone] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.5,
	baseFlags = {
		spell = true,
		duration = true,
		area = true,
	},
	baseMods = {
		skill("hitTimeOverride", 1),
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_skill_effect_duration",
		"maximum_number_of_spinning_blades",
		"active_skill_area_of_effect_radius_+%_final",
		"skill_repeat_count",
		"is_area_damage",
		"skill_can_add_multiple_charges_per_action",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 5000, 5, 0, 2, critChance = 6, levelRequirement = 3, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["GoatmanEarthquake"] = {
	name = "Earthquake",
	hidden = true,
	color = 1,
	description = "Smashes the ground, dealing damage in an area and cracking the earth. The crack will erupt in a powerful aftershock after a short duration. Cracks created before the first one has erupted will not generate their own aftershocks. Requires an Axe, Mace, Sceptre, Staff or Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Multistrikeable] = true, [SkillType.Duration] = true, [SkillType.Slam] = true, [SkillType.Triggerable] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Two Handed Axe"] = true,
		["Staff"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"quake_slam_fully_charged_explosion_damage_+%_final",
		"is_area_damage",
	},
	levels = {
		[1] = { 1800, 25, damageEffectiveness = 0.5, cooldown = 2.75, attackSpeedMultiplier = 13, levelRequirement = 1, statInterpolation = { 1, 1, }, cost = { }, },
	},
}
skills["GoatmanFireMagmaOrb"] = {
	name = "Magma Orb",
	hidden = true,
	color = 3,
	baseEffectiveness = 2.7778000831604,
	incrementalEffectiveness = 0.035999998450279,
	description = "Lob a fiery orb that explodes as it hits the ground. The skill chains, releasing another fiery orb that repeats this effect.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Multicastable] = true, [SkillType.Chains] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.33,
	baseFlags = {
		spell = true,
		area = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"projectile_spread_radius",
		"number_of_additional_projectiles",
		"fire_mortar_second_hit_damage_+%_final",
		"base_cast_speed_+%",
		"number_of_chains",
		"is_area_damage",
		"base_is_projectile",
		"use_scaled_contact_offset",
		"projectile_uses_contact_position",
		"maintain_projectile_direction_when_using_contact_position",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 0, 0, 0, 30, 2, critChance = 5, cooldown = 3, levelRequirement = 3, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, cost = { }, },
		[2] = { 1.3799999952316, 1.8400000333786, 0, 0, 0, 30, 2, critChance = 5, cooldown = 3, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["GoatmanMoltenShell"] = {
	name = "Molten Shell",
	hidden = true,
	color = 1,
	baseEffectiveness = 5.3499999046326,
	incrementalEffectiveness = 0.037999998778105,
	description = "Summons fiery elemental shields providing additional armour for a short duration. If cumulative physical damage prevented by your blocking or armour reaches a threshold, the shields explode outwards, dealing fire damage to surrounding enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.TotemCastsWhenNotDetached] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.17,
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"fire_shield_damage_threshold",
		"base_physical_damage_reduction_rating",
		"base_resist_all_elements_%",
		"skill_art_variation",
		"active_skill_area_of_effect_radius_+%_final",
		"molten_shell_expire_after_x_hits",
		"is_area_damage",
		"always_ignite",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 20, 335, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 3, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[2] = { 0.80000001192093, 1.2000000476837, 25, 649, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 5, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[3] = { 0.80000001192093, 1.2000000476837, 36, 1000, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 8, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[4] = { 0.80000001192093, 1.2000000476837, 49, 1633, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 12, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[5] = { 0.80000001192093, 1.2000000476837, 64, 2075, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 15, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[6] = { 0.80000001192093, 1.2000000476837, 91, 2573, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 19, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[7] = { 0.80000001192093, 1.2000000476837, 116, 3094, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 22, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[8] = { 0.80000001192093, 1.2000000476837, 160, 3641, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 26, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[9] = { 0.80000001192093, 1.2000000476837, 209, 4352, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 30, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[10] = { 0.80000001192093, 1.2000000476837, 315, 5313, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 36, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[11] = { 0.80000001192093, 1.2000000476837, 374, 5890, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 39, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[12] = { 0.80000001192093, 1.2000000476837, 377, 6189, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 40, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[13] = { 0.80000001192093, 1.2000000476837, 565, 7030, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 45, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[14] = { 0.80000001192093, 1.2000000476837, 752, 7870, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 50, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[15] = { 0.80000001192093, 1.2000000476837, 1194, 9159, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 57, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[16] = { 0.80000001192093, 1.2000000476837, 1403, 9867, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 60, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[17] = { 0.80000001192093, 1.2000000476837, 2091, 11090, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 66, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[18] = { 0.80000001192093, 1.2000000476837, 2211, 11524, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 67, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[19] = { 0.80000001192093, 1.2000000476837, 2334, 11966, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[20] = { 0.80000001192093, 1.2000000476837, 2456, 12428, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 69, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[21] = { 0.80000001192093, 1.2000000476837, 2579, 12894, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[22] = { 0.80000001192093, 1.2000000476837, 2746, 13369, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 71, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[23] = { 0.80000001192093, 1.2000000476837, 2912, 13857, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 72, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[24] = { 0.80000001192093, 1.2000000476837, 3074, 14358, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 73, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[25] = { 0.80000001192093, 1.2000000476837, 3237, 14875, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 74, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[26] = { 0.80000001192093, 1.2000000476837, 3397, 15397, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 75, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[27] = { 0.80000001192093, 1.2000000476837, 3552, 15931, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 76, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[28] = { 0.80000001192093, 1.2000000476837, 3703, 16480, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 77, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[29] = { 0.80000001192093, 1.2000000476837, 3847, 17039, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 78, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[30] = { 0.80000001192093, 1.2000000476837, 3981, 17613, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 79, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[31] = { 0.80000001192093, 1.2000000476837, 4110, 18195, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 80, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[32] = { 0.80000001192093, 1.2000000476837, 4230, 18790, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 81, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[33] = { 0.80000001192093, 1.2000000476837, 4334, 19399, 0, 1, 4, 1, critChance = 5, cooldown = 7.5, duration = 5, levelRequirement = 82, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["GoatmanMonsterSlam"] = {
	name = "Slam",
	hidden = true,
	color = 1,
	baseEffectiveness = 0,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"active_skill_attack_speed_+%_final",
		"is_area_damage",
	},
	levels = {
		[1] = { -20, damageEffectiveness = 1.75, cooldown = 6, baseMultiplier = 1.75, levelRequirement = 1, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["GroundEffectsSlamDockworkerChampion"] = {
	name = "Slam",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.7272999286652,
	incrementalEffectiveness = 0.035000000149012,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"active_skill_attack_speed_+%_final",
		"base_skill_effect_duration",
		"skill_art_variation",
		"ground_maelstrom_art_variation",
		"base_cold_damage_to_deal_per_minute",
		"is_area_damage",
	},
	levels = {
		[1] = { -40, 4000, 8, 0, 58.333334637185, damageEffectiveness = 2.5, cooldown = 6, baseMultiplier = 1.5, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, 3, }, cost = { }, },
	},
}
skills["GuardianArc"] = {
	name = "Arc",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.85000002384186,
	incrementalEffectiveness = 0.029999999329448,
	description = "An arc of lightning stretches from the caster to a targeted enemy and chains on to other nearby enemies. Each time the main beam chains it will also chain to a second enemy, but that secondary arc cannot chain further.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Chains] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "beam_skill_stat_descriptions",
	castTime = 0.8,
	baseFlags = {
		spell = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_chance_to_shock_%",
		"number_of_chains",
		"active_skill_cast_speed_+%_final",
		"spell_maximum_action_distance_+%",
		"skill_art_variation",
	},
	levels = {
		[1] = { 0.5, 1.5, 5, 0, -80, -50, 1, damageEffectiveness = 0.7, critChance = 5, levelRequirement = 2, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, cost = { }, },
		[2] = { 0.60000002384186, 1.7999999523163, 5, 0, -80, -50, 1, damageEffectiveness = 0.7, critChance = 5, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["HalfSkeletonPuncture"] = {
	name = "Puncture",
	hidden = true,
	color = 2,
	baseEffectiveness = 0,
	description = "Punctures enemies, causing a bleeding debuff, which will be affected by modifiers to skill duration. Puncture works with bows, daggers, claws or swords.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.DamageOverTime] = true, [SkillType.Triggerable] = true, [SkillType.Physical] = true, },
	weaponTypes = {
		["Bow"] = true,
		["Claw"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	baseMods = {
		mod("BleedChance", "BASE", 100),
	},
	qualityStats = {
	},
	stats = {
		"active_skill_bleeding_damage_+%_final",
		"melee_range_+",
		"global_bleed_on_hit",
	},
	levels = {
		[1] = { 57, 20, baseMultiplier = 1.2, cooldown = 7.5, levelRequirement = 2, statInterpolation = { 1, 1, }, cost = { }, },
		[2] = { 57, 20, baseMultiplier = 1.2, cooldown = 7.5, levelRequirement = 14, statInterpolation = { 1, 1, }, cost = { }, },
	},
}
skills["HolyFireElementalFireball"] = {
	name = "Fireball",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.1888999938965,
	incrementalEffectiveness = 0.03940000012517,
	description = "Unleashes a ball of fire towards a target which explodes, damaging nearby foes.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.85,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_is_projectile",
		"spell_maximum_action_distance_+%",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 1, -50, critChance = 6, levelRequirement = 3, statInterpolation = { 3, 3, 1, 1, }, cost = { }, },
		[2] = { 1.75, 2.710000038147, 1, -50, critChance = 6, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, }, cost = { }, },
	},
}
skills["IguanaProjectile"] = {
	name = "Barrage",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.8700000047684,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"monster_projectile_variation",
		"skill_repeat_count",
		"spell_maximum_action_distance_+%",
		"active_skill_damage_+%_final",
		"monster_reverse_point_blank_damage_-%_at_minimum_range",
		"base_is_projectile",
	},
	levels = {
		[1] = { 4, 0, -60, -60, 30, cooldown = 3.5, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["IguanaProjectileChrome"] = {
	name = "Barrage",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.8700000047684,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"monster_projectile_variation",
		"skill_repeat_count",
		"spell_maximum_action_distance_+%",
		"active_skill_damage_+%_final",
		"monster_reverse_point_blank_damage_-%_at_minimum_range",
		"skill_physical_damage_%_to_convert_to_cold",
		"base_is_projectile",
	},
	levels = {
		[1] = { 24, 0, -60, -30, 30, 50, cooldown = 3.5, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["IncaMinionProjectile"] = {
	name = "Chaos Projectile",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.3600000143051,
	incrementalEffectiveness = 0.018999999389052,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.33,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_chaos_damage",
		"spell_maximum_base_chaos_damage",
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_is_projectile",
		"skill_range_+%",
		"active_skill_damage_+%_final",
		"visual_hit_effect_chaos_is_green",
	},
	levels = {
		[1] = { 0.27000001072884, 0.40000000596046, 0.40000000596046, 0.60000002384186, 1, -75, 60, critChance = 5, levelRequirement = 4, statInterpolation = { 3, 3, 3, 3, 1, 1, 2, }, cost = { }, },
		[2] = { 0.27000001072884, 0.40000000596046, 0.40000000596046, 0.60000002384186, 1, -75, 40, critChance = 5, levelRequirement = 21, statInterpolation = { 3, 3, 3, 3, 1, 1, 2, }, cost = { }, },
		[3] = { 0.6700000166893, 1.0099999904633, 1.0099999904633, 1.5199999809265, 1, -75, 0, critChance = 5, levelRequirement = 68, statInterpolation = { 3, 3, 3, 3, 1, 1, 2, }, cost = { }, },
	},
}
skills["IncursionLeapSlamChampion"] = {
	name = "Leap Slam",
	hidden = true,
	color = 4,
	description = "Jump into the air, damaging and knocking back enemies with your weapon where you land. Enemies you would land on are pushed out of the way. Requires an Axe, Mace, Sceptre, Sword or Staff. Cannot be supported by Multistrike.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"is_area_damage",
		"cast_time_overrides_attack_duration",
	},
	levels = {
		[1] = { baseMultiplier = 1.5, cooldown = 6, levelRequirement = 1, statInterpolation = { }, cost = { }, },
	},
}
skills["IncursionMeteorUpheaval"] = {
	name = "Chaos Spikes",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.25,
	incrementalEffectiveness = 0.02250000089407,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Fire] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.5,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"upheaval_number_of_spikes",
		"monster_penalty_against_minions_damage_+%_final_vs_player_minions",
		"skill_physical_damage_%_to_convert_to_chaos",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 8, 0, 30, critChance = 5, cooldown = 8, levelRequirement = 1, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
	},
}
skills["InsectSpawnerSpit"] = {
	name = "Spit",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.93999999761581,
	incrementalEffectiveness = 0.029999999329448,
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_is_projectile",
		"attack_minimum_added_fire_damage",
		"attack_maximum_added_fire_damage",
		"attack_minimum_added_physical_damage",
		"attack_maximum_added_physical_damage",
		"monster_reverse_point_blank_damage_-%_at_minimum_range",
	},
	levels = {
		[1] = { 1, 0.18000000715256, 0.27000001072884, 0.60000002384186, 0.75, 30, levelRequirement = 2, statInterpolation = { 1, 3, 3, 3, 3, 1, }, cost = { }, },
	},
}
skills["KaomFireBeamTotemSpectre"] = {
	name = "Scorching Ray Totem",
	hidden = true,
	color = 3,
	baseEffectiveness = 3.039999961853,
	incrementalEffectiveness = 0.047400001436472,
	description = "Unleash a beam of fire that burns enemies it touches. Remaining in the beam intensifies the burning, adding a portion of the beam's damage in stages. Inflicts Fire Exposure at maximum stages. Enemies who leave the beam continue to burn for a duration. Increasing cast speed also increases the rate at which the beam can turn.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Totemable] = true, [SkillType.DamageOverTime] = true, [SkillType.Fire] = true, [SkillType.CausesBurning] = true, [SkillType.Duration] = true, [SkillType.Channel] = true, [SkillType.DegenOnlySpellDamage] = true, },
	statDescriptionScope = "debuff_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["fire_beam_enemy_fire_resistance_%_per_stack"] = {
			mod("FireResist", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Debuff", effectStackVar = "KaomFireBeamTotemStage", effectStackLimit = 24 }),
		},
	},
	baseFlags = {
		spell = true,
		totem = true,
		duration = true,
	},
	baseMods = {
		mod("Damage", "MORE", 60, 0, 0, { type = "Multiplier", actor = "parent", var = "KaomFireBeamTotemStage", base = -60, limit = 8 }),
	},
	qualityStats = {
	},
	stats = {
		"base_fire_damage_to_deal_per_minute",
		"totem_damage_+%_final_per_active_totem",
		"fire_beam_additional_stack_damage_+%_final",
		"base_fire_damage_resistance_%",
		"base_totem_duration",
		"totem_art_variation",
		"base_active_skill_totem_level",
		"is_totem",
		"base_skill_is_totemified",
		"totem_ignores_cooldown",
		"ignores_totem_cooldown_limit",
	},
	levels = {
		[1] = { 16.666667039196, -12, -40, -25, 5000, 1, 1, levelRequirement = 1, duration = 1.5, cooldown = 3, statInterpolation = { 3, 1, 1, 1, 1, 1, 2, }, cost = { }, },
		[2] = { 16.666667039196, -12, -40, -25, 5000, 1, 83, levelRequirement = 83, duration = 1.5, cooldown = 3, statInterpolation = { 3, 1, 1, 1, 1, 1, 2, }, cost = { }, },
	},
}
skills["KaomWarriorGroundSlam"] = {
	name = "Ground Slam",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	skillTypes = { [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_stun_threshold_reduction_+%",
		"active_skill_area_of_effect_radius_+%_final",
		"active_skill_damage_+%_final",
		"skill_art_variation",
		"is_area_damage",
	},
	levels = {
		[1] = { 10, 0, 20, 1, cooldown = 5, levelRequirement = 2, statInterpolation = { 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["KaomWarriorMoltenStrike"] = {
	name = "Molten Strike",
	hidden = true,
	color = 1,
	baseEffectiveness = 0.69999998807907,
	description = "Infuses your melee weapon with molten energies to attack with physical and fire damage. This attack causes balls of molten magma to launch forth from the enemies you hit, divided amongst all enemies hit by the strike. These will explode, causing AoE attack damage to enemies where they land.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Fire] = true, [SkillType.RangedAttack] = true, [SkillType.ProjectilesNotFromUser] = true, [SkillType.ThresholdJewelChaining] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_fire",
		"number_of_additional_projectiles",
		"active_skill_damage_+%_final",
		"physical_damage_+%",
		"active_skill_projectile_damage_+%_final",
		"active_skill_area_of_effect_radius_+%_final",
		"base_projectile_speed_+%",
	},
	levels = {
		[1] = { 60, 5, -20, 0, -20, 0, -25, cooldown = 3, levelRequirement = 2, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["KitavaDemonLeapSlam"] = {
	name = "Leap Slam",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Jump into the air, damaging and knocking back enemies with your weapon where you land. Enemies you would land on are pushed out of the way. Requires an Axe, Mace, Sceptre, Sword or Staff. Cannot be supported by Multistrike.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"physical_damage_%_to_add_as_fire",
		"is_area_damage",
		"cast_time_overrides_attack_duration",
	},
	levels = {
		[1] = { 50, damageEffectiveness = 1.2, cooldown = 5, baseMultiplier = 1.2, levelRequirement = 1, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["KitavaDemonCleave"] = {
	name = "Cleave",
	hidden = true,
	color = 1,
	baseEffectiveness = 0,
	description = "The character swings their weapon (or both weapons if dual wielding) in an arc, damaging monsters in an area in front of them. Only works with Axes and Swords.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ThresholdJewelArea] = true, [SkillType.Physical] = true, },
	weaponTypes = {
		["Two Handed Axe"] = true,
		["Thrusting One Handed Sword"] = true,
		["One Handed Axe"] = true,
		["Two Handed Sword"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"bleed_on_hit_with_attacks_%",
		"active_skill_bleeding_damage_+%_final",
		"active_skill_attack_speed_+%_final",
		"is_area_damage",
		"skill_double_hits_when_dual_wielding",
	},
	levels = {
		[1] = { 100, -44, -25, damageEffectiveness = 1.9, cooldown = 6, baseMultiplier = 1.9, levelRequirement = 1, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["KitavaDemonWhirlingBlades"] = {
	name = "Whirling Blades",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.666699886322,
	incrementalEffectiveness = 0.0625,
	description = "Dive through enemies, dealing weapon damage. Only works with daggers, claws and one handed swords. Cannot be supported by Multistrike.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, },
	weaponTypes = {
		["Thrusting One Handed Sword"] = true,
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.859,
	baseFlags = {
		attack = true,
		melee = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"whirling_blades_base_ground_fire_damage_to_deal_per_minute",
		"base_skill_effect_duration",
		"monster_flurry",
		"cast_time_overrides_attack_duration",
		"ignores_proximity_shield",
	},
	levels = {
		[1] = { 16.666667039196, 6000, 1, damageEffectiveness = 0.6, cooldown = 6, baseMultiplier = 0.6, levelRequirement = 1, statInterpolation = { 3, 1, 1, }, cost = { }, },
		[2] = { 16.666667039196, 6000, 1, damageEffectiveness = 0.6, cooldown = 6, baseMultiplier = 0.6, levelRequirement = 45, statInterpolation = { 3, 1, 1, }, cost = { }, },
		[3] = { 16.666667039196, 6000, 1, damageEffectiveness = 0.6, cooldown = 6, baseMultiplier = 0.6, levelRequirement = 68, statInterpolation = { 3, 1, 1, }, cost = { }, },
		[4] = { 16.666667039196, 6000, 1, damageEffectiveness = 0.6, cooldown = 6, baseMultiplier = 0.6, levelRequirement = 84, statInterpolation = { 3, 1, 1, }, cost = { }, },
	},
}
skills["KitavaDemonXMortar"] = {
	name = "Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.5,
	incrementalEffectiveness = 0.035000000149012,
	skillTypes = { [SkillType.Projectile] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"monster_projectile_variation",
		"spell_maximum_action_distance_+%",
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"projectile_minimum_range",
		"projectile_spread_radius",
		"projectile_spread_radius_per_additional_projectile",
		"base_is_projectile",
		"is_area_damage",
	},
	levels = {
		[1] = { 2, 500, 0.80000001192093, 1.2000000476837, 10, 0, 125, cooldown = 3, levelRequirement = 1, statInterpolation = { 1, 1, 3, 3, 1, 1, 1, }, cost = { }, },
		[2] = { 2, 500, 0.54000002145767, 0.80000001192093, 10, 0, 125, cooldown = 3, levelRequirement = 68, statInterpolation = { 1, 1, 3, 3, 1, 1, 1, }, cost = { }, },
	},
}
skills["MassFrenzy"] = {
	name = "Mass Frenzy",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.8700000047684,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 6, levelRequirement = 0, statInterpolation = { }, cost = { }, },
	},
}
skills["MassPower"] = {
	name = "Mass Power",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.8700000047684,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 6, levelRequirement = 0, statInterpolation = { }, cost = { }, },
	},
}
skills["MinerThrowFireSpectre"] = {
	name = "Throw Fire",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.2777999639511,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_fire_damage_to_deal_per_minute",
		"base_skill_effect_duration",
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_is_projectile",
		"is_area_damage",
	},
	levels = {
		[1] = { 26.666667660077, 2000, 0.20000000298023, 0.30000001192093, cooldown = 1.5, levelRequirement = 3, statInterpolation = { 3, 1, 3, 3, }, cost = { }, },
		[2] = { 26.666667660077, 2100, 0.20000000298023, 0.30000001192093, cooldown = 1.5, levelRequirement = 5, statInterpolation = { 3, 1, 3, 3, }, cost = { }, },
		[3] = { 26.666667660077, 2200, 0.20000000298023, 0.30000001192093, cooldown = 1.5, levelRequirement = 8, statInterpolation = { 3, 1, 3, 3, }, cost = { }, },
		[4] = { 26.666667660077, 2300, 0.20000000298023, 0.30000001192093, cooldown = 1.5, levelRequirement = 11, statInterpolation = { 3, 1, 3, 3, }, cost = { }, },
		[5] = { 26.666667660077, 2400, 0.20000000298023, 0.30000001192093, cooldown = 1.5, levelRequirement = 15, statInterpolation = { 3, 1, 3, 3, }, cost = { }, },
		[6] = { 26.666667660077, 2500, 0.20000000298023, 0.30000001192093, cooldown = 1.5, levelRequirement = 19, statInterpolation = { 3, 1, 3, 3, }, cost = { }, },
		[7] = { 26.666667660077, 2600, 0.20000000298023, 0.30000001192093, cooldown = 1.5, levelRequirement = 23, statInterpolation = { 3, 1, 3, 3, }, cost = { }, },
		[8] = { 26.666667660077, 2700, 0.20000000298023, 0.30000001192093, cooldown = 1.5, levelRequirement = 27, statInterpolation = { 3, 1, 3, 3, }, cost = { }, },
		[9] = { 26.666667660077, 2800, 0.20000000298023, 0.30000001192093, cooldown = 1.5, levelRequirement = 28, statInterpolation = { 3, 1, 3, 3, }, cost = { }, },
		[10] = { 26.666667660077, 2900, 0.20000000298023, 0.30000001192093, cooldown = 1.5, levelRequirement = 32, statInterpolation = { 3, 1, 3, 3, }, cost = { }, },
		[11] = { 26.666667660077, 3000, 0.20000000298023, 0.30000001192093, cooldown = 1.5, levelRequirement = 40, statInterpolation = { 3, 1, 3, 3, }, cost = { }, },
		[12] = { 26.666667660077, 4000, 0.20000000298023, 0.30000001192093, cooldown = 1.5, levelRequirement = 79, statInterpolation = { 3, 1, 3, 3, }, cost = { }, },
	},
}
skills["MonsterArc"] = {
	name = "Arc",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.89999997615814,
	incrementalEffectiveness = 0.046000000089407,
	description = "An arc of lightning stretches from the caster to a targeted enemy and chains on to other nearby enemies. Each time the main beam chains it will also chain to a second enemy, but that secondary arc cannot chain further.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Chains] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "beam_skill_stat_descriptions",
	castTime = 0.8,
	baseFlags = {
		spell = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_chance_to_shock_%",
		"number_of_chains",
		"skill_range_+%",
	},
	levels = {
		[1] = { 0.5, 1.5, 10, 1, -50, damageEffectiveness = 0.7, critChance = 5, levelRequirement = 3, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 20, }, },
		[2] = { 0.5, 1.5, 10, 1, -50, damageEffectiveness = 0.7, critChance = 5, levelRequirement = 8, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 19, }, },
		[3] = { 0.5, 1.5, 10, 1, -50, damageEffectiveness = 0.7, critChance = 5, levelRequirement = 12, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 18, }, },
		[4] = { 0.5, 1.5, 10, 1, -50, damageEffectiveness = 0.7, critChance = 5, levelRequirement = 25, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 17, }, },
		[5] = { 0.5, 1.5, 10, 1, -50, damageEffectiveness = 0.7, critChance = 5, levelRequirement = 32, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 16, }, },
		[6] = { 0.5, 1.5, 10, 1, -50, damageEffectiveness = 0.7, critChance = 5, levelRequirement = 70, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { Mana = 16, }, },
	},
}
skills["MonsterCausticArrow"] = {
	name = "Caustic Arrow",
	hidden = true,
	color = 2,
	baseEffectiveness = 1.0666999816895,
	incrementalEffectiveness = 0.03999999910593,
	description = "Fires an arrow which deals chaos damage in an area on impact, and spreads caustic ground. Enemies standing on the caustic ground take chaos damage over time.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.DamageOverTime] = true, [SkillType.Chaos] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"base_chaos_damage_to_deal_per_minute",
		"physical_damage_%_to_add_as_chaos",
		"skill_can_fire_arrows",
		"active_skill_area_of_effect_radius_+%_final",
		"monster_penalty_against_minions_damage_+%_final_vs_player_minions",
		"ground_caustic_art_variation",
		"projectile_damage_modifiers_apply_to_skill_dot",
		"visual_hit_effect_chaos_is_green",
	},
	levels = {
		[1] = { 1200, 16.666667039196, 34, 1, 0, -25, 2, levelRequirement = 3, statInterpolation = { 1, 3, 1, 1, 1, 1, 1, }, cost = { Mana = 10, }, },
		[2] = { 1200, 16.666667039196, 34, 1, 0, -25, 2, levelRequirement = 12, statInterpolation = { 1, 3, 1, 1, 1, 1, 1, }, cost = { Mana = 9, }, },
		[3] = { 1200, 16.666667039196, 34, 1, 0, -25, 2, levelRequirement = 26, statInterpolation = { 1, 3, 1, 1, 1, 1, 1, }, cost = { Mana = 8, }, },
		[4] = { 1200, 16.666667039196, 34, 1, 0, -25, 2, levelRequirement = 67, statInterpolation = { 1, 3, 1, 1, 1, 1, 1, }, cost = { Mana = 8, }, },
		[5] = { 2400, 23.33333345751, 34, 1, 0, -25, 2, levelRequirement = 68, statInterpolation = { 1, 3, 1, 1, 1, 1, 1, }, cost = { Mana = 8, }, },
		[6] = { 2500, 23.33333345751, 34, 1, 0, -25, 2, levelRequirement = 69, statInterpolation = { 1, 3, 1, 1, 1, 1, 1, }, cost = { Mana = 8, }, },
		[7] = { 2600, 23.33333345751, 34, 1, 0, -25, 2, levelRequirement = 70, statInterpolation = { 1, 3, 1, 1, 1, 1, 1, }, cost = { Mana = 8, }, },
		[8] = { 2700, 23.33333345751, 34, 1, 0, -25, 2, levelRequirement = 71, statInterpolation = { 1, 3, 1, 1, 1, 1, 1, }, cost = { Mana = 8, }, },
		[9] = { 2800, 23.33333345751, 34, 1, 0, -25, 2, levelRequirement = 72, statInterpolation = { 1, 3, 1, 1, 1, 1, 1, }, cost = { Mana = 8, }, },
		[10] = { 2900, 23.33333345751, 34, 1, 0, -25, 2, levelRequirement = 73, statInterpolation = { 1, 3, 1, 1, 1, 1, 1, }, cost = { Mana = 8, }, },
		[11] = { 3000, 23.33333345751, 34, 1, 0, -25, 2, levelRequirement = 74, statInterpolation = { 1, 3, 1, 1, 1, 1, 1, }, cost = { Mana = 8, }, },
	},
}
skills["MonsterCausticArrowAtAnimationSpeed"] = {
	name = "Caustic Arrow",
	hidden = true,
	color = 2,
	baseEffectiveness = 1.0666999816895,
	incrementalEffectiveness = 0.03999999910593,
	description = "Fires an arrow which deals chaos damage in an area on impact, and spreads caustic ground. Enemies standing on the caustic ground take chaos damage over time.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.DamageOverTime] = true, [SkillType.Chaos] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"base_chaos_damage_to_deal_per_minute",
		"physical_damage_%_to_add_as_chaos",
		"skill_can_fire_arrows",
		"active_skill_area_of_effect_radius_+%_final",
		"monster_penalty_against_minions_damage_+%_final_vs_player_minions",
		"ground_caustic_art_variation",
		"projectile_damage_modifiers_apply_to_skill_dot",
		"visual_hit_effect_chaos_is_green",
		"action_attack_or_cast_time_uses_animation_length",
	},
	levels = {
		[1] = { 2250, 25.000000558794, 34, 1, 0, -25, 2, levelRequirement = 3, statInterpolation = { 1, 3, 1, 1, 1, 1, 1, }, cost = { }, },
		[2] = { 2250, 25.000000558794, 34, 1, 0, -25, 2, levelRequirement = 68, statInterpolation = { 1, 3, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["MonsterCausticBomb"] = {
	name = "Caustic Bomb",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.2667000293732,
	incrementalEffectiveness = 0.038499999791384,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Damage] = true, [SkillType.Mineable] = true, [SkillType.Area] = true, [SkillType.Trapped] = true, [SkillType.DamageOverTime] = true, [SkillType.Chaos] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		trap = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_trap_duration",
		"base_skill_effect_duration",
		"spell_minimum_base_chaos_damage",
		"spell_maximum_base_chaos_damage",
		"base_chaos_damage_to_deal_per_minute",
		"trap_variation",
		"monster_penalty_against_minions_damage_+%_final_vs_player_minions",
		"ground_caustic_art_variation",
		"is_trap",
		"is_area_damage",
		"base_skill_is_trapped",
		"ignores_trap_and_mine_cooldown_limit",
	},
	levels = {
		[1] = { 2500, 4000, 0.30000001192093, 0.40000000596046, 16.666667039196, 2, -25, 2, critChance = 5, cooldown = 4, levelRequirement = 4, statInterpolation = { 1, 1, 3, 3, 3, 1, 1, 1, }, cost = { }, },
		[2] = { 2500, 4000, 0.30000001192093, 0.40000000596046, 16.666667039196, 2, -25, 2, critChance = 5, cooldown = 4, levelRequirement = 7, statInterpolation = { 1, 1, 3, 3, 3, 1, 1, 1, }, cost = { }, },
		[3] = { 2500, 4000, 0.30000001192093, 0.40000000596046, 16.666667039196, 2, -25, 2, critChance = 5, cooldown = 4, levelRequirement = 12, statInterpolation = { 1, 1, 3, 3, 3, 1, 1, 1, }, cost = { }, },
		[4] = { 2500, 4000, 0.30000001192093, 0.40000000596046, 16.666667039196, 2, -25, 2, critChance = 5, cooldown = 4, levelRequirement = 16, statInterpolation = { 1, 1, 3, 3, 3, 1, 1, 1, }, cost = { }, },
		[5] = { 2500, 4000, 0.30000001192093, 0.40000000596046, 16.666667039196, 2, -25, 2, critChance = 5, cooldown = 4, levelRequirement = 20, statInterpolation = { 1, 1, 3, 3, 3, 1, 1, 1, }, cost = { }, },
		[6] = { 2500, 4000, 0.30000001192093, 0.40000000596046, 16.666667039196, 2, -25, 2, critChance = 5, cooldown = 4, levelRequirement = 76, statInterpolation = { 1, 1, 3, 3, 3, 1, 1, 1, }, cost = { }, },
	},
}
skills["MonsterDischarge"] = {
	name = "Discharge",
	hidden = true,
	color = 3,
	baseEffectiveness = 2.2111001014709,
	incrementalEffectiveness = 0.028500000014901,
	description = "Discharge all the character's charges to deal elemental damage to all nearby monsters.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Cold] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Nova] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage_per_removable_power_charge",
		"spell_maximum_base_lightning_damage_per_removable_power_charge",
		"spell_minimum_base_fire_damage_per_removable_endurance_charge",
		"spell_maximum_base_fire_damage_per_removable_endurance_charge",
		"spell_minimum_base_cold_damage_per_removable_frenzy_charge",
		"spell_maximum_base_cold_damage_per_removable_frenzy_charge",
		"spell_maximum_action_distance_+%",
		"skill_art_variation",
		"is_area_damage",
		"disable_skill_repeats",
	},
	levels = {
		[1] = { 0.56000000238419, 1.6900000572205, 0.80000001192093, 1.2000000476837, 0.64999997615814, 0.98000001907349, -75, 1, damageEffectiveness = 1.5, critChance = 4, levelRequirement = 4, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, cost = { }, },
		[2] = { 0.62000000476837, 1.8500000238419, 0.87999999523163, 1.3200000524521, 0.72000002861023, 1.0800000429153, -75, 1, damageEffectiveness = 1.5, critChance = 4, levelRequirement = 68, statInterpolation = { 3, 3, 3, 3, 3, 3, 1, 1, }, cost = { }, },
	},
}
skills["MonsterEnduringCry"] = {
	name = "Enduring Cry",
	hidden = true,
	color = 1,
	baseEffectiveness = 0,
	description = "Performs a warcry, taunting all nearby enemies to attack the user and granting endurance charges. Gives a brief burst of life regeneration, as well as a buff which grants resistances and physical damage reduction based on your endurance charges.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Warcry] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 0.8,
	baseFlags = {
		warcry = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"enduring_cry_grants_x_additional_endurance_charges",
		"base_skill_effect_duration",
		"life_regeneration_rate_per_minute_%",
	},
	levels = {
		[1] = { 2, 1000, 600, cooldown = 8, levelRequirement = 4, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[2] = { 2, 1000, 600, cooldown = 8, levelRequirement = 7, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[3] = { 2, 1000, 600, cooldown = 8, levelRequirement = 10, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[4] = { 2, 1000, 600, cooldown = 8, levelRequirement = 14, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[5] = { 2, 1000, 600, cooldown = 8, levelRequirement = 18, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[6] = { 2, 1000, 600, cooldown = 8, levelRequirement = 22, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[7] = { 2, 1000, 600, cooldown = 8, levelRequirement = 24, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[8] = { 2, 1000, 600, cooldown = 8, levelRequirement = 28, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[9] = { 2, 1000, 600, cooldown = 8, levelRequirement = 32, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[10] = { 2, 1000, 600, cooldown = 8, levelRequirement = 36, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[11] = { 2, 1000, 600, cooldown = 8, levelRequirement = 40, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[12] = { 2, 1000, 600, cooldown = 8, levelRequirement = 44, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[13] = { 2, 1000, 600, cooldown = 8, levelRequirement = 48, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[14] = { 2, 1000, 600, cooldown = 8, levelRequirement = 52, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[15] = { 2, 1000, 600, cooldown = 8, levelRequirement = 56, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[16] = { 2, 1000, 600, cooldown = 8, levelRequirement = 60, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[17] = { 2, 1000, 600, cooldown = 8, levelRequirement = 63, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[18] = { 2, 1000, 600, cooldown = 8, levelRequirement = 66, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[19] = { 2, 1000, 600, cooldown = 8, levelRequirement = 67, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[20] = { 2, 1000, 600, cooldown = 8, levelRequirement = 68, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[21] = { 2, 1000, 600, cooldown = 8, levelRequirement = 69, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[22] = { 2, 1000, 600, cooldown = 8, levelRequirement = 70, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[23] = { 2, 1000, 600, cooldown = 8, levelRequirement = 71, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[24] = { 2, 1000, 600, cooldown = 8, levelRequirement = 72, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[25] = { 2, 1000, 600, cooldown = 8, levelRequirement = 73, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[26] = { 2, 1000, 600, cooldown = 8, levelRequirement = 74, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[27] = { 2, 1000, 600, cooldown = 8, levelRequirement = 75, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[28] = { 2, 1000, 600, cooldown = 8, levelRequirement = 76, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[29] = { 2, 1000, 600, cooldown = 8, levelRequirement = 77, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[30] = { 2, 1000, 600, cooldown = 8, levelRequirement = 78, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[31] = { 2, 1000, 600, cooldown = 8, levelRequirement = 79, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[32] = { 2, 1000, 600, cooldown = 8, levelRequirement = 80, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[33] = { 2, 1000, 600, cooldown = 8, levelRequirement = 81, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[34] = { 2, 1000, 600, cooldown = 8, levelRequirement = 82, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["AxisEnfeeble"] = {
	name = "Enfeeble",
	hidden = true,
	color = 3,
	baseEffectiveness = 0,
	description = "Curses all targets in an area, reducing their accuracy and making them deal less damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["enfeeble_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique", neg = true }),
		},
		["enfeeble_damage_+%_vs_rare_or_unique_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique" }),
		},
		["accuracy_rating_+%"] = {
			mod("Accuracy", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"active_skill_area_of_effect_radius_+%_final",
		"accuracy_rating_+%",
		"enfeeble_damage_+%_final",
		"enfeeble_damage_+%_vs_rare_or_unique_final",
	},
	levels = {
		[1] = { 5000, 0, -40, -40, -15, cooldown = 10, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["MonsterFireballContactPos"] = {
	name = "Fireball",
	hidden = true,
	color = 3,
	baseEffectiveness = 2.5,
	incrementalEffectiveness = 0.03940000012517,
	description = "Unleashes a ball of fire towards a target which explodes, damaging nearby foes.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.33,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"spell_maximum_action_distance_+%",
		"base_is_projectile",
		"use_scaled_contact_offset",
		"projectile_uses_contact_position",
		"maintain_projectile_direction_when_using_contact_position",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, -50, critChance = 6, levelRequirement = 3, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[2] = { 1.9400000572205, 3.0099999904633, -50, critChance = 6, levelRequirement = 68, statInterpolation = { 3, 3, 1, }, cost = { }, },
	},
}
skills["MonsterFireBomb"] = {
	name = "Fire Bomb",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.8889000415802,
	incrementalEffectiveness = 0.052000001072884,
	description = "Throws a trap that explodes when triggered, dealing fire damage to surrounding enemies and leaving an area of burning ground that damages enemies who walk through it.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Duration] = true, [SkillType.Damage] = true, [SkillType.Mineable] = true, [SkillType.Area] = true, [SkillType.CausesBurning] = true, [SkillType.Trapped] = true, [SkillType.DamageOverTime] = true, [SkillType.Fire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		trap = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_trap_duration",
		"base_skill_effect_duration",
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_fire_damage_to_deal_per_minute",
		"trap_variation",
		"monster_penalty_against_minions_damage_+%_final_vs_player_minions",
		"is_trap",
		"is_area_damage",
		"base_skill_is_trapped",
		"ignores_trap_and_mine_cooldown_limit",
	},
	levels = {
		[1] = { 2500, 4500, 0.40000000596046, 0.60000002384186, 16.666667039196, 1, -25, critChance = 5, levelRequirement = 4, statInterpolation = { 1, 1, 3, 3, 3, 1, 1, }, cost = { }, },
		[2] = { 2500, 4500, 0.56000000238419, 0.83999997377396, 23.33333345751, 1, -25, critChance = 5, levelRequirement = 68, statInterpolation = { 1, 1, 3, 3, 3, 1, 1, }, cost = { }, },
	},
}
skills["MonsterFlickerStrike"] = {
	name = "Flicker Strike",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Teleports the character to a nearby monster and attacks with a melee weapon. If no specific monster is targeted, one is picked at random. Grants a buff that increases movement speed for a duration. The cooldown can be bypassed by expending a Frenzy Charge.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Movement] = true, [SkillType.Duration] = true, [SkillType.Cooldown] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		movement = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"attack_speed_+%",
		"base_attack_speed_+%_per_frenzy_charge",
		"physical_damage_+%",
		"active_skill_damage_+%_final",
		"ignores_proximity_shield",
		"melee_defer_damage_prediction",
	},
	levels = {
		[1] = { 30, 10, 0, 10, cooldown = 2, levelRequirement = 13, statInterpolation = { 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["MonsterFlameRedCannibal"] = {
	name = "Incinerate",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.3999999761581,
	incrementalEffectiveness = 0.037000000476837,
	description = "Summons a totem that fires a stream of flame at nearby enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.SummonsTotem] = true, [SkillType.Fire] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	skillTotemId = 8,
	castTime = 0.333,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"skill_repeat_count",
		"skill_art_variation",
		"spell_maximum_action_distance_+%",
		"active_skill_cast_speed_+%_final",
		"monster_penalty_against_minions_damage_+%_final_vs_player_minions",
		"number_of_additional_projectiles",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"always_pierce",
		"use_scaled_contact_offset",
	},
	levels = {
		[1] = { 0.30000001192093, 0.60000002384186, 2, 2, -75, 0, -25, 3, damageEffectiveness = 0.25, levelRequirement = 3, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["MonsterIceShot"] = {
	name = "Ice Shot",
	hidden = true,
	color = 2,
	baseEffectiveness = 0.85000002384186,
	description = "Fires an arrow that converts some physical damage to cold on its target and converts all physical damage to cold in a cone behind that target.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Area] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Cold] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_cold",
		"base_skill_effect_duration",
		"physical_damage_+%",
		"active_skill_damage_+%_final",
		"skill_art_variation",
		"skill_can_fire_arrows",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	levels = {
		[1] = { 50, 2500, 15, 0, 2, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { }, },
		[2] = { 50, 2500, 50, 0, 2, levelRequirement = 68, statInterpolation = { 1, 1, 2, 1, 1, }, cost = { }, },
	},
}
skills["MountainGoatmanIceSpear"] = {
	name = "Ice Spear",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.1817998886108,
	incrementalEffectiveness = 0.037999998778105,
	description = "Launches shards of ice in rapid succession. After travelling a short distance they change to a second form, which moves much faster and pierces through enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cold] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.33,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"active_skill_chill_duration_+%_final",
		"ice_spear_second_form_damage_+%",
		"base_is_projectile",
		"projectile_uses_contact_position",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 20, 50, critChance = 7, levelRequirement = 40, statInterpolation = { 3, 3, 1, 1, }, cost = { }, },
		[2] = { 0.80000001192093, 1.2000000476837, 20, 25, critChance = 7, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, }, cost = { }, },
	},
}
skills["MonsterLeapSlam"] = {
	name = "Leap Slam",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Jump into the air, damaging and knocking back enemies with your weapon where you land. Enemies you would land on are pushed out of the way. Requires an Axe, Mace, Sceptre, Sword or Staff. Cannot be supported by Multistrike.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.4,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_art_variation",
		"is_area_damage",
		"cast_time_overrides_attack_duration",
	},
	levels = {
		[1] = { 1, damageEffectiveness = 1.5, baseMultiplier = 1.5, levelRequirement = 2, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["MonsterLeapSlamFoothills"] = {
	name = "Leap Slam",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Jump into the air, damaging and knocking back enemies with your weapon where you land. Enemies you would land on are pushed out of the way. Requires an Axe, Mace, Sceptre, Sword or Staff. Cannot be supported by Multistrike.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.4,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_art_variation",
		"leapslam_overshoot_distance",
		"is_area_damage",
		"cast_time_overrides_attack_duration",
	},
	levels = {
		[1] = { 1, 10, damageEffectiveness = 1.5, baseMultiplier = 1.5, levelRequirement = 2, statInterpolation = { 1, 1, }, cost = { }, },
	},
}
skills["MonsterLesserMultiFireballSpectre"] = {
	name = "Lesser Multi Fireball",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.88889998197556,
	incrementalEffectiveness = 0.03940000012517,
	description = "Unleashes a ball of fire towards a target which explodes, damaging nearby foes.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.85,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_is_projectile",
		"spell_maximum_action_distance_+%",
		"number_of_additional_projectiles",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 1, -50, 1, critChance = 6, levelRequirement = 3, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
		[2] = { 1.7599999904633, 2.6400001049042, 1, -50, 1, critChance = 6, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
	},
}
skills["MonsterLesserMultiIceSpear"] = {
	name = "Lesser Multi Ice Spear",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.5908999443054,
	incrementalEffectiveness = 0.03999999910593,
	description = "Launches shards of ice in rapid succession. After travelling a short distance they change to a second form, which moves much faster and pierces through enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cold] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.85,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"ice_spear_second_form_damage_+%",
		"number_of_additional_projectiles",
		"base_is_projectile",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 50, 1, damageEffectiveness = 0.8, critChance = 7, levelRequirement = 3, statInterpolation = { 3, 3, 1, 1, }, cost = { }, },
		[2] = { 0.80000001192093, 1.2000000476837, 50, 1, damageEffectiveness = 0.8, critChance = 7, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, }, cost = { }, },
	},
}
skills["MonsterLightningArrow"] = {
	name = "Lightning Arrow",
	hidden = true,
	color = 2,
	baseEffectiveness = 1.0199999809265,
	incrementalEffectiveness = 0.019999999552965,
	description = "Fires a charged arrow at the target, causing them to be struck by a bolt of lightning which damages nearby enemies.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Area] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Lightning] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_lightning",
		"lightning_arrow_maximum_number_of_extra_targets",
		"base_chance_to_shock_%",
		"active_skill_area_of_effect_radius_+%_final",
	},
	levels = {
		[1] = { 50, 4, 25, 0, levelRequirement = 9, statInterpolation = { 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["SkeletonArcherLightningArrow"] = {
	name = "Lightning Arrow",
	hidden = true,
	color = 2,
	baseEffectiveness = 1.0199999809265,
	incrementalEffectiveness = 0.019999999552965,
	description = "Fires a charged arrow at the target, causing them to be struck by a bolt of lightning which damages nearby enemies.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Area] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Lightning] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_lightning",
		"lightning_arrow_maximum_number_of_extra_targets",
		"base_chance_to_shock_%",
		"active_skill_area_of_effect_radius_+%_final",
	},
	levels = {
		[1] = { 50, 4, 50, 0, baseMultiplier = 1.25, levelRequirement = 9, statInterpolation = { 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["MonsterLightningThorns"] = {
	name = "Lightning Thorns",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.7999999523163,
	incrementalEffectiveness = 0.034000001847744,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Duration] = true, [SkillType.Lightning] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
	},
	levels = {
		[1] = { 3500, cooldown = 3.5, levelRequirement = 3, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["MonsterMultiFireballSpectre"] = {
	name = "Multi Fireball",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.77780002355576,
	incrementalEffectiveness = 0.03940000012517,
	description = "Unleashes a ball of fire towards a target which explodes, damaging nearby foes.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.85,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_is_projectile",
		"spell_maximum_action_distance_+%",
		"number_of_additional_projectiles",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 1, -50, 2, critChance = 6, levelRequirement = 3, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
		[2] = { 1.7599999904633, 2.6400001049042, 1, -50, 2, critChance = 6, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
	},
}
skills["MonsterMultiIceSpear"] = {
	name = "Multi Ice Spear",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.5908999443054,
	incrementalEffectiveness = 0.03999999910593,
	description = "Launches shards of ice in rapid succession. After travelling a short distance they change to a second form, which moves much faster and pierces through enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cold] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.85,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"ice_spear_second_form_damage_+%",
		"number_of_additional_projectiles",
		"base_is_projectile",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 50, 2, damageEffectiveness = 0.8, critChance = 7, levelRequirement = 3, statInterpolation = { 3, 3, 1, 1, }, cost = { }, },
		[2] = { 0.80000001192093, 1.2000000476837, 50, 2, damageEffectiveness = 0.8, critChance = 7, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, }, cost = { }, },
	},
}
skills["MonsterProjectileWeakness"] = {
	name = "Projectile Weakness",
	hidden = true,
	color = 2,
	baseEffectiveness = 0,
	description = "Curses a single enemy, increasing the damage they take from projectiles, and making projectiles split when hitting them, to hit other targets around them. You can gain charges for your life and mana flasks by hitting the cursed enemy. You can only have one Mark at a time.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Mark] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["projectile_damage_taken_+%"] = {
			mod("ProjectileDamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"projectiles_hitting_self_split_into_x",
		"projectile_damage_taken_+%",
		"grant_attacker_x_mana_flask_charges_when_hit_once_per_500ms",
		"grant_attacker_x_life_flask_charges_when_hit_once_per_500ms",
	},
	levels = {
		[1] = { 6000, 3, 32, 0, 0, cooldown = 12, levelRequirement = 25, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { }, },
		[2] = { 6000, 3, 34, 0, 0, cooldown = 12, levelRequirement = 55, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { }, },
		[3] = { 6000, 3, 34, 0, 0, cooldown = 12, levelRequirement = 60, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["MonsterProximityShield"] = {
	name = "Proximity Shield",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
	},
	levels = {
		[1] = { 8000, cooldown = 18, levelRequirement = 0, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["MonsterPuncture"] = {
	name = "Puncture",
	hidden = true,
	color = 2,
	baseEffectiveness = 0,
	description = "Punctures enemies, causing a bleeding debuff, which will be affected by modifiers to skill duration. Puncture works with bows, daggers, claws or swords.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.DamageOverTime] = true, [SkillType.Triggerable] = true, [SkillType.Physical] = true, },
	weaponTypes = {
		["Bow"] = true,
		["Claw"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	baseMods = {
		mod("BleedChance", "BASE", 100),
	},
	qualityStats = {
	},
	stats = {
		"active_skill_bleeding_damage_+%_final",
		"skill_can_fire_arrows",
		"global_bleed_on_hit",
	},
	levels = {
		[1] = { 112, baseMultiplier = 1.2, levelRequirement = 9, statInterpolation = { 1, }, cost = { }, },
		[2] = { 155, baseMultiplier = 1.2, levelRequirement = 30, statInterpolation = { 1, }, cost = { }, },
		[3] = { 197, baseMultiplier = 1.2, levelRequirement = 60, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["MonsterRighteousFireWhileSpectred"] = {
	name = "Unrighteous Fire",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.1110999584198,
	incrementalEffectiveness = 0.056000001728535,
	description = "Engulfs you in magical fire that rapidly burns you and nearby enemies. Your spell damage is substantially increased while under this effect. The effect ends when you have 1 life remaining.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.CausesBurning] = true, [SkillType.DamageOverTime] = true, [SkillType.Fire] = true, [SkillType.Totemable] = true, [SkillType.Triggerable] = true, [SkillType.Instant] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "buff_skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_fire_damage_to_deal_per_minute",
		"skill_art_variation",
		"active_skill_area_of_effect_radius_+%_final",
	},
	levels = {
		[1] = { 16.666667039196, 1, 0, levelRequirement = 3, statInterpolation = { 3, 1, 1, }, cost = { }, },
	},
}
skills["MonsterShockNova"] = {
	name = "Shock Nova",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.2374999523163,
	incrementalEffectiveness = 0.0304000005126,
	description = "Casts a ring of Lightning around you, followed by a larger Lightning nova. Each effect hits enemies caught in their area with Lightning Damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Nova] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.75,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"newshocknova_first_ring_damage_+%_final",
		"base_chance_to_shock_%",
		"shock_effect_+%",
		"active_skill_area_of_effect_radius_+%_final",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, -50, 50, 20, 0, critChance = 3, levelRequirement = 4, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[2] = { 1.460000038147, 4.3899998664856, -50, 50, 20, 0, critChance = 3, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["MonsterSpark"] = {
	name = "Spark",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.5625,
	incrementalEffectiveness = 0.035000000149012,
	description = "Launches unpredictable sparks that move randomly until they hit an enemy or expire.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.65,
	baseFlags = {
		spell = true,
		projectile = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_skill_effect_duration",
		"base_is_projectile",
		"number_of_additional_projectiles",
	},
	levels = {
		[1] = { 0.5, 1.5, 2000, 1, 1, damageEffectiveness = 0.7, critChance = 5, levelRequirement = 4, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
		[2] = { 0.5, 1.5, 2000, 1, 1, damageEffectiveness = 0.7, critChance = 5, levelRequirement = 8, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
		[3] = { 0.5, 1.5, 2000, 1, 1, damageEffectiveness = 0.7, critChance = 5, levelRequirement = 11, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
		[4] = { 0.5, 1.5, 2000, 1, 1, damageEffectiveness = 0.7, critChance = 5, levelRequirement = 25, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
		[5] = { 0.5, 1.5, 2000, 1, 1, damageEffectiveness = 0.7, critChance = 5, levelRequirement = 29, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
		[6] = { 0.5, 1.5, 2000, 1, 1, damageEffectiveness = 0.7, critChance = 5, levelRequirement = 31, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
		[7] = { 0.5, 1.5, 2000, 1, 1, damageEffectiveness = 0.7, critChance = 5, levelRequirement = 66, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
		[8] = { 1.1000000238419, 3.2999999523163, 2000, 1, 1, damageEffectiveness = 0.7, critChance = 5, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
	},
}
skills["MonsterSplitFireballSpectre"] = {
	name = "Split Fireball",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.95560002326965,
	incrementalEffectiveness = 0.03940000012517,
	description = "Unleashes a ball of fire towards a target which explodes, damaging nearby foes.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.85,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_is_projectile",
		"spell_maximum_action_distance_+%",
		"projectiles_fork",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 1, -50, critChance = 6, levelRequirement = 3, statInterpolation = { 3, 3, 1, 1, }, cost = { }, },
		[2] = { 1.7599999904633, 2.6400001049042, 1, -50, critChance = 6, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, }, cost = { }, },
	},
}
skills["MonsterSplitIceSpear"] = {
	name = "Split Ice Spear",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.5908999443054,
	incrementalEffectiveness = 0.03999999910593,
	description = "Launches shards of ice in rapid succession. After travelling a short distance they change to a second form, which moves much faster and pierces through enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cold] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.85,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"ice_spear_second_form_damage_+%",
		"base_is_projectile",
		"projectiles_fork",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 50, damageEffectiveness = 0.8, critChance = 7, levelRequirement = 3, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[2] = { 0.80000001192093, 1.2000000476837, 50, damageEffectiveness = 0.8, critChance = 7, levelRequirement = 68, statInterpolation = { 3, 3, 1, }, cost = { }, },
	},
}
skills["MonsterWarlordsMark"] = {
	name = "Warlord's Mark",
	hidden = true,
	color = 1,
	baseEffectiveness = 0,
	description = "Curses a single enemy, giving a chance to double the duration of stuns on them. Attacking the cursed enemy will leech life and mana, stunning them will grant rage, and killing it will grant an endurance charge. You can only have one Mark at a time.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Mark] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["life_leech_on_any_damage_when_hit_by_attack_permyriad"] = {
			mod("SelfDamageLifeLeech", "BASE", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["mana_leech_on_any_damage_when_hit_by_attack_permyriad"] = {
			mod("SelfDamageManaLeech", "BASE", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["enemy_rage_regeneration_on_stun"] = {
			flag("Condition:CanGainRage", { type = "GlobalEffect", effectType = "Buff" } ),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"enemy_chance_to_double_stun_duration_%_vs_self",
		"enemy_rage_regeneration_on_stun",
		"life_leech_on_any_damage_when_hit_by_attack_permyriad",
		"mana_leech_on_any_damage_when_hit_by_attack_permyriad",
		"chance_to_grant_endurance_charge_on_death_%",
	},
	levels = {
		[1] = { 4000, 40, 0, 200, 200, 100, cooldown = 8, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["MotherOfFlamesMagmaOrb3"] = {
	name = "Rolling Magma",
	hidden = true,
	color = 3,
	baseEffectiveness = 2.7778000831604,
	incrementalEffectiveness = 0.035500001162291,
	description = "Lob a fiery orb that explodes as it hits the ground. The skill chains, releasing another fiery orb that repeats this effect.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Multicastable] = true, [SkillType.Chains] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.7,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"projectile_spread_radius",
		"number_of_additional_projectiles",
		"fire_mortar_second_hit_damage_+%_final",
		"base_cast_speed_+%",
		"number_of_chains",
		"is_area_damage",
		"base_is_projectile",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 0, 0, 0, -66, 2, critChance = 5, cooldown = 3, levelRequirement = 1, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, cost = { }, },
		[2] = { 0.80000001192093, 1.2000000476837, 0, 0, 0, -66, 2, critChance = 5, cooldown = 3, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["NecromancerConductivity"] = {
	name = "Conductivity",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.85000002384186,
	description = "Curses all targets in an area, lowering their lightning resistance and giving them a chance to be shocked when hit.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 1.1,
	statMap = {
		["base_lightning_damage_resistance_%"] = {
			mod("LightningResist", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["chance_to_be_shocked_%"] = {
			mod("SelfShockChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"active_skill_area_of_effect_radius_+%_final",
		"base_lightning_damage_resistance_%",
		"chance_to_be_shocked_%",
		"skill_art_variation",
	},
	levels = {
		[1] = { 6000, 0, -20, 25, 1, cooldown = 10, levelRequirement = 10, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { }, },
		[2] = { 6000, 0, -25, 25, 1, cooldown = 10, levelRequirement = 41, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { }, },
		[3] = { 6000, 0, -30, 25, 1, cooldown = 10, levelRequirement = 58, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { }, },
		[4] = { 6000, 0, -40, 25, 1, cooldown = 10, levelRequirement = 71, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["NecromancerElementalWeakness"] = {
	name = "Elemental Weakness",
	hidden = true,
	color = 3,
	baseEffectiveness = 0,
	description = "Curses all targets in an area, lowering their elemental resistances.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 1.1,
	statMap = {
		["base_resist_all_elements_%"] = {
			mod("ElementalResist", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"active_skill_area_of_effect_radius_+%_final",
		"base_resist_all_elements_%",
		"chance_to_be_shocked_%",
		"chance_to_be_frozen_%",
		"chance_to_be_ignited_%",
		"skill_art_variation",
	},
	levels = {
		[1] = { 6000, 0, -20, 0, 0, 0, 1, cooldown = 10, levelRequirement = 10, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[2] = { 6000, 0, -25, 0, 0, 0, 1, cooldown = 10, levelRequirement = 40, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[3] = { 6000, 0, -30, 0, 0, 0, 1, cooldown = 10, levelRequirement = 56, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[4] = { 6000, 0, -40, 0, 0, 0, 1, cooldown = 10, levelRequirement = 71, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["NecromancerEnfeeble"] = {
	name = "Enfeeble",
	hidden = true,
	color = 3,
	baseEffectiveness = 0,
	description = "Curses all targets in an area, reducing their accuracy and making them deal less damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 1.1,
	statMap = {
		["enfeeble_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique", neg = true }),
		},
		["enfeeble_damage_+%_vs_rare_or_unique_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique" }),
		},
		["accuracy_rating_+%"] = {
			mod("Accuracy", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"active_skill_area_of_effect_radius_+%_final",
		"accuracy_rating_+%",
		"enfeeble_damage_+%_final",
		"skill_art_variation",
		"enfeeble_damage_+%_vs_rare_or_unique_final",
	},
	levels = {
		[1] = { 5000, 0, -60, -60, 1, -23, cooldown = 10, levelRequirement = 4, statInterpolation = { 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["NecromancerFlammability"] = {
	name = "Flammability",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.85000002384186,
	description = "Curses all targets in an area, lowering their fire resistance and giving them a chance to be ignited when hit.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 1.1,
	statMap = {
		["base_fire_damage_resistance_%"] = {
			mod("FireResist", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["chance_to_be_ignited_%"] = {
			mod("SelfIgniteChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"active_skill_area_of_effect_radius_+%_final",
		"base_fire_damage_resistance_%",
		"chance_to_be_ignited_%",
		"skill_art_variation",
	},
	levels = {
		[1] = { 6000, 0, -20, 25, 1, cooldown = 10, levelRequirement = 10, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { }, },
		[2] = { 6000, 0, -25, 25, 1, cooldown = 10, levelRequirement = 41, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { }, },
		[3] = { 6000, 0, -30, 25, 1, cooldown = 10, levelRequirement = 58, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { }, },
		[4] = { 6000, 0, -40, 25, 1, cooldown = 10, levelRequirement = 71, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["NecromancerFrostbite"] = {
	name = "Frostbite",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.85000002384186,
	description = "Curses all targets in an area, lowering their cold resistance and giving them a chance to be frozen when hit.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cold] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 1.1,
	statMap = {
		["base_cold_damage_resistance_%"] = {
			mod("ColdResist", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["chance_to_be_frozen_%"] = {
			mod("SelfFreezeChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"active_skill_area_of_effect_radius_+%_final",
		"base_cold_damage_resistance_%",
		"chance_to_be_frozen_%",
		"skill_art_variation",
	},
	levels = {
		[1] = { 6000, 0, -20, 25, 1, cooldown = 10, levelRequirement = 10, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { }, },
		[2] = { 6000, 0, -25, 25, 1, cooldown = 10, levelRequirement = 41, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { }, },
		[3] = { 6000, 0, -30, 25, 1, cooldown = 10, levelRequirement = 58, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { }, },
		[4] = { 6000, 0, -40, 25, 1, cooldown = 10, levelRequirement = 71, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["NecromancerProjectileWeakness"] = {
	name = "Projectile Weakness",
	hidden = true,
	color = 2,
	baseEffectiveness = 0,
	description = "Curses a single enemy, increasing the damage they take from projectiles, and making projectiles split when hitting them, to hit other targets around them. You can gain charges for your life and mana flasks by hitting the cursed enemy. You can only have one Mark at a time.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Mark] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 1.1,
	statMap = {
		["projectile_damage_taken_+%"] = {
			mod("ProjectileDamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"projectiles_hitting_self_split_into_x",
		"projectile_damage_taken_+%",
		"grant_attacker_x_mana_flask_charges_when_hit_once_per_500ms",
		"grant_attacker_x_life_flask_charges_when_hit_once_per_500ms",
		"skill_art_variation",
	},
	levels = {
		[1] = { 6000, 3, 22, 0, 0, 1, cooldown = 12, levelRequirement = 25, statInterpolation = { 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[2] = { 6000, 3, 24, 0, 0, 1, cooldown = 12, levelRequirement = 55, statInterpolation = { 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[3] = { 6000, 3, 24, 0, 0, 1, cooldown = 12, levelRequirement = 60, statInterpolation = { 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["NecromancerRaiseZombie"] = {
	name = "Raise Zombie",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Raises a zombie minion from a corpse, which will follow you and attack enemies with a melee attack and an area of effect slam which cannot be evaded.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Minion] = true, [SkillType.MinionsCanExplode] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.CanRapidFire] = true, [SkillType.CreatesMinion] = true, },
	minionSkillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Area] = true, },
	statDescriptionScope = "minion_spell_skill_stat_descriptions",
	castTime = 0.85,
	baseFlags = {
		spell = true,
		minion = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_number_of_zombies_allowed",
		"alternate_minion",
	},
	levels = {
		[1] = { 3, 1, levelRequirement = 2, statInterpolation = { 1, 1, }, cost = { }, },
		[2] = { 4, 1, levelRequirement = 26, statInterpolation = { 1, 1, }, cost = { }, },
		[3] = { 5, 1, levelRequirement = 40, statInterpolation = { 1, 1, }, cost = { }, },
		[4] = { 6, 1, levelRequirement = 51, statInterpolation = { 1, 1, }, cost = { }, },
	},
}
skills["NecromancerVulnerability"] = {
	name = "Vulnerability",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Curse all targets in an area, causing them to take increased physical damage. Attacks against the cursed enemies have a chance to inflict bleeding, and ailments inflicted on them will deal damage faster.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 1.1,
	statMap = {
		["receive_bleeding_chance_%_when_hit_by_attack"] = {
			mod("SelfBleedChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["physical_damage_taken_+%"] = {
			mod("PhysicalDamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["enemy_damaging_ailments_deal_damage_+%_faster_against_self"] = {
			mod("SelfIgniteBurnFaster", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }), 
			mod("SelfBleedFaster", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }), 
			mod("SelfPoisonFaster", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"active_skill_area_of_effect_radius_+%_final",
		"physical_damage_taken_+%",
		"skill_art_variation",
		"receive_bleeding_chance_%_when_hit_by_attack",
		"enemy_damaging_ailments_deal_damage_+%_faster_against_self",
	},
	levels = {
		[1] = { 6000, 0, 50, 1, 20, 20, cooldown = 9, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["PyroChaosFireball"] = {
	name = "Chaos Fireball",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.3555999994278,
	incrementalEffectiveness = 0.028500000014901,
	description = "Unleashes a ball of fire towards a target which explodes, damaging nearby foes.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.85,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"spell_minimum_base_chaos_damage",
		"spell_maximum_base_chaos_damage",
		"spell_maximum_action_distance_+%",
		"skill_art_variation",
		"base_is_projectile",
	},
	levels = {
		[1] = { 0.40000000596046, 0.60000002384186, 0.27000001072884, 0.33000001311302, -50, 4, critChance = 6, cooldown = 3, levelRequirement = 3, statInterpolation = { 3, 3, 3, 3, 1, 1, }, cost = { }, },
	},
}
skills["PyroFireball"] = {
	name = "Fireball",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.1888999938965,
	incrementalEffectiveness = 0.03940000012517,
	description = "Unleashes a ball of fire towards a target which explodes, damaging nearby foes.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.93,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_is_projectile",
		"spell_maximum_action_distance_+%",
		"skill_art_variation",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 1, -50, 3, critChance = 6, levelRequirement = 3, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
		[2] = { 1.1200000047684, 1.6799999475479, 1, -50, 3, critChance = 6, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
	},
}
skills["PyroSuicideExplosion"] = {
	name = "Suicide Explosion",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.2667000293732,
	incrementalEffectiveness = 0.050000000745058,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.AreaSpell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"secondary_minimum_base_fire_damage",
		"secondary_maximum_base_fire_damage",
		"is_area_damage",
		"skill_art_variation",
		"grant_kill_to_target_when_exploding_self",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 1, 1, 1, levelRequirement = 3, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
		[2] = { 0.80000001192093, 1.2000000476837, 1, 1, 1, levelRequirement = 9, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
		[3] = { 0.80000001192093, 1.2000000476837, 1, 1, 1, levelRequirement = 13, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
		[4] = { 0.80000001192093, 1.2000000476837, 1, 1, 1, levelRequirement = 18, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
		[5] = { 0.80000001192093, 1.2000000476837, 1, 1, 1, levelRequirement = 23, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
		[6] = { 0.80000001192093, 1.2000000476837, 1, 1, 1, levelRequirement = 27, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
	},
}
skills["RevenantSpellProjectileSpectre"] = {
	name = "Lightning Projectile",
	hidden = true,
	color = 4,
	incrementalEffectiveness = 0.052999999374151,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"monster_projectile_variation",
		"base_number_of_projectiles_in_spiral_nova",
		"projectile_spiral_nova_time_ms",
		"projectile_spiral_nova_angle",
		"projectile_spiral_nova_starting_angle_offset",
		"monster_reverse_point_blank_damage_-%_at_minimum_range",
		"base_is_projectile",
	},
	levels = {
		[1] = { 0.60000002384186, 1.3999999761581, 7, 3, 150, 20, -10, 60, cooldown = 3, levelRequirement = 3, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["SeawitchFrostbolt"] = {
	name = "Frostbolt",
	hidden = true,
	color = 3,
	baseEffectiveness = 2.0455000400543,
	incrementalEffectiveness = 0.041000001132488,
	description = "Fires a slow-moving projectile that pierces through enemies, dealing cold damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Cold] = true, [SkillType.Triggerable] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.333,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"base_is_projectile",
		"always_pierce",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, cooldown = 3, levelRequirement = 3, statInterpolation = { 3, 3, }, cost = { }, },
		[2] = { 1.0499999523163, 1.5800000429153, critChance = 5, cooldown = 3, levelRequirement = 68, statInterpolation = { 3, 3, }, cost = { }, },
	},
}
skills["SeaWitchScreech"] = {
	name = "Screech",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.27270001173019,
	incrementalEffectiveness = 0.041999999433756,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.73,
	baseFlags = {
		spell = true,
		duration = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"base_movement_velocity_+%",
		"base_skill_effect_duration",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, -20, 1900, cooldown = 6.5, levelRequirement = 3, statInterpolation = { 3, 3, 1, 1, }, cost = { }, },
		[2] = { 1.8500000238419, 2.8800001144409, -20, 1900, cooldown = 6.5, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, }, cost = { }, },
	},
}
skills["SeawitchVulnerability"] = {
	name = "Vulnerability",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Curse all targets in an area, causing them to take increased physical damage. Attacks against the cursed enemies have a chance to inflict bleeding, and ailments inflicted on them will deal damage faster.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.75,
	statMap = {
		["receive_bleeding_chance_%_when_hit_by_attack"] = {
			mod("SelfBleedChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["physical_damage_taken_+%"] = {
			mod("PhysicalDamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["enemy_damaging_ailments_deal_damage_+%_faster_against_self"] = {
			mod("SelfIgniteBurnFaster", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }), 
			mod("SelfBleedFaster", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }), 
			mod("SelfPoisonFaster", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"active_skill_base_radius_+",
		"physical_damage_taken_+%",
		"receive_bleeding_chance_%_when_hit_by_attack",
		"enemy_damaging_ailments_deal_damage_+%_faster_against_self",
	},
	levels = {
		[1] = { 4000, 0, 50, 20, 20, cooldown = 8, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["SkeletonBlackAbyssBoneLance"] = {
	name = "Unearth",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.035000000149012,
	description = "Fires a projectile that will pierce through enemies to impact the ground at the targeted location, creating a Bone Archer corpse where it lands.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Trappable] = true, [SkillType.Triggerable] = true, [SkillType.Damage] = true, [SkillType.Multicastable] = true, [SkillType.CanRapidFire] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_skill_effect_duration",
		"alternate_minion",
		"desecrate_maximum_number_of_corpses",
		"base_projectile_speed_+%",
		"base_is_projectile",
		"always_pierce",
		"projectile_uses_contact_position",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 6000, 0, 3, -35, cooldown = 6, levelRequirement = 1, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[2] = { 0.80000001192093, 1.2000000476837, 6000, 0, 3, -35, cooldown = 6, levelRequirement = 82, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["SkeletonCannonMortar"] = {
	name = "Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.5,
	incrementalEffectiveness = 0.014000000432134,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"projectile_spread_radius",
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"projectile_speed_variation_+%",
		"spell_maximum_action_distance_+%",
		"projectile_minimum_range",
		"projectile_spread_radius_per_additional_projectile",
		"is_area_damage",
		"base_is_projectile",
		"projectiles_not_offset",
	},
	levels = {
		[1] = { 5, 0.87999999523163, 1.3200000524521, 15, -40, 8, 5, critChance = 5, levelRequirement = 45, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[2] = { 5, 0.80000001192093, 1.2000000476837, 15, -40, 8, 5, critChance = 5, levelRequirement = 68, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["SkeletonCannonBoneMortar"] = {
	name = "Bone Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.5,
	incrementalEffectiveness = 0.014000000432134,
	skillTypes = { [SkillType.Projectile] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"projectile_spread_radius",
		"projectile_minimum_range",
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"number_of_additional_projectiles",
		"mortar_cone_angle",
		"base_skill_effect_duration",
		"monster_projectile_variation",
		"is_area_damage",
		"base_is_projectile",
	},
	levels = {
		[1] = { 543, 217, 0.87999999523163, 1.3200000524521, 1, 30, 10000, 3, critChance = 5, cooldown = 4, levelRequirement = 45, statInterpolation = { 1, 1, 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[2] = { 543, 217, 0.80000001192093, 1.2000000476837, 1, 30, 10000, 3, critChance = 5, cooldown = 4, levelRequirement = 68, statInterpolation = { 1, 1, 3, 3, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["SkeletonCannonBoneNova"] = {
	name = "Bone Nova",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"number_of_additional_projectiles",
		"active_skill_damage_+%_final",
		"main_hand_base_maximum_attack_distance",
		"projectiles_nova",
	},
	levels = {
		[1] = { 10, 40, 30, cooldown = 5, levelRequirement = 1, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["SkeletonMassBowProjectile"] = {
	name = "Puncture",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.8700000047684,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
		mod("BleedChance", "BASE", 100),
	},
	qualityStats = {
	},
	stats = {
		"monster_projectile_variation",
		"spell_maximum_action_distance_+%",
		"base_projectile_speed_+%",
		"base_is_projectile",
		"global_bleed_on_hit",
	},
	levels = {
		[1] = { 12, -50, 200, levelRequirement = 2, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["SkeletonProjectileBlack"] = {
	name = "",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.2699999809265,
	incrementalEffectiveness = 0.027300000190735,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.2,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"monster_projectile_variation",
		"base_is_projectile",
		"projectile_uses_contact_position",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 33, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, 1, }, cost = { }, },
	},
}
skills["SkeletonSoldierTornadoShot"] = {
	name = "Tornado Shot",
	hidden = true,
	color = 2,
	description = "Fires a piercing shot that travels until it reaches the targeted location. It will then fire projectiles out in all directions from that point, which will travel for a short time before disappearing.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Totemable] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"active_skill_damage_+%_final",
		"number_of_additional_projectiles",
		"tornado_shot_num_of_secondary_projectiles",
		"base_is_projectile",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { -30, 0, 3, levelRequirement = 2, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[2] = { -35, 0, 3, levelRequirement = 38, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[3] = { -40, 0, 3, levelRequirement = 54, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["SkeletonSpark"] = {
	name = "Spark",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.75,
	incrementalEffectiveness = 0.0304000005126,
	description = "Launches unpredictable sparks that move randomly until they hit an enemy or expire.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.65,
	baseFlags = {
		spell = true,
		projectile = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_skill_effect_duration",
		"base_is_projectile",
		"number_of_additional_projectiles",
		"skill_art_variation",
	},
	levels = {
		[1] = { 0.5, 1.5, 3500, 1, 2, 1, damageEffectiveness = 0.7, critChance = 5, levelRequirement = 4, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 50, }, },
		[2] = { 0.5, 1.5, 3500, 1, 2, 1, damageEffectiveness = 0.7, critChance = 5, levelRequirement = 8, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 48, }, },
		[3] = { 0.5, 1.5, 3500, 1, 2, 1, damageEffectiveness = 0.7, critChance = 5, levelRequirement = 11, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 45, }, },
		[4] = { 0.5, 1.5, 3500, 1, 2, 1, damageEffectiveness = 0.7, critChance = 5, levelRequirement = 20, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 44, }, },
		[5] = { 0.5, 1.5, 3500, 1, 2, 1, damageEffectiveness = 0.7, critChance = 5, levelRequirement = 28, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 41, }, },
		[6] = { 0.5, 1.5, 3500, 1, 2, 1, damageEffectiveness = 0.7, critChance = 5, levelRequirement = 29, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 40, }, },
		[7] = { 2.2400000095367, 6.7300000190735, 3500, 1, 2, 1, damageEffectiveness = 0.7, critChance = 5, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { Mana = 40, }, },
	},
}
skills["AxisTemporalChains"] = {
	name = "Temporal Chains",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Curses all enemies in an area, lowering their action speed and making other effects on them expire more slowly.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.67,
	statMap = {
		["temporal_chains_action_speed_+%_final"] = {
			mod("TemporalChainsActionSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique", neg = true }),
		},
		["temporal_chains_action_speed_+%_vs_rare_or_unique_final"] = {
			mod("TemporalChainsActionSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique" }),
		},
		["buff_time_passed_+%_other_than_temporal_chains"] = {
			mod("BuffExpireFaster", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"active_skill_area_of_effect_radius_+%_final",
		"temporal_chains_action_speed_+%_final",
		"buff_time_passed_+%_other_than_temporal_chains",
		"skill_art_variation",
		"temporal_chains_action_speed_+%_vs_rare_or_unique_final",
	},
	levels = {
		[1] = { 4000, 0, -20, -40, 0, -10, cooldown = 8, levelRequirement = 0, statInterpolation = { 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["SkeletonVulnerability"] = {
	name = "Vulnerability",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Curse all targets in an area, causing them to take increased physical damage. Attacks against the cursed enemies have a chance to inflict bleeding, and ailments inflicted on them will deal damage faster.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Physical] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["receive_bleeding_chance_%_when_hit_by_attack"] = {
			mod("SelfBleedChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["physical_damage_taken_+%"] = {
			mod("PhysicalDamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["enemy_damaging_ailments_deal_damage_+%_faster_against_self"] = {
			mod("SelfIgniteBurnFaster", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }), 
			mod("SelfBleedFaster", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }), 
			mod("SelfPoisonFaster", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"active_skill_base_radius_+",
		"physical_damage_taken_+%",
		"receive_bleeding_chance_%_when_hit_by_attack",
		"enemy_damaging_ailments_deal_damage_+%_faster_against_self",
	},
	levels = {
		[1] = { 10900, 0, 50, 20, 20, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { Mana = 110, }, },
	},
}
skills["SlavedriverFlameWhip"] = {
	name = "Lightning Surge",
	hidden = true,
	color = 3,
	baseEffectiveness = 2.5,
	incrementalEffectiveness = 0.045000001788139,
	description = "Strikes enemies in front of you with a surge of flame. Burning enemies are dealt more damage. If you hit an ignited enemy, will create burning ground under them. Your damage modifiers don't apply to this burning ground.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Area] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Duration] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.5,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("radius", 30),
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"active_skill_area_of_effect_radius_+%_final",
		"base_cast_speed_+%",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, 50, -65, critChance = 6, levelRequirement = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { }, },
	},
}
skills["KitavaSlavedriverFlameWhip"] = {
	name = "Flame Surge",
	hidden = true,
	color = 3,
	baseEffectiveness = 2.2000000476837,
	incrementalEffectiveness = 0.027499999850988,
	description = "Strikes enemies in front of you with a surge of flame. Burning enemies are dealt more damage. If you hit an ignited enemy, will create burning ground under them. Your damage modifiers don't apply to this burning ground.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Area] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Duration] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.5,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("radius", 30),
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"active_skill_area_of_effect_radius_+%_final",
		"base_cast_speed_+%",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 50, -65, critChance = 6, levelRequirement = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { }, },
	},
}
skills["SnakeSpineProjectile"] = {
	name = "Spine Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.8700000047684,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		attack = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"monster_projectile_variation",
		"base_is_projectile",
		"spell_maximum_action_distance_+%",
	},
	levels = {
		[1] = { 2, 1, -60, levelRequirement = 1, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["SolarisChampionFlameVortex"] = {
	name = "Flame Vortex",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.6000000238419,
	incrementalEffectiveness = 0.029999999329448,
	description = "Launches unpredictable sparks that move randomly until they hit an enemy or expire.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.65,
	baseFlags = {
		spell = true,
		projectile = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_skill_effect_duration",
		"monster_projectile_variation",
		"base_projectile_speed_+%",
		"base_is_projectile",
		"projectiles_not_offset",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 3000, 2, -57, levelRequirement = 1, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
	},
}
skills["SpecialBeamCannon"] = {
	name = "Beam",
	hidden = true,
	color = 4,
	baseEffectiveness = 4.1556000709534,
	incrementalEffectiveness = 0.037000000476837,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.5,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 8, levelRequirement = 1, statInterpolation = { 3, 3, }, cost = { }, },
		[2] = { 0.80000001192093, 1.2000000476837, cooldown = 8, levelRequirement = 68, statInterpolation = { 3, 3, }, cost = { }, },
		[3] = { 0.80000001192093, 1.2000000476837, cooldown = 8, levelRequirement = 82, statInterpolation = { 3, 3, }, cost = { }, },
	},
}
skills["TarMortarTaster"] = {
	name = "Tar Projectile",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.3332999944687,
	incrementalEffectiveness = 0.032000001519918,
	description = "Like monster mortar skill, but leaves a ground effect on impact.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"monster_projectile_variation",
		"projectile_spread_radius",
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"spell_maximum_action_distance_+%",
		"base_skill_effect_duration",
		"is_area_damage",
		"base_is_projectile",
		"base_projectile_speed_+%",
	},
	levels = {
		[1] = { 2, 10, 0.80000001192093, 1.2000000476837, -50, 2000, cooldown = 4, levelRequirement = 3, statInterpolation = { 1, 1, 3, 3, 1, 1, }, cost = { }, },
		[2] = { 2, 10, 0.87999999523163, 1.3200000524521, -50, 2000, 33, cooldown = 4, levelRequirement = 68, statInterpolation = { 1, 1, 3, 3, 1, 1, 1, }, cost = { }, },
	},
}
skills["UndyingWhirlingBlades"] = {
	name = "Whirling Blades",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Dive through enemies, dealing weapon damage. Only works with daggers, claws and one handed swords. Cannot be supported by Multistrike.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, },
	weaponTypes = {
		["Thrusting One Handed Sword"] = true,
		["Claw"] = true,
		["Dagger"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.43,
	baseFlags = {
		attack = true,
		melee = true,
		movement = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_art_variation",
		"active_skill_damage_+%_final",
		"monster_flurry",
		"cast_time_overrides_attack_duration",
		"ignores_proximity_shield",
	},
	levels = {
		[1] = { 1, -40, 1, levelRequirement = 0, statInterpolation = { 1, 1, 1, }, cost = { Mana = 50, }, },
	},
}
skills["WalkingDoubleSlash"] = {
	name = "Double Slash",
	hidden = true,
	color = 2,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, },
	weaponTypes = {
		["Two Handed Axe"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"active_skill_attack_speed_+%_final",
		"active_skill_base_radius_+",
		"is_area_damage",
		"disable_skill_repeats",
	},
	levels = {
		[1] = { -22, 0, damageEffectiveness = 0.95, cooldown = 6, baseMultiplier = 0.7, levelRequirement = 12, statInterpolation = { 1, 1, }, cost = { }, },
	},
}
skills["WickerManMoltenStrike"] = {
	name = "Molten Strike",
	hidden = true,
	color = 1,
	baseEffectiveness = 0.69999998807907,
	description = "Infuses your melee weapon with molten energies to attack with physical and fire damage. This attack causes balls of molten magma to launch forth from the enemies you hit, divided amongst all enemies hit by the strike. These will explode, causing AoE attack damage to enemies where they land.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Projectile] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Fire] = true, [SkillType.RangedAttack] = true, [SkillType.ProjectilesNotFromUser] = true, [SkillType.ThresholdJewelChaining] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Dagger"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Claw"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_fire",
		"number_of_additional_projectiles",
		"active_skill_damage_+%_final",
		"physical_damage_+%",
		"active_skill_projectile_damage_+%_final",
		"base_projectile_speed_+%",
	},
	levels = {
		[1] = { 60, 4, 20, 10, -40, -25, levelRequirement = 10, statInterpolation = { 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["VaalincursionMortar"] = {
	name = "Physical Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.9550000429153,
	incrementalEffectiveness = 0.035000000149012,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.2,
	baseFlags = {
		spell = true,
		projectile = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"projectile_spread_radius",
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"skill_physical_damage_%_to_convert_to_chaos",
		"spell_maximum_action_distance_+%",
		"projectile_spread_radius_per_additional_projectile",
		"projectile_minimum_range",
		"is_area_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
	},
	levels = {
		[1] = { 10, 0.80000001192093, 1.2000000476837, 0, -40, 5, 10, levelRequirement = 1, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["VaalIncursionFirestorm"] = {
	name = "Firestorm",
	hidden = true,
	color = 4,
	baseEffectiveness = 4.4443998336792,
	incrementalEffectiveness = 0.03999999910593,
	description = "Flaming bolts rain down over the targeted area. They explode when landing, dealing damage to nearby enemies.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Fire] = true, [SkillType.Cascadable] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.2,
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"base_skill_effect_duration",
		"fire_storm_fireball_delay_ms",
		"firestorm_base_area_of_effect_+%",
		"monster_penalty_against_minions_damage_+%_final_vs_player_minions",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 600, 200, 100, 0, cooldown = 6, levelRequirement = 1, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["VaalIncursionSpecialBeamCannonBlood"] = {
	name = "Physical Beam",
	hidden = true,
	color = 4,
	baseEffectiveness = 2,
	incrementalEffectiveness = 0.035000000149012,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, cooldown = 8, levelRequirement = 83, statInterpolation = { 3, 3, }, cost = { }, },
	},
}
skills["MeleeEyrieArrow"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_cold",
		"active_skill_damage_+%_final",
		"arrow_projectile_variation",
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"use_scaled_contact_offset",
		"projectile_uses_contact_position",
	},
	levels = {
		[1] = { 75, 0, 26, baseMultiplier = 0.75, levelRequirement = 1, statInterpolation = { 1, 2, 1, }, cost = { }, },
		[2] = { 75, 0, 26, baseMultiplier = 0.75, levelRequirement = 19, statInterpolation = { 1, 2, 1, }, cost = { }, },
		[3] = { 75, 1, 26, baseMultiplier = 0.75, levelRequirement = 20, statInterpolation = { 1, 2, 1, }, cost = { }, },
		[4] = { 75, 200, 26, baseMultiplier = 0.75, levelRequirement = 84, statInterpolation = { 1, 2, 1, }, cost = { }, },
	},
}
skills["AtlasEyrieArcherMortar"] = {
	name = "Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.5,
	incrementalEffectiveness = 0.03999999910593,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.33,
	baseFlags = {
		spell = true,
		hit = true,
		projectile = true,
		area = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"projectile_spread_radius",
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"is_area_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	levels = {
		[1] = { 0, 0.80000001192093, 1.2000000476837, critChance = 5, cooldown = 10, levelRequirement = 0, statInterpolation = { 1, 3, 3, }, cost = { }, },
	},
}
skills["AtlasEyrieArcherSnipe"] = {
	name = "Snipe",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		hit = true,
		projectile = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"monster_projectile_variation",
		"skill_physical_damage_%_to_convert_to_cold",
		"active_skill_damage_+%_final",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
		"always_pierce",
	},
	levels = {
		[1] = { 92, 75, 0, levelRequirement = 1, statInterpolation = { 1, 1, 2, }, cost = { }, },
		[2] = { 92, 75, 0, levelRequirement = 19, statInterpolation = { 1, 1, 2, }, cost = { }, },
		[3] = { 92, 75, 1, levelRequirement = 20, statInterpolation = { 1, 1, 2, }, cost = { }, },
		[4] = { 92, 75, 200, levelRequirement = 84, statInterpolation = { 1, 1, 2, }, cost = { }, },
	},
}
skills["AtlasEyrieArcherCrystalImpact"] = {
	name = "Crystal Impact",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.5,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		hit = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, cost = { }, },
	},
}
skills["AtlasExilesCrusaderMageguardProjectile"] = {
	name = "Projectile Spell",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.25,
	incrementalEffectiveness = 0.045000001788139,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.33,
	baseFlags = {
		spell = true,
		projectile = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"monster_projectile_variation",
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"spell_maximum_action_distance_+%",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	levels = {
		[1] = { 127, 0.5, 1.5, -40, critChance = 5, levelRequirement = 0, statInterpolation = { 1, 3, 3, 1, }, cost = { }, },
	},
}
skills["AtlasExileCrusaderMageguardBombExplodeSpectre"] = {
	name = "Bombs",
	hidden = true,
	color = 4,
	baseEffectiveness = 2,
	incrementalEffectiveness = 0.045000001788139,
	skillTypes = { [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		hit = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, cost = { }, },
	},
}
skills["AtlasCrusaderMageguardBeam"] = {
	name = "Beam",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.045000001788139,
	skillTypes = { [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.3,
	baseFlags = {
		spell = true,
		hit = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, critChance = 5, cooldown = 8, levelRequirement = 0, statInterpolation = { 3, 3, }, cost = { }, },
	},
}
skills["AtlasCrusaderSisterMortarSpectre"] = {
	name = "Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.2999999523163,
	incrementalEffectiveness = 0.03999999910593,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		hit = true,
		triggerable = true,
		area = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"projectile_spread_radius",
		"number_of_projectiles_override",
		"monster_mortar_number_of_forks",
		"mortar_projectile_distance_override",
		"is_area_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
	},
	levels = {
		[1] = { 0.69999998807907, 1.2999999523163, 20, 1, 3, 10, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["BreachLightningWhip"] = {
	name = "Breach Lightning Whip",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.03999999910593,
	description = "Strikes enemies in front of you with a surge of flame. Burning enemies are dealt more damage. If you hit an ignited enemy, will create burning ground under them. Your damage modifiers don't apply to this burning ground.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Area] = true, [SkillType.Fire] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.Duration] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.75,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("radius", 30),
		skill("showAverage", true),
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"active_skill_area_of_effect_radius_+%_final",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, 0, critChance = 5, cooldown = 5, levelRequirement = 1, statInterpolation = { 3, 3, 1, }, cost = { }, },
		[2] = { 1, 3, 0, critChance = 5, cooldown = 5, levelRequirement = 68, statInterpolation = { 3, 3, 1, }, cost = { }, },
	},
}
skills["BreachArc"] = {
	name = "Breach Arc",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.82499998807907,
	incrementalEffectiveness = 0.043999999761581,
	description = "An arc of lightning stretches from the caster to a targeted enemy and chains on to other nearby enemies. Each time the main beam chains it will also chain to a second enemy, but that secondary arc cannot chain further.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Chains] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "beam_skill_stat_descriptions",
	castTime = 0.5,
	baseFlags = {
		spell = true,
		chaining = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_chance_to_shock_%",
		"number_of_chains",
		"base_cast_speed_+%",
		"spell_maximum_action_distance_+%",
	},
	levels = {
		[1] = { 0.69999998807907, 1.2999999523163, 10, 0, 0, -65, levelRequirement = 1, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
		[2] = { 1.3999999761581, 2.5999999046326, 10, 0, 0, -65, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["BreachTeamWarp"] = {
	name = "Breach Team Warp",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"number_of_monsters_to_summon",
		"breach_team_warp_buff_lightning_damage_+%",
		"breach_team_warp_buff_movement_velocity_+%",
		"breach_team_warp_buff_damage_taken_+%",
	},
	levels = {
		[1] = { 8000, 3, 25, 50, -50, cooldown = 20, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["BreachLightningOrbsCommander"] = {
	name = "Breach Lightning Orbs Commander",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.85000002384186,
	incrementalEffectiveness = 0.049100000411272,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_skill_effect_duration",
		"spell_maximum_action_distance_+%",
		"is_area_damage",
		"cannot_stun",
	},
	levels = {
		[1] = { 0.5, 1.5, 3000, 0, critChance = 5, cooldown = 5, levelRequirement = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { }, },
	},
}
skills["SandLeaperDodgeLeft"] = {
	name = "Sand Leaper Dodge Left",
	hidden = true,
	color = 4,
	skillTypes = { },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"monster_dodge_direction",
		"monster_dodge_distance",
	},
	levels = {
		[1] = { 0, 22, levelRequirement = 1, statInterpolation = { 1, 1, }, cost = { Mana = 90, }, },
	},
}
skills["SandLeaperDodgeRight"] = {
	name = "Sand Leaper Dodge Right",
	hidden = true,
	color = 4,
	skillTypes = { },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"monster_dodge_direction",
		"monster_dodge_distance",
	},
	levels = {
		[1] = { 1, 22, levelRequirement = 1, statInterpolation = { 1, 1, }, cost = { Mana = 90, }, },
	},
}
skills["SynthesisSoulstealerProjectileLightning"] = {
	name = "Lightning Projectile",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.5,
	incrementalEffectiveness = 0.037999998778105,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.33,
	baseFlags = {
		spell = true,
		triggerable = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"monster_projectile_variation",
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
	},
	levels = {
		[1] = { 103, 0.5, 1.5, critChance = 5, levelRequirement = 0, statInterpolation = { 1, 3, 3, }, cost = { }, },
	},
}
skills["SynthesisSoulstealerLaser"] = {
	name = "Lightning Laser",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.60000002384186,
	incrementalEffectiveness = 0.050000000745058,
	skillTypes = { [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"skill_physical_damage_%_to_convert_to_lightning",
		"skill_physical_damage_%_to_convert_to_chaos",
		"monster_penalty_against_minions_damage_+%_final_vs_player_minions",
		"is_area_damage",
		"cannot_stun",
	},
	levels = {
		[1] = { 0.5, 1.5, 0, 0, 0, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, 1, 1, 1, }, cost = { }, },
	},
}
skills["SynthesisSoulstealerBolt"] = {
	name = "Lightning Bolt",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.60000002384186,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"monster_penalty_against_minions_damage_+%_final_vs_player_minions",
		"spell_maximum_action_distance_+%",
		"base_skill_effect_duration",
		"skill_range_+%",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.69999998807907, 1.2999999523163, 0, -50, 260, -75, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["MeleeCold"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_cold",
		"active_skill_damage_+%_final",
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
	},
	levels = {
		[1] = { 75, 0, baseMultiplier = 0.75, levelRequirement = 1, statInterpolation = { 1, 2, }, cost = { }, },
		[2] = { 75, 0, baseMultiplier = 0.75, levelRequirement = 19, statInterpolation = { 1, 2, }, cost = { }, },
		[3] = { 75, 1, baseMultiplier = 0.75, levelRequirement = 20, statInterpolation = { 1, 2, }, cost = { }, },
		[4] = { 75, 200, baseMultiplier = 0.75, levelRequirement = 84, statInterpolation = { 1, 2, }, cost = { }, },
	},
}
skills["AtlasCrusaderJudgeBallLightning"] = {
	name = "Ball Lightning",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.41249999403954,
	incrementalEffectiveness = 0.045000001788139,
	description = "Fires a slow-moving projectile that periodically damages enemies in an area around it with bolts of lightning.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Area] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.6,
	baseFlags = {
		spell = true,
		hit = true,
		triggerable = true,
		area = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_projectile_speed_+%",
		"base_is_projectile",
	},
	levels = {
		[1] = { 0.5, 1.5, -25, critChance = 32, levelRequirement = 0, statInterpolation = { 3, 3, 1, }, cost = { }, },
	},
}
skills["AtlasCruasderJudgeFadingNova"] = {
	name = "Nova Spell",
	hidden = true,
	color = 4,
	baseEffectiveness = 3,
	incrementalEffectiveness = 0.045000001788139,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.33,
	baseFlags = {
		spell = true,
		projectile = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"monster_projectile_variation",
		"number_of_additional_projectiles",
		"base_is_projectile",
		"always_pierce",
		"use_scaled_contact_offset",
		"projectiles_nova",
	},
	levels = {
		[1] = { 0.5, 1.5, 128, 7, critChance = 5, cooldown = 8, levelRequirement = 0, statInterpolation = { 3, 3, 1, 1, }, cost = { }, },
	},
}
skills["GAHarvestCrabDashSlam"] = {
	name = "Dash Slam",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	levels = {
		[1] = { 50, -30, baseMultiplier = 2, cooldown = 4, levelRequirement = 1, statInterpolation = { 1, 2, }, cost = { }, },
		[2] = { 50, 0, baseMultiplier = 2, cooldown = 4, levelRequirement = 19, statInterpolation = { 1, 2, }, cost = { }, },
		[3] = { 50, 1, baseMultiplier = 2, cooldown = 4, levelRequirement = 20, statInterpolation = { 1, 2, }, cost = { }, },
		[4] = { 50, 60, baseMultiplier = 2, cooldown = 4, levelRequirement = 84, statInterpolation = { 1, 2, }, cost = { }, },
	},
	baseFlags = {
		attack = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	qualityStats = {
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_cold",
		"active_skill_damage_+%_final",
		"is_area_damage",
	},
}
skills["HarvestCrabAbyssSlam"] = {
	name = "Slam Attack",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		attack = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	qualityStats = {
	},
	stats = {
		"active_skill_attack_speed_+%_final",
		"upheaval_number_of_spikes",
		"main_hand_base_maximum_attack_distance",
		"active_skill_damage_+%_final",
		"monster_penalty_against_minions_damage_+%_final_vs_player_minions",
		"skill_physical_damage_%_to_convert_to_cold",
		"is_area_damage",
	},
	levels = {
		[1] = { 0, 4, 50, -30, -50, 50, baseMultiplier = 0.75, cooldown = 10, levelRequirement = 1, statInterpolation = { 1, 1, 1, 2, 1, 1, }, cost = { }, },
		[2] = { 0, 4, 50, 0, -50, 50, baseMultiplier = 0.75, cooldown = 10, levelRequirement = 19, statInterpolation = { 1, 1, 1, 2, 1, 1, }, cost = { }, },
		[3] = { 0, 4, 50, 1, -50, 50, baseMultiplier = 0.75, cooldown = 10, levelRequirement = 20, statInterpolation = { 1, 1, 1, 2, 1, 1, }, cost = { }, },
		[4] = { 0, 4, 50, 60, -50, 50, baseMultiplier = 0.75, cooldown = 10, levelRequirement = 84, statInterpolation = { 1, 1, 1, 2, 1, 1, }, cost = { }, },
	},
}
skills["HarvestNessaCrabScreech"] = {
	name = "Screech",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
	},
	levels = {
		[1] = { cooldown = 12, levelRequirement = 0, statInterpolation = { }, cost = { }, },
	},
}
skills["HarvestNessaCrabScreechDebuff"] = {
	name = "Frigid Roar",
	hidden = true,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statMap = {
		["frigid_roar_cold_damage_taken_+%"] = {
			mod("ColdDamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Debuff", effectName = "Frigid Roar" }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"frigid_roar_cold_damage_taken_+%",
	},
	levels = {
		[1] = { 20, cooldown = 12, levelRequirement = 0, statInterpolation = { 1, }, cost = { }, },
	},
}

skills["HarvestRhexLeapSlam"] = {
	name = "Leap Slam",
	hidden = true,
	color = 4,
	description = "Jump into the air, damaging and knocking back enemies with your weapon where you land. Enemies you would land on are pushed out of the way. Requires an Axe, Mace, Sceptre, Sword or Staff. Cannot be supported by Multistrike.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Movement] = true, [SkillType.Travel] = true, [SkillType.Slam] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Thrusting One Handed Sword"] = true,
		["Two Handed Sword"] = true,
		["Staff"] = true,
		["Two Handed Axe"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["One Handed Sword"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.2,
	baseFlags = {
		attack = true,
		melee = true,
		area = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	qualityStats = {
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_lightning",
		"active_skill_damage_+%_final",
		"is_area_damage",
		"cast_time_overrides_attack_duration",
	},
	levels = {
		[1] = { 50, 0, cooldown = 10, levelRequirement = 1, statInterpolation = { 1, 2, }, cost = { }, },
		[2] = { 50, 0, cooldown = 10, levelRequirement = 19, statInterpolation = { 1, 2, }, cost = { }, },
		[3] = { 50, 1, cooldown = 10, levelRequirement = 20, statInterpolation = { 1, 2, }, cost = { }, },
		[4] = { 50, 150, cooldown = 10, levelRequirement = 84, statInterpolation = { 1, 2, }, cost = { }, },
	},
}
skills["GAHarvestRhexDashSlash"] = {
	name = "Dash Slash",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	levels = {
		[1] = { 50, -30, baseMultiplier = 2.2, cooldown = 4, levelRequirement = 1, statInterpolation = { 1, 2, }, cost = { }, },
		[2] = { 50, 0, baseMultiplier = 2.2, cooldown = 4, levelRequirement = 19, statInterpolation = { 1, 2, }, cost = { }, },
		[3] = { 50, 1, baseMultiplier = 2.2, cooldown = 4, levelRequirement = 20, statInterpolation = { 1, 2, }, cost = { }, },
		[4] = { 50, 60, baseMultiplier = 2.2, cooldown = 4, levelRequirement = 84, statInterpolation = { 1, 2, }, cost = { }, },
	},
	baseFlags = {
		attack = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	baseMods = {
		skill("showAverage", true),
	},
	qualityStats = {
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_lightning",
		"active_skill_damage_+%_final",
		"is_area_damage",
	},
}
skills["GSHarvestRhexScreech"] = {
	name = "Screech",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.2000000476837,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	levels = {
		[1] = { 0.5, 1.5, critChance = 5, duration = 4, cooldown = 8, levelRequirement = 1, statInterpolation = { 3, 3, }, cost = { }, },
	},
	baseFlags = {
		spell = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"is_area_damage",
	},
}
skills["HarvestRhexScreechDebuff"] = {
	name = "Thunderous Roar",
	hidden = true,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statMap = {
		["thunderous_roar_lightning_damage_taken_+%"] = {
			mod("LightningDamageTaken", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Debuff", effectName = "Thunderous Roar" }),
		},
	},
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"thunderous_roar_lightning_damage_taken_+%",
	},
	levels = {
		[1] = { 10, cooldown = 8, levelRequirement = 0, statInterpolation = { 1, }, cost = { }, },
	},
}

skills["LegionTemplarJudgeBallLightning"] = {
	name = "Ball Lightning",
	hidden = true,
	color = 3,
	baseEffectiveness = 0.51560002565384,
	incrementalEffectiveness = 0.045000001788139,
	description = "Fires a slow-moving projectile that periodically damages enemies in an area around it with bolts of lightning.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Area] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.6,
	baseFlags = {
		spell = true,
		hit = true,
		triggerable = true,
		area = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_projectile_speed_+%",
		"skill_physical_damage_%_to_convert_to_lightning",
		"base_is_projectile",
		"visual_hit_effect_elemental_is_holy",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, -25, 80, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, 1, 1, }, cost = { }, },
	},
}
skills["LegionTemplarJudgeStormCall"] = {
	name = "Storm Call",
	hidden = true,
	color = 3,
	baseEffectiveness = 3,
	incrementalEffectiveness = 0.031199999153614,
	description = "Sets a marker at a location. After a short duration, lightning strikes the marker, dealing damage around it. When this happens, it will also set off the lightning at any other markers you've cast.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Triggerable] = true, [SkillType.Multicastable] = true, [SkillType.Lightning] = true, [SkillType.Cascadable] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_skill_effect_duration",
		"skill_physical_damage_%_to_convert_to_lightning",
		"is_area_damage",
		"visual_hit_effect_elemental_is_holy",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 2000, 60, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, 1, 1, }, cost = { }, },
	},
}
skills["MPWHeistThugRangedBurningArrow"] = {
	name = "Burning Arrow",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		hit = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"monster_projectile_variation",
		"skill_physical_damage_%_to_convert_to_fire",
		"spell_maximum_action_distance_+%",
		"active_skill_damage_+%_final",
		"base_is_projectile",
		"use_scaled_contact_offset",
		"projectile_uses_contact_position",
		"maintain_projectile_direction_when_using_contact_position",
		"always_ignite",
	},
	levels = {
		[1] = { 124, 75, -50, -30, levelRequirement = 1, statInterpolation = { 1, 1, 1, 2, }, cost = { }, },
		[2] = { 124, 75, -50, 0, levelRequirement = 19, statInterpolation = { 1, 1, 1, 2, }, cost = { }, },
		[3] = { 124, 75, -50, 1, levelRequirement = 20, statInterpolation = { 1, 1, 1, 2, }, cost = { }, },
		[4] = { 124, 75, -50, 60, levelRequirement = 84, statInterpolation = { 1, 1, 1, 2, }, cost = { }, },
	},
}
skills["MPSHeistRobotClockworkGolemBasicProjectile"] = {
	name = "Frost Projectile",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.2000000476837,
	incrementalEffectiveness = 0.041999999433756,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		projectile = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"monster_projectile_variation",
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"spell_maximum_action_distance_+%",
		"base_is_projectile",
		"use_scaled_contact_offset",
		"projectile_uses_contact_position",
	},
	levels = {
		[1] = { 163, 0.80000001192093, 1.2000000476837, -50, levelRequirement = 0, statInterpolation = { 1, 3, 3, 1, }, cost = { }, },
	},
}
skills["MMSHeistRobotClockworkGolemMortarSpectre"] = {
	name = "Frost Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 2,
	incrementalEffectiveness = 0.045000001788139,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		hit = true,
		triggerable = true,
		area = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"spell_maximum_action_distance_+%",
		"is_area_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, -35, cooldown = 6, levelRequirement = 1, statInterpolation = { 3, 3, 1, }, cost = { }, },
	},
}
skills["HeistThugRangedExplosiveArrow"] = {
	name = "Explosive Arrow (20 Fuses)",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.037999998778105,
	description = "Fires an arrow which will stick into an enemy or wall, and then explode, dealing area damage around it, either after a duration or when the maximum number of arrows stuck to that target is reached. If an enemy has multiple Explosive Arrows stuck in them, the first one to explode will consume the others, adding their damage to its explosion.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Fire] = true, [SkillType.Triggerable] = true, },
	weaponTypes = {
		["Bow"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	statMap = {
		["explosive_arrow_explosion_minimum_added_fire_damage"] = {
			mod("FireMin", "BASE", nil),
		},
		["explosive_arrow_explosion_maximum_added_fire_damage"] = {
			mod("FireMax", "BASE", nil),
		},
		["fuse_arrow_explosion_radius_+_per_fuse_arrow_orb"] = {
			skill("radiusExtra", nil, { type = "Multiplier", var = "ExplosiveArrowFuse" }),
		},
		["explosive_arrow_explosion_base_damage_+permyriad"] = {
			mod("Damage", "MORE", nil, 0, bit.bor(KeywordFlag.Hit, KeywordFlag.Ailment)),
			div = 100,
		},
		["explosive_arrow_hit_and_ailment_damage_+%_final_per_stack"] = {
			mod("Damage", "MORE", nil, 0, bit.bor(KeywordFlag.Hit, KeywordFlag.Ailment), { type = "Multiplier", var = "ExplosiveArrowFuse" }),
		},
	},
	baseFlags = {
		attack = true,
		projectile = true,
		hit = true,
		area = true,
		duration = true,
		triggerable = true,
	},
	baseMods = {
		skill("radius", 15),
		skill("showAverage", true),
		mod("Damage", "MORE", 100, 0, 0, { type = "Multiplier", var = "ExplosiveArrowFuse", base = -100 }),
		mod("Multiplier:ExplosiveArrowFuse", "BASE", 20),
	},
	qualityStats = {
	},
	stats = {
		"fuse_arrow_explosion_radius_+_per_fuse_arrow_orb",
		"explosive_arrow_explosion_minimum_added_fire_damage",
		"explosive_arrow_explosion_maximum_added_fire_damage",
		"explosive_arrow_explosion_base_damage_+permyriad",
		"explosive_arrow_maximum_bonus_explosion_radius",
		"explosive_arrow_hit_and_ailment_damage_+%_final_per_stack",
		"explosive_arrow_stack_limit",
		"base_is_projectile",
		"use_scaled_contact_offset",
		"projectile_uses_contact_position",
		"maintain_projectile_direction_when_using_contact_position",
	},
	levels = {
		[1] = { 2, 0.80000001192093, 1.2000000476837, -5000, 12, 3, 20, duration = 2, levelRequirement = 1, statInterpolation = { 1, 3, 3, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["EmptyActionAttackSecretPoliceDaggers"] = {
	name = "Dagger Trigger Attack",
	hidden = true,
	color = 4,
	skillTypes = { },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.87,
	baseFlags = {
		attack = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"main_hand_base_maximum_attack_distance",
		"cast_time_overrides_attack_duration",
	},
	levels = {
		[1] = { 60, levelRequirement = 0, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["BetrayalSecretPoliceCurveDagger1"] = {
	name = "Secret Police Daggers",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.Projectile] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"lunaris_glaive_angle",
		"lunaris_glaive_acceleration_x",
		"active_skill_attack_speed_+%_final",
		"melee_weapon_range_+",
		"active_skill_damage_+%_final",
		"base_projectile_speed_+%",
		"base_is_projectile",
		"projectile_uses_contact_position",
	},
	levels = {
		[1] = { -20, 1500, 20, 50, -50, 0, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, 2, 1, }, cost = { }, },
		[2] = { -20, 1500, 20, 50, 0, 0, levelRequirement = 100, statInterpolation = { 1, 1, 1, 1, 2, 1, }, cost = { }, },
	},
}
skills["AtlasEyrieKiwethMortarSpectre"] = {
	name = "Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.5,
	incrementalEffectiveness = 0.03999999910593,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.67,
	baseFlags = {
		spell = true,
		hit = true,
		area = true,
		projectile = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"projectile_spread_radius",
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"number_of_projectiles_override",
		"is_area_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	levels = {
		[1] = { 0, 0.80000001192093, 1.2000000476837, 1, critChance = 5, cooldown = 10, levelRequirement = 0, statInterpolation = { 1, 3, 3, 1, }, cost = { }, },
	},
}
skills["AtlasEyrieKiwethMortarShards"] = {
	name = "Mortar Shards",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.045000001788139,
	skillTypes = { [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		hit = true,
		projectile = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, }, cost = { }, },
	},
}
skills["GAHeistThugRangedArrowShotgun"] = {
	name = "Arrow Shotgun",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 3,
	baseFlags = {
		attack = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_fire",
		"is_area_damage",
		"cast_time_overrides_attack_duration",
	},
	levels = {
		[1] = { 50, cooldown = 10, levelRequirement = 1, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["GAHeistThugRangedShotgun"] = {
	name = "Ranged Shotgun",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Channel] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.33,
	baseFlags = {
		attack = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_fire",
		"active_skill_damage_+%_final",
		"is_area_damage",
		"cast_time_overrides_attack_duration",
	},
	levels = {
		[1] = { 50, -30, baseMultiplier = 1.3, levelRequirement = 1, statInterpolation = { 1, 2, }, cost = { }, },
		[2] = { 50, 0, baseMultiplier = 1.3, levelRequirement = 19, statInterpolation = { 1, 2, }, cost = { }, },
		[3] = { 50, 1, baseMultiplier = 1.3, levelRequirement = 20, statInterpolation = { 1, 2, }, cost = { }, },
		[4] = { 50, 60, baseMultiplier = 1.3, levelRequirement = 84, statInterpolation = { 1, 2, }, cost = { }, },
	},
}
skills["GSHeistRobotPyreBeamBlast"] = {
	name = "Beam Blast",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.2000000476837,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"spell_maximum_action_distance_+%",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, -50, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, 1, }, cost = { }, },
	},
}
skills["GSHeistRobotPyreNukeBeam"] = {
	name = "Nuke Beam",
	hidden = true,
	color = 4,
	baseEffectiveness = 4,
	incrementalEffectiveness = 0.050000000745058,
	skillTypes = { [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 4.5,
	baseFlags = {
		spell = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, cooldown = 13, levelRequirement = 1, statInterpolation = { 3, 3, }, cost = { }, },
	},
}
skills["GSHeistRobotPyreNukeBeamChannelled"] = {
	name = "Nuke Beam Channelled",
	hidden = true,
	color = 4,
	baseEffectiveness = 4,
	incrementalEffectiveness = 0.045000001788139,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Channel] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.54,
	baseFlags = {
		spell = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, cooldown = 13, levelRequirement = 1, statInterpolation = { 3, 3, }, cost = { }, },
	},
}
skills["GSHeistRobotPyreBeamSweepBeam"] = {
	name = "Beam Sweep",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.5,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_fire_damage",
		"spell_maximum_base_fire_damage",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, }, cost = { }, },
	},
}
skills["MeleeEyrieBird"] = {
	name = "Knockback Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_cold",
		"active_skill_damage_+%_final",
		"base_knockback_speed_+%",
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"global_knockback",
		"determine_knockback_direction_from_melee_pattern",
	},
	levels = {
		[1] = { 75, 0, 100, baseMultiplier = 0.75, cooldown = 8, attackSpeedMultiplier = -38, levelRequirement = 1, statInterpolation = { 1, 2, 1, }, cost = { }, },
		[2] = { 75, 0, 100, baseMultiplier = 0.75, cooldown = 8, attackSpeedMultiplier = -38, levelRequirement = 19, statInterpolation = { 1, 2, 1, }, cost = { }, },
		[3] = { 75, 1, 100, baseMultiplier = 0.75, cooldown = 8, attackSpeedMultiplier = -38, levelRequirement = 20, statInterpolation = { 1, 2, 1, }, cost = { }, },
		[4] = { 75, 200, 100, baseMultiplier = 0.75, cooldown = 8, attackSpeedMultiplier = -38, levelRequirement = 84, statInterpolation = { 1, 2, 1, }, cost = { }, },
	},
}
skills["AtlasEyrieBirdBreath"] = {
	name = "Chilling Breath",
	hidden = true,
	color = 4,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_cold_damage",
		"spell_maximum_base_cold_damage",
		"chill_minimum_slow_%",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 30, critChance = 5, cooldown = 10, levelRequirement = 0, statInterpolation = { 3, 3, 1, }, cost = { }, },
	},
}
skills["SecretDesecrateMonsterEarthquakeTriggered"] = {
	name = "Earthquake",
	hidden = true,
	color = 4,
	description = "Smashes the ground, dealing damage in an area and cracking the earth. The crack will erupt in a powerful aftershock after a short duration. Cracks created before the first one has erupted will not generate their own aftershocks. Requires an Axe, Mace, Sceptre, Staff or Unarmed.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.Area] = true, [SkillType.Melee] = true, [SkillType.Multistrikeable] = true, [SkillType.Duration] = true, [SkillType.Slam] = true, [SkillType.Triggerable] = true, [SkillType.Totemable] = true, },
	weaponTypes = {
		["None"] = true,
		["One Handed Mace"] = true,
		["Sceptre"] = true,
		["Two Handed Mace"] = true,
		["One Handed Axe"] = true,
		["Two Handed Axe"] = true,
		["Staff"] = true,
	},
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		hit = true,
		melee = true,
		area = true,
		duration = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"quake_slam_fully_charged_explosion_damage_+%_final",
		"is_area_damage",
	},
	levels = {
		[1] = { 10, 50, levelRequirement = 1, statInterpolation = { 1, 1, }, cost = { }, },
	},
}
skills["SecretDesecrateMonsterMultiSlash"] = {
	name = "Multi Slash",
	hidden = true,
	color = 1,
	baseEffectiveness = 0,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"is_area_damage",
		"skill_is_attack",
	},
	levels = {
		[1] = { attackSpeedMultiplier = -33, levelRequirement = 0, statInterpolation = { }, cost = { }, },
	},
}
skills["UltimatumGuardMeleeCold"] = {
	name = "Cold Arrow",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		melee = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"number_of_additional_projectiles",
		"skill_physical_damage_%_to_convert_to_cold",
		"active_skill_damage_+%_final",
		"arrow_projectile_variation",
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"action_attack_or_cast_time_uses_animation_length",
		"use_scaled_contact_offset",
	},
	levels = {
		[1] = { 2, 50, -50, 34, levelRequirement = 1, statInterpolation = { 1, 1, 2, 1, }, cost = { }, },
		[2] = { 2, 50, 0, 34, levelRequirement = 68, statInterpolation = { 1, 1, 2, 1, }, cost = { }, },
	},
}
skills["UltimatumGuardConeArrowCold"] = {
	name = "Cone Arrow",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_cold",
		"active_skill_damage_+%_final",
		"is_area_damage",
	},
	levels = {
		[1] = { 100, 0, cooldown = 8, levelRequirement = 1, statInterpolation = { 1, 2, }, cost = { }, },
		[2] = { 100, 250, cooldown = 8, levelRequirement = 83, statInterpolation = { 1, 2, }, cost = { }, },
	},
}
skills["MPWVaalGuardBarrage"] = {
	name = "Barrage",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_cold",
		"monster_projectile_variation",
		"projectile_random_angle_based_on_distance_to_target_location_%",
		"active_skill_damage_+%_final",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
		"maintain_projectile_direction_when_using_contact_position",
	},
	levels = {
		[1] = { 80, 141, 60, -70, levelRequirement = 1, statInterpolation = { 1, 1, 1, 2, }, cost = { }, },
		[2] = { 80, 141, 60, 0, levelRequirement = 83, statInterpolation = { 1, 1, 1, 2, }, cost = { }, },
	},
}
skills["MeleeAtAnimationSpeed"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		melee = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"action_attack_or_cast_time_uses_animation_length",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	levels = {
		[1] = { levelRequirement = 1, statInterpolation = { }, cost = { }, },
	},
}
skills["MeleeKaruiArcher"] = {
	name = "Cold Arrow",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		melee = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"arrow_projectile_variation",
		"skill_physical_damage_%_to_convert_to_cold",
		"active_skill_damage_+%_final",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { 18, 75, 0, levelRequirement = 1, statInterpolation = { 1, 1, 2, }, cost = { }, },
		[2] = { 18, 75, 0, levelRequirement = 19, statInterpolation = { 1, 1, 2, }, cost = { }, },
		[3] = { 18, 75, 1, levelRequirement = 20, statInterpolation = { 1, 1, 2, }, cost = { }, },
		[4] = { 18, 75, 200, levelRequirement = 84, statInterpolation = { 1, 1, 2, }, cost = { }, },
	},
}
skills["LegionKaruiArcherSnipe"] = {
	name = "Snipe",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Damage] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.5,
	baseFlags = {
		attack = true,
		projectile = true,
		hit = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_cold",
		"active_skill_attack_speed_+%_final",
		"monster_projectile_variation",
		"active_skill_damage_+%_final",
		"base_is_projectile",
		"always_pierce",
		"skill_can_fire_arrows",
	},
	levels = {
		[1] = { 75, -50, 69, 0, baseMultiplier = 1.65, cooldown = 10, levelRequirement = 1, statInterpolation = { 1, 1, 1, 2, }, cost = { }, },
		[2] = { 75, -50, 69, 0, baseMultiplier = 1.65, cooldown = 10, levelRequirement = 20, statInterpolation = { 1, 1, 1, 2, }, cost = { }, },
		[3] = { 75, -50, 69, 1, baseMultiplier = 1.65, cooldown = 10, levelRequirement = 21, statInterpolation = { 1, 1, 1, 2, }, cost = { }, },
		[4] = { 75, -50, 69, 200, baseMultiplier = 1.65, cooldown = 10, levelRequirement = 84, statInterpolation = { 1, 1, 1, 2, }, cost = { }, },
	},
}
skills["MeleeAtAnimationSpeedFire"] = {
	name = "Default Attack",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Strike your foes down with a powerful blow.",
	skillTypes = { [SkillType.Attack] = true, [SkillType.RangedAttack] = true, [SkillType.MirageArcherCanUse] = true, [SkillType.Projectile] = true, [SkillType.MeleeSingleTarget] = true, [SkillType.Multistrikeable] = true, [SkillType.Melee] = true, [SkillType.ProjectilesFromUser] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		projectile = true,
		melee = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_fire",
		"active_skill_damage_+%_final",
		"skill_can_fire_arrows",
		"skill_can_fire_wand_projectiles",
		"action_attack_or_cast_time_uses_animation_length",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	levels = {
		[1] = { 75, 0, baseMultiplier = 0.75, levelRequirement = 1, statInterpolation = { 1, 2, }, cost = { }, },
		[2] = { 75, 0, baseMultiplier = 0.75, levelRequirement = 19, statInterpolation = { 1, 2, }, cost = { }, },
		[3] = { 75, 1, baseMultiplier = 0.75, levelRequirement = 20, statInterpolation = { 1, 2, }, cost = { }, },
		[4] = { 75, 200, baseMultiplier = 0.75, levelRequirement = 84, statInterpolation = { 1, 2, }, cost = { }, },
	},
}
skills["GAHellscapeDemonElite1DashSlash"] = {
	name = "Dash Slash",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"skill_physical_damage_%_to_convert_to_fire",
		"active_skill_damage_+%_final",
		"is_area_damage",
	},
	levels = {
		[1] = { 50, -30, levelRequirement = 1, statInterpolation = { 1, 2, }, cost = { }, },
		[2] = { 50, 0, levelRequirement = 19, statInterpolation = { 1, 2, }, cost = { }, },
		[3] = { 50, 1, levelRequirement = 20, statInterpolation = { 1, 2, }, cost = { }, },
		[4] = { 50, 60, levelRequirement = 84, statInterpolation = { 1, 2, }, cost = { }, },
	},
}
skills["GSHellscapeDemonElite1Screech"] = {
	name = "Screech",
	hidden = true,
	color = 4,
	baseEffectiveness = 0.75,
	incrementalEffectiveness = 0.029999999329448,
	skillTypes = { [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		hit = true,
		area = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"damage_hit_effect_index",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 43, critChance = 5, duration = 4, levelRequirement = 1, statInterpolation = { 3, 3, 1, }, cost = { }, },
	},
}
skills["TBHellscapePaleLightningBoltSpammableLeft"] = {
	name = "Lightning Bolt",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.5,
	incrementalEffectiveness = 0.045000001788139,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.333,
	baseFlags = {
		spell = true,
		hit = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"generic_skill_trigger_skills_with_id",
	},
	levels = {
		[1] = { 0.5, 1.5, 1, critChance = 5, levelRequirement = 0, statInterpolation = { 3, 3, 1, }, cost = { }, },
	},
}
skills["GSHellscapePaleEliteBoltImpact"] = {
	name = "Bolt Impact",
	hidden = true,
	color = 4,
	baseEffectiveness = 4,
	incrementalEffectiveness = 0.03999999910593,
	skillTypes = { [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		spell = true,
		area = true,
		hit = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"generic_skill_trigger_id",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, 1, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, 1, }, cost = { }, },
	},
}
skills["GSHellscapePaleEliteOmegaBeam"] = {
	name = "Omega Beam",
	hidden = true,
	color = 4,
	baseEffectiveness = 6.5,
	incrementalEffectiveness = 0.043099999427795,
	skillTypes = { [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.333,
	baseFlags = {
		spell = true,
		area = true,
		hit = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"spell_maximum_action_distance_+%",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.5, 1.5, -50, critChance = 5, cooldown = 6, levelRequirement = 1, statInterpolation = { 3, 3, 1, }, cost = { }, },
	},
}
skills["MMSHellscapeDemonEliteTripleMortar"] = {
	name = "Triple Mortal",
	hidden = true,
	color = 4,
	baseEffectiveness = 3.2000000476837,
	incrementalEffectiveness = 0.032000001519918,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		hit = true,
		triggerable = true,
		area = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"spell_maximum_action_distance_+%",
		"projectile_spread_radius",
		"skill_physical_damage_%_to_convert_to_fire",
		"active_skill_damage_+%_final",
		"is_area_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, -50, 15, 25, -30, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, 1, 1, 1, 2, }, cost = { }, },
		[2] = { 0.80000001192093, 1.2000000476837, -50, 15, 25, 0, critChance = 5, levelRequirement = 19, statInterpolation = { 3, 3, 1, 1, 1, 2, }, cost = { }, },
		[3] = { 0.80000001192093, 1.2000000476837, -50, 15, 25, 1, critChance = 5, levelRequirement = 20, statInterpolation = { 3, 3, 1, 1, 1, 2, }, cost = { }, },
		[4] = { 0.80000001192093, 1.2000000476837, -50, 15, 25, 24, critChance = 5, levelRequirement = 84, statInterpolation = { 3, 3, 1, 1, 1, 2, }, cost = { }, },
	},
}
skills["MMSHellscapeDemonEliteVomitMortar"] = {
	name = "Vomit Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.875,
	incrementalEffectiveness = 0.032000001519918,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2.7,
	baseFlags = {
		spell = true,
		hit = true,
		triggerable = true,
		area = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"spell_maximum_action_distance_+%",
		"projectile_spread_radius",
		"skill_physical_damage_%_to_convert_to_fire",
		"active_skill_damage_+%_final",
		"is_area_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"use_scaled_contact_offset",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, -50, 5, 25, -30, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, 1, 1, 1, 2, }, cost = { }, },
		[2] = { 0.80000001192093, 1.2000000476837, -50, 5, 25, 0, critChance = 5, levelRequirement = 19, statInterpolation = { 3, 3, 1, 1, 1, 2, }, cost = { }, },
		[3] = { 0.80000001192093, 1.2000000476837, -50, 5, 25, 1, critChance = 5, levelRequirement = 20, statInterpolation = { 3, 3, 1, 1, 1, 2, }, cost = { }, },
		[4] = { 0.80000001192093, 1.2000000476837, -50, 5, 25, 24, critChance = 5, levelRequirement = 84, statInterpolation = { 3, 3, 1, 1, 1, 2, }, cost = { }, },
	},
}
skills["GSHellscapeDemonEliteBeamNuke"] = {
	name = "Beam Nuke",
	hidden = true,
	color = 4,
	baseEffectiveness = 5,
	incrementalEffectiveness = 0.033500000834465,
	skillTypes = { [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		spell = true,
		hit = true,
		triggerable = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"spell_maximum_action_distance_+%",
		"skill_physical_damage_%_to_convert_to_fire",
		"active_skill_damage_+%_final",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, -50, 25, -30, critChance = 5, cooldown = 7, levelRequirement = 1, statInterpolation = { 3, 3, 1, 1, 2, }, cost = { }, },
		[2] = { 0.80000001192093, 1.2000000476837, -50, 25, 0, critChance = 5, cooldown = 7, levelRequirement = 19, statInterpolation = { 3, 3, 1, 1, 2, }, cost = { }, },
		[3] = { 0.80000001192093, 1.2000000476837, -50, 25, 1, critChance = 5, cooldown = 7, levelRequirement = 20, statInterpolation = { 3, 3, 1, 1, 2, }, cost = { }, },
		[4] = { 0.80000001192093, 1.2000000476837, -50, 25, 24, critChance = 5, cooldown = 7, levelRequirement = 84, statInterpolation = { 3, 3, 1, 1, 2, }, cost = { }, },
	},
}
skills["DTTHellscapeStabWeb"] = {
	name = "Web Debuff",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Movement] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 2,
	baseFlags = {
		spell = true,
		hit = true,
		movement = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"walk_emerge_extra_distance",
		"leap_slam_minimum_distance",
		"spell_maximum_action_distance_+%",
	},
	levels = {
		[1] = { 20, 40, -50, cooldown = 6, levelRequirement = 0, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["GAHellscapeStabbyCleave1"] = {
	name = "Cleave",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		hit = true,
		triggerable = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { baseMultiplier = 0.5, levelRequirement = 1, statInterpolation = { }, cost = { }, },
	},
}
skills["GAHellscapePaleEliteSkyStab"] = {
	name = "Stab Attack",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		hit = true,
		triggerable = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"is_area_damage",
	},
	levels = {
		[1] = { levelRequirement = 1, statInterpolation = { }, cost = { }, },
	},
}
skills["HellscapeFleshFodderArc"] = {
	name = "Scourge Arc",
	hidden = true,
	color = 3,
	baseEffectiveness = 1.3500000238419,
	incrementalEffectiveness = 0.045000001788139,
	description = "An arc of lightning stretches from the caster to a targeted enemy and chains on to other nearby enemies. Each time the main beam chains it will also chain to a second enemy, but that secondary arc cannot chain further.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Chains] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Lightning] = true, [SkillType.CanRapidFire] = true, },
	statDescriptionScope = "beam_skill_stat_descriptions",
	castTime = 1.166,
	baseFlags = {
		spell = true,
		chaining = true,
		triggerable = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_lightning_damage",
		"spell_maximum_base_lightning_damage",
		"base_chance_to_shock_%",
		"number_of_chains",
		"spell_maximum_action_distance_+%",
		"shock_art_variation",
		"disable_visual_hit_effect",
	},
	levels = {
		[1] = { 0.5, 1.5, 10, 0, -50, 2, critChance = 5, levelRequirement = 1, statInterpolation = { 3, 3, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["SynthesisSoulstealerProjectilePhysical"] = {
	name = "Projectile",
	hidden = true,
	color = 4,
	incrementalEffectiveness = 0.037999998778105,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.33,
	baseFlags = {
		spell = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"monster_projectile_variation",
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
	},
	levels = {
		[1] = { 104, 0.80000001192093, 1.2000000476837, critChance = 5, levelRequirement = 0, statInterpolation = { 1, 3, 3, }, cost = { }, },
	},
}
skills["SynthesisPhysicalTripleMortar"] = {
	name = "Triple Mortar",
	hidden = true,
	color = 4,
	baseEffectiveness = 0,
	description = "Generic monster mortar skill. Like Monster Projectile but has an impact effect.",
	skillTypes = { [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Area] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 3.67,
	baseFlags = {
		area = true,
		spell = true,
		projectile = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"projectile_spread_radius",
		"projectile_minimum_range",
		"number_of_additional_projectiles",
		"mortar_projectile_distance_override",
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"skill_physical_damage_%_to_convert_to_fire",
		"number_of_projectiles_override",
		"is_area_damage",
		"base_is_projectile",
		"projectile_uses_contact_position",
		"mortar_projectile_scale_animation_speed_instead_of_projectile_speed",
	},
	levels = {
		[1] = { 25, 20, 0, 0, 0.80000001192093, 1.2000000476837, 0, 2, critChance = 5, cooldown = 12, levelRequirement = 0, statInterpolation = { 1, 1, 1, 1, 3, 3, 1, 1, }, cost = { }, },
	},
}
skills["SynthesisSoulstealerQuicksand"] = {
	name = "Quicksand",
	hidden = true,
	color = 4,
	baseEffectiveness = 2.5,
	incrementalEffectiveness = 0.045000001788139,
	skillTypes = { [SkillType.Area] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.67,
	baseFlags = {
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"base_skill_effect_duration",
		"ground_quicksand_art_variation",
		"base_physical_damage_to_deal_per_minute",
	},
	levels = {
		[1] = { 6000, 4, 16.666667039196, cooldown = 8, levelRequirement = 0, statInterpolation = { 1, 1, 3, }, cost = { }, },
	},
}
skills["SynthesisPhysicalVolatileSlam"] = {
	name = "Volatile Slam",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Triggerable] = true, [SkillType.Attack] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	baseFlags = {
		attack = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"active_skill_damage_+%_final",
		"is_area_damage",
	},
	levels = {
		[1] = { 0, levelRequirement = 0, statInterpolation = { 1, }, cost = { }, },
	},
}
skills["HellionRallyingCry"] = {
	name = "Rallying Cry",
	hidden = true,
	color = 1,
	description = "Performs a warcry, granting increased damage and mana regeneration to the user and nearby allies if there are nearby enemies. The damage increase is proportional to the number of surrounding enemies. Taunts all nearby enemies to attack the user. Shares a cooldown with other Warcry skills.",
	skillTypes = { [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Warcry] = true, [SkillType.Cooldown] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.25,
	baseFlags = {
		area = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"damage_+%",
		"base_skill_effect_duration",
		"taunted_enemies_damage_+%_final_vs_non_taunt_target",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 8, 8000, -30, cooldown = 8, levelRequirement = 1, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[2] = { 10, 8000, -30, cooldown = 8, levelRequirement = 50, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[3] = { 12, 8000, -30, cooldown = 8, levelRequirement = 68, statInterpolation = { 1, 1, 1, }, cost = { }, },
		[4] = { 15, 8000, -30, cooldown = 8, levelRequirement = 77, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["EmptyActionSpellWarlordGrandmaster"] = {
	name = "Arena Master's Presence",
	hidden = true,
	color = 4,
	skillTypes = { },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 4,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Cooldown] = true, },
	statMap = {
		["auras_grant_damage_+%_to_you_and_your_allies"] = {
			mod("Damage", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Arena Master's Presence" }),
		},
		["cast_speed_+%_granted_from_skill"] = {
			mod("Speed", "INC", nil, ModFlag.Cast, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Arena Master's Presence" }),
		},
		["attack_speed_+%_granted_from_skill"] = {
			mod("Speed", "INC", nil, ModFlag.Attack, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Arena Master's Presence" }),
		},
		["base_movement_velocity_+%"] = {
			mod("MovementSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Arena Master's Presence" }),
		},
	},
	stats = {
		"auras_grant_damage_+%_to_you_and_your_allies",
		"attack_speed_+%_granted_from_skill",
		"cast_speed_+%_granted_from_skill",
		"base_movement_velocity_+%",
	},
	levels = {
		[1] = { 20, 20, 20, 20, duration = 4, cooldown = 12, levelRequirement = 0, statInterpolation = { 1, 1, 1, 1 }, cost = { }, },
	},
	baseFlags = {
		spell = true,
		buff = true,
		area = true,
		duration = true,
		cooldown = true,
	},
	baseMods = {
		skill("buffAllies", true),
		skill("buffMinions", true),
	},
	qualityStats = {
	},
}
skills["BreachBlizzardSpectre"] = {
	name = "Snow Cloak",
	hidden = true,
	color = 4,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Damage] = true, [SkillType.AreaSpell] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Buff] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Cooldown] = true, },
	statMap = {
		["avoid_damage_%"] = {
			mod("AvoidPhysicalDamageChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Snow Cloak" }),
			mod("AvoidLightningDamageChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Snow Cloak" }),
			mod("AvoidColdDamageChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Snow Cloak" }),
			mod("AvoidFireDamageChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Snow Cloak" }),
			mod("AvoidChaosDamageChance", "BASE", nil, 0, 0, { type = "GlobalEffect", effectType = "Buff", effectName = "Snow Cloak" }),
		},
	},
	baseFlags = {
		spell = true,
		buff = true,
		area = true,
		duration = true,
		cooldown = true,
	},
	baseMods = {
		skill("buffAllies", true),
		skill("buffMinions", true),
	},
	qualityStats = {
	},
	stats = {
		"base_damage_taken_+%",
		"avoid_damage_%",
		"base_skill_effect_duration",
	},
	levels = {
		[1] = { 0, 15, 10000, cooldown = 9, levelRequirement = 1, statInterpolation = { 1, 1, 1, }, cost = { }, },
	},
}
skills["DelveWraithScreechChaos"] = {
	name = "Chaos Screech",
	hidden = true,
	color = 4,
	baseEffectiveness = 1.7999999523163,
	incrementalEffectiveness = 0.029999999329448,
	skillTypes = { [SkillType.Spell] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 1.5,
	baseFlags = {
		spell = true,
		area = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_chaos_damage",
		"spell_maximum_base_chaos_damage",
		"is_area_damage",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, levelRequirement = 1, statInterpolation = { 3, 3, }, cost = { }, },
	},
}
skills["MonsterChanceToTemporalChainsOnHit1"] = {
	name = "Temporal Chains",
	hidden = true,
	color = 2,
	baseEffectiveness = 0,
	description = "Curses all enemies in an area, lowering their action speed and making other effects on them expire more slowly.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["temporal_chains_action_speed_+%_final"] = {
			mod("TemporalChainsActionSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique", neg = true }),
		},
		["buff_time_passed_+%_other_than_temporal_chains"] = {
			mod("BuffExpireFaster", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
		["curse_effect_+%_final_vs_players"] = {
			mod("CurseEffectAgainstPlayer", "MORE", nil),
		},
		["temporal_chains_action_speed_+%_vs_rare_or_unique_final"] = {
			mod("TemporalChainsActionSpeed", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
		hex = true,
	},
	baseMods = {
		skill("debuff", true),
		skill("radius", 22),
		mod("MaxDoom", "BASE", 30),
	},
	qualityStats = {
		Default = {
			{ "curse_effect_+%", 0.5 },
		},
		Alternate1 = {
			{ "hex_doom_gain_rate_+%", 2 },
		},
		Alternate2 = {
			{ "base_curse_duration_+%", 1 },
		},
	},
	stats = {
		"base_skill_effect_duration",
		"active_skill_base_radius_+",
		"temporal_chains_action_speed_+%_final",
		"buff_time_passed_+%_other_than_temporal_chains",
		"curse_effect_+%_final_vs_players",
		"temporal_chains_action_speed_+%_vs_rare_or_unique_final",
		"base_curse_skill_doom_gain_per_minute_if_cast_yourself",
		"base_deal_no_damage",
	},
	levels = {
		[1] = { 5000, 0, -20, -40, -50, -10, 600, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}

skills["WraithEtherealKnives"] = {
	name = "Ethereal Knives",
	hidden = true,
	color = 2,
	baseEffectiveness = 1.7000000476837,
	incrementalEffectiveness = 0.037999998778105,
	description = "Fires an arc of knives in front of the caster which deals physical damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Damage] = true, [SkillType.Projectile] = true, [SkillType.ProjectilesFromUser] = true, [SkillType.Totemable] = true, [SkillType.Trappable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.CanRapidFire] = true, [SkillType.Physical] = true, [SkillType.Duration] = true, },
	statDescriptionScope = "skill_stat_descriptions",
	castTime = 0.8,
	baseFlags = {
		spell = true,
		projectile = true,
		duration = true,
	},
	baseMods = {
	},
	qualityStats = {
	},
	stats = {
		"spell_minimum_base_physical_damage",
		"spell_maximum_base_physical_damage",
		"number_of_additional_projectiles",
		"base_cast_speed_+%",
		"monster_penalty_against_minions_damage_+%_final_vs_player_minions",
		"active_skill_damage_+%_final",
		"base_projectile_speed_+%",
		"fixed_projectile_spread",
		"base_is_projectile",
	},
	levels = {
		[1] = { 0.80000001192093, 1.2000000476837, 9, -25, 0, -15, 25, 20, critChance = 5, levelRequirement = 51, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[2] = { 0.60000002384186, 0.89999997615814, 9, -25, -25, -15, 25, 20, critChance = 5, levelRequirement = 68, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
		[3] = { 0.60000002384186, 0.89999997615814, 9, -25, -25, -15, 25, 20, critChance = 5, levelRequirement = 82, statInterpolation = { 3, 3, 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
skills["DelveMonsterEnfeebleOnHit"] = {
	name = "Enfeeble",
	hidden = true,
	color = 3,
	baseEffectiveness = 0,
	description = "Curses all targets in an area, reducing their accuracy and making them deal less damage.",
	skillTypes = { [SkillType.Spell] = true, [SkillType.Area] = true, [SkillType.Duration] = true, [SkillType.Trappable] = true, [SkillType.Totemable] = true, [SkillType.Mineable] = true, [SkillType.Multicastable] = true, [SkillType.Triggerable] = true, [SkillType.Cascadable] = true, [SkillType.AppliesCurse] = true, [SkillType.CanRapidFire] = true, [SkillType.AreaSpell] = true, [SkillType.InstantNoRepeatWhenHeld] = true, [SkillType.InstantShiftAttackForLeftMouse] = true, [SkillType.Hex] = true, },
	statDescriptionScope = "curse_skill_stat_descriptions",
	castTime = 0.5,
	statMap = {
		["enfeeble_damage_+%_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique", neg = true }),
		},
		["enfeeble_damage_+%_vs_rare_or_unique_final"] = {
			mod("Damage", "MORE", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }, { type = "Condition", var = "RareOrUnique" }),
		},
		["accuracy_rating_+%"] = {
			mod("Accuracy", "INC", nil, 0, 0, { type = "GlobalEffect", effectType = "Curse" }),
		},
	},
	baseFlags = {
		spell = true,
		curse = true,
		area = true,
		duration = true,
		hex = true,
	},
	baseMods = {
		skill("debuff", true),
		skill("radius", 22),
		mod("MaxDoom", "BASE", 30),
	},
	qualityStats = {
		Default = {
			{ "curse_effect_+%", 0.5 },
		},
		Alternate1 = {
			{ "hex_doom_gain_rate_+%", 2 },
		},
		Alternate2 = {
			{ "curse_cast_speed_+%", 0.5 },
		},
	},
	stats = {
		"base_skill_effect_duration",
		"active_skill_base_radius_+",
		"accuracy_rating_+%",
		"enfeeble_damage_+%_final",
		"enfeeble_damage_+%_vs_rare_or_unique_final",
		"base_curse_skill_doom_gain_per_minute_if_cast_yourself",
		"base_deal_no_damage",
	},
	levels = {
		[8] = { 9700, 4, -13, -24, -12, 600, levelRequirement = 1, statInterpolation = { 1, 1, 1, 1, 1, 1, }, cost = { }, },
	},
}
