-- Path of Building
--
-- Module: Calc Sections
-- List of sections for the Calcs tab
--

-- Commonly used modifier lists
local physicalHitTaken = {
	"DamageTaken", "PhysicalDamageTaken"
}
local lightningHitTaken = {
	"DamageTaken", "LightningDamageTaken", "ElementalDamageTaken", "LightningResist", "ElementalResist"
}
local coldHitTaken = {
	"DamageTaken", "ColdDamageTaken", "ElementalDamageTaken", "ColdResist", "ElementalResist"
}
local fireHitTaken = {
	"DamageTaken", "FireDamageTaken", "ElementalDamageTaken", "FireResist", "ElementalResist"
}
local chaosHitTaken = {
	"DamageTaken", "ChaosDamageTaken", "ChaosResist"
}
local physicalConvert = { 
	"SkillPhysicalDamageConvertToLightning", "SkillPhysicalDamageConvertToCold", "SkillPhysicalDamageConvertToFire", "SkillPhysicalDamageConvertToChaos", 
	"PhysicalDamageConvertToLightning", "PhysicalDamageConvertToCold", "PhysicalDamageConvertToFire", "PhysicalDamageConvertToChaos", "NonChaosDamageConvertToChaos", 
	"PhysicalDamageGainAsLightning", "PhysicalDamageGainAsCold", "PhysicalDamageGainAsFire", "PhysicalDamageGainAsChaos", "NonChaosDamageGainAsChaos" 
}
local lightningConvert = {
	"SkillLightningDamageConvertToCold", "SkillLightningDamageConvertToFire", "SkillLightningDamageConvertToChaos",
	"LightningDamageConvertToCold", "LightningDamageConvertToFire", "LightningDamageConvertToChaos", "ElementalDamageConvertToChaos", "NonChaosDamageConvertToChaos", 
	"LightningDamageGainAsCold", "LightningDamageGainAsFire", "LightningDamageGainAsChaos", "ElementalDamageGainAsChaos", "NonChaosDamageGainAsChaos"
}
local coldConvert = { 
	"SkillColdDamageConvertToFire", "SkillColdDamageConvertToChaos",
	"ColdDamageConvertToFire", "ColdDamageConvertToChaos", "ElementalDamageConvertToChaos", "NonChaosDamageConvertToChaos",
	"ColdDamageGainAsFire", "ColdDamageGainAsChaos", "ElementalDamageGainAsChaos", "NonChaosDamageGainAsChaos"
}
local fireConvert = {
	"SkillFireDamageConvertToChaos",
	"FireDamageConvertToChaos", "ElementalDamageConvertToChaos", "NonChaosDamageConvertToChaos", 
	"FireDamageGainAsChaos", "ElementalDamageGainAsChaos", "NonChaosDamageGainAsChaos"
}

-- format {width, id, group, color, subection:{default hidden, label, data:{}}}
return {
{ 3, "HitDamage", 1, colorCodes.OFFENCE, {{ defaultCollapsed = false, label = "Skill Hit Damage", data = {
	extra = "{output:DisplayDamage}",
	flag = "hit",
	colWidth = 95,
	{
		{ format = "All Types:", },
		{ format = "Physical:" },
		{ format = "Lightning:" },
		{ format = "Cold:" },
		{ format = "Fire:" },
		{ format = "Chaos:" },
	},
	{ label = "Added Min",
		{ },
		{ format = "{0:mod:1,2}", 
			{ label = "Player modifiers", modName = "PhysicalMin", modType = "BASE", cfg = "skill" },
			{ label = "Enemy modifiers", modName = "SelfPhysicalMin", modType = "BASE", enemy = true, cfg = "skill" },
		},
		{ format = "{0:mod:1,2}", 
			{ label = "Player modifiers", modName = "LightningMin", modType = "BASE", cfg = "skill" },
			{ label = "Enemy modifiers", modName = "SelfLightningMin", modType = "BASE", enemy = true, cfg = "skill" },
		},
		{ format = "{0:mod:1,2}", 
			{ label = "Player modifiers", modName = "ColdMin", modType = "BASE", cfg = "skill" },
			{ label = "Enemy modifiers", modName = "SelfColdMin", modType = "BASE", enemy = true, cfg = "skill" },
		},
		{ format = "{0:mod:1,2}", 
			{ label = "Player modifiers", modName = "FireMin", modType = "BASE", cfg = "skill" },
			{ label = "Enemy modifiers", modName = "SelfFireMin", modType = "BASE", enemy = true, cfg = "skill" },
		},
		{ format = "{0:mod:1,2}", 
			{ label = "Player modifiers", modName = "ChaosMin", modType = "BASE", cfg = "skill" },
			{ label = "Enemy modifiers", modName = "SelfChaosMin", modType = "BASE", enemy = true, cfg = "skill" },
		},
	},
	{ label = "Added Max",
		{ },
		{ format = "{0:mod:1,2}", 
			{ label = "Player modifiers", modName = "PhysicalMax", modType = "BASE", cfg = "skill" },
			{ label = "Enemy modifiers", modName = "SelfPhysicalMax", modType = "BASE", enemy = true, cfg = "skill" },
		},
		{ format = "{0:mod:1,2}", 
			{ label = "Player modifiers", modName = "LightningMax", modType = "BASE", cfg = "skill" },
			{ label = "Enemy modifiers", modName = "SelfLightningMax", modType = "BASE", enemy = true, cfg = "skill" },
		},
		{ format = "{0:mod:1,2}", 
			{ label = "Player modifiers", modName = "ColdMax", modType = "BASE", cfg = "skill" },
			{ label = "Enemy modifiers", modName = "SelfColdMax", modType = "BASE", enemy = true, cfg = "skill" },
		},
		{ format = "{0:mod:1,2}", 
			{ label = "Player modifiers", modName = "FireMax", modType = "BASE", cfg = "skill" },
			{ label = "Enemy modifiers", modName = "SelfFireMax", modType = "BASE", enemy = true, cfg = "skill" },
		},
		{ format = "{0:mod:1,2}", 
			{ label = "Player modifiers", modName = "ChaosMax", modType = "BASE", cfg = "skill" },
			{ label = "Enemy modifiers", modName = "SelfChaosMax", modType = "BASE", enemy = true, cfg = "skill" },
		},
	},
	-- Skill Hit Damage
	{ label = "Total Increased", notFlag = "attack",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "INC", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "INC", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "INC", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "INC", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "INC", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "INC", cfg = "skill" }, },
	},
	{ label = "Total More", notFlag = "attack",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "MORE", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "MORE", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "MORE", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "MORE", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "MORE", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "MORE", cfg = "skill" }, },
	},
	{ label = "Effective DPS Mod", notFlag = "attack", flag = "effective",
		{ },
		{ format = "x {3:output:PhysicalEffMult}",
			{ breakdown = "PhysicalEffMult" },
			{ label = "Enemy modifiers", modName = physicalHitTaken, enemy = true, cfg = "skill" }, 
		},
		{ format = "x {3:output:LightningEffMult}",
			{ breakdown = "LightningEffMult" },
			{ label = "Player modifiers", modName = { "LightningPenetration", "ElementalPenetration" }, cfg = "skill" },
			{ label = "Enemy modifiers", modName = lightningHitTaken, enemy = true, cfg = "skill" },
		},
		{ format = "x {3:output:ColdEffMult}",
			{ breakdown = "ColdEffMult" },
			{ label = "Player modifiers", modName = { "ColdPenetration", "ElementalPenetration" }, cfg = "skill" },
			{ label = "Enemy modifiers", modName = coldHitTaken, enemy = true, cfg = "skill" },
		},
		{ format = "x {3:output:FireEffMult}",
			{ breakdown = "FireEffMult" },
			{ label = "Player modifiers", modName = { "FirePenetration", "ElementalPenetration" }, cfg = "skill" },
			{ label = "Enemy modifiers", modName = fireHitTaken, enemy = true, cfg = "skill" },
		},
		{ format = "x {3:output:ChaosEffMult}",
			{ breakdown = "ChaosEffMult" },
			{ label = "Player modifiers", modName = "ChaosPenetration", cfg = "skill" },
			{ label = "Enemy modifiers", modName = chaosHitTaken, enemy = true, cfg = "skill" },
		},
	},
	{ label = "Skill Hit Damage", textSize = 12, notFlag = "attack",
		{ format = "{0:output:TotalMin} to {0:output:TotalMax}", },
		{ format = "{0:output:PhysicalMin} to {0:output:PhysicalMax}", 
			{ breakdown = "Physical" }, 
			{ label = "Conversions", modType = "BASE", cfg = "skill", modName = physicalConvert }, 
		},
		{ format = "{0:output:LightningMin} to {0:output:LightningMax}", 
			{ breakdown = "Lightning" }, 
			{ label = "Conversions", modType = "BASE", cfg = "skill", modName = lightningConvert }, 
		},
		{ format = "{0:output:ColdMin} to {0:output:ColdMax}", 
			{ breakdown = "Cold" }, 
			{ label = "Conversions", modType = "BASE", cfg = "skill", modName = coldConvert }, 
		},
		{ format = "{0:output:FireMin} to {0:output:FireMax}", 
			{ breakdown = "Fire" }, 
			{ label = "Conversions", modType = "BASE", cfg = "skill", modName = fireConvert }, 
		},
		{ format = "{0:output:ChaosMin} to {0:output:ChaosMax}", 
			{ breakdown = "Chaos" }, 
		},
	},
	{ label = "Skill Average Hit", notFlag = "attack", { format = "{1:output:AverageHit}", { breakdown = "AverageHit" }, }, },
	-- Main Hand Hit Damage
	{ label = "MH Total Increased", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "INC", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "INC", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "INC", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "INC", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "INC", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "INC", cfg = "weapon1" }, },
	},
	{ label = "MH Total More", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "MORE", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "MORE", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "MORE", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "MORE", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "MORE", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "MORE", cfg = "weapon1" }, },
	},
	{ label = "MH Eff. DPS Mod", bgCol = colorCodes.MAINHANDBG, flagList = {"weapon1Attack","effective"},
		{ },
		{ format = "x {3:output:MainHand.PhysicalEffMult}",
			{ breakdown = "MainHand.PhysicalEffMult" },
			{ label = "Enemy modifiers", modName = physicalHitTaken, enemy = true, cfg = "weapon1" }, 
		},
		{ format = "x {3:output:MainHand.LightningEffMult}",
			{ breakdown = "MainHand.LightningEffMult" },
			{ label = "Player modifiers", modName = { "LightningPenetration", "ElementalPenetration" }, cfg = "weapon1" },
			{ label = "Enemy modifiers", modName = lightningHitTaken, enemy = true, cfg = "weapon1" },
		},
		{ format = "x {3:output:MainHand.ColdEffMult}",
			{ breakdown = "MainHand.ColdEffMult" },
			{ label = "Player modifiers", modName = { "ColdPenetration", "ElementalPenetration" }, cfg = "weapon1" },
			{ label = "Enemy modifiers", modName = coldHitTaken, enemy = true, cfg = "weapon1" },
		},
		{ format = "x {3:output:MainHand.FireEffMult}",
			{ breakdown = "MainHand.FireEffMult" },
			{ label = "Player modifiers", modName = { "FirePenetration", "ElementalPenetration" }, cfg = "weapon1" },
			{ label = "Enemy modifiers", modName = fireHitTaken, enemy = true, cfg = "weapon1" },
		},
		{ format = "x {3:output:MainHand.ChaosEffMult}",
			{ breakdown = "MainHand.ChaosEffMult" },
			{ label = "Player modifiers", modName = "ChaosPenetration", cfg = "weapon1" },
			{ label = "Enemy modifiers", modName = chaosHitTaken, enemy = true, cfg = "weapon1" },
		},
	},
	{ label = "MH Hit Damage", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack",
		{ format = "{0:output:MainHand.TotalMin} to {0:output:MainHand.TotalMax}", },
		{ format = "{0:output:MainHand.PhysicalMin} to {0:output:MainHand.PhysicalMax}", 
			{ breakdown = "MainHand.Physical" }, 
			{ label = "Conversions", modType = "BASE", cfg = "weapon1", modName = physicalConvert },
		},
		{ format = "{0:output:MainHand.LightningMin} to {0:output:MainHand.LightningMax}", 
			{ breakdown = "MainHand.Lightning" }, 
			{ label = "Conversions", modType = "BASE", cfg = "weapon1", modName = lightningConvert }, 
		},
		{ format = "{0:output:MainHand.ColdMin} to {0:output:MainHand.ColdMax}", 
			{ breakdown = "MainHand.Cold" }, 
			{ label = "Conversions", modType = "BASE", cfg = "weapon1", modName = coldConvert }, 
		},
		{ format = "{0:output:MainHand.FireMin} to {0:output:MainHand.FireMax}", 
			{ breakdown = "MainHand.Fire" }, 
			{ label = "Conversions", modType = "BASE", cfg = "weapon1", modName = fireConvert }, 
		},
		{ format = "{0:output:MainHand.ChaosMin} to {0:output:MainHand.ChaosMax}", 
			{ breakdown = "MainHand.Chaos" }, 
		},
	},
	{ label = "MH Average Hit", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "{1:output:MainHand.AverageHit}", { breakdown = "MainHand.AverageHit" }, }, },
	-- Off Hand Hit Damage
	{ label = "OH Total Increased", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "INC", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "INC", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "INC", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "INC", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "INC", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "INC", cfg = "weapon2" }, },
	},
	{ label = "OH Total More", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "MORE", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "MORE", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "MORE", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "MORE", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "MORE", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "MORE", cfg = "weapon2" }, },
	},
	{ label = "OH Eff. DPS Mod", bgCol = colorCodes.OFFHANDBG, flagList = {"weapon2Attack","effective"},
		{ },
		{ format = "x {3:output:OffHand.PhysicalEffMult}",
			{ breakdown = "OffHand.PhysicalEffMult" },
			{ label = "Enemy modifiers", modName = physicalHitTaken, enemy = true, cfg = "weapon2" }, 
		},
		{ format = "x {3:output:OffHand.LightningEffMult}",
			{ breakdown = "OffHand.LightningEffMult" },
			{ label = "Player modifiers", modName = { "LightningPenetration", "ElementalPenetration" }, cfg = "weapon2" },
			{ label = "Enemy modifiers", modName = lightningHitTaken, enemy = true, cfg = "weapon2" },
		},
		{ format = "x {3:output:OffHand.ColdEffMult}",
			{ breakdown = "OffHand.ColdEffMult" },
			{ label = "Player modifiers", modName = { "ColdPenetration", "ElementalPenetration" }, cfg = "weapon2" },
			{ label = "Enemy modifiers", modName = coldHitTaken, enemy = true, cfg = "weapon2" },
		},
		{ format = "x {3:output:OffHand.FireEffMult}",
			{ breakdown = "OffHand.FireEffMult" },
			{ label = "Player modifiers", modName = { "FirePenetration", "ElementalPenetration" }, cfg = "weapon2" },
			{ label = "Enemy modifiers", modName = fireHitTaken, enemy = true, cfg = "weapon2" },
		},
		{ format = "x {3:output:OffHand.ChaosEffMult}",
			{ breakdown = "OffHand.ChaosEffMult" },
			{ label = "Player modifiers", modName = "ChaosPenetration", cfg = "weapon2" },
			{ label = "Enemy modifiers", modName = chaosHitTaken, enemy = true, cfg = "weapon2" },
		},
	},
	{ label = "OH Hit Damage", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack",
		{ format = "{0:output:OffHand.TotalMin} to {0:output:OffHand.TotalMax}", },
		{ format = "{0:output:OffHand.PhysicalMin} to {0:output:OffHand.PhysicalMax}", 
			{ breakdown = "OffHand.Physical" }, 
			{ label = "Conversions", modType = "BASE", cfg = "weapon2", modName = physicalConvert },
		},
		{ format = "{0:output:OffHand.LightningMin} to {0:output:OffHand.LightningMax}", 
			{ breakdown = "OffHand.Lightning" }, 
			{ label = "Conversions", modType = "BASE", cfg = "weapon2", modName = lightningConvert }, 
		},
		{ format = "{0:output:OffHand.ColdMin} to {0:output:OffHand.ColdMax}", 
			{ breakdown = "OffHand.Cold" }, 
			{ label = "Conversions", modType = "BASE", cfg = "weapon2", modName = coldConvert }, 
		},
		{ format = "{0:output:OffHand.FireMin} to {0:output:OffHand.FireMax}", 
			{ breakdown = "OffHand.Fire" }, 
			{ label = "Conversions", modType = "BASE", cfg = "weapon2", modName = fireConvert }, 
		},
		{ format = "{0:output:OffHand.ChaosMin} to {0:output:OffHand.ChaosMax}", 
			{ breakdown = "OffHand.Chaos" },
		},
	},
	{ label = "OH Average Hit", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "{1:output:OffHand.AverageHit}", { breakdown = "OffHand.AverageHit" }, }, },
	{ label = "Average Damage", flag = "attack", { format = "{1:output:AverageDamage}", 
		{ breakdown = "MainHand.AverageDamage" },
		{ breakdown = "OffHand.AverageDamage" },
		{ breakdown = "AverageDamage" },
	}, },
	{ label = "Skill DPS", flag = "notAverage", notFlag = "triggered", { format = "{1:output:TotalDPS}", { breakdown = "TotalDPS" }, }, },
	{ label = "Skill DPS", flag = "triggered", { format = "{1:output:TotalDPS}", { breakdown = "TotalDPS" }, }, },
	{ label = "Mana Cost", haveOutput = "ManaCost", { format = "{0:output:ManaCost}", { breakdown = "ManaCost" }, { modName = { "ManaCost", "Cost" }, cfg = "skill" }, }, },
	{ label = "Life Cost", haveOutput = "LifeCost", { format = "{0:output:LifeCost}", { breakdown = "LifeCost" }, { modName = { "LifeCost", "Cost" }, cfg = "skill" }, }, },
	{ label = "ES Cost", haveOutput = "ESCost", { format = "{0:output:ESCost}", { breakdown = "ESCost" }, { modName = { "ESCost", "Cost" }, cfg = "skill" }, }, },
	{ label = "Rage Cost", haveOutput = "RageCost", { format = "{0:output:RageCost}", { breakdown = "RageCost" }, { modName = { "RageCost", "Cost" }, cfg = "skill" }, }, },
	{ label = "Mana % Cost", haveOutput = "ManaPercentCost", { format = "{0:output:ManaPercentCost}", { breakdown = "ManaPercentCost" }, { modName = { "ManaPercentCost", "ManaCost", "Cost" }, cfg = "skill" }, }, },
	{ label = "Life % Cost", haveOutput = "LifePercentCost", { format = "{0:output:LifePercentCost}", { breakdown = "LifePercentCost" }, { modName = { "LifePercentCost", "LifeCost", "Cost" }, cfg = "skill" }, }, },
} }
} },
{ 3, "Warcries", 1, colorCodes.OFFENCE, {{ defaultCollapsed = false, label = "Exerting Warcries", data = {
	extra = "{2:output:TheoreticalOffensiveWarcryEffect} Avg Combined Impact  |  {2:output:TheoreticalMaxOffensiveWarcryEffect} Max Combined Impact",
	colWidth = 114,
	{
		haveOutput = "CreateWarcryOffensiveCalcSection",
		{ format = "Effective Impact" },
		{ format = "Avg Dmg Effect" },
		{ format = "Uptime" },
		{ format = "Number of Exerts" },
		{ format = "Max 1-Hit Impact"},
	},
	{ label = "Seismic Cry", haveOutput = "SeismicUpTimeRatio", 
		{ format = "{2:output:SeismicHitEffect}", { breakdown = "SeismicHitEffect"}, },
		{ format = "{2:output:SeismicAvgDmg}", { breakdown = "SeismicAvgDmg"}, },
		{ format = "{0:output:SeismicUpTimeRatio}%", { breakdown = "SeismicUpTimeRatio" }, },
		{ format = "{0:output:SeismicExertsCount}" },
		{ format = "{2:output:SeismicMaxHitEffect}" },
	},
	{ label = "Intimidating Cry", haveOutput = "IntimidatingUpTimeRatio", 
		{ format = "{2:output:IntimidatingHitEffect}", { breakdown = "IntimidatingHitEffect"}, },
		{ format = "{2:output:IntimidatingAvgDmg}", { breakdown = "IntimidatingAvgDmg"}, },
		{ format = "{0:output:IntimidatingUpTimeRatio}%", { breakdown = "IntimidatingUpTimeRatio" }, },
		{ format = "{0:output:IntimidatingExertsCount}" },
		{ format = "{2:output:IntimidatingMaxHitEffect}" },
	},
	{ label = "Rallying Cry", haveOutput = "RallyingUpTimeRatio", 
		{ format = "{2:output:RallyingHitEffect}", { breakdown = "RallyingHitEffect"}, },
		{ format = "{2:output:RallyingAvgDmg}", { breakdown = "RallyingAvgDmg"}, },
		{ format = "{0:output:RallyingUpTimeRatio}%", { breakdown = "RallyingUpTimeRatio" }, },
		{ format = "{0:output:RallyingExertsCount}" },
		{ format = "{2:output:RallyingMaxHitEffect}" },
	},
	{ label = "Infernal Cry", haveOutput = "InfernalUpTimeRatio", 
		{ format = "" },
		{ format = "" },
		{ format = "{0:output:InfernalUpTimeRatio}%", { breakdown = "InfernalUpTimeRatio" }, },
		{ format = "{0:output:InfernalExertsCount}" },
		{ format = "" },
	},
	{ label = "Ancestral Cry", haveOutput = "AncestralUpTimeRatio", 
		{ format = "" },
		{ format = "" },
		{ format = "{0:output:AncestralUpTimeRatio}%", { breakdown = "AncestralUpTimeRatio" }, },
		{ format = "{0:output:AncestralExertsCount}" },
		{ format = "" },
	},
	{ label = "Exerted Attacks", bgCol = colorCodes.MAINHANDBG, haveOutput = "ExertedAttackUptimeRatio",
		{ format = "{2:output:ExertedAttackHitEffect}", { breakdown = "ExertedAttackHitEffect"}, },
		{ format = "{2:output:ExertedAttackAvgDmg}", { modName = "ExertIncrease", cfg = "skill" }, },
		{ format = "{0:output:ExertedAttackUptimeRatio}%", { breakdown = "ExertedAttackUptimeRatio" }, },
		{ format = "" },
		{ format = "{2:output:ExertedAttackMaxHitEffect}", { modName = "ExertIncrease", cfg = "skill" }, },
	},
	{ label = "Fist of War", bgCol = colorCodes.MAINHANDBG, haveOutput = "FistOfWarUptimeRatio",
		{ format = "{2:output:AvgFistOfWarHitEffect}", { breakdown = "AvgFistOfWarHitEffect"}, },
		{ format = "{2:output:AvgFistOfWarHit}", { modName = "FistOfWarHitMultiplier", cfg = "skill"}, },
		{ format = "{0:output:FistOfWarUptimeRatio}%", { breakdown = "FistOfWarUptimeRatio" },  },
		{ format = "" },
		{ format = "{2:output:MaxFistOfWarHitEffect}" },
	},
} }
} },
{ 3, "Dot", 1, colorCodes.OFFENCE, {{ defaultCollapsed = false, label = "Skill Damage over Time", data = {
	extra = "{1:output:TotalDot} total DoT",
	flag = "dot",
	colWidth = 95,
	{ { format = "All Types:", }, { format = "Physical:" }, { format = "Lightning:" }, { format = "Cold:" }, { format = "Fire:" }, { format = "Chaos:" }, },
	{ label = "Total Increased",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "INC", cfg = "dot" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "INC", cfg = "dotPhysical" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "INC", cfg = "dotLightning" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "INC", cfg = "dotCold" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "INC", cfg = "dotFire" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "INC", cfg = "dotChaos" }, },
	},
	{ label = "Total More",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "MORE", cfg = "dot" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "MORE", cfg = "dotPhysical" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "MORE", cfg = "dotLightning" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "MORE", cfg = "dotCold" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "MORE", cfg = "dotFire" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "MORE", cfg = "dotChaos" }, },
	},
	{ label = "Total Multiplier",
		{ format = "{0:mod:1}%", { modName = "DotMultiplier", modType = "BASE", cfg = "dot" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDotMultiplier", modType = "BASE", cfg = "dotPhysical" }, },
		{ format = "{0:mod:1}%", { modName = "LightningDotMultiplier", modType = "BASE", cfg = "dotLightning" }, },
		{ format = "{0:mod:1}%", { modName = "ColdDotMultiplier", modType = "BASE", cfg = "dotCold" }, },
		{ format = "{0:mod:1}%", { modName = "FireDotMultiplier", modType = "BASE", cfg = "dotFire" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDotMultiplier", modType = "BASE", cfg = "dotChaos" }, },
	},
	{ label = "Effective DPS Mod", flag = "effective",
		{ },
		{ format = "x {3:output:PhysicalDotEffMult}",
			{ breakdown = "PhysicalDotEffMult" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "DamageTakenOverTime", "PhysicalDamageTaken", "PhysicalDamageTakenOverTime", "PhysicalDamageReduction" }, enemy = true }, 
		},
		{ format = "x {3:output:LightningDotEffMult}",
			{ breakdown = "LightningDotEffMult" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "DamageTakenOverTime", "LightningDamageTaken", "LightningDamageTakenOverTime", "ElementalDamageTaken", "LightningResist", "ElementalResist" }, enemy = true },
		},
		{ format = "x {3:output:ColdDotEffMult}",
			{ breakdown = "ColdDotEffMult" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "DamageTakenOverTime", "ColdDamageTaken", "ColdDamageTakenOverTime", "ElementalDamageTaken", "ColdResist", "ElementalResist" }, enemy = true },
		},
		{ format = "x {3:output:FireDotEffMult}",
			{ breakdown = "FireDotEffMult" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "DamageTakenOverTime", "FireDamageTaken", "FireDamageTakenOverTime", "ElementalDamageTaken", "FireResist", "ElementalResist" }, enemy = true },
		},
		{ format = "x {3:output:ChaosDotEffMult}",
			{ breakdown = "ChaosDotEffMult" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "DamageTakenOverTime", "ChaosDamageTaken", "ChaosDamageTakenOverTime", "ChaosResist" }, enemy = true },
		},
	},
	{ label = "Damage over Time",
		{ format = "{1:output:TotalDotInstance}", },
		{ format = "{1:output:PhysicalDot}", { breakdown = "PhysicalDot" }, },
		{ format = "{1:output:LightningDot}", { breakdown = "LightningDot" }, },
		{ format = "{1:output:ColdDot}", { breakdown = "ColdDot" }, },
		{ format = "{1:output:FireDot}", { breakdown = "FireDot" }, },
		{ format = "{1:output:ChaosDot}", { breakdown = "ChaosDot" }, },
	},
	{ label = "Skill DoT DPS", { format = "{1:output:TotalDot}", { breakdown = "TotalDot" }, }, },
	{ label = "Mana Cost", { format = "{0:output:ManaCost}", { breakdown = "ManaCost" }, { modName = "ManaCost", cfg = "skill" }, }, },
} }
} },
{ 1, "Speed", 1, colorCodes.OFFENCE, {{ defaultCollapsed = false, label = "Attack/Cast Rate", data = {
	extra = "{2:output:Speed}/s",
	{ label = "MH Inc. Att. Speed", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", notFlag = "triggered", { format = "{0:mod:1}%", { modName = "Speed", modType = "INC", cfg = "weapon1", }, }, },
	{ label = "MH More Att. Speed", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", notFlag = "triggered", { format = "{0:mod:1}%", { modName = "Speed", modType = "MORE", cfg = "weapon1", }, }, },
	{ label = "MH Att. per second", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", notFlag = "triggered", { format = "{2:output:MainHand.Speed}", { breakdown = "MainHand.Speed" }, }, },
	{ label = "OH Inc. Att. Speed", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", notFlag = "triggered", { format = "{0:mod:1}%", { modName = "Speed", modType = "INC", cfg = "weapon2", }, }, },
	{ label = "OH More Att. Speed", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", notFlag = "triggered", { format = "{0:mod:1}%", { modName = "Speed", modType = "MORE", cfg = "weapon2", }, }, },
	{ label = "OH Att. per second", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", notFlag = "triggered", { format = "{2:output:OffHand.Speed}", { breakdown = "OffHand.Speed" }, }, },
	{ label = "Attacks per second", flag = "bothWeaponAttack", notFlag = "triggered", { format = "{2:output:Speed}", { breakdown = "Speed" }, }, },
	{ label = "Attack time", flag = "attack", notFlag = "triggered", { format = "{2:output:Time}s", { breakdown = "MainHand.Time" }, }, },
	{ label = "Inc. Cast Speed", flag = "spell", notFlag = "triggered", { format = "{0:mod:1}%", { modName = "Speed", modType = "INC", cfg = "skill", }, }, },
	{ label = "More Cast Speed", flag = "spell", notFlag = "triggered", { format = "{0:mod:1}%", { modName = "Speed", modType = "MORE", cfg = "skill", }, }, },
	{ label = "Casts per second", flag = "spell", notFlag = "triggered", { format = "{2:output:Speed}", { breakdown = "Speed" }, }, },
	{ label = "Trigger Rate Cap", flag = "triggered", notFlag = "focussed", { format = "{2:output:ActionTriggerRate}", { breakdown = "ActionTriggerRate" }, { modName = "CooldownRecovery", modType = "INC", cfg = "skill", }, }, },
	{ label = "Trigger Rate Cap", flagList = {"triggered", "focussed"}, { format = "{2:output:ActionTriggerRate}", { breakdown = "ActionTriggerRate" }, { modName = "FocusCooldownRecovery", modType = "INC", cfg = "skill", }, }, },
	{ label = "Skill Trigger Rate", flag = "triggered", notFlag = "focussed", { format = "{2:output:SourceTriggerRate}", { breakdown = "SourceTriggerRate" }, { breakdown = "SimData" }, }, },
	{ label = "Skill Trigger Rate", flagList = {"triggered", "focussed"}, { format = "{2:output:SourceTriggerRate}", { breakdown = "SourceTriggerRate" }, { breakdown = "SimData" }, { modName = "FocusCooldownRecovery", modType = "INC", cfg = "skill", }, }, },
	{ label = "Adj. Trigger Rate", flag = "triggered", { format = "{2:output:ServerTriggerRate}",  { breakdown = "ServerTriggerRate" }, }, },
	{ label = "Eff. Trigger Rate", flag = "triggered", notFlag = "dontDisplay", { format = "{2:output:Speed}", { breakdown = "Speed" }, }, },
	{ label = "Cast time", flag = "spell", notFlag = "triggered", { format = "{2:output:Time}s", }, },
} }
} },
{ 1, "Crit", 1, colorCodes.OFFENCE, {{ defaultCollapsed = false, label = "Crits", data = {
	extra = "{2:output:CritChance}% x{2:output:CritMultiplier}",
	flag = "hit",
	-- Skill
	{ label = "Inc. Crit Chance", notFlag = "attack", { format = "{0:mod:1,2}%", 
		{ label = "Player modifiers", modName = "CritChance", modType = "INC", cfg = "skill" }, 
		{ label = "Enemy modifiers", modName = "SelfCritChance", modType = "INC", enemy = true }, 
	}, },
	{ label = "Crit Chance", notFlag = "attack", { format = "{2:output:CritChance}%", 
		{ breakdown = "CritChance" }, 
		{ label = "Player modifiers", modName = "CritChance", cfg = "skill" }, 
		{ label = "Enemy modifiers", modName = "SelfCritChance", enemy = true }, 
	}, },
	{ label = "Crit Multiplier", notFlag = "attack", { format = "x {2:output:CritMultiplier}", 
		{ breakdown = "CritMultiplier" }, 
		{ label = "Player modifiers", modName = "CritMultiplier", cfg = "skill" }, 
		{ label = "Enemy modifiers", modName = "SelfCritMultiplier", enemy = true }, 
	}, },
	{ label = "Crit Effect Mod", notFlag = "attack", { format = "x {3:output:CritEffect}", { breakdown = "CritEffect" }, }, },
	-- Main Hand
	{ label = "MH Inc. Crit Chance", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "{0:mod:1,2}%", 
		{ label = "Player modifiers", modName = "CritChance", modType = "INC", cfg = "weapon1" }, 
		{ label = "Enemy modifiers", modName = "SelfCritChance", modType = "INC", enemy = true }, 
	}, },
	{ label = "MH Crit Chance", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "{2:output:MainHand.CritChance}%", 
		{ breakdown = "MainHand.CritChance" }, 
		{ label = "Player modifiers", modName = { "CritChance", "WeaponBaseCritChance" }, cfg = "weapon1" }, 
		{ label = "Enemy modifiers", modName = "SelfCritChance", enemy = true }, 
	}, },
	{ label = "MH Crit Multiplier", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "x {2:output:MainHand.CritMultiplier}", 
		{ breakdown = "MainHand.CritMultiplier" }, 
		{ label = "Player modifiers", modName = "CritMultiplier", cfg = "weapon1" }, 
		{ label = "Enemy modifiers", modName = "SelfCritMultiplier", enemy = true },
	}, },
	{ label = "MH Crit Effect Mod", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "x {3:output:MainHand.CritEffect}", { breakdown = "MainHand.CritEffect" }, }, },
	-- Off Hand
	{ label = "OH Inc. Crit Chance", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "{0:mod:1,2}%", 
		{ label = "Player modifiers", modName = "CritChance", modType = "INC", cfg = "weapon2" }, 
		{ label = "Enemy modifiers", modName = "SelfCritChance", modType = "INC", enemy = true }, 
	}, },
	{ label = "OH Crit Chance", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "{2:output:OffHand.CritChance}%", 
		{ breakdown = "OffHand.CritChance" }, 
		{ label = "Player modifiers", modName = { "CritChance", "WeaponBaseCritChance" }, cfg = "weapon2" },
		{ label = "Enemy modifiers", modName = "SelfCritChance", enemy = true }, 
	}, },
	{ label = "OH Crit Multiplier", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "x {2:output:OffHand.CritMultiplier}", 
		{ breakdown = "OffHand.CritMultiplier" }, 
		{ label = "Player modifiers", modName = "CritMultiplier", cfg = "weapon2" }, 
		{ label = "Enemy modifiers", modName = "SelfCritMultiplier", enemy = true },
	}, },
	{ label = "OH Crit Effect Mod", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "x {3:output:OffHand.CritEffect}", { breakdown = "OffHand.CritEffect" }, }, },
} }
} },
{ 1, "Impale", 1, colorCodes.OFFENCE, {{ defaultCollapsed = false, label = "Impale", data = {
    flag = "impale",
	extra = "{0:output:ImpaleChance}%",
	{ label = "Max Impale Stacks", { format = "{0:output:ImpaleStacksMax}", { modName = "ImpaleStacksMax" } }, },
	{ label = "Stacks on Enemy", { format = "{0:output:ImpaleStacks}" }},
	{ label = "Impale Chance", bgCol = colorCodes.MAINHANDBG, flag = "spell", haveOutput = "ImpaleChance", { format = "{0:output:ImpaleChance}%",
		{ flag = "impale", modName = "ImpaleChance", modType = "BASE", cfg = "skill" },
	}, },
	{ label = "Stored Damage",  bgCol = colorCodes.MAINHANDBG, flag = "spell", haveOutput = "ImpaleStoredDamage", { format = "{1:output:ImpaleStoredDamage}%",
		{ breakdown = "ImpaleStoredDamage" },
		{ flag = "spell", modName = "ImpaleEffect", cfg = "skill" },
	}, },
	{ label = "Damage Mod.",  bgCol = colorCodes.MAINHANDBG, flag = "spell", haveOutput = "ImpaleModifier", { format = "{3:output:ImpaleModifier}",
		{ breakdown = "ImpaleModifier" },
	} },
	{ label = "MH Impale Chance", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", haveOutput = "MainHand.ImpaleChance", { format = "{0:output:MainHand.ImpaleChance}%",
		{ flag = "weapon1Attack", modName = "ImpaleChance", modType = "BASE", cfg = "weapon1" },
	}, },
	{ label = "MH Stored Damage",  bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", haveOutput = "MainHand.ImpaleStoredDamage", { format = "{1:output:MainHand.ImpaleStoredDamage}%",
		{ breakdown = "MainHand.ImpaleStoredDamage" },
		{ flag = "weapon1Attack", modName = "ImpaleEffect", cfg = "weapon1" },
	}, },
	{ label = "MH DMG Mod.",  bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", haveOutput = "MainHand.ImpaleModifier", { format = "{3:output:MainHand.ImpaleModifier}",
		{ breakdown = "MainHand.ImpaleModifier" },
	} },
	{ label = "OH Impale Chance", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", haveOutput = "OffHand.ImpaleChance", { format = "{0:output:OffHand.ImpaleChance}%",
		{ flag = "weapon2Attack", modName = "ImpaleChance", modType = "BASE", cfg = "weapon2" },
	}, },
	{ label = "OH Stored Damage",  bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", haveOutput = "OffHand.ImpaleStoredDamage", { format = "{1:output:OffHand.ImpaleStoredDamage}%",
		{ breakdown = "OffHand.ImpaleStoredDamage" },
		{ flag = "weapon2Attack", modName = "ImpaleEffect", cfg = "weapon2" },
	}, },
	{ label = "OH DMG Mod.", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", haveOutput = "OffHand.ImpaleModifier", { format = "{3:output:OffHand.ImpaleModifier}", modType = "MORE",
		{ breakdown = "OffHand.ImpaleModifier" },
	}, },
	{ label = "Impale DPS", flag = "impale", flag = "notAverage", { format = "{1:output:ImpaleDPS}", { breakdown = "ImpaleDPS" }, }, },
	{ label = "Impale Damage", flag = "impale", flag = "showAverage", { format = "{1:output:ImpaleDPS}", { breakdown = "ImpaleDPS" }, }, },
} }
} },
{ 1, "SkillTypeStats", 1, colorCodes.OFFENCE, {{ defaultCollapsed = false, label = "Skill type-specific Stats", data = {
	{ label = "Active Minion Limit", haveOutput = "ActiveMinionLimit", { format = "{0:output:ActiveMinionLimit}" } },
	{ label = "Quantity Multiplier", haveOutput = "QuantityMultiplier", { format = "{0:output:QuantityMultiplier}", { modName = "QuantityMultiplier", cfg = "skill" }, }, },
	{ label = "Skill Cooldown", haveOutput = "Cooldown", { format = "{2:output:Cooldown}s", 
		{ breakdown = "Cooldown" }, 
		{ modName = "CooldownRecovery", cfg = "skill" },
	}, },
	{ label = "Duration Mod", flag = "duration", { format = "x {2:output:DurationMod}", 
		{ breakdown = "DurationMod" }, 
		{ breakdown = "SecondaryDurationMod" }, 
		{ modName = { "Duration", "PrimaryDuration", "SecondaryDuration", "SkillAndDamagingAilmentDuration" }, cfg = "skill" }, 
	}, },
	{ label = "Skill Duration", flag = "duration", haveOutput = "Duration", { format = "{2:output:Duration}s", { breakdown = "Duration" }, }, },
	{ label = "Secondary Duration", flag = "duration", haveOutput = "DurationSecondary", { format = "{2:output:DurationSecondary}s", { breakdown = "DurationSecondary" }, }, },
	{ label = "Aura Duration", haveOutput = "AuraDuration", { format = "{2:output:AuraDuration}s", { breakdown = "AuraDuration" }, }, },
	{ label = "Reserve Duration", haveOutput = "ReserveDuration", { format = "{2:output:ReserveDuration}s", { breakdown = "ReserveDuration" }, }, },
	{ label = "Projectile Count", flag = "projectile", { format = "{output:ProjectileCount}", { modName = { "NoAdditionalProjectiles" , "ProjectileCount" }, cfg = "skill" }, }, },
	{ label = "Pierce Count", flag = "projectile", { format = "{output:PierceCountString}", { modName = { "CannotPierce", "PierceCount", "PierceAllTargets" }, cfg = "skill" }, }, },
	{ label = "Fork Count", flag = "projectile", { format = "{output:ForkCountString}", { modName = { "CannotFork", "ForkCountMax" }, cfg = "skill" }, }, },
	{ label = "Max Chain Count", flag = "chaining", { format = "{output:ChainMaxString}", { modName = { "CannotChain", "ChainCountMax" }, cfg = "skill" }, }, }, 
	{ label = "Proj. Speed Mod", flag = "projectile", { format = "x {2:output:ProjectileSpeedMod}",
		{ breakdown = "ProjectileSpeedMod" },
		{ modName = "ProjectileSpeed", cfg = "skill" },
	}, },
	{ label = "Bounces Count", flag = "bounce", { format = "{output:BounceCount}", { modName = { "BounceCount", "ProjectileCount" }, cfg = "skill" }, }, },
	{ label = "Aura Effect Mod", haveOutput = "AuraEffectMod", { format = "x {2:output:AuraEffectMod}",
		{ breakdown = "AuraEffectMod" },
		{ modName = "AuraEffect", cfg = "skill" },
	}, },
	{ label = "Mana Reserve Mod", haveOutput = "ManaReservedMod", { format = "x {2:output:ManaReservedMod}",
		{ breakdown = "ManaReservedMod" },
		{ modName = { "ManaReserved", "Reserved", "SupportManaMultiplier" }, cfg = "skill"}
	}, },
	{ label = "Life Reserve Mod", haveOutput = "LifeReservedMod", { format = "x {2:output:LifeReservedMod}",
		{ breakdown = "LifeReservedMod" },
		{ modName = { "LifeReserved", "Reserved", "SupportManaMultiplier" }, cfg = "skill"}
	}, },
	{ label = "Curse Effect Mod", haveOutput = "CurseEffectMod", { format = "x {2:output:CurseEffectMod}",
		{ breakdown = "CurseEffectMod" },
		{ modName = "CurseEffect", cfg = "skill" },
	}, },
	{ label = "Area of Effect Mod", haveOutput = "AreaOfEffectMod", { format = "x {2:output:AreaOfEffectMod}", 
		{ breakdown = "AreaOfEffectMod" }, 
		{ modName = "AreaOfEffect", cfg = "skill" },
	}, },
	{ label = "Radius", haveOutput = "AreaOfEffectRadius", { format = "{0:output:AreaOfEffectRadius}", { breakdown = "AreaOfEffectRadius" }, }, },
	{ label = "Secondary Radius", haveOutput = "AreaOfEffectRadiusSecondary", { format = "{0:output:AreaOfEffectRadiusSecondary}",
		{ breakdown = "AreaOfEffectRadiusSecondary" },
		{ label = "Area of Effect modifiers", modName = "AreaOfEffectSecondary", cfg = "skill" },
	}, },
	{ label = "Tertiary Radius", haveOutput = "AreaOfEffectRadiusTertiary", { format = "{0:output:AreaOfEffectRadiusTertiary}",
		{ breakdown = "AreaOfEffectRadiusTertiary" },
		{ label = "Area of Effect modifiers", modName = "AreaOfEffectTertiary", cfg = "skill" },
	}, },
	{ label = "Weapon Range", haveOutput = "WeaponRange", { format = "{0:output:WeaponRange}", { breakdown = "WeaponRange" }, }, },
	{ label = "Attachment Range", flag = "brand", { format = "x {2:output:BrandAttachmentRange}",
		{ breakdown = "BrandAttachmentRange" },
		{ modName = "BrandAttachmentRange", cfg = "skill"},
	}, },
	{ label = "Trap Throw Rate", flag = "trap", { format = "{2:output:TrapThrowingSpeed}", 
		{ breakdown = "TrapThrowingSpeed" },
		{ modName = "TrapThrowingSpeed", cfg = "skill" }, 
	}, },
	{ label = "Trap Throw Time", flag = "trap", { format = "{2:output:TrapThrowingTime}s", { breakdown = "TrapThrowingTime" }, }, },
	{ label = "Active Trap Limit", flag = "trap", { format = "{0:output:ActiveTrapLimit}", { modName = "ActiveTrapLimit", cfg = "skill" }, }, },
	{ label = "Trap Cooldown", haveOutput = "TrapCooldown", { format = "{2:output:TrapCooldown}s", 
		{ breakdown = "TrapCooldown" }, 
		{ modName = "CooldownRecovery", cfg = "skill" },
	}, },
	{ label = "Trap Trigg. Radius", flag = "trap", { format = "{0:output:TrapTriggerRadius}", 
		{ breakdown = "TrapTriggerRadius" },
		{ label = "Area of Effect modifiers", modName = "TrapTriggerAreaOfEffect", cfg = "skill" },
	}, },
	{ label = "Seal Gain Rate", haveOutput = "SealMax", { format = "{2:output:SealCooldown}s", 
		{ breakdown = "SealGainTime" },
		{ modName = "SealGainFrequency", cfg = "skill" }, 
	}, },
	{ label = "Mine Throw Rate", flag = "mine", { format = "{2:output:MineLayingSpeed}", 
		{ breakdown = "MineLayingTime" },
		{ modName = "MineLayingSpeed", cfg = "skill" }, 
	}, },
	{ label = "Mine Throw Time", flag = "mine", { format = "{2:output:MineLayingTime}s", { breakdown = "MineThrowingTime" }, }, },
	{ label = "Active Mine Limit", flag = "mine", { format = "{0:output:ActiveMineLimit}", { modName = "ActiveMineLimit", cfg = "skill" }, }, },
	{ label = "Mine Deton. Radius", flag = "mine", { format = "{0:output:MineDetonationRadius}", 
		{ breakdown = "MineDetonationRadius" },
		{ label = "Area of Effect modifiers", modName = "MineDetonationAreaOfEffect", cfg = "skill" },
	}, },
	{ label = "Mine Aura Radius", haveOutput = "MineAuraRadius", { format = "{0:output:MineAuraRadius}", { breakdown = "MineAuraRadius" }, }, },
	{ label = "Totem Place Time", flag = "totem", { format = "{2:output:TotemPlacementTime}s", 
		{ breakdown = "TotemPlacementTime" },
		{ modName = "TotemPlacementSpeed", cfg = "skill" }, 
	}, },
	{ label = "Active Totem Limit", flag = "totem", { format = "{0:output:ActiveTotemLimit}", 
		{ breakdown = "ActiveTotemLimit" },
		{ modName = { "ActiveTotemLimit", "ActiveBallistaLimit" }, cfg = "skill" }, 
	}, },
	{ label = "Totem Life Mod", flag = "totem", { format = "x {2:output:TotemLifeMod}", 
		{ breakdown = "TotemLifeMod" },
		{ modName = "TotemLife", cfg = "skill" },
	}, },
	{ label = "Totem Life", flag = "totem", { format = "{0:output:TotemLife}", { breakdown = "TotemLife" }, }, },
	{ label = "Active Brand Limit", flag = "brand", { format = "{0:output:ActiveBrandLimit}", { modName = "ActiveBrandLimit", cfg = "skill" }, }, },
} }
} },
{ 1, "HitChance", 1, colorCodes.OFFENCE, {{ defaultCollapsed = false, label = "Accuracy", data = {
	extra = "{0:output:HitChance}%",
	flag = "attack",
	{ label = "MH Accuracy", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "{0:output:MainHand.Accuracy}", 
		{ breakdown = "MainHand.Accuracy" }, 
		{ modName = "Accuracy", cfg = "weapon1" }, 
	}, },
	{ label = "MH Chance to Hit", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "{0:output:MainHand.HitChance}%",
		{ breakdown = "MainHand.HitChance" }, 
		{ label = "Enemy Evasion modifiers", modName = { "Evasion", "CannotEvade" }, enemy = true },
		{ label = "Player modifiers", modName = { "HitChance", "CannotBeEvaded", "IgnoreBlindHitChance" } },
	}, },
	{ label = "OH Accuracy", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "{0:output:OffHand.Accuracy}",
		{ breakdown = "OffHand.Accuracy" }, 
		{ modName = "Accuracy", cfg = "weapon2" },
	}, },
	{ label = "OH Chance to Hit", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "{0:output:OffHand.HitChance}%",
		{ breakdown = "OffHand.HitChance" },
		{ label = "Enemy Evasion modifiers", modName = { "Evasion", "CannotEvade" }, enemy = true },
		{ label = "Player modifiers", modName = { "HitChance", "CannotBeEvaded", "IgnoreBlindHitChance" } },
	}, },
} }
} },
{ 1, "Bleed", 1, colorCodes.OFFENCE, {{ defaultCollapsed = false, label = "Bleed", data = {
	extra = "{0:output:BleedChance}% {1:output:BleedDPS} {2:output:BleedDuration}s",
	flag = "bleed",
	{ label = "Max Bleed Stacks", { format = "{0:output:BleedStacksMax}", { modName = "BleedStacksMax" } }, },
	{ label = "Stacks on Enemy", { format = "{0:output:BleedStacks}" }},
	{ label = "Chance to Bleed", { format = "{0:output:BleedChance}%", 
		{ breakdown = "MainHand.BleedChance" },
		{ breakdown = "OffHand.BleedChance" },
		{ breakdown = "BleedChance" },
		{ label = "Main Hand", flag = "weapon1Attack", modName = "BleedChance", modType = "BASE", cfg = "weapon1" },
		{ label = "Off Hand", flag = "weapon2Attack", modName = "BleedChance", modType = "BASE", cfg = "weapon2" },
		{ label = "Enemy modifiers", modName = "SelfBleedChance", modType = "BASE", enemy = true },
	}, },
	{ label = "Total Increased", { format = "{0:mod:1}%", { modName = { "Damage", "PhysicalDamage" }, modType = "INC", cfg = "bleed" }, }, },
	{ label = "Total More", { format = "{0:mod:1}%", { modName = { "Damage", "PhysicalDamage" }, modType = "MORE", cfg = "bleed" }, }, },
	{ label = "Eff. DoT Multiplier", { format = "x {2:output:BleedDotMulti}", { breakdown = "BleedDotMulti" }, { modName = { "DotMultiplier", "PhysicalDotMultiplier" }, modType = "BASE", cfg = "bleed" }, }, },
	{ label = "MH Source Physical", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack", { format = "{0:output:MainHand.BleedPhysicalMin} to {0:output:MainHand.BleedPhysicalMax}", { breakdown = "MainHand.BleedPhysical" }, }, },
	{ label = "OH Source Physical", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack", { format = "{0:output:OffHand.BleedPhysicalMin} to {0:output:OffHand.BleedPhysicalMax}", { breakdown = "OffHand.BleedPhysical" }, }, },
	{ label = "Effective DPS Mod", flag = "effective", { format = "x {3:output:BleedEffMult}", { breakdown = "BleedEffMult" }, { label = "Enemy modifiers", modName = { "DamageTaken", "DamageTakenOverTime", "PhysicalDamageTaken", "PhysicalDamageTakenOverTime", "PhysicalDamageReduction" }, enemy = true, cfg = "bleed" }, }, },
	{ label = "Bleed DPS", { format = "{1:output:BleedDPS}", { breakdown = "BleedDPS" }, { breakdown = "MainHand.BleedDPS" }, { breakdown = "OffHand.BleedDPS" }, }, },
	{ label = "Bleed Duration", { format = "{2:output:BleedDuration}s", 
		{ breakdown = "BleedDuration" }, 
		{ label = "Player modifiers", modName = { "EnemyBleedDuration", "SkillAndDamagingAilmentDuration", "BleedFaster" }, cfg = "bleed" }, 
		{ label = "Enemy modifiers", modName = { "SelfBleedDuration", "SelfBleedFaster" }, enemy = true },
	}, },
} }
} },
{ 1, "Poison", 1, colorCodes.OFFENCE, {{ defaultCollapsed = false, label = "Poison", data = {
	extra = "{0:output:PoisonChance}% {1:output:PoisonDPS} {2:output:PoisonDuration}s",
	flag = "poison",
	{ label = "Chance to Poison", { format = "{0:output:PoisonChance}%", 
		{ breakdown = "MainHand.PoisonChance" }, 
		{ breakdown = "OffHand.PoisonChance" }, 
		{ breakdown = "PoisonChance" }, 
		{ notFlag = "attack", modName = "PoisonChance", modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", flag = "weapon1Attack", modName = "PoisonChance", modType = "BASE", cfg = "weapon1" },
		{ label = "Off Hand", flag = "weapon2Attack", modName = "PoisonChance", modType = "BASE", cfg = "weapon2" },
	}, },
	{ label = "Total Increased", { format = "{0:mod:1}%", { modName = { "Damage", "ChaosDamage" }, modType = "INC", cfg = "poison" }, }, },
	{ label = "Total More", { format = "{0:mod:1}%", { modName = { "Damage", "ChaosDamage" }, modType = "MORE", cfg = "poison" }, }, },
	{ label = "Eff. DoT Multiplier", { format = "x {2:output:PoisonDotMulti}", { breakdown = "PoisonDotMulti" }, { modName = { "DotMultiplier", "ChaosDotMultiplier" }, modType = "BASE", cfg = "poison" }, }, },
	{ label = "Source Physical", textSize = 12, notFlag = "attack", haveOutput = "PoisonPhysicalMax", { format = "{0:output:PoisonPhysicalMin} to {0:output:PoisonPhysicalMax}", { breakdown = "PoisonPhysical" }, }, },
	{ label = "MH Source Physical", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack", haveOutput = "MainHand.PoisonPhysicalMax", { format = "{0:output:MainHand.PoisonPhysicalMin} to {0:output:MainHand.PoisonPhysicalMax}", { breakdown = "MainHand.PoisonPhysical" }, }, },
	{ label = "OH Source Physical", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack", haveOutput = "OffHand.PoisonPhysicalMax", { format = "{0:output:OffHand.PoisonPhysicalMin} to {0:output:OffHand.PoisonPhysicalMax}", { breakdown = "OffHand.PoisonPhysical" }, }, },
	{ label = "Source Lightning", textSize = 12, notFlag = "attack", haveOutput = "PoisonLightningMax", { format = "{0:output:PoisonLightningMin} to {0:output:PoisonLightningMax}", { breakdown = "PoisonLightning" }, }, },
	{ label = "MH Source Lightning", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack", haveOutput = "MainHand.PoisonLightningMax", { format = "{0:output:MainHand.PoisonLightningMin} to {0:output:MainHand.PoisonLightningMax}", { breakdown = "MainHand.PoisonLightning" }, }, },
	{ label = "OH Source Lightning", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack", haveOutput = "OffHand.PoisonLightningMax", { format = "{0:output:OffHand.PoisonLightningMin} to {0:output:OffHand.PoisonLightningMax}", { breakdown = "OffHand.PoisonLightning" }, }, },
	{ label = "Source Cold", textSize = 12, notFlag = "attack", haveOutput = "PoisonColdMax", { format = "{0:output:PoisonColdMin} to {0:output:PoisonColdMax}", { breakdown = "PoisonCold" }, }, },
	{ label = "MH Source Cold", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack", haveOutput = "MainHand.PoisonColdMax", { format = "{0:output:MainHand.PoisonColdMin} to {0:output:MainHand.PoisonColdMax}", { breakdown = "MainHand.PoisonCold" }, }, },
	{ label = "OH Source Cold", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack", haveOutput = "OffHand.PoisonColdMax", { format = "{0:output:OffHand.PoisonColdMin} to {0:output:OffHand.PoisonColdMax}", { breakdown = "OffHand.PoisonCold" }, }, },
	{ label = "Source Fire", textSize = 12, notFlag = "attack", haveOutput = "PoisonFireMax", { format = "{0:output:PoisonFireMin} to {0:output:PoisonFireMax}", { breakdown = "PoisonFire" }, }, },
	{ label = "MH Source Fire", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack", haveOutput = "MainHand.PoisonFireMax", { format = "{0:output:MainHand.PoisonFireMin} to {0:output:MainHand.PoisonFireMax}", { breakdown = "MainHand.PoisonFire" }, }, },
	{ label = "OH Source Fire", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack", haveOutput = "OffHand.PoisonFireMax", { format = "{0:output:OffHand.PoisonFireMin} to {0:output:OffHand.PoisonFireMax}", { breakdown = "OffHand.PoisonFire" }, }, },
	{ label = "Source Chaos", textSize = 12, notFlag = "attack", haveOutput = "PoisonChaosMax", { format = "{0:output:PoisonChaosMin} to {0:output:PoisonChaosMax}", { breakdown = "PoisonChaos" }, }, },
	{ label = "MH Source Chaos", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack", haveOutput = "MainHand.PoisonChaosMax", { format = "{0:output:MainHand.PoisonChaosMin} to {0:output:MainHand.PoisonChaosMax}", { breakdown = "MainHand.PoisonChaos" }, }, },
	{ label = "OH Source Chaos", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack", haveOutput = "OffHand.PoisonChaosMax", { format = "{0:output:OffHand.PoisonChaosMin} to {0:output:OffHand.PoisonChaosMax}", { breakdown = "OffHand.PoisonChaos" }, }, },
	{ label = "Effective DPS Mod", flag = "effective", { format = "x {3:output:PoisonEffMult}", 
		{ breakdown = "PoisonEffMult" }, 
		{ label = "Enemy modifiers", modName = { "ChaosResist", "DamageTaken", "DamageTakenOverTime", "ChaosDamageTaken", "ChaosDamageTakenOverTime" }, enemy = true },
	}, },
	{ label = "Poison DPS", { format = "{1:output:PoisonDPS}", 
		{ breakdown = "PoisonDPS" }, 
		{ breakdown = "MainHand.PoisonDPS" },
		{ breakdown = "OffHand.PoisonDPS" },
	}, },
	{ label = "Poison Duration", { format = "{2:output:PoisonDuration}s", 
		{ breakdown = "PoisonDuration" },
		{ label = "Player modifiers", modName = { "EnemyPoisonDuration", "SkillAndDamagingAilmentDuration", "PoisonFaster" }, cfg = "poison" },
		{ label = "Enemy modifiers", modName = { "SelfPoisonDuration", "SelfPoisonFaster" }, enemy = true },
	}, },
	{ label = "Dmg. per Poison", { format = "{1:output:PoisonDamage}", 
		{ breakdown = "MainHand.PoisonDamage" }, 
		{ breakdown = "OffHand.PoisonDamage" }, 
		{ breakdown = "PoisonDamage" }, 
	}, },
	{ flag = "notAverage", label = "Max Poison Stacks", { format = "{1:output:TotalPoisonStacks}",
		{ breakdown = "MainHand.TotalPoisonStacks" }, 
		{ breakdown = "OffHand.TotalPoisonStacks" }, 
		{ breakdown = "TotalPoisonStacks" }, 
	}, },
} }
} },
{ 1, "Ignite", 1, colorCodes.OFFENCE, {{ defaultCollapsed = false, label = "Ignite", data = {	
	extra = "{0:output:IgniteChance}% {1:output:IgniteDPS} {2:output:IgniteDuration}s",
	flag = "ignite",
	{ label = "Chance to Ignite", { format = "{0:output:IgniteChance}%", 
		{ breakdown = "MainHand.IgniteChance" }, 
		{ breakdown = "OffHand.IgniteChance" },
		{ breakdown = "IgniteChance" },
		{ label = "Player modifiers", modName = "EnemyIgniteChance", cfg = "skill" },
		{ label = "Enemy modifiers", modName = "SelfIgniteChance", enemy = true },
	}, },
	{ label = "Total Increased", { format = "{0:mod:1}%", { modName = { "Damage", "FireDamage", "ElementalDamage" }, modType = "INC", cfg = "ignite" }, }, },
	{ label = "Total More", { format = "{0:mod:1}%", { modName = { "Damage", "FireDamage", "ElementalDamage" }, modType = "MORE", cfg = "ignite" }, }, },
	{ label = "Eff. DoT Multiplier", { format = "x {2:output:IgniteDotMulti}", { breakdown = "IgniteDotMulti" }, { modName = { "DotMultiplier", "FireDotMultiplier" }, modType = "BASE", cfg = "ignite" }, }, },
	{ label = "Source Physical", textSize = 12, notFlag = "attack", haveOutput = "IgnitePhysicalMax", { format = "{0:output:IgnitePhysicalMin} to {0:output:IgnitePhysicalMax}", { breakdown = "IgnitePhysical" }, }, },
	{ label = "MH Source Physical", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack", haveOutput = "MainHand.IgnitePhysicalMax", { format = "{0:output:MainHand.IgnitePhysicalMin} to {0:output:MainHand.IgnitePhysicalMax}", { breakdown = "MainHand.IgnitePhysical" }, }, },
	{ label = "OH Source Physical", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack", haveOutput = "OffHand.IgnitePhysicalMax", { format = "{0:output:OffHand.IgnitePhysicalMin} to {0:output:OffHand.IgnitePhysicalMax}", { breakdown = "OffHand.IgnitePhysical" }, }, },
	{ label = "Source Lightning", textSize = 12, notFlag = "attack", haveOutput = "IgniteLightningMax", { format = "{0:output:IgniteLightningMin} to {0:output:IgniteLightningMax}", { breakdown = "IgniteLightning" }, }, },
	{ label = "MH Source Lightning", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack", haveOutput = "MainHand.IgniteLightningMax", { format = "{0:output:MainHand.IgniteLightningMin} to {0:output:MainHand.IgniteLightningMax}", { breakdown = "MainHand.IgniteLightning" }, }, },
	{ label = "OH Source Lightning", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack", haveOutput = "OffHand.IgniteLightningMax", { format = "{0:output:OffHand.IgniteLightningMin} to {0:output:OffHand.IgniteLightningMax}", { breakdown = "OffHand.IgniteLightning" }, }, },
	{ label = "Source Cold", textSize = 12, notFlag = "attack", haveOutput = "IgniteColdMax", { format = "{0:output:IgniteColdMin} to {0:output:IgniteColdMax}", { breakdown = "IgniteCold" }, }, },
	{ label = "MH Source Cold", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack", haveOutput = "MainHand.IgniteColdMax", { format = "{0:output:MainHand.IgniteColdMin} to {0:output:MainHand.IgniteColdMax}", { breakdown = "MainHand.IgniteCold" }, }, },
	{ label = "OH Source Cold", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack", haveOutput = "OffHand.IgniteColdMax", { format = "{0:output:OffHand.IgniteColdMin} to {0:output:OffHand.IgniteColdMax}", { breakdown = "OffHand.IgniteCold" }, }, },
	{ label = "Source Fire", textSize = 12, notFlag = "attack", haveOutput = "IgniteFireMax", { format = "{0:output:IgniteFireMin} to {0:output:IgniteFireMax}", { breakdown = "IgniteFire" }, }, },
	{ label = "MH Source Fire", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack", haveOutput = "MainHand.IgniteFireMax", { format = "{0:output:MainHand.IgniteFireMin} to {0:output:MainHand.IgniteFireMax}", { breakdown = "MainHand.IgniteFire" }, }, },
	{ label = "OH Source Fire", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack", haveOutput = "OffHand.IgniteFireMax", { format = "{0:output:OffHand.IgniteFireMin} to {0:output:OffHand.IgniteFireMax}", { breakdown = "OffHand.IgniteFire" }, }, },
	{ label = "Source Chaos", textSize = 12, notFlag = "attack", haveOutput = "IgniteChaosMax", { format = "{0:output:IgniteChaosMin} to {0:output:IgniteChaosMax}", { breakdown = "IgniteChaos" }, }, },
	{ label = "MH Source Chaos", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack", haveOutput = "MainHand.IgniteChaosMax", { format = "{0:output:MainHand.IgniteChaosMin} to {0:output:MainHand.IgniteChaosMax}", { breakdown = "MainHand.IgniteChaos" }, }, },
	{ label = "OH Source Chaos", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack", haveOutput = "OffHand.IgniteChaosMax", { format = "{0:output:OffHand.IgniteChaosMin} to {0:output:OffHand.IgniteChaosMax}", { breakdown = "OffHand.IgniteChaos" }, }, },
	{ label = "Effective DPS Mod", flag = "effective", notFlag = "igniteToChaos", { format = "x {3:output:IgniteEffMult}", 
		{ breakdown = "IgniteEffMult" }, 
		{ label = "Enemy modifiers", modName = { "FireResist", "ElementalResist", "DamageTaken", "DamageTakenOverTime", "FireDamageTaken", "FireDamageTakenOverTime", "ElementalDamageTaken" }, enemy = true },
	}, },
	{ label = "Effective DPS Mod", flagList = { "effective", "igniteToChaos" }, { format = "x {3:output:IgniteEffMult}", 
		{ breakdown = "IgniteEffMult" }, 
		{ label = "Enemy modifiers", modName = { "ChaosResist", "DamageTaken", "DamageTakenOverTime", "ChaosDamageTaken", "ChaosDamageTakenOverTime" }, enemy = true },
	}, },
	{ label = "Ignite DPS", { format = "{1:output:IgniteDPS}", 
		{ breakdown = "IgniteDPS" }, 
		{ breakdown = "MainHand.IgniteDPS" },
		{ breakdown = "OffHand.IgniteDPS" },
		{ modName = { "IgniteBurnRate" }, cfg = "skill" }, 
	}, },
	{ label = "Ignite Duration", { format = "{2:output:IgniteDuration}s", 
		{ breakdown = "IgniteDuration" },
		{ label = "Player modifiers", modName = { "EnemyIgniteDuration", "SkillAndDamagingAilmentDuration", "IgniteBurnFaster", "IgniteBurnSlower" }, cfg = "skill" },
		{ label = "Enemy modifiers", modName = {"SelfIgniteDuration", "SelfIgniteBurnFaster"}, enemy = true },
	}, },
	{ label = "Dmg. per Ignite", flag = "igniteCanStack", { format = "{1:output:IgniteDamage}",
		{ breakdown = "MainHand.IgniteDamage" },
		{ breakdown = "OffHand.IgniteDamage" },
		{ breakdown = "IgniteDamage" },
	}, },
	{ label = "Max Ignite Stacks", flag = "igniteCanStack", { format = "{1:output:TotalIgniteStacks}", { modName = "IgniteStacks" }, }, },
} }
} },
{ 1, "Decay", 1, colorCodes.OFFENCE, {{ defaultCollapsed = false, label = "Decay", data = {
	extra = "{1:output:DecayDPS} {2:output:DecayDuration}s",
	flag = "decay",
	{ label = "Total Increased", { format = "{0:mod:1}%", { modName = { "Damage", "ChaosDamage" }, modType = "INC", cfg = "decay" }, }, },
	{ label = "Total More", { format = "{0:mod:1}%", { modName = { "Damage", "ChaosDamage" }, modType = "MORE", cfg = "decay" }, }, },
	{ label = "Effective DPS Mod", flag = "effective", { format = "x {3:output:DecayEffMult}", 
		{ breakdown = "DecayEffMult" }, 
		{ label = "Enemy modifiers", modName = { "ChaosResist", "DamageTaken", "DamageTakenOverTime", "ChaosDamageTaken", "ChaosDamageTakenOverTime" }, enemy = true },
	}, },
	{ label = "Decay DPS", { format = "{1:output:DecayDPS}", 
		{ breakdown = "DecayDPS" }, 
	}, },
	{ label = "Decay Duration", { format = "{2:output:DecayDuration}s", 
		{ breakdown = "DecayDuration" },
		{ modName = { "Duration", "SkillAndDamagingAilmentDuration" }, cfg = "decay" },
	}, },
} }
} },
{ 1, "LeechGain", 1, colorCodes.OFFENCE, {{ defaultCollapsed = false, label = "Leech & Gain on Hit", data = {
	{ label = "Life Leech Cap", flag = "leechLife", { format = "{1:output:MaxLifeLeechRate}", 
		{ breakdown = "MaxLifeLeechRate" },
		{ modName = "MaxLifeLeechRate" },
	}, },
	{ label = "Life Leech Rate", flag = "leechLife", notFlag = "showAverage", { format = "{1:output:LifeLeechRate}", 
		{ breakdown = "LifeLeech" }, 
		{ label = "Player modifiers", notFlagList = { "totem", "attack" }, modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", notFlag = "totem", flag = "weapon1Attack", modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", notFlag = "totem", flag = "weapon2Attack", modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "weapon2" }, 
		{ label = "Totem modifiers", flag = "totem", modName = { "DamageLifeLeechToPlayer" }, modType = "BASE", cfg = "skill" },
		{ label = "Enemy modifiers", modName = { "SelfDamageLifeLeech" }, modType = "BASE", enemy = true },
	}, },
	{ label = "Life Leech per Hit", flagList = { "leechLife", "showAverage" }, { format = "{1:output:LifeLeechPerHit}", 
		{ breakdown = "LifeLeech" },
		{ label = "Player modifiers", notFlagList = { "totem", "attack" }, modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", notFlag = "totem", flag = "weapon1Attack", modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", notFlag = "totem", flag = "weapon2Attack", modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "weapon2" }, 
		{ label = "Totem modifiers", flag = "totem", modName = { "DamageLifeLeechToPlayer" }, modType = "BASE", cfg = "skill" },
		{ label = "Enemy modifiers", modName = { "SelfDamageLifeLeech" }, modType = "BASE", enemy = true },
	}, },
	{ label = "Life Gain Rate", notFlag = "showAverage", haveOutput = "LifeOnHitRate", { format = "{1:output:LifeOnHitRate}", 
		{ label = "Player modifiers", notFlag = "attack", modName = "LifeOnHit", modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", flag = "weapon1Attack", modName = "LifeOnHit", modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", flag = "weapon2Attack", modName = "LifeOnHit", modType = "BASE", cfg = "weapon2" }, 
		{ label = "Enemy modifiers", modName = { "SelfLifeOnHit" }, modType = "BASE", cfg = "skill", enemy = true },
	}, },
	{ label = "Life Gain per Hit", flag = "showAverage", haveOutput = "LifeOnHit", { format = "{1:output:LifeOnHit}", 
		{ label = "Player modifiers", notFlag = "attack", modName = "LifeOnHit", modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", flag = "weapon1Attack", modName = "LifeOnHit", modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", flag = "weapon2Attack", modName = "LifeOnHit", modType = "BASE", cfg = "weapon2" }, 
		{ label = "Enemy modifiers", modName = { "SelfLifeOnHit" }, modType = "BASE", cfg = "skill", enemy = true },
	}, },
	{ label = "ES Leech Cap", flag = "leechES", { format = "{1:output:MaxEnergyShieldLeechRate}", 
		{ breakdown = "MaxEnergyShieldLeechRate" },
		{ modName = "MaxEnergyShieldLeechRate" },
	}, },
	{ label = "ES Leech Rate", flag = "leechES", notFlag = "showAverage", { format = "{1:output:EnergyShieldLeechRate}", 
		{ breakdown = "EnergyShieldLeech" },
		{ label = "Player modifiers", notFlagList = { "totem", "attack" }, modName = { "DamageEnergyShieldLeech", "PhysicalDamageEnergyShieldLeech", "LightningDamageEnergyShieldLeech", "ColdDamageEnergyShieldLeech", "FireDamageEnergyShieldLeech", "ChaosDamageEnergyShieldLeech", "ElementalDamageEnergyShieldLeech" }, modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", notFlag = "totem", flag = "weapon1Attack", modName = { "DamageEnergyShieldLeech", "PhysicalDamageEnergyShieldLeech", "LightningDamageEnergyShieldLeech", "ColdDamageEnergyShieldLeech", "FireDamageEnergyShieldLeech", "ChaosDamageEnergyShieldLeech", "ElementalDamageEnergyShieldLeech" }, modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", notFlag = "totem", flag = "weapon2Attack", modName = { "DamageEnergyShieldLeech", "PhysicalDamageEnergyShieldLeech", "LightningDamageEnergyShieldLeech", "ColdDamageEnergyShieldLeech", "FireDamageEnergyShieldLeech", "ChaosDamageEnergyShieldLeech", "ElementalDamageEnergyShieldLeech" }, modType = "BASE", cfg = "weapon2" }, 
		{ label = "Totem modifiers", flag = "totem", modName = { "DamageEnergyShieldLeechToPlayer" }, modType = "BASE", cfg = "skill" },
		{ label = "Enemy modifiers", modName = { "SelfDamageEnergyShieldLeech" }, modType = "BASE", enemy = true },
	}, },
	{ label = "ES Leech per Hit", flagList = { "leechES", "showAverage" }, { format = "{1:output:EnergyShieldLeechPerHit}",
		{ breakdown = "EnergyShieldLeech" },
		{ label = "Player modifiers", notFlagList = { "totem", "attack" }, modName = { "DamageEnergyShieldLeech", "PhysicalDamageEnergyShieldLeech", "LightningDamageEnergyShieldLeech", "ColdDamageEnergyShieldLeech", "FireDamageEnergyShieldLeech", "ChaosDamageEnergyShieldLeech", "ElementalDamageEnergyShieldLeech" }, modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", notFlag = "totem", flag = "weapon1Attack", modName = { "DamageEnergyShieldLeech", "PhysicalDamageEnergyShieldLeech", "LightningDamageEnergyShieldLeech", "ColdDamageEnergyShieldLeech", "FireDamageEnergyShieldLeech", "ChaosDamageEnergyShieldLeech", "ElementalDamageEnergyShieldLeech" }, modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", notFlag = "totem", flag = "weapon2Attack", modName = { "DamageEnergyShieldLeech", "PhysicalDamageEnergyShieldLeech", "LightningDamageEnergyShieldLeech", "ColdDamageEnergyShieldLeech", "FireDamageEnergyShieldLeech", "ChaosDamageEnergyShieldLeech", "ElementalDamageEnergyShieldLeech" }, modType = "BASE", cfg = "weapon2" }, 
		{ label = "Totem modifiers", flag = "totem", modName = { "DamageEnergyShieldLeechToPlayer" }, modType = "BASE", cfg = "skill" },
		{ label = "Enemy modifiers", modName = { "SelfDamageEnergyShieldLeech" }, modType = "BASE", enemy = true },
	}, },
	{ label = "ES Gain Rate", notFlag = "showAverage", haveOutput = "EnergyShieldOnHitRate", { format = "{1:output:EnergyShieldOnHitRate}", 
		{ label = "Player modifiers", notFlag = "attack", modName = "EnergyShieldOnHit", modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", flag = "weapon1Attack", modName = "EnergyShieldOnHit", modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", flag = "weapon2Attack", modName = "EnergyShieldOnHit", modType = "BASE", cfg = "weapon2" }, 
		{ label = "Enemy modifiers", modName = { "SelfEnergyShieldOnHit" }, modType = "BASE", enemy = true },
	}, },
	{ label = "ES Gain per Hit", flag = "showAverage", haveOutput = "EnergyShieldOnHit", { format = "{1:output:EnergyShieldOnHit}", 
		{ label = "Player modifiers", notFlag = "attack", modName = "EnergyShieldOnHit", modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", flag = "weapon1Attack", modName = "EnergyShieldOnHit", modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", flag = "weapon2Attack", modName = "EnergyShieldOnHit", modType = "BASE", cfg = "weapon2" }, 
		{ label = "Enemy modifiers", modName = { "SelfEnergyShieldOnHit" }, modType = "BASE", cfg = "skill", enemy = true },
	}, },
	{ label = "Mana Leech Cap", flag = "leechMana", { format = "{1:output:MaxManaLeechRate}", 
		{ breakdown = "MaxManaLeechRate" },
		{ modName = "MaxManaLeechRate" },
	}, },
	{ label = "Mana Leech Rate", flag = "leechMana", notFlag = "showAverage", { format = "{1:output:ManaLeechRate}", 
		{ breakdown = "ManaLeech" }, 
		{ label = "Player modifiers", notFlag = "attack", modName = { "DamageLeech", "DamageManaLeech", "PhysicalDamageManaLeech", "LightningDamageManaLeech", "ColdDamageManaLeech", "FireDamageManaLeech", "ChaosDamageManaLeech", "ElementalDamageManaLeech" }, modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", flag = "weapon1Attack", modName = { "DamageLeech", "DamageManaLeech", "PhysicalDamageManaLeech", "LightningDamageManaLeech", "ColdDamageManaLeech", "FireDamageManaLeech", "ChaosDamageManaLeech", "ElementalDamageManaLeech" }, modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", flag = "weapon2Attack", modName = { "DamageLeech", "DamageManaLeech", "PhysicalDamageManaLeech", "LightningDamageManaLeech", "ColdDamageManaLeech", "FireDamageManaLeech", "ChaosDamageManaLeech", "ElementalDamageManaLeech" }, modType = "BASE", cfg = "weapon2" }, 
		{ label = "Enemy modifiers", modName = { "SelfDamageManaLeech" }, modType = "BASE", cfg = "skill", enemy = true },
	}, },
	{ label = "Mana Leech per Hit", flagList = { "leechMana", "showAverage" }, { format = "{1:output:ManaLeechPerHit}", 
		{ breakdown = "ManaLeech" }, 
		{ label = "Player modifiers", notFlag = "attack", modName = { "DamageLeech", "DamageManaLeech", "PhysicalDamageManaLeech", "LightningDamageManaLeech", "ColdDamageManaLeech", "FireDamageManaLeech", "ChaosDamageManaLeech", "ElementalDamageManaLeech" }, modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", flag = "weapon1Attack", modName = { "DamageLeech", "DamageManaLeech", "PhysicalDamageManaLeech", "LightningDamageManaLeech", "ColdDamageManaLeech", "FireDamageManaLeech", "ChaosDamageManaLeech", "ElementalDamageManaLeech" }, modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", flag = "weapon2Attack", modName = { "DamageLeech", "DamageManaLeech", "PhysicalDamageManaLeech", "LightningDamageManaLeech", "ColdDamageManaLeech", "FireDamageManaLeech", "ChaosDamageManaLeech", "ElementalDamageManaLeech" }, modType = "BASE", cfg = "weapon2" }, 
		{ label = "Enemy modifiers", modName = { "SelfDamageManaLeech" }, modType = "BASE", enemy = true },
	}, },
	{ label = "Mana Gain Rate", notFlag = "showAverage", haveOutput = "ManaOnHitRate", { format = "{1:output:ManaOnHitRate}", 
		{ label = "Player modifiers", notFlag = "attack", modName = "ManaOnHit", modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", flag = "weapon1Attack", modName = "ManaOnHit", modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", flag = "weapon2Attack", modName = "ManaOnHit", modType = "BASE", cfg = "weapon2" }, 
		{ label = "Enemy modifiers", modName = { "SelfManaOnHit" }, modType = "BASE", cfg = "skill", enemy = true },
	}, },
	{ label = "Mana Gain per Hit", flag = "showAverage", haveOutput = "ManaOnHit", { format = "{1:output:ManaOnHit}",
		{ label = "Player modifiers", notFlag = "attack", modName = "ManaOnHit", modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", flag = "weapon1Attack", modName = "ManaOnHit", modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", flag = "weapon2Attack", modName = "ManaOnHit", modType = "BASE", cfg = "weapon2" }, 
		{ label = "Enemy modifiers", modName = { "SelfManaOnHit" }, modType = "BASE", cfg = "skill", enemy = true },
	}, },
} }
} },
{ 1, "EleAilments", 1, colorCodes.OFFENCE, {{ defaultCollapsed = false, label = "Elemental Ailments", data = {
	{ label = "Inc. Scorch Effect", haveOutput = "ScorchEffectMod", flag = "scorch", { format = "{0:output:ScorchEffectMod}%",
		{ label = "Player modifiers", modName = "EnemyScorchEffect", cfg = "skill" },
		{ label = "Enemy modifiers", modName = "SelfScorchEffect", enemy = true },
	}, },
	{ label = "Chance to Scorch", haveOutput = "ScorchChance", flag = "scorch", { format = "{0:output:ScorchChance}%",
		{ breakdown = "MainHand.ScorchChance" }, 
		{ breakdown = "OffHand.ScorchChance" }, 
		{ breakdown = "ScorchChance" }, 
		{ label = "Player modifiers", modName = "EnemyScorchChance", cfg = "skill" }, 
		{ label = "Enemy modifiers", modName = "SelfScorchChance", enemy = true },
		{ label = "Guaranteed Scorches", modName = "ScorchOverride", modType = "BASE" },
	}, },
	{ label = "Scorch Dur. Mod", haveOutput = "ScorchDurationMod", flag = "scorch", { format = "x {2:output:ScorchDurationMod}",
		{ label = "Player modifiers", modName = "EnemyScorchDuration", cfg = "skill" },
		{ label = "Enemy modifiers", modName = "SelfScorchEffect", enemy = true },
	}, },
	{ label = "Effect of Chill", flag = "chill", haveOutput = "ChillSourceEffect", { format = "{0:output:ChillSourceEffect}%", { breakdown = "DotChill" }, }, },
	{ label = "Chill Effect Mod", flag = "chill", { format = "+{0:output:ChillEffectModDisplay}%",
		{ label = "Player modifiers", modName = "EnemyChillEffect", cfg = "skill" },
		{ label = "Enemy modifiers", modName = "SelfChillEffect", enemy = true },
	}, },
	{ label = "Chill Dur. Mod", flag = "chill", { format = "x {2:output:ChillDurationMod}",
		{ breakdown = "ChillDurationMod" },
		{ breakdown = "MainHand.ChillDPS" },
		{ breakdown = "OffHand.ChillDPS" },
		{ breakdown = "ChillDPS" },
		{ label = "Player modifiers", modName = { "EnemyChillDuration", "ChillAsThoughDealing" }, cfg = "skill" },
		{ label = "Enemy modifiers", modName = { "SelfChillEffect", "SelfChillDuration" }, enemy = true },
	}, },
	{ label = "Chance to Freeze", flag = "freeze", { format = "{0:output:FreezeChance}%", 
		{ breakdown = "MainHand.FreezeChance" }, 
		{ breakdown = "OffHand.FreezeChance" }, 
		{ breakdown = "FreezeChance" }, 
		{ label = "Player modifiers", modName = "EnemyFreezeChance", cfg = "skill" }, 
		{ label = "Enemy modifiers", modName = "SelfFreezeChance", enemy = true },
	}, },
	{ label = "Freeze Dur. Mod", flag = "freeze", { format = "x {2:output:FreezeDurationMod}",
		{ breakdown = "FreezeDurationMod" },
		{ breakdown = "MainHand.FreezeDPS" }, 
		{ breakdown = "OffHand.FreezeDPS" },
		{ breakdown = "FreezeDPS" },
		{ label = "Player modifiers", modName = { "EnemyFreezeDuration", "FreezeAsThoughDealing" }, cfg = "skill" },
		{ label = "Enemy modifiers", modName = "SelfFreezeDuration", enemy = true },
	}, },
	{ label = "Inc. Brittle Effect", haveOutput = "BrittleEffectMod", flag = "brittle", { format = "{0:output:BrittleEffectMod}%",
		{ label = "Player modifiers", modName = "EnemyBrittleEffect", cfg = "skill" },
		{ label = "Enemy modifiers", modName = "SelfBrittleEffect", enemy = true },
	}, },
	{ label = "Chance to Brittle", haveOutput = "BrittleChance", flag = "brittle", { format = "{0:output:BrittleChance}%",
		{ breakdown = "MainHand.BrittleChance" }, 
		{ breakdown = "OffHand.BrittleChance" }, 
		{ breakdown = "BrittleChance" }, 
		{ label = "Player modifiers", modName = "EnemyBrittleChance", cfg = "skill" }, 
		{ label = "Enemy modifiers", modName = "SelfBrittleChance", enemy = true },
	}, },
	{ label = "Brittle Dur. Mod", haveOutput = "BrittleDurationMod", flag = "brittle", { format = "x {2:output:BrittleDurationMod}",
		{ label = "Player modifiers", modName = "EnemyBrittleDuration", cfg = "skill" },
		{ label = "Enemy modifiers", modName = "SelfBrittleEffect", enemy = true },
	}, },
	{ label = "Shock Effect Mod", flag = "shock", { format = "+{0:output:ShockEffectModDisplay}%",
		{ label = "Player modifiers", modName = "EnemyShockEffect", cfg = "skill" },
		{ label = "Enemy modifiers", modName = "SelfShockEffect", enemy = true },
	}, },
	{ label = "Chance to Shock", flag = "shock", { format = "{0:output:ShockChance}%", 
		{ breakdown = "MainHand.ShockChance" },
		{ breakdown = "OffHand.ShockChance" },
		{ breakdown = "ShockChance" },
		{ label = "Player modifiers", modName = "EnemyShockChance", cfg = "skill" },
		{ label = "Enemy modifiers", modName = "SelfShockChance", enemy = true },
	}, },
	{ label = "Shock Dur. Mod", flag = "shock", { format = "x {2:output:ShockDurationMod}",
		{ breakdown = "ShockDurationMod" },
		{ breakdown = "MainHand.ShockDPS" },
		{ breakdown = "OffHand.ShockDPS" },
		{ breakdown = "ShockDPS" },
		{ label = "Player modifiers", modName = { "EnemyShockDuration", "ShockAsThoughDealing" }, cfg = "skill" }, 
		{ label = "Enemy modifiers", modName = "SelfShockDuration", enemy = true }, 
	}, },
	{ label = "Maximum Shock", flag = "shock", { format = "{0:output:MaximumShock}%",
		{ modName = "ShockMax" }, 
	}, },
	{ label = "Current Shock", haveOutput = "CurrentShock", { format = "{0:output:CurrentShock}%",
		{ label = "Configured Shock", modName = "ShockVal", enemy = true, modType = "BASE" }, 
		{ label = "Guaranteed Shocks", modName = "ShockOverride", modType = "BASE" },
	}, },
	{ label = "Inc. Sap Effect", haveOutput = "SapEffectMod", flag = "sap", { format = "{0:output:SapEffectMod}%",
		{ label = "Player modifiers", modName = "EnemySapEffect", cfg = "skill" },
		{ label = "Enemy modifiers", modName = "SelfSapEffect", enemy = true },
	}, },
	{ label = "Chance to Sap", haveOutput = "SapChance", flag = "sap", { format = "{0:output:SapChance}%",
		{ breakdown = "MainHand.SapChance" }, 
		{ breakdown = "OffHand.SapChance" }, 
		{ breakdown = "SapChance" }, 
		{ label = "Player modifiers", modName = "EnemySapChance", cfg = "skill" }, 
		{ label = "Enemy modifiers", modName = "SelfSapChance", enemy = true },
	}, },
	{ label = "Sap Duration Mod", haveOutput = "SapDurationMod", flag = "sap", { format = "x {2:output:SapDurationMod}",
		{ label = "Player modifiers", modName = "EnemySapDuration", cfg = "skill" },
		{ label = "Enemy modifiers", modName = "SelfSapEffect", enemy = true },
	}, },
} }
} },
{ 1, "MiscEffects", 1, colorCodes.OFFENCE, {{ defaultCollapsed = false, label = "Other Effects", data = {
	{ label = "Stun Threshold", flag = "hit", notFlag = "attack", { format = "x {2:output:EnemyStunThresholdMod}", { modName = "EnemyStunThreshold", cfg = "skill" }, }, },
	{ label = "Stun Duration", flag = "hit", notFlag = "attack", { format = "{2:output:EnemyStunDuration}s", 
		{ breakdown = "EnemyStunDuration" }, 
		{ label = "Player modifiers", modName = { "EnemyStunDuration" }, cfg = "skill" },
		{ label = "Enemy modifiers", modName = { "StunRecovery" }, enemy = true },
	}, },
	{ label = "MH Stun Threshold", bgCol = colorCodes.MAINHANDBG, flagList = {"hit","weapon1Attack"}, { format = "x {2:output:MainHand.EnemyStunThresholdMod}", { modName = "EnemyStunThreshold", cfg = "weapon1" }, }, },
	{ label = "MH Stun Duration", bgCol = colorCodes.MAINHANDBG, flagList = {"hit","weapon1Attack"}, { format = "{2:output:MainHand.EnemyStunDuration}s", 
		{ breakdown = "MainHand.EnemyStunDuration" }, 
		{ label = "Player modifiers", modName = { "EnemyStunDuration" }, cfg = "weapon1" },
		{ label = "Enemy modifiers", modName = { "StunRecovery" }, enemy = true },
	}, },
	{ label = "OH Stun Threshold", bgCol = colorCodes.OFFHANDBG, flagList = {"hit","weapon2Attack"}, { format = "x {2:output:OffHand.EnemyStunThresholdMod}", { modName = "EnemyStunThreshold", cfg = "weapon2" }, }, },
	{ label = "OH Stun Duration", bgCol = colorCodes.OFFHANDBG, flagList = {"hit","weapon2Attack"}, { format = "{2:output:OffHand.EnemyStunDuration}s", 
		{ breakdown = "OffHand.EnemyStunDuration" }, 
		{ label = "Player modifiers", modName = { "EnemyStunDuration" }, cfg = "weapon2" },
		{ label = "Enemy modifiers", modName = { "StunRecovery" }, enemy = true },
	}, },
	{ label = "Knockback Chance", haveOutput = "KnockbackChance", { format = "{0:output:KnockbackChance}%", 
		{ label = "Player modifiers", modName = "EnemyKnockbackChance", cfg = "skill" }, 
		{ label = "Enemy modifiers", modName = "SelfKnockbackChance", enemy = true },
	}, },
	{ label = "Knockback Dist.", haveOutput = "KnockbackChance", { format = "{0:output:KnockbackDistance}", 
		{ breakdown = "KnockbackDistance" },
		{ modName = "EnemyKnockbackDistance", cfg = "skill" }, 
	}, },
	{ label = "MH K.B. Chance", bgCol = colorCodes.MAINHANDBG, haveOutput = "MainHand.KnockbackChance", { format = "{0:output:MainHand.KnockbackChance}%", 
		{ label = "Player modifiers", modName = "EnemyKnockbackChance", cfg = "weapon1" },
		{ label = "Enemy modifiers", modName = "SelfKnockbackChance", enemy = true },
	}, },
	{ label = "MH K.B. Dist.", bgCol = colorCodes.MAINHANDBG, haveOutput = "MainHand.KnockbackChance", { format = "{0:output:MainHand.KnockbackDistance}",
		{ breakdown = "MainHand.KnockbackDistance" },
		{ modName = "EnemyKnockbackDistance", cfg = "weapon1" },
	}, },
	{ label = "OH K.B. Chance", bgCol = colorCodes.OFFHANDBG, haveOutput = "OffHand.KnockbackChance", { format = "{0:output:OffHand.KnockbackChance}%", 
		{ label = "Player modifiers", modName = "EnemyKnockbackChance", cfg = "weapon2" },
		{ label = "Enemy modifiers", modName = "SelfKnockbackChance", enemy = true },
	}, },
	{ label = "OH K.B. Dist.", bgCol = colorCodes.OFFHANDBG, haveOutput = "OffHand.KnockbackChance", { format = "{0:output:OffHand.KnockbackDistance}",
		{ breakdown = "OffHand.KnockbackDistance" },
		{ modName = "EnemyKnockbackDistance", cfg = "weapon2" },
	}, },
	{ label = "Maximum Rage", haveOutput = "MaximumRage", { format = "{0:output:MaximumRage}", { modName = "MaximumRage" },	}, },
	{ label = "Rage Regen", haveOutput = "RageRegen", { format = "{2:output:RageRegen}",
		{ breakdown = "RageRegen" },
		{ modName = "RageRegen" },
	}, },
	{ label = "Inc. Item Quantity", { format = "{0:mod:1}%", { modName = "LootQuantity", modType = "INC", cfg = "skill" }, }, },
	{ label = "Inc. Item Rarity", { format = "{0:mod:1}%", { modName = "LootRarity", modType = "INC", cfg = "skill" }, }, },
	{ label = "Culling Strike", haveOutput = "CullPercent", { format = "{0:output:CullPercent}%", { modName = { "CullPercent", "CriticalCullPercent" }, cfg = "skill" } } },
} }
} },
--misc
{ 1, "Attributes", 2, colorCodes.NORMAL, {{ defaultCollapsed = false, label = "Attributes", data = {
	extra = colorCodes.STRENGTH.."{0:output:Str}^7, "..colorCodes.DEXTERITY.."{0:output:Dex}^7, "..colorCodes.INTELLIGENCE.."{0:output:Int}",
	{ label = "Strength", { format = "{0:output:Str}", { breakdown = "Str" }, { modName = "Str" }, }, },
	{ label = "Dexterity", { format = "{0:output:Dex}", { breakdown = "Dex" }, { modName = "Dex" }, }, },
	{ label = "Intelligence", { format = "{0:output:Int}", { breakdown = "Int" }, { modName = "Int" }, }, },
	{ notFlag = "minionSkill", label = "Str. Required", { format = "{output:ReqStrString}", { breakdown = "ReqStr" }, }, },
	{ notFlag = "minionSkill", label = "Dex. Required", { format = "{output:ReqDexString}", { breakdown = "ReqDex" }, }, },
	{ notFlag = "minionSkill", label = "Int. Required", { format = "{output:ReqIntString}", { breakdown = "ReqInt" }, }, },
} }
} },
--defence
{ 1, "Life", 2, colorCodes.DEFENCE, {{ defaultCollapsed = false, label = "Life", data = {
	extra = "{0:output:LifeUnreserved}/{0:output:Life}",
	{ label = "Base from Gear", { format = "{0:mod:1}", { modName = "Life", modType = "BASE", modSource = "Item" }, }, },
	{ label = "Inc. from Tree", { format = "{0:mod:1}%", { modName = "Life", modType = "INC", modSource = "Tree" }, }, },
	{ label = "Total Base", { format = "{0:mod:1}", { modName = "Life", modType = "BASE" }, }, },
	{ label = "Total Increased", { format = "{0:mod:1}%", { modName = "Life", modType = "INC", }, }, },
	{ label = "Total More", { format = "{0:mod:1}%", { modName = "Life", modType = "MORE", }, }, },
	{ label = "Total", { format = "{0:output:Life}", { breakdown = "Life" }, }, },
	{ label = "Reserved", { format = "{0:output:LifeReserved} ({0:output:LifeReservedPercent}%)", { breakdown = "LifeReserved" }, }, },
	{ label = "Unreserved", { format = "{0:output:LifeUnreserved} ({0:output:LifeUnreservedPercent}%)" }, },
	{ label = "Recharge Rate", haveOutput = "EnergyShieldRechargeAppliesToLife", { format = "{1:output:LifeRecharge}", 
		{ breakdown = "LifeRecharge" },
		{ modName = { "EnergyShieldRecharge", "LifeRecoveryRate", "NoEnergyShieldRecharge", "EnergyShieldRechargeAppliesToLife" }, },
	}, },
	{ label = "Recharge Delay", haveOutput = "EnergyShieldRechargeAppliesToLife", { format = "{2:output:EnergyShieldRechargeDelay}s", 
		{ breakdown = "EnergyShieldRechargeDelay" },
		{ modName = "EnergyShieldRechargeFaster" },
	}, },
	{ label = "Regen", { format = "{1:output:LifeRegen} ({1:output:LifeRegenPercent}%)", 
		{ label = "Sources", modName = { "LifeRegen", "LifeRegenPercent", "LifeDegen", "LifeDegen", "LifeRecovery" }, modType = "BASE" }, 
		{ label = "Recovery modifiers", modName = "LifeRecoveryRate" },
	}, },
} }
} },
{ 1, "Mana", 2, colorCodes.DEFENCE, {{ defaultCollapsed = false, label = "Mana", data = {
	extra = "{0:output:ManaUnreserved}/{0:output:Mana}",
	notFlag = "minionSkill",
	{ label = "Base from Gear", { format = "{0:mod:1}", { modName = "Mana", modType = "BASE", modSource = "Item" }, }, },
	{ label = "Inc. from Tree", { format = "{0:mod:1}%", { modName = "Mana", modType = "INC", modSource = "Tree" }, }, },
	{ label = "Total Base", { format = "{0:mod:1}", { modName = "Mana", modType = "BASE" }, }, },
	{ label = "Total Increased", { format = "{0:mod:1}%", { modName = "Mana", modType = "INC" }, }, },
	{ label = "Total", { format = "{0:output:Mana}", { breakdown = "Mana" }, }, },
	{ label = "Reserved", { format = "{0:output:ManaReserved} ({0:output:ManaReservedPercent}%)", { breakdown = "ManaReserved" }, }, },
	{ label = "Unreserved", { format = "{0:output:ManaUnreserved} ({0:output:ManaUnreservedPercent}%)" }, },
	{ label = "Increased Regen", { format = "{0:output:ManaRegenInc}%", { modName = "ManaRegen", modType = "INC" }, }, },
	{ label = "Regen", { format = "{1:output:ManaRegen}", 
		{ breakdown = "ManaRegen" }, 
		{ label = "Sources", modName = { "ManaRegen", "ManaRegenPercent", "ManaDegen" }, modType = "BASE" },
		{ label = "Recovery modifiers", modName = "ManaRecoveryRate" },
	}, },
} }
} },
{ 1, "EnergyShield", 2, colorCodes.DEFENCE, {{ defaultCollapsed = false, label = "Energy Shield", data = {
	extra = "{0:output:EnergyShield}",
	{ label = "Base from Armours", { format = "{0:output:Gear:EnergyShield}", { breakdown = "EnergyShield", gearOnly = true }, }, },
	{ label = "Global Base", { format = "{0:mod:1}", { modName = "EnergyShield", modType = "BASE" }, }, },
	{ label = "Inc. from Tree", { format = "{0:mod:1}%", { modName = "EnergyShield", modType = "INC", modSource = "Tree" }, }, },
	{ label = "Total Increased", { format = "{0:mod:1}%", { modName = { "EnergyShield", "Defences" }, modType = "INC" }, }, },
	{ label = "Total More", { format = "{0:mod:1}%", { modName = { "EnergyShield", "Defences" }, modType = "MORE" }, }, },
	{ label = "Total", { format = "{0:output:EnergyShield}", { breakdown = "EnergyShield" }, }, },
	{ label = "Recharge Rate", haveOutput = "EnergyShieldRechargeAppliesToEnergyShield", { format = "{1:output:EnergyShieldRecharge}", 
		{ breakdown = "EnergyShieldRecharge" },
		{ modName = { "EnergyShieldRecharge", "EnergyShieldRecoveryRate", "NoEnergyShieldRecharge" }, },
	}, },
	{ label = "Recharge Delay", haveOutput = "EnergyShieldRechargeAppliesToEnergyShield", { format = "{2:output:EnergyShieldRechargeDelay}s", 
		{ breakdown = "EnergyShieldRechargeDelay" },
		{ modName = "EnergyShieldRechargeFaster" },
	}, },
	{ label = "Regen", { format = "{1:output:EnergyShieldRegen} ({1:output:EnergyShieldRegenPercent}%)", 
		{ label = "Sources", modName = { "EnergyShieldRegen", "EnergyShieldRecovery", "EnergyShieldRegenPercent", "EnergyShieldDegen", "NoEnergyShieldRegen" } }, 
		{ label = "Recovery modifiers", modName = "EnergyShieldRecoveryRate" },
	}, },
} }
} },
{ 1, "Ward", 2, colorCodes.DEFENCE, {{ defaultCollapsed = false, label = "Ward", data = {
	extra = "{0:output:Ward}",
	{ label = "Base from Armours", { format = "{0:output:Gear:Ward}", { breakdown = "Ward", gearOnly = true }, }, },
	{ label = "Global Base", { format = "{0:mod:1}", { modName = "Ward", modType = "BASE" }, }, },
	{ label = "Inc. from Tree", { format = "{0:mod:1}%", { modName = "Ward", modType = "INC", modSource = "Tree" }, }, },
	{ label = "Total Increased", { format = "{0:mod:1}%", { modName = { "Ward", "Defences" }, modType = "INC" }, }, },
	{ label = "Total More", { format = "{0:mod:1}%", { modName = { "Ward", "Defences" }, modType = "MORE" }, }, },
	{ label = "Total", { format = "{0:output:Ward}", { breakdown = "Ward" }, }, },
	{ label = "Recharge Delay", { format = "{2:output:WardRechargeDelay}s",
		{ breakdown = "WardRechargeDelay" },
		{ modName = "WardRechargeFaster" },
	}, },
	{ label = "Regen", { format = "{1:output:EnergyShieldRegen} ({1:output:EnergyShieldRegenPercent}%)",
		{ label = "Sources", modName = { "EnergyShieldRegen", "EnergyShieldRecovery", "EnergyShieldRegenPercent", "EnergyShieldDegen", "NoEnergyShieldRegen" } },
		{ label = "Recovery modifiers", modName = "EnergyShieldRecoveryRate" },
	}, },
} }
} },
{ 1, "Armour", 3, colorCodes.DEFENCE, {{ defaultCollapsed = false, label = "Armour", data = {
	extra = "{0:output:Armour}",
	{ label = "Base from Armours", { format = "{0:output:Gear:Armour}", { breakdown = "Armour", gearOnly = true }, }, },
	{ label = "Global Base", { format = "{0:mod:1}", { modName = "Armour", modType = "BASE" }, }, },
	{ label = "Inc. from Tree", { format = "{0:mod:1}%", { modName = { "Armour", "ArmourAndEvasion" }, modType = "INC", modSource = "Tree", }, }, },
	{ label = "Total Increased", { format = "{0:mod:1}%", { modName = { "Armour", "ArmourAndEvasion", "Defences" }, modType = "INC" }, }, },
	{ label = "Total More", { format = "{0:mod:1}%", { modName = { "Armour", "ArmourAndEvasion", "Defences" }, modType = "MORE" }, }, },
	{ label = "Total", { format = "{0:output:Armour}", { breakdown = "Armour" }, }, },
	{ label = "Double Armour Ch.", haveOutput = "DoubleArmourChance", { format = "{0:output:DoubleArmourChance}%", { modName = "DoubleArmourChance" }, }, },
	{ label = "Phys. Dmg. Reduct", { format = "{0:output:PhysicalDamageReduction}%", 
		{ breakdown = "PhysicalDamageReduction" },
		{ modName = { "PhysicalDamageReduction", "PhysicalDamageReductionWhenHit", "ArmourDoesNotApplyToPhysicalDamageTaken", "DamageReductionMax" } }, 
	}, },
	{ label = "Fire Dmg. Reduct", haveOutput = "FireDamageReduction", { format = "{0:output:FireDamageReduction}%", 
		{ breakdown = "FireDamageReduction" },
		{ modName = { "ArmourAppliesToFireDamageTaken", "SelfIgnoreFireResistance", "DamageReductionMax" } }, 
	}, },
	{ label = "Cold Dmg. Reduct", haveOutput = "ColdDamageReduction", { format = "{0:output:ColdDamageReduction}%", 
		{ breakdown = "ColdDamageReduction" },
		{ modName = { "ArmourAppliesToColdDamageTaken", "SelfIgnoreColdResistance", "DamageReductionMax" } }, 
	}, },
	{ label = "Light. Dmg. Reduct", haveOutput = "LightningDamageReduction", { format = "{0:output:LightningDamageReduction}%", 
		{ breakdown = "LightningDamageReduction" },
		{ modName = { "ArmourAppliesToLightningDamageTaken", "SelfIgnoreLightningResistance", "DamageReductionMax" } }, 
	}, },
} }
} },
{ 1, "Evasion", 3, colorCodes.DEFENCE, {{ defaultCollapsed = false, label = "Evasion", data = {
	extra = "{0:output:Evasion}",
	{ label = "Base from Armours", { format = "{0:output:Gear:Evasion}", { breakdown = "Evasion", gearOnly = true }, }, },
	{ label = "Global Base", { format = "{0:mod:1}", { modName = "Evasion", modType = "BASE" }, }, },
	{ label = "Inc. from Tree", { format = "{0:mod:1}%", { modName = { "Evasion", "ArmourAndEvasion" }, modType = "INC", modSource = "Tree" }, }, },
	{ label = "Total Increased", { format = "{0:mod:1}%", { modName = { "Evasion", "ArmourAndEvasion", "Defences" }, modType = "INC" }, }, },
	{ label = "Total More", { format = "{0:mod:1}%", { modName = { "Evasion", "ArmourAndEvasion", "Defences" }, modType = "MORE" }, }, },
	{ label = "Total", { format = "{0:output:Evasion}", { breakdown = "Evasion" }, }, },
	{ label = "Evade Chance", haveOutput = "dontSplitEvade", { format = "{0:output:EvadeChance}%", 
	  { breakdown = "EvadeChance" },
    { label = "Player modifiers", modName = { "CannotEvade", "EvadeChance", "MeleeEvadeChance", "ProjectileEvadeChance" } },
	  { label = "Enemy modifiers", modName = { "Accuracy", "HitChance" }, enemy = true },
	}, },
	 { label = "Melee Evade Ch.", haveOutput = "splitEvade", { format = "{0:output:MeleeEvadeChance}%", 
	    { breakdown = "MeleeEvadeChance" },
	    { label = "Player modifiers", modName = { "CannotEvade", "EvadeChance", "MeleeEvadeChance" } },
	    { label = "Enemy modifiers", modName = { "Accuracy", "HitChance" }, enemy = true },
	}, },
	{ label = "Proj. Evade Ch.", haveOutput = "splitEvade", { format = "{0:output:ProjectileEvadeChance}%", 
	    { breakdown = "ProjectileEvadeChance" },
	    { label = "Player modifiers", modName = { "CannotEvade", "EvadeChance", "ProjectileEvadeChance" } },
	    { label = "Enemy modifiers", modName = { "Accuracy", "HitChance" }, enemy = true },
	}, },
} }
} },
{ 1, "Resist", 3, colorCodes.DEFENCE, {{ defaultCollapsed = false, label = "Resists", data = {
	extra = colorCodes.FIRE.."{0:output:FireResist}+{0:output:FireResistOverCap}^7/"..colorCodes.COLD.."{0:output:ColdResist}+{0:output:ColdResistOverCap}^7/"..colorCodes.LIGHTNING.."{0:output:LightningResist}+{0:output:LightningResistOverCap}",
	{ label = "Fire Resist", { format = "{0:output:FireResist}% (+{0:output:FireResistOverCap}%)",
		{ breakdown = "FireResist" }, 
		{ modName = { "FireResistMax", "ElementalResistMax", "FireResist", "ElementalResist" }, },
	}, },
	{ label = "Cold Resist", { format = "{0:output:ColdResist}% (+{0:output:ColdResistOverCap}%)", 
		{ breakdown = "ColdResist" },
		{ modName = { "ColdResistMax", "ElementalResistMax", "ColdResist", "ElementalResist" }, },
	}, },
	{ label = "Lightning Resist", { format = "{0:output:LightningResist}% (+{0:output:LightningResistOverCap}%)",
		{ breakdown = "LightningResist" },
		{ modName = { "LightningResistMax", "ElementalResistMax", "LightningResist", "ElementalResist" }, },
	}, },
	{ label = "Chaos Resist", { format = "{0:output:ChaosResist}% (+{0:output:ChaosResistOverCap}%)",
		{ breakdown = "ChaosResist" },
		{ modName = { "ChaosResistMax", "ChaosResist" }, }, 
	}, },
} }
} },
{ 1, "Block", 3, colorCodes.DEFENCE, {{ defaultCollapsed = false, label = "Block", data = {
	extra = "{0:output:BlockChance}%/{0:output:SpellBlockChance}%",
	{ label = "Block Chance", { format = "{0:output:BlockChance}%",
		{ breakdown = "BlockChance" },
		{ modName = "BlockChance" }, 
	}, },
	{ label = "Spell Block Chance", { format = "{0:output:SpellBlockChance}%", 
		{ breakdown = "SpellBlockChance" }, 
		{ modName = { "SpellBlockChance", "BlockChanceConv" }, },
	}, },
	{ label = "Taken From Block", haveOutput = "ShowBlockEffect", { format = "{0:output:DamageTakenOnBlock}%", 
		{ breakdown = "BlockEffect" }, 
		{ modName = { "BlockEffect" }, },
	}, },
} }, { defaultCollapsed = true, label = "Gain on Block", data = {
	extra = "{0:output:LifeOnBlock}/{0:output:ManaOnBlock}/{0:output:EnergyShieldOnBlock}",
	{ label = "Life on Block", { format = "{0:output:LifeOnBlock}", { modName = "LifeOnBlock" }, }, },
	{ label = "Mana on Block", { format = "{0:output:ManaOnBlock}", { modName = "ManaOnBlock" }, }, },
	{ label = "ES on Block", { format = "{0:output:EnergyShieldOnBlock}", { modName = "EnergyShieldOnBlock" }, }, },
} },
} },
{ 1, "MiscDefences", 3, colorCodes.DEFENCE, {{ defaultCollapsed = false, label = "Other Defences", data = {
	{ label = "Movement Speed", { format = "x {2:output:EffectiveMovementSpeedMod}", { breakdown = "EffectiveMovementSpeedMod" }, { modName = "MovementSpeed" }, }, },
	{ label = "Effect of Elusive", haveOutput = "ElusiveEffectMod", { format = "{0:output:ElusiveEffectMod}%", { breakdown = "ElusiveEffectMod" }, { modName = { "ElusiveEffect", "BuffEffectOnSelf" }, }, } },
	{ label = "Stun Duration", { format = "{2:output:StunDuration}s", 
		{ breakdown = "StunDuration" },
		{ modName = "StunRecovery" },
	}, },
	{ label = "Block Duration", { format = "{2:output:BlockDuration}s", 
		{ breakdown = "BlockDuration" },
		{ modName = { "StunRecovery", "BlockRecovery" }, }, 
	}, },
	{ label = "Light Radius Mod", { format = "x {2:output:LightRadiusMod}", { breakdown = "LightRadiusMod" }, { modName = "LightRadius" }, }, },
} }, { defaultCollapsed = false, label = "Damage Avoidance", data = {
	{ label = "Avoid Physical Ch.", haveOutput = "AvoidPhysicalDamageChance", { format = "{0:output:AvoidPhysicalDamageChance}%", { modName = "AvoidPhysicalDamageChance" }, }, },
	{ label = "Avoid Lightning Ch.", haveOutput = "AvoidLightningDamageChance", { format = "{0:output:AvoidLightningDamageChance}%", { modName = "AvoidLightningDamageChance" }, }, },
	{ label = "Avoid Cold Chance", haveOutput = "AvoidColdDamageChance", { format = "{0:output:AvoidColdDamageChance}%", { modName = "AvoidColdDamageChance" }, }, },
	{ label = "Avoid Fire Chance", haveOutput = "AvoidFireDamageChance", { format = "{0:output:AvoidFireDamageChance}%", { modName = "AvoidFireDamageChance" }, }, },
	{ label = "Avoid Chaos Chance", haveOutput = "AvoidChaosDamageChance", { format = "{0:output:AvoidChaosDamageChance}%", { modName = "AvoidChaosDamageChance" }, }, },
	{ label = "Avoid Projectiles Ch.", haveOutput = "AvoidProjectilesChance", { format = "{0:output:AvoidProjectilesChance}%", { modName = "AvoidProjectilesChance" }, }, },
} }, { defaultCollapsed = true, label = "Other Avoidance", data = {
	{ label = "Stun Avoid Chance", haveOutput = "StunAvoidChance", { format = "{0:output:StunAvoidChance}%", { modName = "AvoidStun" }, }, },
	{ label = "Interupt Avoid Ch.", haveOutput = "InteruptStunAvoidChance", { format = "{0:output:InteruptStunAvoidChance}%", { modName = "AvoidInteruptStun" }, }, },
	{ label = "Blind Avoid Ch.", haveOutput = "BlindAvoidChance", { format = "{0:output:BlindAvoidChance}%", { modName = "AvoidBlind" }, }, },
	{ label = "Shock Avoid Ch.", haveOutput = "ShockAvoidChance", { format = "{0:output:ShockAvoidChance}%", { modName = "AvoidShock" }, }, },
	{ label = "Freeze Avoid Ch.", haveOutput = "FreezeAvoidChance", { format = "{0:output:FreezeAvoidChance}%", { modName = "AvoidFreeze" }, }, },
	{ label = "Chill Avoid Ch.", haveOutput = "ChillAvoidChance", { format = "{0:output:ChillAvoidChance}%", { modName = "AvoidChill" }, }, },
	{ label = "Ignite Avoid Ch.", haveOutput = "IgniteAvoidChance", { format = "{0:output:IgniteAvoidChance}%", { modName = "AvoidIgnite" }, }, },
	{ label = "Bleed Avoid Ch.", haveOutput = "BleedAvoidChance", { format = "{0:output:BleedAvoidChance}%", { modName = "AvoidBleed" }, }, },
	{ label = "Poison Avoid Ch.", haveOutput = "PoisonAvoidChance", { format = "{0:output:PoisonAvoidChance}%", { modName = "AvoidPoison" }, }, },
	{ label = "Crit Reduction", haveOutput = "CritExtraDamageReduction", { format = "{0:output:CritExtraDamageReduction}%", { modName = "ReduceCritExtraDamage" }, }, },
} }, { defaultCollapsed = false, label = "Dodge", data = {
	extra = "{0:output:AttackDodgeChance}%/{0:output:SpellDodgeChance}%",
	{ label = "Dodge Chance", { format = "{0:output:AttackDodgeChance}%", { modName = "AttackDodgeChance" }, }, },
	{ label = "Spell Ddg. Chance", { format = "{0:output:SpellDodgeChance}%", { modName = "SpellDodgeChance" }, }, }, 
} },
} },
{ 3, "DamageTaken", 1, colorCodes.DEFENCE, {{ defaultCollapsed = false, label = "Damage Taken", data = {
	colWidth = 114,
	{
		{ format = "Physical:" },
		{ format = "Lightning:" },
		{ format = "Cold:" },
		{ format = "Fire:" },
		{ format = "Chaos:" },
	},
	{ label = "Hit taken",
		{ format = "x {2:output:PhysicalTakenHitMult}", 
			{ breakdown = "PhysicalTakenHitMult" }, 
			{ modName = { "DamageTaken", "DamageTakenWhenHit", "PhysicalDamageTaken", "PhysicalDamageTakenWhenHit", "PhysicalDamageTakenAsFire", "PhysicalDamageTakenAsCold", "PhysicalDamageTakenAsLightning", "PhysicalDamageTakenAsChaos" } } 
		},
		{ format = "x {2:output:LightningTakenHitMult}",
			{ breakdown = "LightningTakenHitMult" }, 
			{ modName = { "DamageTaken", "DamageTakenWhenHit", "LightningDamageTaken", "LightningDamageTakenWhenHit", "ElementalDamageTaken", "ElementalDamageTakenWhenHit", "LightningDamageTakenAsPhysical", "LightningDamageTakenAsFire", "LightningDamageTakenAsCold", "LightningDamageTakenAsChaos", "ElementalDamageTakenAsPhysical", "ElementalDamageTakenAsChaos", "SelfIgnoreLightningResistance" } }
		},
		{ format = "x {2:output:ColdTakenHitMult}",
			{ breakdown = "ColdTakenHitMult" }, 
			{ modName = { "DamageTaken", "DamageTakenWhenHit", "ColdDamageTaken", "ColdDamageTakenWhenHit", "ElementalDamageTaken", "ElementalDamageTakenWhenHit", "ColdDamageTakenAsPhysical", "ColdDamageTakenAsFire", "ColdDamageTakenAsLightning", "ColdDamageTakenAsChaos", "ElementalDamageTakenAsPhysical", "ElementalDamageTakenAsChaos", "SelfIgnoreColdResistance" } }
		},
		{ format = "x {2:output:FireTakenHitMult}", 
			{ breakdown = "FireTakenHitMult" }, 
			{ modName = { "DamageTaken", "DamageTakenWhenHit", "FireDamageTaken", "FireDamageTakenWhenHit", "ElementalDamageTaken", "ElementalDamageTakenWhenHit", "FireDamageTakenAsPhysical", "FireDamageDamageTakenAsCold", "FireDamageTakenAsLightning", "FireDamageTakenAsChaos", "ElementalDamageTakenAsPhysical", "ElementalDamageTakenAsChaos", "SelfIgnoreFireResistance" }  } 
		},
		{ format = "x {2:output:ChaosTakenHitMult}",
			{ breakdown = "ChaosTakenHitMult" }, 
			{ modName = { "DamageTaken", "DamageTakenWhenHit", "ChaosDamageTaken", "ChaosDamageTakenWhenHit", "ChaosDamageTakenAsPhysical", "ChaosDamageTakenAsFire", "ChaosDamageTakenAsCold", "ChaosDamageTakenAsLightning", "SelfIgnoreChaosResistance" } }
		},
	},
	{ label = "DoT taken",
		{ format = "x {2:output:PhysicalTakenDotMult}", 
			{ breakdown = "PhysicalTakenDotMult" }, 
			{ modName = { "DamageTaken", "DamageTakenOverTime", "PhysicalDamageTaken", "PhysicalDamageTakenOverTime" } } 
		},
		{ format = "x {2:output:LightningTakenDotMult}",
			{ breakdown = "LightningTakenDotMult" }, 
			{ modName = { "DamageTaken", "DamageTakenOverTime", "LightningDamageTaken", "LightningDamageTakenOverTime", "ElementalDamageTaken", "ElementalDamageTakenOverTime", "SelfIgnoreLightningResistance" } }
		},
		{ format = "x {2:output:ColdTakenDotMult}",
			{ breakdown = "ColdTakenDotMult" }, 
			{ modName = { "DamageTaken", "DamageTakenOverTime", "ColdDamageTaken", "ColdDamageTakenOverTime", "ElementalDamageTaken", "ElementalDamageTakenOverTime", "SelfIgnoreColdResistance" } }
		},
		{ format = "x {2:output:FireTakenDotMult}", 
			{ breakdown = "FireTakenDotMult" }, 
			{ modName = { "DamageTaken", "DamageTakenOverTime", "FireDamageTaken", "FireDamageTakenOverTime", "ElementalDamageTaken", "ElementalDamageTakenOverTime", "SelfIgnoreFireResistance" }  } 
		},
		{ format = "x {2:output:ChaosTakenDotMult}",
			{ breakdown = "ChaosTakenDotMult" }, 
			{ modName = { "DamageTaken", "DamageTakenOverTime", "ChaosDamageTaken", "ChaosDamageTakenOverTime", "SelfIgnoreChaosResistance" } }
		},
	},
	{ label = "Reflect taken", haveOutput = "AnyTakenReflect",
		{ format = "x {2:output:PhysicalTakenReflectMult}", 
			{ breakdown = "PhysicalTakenReflectMult" }, 
			{ modName = { "DamageTaken", "DamageTakenWhenHit", "PhysicalDamageTaken", "PhysicalDamageTakenWhenHit", "PhysicalReflectedDamageTaken", "PhysicalDamageTakenAsFire", "PhysicalDamageTakenAsCold", "PhysicalDamageTakenAsLightning", "PhysicalDamageTakenAsChaos" } } 
		},
		{ format = "x {2:output:LightningTakenReflectMult}",
			{ breakdown = "LightningTakenReflectMult" }, 
			{ modName = { "DamageTaken", "DamageTakenWhenHit", "LightningDamageTaken", "LightningDamageTakenWhenHit", "LightningReflectedDamageTaken", "ElementalDamageTaken", "ElementalDamageTakenWhenHit", "ElementalReflectedDamageTaken", "LightningDamageTakenAsPhysical", "LightningDamageTakenAsFire", "LightningDamageTakenAsCold", "LightningDamageTakenAsChaos", "ElementalDamageTakenAsPhysical", "ElementalDamageTakenAsChaos" } }
		},
		{ format = "x {2:output:ColdTakenReflectMult}",
			{ breakdown = "ColdTakenReflectMult" }, 
			{ modName = { "DamageTaken", "DamageTakenWhenHit", "ColdDamageTaken", "ColdDamageTakenWhenHit", "ColdReflectedDamageTaken", "ElementalDamageTaken", "ElementalDamageTakenWhenHit", "ElementalReflectedDamageTaken", "ColdDamageTakenAsPhysical", "ColdDamageTakenAsFire", "ColdDamageTakenAsLightning", "ColdDamageTakenAsChaos", "ElementalDamageTakenAsPhysical", "ElementalDamageTakenAsChaos" } }
		},
		{ format = "x {2:output:FireTakenReflectMult}", 
			{ breakdown = "FireTakenReflectMult" }, 
			{ modName = { "DamageTaken", "DamageTakenWhenHit", "FireDamageTaken", "FireDamageTakenWhenHit", "FireReflectedDamageTaken", "ElementalDamageTaken", "ElementalDamageTakenWhenHit", "ElementalReflectedDamageTaken", "ElementalDamageTakenOverTime", "FireDamageTakenAsPhysical", "FireDamageDamageTakenAsCold", "FireDamageTakenAsLightning", "FireDamageTakenAsChaos", "ElementalDamageTakenAsPhysical", "ElementalDamageTakenAsChaos" }  } 
		},
		{ format = "x {2:output:ChaosTakenReflectMult}",
			{ breakdown = "ChaosTakenReflectMult" }, 
			{ modName = { "DamageTaken", "DamageTakenWhenHit", "ChaosDamageTaken", "ChaosDamageTakenWhenHit", "ChaosDamageTakenAsPhysical", "ChaosDamageTakenAsFire", "ChaosDamageTakenAsCold", "ChaosDamageTakenAsLightning" } }
		},
	},
} }, { defaultCollapsed = false, label = "Chance to not be Hit", data = {
	{ label = "Melee Ch.", { format = "{0:output:MeleeNotHitChance}%", { breakdown = "MeleeNotHitChance" }, }, },
	{ label = "Projectile Ch.", { format = "{0:output:ProjectileNotHitChance}%", { breakdown = "ProjectileNotHitChance" }, }, },
	{ label = "Spell Ch.", { format = "{0:output:SpellNotHitChance}%", { breakdown = "SpellNotHitChance" }, }, },
	{ label = "Spell Projectile Ch.", { format = "{0:output:SpellProjectileNotHitChance}%", { breakdown = "SpellProjectileNotHitChance" }, }, },
}, }, { defaultCollapsed = false, label = "Chance to not take Damage when Hit", data = {
	colWidth = 114,
	{ label = "Melee Ch.",
		{ format = "{1:output:PhysicalMeleeDamageChance}%", 
			{ breakdown = "PhysicalMeleeDamageChance" }, 
		},
		{ format = "{1:output:LightningMeleeDamageChance}%",
			{ breakdown = "LightningMeleeDamageChance" }, 
		},
		{ format = "{1:output:ColdMeleeDamageChance}%",
			{ breakdown = "ColdMeleeDamageChance" }, 
		},
		{ format = "{1:output:FireMeleeDamageChance}%", 
			{ breakdown = "FireMeleeDamageChance" }, 
		},
		{ format = "{1:output:ChaosMeleeDamageChance}%",
			{ breakdown = "ChaosMeleeDamageChance" }, 
		},
	},
	{ label = "Projectile Ch.",
		{ format = "{1:output:PhysicalProjectileDamageChance}%", 
			{ breakdown = "PhysicalProjectileDamageChance" }, 
		},
		{ format = "{1:output:LightningProjectileDamageChance}%",
			{ breakdown = "LightningProjectileDamageChance" }, 
		},
		{ format = "{1:output:ColdProjectileDamageChance}%",
			{ breakdown = "ColdProjectileDamageChance" }, 
		},
		{ format = "{1:output:FireProjectileDamageChance}%", 
			{ breakdown = "FireProjectileDamageChance" }, 
		},
		{ format = "{1:output:ChaosProjectileDamageChance}%",
			{ breakdown = "ChaosProjectileDamageChance" }, 
		},
	},
	{ label = "Spell Ch.",
		{ format = "{1:output:PhysicalSpellDamageChance}%", 
			{ breakdown = "PhysicalSpellDamageChance" }, 
		},
		{ format = "{1:output:LightningSpellDamageChance}%",
			{ breakdown = "LightningSpellDamageChance" }, 
		},
		{ format = "{1:output:ColdSpellDamageChance}%",
			{ breakdown = "ColdSpellDamageChance" }, 
		},
		{ format = "{1:output:FireSpellDamageChance}%", 
			{ breakdown = "FireSpellDamageChance" }, 
		},
		{ format = "{1:output:ChaosSpellDamageChance}%",
			{ breakdown = "ChaosSpellDamageChance" }, 
		},
	},
	{ label = "Spell Projectile Ch.",
		{ format = "{1:output:PhysicalSpellProjectileDamageChance}%", 
			{ breakdown = "PhysicalSpellProjectileDamageChance" }, 
		},
		{ format = "{1:output:LightningSpellProjectileDamageChance}%",
			{ breakdown = "LightningSpellProjectileDamageChance" }, 
		},
		{ format = "{1:output:ColdSpellProjectileDamageChance}%",
			{ breakdown = "ColdSpellProjectileDamageChance" }, 
		},
		{ format = "{1:output:FireSpellProjectileDamageChance}%", 
			{ breakdown = "FireSpellProjectileDamageChance" }, 
		},
		{ format = "{1:output:ChaosSpellProjectileDamageChance}%",
			{ breakdown = "ChaosSpellProjectileDamageChance" }, 
		},
	},
}, }, { defaultCollapsed = false, label = "Effective \"Health\" Pool", data = {
	colWidth = 114,
	{ label = "Aegis", haveOutput = "AnyAegis",
		{ format = "{0:output:PhysicalAegis}", 
			{ breakdown = "PhysicalAegis" },
			{ modName = {"PhysicalAegisValue"} },			
		},
		{ format = "{0:output:LightningAegis}",
			{ breakdown = "LightningAegis" }, 
			{ modName = {"LightningAegisValue"} },	
		},
		{ format = "{0:output:ColdAegis}",
			{ breakdown = "ColdAegis" },
			{ modName = {"ColdAegisValue"} },	 
		},
		{ format = "{0:output:FireAegis}", 
			{ breakdown = "FireAegis" }, 
			{ modName = {"FireAegisValue"} },	
		},
		{ format = "{0:output:ChaosAegis}",
			{ breakdown = "ChaosAegis" }, 
			{ modName = {"ChaosAegisValue",} },	
		},
	},
	{ label = "ES Bypass%", haveOutput = "AnyBypass",
		{ format = "{0:output:PhysicalEnergyShieldBypass}", 
			{ breakdown = "PhysicalEnergyShieldBypass" },
			{ modName = {"PhysicalEnergyShieldBypass", "BlockedDamageDoesntBypassES", "UnblockedDamageDoesBypassES"} },			
		},
		{ format = "{0:output:LightningEnergyShieldBypass}",
			{ breakdown = "LightningEnergyShieldBypass" }, 
			{ modName = {"LightningEnergyShieldBypass", "BlockedDamageDoesntBypassES", "UnblockedDamageDoesBypassES"} },	
		},
		{ format = "{0:output:ColdEnergyShieldBypass}",
			{ breakdown = "ColdEnergyShieldBypass" },
			{ modName = {"ColdEnergyShieldBypass", "BlockedDamageDoesntBypassES", "UnblockedDamageDoesBypassES"} },	 
		},
		{ format = "{0:output:FireEnergyShieldBypass}", 
			{ breakdown = "FireEnergyShieldBypass" }, 
			{ modName = {"FireEnergyShieldBypass", "BlockedDamageDoesntBypassES", "UnblockedDamageDoesBypassES"} },	
		},
		{ format = "{0:output:ChaosEnergyShieldBypass}",
			{ breakdown = "ChaosEnergyShieldBypass" }, 
			{ modName = {"ChaosEnergyShieldBypass", "ChaosNotBypassEnergyShield", "BlockedDamageDoesntBypassES", "UnblockedDamageDoesBypassES"} },	
		},
	},
	{ label = "Guard", haveOutput = "AnyGuard",
		{ format = "{0:output:PhysicalGuardAbsorb}",
			{ breakdown = "PhysicalGuardAbsorb" },
			{ modName = { "GuardAbsorbRate", "PhysicalGuardAbsorbRate", "GuardAbsorbLimit", "PhysicalGuardAbsorbLimit" } },
		},
		{ format = "{0:output:LightningGuardAbsorb}",
			{ breakdown = "LightningGuardAbsorb" },
			{ modName = { "GuardAbsorbRate", "LightningGuardAbsorbRate", "GuardAbsorbLimit", "LightningGuardAbsorbLimit" } },
		},
		{ format = "{0:output:ColdGuardAbsorb}",
			{ breakdown = "ColdGuardAbsorb" },
			{ modName = { "GuardAbsorbRate", "ColdGuardAbsorbRate", "GuardAbsorbLimit", "ColdGuardAbsorbLimit" } },
		},
		{ format = "{0:output:FireGuardAbsorb}",
			{ breakdown = "FireGuardAbsorb" },
			{ modName = { "GuardAbsorbRate", "FireGuardAbsorbRate", "GuardAbsorbLimit", "FireGuardAbsorbLimit" } },
		},
		{ format = "{0:output:ChaosGuardAbsorb}",
			{ breakdown = "ChaosGuardAbsorb" },
			{ modName = { "GuardAbsorbRate", "ChaosGuardAbsorbRate", "GuardAbsorbLimit", "ChaosGuardAbsorbLimit" } },
		},
	},
	{ label = "Mind over Matter", haveOutput = "AnyMindOverMatter",
		{ format = "{0:output:PhysicalMindOverMatter}", 
			{ breakdown = "PhysicalMindOverMatter" },
			{ modName = "DamageTakenFromManaBeforeLife" },			
		},
		{ format = "{0:output:LightningMindOverMatter}",
			{ breakdown = "LightningMindOverMatter" }, 
			{ modName = {"DamageTakenFromManaBeforeLife", "LightningDamageTakenFromManaBeforeLife"} },	
		},
		{ format = "{0:output:ColdMindOverMatter}",
			{ breakdown = "ColdMindOverMatter" },
			{ modName = "DamageTakenFromManaBeforeLife" },	 
		},
		{ format = "{0:output:FireMindOverMatter}", 
			{ breakdown = "FireMindOverMatter" }, 
			{ modName = "DamageTakenFromManaBeforeLife" },	
		},
		{ format = "{0:output:ChaosMindOverMatter}",
			{ breakdown = "ChaosMindOverMatter" }, 
			{ modName = {"DamageTakenFromManaBeforeLife", "ChaosDamageTakenFromManaBeforeLife"} },	
		},
	},
	{ label = "Total Pool",
		{ format = "{0:output:PhysicalTotalPool}", 
			{ breakdown = "PhysicalTotalPool" },			
		},
		{ format = "{0:output:LightningTotalPool}",
			{ breakdown = "LightningTotalPool" }, 	
		},
		{ format = "{0:output:ColdTotalPool}",
			{ breakdown = "ColdTotalPool" },
		},
		{ format = "{0:output:FireTotalPool}", 
			{ breakdown = "FireTotalPool" }, 
		},
		{ format = "{0:output:ChaosTotalPool}",
			{ breakdown = "ChaosTotalPool" }, 
		},
	}, 
	{ label = "Maximum Hit Taken",
		{ format = "{0:output:PhysicalMaximumHitTaken}", 
			{ breakdown = "PhysicalMaximumHitTaken" }, 
		},
		{ format = "{0:output:LightningMaximumHitTaken}",
			{ breakdown = "LightningMaximumHitTaken" }, 
		},
		{ format = "{0:output:ColdMaximumHitTaken}",
			{ breakdown = "ColdMaximumHitTaken" }, 
		},
		{ format = "{0:output:FireMaximumHitTaken}", 
			{ breakdown = "FireMaximumHitTaken" }, 
		},
		{ format = "{0:output:ChaosMaximumHitTaken}",
			{ breakdown = "ChaosMaximumHitTaken" }, 
		},
	},
	{ label = "Effective DoT Pool",
		{ format = "{0:output:PhysicalDotEHP}", 
			{ breakdown = "PhysicalDotEHP" }, 
		},
		{ format = "{0:output:LightningDotEHP}",
			{ breakdown = "LightningDotEHP" }, 
		},
		{ format = "{0:output:ColdDotEHP}",
			{ breakdown = "ColdDotEHP" }, 
		},
		{ format = "{0:output:FireDotEHP}", 
			{ breakdown = "FireDotEHP" }, 
		},
		{ format = "{0:output:ChaosDotEHP}",
			{ breakdown = "ChaosDotEHP" }, 
		},
	},
	{ label = "Effective Hit Pool",
		{ format = "{0:output:PhysicalTotalEHP}", 
			{ breakdown = "PhysicalTotalEHP" }, 
		},
		{ format = "{0:output:LightningTotalEHP}",
			{ breakdown = "LightningTotalEHP" }, 
		},
		{ format = "{0:output:ColdTotalEHP}",
			{ breakdown = "ColdTotalEHP" }, 
		},
		{ format = "{0:output:FireTotalEHP}", 
			{ breakdown = "FireTotalEHP" }, 
		},
		{ format = "{0:output:ChaosTotalEHP}",
			{ breakdown = "ChaosTotalEHP" }, 
		},
	}
} }, { defaultCollapsed = false, label = "Degen", data = {
	colWidth = 114,
	{ label = "Degens", haveOutput = "TotalDegen",
		{ format = "{0:output:PhysicalDegen}", 
			{ breakdown = "PhysicalDegen" }, 
			{ modName = "PhysicalDegen", }
		},
		{ format = "{0:output:LightningDegen}",
			{ breakdown = "LightningDegen" }, 
			{ modName = "LightningDegen", }
		},
		{ format = "{0:output:ColdDegen}",
			{ breakdown = "ColdDegen" }, 
			{ modName = "ColdDegen", }
		},
		{ format = "{0:output:FireDegen}", 
			{ breakdown = "FireDegen" }, 
			{ modName = "FireDegen", }
		},
		{ format = "{0:output:ChaosDegen}",
			{ breakdown = "ChaosDegen" }, 
			{ modName = "ChaosDegen", }
		},
	},
	{ label = "Total Degen", haveOutput = "TotalDegen", { format = "{1:output:TotalDegen}", 
		{ breakdown = "TotalDegen" },
		{ label = "Sources", modName = { "PhysicalDegen", "FireDegen", "ColdDegen", "LightningDegen", "ChaosDegen" }, modType = "BASE" },
	}, },
	{ label = "Total Net Regen", haveOutput = "TotalNetRegen", { format = "{1:output:TotalNetRegen}", 
		{ breakdown = "TotalNetRegen" },
	}, },
	{ label = "Net Life Regen", haveOutput = "NetLifeRegen", { format = "{1:output:NetLifeRegen}", { breakdown = "NetLifeRegen" }, }, },
	{ label = "Net Mana Regen", haveOutput = "NetManaRegen", { format = "{1:output:NetManaRegen}", { breakdown = "NetManaRegen" }, }, },
	{ label = "Net ES Regen", haveOutput = "NetEnergyShieldRegen", { format = "{1:output:NetEnergyShieldRegen}", { breakdown = "NetEnergyShieldRegen" }, }, },
} }
} },
}
