/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest;

import junit.framework.TestCase;
import org.hamcrest.BaseDescription;

public class BaseDescriptionTest
extends TestCase {
    private final StringBuilder result = new StringBuilder();
    private final BaseDescription baseDescription = new BaseDescription(){

        protected void append(char c) {
            BaseDescriptionTest.this.result.append(c);
        }
    };

    public void testDescribesAppendedNullValue() {
        this.baseDescription.appendValue(null);
        BaseDescriptionTest.assertEquals((String)"null", (String)this.result.toString());
    }

    public void testQuotesAppendedStringValue() {
        this.baseDescription.appendValue((Object)"foo");
        BaseDescriptionTest.assertEquals((String)"\"foo\"", (String)this.result.toString());
    }

    public void testQuotesAppendedCharacterValue() {
        this.baseDescription.appendValue((Object)Character.valueOf('f'));
        BaseDescriptionTest.assertEquals((String)"\"f\"", (String)this.result.toString());
    }

    public void testBracketsAppendedShortValue() {
        this.baseDescription.appendValue((Object)Short.valueOf("2"));
        BaseDescriptionTest.assertEquals((String)"<2s>", (String)this.result.toString());
    }

    public void testBracketsAppendedLongValue() {
        this.baseDescription.appendValue((Object)Long.valueOf("2"));
        BaseDescriptionTest.assertEquals((String)"<2L>", (String)this.result.toString());
    }

    public void testBracketsAppendedFloatValue() {
        this.baseDescription.appendValue((Object)Float.valueOf("1.2"));
        BaseDescriptionTest.assertEquals((String)"<1.2F>", (String)this.result.toString());
    }

    public void testDescribesAppendedArrayValue() {
        this.baseDescription.appendValue((Object)new String[]{"2", "3"});
        BaseDescriptionTest.assertEquals((String)"[\"2\", \"3\"]", (String)this.result.toString());
    }

    public void testBracketsAppendedObjectValue() {
        Object value = new Object();
        this.baseDescription.appendValue(value);
        BaseDescriptionTest.assertEquals((String)("<" + value.toString() + ">"), (String)this.result.toString());
    }

    public void testSafelyDescribesAppendedValueOfObjectWhoseToStringThrowsAnException() {
        Object value = new Object(){

            public String toString() {
                throw new UnsupportedOperationException();
            }
        };
        String expected = value.getClass().getName() + "@" + Integer.toHexString(value.hashCode());
        this.baseDescription.appendValue(value);
        BaseDescriptionTest.assertEquals((String)("<" + expected + ">"), (String)this.result.toString());
    }
}

