/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest;

import junit.framework.TestCase;
import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.core.IsEqual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureMatcherTest
extends TestCase {
    private final FeatureMatcher<Thingy, String> resultMatcher = FeatureMatcherTest.resultMatcher();

    public void testMatchesPartOfAnObject() {
        AbstractMatcherTest.assertMatches("feature", this.resultMatcher, new Thingy("bar"));
        AbstractMatcherTest.assertDescription("Thingy with result \"bar\"", this.resultMatcher);
    }

    public void testMismatchesPartOfAnObject() {
        AbstractMatcherTest.assertMismatchDescription("result mismatch-description", this.resultMatcher, new Thingy("foo"));
    }

    public void testDoesNotThrowNullPointerException() {
        AbstractMatcherTest.assertMismatchDescription("was null", this.resultMatcher, null);
    }

    public void testDoesNotThrowClassCastException() {
        this.resultMatcher.matches((Object)new ShouldNotMatch());
        StringDescription mismatchDescription = new StringDescription();
        this.resultMatcher.describeMismatch((Object)new ShouldNotMatch(), (Description)mismatchDescription);
        FeatureMatcherTest.assertEquals((String)"was <ShouldNotMatch>", (String)mismatchDescription.toString());
    }

    private static FeatureMatcher<Thingy, String> resultMatcher() {
        return new FeatureMatcher<Thingy, String>((Matcher)new Match("bar"), "Thingy with result", "result"){

            public String featureValueOf(Thingy actual) {
                return actual.getResult();
            }
        };
    }

    public static class ShouldNotMatch {
        public String toString() {
            return "ShouldNotMatch";
        }
    }

    public static class Thingy {
        private final String result;

        public Thingy(String result) {
            this.result = result;
        }

        public String getResult() {
            return this.result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Match
    extends IsEqual<String> {
        public Match(String equalArg) {
            super((Object)equalArg);
        }

        public void describeMismatch(Object item, Description description) {
            description.appendText("mismatch-description");
        }
    }
}

