/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest;

import junit.framework.TestCase;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;

public class MatcherAssertTest
extends TestCase {
    public void testIncludesDescriptionOfTestedValueInErrorMessage() {
        String expected = "expected";
        String actual = "actual";
        String expectedMessage = "identifier\nExpected: \"expected\"\n     but: was \"actual\"";
        try {
            MatcherAssert.assertThat((String)"identifier", (Object)actual, (Matcher)IsEqual.equalTo((Object)expected));
        }
        catch (AssertionError e) {
            MatcherAssertTest.assertTrue((boolean)((Throwable)((Object)e)).getMessage().startsWith(expectedMessage));
            return;
        }
        MatcherAssertTest.fail((String)"should have failed");
    }

    public void testDescriptionCanBeElided() {
        String expected = "expected";
        String actual = "actual";
        String expectedMessage = "\nExpected: \"expected\"\n     but: was \"actual\"";
        try {
            MatcherAssert.assertThat((Object)actual, (Matcher)IsEqual.equalTo((Object)expected));
        }
        catch (AssertionError e) {
            MatcherAssertTest.assertTrue((boolean)((Throwable)((Object)e)).getMessage().startsWith(expectedMessage));
            return;
        }
        MatcherAssertTest.fail((String)"should have failed");
    }

    public void testCanTestBooleanDirectly() {
        MatcherAssert.assertThat((String)"success reason message", (boolean)true);
        try {
            MatcherAssert.assertThat((String)"failing reason message", (boolean)false);
        }
        catch (AssertionError e) {
            MatcherAssertTest.assertEquals((String)"failing reason message", (String)((Throwable)((Object)e)).getMessage());
            return;
        }
        MatcherAssertTest.fail((String)"should have failed");
    }

    public void testIncludesMismatchDescription() {
        BaseMatcher<String> matcherWithCustomMismatchDescription = new BaseMatcher<String>(){

            public boolean matches(Object item) {
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("Something cool");
            }

            public void describeMismatch(Object item, Description mismatchDescription) {
                mismatchDescription.appendText("Not cool");
            }
        };
        String expectedMessage = "\nExpected: Something cool\n     but: Not cool";
        try {
            MatcherAssert.assertThat((Object)"Value", (Matcher)matcherWithCustomMismatchDescription);
            MatcherAssertTest.fail((String)"should have failed");
        }
        catch (AssertionError e) {
            MatcherAssertTest.assertEquals((String)expectedMessage, (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testCanAssertSubtypes() {
        Integer aSub;
        Integer aSuper = aSub = new Integer(1);
        MatcherAssert.assertThat((Object)aSub, (Matcher)IsEqual.equalTo((Object)aSuper));
    }
}

