/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsArrayContainingInAnyOrder;
import org.hamcrest.core.IsEqual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsArrayContainingInAnyOrderTest
extends AbstractMatcherTest {
    @Override
    protected Matcher<?> createMatcher() {
        return IsArrayContainingInAnyOrder.arrayContainingInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)1), IsEqual.equalTo((Object)2)});
    }

    public void testHasAReadableDescription() {
        IsArrayContainingInAnyOrderTest.assertDescription("[<1>, <2>] in any order", IsArrayContainingInAnyOrder.arrayContainingInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)1), IsEqual.equalTo((Object)2)}));
        IsArrayContainingInAnyOrderTest.assertDescription("[<1>, <2>] in any order", IsArrayContainingInAnyOrder.arrayContainingInAnyOrder((Object[])new Integer[]{1, 2}));
    }

    public void testMatchesItemsInAnyOrder() {
        IsArrayContainingInAnyOrderTest.assertMatches("in order", IsArrayContainingInAnyOrder.arrayContainingInAnyOrder((Object[])new Integer[]{1, 2, 3}), new Integer[]{1, 2, 3});
        IsArrayContainingInAnyOrderTest.assertMatches("out of order", IsArrayContainingInAnyOrder.arrayContainingInAnyOrder((Object[])new Integer[]{1, 2, 3}), new Integer[]{3, 2, 1});
        IsArrayContainingInAnyOrderTest.assertMatches("single", IsArrayContainingInAnyOrder.arrayContainingInAnyOrder((Object[])new Integer[]{1}), new Integer[]{1});
    }

    public void testAppliesMatchersInAnyOrder() {
        IsArrayContainingInAnyOrderTest.assertMatches("in order", IsArrayContainingInAnyOrder.arrayContainingInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)1), IsEqual.equalTo((Object)2), IsEqual.equalTo((Object)3)}), new Integer[]{1, 2, 3});
        IsArrayContainingInAnyOrderTest.assertMatches("out of order", IsArrayContainingInAnyOrder.arrayContainingInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)1), IsEqual.equalTo((Object)2), IsEqual.equalTo((Object)3)}), new Integer[]{3, 2, 1});
        IsArrayContainingInAnyOrderTest.assertMatches("single", IsArrayContainingInAnyOrder.arrayContainingInAnyOrder((Matcher[])new Matcher[]{IsEqual.equalTo((Object)1)}), new Integer[]{1});
    }

    public void testMismatchesItemsInAnyOrder() {
        Matcher matcher = IsArrayContainingInAnyOrder.arrayContainingInAnyOrder((Object[])new Integer[]{1, 2, 3});
        IsArrayContainingInAnyOrderTest.assertMismatchDescription("was null", matcher, null);
        IsArrayContainingInAnyOrderTest.assertMismatchDescription("No item matches: <1>, <2>, <3> in []", matcher, new Integer[0]);
        IsArrayContainingInAnyOrderTest.assertMismatchDescription("No item matches: <2>, <3> in [<1>]", matcher, new Integer[]{1});
        IsArrayContainingInAnyOrderTest.assertMismatchDescription("Not matched: <4>", matcher, new Integer[]{4, 3, 2, 1});
    }
}

