/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsArrayWithSize;
import org.hamcrest.core.IsEqual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsArrayWithSizeTest
extends AbstractMatcherTest {
    @Override
    protected Matcher<?> createMatcher() {
        return IsArrayWithSize.arrayWithSize((Matcher)IsEqual.equalTo((Object)2));
    }

    public void testMatchesWhenSizeIsCorrect() {
        IsArrayWithSizeTest.assertMatches("correct size", IsArrayWithSize.arrayWithSize((Matcher)IsEqual.equalTo((Object)3)), new Object[]{1, 2, 3});
        IsArrayWithSizeTest.assertDoesNotMatch("incorrect size", IsArrayWithSize.arrayWithSize((Matcher)IsEqual.equalTo((Object)2)), new Object[]{1, 2, 3});
    }

    public void testProvidesConvenientShortcutForArrayWithSizeEqualTo() {
        IsArrayWithSizeTest.assertMatches("correct size", IsArrayWithSize.arrayWithSize((int)3), new Object[]{1, 2, 3});
        IsArrayWithSizeTest.assertDoesNotMatch("incorrect size", IsArrayWithSize.arrayWithSize((int)2), new Object[]{1, 2, 3});
    }

    public void testEmptyArray() {
        IsArrayWithSizeTest.assertMatches("correct size", IsArrayWithSize.emptyArray(), new Object[0]);
        IsArrayWithSizeTest.assertDoesNotMatch("incorrect size", IsArrayWithSize.emptyArray(), new Object[]{1});
    }

    public void testHasAReadableDescription() {
        IsArrayWithSizeTest.assertDescription("an array with size <3>", IsArrayWithSize.arrayWithSize((Matcher)IsEqual.equalTo((Object)3)));
        IsArrayWithSizeTest.assertDescription("an empty array", IsArrayWithSize.emptyArray());
    }
}

