/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.collection.IsIterableContainingInOrderTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsIterableContainingInAnyOrderTest
extends AbstractMatcherTest {
    @Override
    protected Matcher<?> createMatcher() {
        return IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Integer[]{1, 2});
    }

    public void testMatchesSingleItemIterable() {
        IsIterableContainingInAnyOrderTest.assertMatches("single item", IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Integer[]{1}), Arrays.asList(1));
    }

    public void testDoesNotMatchEmpty() {
        IsIterableContainingInAnyOrderTest.assertMismatchDescription("No item matches: <1>, <2> in []", IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Integer[]{1, 2}), Collections.emptyList());
    }

    public void testMatchesIterableOutOfOrder() {
        IsIterableContainingInAnyOrderTest.assertMatches("Out of order", IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Integer[]{1, 2}), Arrays.asList(2, 1));
    }

    public void testMatchesIterableInOrder() {
        IsIterableContainingInAnyOrderTest.assertMatches("In order", IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Integer[]{1, 2}), Arrays.asList(1, 2));
    }

    public void testDoesNotMatchIfOneOfMultipleElementsMismatches() {
        IsIterableContainingInAnyOrderTest.assertMismatchDescription("Not matched: <4>", IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Integer[]{1, 2, 3}), Arrays.asList(1, 2, 4));
    }

    public void testDoesNotMatchIfThereAreMoreElementsThanMatchers() {
        Matcher helpTheCompilerOut = IsIterableContainingInAnyOrder.containsInAnyOrder((Matcher[])new Matcher[]{IsIterableContainingInOrderTest.value(1), IsIterableContainingInOrderTest.value(3)});
        IsIterableContainingInAnyOrderTest.assertMismatchDescription("Not matched: <WithValue 2>", helpTheCompilerOut, Arrays.asList(IsIterableContainingInOrderTest.make(1), IsIterableContainingInOrderTest.make(2), IsIterableContainingInOrderTest.make(3)));
    }

    public void testDoesNotMatchIfThereAreMoreMatchersThanElements() {
        IsIterableContainingInAnyOrderTest.assertMismatchDescription("No item matches: <4> in [<1>, <2>, <3>]", IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Integer[]{1, 2, 3, 4}), Arrays.asList(1, 2, 3));
    }

    public void testHasAReadableDescription() {
        IsIterableContainingInAnyOrderTest.assertDescription("iterable over [<1>, <2>] in any order", IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Integer[]{1, 2}));
    }

    public void testDoesNotMatchIfSingleItemMismatches() throws Exception {
        IsIterableContainingInAnyOrderTest.assertMismatchDescription("Not matched: <WithValue 3>", IsIterableContainingInAnyOrder.containsInAnyOrder(IsIterableContainingInOrderTest.value(4)), Arrays.asList(IsIterableContainingInOrderTest.make(3)));
    }
}

