/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import java.util.HashMap;
import java.util.TreeMap;
import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsMapContaining;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsMapContainingKeyTest
extends AbstractMatcherTest {
    @Override
    protected Matcher<?> createMatcher() {
        return IsMapContaining.hasKey((Object)"foo");
    }

    public void testMatchesSingletonMapContainingKey() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("a", 1);
        IsMapContainingKeyTest.assertMatches("Matches single key", IsMapContaining.hasKey((Object)"a"), map);
    }

    public void testMatchesMapContainingKey() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("a", 1);
        map.put("b", 2);
        map.put("c", 3);
        IsMapContainingKeyTest.assertMatches("Matches a", IsMapContaining.hasKey((Object)"a"), map);
        IsMapContainingKeyTest.assertMatches("Matches c", IsMapContaining.hasKey((Object)"c"), map);
    }

    public void testMatchesMapContainingKeyWithIntegerKeys() throws Exception {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "A");
        map.put(2, "B");
        MatcherAssert.assertThat(map, (Matcher)IsMapContaining.hasKey((Object)1));
    }

    public void testMatchesMapContainingKeyWithNumberKeys() throws Exception {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "A");
        map.put(2, "B");
        MatcherAssert.assertThat(map, (Matcher)IsMapContaining.hasKey((Object)1));
    }

    public void testHasReadableDescription() {
        IsMapContainingKeyTest.assertDescription("map containing [\"a\"->ANYTHING]", IsMapContaining.hasKey((Object)"a"));
    }

    public void testDoesNotMatchEmptyMap() {
        IsMapContainingKeyTest.assertMismatchDescription("map was []", IsMapContaining.hasKey((Object)"Foo"), new HashMap());
    }

    public void testDoesNotMatchMapMissingKey() {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        map.put("a", 1);
        map.put("b", 2);
        map.put("c", 3);
        IsMapContainingKeyTest.assertMismatchDescription("map was [<a=1>, <b=2>, <c=3>]", IsMapContaining.hasKey((Object)"d"), map);
    }
}

