/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.hamcrest.generator.FactoryMethod;
import org.hamcrest.generator.FactoryWriter;
import org.hamcrest.generator.HamcrestFactoryWriter;

public class HamcrestFactoryWriterTest
extends TestCase {
    private FactoryWriter factoryWriter;
    private StringWriter output = new StringWriter();

    protected void setUp() throws Exception {
        super.setUp();
        this.factoryWriter = new HamcrestFactoryWriter(null, null, (Writer)this.output);
    }

    public void testWritesMethodDelegationMethod() throws IOException {
        FactoryMethod method = new FactoryMethod("com.example.MyMatcher", "anyObject", "matcher.ReturnType");
        this.factoryWriter.writeMethod(method.getName(), method);
        HamcrestFactoryWriterTest.assertEquals((String)"  public static matcher.ReturnType anyObject() {\n    return com.example.MyMatcher.anyObject();\n  }\n\n", (String)this.output.toString());
    }

    public void testWritesCompleteJavaSource() throws IOException {
        this.factoryWriter = new HamcrestFactoryWriter("com.some.package", "SomeClass", (Writer)this.output);
        this.factoryWriter.writeHeader();
        this.factoryWriter.writeMethod("method1", new FactoryMethod("com.example.MyMatcher", "method1", "matcher.ReturnType"));
        this.factoryWriter.writeMethod("method2", new FactoryMethod("com.example.MyMatcher", "method2", "matcher.ReturnType"));
        this.factoryWriter.writeFooter();
        HamcrestFactoryWriterTest.assertEquals((String)"// Generated source.\npackage com.some.package;\n\npublic class SomeClass {\n\n  public static matcher.ReturnType method1() {\n    return com.example.MyMatcher.method1();\n  }\n\n  public static matcher.ReturnType method2() {\n    return com.example.MyMatcher.method2();\n  }\n\n}\n", (String)this.output.toString());
    }

    public void testWritesGenerifiedMatcherType() throws IOException {
        FactoryMethod method = new FactoryMethod("com.example.MyMatcher", "anyString", "matcher.ReturnType");
        method.setGenerifiedType("String");
        this.factoryWriter.writeMethod(method.getName(), method);
        HamcrestFactoryWriterTest.assertEquals((String)"  public static matcher.ReturnType<String> anyString() {\n    return com.example.MyMatcher.anyString();\n  }\n\n", (String)this.output.toString());
    }

    public void testWritesAdvancedGenerifiedMatcherType() throws IOException {
        FactoryMethod method = new FactoryMethod("com.example.MyMatcher", "weirdThing", "matcher.ReturnType");
        method.setGenerifiedType("java.util.Map<com.Foo<Cheese>,?>");
        this.factoryWriter.writeMethod(method.getName(), method);
        HamcrestFactoryWriterTest.assertEquals((String)"  public static matcher.ReturnType<java.util.Map<com.Foo<Cheese>,?>> weirdThing() {\n    return com.example.MyMatcher.weirdThing();\n  }\n\n", (String)this.output.toString());
    }

    public void testWritesParameters() throws IOException {
        FactoryMethod method = new FactoryMethod("com.example.MyMatcher", "between", "matcher.ReturnType");
        method.addParameter("int[]", "lower");
        method.addParameter("com.blah.Cheesable<Long>...", "upper");
        this.factoryWriter.writeMethod(method.getName(), method);
        HamcrestFactoryWriterTest.assertEquals((String)"  public static matcher.ReturnType between(int[] lower, com.blah.Cheesable<Long>... upper) {\n    return com.example.MyMatcher.between(lower, upper);\n  }\n\n", (String)this.output.toString());
    }

    public void testWritesExceptions() throws IOException {
        FactoryMethod method = new FactoryMethod("com.example.MyMatcher", "tricky", "matcher.ReturnType");
        method.addException("java.io.IOException");
        method.addException("com.foo.CheeselessException");
        this.factoryWriter.writeMethod(method.getName(), method);
        HamcrestFactoryWriterTest.assertEquals((String)"  public static matcher.ReturnType tricky() throws java.io.IOException, com.foo.CheeselessException {\n    return com.example.MyMatcher.tricky();\n  }\n\n", (String)this.output.toString());
    }

    public void testWritesGenericTypeParameters() throws IOException {
        FactoryMethod method = new FactoryMethod("com.example.MyMatcher", "tricky", "matcher.ReturnType");
        method.addGenericTypeParameter("T");
        method.addGenericTypeParameter("V extends String & Cheese");
        method.addParameter("T", "t");
        method.addParameter("List<V>", "v");
        this.factoryWriter.writeMethod(method.getName(), method);
        HamcrestFactoryWriterTest.assertEquals((String)"  public static <T, V extends String & Cheese> matcher.ReturnType tricky(T t, List<V> v) {\n    return com.example.MyMatcher.<T,V>tricky(t, v);\n  }\n\n", (String)this.output.toString());
    }

    public void testWritesJavaDoc() throws IOException {
        FactoryMethod method = new FactoryMethod("com.example.MyMatcher", "needsDoc", "matcher.ReturnType");
        method.setJavaDoc("This is a complicated method.\nIt needs docs.\n\n@see MoreStuff");
        this.factoryWriter.writeMethod(method.getName(), method);
        HamcrestFactoryWriterTest.assertEquals((String)"  /**\n   * This is a complicated method.\n   * It needs docs.\n   * \n   * @see MoreStuff\n   */\n  public static matcher.ReturnType needsDoc() {\n    return com.example.MyMatcher.needsDoc();\n  }\n\n", (String)this.output.toString());
    }

    public void testWritesMethodWithNameOverriden() throws IOException {
        FactoryMethod method = new FactoryMethod("com.example.MyMatcher", "eq", "matcher.ReturnType");
        this.factoryWriter.writeMethod("anotherName", method);
        HamcrestFactoryWriterTest.assertEquals((String)"  public static matcher.ReturnType anotherName() {\n    return com.example.MyMatcher.eq();\n  }\n\n", (String)this.output.toString());
    }
}

