/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.hamcrest.generator.FactoryMethod;
import org.hamcrest.generator.QDox;
import org.hamcrest.generator.QDoxFactoryReader;

public class QDoxFactoryReaderTest
extends TestCase {
    public void testExtractsOriginalParameterNamesFromSource() {
        FactoryMethod method = new FactoryMethod("org.SomeClass", "someMethod", "unusedReturnType");
        method.addParameter("java.lang.String", "badParamName");
        String input = "package org;\nclass SomeClass {\n  Matcher someMethod(String realParamName) { ... } \n}\n";
        FactoryMethod factoryMethod = QDoxFactoryReaderTest.wrapUsingQDoxedSource(method, "org.SomeClass", input);
        QDoxFactoryReaderTest.assertEquals((String)"java.lang.String", (String)((FactoryMethod.Parameter)factoryMethod.getParameters().get(0)).getType());
        QDoxFactoryReaderTest.assertEquals((String)"realParamName", (String)((FactoryMethod.Parameter)factoryMethod.getParameters().get(0)).getName());
    }

    public void testExtractsOriginalGenericParameterNamesFromSource() {
        FactoryMethod method = new FactoryMethod("org.SomeClass", "someMethod", "unusedReturnType");
        method.addParameter("java.util.Collection<java.lang.String>", "badParamName");
        String input = "package org;\nclass SomeClass {\n  Matcher someMethod(java.util.Collection<String> realParamName) { ... } \n}\n";
        FactoryMethod factoryMethod = QDoxFactoryReaderTest.wrapUsingQDoxedSource(method, "org.SomeClass", input);
        QDoxFactoryReaderTest.assertEquals((String)"java.util.Collection<java.lang.String>", (String)((FactoryMethod.Parameter)factoryMethod.getParameters().get(0)).getType());
        QDoxFactoryReaderTest.assertEquals((String)"realParamName", (String)((FactoryMethod.Parameter)factoryMethod.getParameters().get(0)).getName());
    }

    public void testExtractsOriginalVarArgParameterNamesFromSource() {
        FactoryMethod method = new FactoryMethod("org.SomeClass", "someMethod", "unusedReturnType");
        method.addParameter("java.lang.String...", "badParamName");
        String input = "package org;\nclass SomeClass {\n  Matcher someMethod(java.lang.String... realParamName) { ... } \n}\n";
        FactoryMethod factoryMethod = QDoxFactoryReaderTest.wrapUsingQDoxedSource(method, "org.SomeClass", input);
        QDoxFactoryReaderTest.assertEquals((String)"java.lang.String...", (String)((FactoryMethod.Parameter)factoryMethod.getParameters().get(0)).getType());
        QDoxFactoryReaderTest.assertEquals((String)"realParamName", (String)((FactoryMethod.Parameter)factoryMethod.getParameters().get(0)).getName());
    }

    public void testExtractsOriginalJavaDocFromSource() {
        FactoryMethod method = new FactoryMethod("org.SomeClass", "someMethod", "unusedReturnType");
        String input = "package org;\nclass SomeClass {\n  /**\n   * This class does something.\n   *\n   * @return stuff.\n   */\n  Matcher someMethod() { ... } \n}\n";
        FactoryMethod factoryMethod = QDoxFactoryReaderTest.wrapUsingQDoxedSource(method, "org.SomeClass", input);
        QDoxFactoryReaderTest.assertEquals((String)"This class does something.\n\n@return stuff.\n", (String)factoryMethod.getJavaDoc());
    }

    private static FactoryMethod wrapUsingQDoxedSource(FactoryMethod originalMethod, String className, String input) {
        ArrayList<FactoryMethod> originalMethods = new ArrayList<FactoryMethod>();
        originalMethods.add(originalMethod);
        QDox qdox = new QDox();
        qdox.addSource((Reader)new StringReader(input));
        QDoxFactoryReader qDoxFactoryReader = new QDoxFactoryReader(originalMethods, qdox, className);
        return QDoxFactoryReaderTest.getFirstFactoryMethod(qDoxFactoryReader);
    }

    private static FactoryMethod getFirstFactoryMethod(QDoxFactoryReader qDoxFactoryReader) {
        Iterator iterator = qDoxFactoryReader.iterator();
        iterator.hasNext();
        return (FactoryMethod)iterator.next();
    }
}

