/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.number;

import java.math.BigDecimal;
import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNot;
import org.hamcrest.number.OrderingComparison;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderingComparisonTest
extends AbstractMatcherTest {
    protected Matcher<Integer> createMatcher() {
        return OrderingComparison.greaterThan((Comparable)Integer.valueOf(1));
    }

    public void testDescription() {
        OrderingComparisonTest.assertDescription("a value greater than <1>", OrderingComparison.greaterThan((Comparable)Integer.valueOf(1)));
        OrderingComparisonTest.assertDescription("a value equal to or greater than <1>", OrderingComparison.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        OrderingComparisonTest.assertDescription("a value equal to <1>", OrderingComparison.comparesEqualTo((Comparable)Integer.valueOf(1)));
        OrderingComparisonTest.assertDescription("a value less than or equal to <1>", OrderingComparison.lessThanOrEqualTo((Comparable)Integer.valueOf(1)));
        OrderingComparisonTest.assertDescription("a value less than <1>", OrderingComparison.lessThan((Comparable)Integer.valueOf(1)));
    }

    public void testMismatchDescriptions() {
        OrderingComparisonTest.assertMismatchDescription("<0> was less than <1>", OrderingComparison.greaterThan((Comparable)Integer.valueOf(1)), 0);
        OrderingComparisonTest.assertMismatchDescription("<1> was equal to <1>", OrderingComparison.greaterThan((Comparable)Integer.valueOf(1)), 1);
        OrderingComparisonTest.assertMismatchDescription("<1> was greater than <0>", OrderingComparison.lessThan((Comparable)Integer.valueOf(0)), 1);
        OrderingComparisonTest.assertMismatchDescription("<2> was equal to <2>", OrderingComparison.lessThan((Comparable)Integer.valueOf(2)), 2);
    }

    public void testComparesObjectsForGreaterThan() {
        MatcherAssert.assertThat((Object)2, (Matcher)OrderingComparison.greaterThan((Comparable)Integer.valueOf(1)));
        MatcherAssert.assertThat((Object)0, (Matcher)IsNot.not((Matcher)OrderingComparison.greaterThan((Comparable)Integer.valueOf(1))));
    }

    public void testComparesObjectsForLessThan() {
        MatcherAssert.assertThat((Object)2, (Matcher)OrderingComparison.lessThan((Comparable)Integer.valueOf(3)));
        MatcherAssert.assertThat((Object)0, (Matcher)OrderingComparison.lessThan((Comparable)Integer.valueOf(1)));
    }

    public void testComparesObjectsForEquality() {
        MatcherAssert.assertThat((Object)3, (Matcher)OrderingComparison.comparesEqualTo((Comparable)Integer.valueOf(3)));
        MatcherAssert.assertThat((Object)"aa", (Matcher)OrderingComparison.comparesEqualTo((Comparable)((Object)"aa")));
    }

    public void testAllowsForInclusiveComparisons() {
        MatcherAssert.assertThat((String)"less", (Object)1, (Matcher)OrderingComparison.lessThanOrEqualTo((Comparable)Integer.valueOf(1)));
        MatcherAssert.assertThat((String)"greater", (Object)1, (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
    }

    public void testSupportsDifferentTypesOfComparableObjects() {
        MatcherAssert.assertThat((Object)1.1, (Matcher)OrderingComparison.greaterThan((Comparable)Double.valueOf(1.0)));
        MatcherAssert.assertThat((Object)"cc", (Matcher)OrderingComparison.greaterThan((Comparable)((Object)"bb")));
    }

    public void testComparesBigDecimalsWithDifferentScalesCorrectlyForIssue20() {
        MatcherAssert.assertThat((Object)new BigDecimal("10.0"), (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)new BigDecimal("10")));
        MatcherAssert.assertThat((Object)new BigDecimal(10), (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)new BigDecimal("10.0")));
        MatcherAssert.assertThat((Object)new BigDecimal("2"), (Matcher)OrderingComparison.comparesEqualTo((Comparable)new BigDecimal("2.000")));
    }

    public void testComparesCustomTypesWhoseCompareToReturnsValuesGreaterThatOne() {
        MatcherAssert.assertThat((Object)new CustomInt(5), (Matcher)OrderingComparison.lessThan((Comparable)new CustomInt(10)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CustomInt
    implements Comparable<CustomInt> {
        private final int value;

        public CustomInt(int value) {
            this.value = value;
        }

        @Override
        public int compareTo(CustomInt other) {
            return this.value - other.value;
        }
    }
}

