/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.text;

import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNot;
import org.hamcrest.text.IsEmptyString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsEmptyStringTest
extends AbstractMatcherTest {
    @Override
    protected Matcher<?> createMatcher() {
        return IsEmptyString.isEmptyOrNullString();
    }

    public void testEmptyOrNullIsNull() {
        MatcherAssert.assertThat(null, (Matcher)IsEmptyString.isEmptyOrNullString());
    }

    public void testEmptyIsNotNull() {
        MatcherAssert.assertThat(null, (Matcher)IsNot.not((Matcher)IsEmptyString.isEmptyString()));
    }

    public void testMatchesEmptyString() {
        IsEmptyStringTest.assertMatches("empty string", IsEmptyString.isEmptyString(), "");
        IsEmptyStringTest.assertMatches("empty string", IsEmptyString.isEmptyOrNullString(), "");
    }

    public void testDoesNotMatchNonEmptyString() {
        IsEmptyStringTest.assertDoesNotMatch("non empty string", IsEmptyString.isEmptyString(), "a");
    }

    public void testHasAReadableDescription() {
        IsEmptyStringTest.assertDescription("an empty string", IsEmptyString.isEmptyString());
        IsEmptyStringTest.assertDescription("(null or an empty string)", IsEmptyString.isEmptyOrNullString());
    }
}

