/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.text;

import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNot;
import org.hamcrest.text.IsEqualIgnoringWhiteSpace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsEqualIgnoringWhiteSpaceTest
extends AbstractMatcherTest {
    private final Matcher<String> matcher = IsEqualIgnoringWhiteSpace.equalToIgnoringWhiteSpace((String)"Hello World   how\n are we? ");

    @Override
    protected Matcher<?> createMatcher() {
        return this.matcher;
    }

    public void testPassesIfWordsAreSameButWhitespaceDiffers() {
        MatcherAssert.assertThat((Object)"Hello World how are we?", this.matcher);
        MatcherAssert.assertThat((Object)"   Hello World   how are \n\n\twe?", this.matcher);
    }

    public void testFailsIfTextOtherThanWhitespaceDiffers() {
        MatcherAssert.assertThat((Object)"Hello PLANET how are we?", (Matcher)IsNot.not(this.matcher));
        MatcherAssert.assertThat((Object)"Hello World how are we", (Matcher)IsNot.not(this.matcher));
    }

    public void testFailsIfWhitespaceIsAddedOrRemovedInMidWord() {
        MatcherAssert.assertThat((Object)"HelloWorld how are we?", (Matcher)IsNot.not(this.matcher));
        MatcherAssert.assertThat((Object)"Hello Wo rld how are we?", (Matcher)IsNot.not(this.matcher));
    }

    public void testFailsIfMatchingAgainstNull() {
        MatcherAssert.assertThat(null, (Matcher)IsNot.not(this.matcher));
    }

    public void testRequiresNonNullStringToBeConstructed() {
        try {
            new IsEqualIgnoringWhiteSpace(null);
            IsEqualIgnoringWhiteSpaceTest.fail((String)"Expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testHasAReadableDescription() {
        IsEqualIgnoringWhiteSpaceTest.assertDescription("equalToIgnoringWhiteSpace(\"Hello World   how\\n are we? \")", this.matcher);
    }
}

