/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.text;

import java.util.Arrays;
import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.text.StringContainsInOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringContainsInOrderTest
extends AbstractMatcherTest {
    StringContainsInOrder m = new StringContainsInOrder(Arrays.asList("a", "b", "c"));

    @Override
    protected Matcher<?> createMatcher() {
        return this.m;
    }

    public void testMatchesOnlyIfStringContainsGivenSubstringsInTheSameOrder() {
        StringContainsInOrderTest.assertMatches("substrings in order", this.m, "abc");
        StringContainsInOrderTest.assertMatches("substrings separated", this.m, "1a2b3c4");
        StringContainsInOrderTest.assertDoesNotMatch("substrings out of order", this.m, "cab");
        StringContainsInOrderTest.assertDoesNotMatch("no substrings in string", this.m, "xyz");
        StringContainsInOrderTest.assertDoesNotMatch("substring missing", this.m, "ac");
        StringContainsInOrderTest.assertDoesNotMatch("empty string", this.m, "");
    }

    public void testHasAReadableDescription() {
        StringContainsInOrderTest.assertDescription("a string containing \"a\", \"b\", \"c\" in order", this.m);
    }
}

