/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.UnsupportedEncodingException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.DateTimeValue;
import org.apache.derby.client.am.SqlException;

public class DateTime {
    private static final int dateRepresentationLength = 10;
    private static final int timeRepresentationLength = 8;
    private static final int timestampRepresentationLength = 26;

    private DateTime() {
    }

    public static final java.sql.Date dateBytesToDate(byte[] byArray, int n, Calendar calendar, String string) throws UnsupportedEncodingException {
        String string2 = new String(byArray, n, 10, string);
        if (string2.charAt(4) != '-') {
            throw new IllegalArgumentException(SqlException.getMessageUtil().getTextMessage("22018"));
        }
        int n2 = 0;
        int n3 = 5;
        int n4 = 8;
        int n5 = 48;
        int n6 = 1000 * (string2.charAt(n2) - n5) + 100 * (string2.charAt(n2 + 1) - n5) + 10 * (string2.charAt(n2 + 2) - n5) + (string2.charAt(n2 + 3) - n5);
        int n7 = 10 * (string2.charAt(n3) - n5) + (string2.charAt(n3 + 1) - n5) - 1;
        int n8 = 10 * (string2.charAt(n4) - n5) + (string2.charAt(n4 + 1) - n5);
        Calendar calendar2 = DateTime.getCleanCalendar(calendar);
        calendar2.set(n6, n7, n8);
        return new java.sql.Date(calendar2.getTimeInMillis());
    }

    public static final Time timeBytesToTime(byte[] byArray, int n, Calendar calendar, String string) throws UnsupportedEncodingException {
        String string2 = new String(byArray, n, 8, string);
        int n2 = 48;
        int n3 = 10 * (string2.charAt(0) - n2) + (string2.charAt(1) - n2);
        int n4 = 10 * (string2.charAt(3) - n2) + (string2.charAt(4) - n2);
        int n5 = 10 * (string2.charAt(6) - n2) + (string2.charAt(7) - n2);
        Calendar calendar2 = DateTime.getCleanCalendar(calendar);
        calendar2.set(1970, 0, 1, n3, n4, n5);
        return new Time(calendar2.getTimeInMillis());
    }

    public static final Timestamp timestampBytesToTimestamp(byte[] byArray, int n, Calendar calendar, String string, boolean bl) throws UnsupportedEncodingException {
        String string2 = new String(byArray, n, DateTime.getTimestampLength(bl), string);
        Calendar calendar2 = DateTime.getCleanCalendar(calendar);
        int n2 = DateTime.parseTimestampString(string2, calendar2, bl);
        Timestamp timestamp = new Timestamp(calendar2.getTimeInMillis());
        timestamp.setNanos(n2);
        return timestamp;
    }

    private static int parseTimestampString(String string, Calendar calendar, boolean bl) {
        int n = 48;
        calendar.set(1, 1000 * (string.charAt(0) - n) + 100 * (string.charAt(1) - n) + 10 * (string.charAt(2) - n) + (string.charAt(3) - n));
        calendar.set(2, 10 * (string.charAt(5) - n) + (string.charAt(6) - n) - 1);
        calendar.set(5, 10 * (string.charAt(8) - n) + (string.charAt(9) - n));
        calendar.set(10, 10 * (string.charAt(11) - n) + (string.charAt(12) - n));
        calendar.set(12, 10 * (string.charAt(14) - n) + (string.charAt(15) - n));
        calendar.set(13, 10 * (string.charAt(17) - n) + (string.charAt(18) - n));
        int n2 = 100000000 * (string.charAt(20) - n) + 10000000 * (string.charAt(21) - n) + 1000000 * (string.charAt(22) - n) + 100000 * (string.charAt(23) - n) + 10000 * (string.charAt(24) - n) + 1000 * (string.charAt(25) - n);
        if (bl) {
            n2 += 100 * (string.charAt(26) - n);
            n2 += 10 * (string.charAt(27) - n);
            n2 += string.charAt(28) - n;
        }
        calendar.set(14, n2 / 1000000);
        return n2;
    }

    public static final int dateToDateBytes(byte[] byArray, int n, DateTimeValue dateTimeValue) throws SqlException, UnsupportedEncodingException {
        int n2 = dateTimeValue.getYear();
        if (n2 > 9999) {
            throw new SqlException(null, new ClientMessageId("22003.S.1"), (Object)new Integer(n2), "9999");
        }
        int n3 = dateTimeValue.getMonth() + 1;
        int n4 = dateTimeValue.getDayOfMonth();
        char[] cArray = new char[10];
        int n5 = 48;
        cArray[0] = (char)(n2 / 1000 + n5);
        cArray[1] = (char)(n2 % 1000 / 100 + n5);
        cArray[2] = (char)(n2 % 100 / 10 + n5);
        cArray[3] = (char)(n2 % 10 + n5);
        cArray[4] = 45;
        cArray[5] = (char)(n3 / 10 + n5);
        cArray[6] = (char)(n3 % 10 + n5);
        cArray[7] = 45;
        cArray[8] = (char)(n4 / 10 + n5);
        cArray[9] = (char)(n4 % 10 + n5);
        byte[] byArray2 = new String(cArray).getBytes("UTF8");
        System.arraycopy(byArray2, 0, byArray, n, 10);
        return 10;
    }

    public static final int timeToTimeBytes(byte[] byArray, int n, DateTimeValue dateTimeValue) throws UnsupportedEncodingException {
        int n2 = dateTimeValue.getHours();
        int n3 = dateTimeValue.getMinutes();
        int n4 = dateTimeValue.getSeconds();
        char[] cArray = new char[8];
        int n5 = 48;
        cArray[0] = (char)(n2 / 10 + n5);
        cArray[1] = (char)(n2 % 10 + n5);
        cArray[2] = 58;
        cArray[3] = (char)(n3 / 10 + n5);
        cArray[4] = (char)(n3 % 10 + n5);
        cArray[5] = 58;
        cArray[6] = (char)(n4 / 10 + n5);
        cArray[7] = (char)(n4 % 10 + n5);
        byte[] byArray2 = new String(cArray).getBytes("UTF8");
        System.arraycopy(byArray2, 0, byArray, n, 8);
        return 8;
    }

    public static final int timestampToTimestampBytes(byte[] byArray, int n, DateTimeValue dateTimeValue, boolean bl) throws SqlException, UnsupportedEncodingException {
        int n2 = dateTimeValue.getYear();
        if (n2 > 9999) {
            throw new SqlException(null, new ClientMessageId("22003.S.1"), (Object)new Integer(n2), "9999");
        }
        int n3 = dateTimeValue.getMonth() + 1;
        int n4 = dateTimeValue.getDayOfMonth();
        int n5 = dateTimeValue.getHours();
        int n6 = dateTimeValue.getMinutes();
        int n7 = dateTimeValue.getSeconds();
        int n8 = dateTimeValue.getNanos() / 1000;
        int n9 = DateTime.getTimestampLength(bl);
        char[] cArray = new char[n9];
        int n10 = 48;
        cArray[0] = (char)(n2 / 1000 + n10);
        cArray[1] = (char)(n2 % 1000 / 100 + n10);
        cArray[2] = (char)(n2 % 100 / 10 + n10);
        cArray[3] = (char)(n2 % 10 + n10);
        cArray[4] = 45;
        cArray[5] = (char)(n3 / 10 + n10);
        cArray[6] = (char)(n3 % 10 + n10);
        cArray[7] = 45;
        cArray[8] = (char)(n4 / 10 + n10);
        cArray[9] = (char)(n4 % 10 + n10);
        cArray[10] = 45;
        cArray[11] = (char)(n5 / 10 + n10);
        cArray[12] = (char)(n5 % 10 + n10);
        cArray[13] = 46;
        cArray[14] = (char)(n6 / 10 + n10);
        cArray[15] = (char)(n6 % 10 + n10);
        cArray[16] = 46;
        cArray[17] = (char)(n7 / 10 + n10);
        cArray[18] = (char)(n7 % 10 + n10);
        cArray[19] = 46;
        cArray[20] = (char)(n8 / 100000 + n10);
        cArray[21] = (char)(n8 % 100000 / 10000 + n10);
        cArray[22] = (char)(n8 % 10000 / 1000 + n10);
        cArray[23] = (char)(n8 % 1000 / 100 + n10);
        cArray[24] = (char)(n8 % 100 / 10 + n10);
        cArray[25] = (char)(n8 % 10 + n10);
        if (bl) {
            int n11 = dateTimeValue.getNanos() % 1000;
            cArray[26] = (char)(n11 / 100 + n10);
            cArray[27] = (char)(n11 % 100 / 10 + n10);
            cArray[28] = (char)(n11 % 10 + n10);
        }
        String string = new String(cArray);
        byte[] byArray2 = string.getBytes("UTF8");
        System.arraycopy(byArray2, 0, byArray, n, n9);
        return n9;
    }

    public static final Timestamp dateBytesToTimestamp(byte[] byArray, int n, Calendar calendar, String string) throws UnsupportedEncodingException {
        String string2 = new String(byArray, n, 10, string);
        int n2 = 0;
        int n3 = 5;
        int n4 = 8;
        int n5 = 48;
        int n6 = 1000 * (string2.charAt(n2) - n5) + 100 * (string2.charAt(n2 + 1) - n5) + 10 * (string2.charAt(n2 + 2) - n5) + (string2.charAt(n2 + 3) - n5);
        int n7 = 10 * (string2.charAt(n3) - n5) + (string2.charAt(n3 + 1) - n5) - 1;
        int n8 = 10 * (string2.charAt(n4) - n5) + (string2.charAt(n4 + 1) - n5);
        Calendar calendar2 = DateTime.getCleanCalendar(calendar);
        calendar2.set(n6, n7, n8, 0, 0, 0);
        Timestamp timestamp = new Timestamp(calendar2.getTimeInMillis());
        timestamp.setNanos(0);
        return timestamp;
    }

    public static final Timestamp timeBytesToTimestamp(byte[] byArray, int n, Calendar calendar, String string) throws UnsupportedEncodingException {
        String string2 = new String(byArray, n, 8, string);
        int n2 = 48;
        int n3 = 10 * (string2.charAt(0) - n2) + (string2.charAt(1) - n2);
        int n4 = 10 * (string2.charAt(3) - n2) + (string2.charAt(4) - n2);
        int n5 = 10 * (string2.charAt(6) - n2) + (string2.charAt(7) - n2);
        Calendar calendar2 = DateTime.getCleanCalendar(calendar);
        calendar2.setTime(new Date());
        calendar2.set(11, n3);
        calendar2.set(12, n4);
        calendar2.set(13, n5);
        calendar2.set(14, 0);
        return new Timestamp(calendar2.getTimeInMillis());
    }

    public static final java.sql.Date timestampBytesToDate(byte[] byArray, int n, Calendar calendar, String string) throws UnsupportedEncodingException {
        String string2 = new String(byArray, n, 26, string);
        int n2 = 48;
        int n3 = 1000 * (string2.charAt(0) - n2) + 100 * (string2.charAt(1) - n2) + 10 * (string2.charAt(2) - n2) + (string2.charAt(3) - n2);
        int n4 = 10 * (string2.charAt(5) - n2) + (string2.charAt(6) - n2) - 1;
        int n5 = 10 * (string2.charAt(8) - n2) + (string2.charAt(9) - n2);
        Calendar calendar2 = DateTime.getCleanCalendar(calendar);
        calendar2.set(n3, n4, n5);
        return new java.sql.Date(calendar2.getTimeInMillis());
    }

    public static final Time timestampBytesToTime(byte[] byArray, int n, Calendar calendar, String string) throws UnsupportedEncodingException {
        String string2 = new String(byArray, n, 26, string);
        Calendar calendar2 = DateTime.getCleanCalendar(calendar);
        DateTime.parseTimestampString(string2, calendar2, false);
        calendar2.set(1970, 0, 1);
        return new Time(calendar2.getTimeInMillis());
    }

    private static Calendar getCleanCalendar(Calendar calendar) {
        if (calendar != null) {
            calendar.clear();
            return calendar;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.clear();
        return gregorianCalendar;
    }

    public static final int timestampToDateBytes(byte[] byArray, int n, Timestamp timestamp) throws SqlException, UnsupportedEncodingException {
        int n2 = timestamp.getYear() + 1900;
        if (n2 > 9999) {
            throw new SqlException(null, new ClientMessageId("22003.S.1"), (Object)new Integer(n2), "9999");
        }
        int n3 = timestamp.getMonth() + 1;
        int n4 = timestamp.getDate();
        char[] cArray = new char[10];
        int n5 = 48;
        cArray[0] = (char)(n2 / 1000 + n5);
        cArray[1] = (char)(n2 % 1000 / 100 + n5);
        cArray[2] = (char)(n2 % 100 / 10 + n5);
        cArray[3] = (char)(n2 % 10 + n5);
        cArray[4] = 45;
        cArray[5] = (char)(n3 / 10 + n5);
        cArray[6] = (char)(n3 % 10 + n5);
        cArray[7] = 45;
        cArray[8] = (char)(n4 / 10 + n5);
        cArray[9] = (char)(n4 % 10 + n5);
        byte[] byArray2 = new String(cArray).getBytes("UTF8");
        System.arraycopy(byArray2, 0, byArray, n, 10);
        return 10;
    }

    public static final int timestampToTimeBytes(byte[] byArray, int n, Timestamp timestamp) throws UnsupportedEncodingException {
        int n2 = timestamp.getHours();
        int n3 = timestamp.getMinutes();
        int n4 = timestamp.getSeconds();
        char[] cArray = new char[8];
        int n5 = 48;
        cArray[0] = (char)(n2 / 10 + n5);
        cArray[1] = (char)(n2 % 10 + n5);
        cArray[2] = 58;
        cArray[3] = (char)(n3 / 10 + n5);
        cArray[4] = (char)(n3 % 10 + n5);
        cArray[5] = 58;
        cArray[6] = (char)(n4 / 10 + n5);
        cArray[7] = (char)(n4 % 10 + n5);
        byte[] byArray2 = new String(cArray).getBytes("UTF8");
        System.arraycopy(byArray2, 0, byArray, n, 8);
        return 8;
    }

    public static int getTimestampLength(boolean bl) {
        return bl ? 29 : 26;
    }
}

