/**
 * The Login Button created by Titanium.Facebook.createLoginButton.
 * @since 0.8
 */
function Titanium_Facebook_LoginButton() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_Facebook_LoginButton.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_Facebook_LoginButton.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_Facebook_LoginButton.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_Facebook_LoginButton.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_Facebook_LoginButton.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_Facebook_LoginButton.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * the background color of the view
	 * @alias Titanium_Facebook_LoginButton.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the view
	 * @alias Titanium_Facebook_LoginButton.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_Facebook_LoginButton.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_Facebook_LoginButton.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_Facebook_LoginButton.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_Facebook_LoginButton.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_Facebook_LoginButton.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_Facebook_LoginButton.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_Facebook_LoginButton.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_Facebook_LoginButton.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_Facebook_LoginButton.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_Facebook_LoginButton.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_Facebook_LoginButton.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_Facebook_LoginButton.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_Facebook_LoginButton.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_Facebook_LoginButton.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_Facebook_LoginButton.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_Facebook_LoginButton.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_Facebook_LoginButton.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_Facebook_LoginButton.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_Facebook_LoginButton.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_Facebook_LoginButton.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_Facebook_LoginButton.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_Facebook_LoginButton.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Facebook_LoginButton.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Facebook_LoginButton.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_Facebook_LoginButton.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_Facebook_LoginButton.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_Facebook_LoginButton.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_Facebook_LoginButton.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_Facebook_LoginButton.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_Facebook_LoginButton.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_Facebook_LoginButton.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Facebook_LoginButton.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Facebook_LoginButton.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_Facebook_LoginButton.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_Facebook_LoginButton.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_Facebook_LoginButton.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_Facebook_LoginButton.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Facebook_LoginButton.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Facebook_LoginButton.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_Facebook_LoginButton.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_Facebook_LoginButton.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_Facebook_LoginButton.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_Facebook_LoginButton.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Facebook_LoginButton.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Facebook_LoginButton.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_Facebook_LoginButton.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_Facebook_LoginButton.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_Facebook_LoginButton.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Facebook_LoginButton.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_Facebook_LoginButton.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_Facebook_LoginButton.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_Facebook_LoginButton.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_Facebook_LoginButton.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_Facebook_LoginButton.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Facebook_LoginButton.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_Facebook_LoginButton.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_Facebook_LoginButton.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_Facebook_LoginButton.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_Facebook_LoginButton.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_Facebook_LoginButton.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Facebook_LoginButton.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_Facebook_LoginButton.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_Facebook_LoginButton.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_Facebook_LoginButton.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_Facebook_LoginButton.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_Facebook_LoginButton.hide
	 */
	this.hide = function hide() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_Facebook_LoginButton.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_Facebook_LoginButton.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * make the view visible
	 * @alias Titanium_Facebook_LoginButton.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_Facebook_LoginButton.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * An Annotation object that is created by the method Titanium.Map.createAnnotation. This object gives you low level control over annotations that can be added to a Map View.
 * @since 0.9
 */
function Titanium_Map_Annotation() {
	/**
	 * boolean to indicate whether the pin should animate when dropped
	 * @alias Titanium_Map_Annotation.animate
	 * @property {Boolean}
	 */
	this.animate = false
	/**
	 * Get the boolean to indicate whether the pin should animate when dropped
	 * @alias Titanium_Map_Annotation.getAnimate
	 * @return {Boolean}
	 */
	this.getAnimate = function() { return this.animate; }
	/**
	 * Set the boolean to indicate whether the pin should animate when dropped
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Map_Annotation.setAnimate
	 */
	this.setAnimate = function(value) { this.animate = value; }
	/**
	 * the left button image on the annotation. must either be a button type constant or url
	 * @alias Titanium_Map_Annotation.leftButton
	 * @property {Integer,String}
	 */
	this.leftButton = 0
	/**
	 * Get the the left button image on the annotation. must either be a button type constant or url
	 * @alias Titanium_Map_Annotation.getLeftButton
	 * @return {Integer,String}
	 */
	this.getLeftButton = function() { return this.leftButton; }
	/**
	 * Set the the left button image on the annotation. must either be a button type constant or url
	 * @param {Integer,String} value New value to set.
	 * @alias Titanium_Map_Annotation.setLeftButton
	 */
	this.setLeftButton = function(value) { this.leftButton = value; }
	/**
	 * a left view that is displayed on the annotation
	 * @alias Titanium_Map_Annotation.leftView
	 * @property {Object}
	 */
	this.leftView = {}
	/**
	 * Get the a left view that is displayed on the annotation
	 * @alias Titanium_Map_Annotation.getLeftView
	 * @return {Object}
	 */
	this.getLeftView = function() { return this.leftView; }
	/**
	 * Set the a left view that is displayed on the annotation
	 * @param {Object} value New value to set.
	 * @alias Titanium_Map_Annotation.setLeftView
	 */
	this.setLeftView = function(value) { this.leftView = value; }
	/**
	 * the pin color as one of Titanium.Map.ANNOTATION_RED, Titanium.Map.ANNOTATION_GREEN or Titanium.Map.ANNOTATION_PURPLE.
	 * @alias Titanium_Map_Annotation.pincolor
	 * @property {Integer}
	 */
	this.pincolor = 0
	/**
	 * Get the the pin color as one of Titanium.Map.ANNOTATION_RED, Titanium.Map.ANNOTATION_GREEN or Titanium.Map.ANNOTATION_PURPLE.
	 * @alias Titanium_Map_Annotation.getPincolor
	 * @return {Integer}
	 */
	this.getPincolor = function() { return this.pincolor; }
	/**
	 * Set the the pin color as one of Titanium.Map.ANNOTATION_RED, Titanium.Map.ANNOTATION_GREEN or Titanium.Map.ANNOTATION_PURPLE.
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Map_Annotation.setPincolor
	 */
	this.setPincolor = function(value) { this.pincolor = value; }
	/**
	 * the right button image on the annotation. must either be a button type constant or url
	 * @alias Titanium_Map_Annotation.rightButton
	 * @property {Integer,String}
	 */
	this.rightButton = 0
	/**
	 * Get the the right button image on the annotation. must either be a button type constant or url
	 * @alias Titanium_Map_Annotation.getRightButton
	 * @return {Integer,String}
	 */
	this.getRightButton = function() { return this.rightButton; }
	/**
	 * Set the the right button image on the annotation. must either be a button type constant or url
	 * @param {Integer,String} value New value to set.
	 * @alias Titanium_Map_Annotation.setRightButton
	 */
	this.setRightButton = function(value) { this.rightButton = value; }
	/**
	 * a right view that is displayed on the annotation
	 * @alias Titanium_Map_Annotation.rightView
	 * @property {Object}
	 */
	this.rightView = {}
	/**
	 * Get the a right view that is displayed on the annotation
	 * @alias Titanium_Map_Annotation.getRightView
	 * @return {Object}
	 */
	this.getRightView = function() { return this.rightView; }
	/**
	 * Set the a right view that is displayed on the annotation
	 * @param {Object} value New value to set.
	 * @alias Titanium_Map_Annotation.setRightView
	 */
	this.setRightView = function(value) { this.rightView = value; }
	/**
	 * the secondary title of the annotation view
	 * @alias Titanium_Map_Annotation.subtitle
	 * @property {String}
	 */
	this.subtitle = ''
	/**
	 * Get the the secondary title of the annotation view
	 * @alias Titanium_Map_Annotation.getSubtitle
	 * @return {String}
	 */
	this.getSubtitle = function() { return this.subtitle; }
	/**
	 * Set the the secondary title of the annotation view
	 * @param {String} value New value to set.
	 * @alias Titanium_Map_Annotation.setSubtitle
	 */
	this.setSubtitle = function(value) { this.subtitle = value; }
	/**
	 * the primary title of the annotation view
	 * @alias Titanium_Map_Annotation.title
	 * @property {String}
	 */
	this.title = ''
	/**
	 * Get the the primary title of the annotation view
	 * @alias Titanium_Map_Annotation.getTitle
	 * @return {String}
	 */
	this.getTitle = function() { return this.title; }
	/**
	 * Set the the primary title of the annotation view
	 * @param {String} value New value to set.
	 * @alias Titanium_Map_Annotation.setTitle
	 */
	this.setTitle = function(value) { this.title = value; }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_Map_Annotation.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_Map_Annotation.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_Map_Annotation.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
};

/**
 * The MapView is an object created by Titanium.Map.createView and is used for embedding native mapping capabilities as a view in your application.  With native maps, you can control the mapping location, the type of map, the zoom level and you can add custom annotations directly to the map.
 * @since 0.8
 */
function Titanium_Map_MapView() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_Map_MapView.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_Map_MapView.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_Map_MapView.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * boolean is mapping actions should be animated
	 * @alias Titanium_Map_MapView.animate
	 * @property {Boolean}
	 */
	this.animate = false
	/**
	 * Get the boolean is mapping actions should be animated
	 * @alias Titanium_Map_MapView.getAnimate
	 * @return {Boolean}
	 */
	this.getAnimate = function() { return this.animate; }
	/**
	 * Set the boolean is mapping actions should be animated
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Map_MapView.setAnimate
	 */
	this.setAnimate = function(value) { this.animate = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_Map_MapView.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_Map_MapView.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_Map_MapView.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * an array of annotations to add to the map
	 * @alias Titanium_Map_MapView.annotations
	 * @property {Array}
	 */
	this.annotations = []
	/**
	 * Get the an array of annotations to add to the map
	 * @alias Titanium_Map_MapView.getAnnotations
	 * @return {Array}
	 */
	this.getAnnotations = function() { return this.annotations; }
	/**
	 * Set the an array of annotations to add to the map
	 * @param {Array} value New value to set.
	 * @alias Titanium_Map_MapView.setAnnotations
	 */
	this.setAnnotations = function(value) { this.annotations = value; }
	/**
	 * the background color of the view
	 * @alias Titanium_Map_MapView.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the view
	 * @alias Titanium_Map_MapView.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_Map_MapView.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_Map_MapView.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_Map_MapView.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_Map_MapView.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_Map_MapView.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_Map_MapView.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_Map_MapView.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_Map_MapView.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_Map_MapView.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_Map_MapView.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_Map_MapView.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_Map_MapView.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_Map_MapView.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_Map_MapView.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_Map_MapView.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_Map_MapView.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_Map_MapView.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_Map_MapView.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_Map_MapView.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_Map_MapView.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_Map_MapView.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_Map_MapView.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Map_MapView.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Map_MapView.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_Map_MapView.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_Map_MapView.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_Map_MapView.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_Map_MapView.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_Map_MapView.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_Map_MapView.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_Map_MapView.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Map_MapView.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Map_MapView.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_Map_MapView.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * a dictionary that specifies the following properties specifying the region location to set the map: latitudeDelta, longitudeDelta, latitude, longitude.
	 * @alias Titanium_Map_MapView.location
	 * @property {Object}
	 */
	this.location = {}
	/**
	 * Get the a dictionary that specifies the following properties specifying the region location to set the map: latitudeDelta, longitudeDelta, latitude, longitude.
	 * @alias Titanium_Map_MapView.getLocation
	 * @return {Object}
	 */
	this.getLocation = function() { return this.location; }
	/**
	 * Set the a dictionary that specifies the following properties specifying the region location to set the map: latitudeDelta, longitudeDelta, latitude, longitude.
	 * @param {Object} value New value to set.
	 * @alias Titanium_Map_MapView.setLocation
	 */
	this.setLocation = function(value) { this.location = value; }
	/**
	 * the map type constant of either Titanium.Map.STANDARD_TYPE, Titanium.Map.SATELLITE_TYPE or Titanium.Map.HYBRID_TYPE.
	 * @alias Titanium_Map_MapView.mapType
	 * @property {Integer}
	 */
	this.mapType = 0
	/**
	 * Get the the map type constant of either Titanium.Map.STANDARD_TYPE, Titanium.Map.SATELLITE_TYPE or Titanium.Map.HYBRID_TYPE.
	 * @alias Titanium_Map_MapView.getMapType
	 * @return {Integer}
	 */
	this.getMapType = function() { return this.mapType; }
	/**
	 * Set the the map type constant of either Titanium.Map.STANDARD_TYPE, Titanium.Map.SATELLITE_TYPE or Titanium.Map.HYBRID_TYPE.
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Map_MapView.setMapType
	 */
	this.setMapType = function(value) { this.mapType = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_Map_MapView.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_Map_MapView.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_Map_MapView.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * a dictionary that specifies the following properties specifying the region location to set the map: latitudeDelta, longitudeDelta, latitude, longitude.
	 * @alias Titanium_Map_MapView.region
	 * @property {Object}
	 */
	this.region = {}
	/**
	 * Get the a dictionary that specifies the following properties specifying the region location to set the map: latitudeDelta, longitudeDelta, latitude, longitude.
	 * @alias Titanium_Map_MapView.getRegion
	 * @return {Object}
	 */
	this.getRegion = function() { return this.region; }
	/**
	 * Set the a dictionary that specifies the following properties specifying the region location to set the map: latitudeDelta, longitudeDelta, latitude, longitude.
	 * @param {Object} value New value to set.
	 * @alias Titanium_Map_MapView.setRegion
	 */
	this.setRegion = function(value) { this.region = value; }
	/**
	 * boolean to indicate if the map should attempt to fit the map view into the region in the visible view
	 * @alias Titanium_Map_MapView.regionFit
	 * @property {Boolean}
	 */
	this.regionFit = false
	/**
	 * Get the boolean to indicate if the map should attempt to fit the map view into the region in the visible view
	 * @alias Titanium_Map_MapView.getRegionFit
	 * @return {Boolean}
	 */
	this.getRegionFit = function() { return this.regionFit; }
	/**
	 * Set the boolean to indicate if the map should attempt to fit the map view into the region in the visible view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Map_MapView.setRegionFit
	 */
	this.setRegionFit = function(value) { this.regionFit = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Map_MapView.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Map_MapView.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_Map_MapView.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_Map_MapView.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_Map_MapView.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_Map_MapView.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Map_MapView.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Map_MapView.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_Map_MapView.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_Map_MapView.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_Map_MapView.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Map_MapView.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_Map_MapView.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_Map_MapView.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_Map_MapView.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * boolean to indicate if the map should show the user's current device location as a pin on the map
	 * @alias Titanium_Map_MapView.userLocation
	 * @property {Boolean}
	 */
	this.userLocation = false
	/**
	 * Get the boolean to indicate if the map should show the user's current device location as a pin on the map
	 * @alias Titanium_Map_MapView.getUserLocation
	 * @return {Boolean}
	 */
	this.getUserLocation = function() { return this.userLocation; }
	/**
	 * Set the boolean to indicate if the map should show the user's current device location as a pin on the map
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Map_MapView.setUserLocation
	 */
	this.setUserLocation = function(value) { this.userLocation = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_Map_MapView.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_Map_MapView.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Map_MapView.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_Map_MapView.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_Map_MapView.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_Map_MapView.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_Map_MapView.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_Map_MapView.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Map_MapView.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_Map_MapView.add
	 */
	this.add = function add(view) { }
	/**
	 * add a new annotation to the map
	 * @param {Object} annotation either a dictionary of properties for the annotation or a [Titanium.Map.Annotation](Titanium.Map.Annotation) instance.
	 * @alias Titanium_Map_MapView.addAnnotation
	 */
	this.addAnnotation = function addAnnotation(annotation) { }
	/**
	 * add one or more new annotation to the map
	 * @param {Array} annotations an array of either a dictionary of properties for the annotation or a [Titanium.Map.Annotation](Titanium.Map.Annotation) instance.
	 * @alias Titanium_Map_MapView.addAnnotations
	 */
	this.addAnnotations = function addAnnotations(annotations) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_Map_MapView.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_Map_MapView.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * cause the annotation to be deselected (hidden)
	 * @param {String,Object} annotation either a string of the annotation title or a [Titanium.Map.Annotation](Titanium.Map.Annotation) reference.
	 * @alias Titanium_Map_MapView.deselectAnnotation
	 */
	this.deselectAnnotation = function deselectAnnotation(annotation) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_Map_MapView.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_Map_MapView.hide
	 */
	this.hide = function hide() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_Map_MapView.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * removes all annotations added to the map
	 * @alias Titanium_Map_MapView.removeAllAnnotations
	 */
	this.removeAllAnnotations = function removeAllAnnotations() { }
	/**
	 * remove an existing annotation from the map
	 * @param {String,Object} annotation either a string of the annotation title or a [Titanium.Map.Annotation](Titanium.Map.Annotation) reference.
	 * @alias Titanium_Map_MapView.removeAnnotation
	 */
	this.removeAnnotation = function removeAnnotation(annotation) { }
	/**
	 * remove one or more existing annotations from the map
	 * @param {Array} annotation an array of either a string of the annotation title or a [Titanium.Map.Annotation](Titanium.Map.Annotation) reference.
	 * @alias Titanium_Map_MapView.removeAnnotations
	 */
	this.removeAnnotations = function removeAnnotations(annotation) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_Map_MapView.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * cause the annotation to be selected (shown)
	 * @param {String,Object} annotation either a string of the annotation title or a [Titanium.Map.Annotation](Titanium.Map.Annotation) reference.
	 * @alias Titanium_Map_MapView.selectAnnotation
	 */
	this.selectAnnotation = function selectAnnotation(annotation) { }
	/**
	 * make the view visible
	 * @alias Titanium_Map_MapView.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_Map_MapView.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
	/**
	 * zoom in or out of the map
	 * @param {Double} level zoom level (can be positive or negative)
	 * @alias Titanium_Map_MapView.zoom
	 */
	this.zoom = function zoom(level) { }
};

/**
 * The AudioPlayer object is returned by Titanium.Media.createAudioPlayer and is used for streaming audio to the device and low-level control of the audio playback.
 * @since 0.9
 */
function Titanium_Media_AudioPlayer() {
	/**
	 * boolean to indicate if audio should continue playing even if Activity is paused (Android only as of 1.3.0)
	 * @alias Titanium_Media_AudioPlayer.allowBackground
	 * @property {Boolean}
	 */
	this.allowBackground = false
	/**
	 * Get the boolean to indicate if audio should continue playing even if Activity is paused (Android only as of 1.3.0)
	 * @alias Titanium_Media_AudioPlayer.getAllowBackground
	 * @return {Boolean}
	 */
	this.getAllowBackground = function() { return this.allowBackground; }
	/**
	 * Set the boolean to indicate if audio should continue playing even if Activity is paused (Android only as of 1.3.0)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Media_AudioPlayer.setAllowBackground
	 */
	this.setAllowBackground = function(value) { this.allowBackground = value; }
	/**
	 * the default audio session mode to be used for this player. One of Titanium.Media.AUDIO_SESSION_MODE_AMBIENT, Titanium.Media.AUDIO_SESSION_MODE_SOLO_AMBIENT Titanium.Media.AUDIO_SESSION_MODE_PLAYBACK Titanium.Media.AUDIO_SESSION_MODE_RECORD, Titanium.Media.AUDIO_SESSION_MODE_PLAY_AND_RECORD.
	 * @alias Titanium_Media_AudioPlayer.audioSessionMode
	 * @property {Integer}
	 */
	this.audioSessionMode = 0
	/**
	 * Get the the default audio session mode to be used for this player. One of Titanium.Media.AUDIO_SESSION_MODE_AMBIENT, Titanium.Media.AUDIO_SESSION_MODE_SOLO_AMBIENT Titanium.Media.AUDIO_SESSION_MODE_PLAYBACK Titanium.Media.AUDIO_SESSION_MODE_RECORD, Titanium.Media.AUDIO_SESSION_MODE_PLAY_AND_RECORD.
	 * @alias Titanium_Media_AudioPlayer.getAudioSessionMode
	 * @return {Integer}
	 */
	this.getAudioSessionMode = function() { return this.audioSessionMode; }
	/**
	 * Set the the default audio session mode to be used for this player. One of Titanium.Media.AUDIO_SESSION_MODE_AMBIENT, Titanium.Media.AUDIO_SESSION_MODE_SOLO_AMBIENT Titanium.Media.AUDIO_SESSION_MODE_PLAYBACK Titanium.Media.AUDIO_SESSION_MODE_RECORD, Titanium.Media.AUDIO_SESSION_MODE_PLAY_AND_RECORD.
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Media_AudioPlayer.setAudioSessionMode
	 */
	this.setAudioSessionMode = function(value) { this.audioSessionMode = value; }
	/**
	 * bit rate of the current playback stream
	 * @alias Titanium_Media_AudioPlayer.bitRate
	 * @property {Double}
	 */
	this.bitRate = 0.0
	/**
	 * Get the bit rate of the current playback stream
	 * @alias Titanium_Media_AudioPlayer.getBitRate
	 * @return {Double}
	 */
	this.getBitRate = function() { return this.bitRate; }
	/**
	 * Set the bit rate of the current playback stream
	 * @param {Double} value New value to set.
	 * @alias Titanium_Media_AudioPlayer.setBitRate
	 */
	this.setBitRate = function(value) { this.bitRate = value; }
	/**
	 * returns boolean indicating if the playback is idle
	 * @alias Titanium_Media_AudioPlayer.idle
	 * @property {Boolean}
	 */
	this.idle = false
	/**
	 * Get the returns boolean indicating if the playback is idle
	 * @alias Titanium_Media_AudioPlayer.getIdle
	 * @return {Boolean}
	 */
	this.getIdle = function() { return this.idle; }
	/**
	 * Set the returns boolean indicating if the playback is idle
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Media_AudioPlayer.setIdle
	 */
	this.setIdle = function(value) { this.idle = value; }
	/**
	 * returns boolean indicating if the playback is paused
	 * @alias Titanium_Media_AudioPlayer.paused
	 * @property {Boolean}
	 */
	this.paused = false
	/**
	 * Get the returns boolean indicating if the playback is paused
	 * @alias Titanium_Media_AudioPlayer.getPaused
	 * @return {Boolean}
	 */
	this.getPaused = function() { return this.paused; }
	/**
	 * Set the returns boolean indicating if the playback is paused
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Media_AudioPlayer.setPaused
	 */
	this.setPaused = function(value) { this.paused = value; }
	/**
	 * returns boolean indicating if the playback is streaming audio
	 * @alias Titanium_Media_AudioPlayer.playing
	 * @property {Boolean}
	 */
	this.playing = false
	/**
	 * Get the returns boolean indicating if the playback is streaming audio
	 * @alias Titanium_Media_AudioPlayer.getPlaying
	 * @return {Boolean}
	 */
	this.getPlaying = function() { return this.playing; }
	/**
	 * Set the returns boolean indicating if the playback is streaming audio
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Media_AudioPlayer.setPlaying
	 */
	this.setPlaying = function(value) { this.playing = value; }
	/**
	 * returns the current playback progress. Will return zero if sampleRate has not yet been detected
	 * @alias Titanium_Media_AudioPlayer.progress
	 * @property {Double}
	 */
	this.progress = 0.0
	/**
	 * Get the returns the current playback progress. Will return zero if sampleRate has not yet been detected
	 * @alias Titanium_Media_AudioPlayer.getProgress
	 * @return {Double}
	 */
	this.getProgress = function() { return this.progress; }
	/**
	 * Set the returns the current playback progress. Will return zero if sampleRate has not yet been detected
	 * @param {Double} value New value to set.
	 * @alias Titanium_Media_AudioPlayer.setProgress
	 */
	this.setProgress = function(value) { this.progress = value; }
	/**
	 * returns int for the current state of playback
	 * @alias Titanium_Media_AudioPlayer.state
	 * @property {Integer}
	 */
	this.state = 0
	/**
	 * Get the returns int for the current state of playback
	 * @alias Titanium_Media_AudioPlayer.getState
	 * @return {Integer}
	 */
	this.getState = function() { return this.state; }
	/**
	 * Set the returns int for the current state of playback
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Media_AudioPlayer.setState
	 */
	this.setState = function(value) { this.state = value; }
	/**
	 * returns the url for the current playback
	 * @alias Titanium_Media_AudioPlayer.url
	 * @property {String}
	 */
	this.url = ''
	/**
	 * Get the returns the url for the current playback
	 * @alias Titanium_Media_AudioPlayer.getUrl
	 * @return {String}
	 */
	this.getUrl = function() { return this.url; }
	/**
	 * Set the returns the url for the current playback
	 * @param {String} value New value to set.
	 * @alias Titanium_Media_AudioPlayer.setUrl
	 */
	this.setUrl = function(value) { this.url = value; }
	/**
	 * returns boolean indicating if the playback is waiting for audio data from the network
	 * @alias Titanium_Media_AudioPlayer.waiting
	 * @property {Boolean}
	 */
	this.waiting = false
	/**
	 * Get the returns boolean indicating if the playback is waiting for audio data from the network
	 * @alias Titanium_Media_AudioPlayer.getWaiting
	 * @return {Boolean}
	 */
	this.getWaiting = function() { return this.waiting; }
	/**
	 * Set the returns boolean indicating if the playback is waiting for audio data from the network
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Media_AudioPlayer.setWaiting
	 */
	this.setWaiting = function(value) { this.waiting = value; }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_Media_AudioPlayer.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_Media_AudioPlayer.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * pause playback
	 * @alias Titanium_Media_AudioPlayer.pause
	 */
	this.pause = function pause() { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_Media_AudioPlayer.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * control the playback of the audio
	 * @param {Boolean} paused pass true to pause the current playback temporarily, false to unpause it
	 * @alias Titanium_Media_AudioPlayer.setPaused
	 */
	this.setPaused = function setPaused(paused) { }
	/**
	 * change the url of the audio playback
	 * @param {String} url the new url
	 * @alias Titanium_Media_AudioPlayer.setUrl
	 */
	this.setUrl = function setUrl(url) { }
	/**
	 * start playback
	 * @alias Titanium_Media_AudioPlayer.start
	 */
	this.start = function start() { }
	/**
	 * convert a state into a textual description suitable for display
	 * @alias Titanium_Media_AudioPlayer.stateDescription
	 * @return {String}
	 */
	this.stateDescription = function stateDescription() { return ''; }
	/**
	 * stop playback
	 * @alias Titanium_Media_AudioPlayer.stop
	 */
	this.stop = function stop() { }
};

/**
 * The AudioRecorder object is returned by Titanium.Media.createAudioRecorder and is used for recording audio from the device microphone.
 * @since 0.9
 */
function Titanium_Media_AudioRecorder() {
	/**
	 * the default audio session mode to be used for this recorder. One of Titanium.Media.AUDIO_SESSION_MODE_AMBIENT, Titanium.Media.AUDIO_SESSION_MODE_SOLO_AMBIENT Titanium.Media.AUDIO_SESSION_MODE_PLAYBACK Titanium.Media.AUDIO_SESSION_MODE_RECORD, Titanium.Media.AUDIO_SESSION_MODE_PLAY_AND_RECORD.
	 * @alias Titanium_Media_AudioRecorder.audioSessionMode
	 * @property {Integer}
	 */
	this.audioSessionMode = 0
	/**
	 * Get the the default audio session mode to be used for this recorder. One of Titanium.Media.AUDIO_SESSION_MODE_AMBIENT, Titanium.Media.AUDIO_SESSION_MODE_SOLO_AMBIENT Titanium.Media.AUDIO_SESSION_MODE_PLAYBACK Titanium.Media.AUDIO_SESSION_MODE_RECORD, Titanium.Media.AUDIO_SESSION_MODE_PLAY_AND_RECORD.
	 * @alias Titanium_Media_AudioRecorder.getAudioSessionMode
	 * @return {Integer}
	 */
	this.getAudioSessionMode = function() { return this.audioSessionMode; }
	/**
	 * Set the the default audio session mode to be used for this recorder. One of Titanium.Media.AUDIO_SESSION_MODE_AMBIENT, Titanium.Media.AUDIO_SESSION_MODE_SOLO_AMBIENT Titanium.Media.AUDIO_SESSION_MODE_PLAYBACK Titanium.Media.AUDIO_SESSION_MODE_RECORD, Titanium.Media.AUDIO_SESSION_MODE_PLAY_AND_RECORD.
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Media_AudioRecorder.setAudioSessionMode
	 */
	this.setAudioSessionMode = function(value) { this.audioSessionMode = value; }
	/**
	 * audio compression constant to be used for the recording
	 * @alias Titanium_Media_AudioRecorder.compression
	 * @property {Integer}
	 */
	this.compression = 0
	/**
	 * Get the audio compression constant to be used for the recording
	 * @alias Titanium_Media_AudioRecorder.getCompression
	 * @return {Integer}
	 */
	this.getCompression = function() { return this.compression; }
	/**
	 * Set the audio compression constant to be used for the recording
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Media_AudioRecorder.setCompression
	 */
	this.setCompression = function(value) { this.compression = value; }
	/**
	 * audio format constant for used for the recording
	 * @alias Titanium_Media_AudioRecorder.format
	 * @property {Integer}
	 */
	this.format = 0
	/**
	 * Get the audio format constant for used for the recording
	 * @alias Titanium_Media_AudioRecorder.getFormat
	 * @return {Integer}
	 */
	this.getFormat = function() { return this.format; }
	/**
	 * Set the audio format constant for used for the recording
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Media_AudioRecorder.setFormat
	 */
	this.setFormat = function(value) { this.format = value; }
	/**
	 * readonly property to indicate if paused
	 * @alias Titanium_Media_AudioRecorder.paused
	 * @property {Boolean}
	 */
	this.paused = false
	/**
	 * Get the readonly property to indicate if paused
	 * @alias Titanium_Media_AudioRecorder.getPaused
	 * @return {Boolean}
	 */
	this.getPaused = function() { return this.paused; }
	/**
	 * Set the readonly property to indicate if paused
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Media_AudioRecorder.setPaused
	 */
	this.setPaused = function(value) { this.paused = value; }
	/**
	 * readonly property to indicate if recording
	 * @alias Titanium_Media_AudioRecorder.recording
	 * @property {Boolean}
	 */
	this.recording = false
	/**
	 * Get the readonly property to indicate if recording
	 * @alias Titanium_Media_AudioRecorder.getRecording
	 * @return {Boolean}
	 */
	this.getRecording = function() { return this.recording; }
	/**
	 * Set the readonly property to indicate if recording
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Media_AudioRecorder.setRecording
	 */
	this.setRecording = function(value) { this.recording = value; }
	/**
	 * readonly property to indicate if stopped
	 * @alias Titanium_Media_AudioRecorder.stopped
	 * @property {Boolean}
	 */
	this.stopped = false
	/**
	 * Get the readonly property to indicate if stopped
	 * @alias Titanium_Media_AudioRecorder.getStopped
	 * @return {Boolean}
	 */
	this.getStopped = function() { return this.stopped; }
	/**
	 * Set the readonly property to indicate if stopped
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Media_AudioRecorder.setStopped
	 */
	this.setStopped = function(value) { this.stopped = value; }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_Media_AudioRecorder.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_Media_AudioRecorder.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * called to temporarily pause recording
	 * @alias Titanium_Media_AudioRecorder.pause
	 */
	this.pause = function pause() { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_Media_AudioRecorder.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * called to resume audio recording
	 * @alias Titanium_Media_AudioRecorder.resume
	 */
	this.resume = function resume() { }
	/**
	 * called to start recording audio
	 * @alias Titanium_Media_AudioRecorder.start
	 */
	this.start = function start() { }
	/**
	 * called to stop recording audio
	 * @alias Titanium_Media_AudioRecorder.stop
	 */
	this.stop = function stop() { }
};

/**
 * The Sound object is returned by Titanium.Media.createSound and is useful for playing basic sounds. The Sound object loads the entire media resource in memory before playing.  If you need to support streaming, use the Titanium.Media.createAudioPlayer API.
 * @since 0.8
 */
function Titanium_Media_Sound() {
	/**
	 * boolean to indicate if audio should continue playing even if Activity is paused (Android only as of 1.3.0)
	 * @alias Titanium_Media_Sound.allowBackground
	 * @property {Boolean}
	 */
	this.allowBackground = false
	/**
	 * Get the boolean to indicate if audio should continue playing even if Activity is paused (Android only as of 1.3.0)
	 * @alias Titanium_Media_Sound.getAllowBackground
	 * @return {Boolean}
	 */
	this.getAllowBackground = function() { return this.allowBackground; }
	/**
	 * Set the boolean to indicate if audio should continue playing even if Activity is paused (Android only as of 1.3.0)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Media_Sound.setAllowBackground
	 */
	this.setAllowBackground = function(value) { this.allowBackground = value; }
	/**
	 * the default audio session mode to be used for this player. One of Titanium.Media.AUDIO_SESSION_MODE_AMBIENT, Titanium.Media.AUDIO_SESSION_MODE_SOLO_AMBIENT Titanium.Media.AUDIO_SESSION_MODE_PLAYBACK Titanium.Media.AUDIO_SESSION_MODE_RECORD, Titanium.Media.AUDIO_SESSION_MODE_PLAY_AND_RECORD.
	 * @alias Titanium_Media_Sound.audioSessionMode
	 * @property {Integer}
	 */
	this.audioSessionMode = 0
	/**
	 * Get the the default audio session mode to be used for this player. One of Titanium.Media.AUDIO_SESSION_MODE_AMBIENT, Titanium.Media.AUDIO_SESSION_MODE_SOLO_AMBIENT Titanium.Media.AUDIO_SESSION_MODE_PLAYBACK Titanium.Media.AUDIO_SESSION_MODE_RECORD, Titanium.Media.AUDIO_SESSION_MODE_PLAY_AND_RECORD.
	 * @alias Titanium_Media_Sound.getAudioSessionMode
	 * @return {Integer}
	 */
	this.getAudioSessionMode = function() { return this.audioSessionMode; }
	/**
	 * Set the the default audio session mode to be used for this player. One of Titanium.Media.AUDIO_SESSION_MODE_AMBIENT, Titanium.Media.AUDIO_SESSION_MODE_SOLO_AMBIENT Titanium.Media.AUDIO_SESSION_MODE_PLAYBACK Titanium.Media.AUDIO_SESSION_MODE_RECORD, Titanium.Media.AUDIO_SESSION_MODE_PLAY_AND_RECORD.
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Media_Sound.setAudioSessionMode
	 */
	this.setAudioSessionMode = function(value) { this.audioSessionMode = value; }
	/**
	 * the duration of the audio.
	 * @alias Titanium_Media_Sound.duration
	 * @property {Float}
	 */
	this.duration = 0.0
	/**
	 * Get the the duration of the audio.
	 * @alias Titanium_Media_Sound.getDuration
	 * @return {Float}
	 */
	this.getDuration = function() { return this.duration; }
	/**
	 * Set the the duration of the audio.
	 * @param {Float} value New value to set.
	 * @alias Titanium_Media_Sound.setDuration
	 */
	this.setDuration = function(value) { this.duration = value; }
	/**
	 * boolean to indicate if the audio should loop upon completion
	 * @alias Titanium_Media_Sound.looping
	 * @property {Boolean}
	 */
	this.looping = false
	/**
	 * Get the boolean to indicate if the audio should loop upon completion
	 * @alias Titanium_Media_Sound.getLooping
	 * @return {Boolean}
	 */
	this.getLooping = function() { return this.looping; }
	/**
	 * Set the boolean to indicate if the audio should loop upon completion
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Media_Sound.setLooping
	 */
	this.setLooping = function(value) { this.looping = value; }
	/**
	 * boolean to indicate if the audio is paused
	 * @alias Titanium_Media_Sound.paused
	 * @property {Boolean}
	 */
	this.paused = false
	/**
	 * Get the boolean to indicate if the audio is paused
	 * @alias Titanium_Media_Sound.getPaused
	 * @return {Boolean}
	 */
	this.getPaused = function() { return this.paused; }
	/**
	 * Set the boolean to indicate if the audio is paused
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Media_Sound.setPaused
	 */
	this.setPaused = function(value) { this.paused = value; }
	/**
	 * boolean to indicate if the audio is playing
	 * @alias Titanium_Media_Sound.playing
	 * @property {Boolean}
	 */
	this.playing = false
	/**
	 * Get the boolean to indicate if the audio is playing
	 * @alias Titanium_Media_Sound.getPlaying
	 * @return {Boolean}
	 */
	this.getPlaying = function() { return this.playing; }
	/**
	 * Set the boolean to indicate if the audio is playing
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Media_Sound.setPlaying
	 */
	this.setPlaying = function(value) { this.playing = value; }
	/**
	 * the time position of the audio.
	 * @alias Titanium_Media_Sound.time
	 * @property {Float}
	 */
	this.time = 0.0
	/**
	 * Get the the time position of the audio.
	 * @alias Titanium_Media_Sound.getTime
	 * @return {Float}
	 */
	this.getTime = function() { return this.time; }
	/**
	 * Set the the time position of the audio.
	 * @param {Float} value New value to set.
	 * @alias Titanium_Media_Sound.setTime
	 */
	this.setTime = function(value) { this.time = value; }
	/**
	 * url to the audio
	 * @alias Titanium_Media_Sound.url
	 * @property {String}
	 */
	this.url = ''
	/**
	 * Get the url to the audio
	 * @alias Titanium_Media_Sound.getUrl
	 * @return {String}
	 */
	this.getUrl = function() { return this.url; }
	/**
	 * Set the url to the audio
	 * @param {String} value New value to set.
	 * @alias Titanium_Media_Sound.setUrl
	 */
	this.setUrl = function(value) { this.url = value; }
	/**
	 * the volume of the audio. this volume only affects the media, not the device audio.
	 * @alias Titanium_Media_Sound.volume
	 * @property {Float}
	 */
	this.volume = 0.0
	/**
	 * Get the the volume of the audio. this volume only affects the media, not the device audio.
	 * @alias Titanium_Media_Sound.getVolume
	 * @return {Float}
	 */
	this.getVolume = function() { return this.volume; }
	/**
	 * Set the the volume of the audio. this volume only affects the media, not the device audio.
	 * @param {Float} value New value to set.
	 * @alias Titanium_Media_Sound.setVolume
	 */
	this.setVolume = function(value) { this.volume = value; }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_Media_Sound.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_Media_Sound.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * return the current time position of the audio
	 * @alias Titanium_Media_Sound.getTime
	 * @return {Double}
	 */
	this.getTime = function getTime() { return 0.0; }
	/**
	 * return the value of the audio
	 * @alias Titanium_Media_Sound.getVolume
	 * @return {Float}
	 */
	this.getVolume = function getVolume() { return 0.0; }
	/**
	 * returns true if the audio will loop
	 * @alias Titanium_Media_Sound.isLooping
	 * @return {Boolean}
	 */
	this.isLooping = function isLooping() { return false; }
	/**
	 * returns true if the audio is paused
	 * @alias Titanium_Media_Sound.isPaused
	 * @return {Boolean}
	 */
	this.isPaused = function isPaused() { return false; }
	/**
	 * returns true if the audio is playing
	 * @alias Titanium_Media_Sound.isPlaying
	 * @return {Boolean}
	 */
	this.isPlaying = function isPlaying() { return false; }
	/**
	 * temporarily pause the audio. to resume, invoke play.
	 * @alias Titanium_Media_Sound.pause
	 */
	this.pause = function pause() { }
	/**
	 * starting playing the source. if paused, will resume.
	 * @alias Titanium_Media_Sound.play
	 */
	this.play = function play() { }
	/**
	 * release all internal resources. this is typically unnecessary but can be useful if you load a large audio file in app.js and play it only once and you would like to release all releases after your final play to reduce memory.
	 * @alias Titanium_Media_Sound.release
	 */
	this.release = function release() { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_Media_Sound.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * reset the audio to the beginning.
	 * @alias Titanium_Media_Sound.reset
	 */
	this.reset = function reset() { }
	/**
	 * control whether the audio should loop
	 * @alias Titanium_Media_Sound.setLooping
	 */
	this.setLooping = function setLooping() { }
	/**
	 * control whether the audio is paused
	 * @alias Titanium_Media_Sound.setPaused
	 */
	this.setPaused = function setPaused() { }
	/**
	 * set the time position of the audio
	 * @alias Titanium_Media_Sound.setTime
	 */
	this.setTime = function setTime() { }
	/**
	 * set the volume of the audio
	 * @alias Titanium_Media_Sound.setVolume
	 */
	this.setVolume = function setVolume() { }
	/**
	 * stop playing the audio and reset it to the beginning.
	 * @alias Titanium_Media_Sound.stop
	 */
	this.stop = function stop() { }
};

/**
 * The VideoPlayer object is returned by Titanium.Media.createVideoPlayer and is useful for playing videos.
 * @since 0.9
 */
function Titanium_Media_VideoPlayer() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_Media_VideoPlayer.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_Media_VideoPlayer.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_Media_VideoPlayer.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_Media_VideoPlayer.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * indicates if a movie should automatically start playback when it is likely to finish uninterrupted based on e.g. network conditions. Defaults to true.
	 * @alias Titanium_Media_VideoPlayer.autoplay
	 * @property {Boolean}
	 */
	this.autoplay = false
	/**
	 * Get the indicates if a movie should automatically start playback when it is likely to finish uninterrupted based on e.g. network conditions. Defaults to true.
	 * @alias Titanium_Media_VideoPlayer.getAutoplay
	 * @return {Boolean}
	 */
	this.getAutoplay = function() { return this.autoplay; }
	/**
	 * Set the indicates if a movie should automatically start playback when it is likely to finish uninterrupted based on e.g. network conditions. Defaults to true.
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setAutoplay
	 */
	this.setAutoplay = function(value) { this.autoplay = value; }
	/**
	 * background color for the view. deprecated, set the background color on the view.
	 * @alias Titanium_Media_VideoPlayer.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the background color for the view. deprecated, set the background color on the view.
	 * @alias Titanium_Media_VideoPlayer.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the background color for the view. deprecated, set the background color on the view.
	 * @param {String} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_Media_VideoPlayer.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_Media_VideoPlayer.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_Media_VideoPlayer.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_Media_VideoPlayer.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_Media_VideoPlayer.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_Media_VideoPlayer.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_Media_VideoPlayer.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_Media_VideoPlayer.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_Media_VideoPlayer.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_Media_VideoPlayer.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_Media_VideoPlayer.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_Media_VideoPlayer.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_Media_VideoPlayer.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_Media_VideoPlayer.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Media_VideoPlayer.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Media_VideoPlayer.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_Media_VideoPlayer.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_Media_VideoPlayer.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * deprecated. use url property instead.
	 * @alias Titanium_Media_VideoPlayer.contentURL
	 * @property {String}
	 */
	this.contentURL = ''
	/**
	 * Get the deprecated. use url property instead.
	 * @alias Titanium_Media_VideoPlayer.getContentURL
	 * @return {String}
	 */
	this.getContentURL = function() { return this.contentURL; }
	/**
	 * Set the deprecated. use url property instead.
	 * @param {String} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setContentURL
	 */
	this.setContentURL = function(value) { this.contentURL = value; }
	/**
	 * The duration of the movie, or 0.0 if not known.
	 * @alias Titanium_Media_VideoPlayer.duration
	 * @property {Double}
	 */
	this.duration = 0.0
	/**
	 * Get the The duration of the movie, or 0.0 if not known.
	 * @alias Titanium_Media_VideoPlayer.getDuration
	 * @return {Double}
	 */
	this.getDuration = function() { return this.duration; }
	/**
	 * Set the The duration of the movie, or 0.0 if not known.
	 * @param {Double} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setDuration
	 */
	this.setDuration = function(value) { this.duration = value; }
	/**
	 * The end time of movie playback. Defaults to NaN, which indicates natural end time of the movie.
	 * @alias Titanium_Media_VideoPlayer.endPlaybackTime
	 * @property {Double}
	 */
	this.endPlaybackTime = 0.0
	/**
	 * Get the The end time of movie playback. Defaults to NaN, which indicates natural end time of the movie.
	 * @alias Titanium_Media_VideoPlayer.getEndPlaybackTime
	 * @return {Double}
	 */
	this.getEndPlaybackTime = function() { return this.endPlaybackTime; }
	/**
	 * Set the The end time of movie playback. Defaults to NaN, which indicates natural end time of the movie.
	 * @param {Double} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setEndPlaybackTime
	 */
	this.setEndPlaybackTime = function(value) { this.endPlaybackTime = value; }
	/**
	 * Determines if the movie is presented in the entire screen (obscuring all other application content). Default is false. Setting this property to true before the movie player's view is visible will have no effect.
	 * @alias Titanium_Media_VideoPlayer.fullscreen
	 * @property {Boolean}
	 */
	this.fullscreen = false
	/**
	 * Get the Determines if the movie is presented in the entire screen (obscuring all other application content). Default is false. Setting this property to true before the movie player's view is visible will have no effect.
	 * @alias Titanium_Media_VideoPlayer.getFullscreen
	 * @return {Boolean}
	 */
	this.getFullscreen = function() { return this.fullscreen; }
	/**
	 * Set the Determines if the movie is presented in the entire screen (obscuring all other application content). Default is false. Setting this property to true before the movie player's view is visible will have no effect.
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setFullscreen
	 */
	this.setFullscreen = function(value) { this.fullscreen = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_Media_VideoPlayer.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_Media_VideoPlayer.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * The start time of movie playback. Defaults to NaN, indicating the natural start time of the movie.
	 * @alias Titanium_Media_VideoPlayer.initialPlaybackTime
	 * @property {Double}
	 */
	this.initialPlaybackTime = 0.0
	/**
	 * Get the The start time of movie playback. Defaults to NaN, indicating the natural start time of the movie.
	 * @alias Titanium_Media_VideoPlayer.getInitialPlaybackTime
	 * @return {Double}
	 */
	this.getInitialPlaybackTime = function() { return this.initialPlaybackTime; }
	/**
	 * Set the The start time of movie playback. Defaults to NaN, indicating the natural start time of the movie.
	 * @param {Double} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setInitialPlaybackTime
	 */
	this.setInitialPlaybackTime = function(value) { this.initialPlaybackTime = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Media_VideoPlayer.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Media_VideoPlayer.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * Returns the network load state of the movie player.
	 * @alias Titanium_Media_VideoPlayer.loadState
	 * @property {Integer}
	 */
	this.loadState = 0
	/**
	 * Get the Returns the network load state of the movie player.
	 * @alias Titanium_Media_VideoPlayer.getLoadState
	 * @return {Integer}
	 */
	this.getLoadState = function() { return this.loadState; }
	/**
	 * Set the Returns the network load state of the movie player.
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setLoadState
	 */
	this.setLoadState = function(value) { this.loadState = value; }
	/**
	 * the media object, either a File or Blob.
	 * @alias Titanium_Media_VideoPlayer.media
	 * @property {Object}
	 */
	this.media = {}
	/**
	 * Get the the media object, either a File or Blob.
	 * @alias Titanium_Media_VideoPlayer.getMedia
	 * @return {Object}
	 */
	this.getMedia = function() { return this.media; }
	/**
	 * Set the the media object, either a File or Blob.
	 * @param {Object} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setMedia
	 */
	this.setMedia = function(value) { this.media = value; }
	/**
	 * The style of the playback controls. Defaults to Titanium.Media.VIDEO_CONTROL_DEFAULT
	 * @alias Titanium_Media_VideoPlayer.mediaControlStyle
	 * @property {Integer}
	 */
	this.mediaControlStyle = 0
	/**
	 * Get the The style of the playback controls. Defaults to Titanium.Media.VIDEO_CONTROL_DEFAULT
	 * @alias Titanium_Media_VideoPlayer.getMediaControlStyle
	 * @return {Integer}
	 */
	this.getMediaControlStyle = function() { return this.mediaControlStyle; }
	/**
	 * Set the The style of the playback controls. Defaults to Titanium.Media.VIDEO_CONTROL_DEFAULT
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setMediaControlStyle
	 */
	this.setMediaControlStyle = function(value) { this.mediaControlStyle = value; }
	/**
	 * The types of media in the movie, or Titanium.Media.VIDEO_MEDIA_TYPE_NONE if not known.
	 * @alias Titanium_Media_VideoPlayer.mediaTypes
	 * @property {Integer}
	 */
	this.mediaTypes = 0
	/**
	 * Get the The types of media in the movie, or Titanium.Media.VIDEO_MEDIA_TYPE_NONE if not known.
	 * @alias Titanium_Media_VideoPlayer.getMediaTypes
	 * @return {Integer}
	 */
	this.getMediaTypes = function() { return this.mediaTypes; }
	/**
	 * Set the The types of media in the movie, or Titanium.Media.VIDEO_MEDIA_TYPE_NONE if not known.
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setMediaTypes
	 */
	this.setMediaTypes = function(value) { this.mediaTypes = value; }
	/**
	 * deprecated in 3.2+ of the iPhone SDK - use mediaControlStyle. Provides the ability to set the control mode of the movie player. Defaults to Titanium.Media.VIDEO_CONTROL_DEFAULT.
	 * @alias Titanium_Media_VideoPlayer.movieControlMode
	 * @property {Integer}
	 */
	this.movieControlMode = 0
	/**
	 * Get the deprecated in 3.2+ of the iPhone SDK - use mediaControlStyle. Provides the ability to set the control mode of the movie player. Defaults to Titanium.Media.VIDEO_CONTROL_DEFAULT.
	 * @alias Titanium_Media_VideoPlayer.getMovieControlMode
	 * @return {Integer}
	 */
	this.getMovieControlMode = function() { return this.movieControlMode; }
	/**
	 * Set the deprecated in 3.2+ of the iPhone SDK - use mediaControlStyle. Provides the ability to set the control mode of the movie player. Defaults to Titanium.Media.VIDEO_CONTROL_DEFAULT.
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setMovieControlMode
	 */
	this.setMovieControlMode = function(value) { this.movieControlMode = value; }
	/**
	 * returns a dictionary with properties width and height. Returns the natural size of the movie or 0 for both properties if not known or applicable.
	 * @alias Titanium_Media_VideoPlayer.naturalSize
	 * @property {Object}
	 */
	this.naturalSize = {}
	/**
	 * Get the returns a dictionary with properties width and height. Returns the natural size of the movie or 0 for both properties if not known or applicable.
	 * @alias Titanium_Media_VideoPlayer.getNaturalSize
	 * @return {Object}
	 */
	this.getNaturalSize = function() { return this.naturalSize; }
	/**
	 * Set the returns a dictionary with properties width and height. Returns the natural size of the movie or 0 for both properties if not known or applicable.
	 * @param {Object} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setNaturalSize
	 */
	this.setNaturalSize = function(value) { this.naturalSize = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_Media_VideoPlayer.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_Media_VideoPlayer.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * The currently playable duration of the movie, for progressively downloaded network content.
	 * @alias Titanium_Media_VideoPlayer.playableDuration
	 * @property {Double}
	 */
	this.playableDuration = 0.0
	/**
	 * Get the The currently playable duration of the movie, for progressively downloaded network content.
	 * @alias Titanium_Media_VideoPlayer.getPlayableDuration
	 * @return {Double}
	 */
	this.getPlayableDuration = function() { return this.playableDuration; }
	/**
	 * Set the The currently playable duration of the movie, for progressively downloaded network content.
	 * @param {Double} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setPlayableDuration
	 */
	this.setPlayableDuration = function(value) { this.playableDuration = value; }
	/**
	 * Returns the current playback state of the music player
	 * @alias Titanium_Media_VideoPlayer.playbackState
	 * @property {Integer}
	 */
	this.playbackState = 0
	/**
	 * Get the Returns the current playback state of the music player
	 * @alias Titanium_Media_VideoPlayer.getPlaybackState
	 * @return {Integer}
	 */
	this.getPlaybackState = function() { return this.playbackState; }
	/**
	 * Set the Returns the current playback state of the music player
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setPlaybackState
	 */
	this.setPlaybackState = function(value) { this.playbackState = value; }
	/**
	 * Boolean to indicate if the player has started playing.
	 * @alias Titanium_Media_VideoPlayer.playing
	 * @property {Boolean}
	 */
	this.playing = false
	/**
	 * Get the Boolean to indicate if the player has started playing.
	 * @alias Titanium_Media_VideoPlayer.getPlaying
	 * @return {Boolean}
	 */
	this.getPlaying = function() { return this.playing; }
	/**
	 * Set the Boolean to indicate if the player has started playing.
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setPlaying
	 */
	this.setPlaying = function(value) { this.playing = value; }
	/**
	 * Determines how the movie player repeats when reaching the end of playback. Defaults to Titanium.Media.VIDEO_REPEAT_MODE_NONE.
	 * @alias Titanium_Media_VideoPlayer.repeatMode
	 * @property {Integer}
	 */
	this.repeatMode = 0
	/**
	 * Get the Determines how the movie player repeats when reaching the end of playback. Defaults to Titanium.Media.VIDEO_REPEAT_MODE_NONE.
	 * @alias Titanium_Media_VideoPlayer.getRepeatMode
	 * @return {Integer}
	 */
	this.getRepeatMode = function() { return this.repeatMode; }
	/**
	 * Set the Determines how the movie player repeats when reaching the end of playback. Defaults to Titanium.Media.VIDEO_REPEAT_MODE_NONE.
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setRepeatMode
	 */
	this.setRepeatMode = function(value) { this.repeatMode = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Media_VideoPlayer.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Media_VideoPlayer.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * Determines how the content scales to fit the view. Defaults to Titanium.Media.VIDEO_SCALING_ASPECT_FIT.
	 * @alias Titanium_Media_VideoPlayer.scalingMode
	 * @property {Integer}
	 */
	this.scalingMode = 0
	/**
	 * Get the Determines how the content scales to fit the view. Defaults to Titanium.Media.VIDEO_SCALING_ASPECT_FIT.
	 * @alias Titanium_Media_VideoPlayer.getScalingMode
	 * @return {Integer}
	 */
	this.getScalingMode = function() { return this.scalingMode; }
	/**
	 * Set the Determines how the content scales to fit the view. Defaults to Titanium.Media.VIDEO_SCALING_ASPECT_FIT.
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setScalingMode
	 */
	this.setScalingMode = function(value) { this.scalingMode = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_Media_VideoPlayer.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_Media_VideoPlayer.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * The playback type of the movie. Defaults to Titanium.Media.VIDEO_SOURCE_TYPE_UNKNOWN. Specifying a playback type before playing the movie can result in faster load times.
	 * @alias Titanium_Media_VideoPlayer.sourceType
	 * @property {Integer}
	 */
	this.sourceType = 0
	/**
	 * Get the The playback type of the movie. Defaults to Titanium.Media.VIDEO_SOURCE_TYPE_UNKNOWN. Specifying a playback type before playing the movie can result in faster load times.
	 * @alias Titanium_Media_VideoPlayer.getSourceType
	 * @return {Integer}
	 */
	this.getSourceType = function() { return this.sourceType; }
	/**
	 * Set the The playback type of the movie. Defaults to Titanium.Media.VIDEO_SOURCE_TYPE_UNKNOWN. Specifying a playback type before playing the movie can result in faster load times.
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setSourceType
	 */
	this.setSourceType = function(value) { this.sourceType = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Media_VideoPlayer.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_Media_VideoPlayer.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_Media_VideoPlayer.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_Media_VideoPlayer.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_Media_VideoPlayer.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_Media_VideoPlayer.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * url of the media.
	 * @alias Titanium_Media_VideoPlayer.url
	 * @property {String}
	 */
	this.url = ''
	/**
	 * Get the url of the media.
	 * @alias Titanium_Media_VideoPlayer.getUrl
	 * @return {String}
	 */
	this.getUrl = function() { return this.url; }
	/**
	 * Set the url of the media.
	 * @param {String} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setUrl
	 */
	this.setUrl = function(value) { this.url = value; }
	/**
	 * Indicates if the movie player should inherit the application's audio session instead of creating a new session (which would interrupt the application's session). Defaults to true. Setting this property during playback will not take effect until playback is stopped and started again.
	 * @alias Titanium_Media_VideoPlayer.useApplicationAudioSession
	 * @property {Boolean}
	 */
	this.useApplicationAudioSession = false
	/**
	 * Get the Indicates if the movie player should inherit the application's audio session instead of creating a new session (which would interrupt the application's session). Defaults to true. Setting this property during playback will not take effect until playback is stopped and started again.
	 * @alias Titanium_Media_VideoPlayer.getUseApplicationAudioSession
	 * @return {Boolean}
	 */
	this.getUseApplicationAudioSession = function() { return this.useApplicationAudioSession; }
	/**
	 * Set the Indicates if the movie player should inherit the application's audio session instead of creating a new session (which would interrupt the application's session). Defaults to true. Setting this property during playback will not take effect until playback is stopped and started again.
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setUseApplicationAudioSession
	 */
	this.setUseApplicationAudioSession = function(value) { this.useApplicationAudioSession = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_Media_VideoPlayer.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_Media_VideoPlayer.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_Media_VideoPlayer.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_Media_VideoPlayer.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_Media_VideoPlayer.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_Media_VideoPlayer.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Media_VideoPlayer.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_Media_VideoPlayer.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_Media_VideoPlayer.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_Media_VideoPlayer.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * Cancels all pending asynchronous thumbnail requests.
	 * @alias Titanium_Media_VideoPlayer.cancelAllThumbnailImageRequests
	 */
	this.cancelAllThumbnailImageRequests = function cancelAllThumbnailImageRequests() { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_Media_VideoPlayer.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_Media_VideoPlayer.hide
	 */
	this.hide = function hide() { }
	/**
	 * start playing the video
	 * @alias Titanium_Media_VideoPlayer.play
	 */
	this.play = function play() { }
	/**
	 * release the internal video resources immediately.  this is not usually necessary but can help if you no longer need to use the player after it is used to help converse memory.
	 * @alias Titanium_Media_VideoPlayer.release
	 */
	this.release = function release() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_Media_VideoPlayer.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_Media_VideoPlayer.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * Asynchronously request thumbnails for one or more times, provided as an array of numbers (double). Fires a thumbnail event on completion. Optionally invokes the callback function passed in the method.
	 * @param {Array} times array of doubles for each time to request
	 * @param {Integer} option either [[Titanium.Media.VIDEO_TIME_OPTION_NEAREST_KEYFRAME]] or [[Titanium.Media.VIDEO_TIME_OPTION_EXACT]].
	 * @alias Titanium_Media_VideoPlayer.requestThumbnailImagesAtTimes
	 */
	this.requestThumbnailImagesAtTimes = function requestThumbnailImagesAtTimes(times,option) { }
	/**
	 * A view for customization which is always displayed behind movie content.
	 * @param {Object} view view to set
	 * @alias Titanium_Media_VideoPlayer.setBackgroundView
	 */
	this.setBackgroundView = function setBackgroundView(view) { }
	/**
	 * the a non-url based media to play, either a File or Blob.
	 * @param {Object} media media to play
	 * @alias Titanium_Media_VideoPlayer.setMedia
	 */
	this.setMedia = function setMedia(media) { }
	/**
	 * the url to play
	 * @param {String} url the url to play
	 * @alias Titanium_Media_VideoPlayer.setUrl
	 */
	this.setUrl = function setUrl(url) { }
	/**
	 * make the view visible
	 * @alias Titanium_Media_VideoPlayer.show
	 */
	this.show = function show() { }
	/**
	 * stop playing the video
	 * @alias Titanium_Media_VideoPlayer.stop
	 */
	this.stop = function stop() { }
	/**
	 * Returns a thumbnail at the given time as a blob.
	 * @param {Double} time playback time
	 * @param {Integer} option either [[Titanium.Media.VIDEO_TIME_OPTION_NEAREST_KEYFRAME]] or [[Titanium.Media.VIDEO_TIME_OPTION_EXACT]]
	 * @alias Titanium_Media_VideoPlayer.thumbnailImageAtTime
	 * @return {Object}
	 */
	this.thumbnailImageAtTime = function thumbnailImageAtTime(time,option) { return {}; }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_Media_VideoPlayer.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * The BonjourBrowser instance returned from Titanium.Network.createBonjourBrowser.  This object is a browser for the discovery and retrieval of Bonjour services available on the network.
 * @since 1.2.0
 */
function Titanium_Network_BonjourBrowser() {
	/**
	 * The domain the browser is searching in
	 * @alias Titanium_Network_BonjourBrowser.domain
	 * @property {String}
	 */
	this.domain = ''
	/**
	 * Get the The domain the browser is searching in
	 * @alias Titanium_Network_BonjourBrowser.getDomain
	 * @return {String}
	 */
	this.getDomain = function() { return this.domain; }
	/**
	 * Set the The domain the browser is searching in
	 * @param {String} value New value to set.
	 * @alias Titanium_Network_BonjourBrowser.setDomain
	 */
	this.setDomain = function(value) { this.domain = value; }
	/**
	 * Whether or not the browser is currently searching
	 * @alias Titanium_Network_BonjourBrowser.isSearching
	 * @property {Boolean}
	 */
	this.isSearching = false
	/**
	 * Get the Whether or not the browser is currently searching
	 * @alias Titanium_Network_BonjourBrowser.getIsSearching
	 * @return {Boolean}
	 */
	this.getIsSearching = function() { return this.isSearching; }
	/**
	 * Set the Whether or not the browser is currently searching
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Network_BonjourBrowser.setIsSearching
	 */
	this.setIsSearching = function(value) { this.isSearching = value; }
	/**
	 * The type of the service the browser searches for
	 * @alias Titanium_Network_BonjourBrowser.serviceType
	 * @property {String}
	 */
	this.serviceType = ''
	/**
	 * Get the The type of the service the browser searches for
	 * @alias Titanium_Network_BonjourBrowser.getServiceType
	 * @return {String}
	 */
	this.getServiceType = function() { return this.serviceType; }
	/**
	 * Set the The type of the service the browser searches for
	 * @param {String} value New value to set.
	 * @alias Titanium_Network_BonjourBrowser.setServiceType
	 */
	this.setServiceType = function(value) { this.serviceType = value; }
	/**
	 * Conduct a search for Bonjour services matching the type and domain specified during creation
	 * @alias Titanium_Network_BonjourBrowser.search
	 */
	this.search = function search() { }
	/**
	 * Halt an ongoing search
	 * @alias Titanium_Network_BonjourBrowser.stopSearch
	 */
	this.stopSearch = function stopSearch() { }
};

/**
 * The BonjourService instance returned either from Titanium.Network.createBonjourService or via the service list from a BonjourBrowser updatedServices event.  This object describes a service on the network which is published by Bonjour.
 * @since 1.2.0
 */
function Titanium_Network_BonjourService() {
	/**
	 * the domain of the service
	 * @alias Titanium_Network_BonjourService.domain
	 * @property {String}
	 */
	this.domain = ''
	/**
	 * Get the the domain of the service
	 * @alias Titanium_Network_BonjourService.getDomain
	 * @return {String}
	 */
	this.getDomain = function() { return this.domain; }
	/**
	 * Set the the domain of the service
	 * @param {String} value New value to set.
	 * @alias Titanium_Network_BonjourService.setDomain
	 */
	this.setDomain = function(value) { this.domain = value; }
	/**
	 * the name of the service
	 * @alias Titanium_Network_BonjourService.name
	 * @property {String}
	 */
	this.name = ''
	/**
	 * Get the the name of the service
	 * @alias Titanium_Network_BonjourService.getName
	 * @return {String}
	 */
	this.getName = function() { return this.name; }
	/**
	 * Set the the name of the service
	 * @param {String} value New value to set.
	 * @alias Titanium_Network_BonjourService.setName
	 */
	this.setName = function(value) { this.name = value; }
	/**
	 * the TCPSocket object that is used to connect to the service
	 * @alias Titanium_Network_BonjourService.socket
	 * @property {Object}
	 */
	this.socket = {}
	/**
	 * Get the the TCPSocket object that is used to connect to the service
	 * @alias Titanium_Network_BonjourService.getSocket
	 * @return {Object}
	 */
	this.getSocket = function() { return this.socket; }
	/**
	 * Set the the TCPSocket object that is used to connect to the service
	 * @param {Object} value New value to set.
	 * @alias Titanium_Network_BonjourService.setSocket
	 */
	this.setSocket = function(value) { this.socket = value; }
	/**
	 * the type of the service
	 * @alias Titanium_Network_BonjourService.type
	 * @property {String}
	 */
	this.type = ''
	/**
	 * Get the the type of the service
	 * @alias Titanium_Network_BonjourService.getType
	 * @return {String}
	 */
	this.getType = function() { return this.type; }
	/**
	 * Set the the type of the service
	 * @param {String} value New value to set.
	 * @alias Titanium_Network_BonjourService.setType
	 */
	this.setType = function(value) { this.type = value; }
	/**
	 * whether or not the service is local to the device
	 * @alias Titanium_Network_BonjourService.isLocal
	 */
	this.isLocal = function isLocal() { }
	/**
	 * Publish a Bonjour service to the network.  Only works if isLocal is TRUE
	 * @param {Object} socket a TCPSocket object to associate with the Bonjour service.
	 * @alias Titanium_Network_BonjourService.publish
	 */
	this.publish = function publish(socket) { }
	/**
	 * Resolve a Bonjour service from the network.  Must be done before attempting to access the service's socket information, if a remote service.  You cannot resolve a locally published service.
	 * @param {Double} timeout the timeout for service resolution, in seconds.  Optional, default is 120s.
	 * @alias Titanium_Network_BonjourService.resolve
	 */
	this.resolve = function resolve(timeout) { }
	/**
	 * Halts publication of a service.
	 * @alias Titanium_Network_BonjourService.stop
	 */
	this.stop = function stop() { }
};

/**
 * The HttpClient instance returned from Titanium.Network.createHTTPClient. This object (mostly) implements the XMLHttpRequest specification.
 * @since 0.1
 */
function Titanium_Network_HTTPClient() {
	/**
	 * boolean to indicate that the response was successful
	 * @alias Titanium_Network_HTTPClient.connected
	 * @property {Boolean}
	 */
	this.connected = false
	/**
	 * Get the boolean to indicate that the response was successful
	 * @alias Titanium_Network_HTTPClient.getConnected
	 * @return {Boolean}
	 */
	this.getConnected = function() { return this.connected; }
	/**
	 * Set the boolean to indicate that the response was successful
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Network_HTTPClient.setConnected
	 */
	this.setConnected = function(value) { this.connected = value; }
	/**
	 * the connection type, normally either GET or POST.
	 * @alias Titanium_Network_HTTPClient.connectionType
	 * @property {String}
	 */
	this.connectionType = ''
	/**
	 * Get the the connection type, normally either GET or POST.
	 * @alias Titanium_Network_HTTPClient.getConnectionType
	 * @return {String}
	 */
	this.getConnectionType = function() { return this.connectionType; }
	/**
	 * Set the the connection type, normally either GET or POST.
	 * @param {String} value New value to set.
	 * @alias Titanium_Network_HTTPClient.setConnectionType
	 */
	this.setConnectionType = function(value) { this.connectionType = value; }
	/**
	 * the absolute URL of the request
	 * @alias Titanium_Network_HTTPClient.location
	 * @property {String}
	 */
	this.location = ''
	/**
	 * Get the the absolute URL of the request
	 * @alias Titanium_Network_HTTPClient.getLocation
	 * @return {String}
	 */
	this.getLocation = function() { return this.location; }
	/**
	 * Set the the absolute URL of the request
	 * @param {String} value New value to set.
	 * @alias Titanium_Network_HTTPClient.setLocation
	 */
	this.setLocation = function(value) { this.location = value; }
	/**
	 * set this to a function before calling open to cause the function to be called at regular intervals as the request data is being received. the progress property of the event will contain a value from 0.0-1.0 with the progress.
	 * @alias Titanium_Network_HTTPClient.ondatastream
	 * @property {Function}
	 */
	this.ondatastream = {}
	/**
	 * Get the set this to a function before calling open to cause the function to be called at regular intervals as the request data is being received. the progress property of the event will contain a value from 0.0-1.0 with the progress.
	 * @alias Titanium_Network_HTTPClient.getOndatastream
	 * @return {Function}
	 */
	this.getOndatastream = function() { return this.ondatastream; }
	/**
	 * Set the set this to a function before calling open to cause the function to be called at regular intervals as the request data is being received. the progress property of the event will contain a value from 0.0-1.0 with the progress.
	 * @param {Function} value New value to set.
	 * @alias Titanium_Network_HTTPClient.setOndatastream
	 */
	this.setOndatastream = function(value) { this.ondatastream = value; }
	/**
	 * set this to a function before calling open to cause the function to be called upon a error response
	 * @alias Titanium_Network_HTTPClient.onerror
	 * @property {Function}
	 */
	this.onerror = {}
	/**
	 * Get the set this to a function before calling open to cause the function to be called upon a error response
	 * @alias Titanium_Network_HTTPClient.getOnerror
	 * @return {Function}
	 */
	this.getOnerror = function() { return this.onerror; }
	/**
	 * Set the set this to a function before calling open to cause the function to be called upon a error response
	 * @param {Function} value New value to set.
	 * @alias Titanium_Network_HTTPClient.setOnerror
	 */
	this.setOnerror = function(value) { this.onerror = value; }
	/**
	 * set this to a function before calling open to cause the function to be called upon a successful response
	 * @alias Titanium_Network_HTTPClient.onload
	 * @property {Function}
	 */
	this.onload = {}
	/**
	 * Get the set this to a function before calling open to cause the function to be called upon a successful response
	 * @alias Titanium_Network_HTTPClient.getOnload
	 * @return {Function}
	 */
	this.getOnload = function() { return this.onload; }
	/**
	 * Set the set this to a function before calling open to cause the function to be called upon a successful response
	 * @param {Function} value New value to set.
	 * @alias Titanium_Network_HTTPClient.setOnload
	 */
	this.setOnload = function(value) { this.onload = value; }
	/**
	 * set this to a function before calling open to cause the function to be called for each readyState change
	 * @alias Titanium_Network_HTTPClient.onreadystatechange
	 * @property {Function}
	 */
	this.onreadystatechange = {}
	/**
	 * Get the set this to a function before calling open to cause the function to be called for each readyState change
	 * @alias Titanium_Network_HTTPClient.getOnreadystatechange
	 * @return {Function}
	 */
	this.getOnreadystatechange = function() { return this.onreadystatechange; }
	/**
	 * Set the set this to a function before calling open to cause the function to be called for each readyState change
	 * @param {Function} value New value to set.
	 * @alias Titanium_Network_HTTPClient.setOnreadystatechange
	 */
	this.setOnreadystatechange = function(value) { this.onreadystatechange = value; }
	/**
	 * set this to a function before calling open to cause the function to be called at regular intervals as the request data is being transmitted. the progress property of the event will contain a value from 0.0-1.0 with the progress.
	 * @alias Titanium_Network_HTTPClient.onsendstream
	 * @property {Function}
	 */
	this.onsendstream = {}
	/**
	 * Get the set this to a function before calling open to cause the function to be called at regular intervals as the request data is being transmitted. the progress property of the event will contain a value from 0.0-1.0 with the progress.
	 * @alias Titanium_Network_HTTPClient.getOnsendstream
	 * @return {Function}
	 */
	this.getOnsendstream = function() { return this.onsendstream; }
	/**
	 * Set the set this to a function before calling open to cause the function to be called at regular intervals as the request data is being transmitted. the progress property of the event will contain a value from 0.0-1.0 with the progress.
	 * @param {Function} value New value to set.
	 * @alias Titanium_Network_HTTPClient.setOnsendstream
	 */
	this.setOnsendstream = function(value) { this.onsendstream = value; }
	/**
	 * the readyState value
	 * @alias Titanium_Network_HTTPClient.readyState
	 * @property {Integer}
	 */
	this.readyState = 0
	/**
	 * Get the the readyState value
	 * @alias Titanium_Network_HTTPClient.getReadyState
	 * @return {Integer}
	 */
	this.getReadyState = function() { return this.readyState; }
	/**
	 * Set the the readyState value
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Network_HTTPClient.setReadyState
	 */
	this.setReadyState = function(value) { this.readyState = value; }
	/**
	 * the response data as a Blob object.
	 * @alias Titanium_Network_HTTPClient.responseData
	 * @property {Object}
	 */
	this.responseData = {}
	/**
	 * Get the the response data as a Blob object.
	 * @alias Titanium_Network_HTTPClient.getResponseData
	 * @return {Object}
	 */
	this.getResponseData = function() { return this.responseData; }
	/**
	 * Set the the response data as a Blob object.
	 * @param {Object} value New value to set.
	 * @alias Titanium_Network_HTTPClient.setResponseData
	 */
	this.setResponseData = function(value) { this.responseData = value; }
	/**
	 * the response as text or null if an error was received or no data was returned
	 * @alias Titanium_Network_HTTPClient.responseText
	 * @property {String}
	 */
	this.responseText = ''
	/**
	 * Get the the response as text or null if an error was received or no data was returned
	 * @alias Titanium_Network_HTTPClient.getResponseText
	 * @return {String}
	 */
	this.getResponseText = function() { return this.responseText; }
	/**
	 * Set the the response as text or null if an error was received or no data was returned
	 * @param {String} value New value to set.
	 * @alias Titanium_Network_HTTPClient.setResponseText
	 */
	this.setResponseText = function(value) { this.responseText = value; }
	/**
	 * the response object as an XML DOMDocument object. returns null if the content type returned by the server was not XML or the content could not be parsed
	 * @alias Titanium_Network_HTTPClient.responseXML
	 * @property {Object}
	 */
	this.responseXML = {}
	/**
	 * Get the the response object as an XML DOMDocument object. returns null if the content type returned by the server was not XML or the content could not be parsed
	 * @alias Titanium_Network_HTTPClient.getResponseXML
	 * @return {Object}
	 */
	this.getResponseXML = function() { return this.responseXML; }
	/**
	 * Set the the response object as an XML DOMDocument object. returns null if the content type returned by the server was not XML or the content could not be parsed
	 * @param {Object} value New value to set.
	 * @alias Titanium_Network_HTTPClient.setResponseXML
	 */
	this.setResponseXML = function(value) { this.responseXML = value; }
	/**
	 * the response HTTP status code
	 * @alias Titanium_Network_HTTPClient.status
	 * @property {Integer}
	 */
	this.status = 0
	/**
	 * Get the the response HTTP status code
	 * @alias Titanium_Network_HTTPClient.getStatus
	 * @return {Integer}
	 */
	this.getStatus = function() { return this.status; }
	/**
	 * Set the the response HTTP status code
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Network_HTTPClient.setStatus
	 */
	this.setStatus = function(value) { this.status = value; }
	/**
	 * timeout is milliseconds when the connection should be aborted
	 * @alias Titanium_Network_HTTPClient.timeout
	 * @property {Integer}
	 */
	this.timeout = 0
	/**
	 * Get the timeout is milliseconds when the connection should be aborted
	 * @alias Titanium_Network_HTTPClient.getTimeout
	 * @return {Integer}
	 */
	this.getTimeout = function() { return this.timeout; }
	/**
	 * Set the timeout is milliseconds when the connection should be aborted
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Network_HTTPClient.setTimeout
	 */
	this.setTimeout = function(value) { this.timeout = value; }
	/**
	 * set this to control how SSL certification validation is performed on connection.  defaults to false if in simulator or device testing and true if release for distribution mode.
	 * @alias Titanium_Network_HTTPClient.validatesSecureCertificate
	 * @property {Boolean}
	 */
	this.validatesSecureCertificate = false
	/**
	 * Get the set this to control how SSL certification validation is performed on connection.  defaults to false if in simulator or device testing and true if release for distribution mode.
	 * @alias Titanium_Network_HTTPClient.getValidatesSecureCertificate
	 * @return {Boolean}
	 */
	this.getValidatesSecureCertificate = function() { return this.validatesSecureCertificate; }
	/**
	 * Set the set this to control how SSL certification validation is performed on connection.  defaults to false if in simulator or device testing and true if release for distribution mode.
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_Network_HTTPClient.setValidatesSecureCertificate
	 */
	this.setValidatesSecureCertificate = function(value) { this.validatesSecureCertificate = value; }
	/**
	 * abort a pending request
	 * @alias Titanium_Network_HTTPClient.abort
	 */
	this.abort = function abort() { }
	/**
	 * return the response header.
	 * @param {String} name the header name
	 * @alias Titanium_Network_HTTPClient.getResponseHeader
	 * @return {String}
	 */
	this.getResponseHeader = function getResponseHeader(name) { return ''; }
	/**
	 * open the request and ready the connection
	 * @param {String} method the HTTP method
	 * @param {String} url the URL for the request
	 * @param {Boolean} [async] optional property to indicate if asynchronous (default) or not
	 * @alias Titanium_Network_HTTPClient.open
	 */
	this.open = function open(method,url,async) { }
	/**
	 * send the request
	 * @param {Object} data the data to send in the request. can either be null, dictionary, string, File object or Blob.
	 * @alias Titanium_Network_HTTPClient.send
	 */
	this.send = function send(data) { }
	/**
	 * set the request header. Must be called after open but before send.
	 * @param {String} name name of the header
	 * @param {String} value value of the header
	 * @alias Titanium_Network_HTTPClient.setRequestHeader
	 */
	this.setRequestHeader = function setRequestHeader(name,value) { }
	/**
	 * set the request timeout
	 * @param {Double} timeout the timeout in milliseconds
	 * @alias Titanium_Network_HTTPClient.setTimeout
	 */
	this.setTimeout = function setTimeout(timeout) { }
};

/**
 * The TCPSocket instance returned from Titanium.Network.createTCPSocket.  This object represents a socket which either listens locally on the device for connections, or connects to a remote machine.
 * @since 1.2.0
 */
function Titanium_Network_TCPSocket() {
	/**
	 * the host name to connect to.  Must be INADDR_ANY or an identifier for the local device in order to listen
	 * @alias Titanium_Network_TCPSocket.hostName
	 * @property {String}
	 */
	this.hostName = ''
	/**
	 * Get the the host name to connect to.  Must be INADDR_ANY or an identifier for the local device in order to listen
	 * @alias Titanium_Network_TCPSocket.getHostName
	 * @return {String}
	 */
	this.getHostName = function() { return this.hostName; }
	/**
	 * Set the the host name to connect to.  Must be INADDR_ANY or an identifier for the local device in order to listen
	 * @param {String} value New value to set.
	 * @alias Titanium_Network_TCPSocket.setHostName
	 */
	this.setHostName = function(value) { this.hostName = value; }
	/**
	 * the socket's mode
	 * @alias Titanium_Network_TCPSocket.mode
	 * @property {Integer}
	 */
	this.mode = 0
	/**
	 * Get the the socket's mode
	 * @alias Titanium_Network_TCPSocket.getMode
	 * @return {Integer}
	 */
	this.getMode = function() { return this.mode; }
	/**
	 * Set the the socket's mode
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Network_TCPSocket.setMode
	 */
	this.setMode = function(value) { this.mode = value; }
	/**
	 * the port to connect/listen on
	 * @alias Titanium_Network_TCPSocket.port
	 * @property {Integer}
	 */
	this.port = 0
	/**
	 * Get the the port to connect/listen on
	 * @alias Titanium_Network_TCPSocket.getPort
	 * @return {Integer}
	 */
	this.getPort = function() { return this.port; }
	/**
	 * Set the the port to connect/listen on
	 * @param {Integer} value New value to set.
	 * @alias Titanium_Network_TCPSocket.setPort
	 */
	this.setPort = function(value) { this.port = value; }
	/**
	 * close the socket
	 * @alias Titanium_Network_TCPSocket.close
	 */
	this.close = function close() { }
	/**
	 * connect the scocket to a TCP server
	 * @alias Titanium_Network_TCPSocket.connect
	 */
	this.connect = function connect() { }
	/**
	 * whether or not the socket is valid
	 * @alias Titanium_Network_TCPSocket.isValid
	 */
	this.isValid = function isValid() { }
	/**
	 * set up the socket to receive connections
	 * @alias Titanium_Network_TCPSocket.listen
	 */
	this.listen = function listen() { }
	/**
	 * write data to the socket, if the mode is WRITE_MODE or READ_WRITE_MODE
	 * @param {Object,String} data either a string or blob object representing the data to be transferred
	 * @param {Integer} sendTo the socket reference to send the data to.  Default is to send to all connected sockets
	 * @alias Titanium_Network_TCPSocket.write
	 */
	this.write = function write(data,sendTo) { }
};

/**
 * The 2DMatrix is created by Titanium.UI.create2DMatrix.  The 2D Matrix is an object for holding values for an affine transformation matrix. A 2D matrix is used to rotate, scale, translate, or skew the objects in a two-dimensional space. A 2D matrix is represented by a 3 by 3 matrix. Because the third column is always (0,0,1), the data structure contains values for only the first two columns.
 * @since 0.9
 */
function Titanium_UI_2DMatrix() {
	/**
	 * The entry at position [1,1] in the matrix.
	 * @alias Titanium_UI_2DMatrix.a
	 * @property {Float}
	 */
	this.a = 0.0
	/**
	 * Get the The entry at position [1,1] in the matrix.
	 * @alias Titanium_UI_2DMatrix.getA
	 * @return {Float}
	 */
	this.getA = function() { return this.a; }
	/**
	 * Set the The entry at position [1,1] in the matrix.
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_2DMatrix.setA
	 */
	this.setA = function(value) { this.a = value; }
	/**
	 * The entry at position [1,2] in the matrix.
	 * @alias Titanium_UI_2DMatrix.b
	 * @property {Float}
	 */
	this.b = 0.0
	/**
	 * Get the The entry at position [1,2] in the matrix.
	 * @alias Titanium_UI_2DMatrix.getB
	 * @return {Float}
	 */
	this.getB = function() { return this.b; }
	/**
	 * Set the The entry at position [1,2] in the matrix.
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_2DMatrix.setB
	 */
	this.setB = function(value) { this.b = value; }
	/**
	 * The entry at position [2,1] in the matrix.
	 * @alias Titanium_UI_2DMatrix.c
	 * @property {Float}
	 */
	this.c = 0.0
	/**
	 * Get the The entry at position [2,1] in the matrix.
	 * @alias Titanium_UI_2DMatrix.getC
	 * @return {Float}
	 */
	this.getC = function() { return this.c; }
	/**
	 * Set the The entry at position [2,1] in the matrix.
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_2DMatrix.setC
	 */
	this.setC = function(value) { this.c = value; }
	/**
	 * The entry at position [2,2] in the matrix.
	 * @alias Titanium_UI_2DMatrix.d
	 * @property {Float}
	 */
	this.d = 0.0
	/**
	 * Get the The entry at position [2,2] in the matrix.
	 * @alias Titanium_UI_2DMatrix.getD
	 * @return {Float}
	 */
	this.getD = function() { return this.d; }
	/**
	 * Set the The entry at position [2,2] in the matrix.
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_2DMatrix.setD
	 */
	this.setD = function(value) { this.d = value; }
	/**
	 * The entry at position [3,1] in the matrix.
	 * @alias Titanium_UI_2DMatrix.tx
	 * @property {Float}
	 */
	this.tx = 0.0
	/**
	 * Get the The entry at position [3,1] in the matrix.
	 * @alias Titanium_UI_2DMatrix.getTx
	 * @return {Float}
	 */
	this.getTx = function() { return this.tx; }
	/**
	 * Set the The entry at position [3,1] in the matrix.
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_2DMatrix.setTx
	 */
	this.setTx = function(value) { this.tx = value; }
	/**
	 * The entry at position [3,2] in the matrix.
	 * @alias Titanium_UI_2DMatrix.ty
	 * @property {Float}
	 */
	this.ty = 0.0
	/**
	 * Get the The entry at position [3,2] in the matrix.
	 * @alias Titanium_UI_2DMatrix.getTy
	 * @return {Float}
	 */
	this.getTy = function() { return this.ty; }
	/**
	 * Set the The entry at position [3,2] in the matrix.
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_2DMatrix.setTy
	 */
	this.setTy = function(value) { this.ty = value; }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_2DMatrix.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_2DMatrix.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * Returns a matrix constructed by inverting an existing matrix
	 * @alias Titanium_UI_2DMatrix.invert
	 */
	this.invert = function invert() { }
	/**
	 * Returns a matrix constructed by combining two existing matrix.
	 * @param {Object} t2 The second matrix. This matrix is concatenated to the matrix instance against which the function is invoked.  The result of this function is the first matrix multiplied by the second matrix. You might perform several multiplications in order to create a single matrix that contains the cumulative effects of several transformations. Note that matrix operations are not commutative - the order in which you concatenate matrices is important. That is, the result of multiplying matrix t1 by matrix t2 does not necessarily equal the result of multiplying matrix t2 by matrix t1.
	 * @alias Titanium_UI_2DMatrix.multiply
	 * @return {Object}
	 */
	this.multiply = function multiply(t2) { return {}; }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_2DMatrix.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * Returns a matrix constructed by rotating an existing matrix
	 * @param {Float} angle The angle, in degrees, by which to rotate the matrix. A positive value specifies counterclockwise rotation and a negative value specifies clockwise rotation.
	 * @alias Titanium_UI_2DMatrix.rotate
	 * @return {Object}
	 */
	this.rotate = function rotate(angle) { return {}; }
	/**
	 * Returns a matrix constructed by scaling an existing matrix
	 * @param {Float} sx The value by which to scale x values of the matrix
	 * @param {Float} sy The value by which to scale y values of the matrix
	 * @alias Titanium_UI_2DMatrix.scale
	 * @return {Object}
	 */
	this.scale = function scale(sx,sy) { return {}; }
	/**
	 * Returns a matrix constructed by translating an existing matrix
	 * @param {Float} tx The value by which to move x values with the matrix
	 * @param {Float} ty The value by which to move y values with the matrix
	 * @alias Titanium_UI_2DMatrix.translate
	 * @return {Object}
	 */
	this.translate = function translate(tx,ty) { return {}; }
};

/**
 * The 2DMatrix is created by Titanium.UI.create2DMatrix.  The 2D Matrix is an object for holding values for an affine transformation matrix. A 2D matrix is used to rotate, scale, translate, or skew the objects in a three-dimensional space. A 3D matrix is represented by a 4 by 4 matrix. Because the forth column is always (0,0,1), the data structure contains values for only the first three columns.
 * @since 0.9
 */
function Titanium_UI_3DMatrix() {
	/**
	 * The entry at position [1,1] in the matrix.
	 * @alias Titanium_UI_3DMatrix.m11
	 * @property {Float}
	 */
	this.m11 = 0.0
	/**
	 * Get the The entry at position [1,1] in the matrix.
	 * @alias Titanium_UI_3DMatrix.getM11
	 * @return {Float}
	 */
	this.getM11 = function() { return this.m11; }
	/**
	 * Set the The entry at position [1,1] in the matrix.
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_3DMatrix.setM11
	 */
	this.setM11 = function(value) { this.m11 = value; }
	/**
	 * The entry at position [1,2] in the matrix.
	 * @alias Titanium_UI_3DMatrix.m12
	 * @property {Float}
	 */
	this.m12 = 0.0
	/**
	 * Get the The entry at position [1,2] in the matrix.
	 * @alias Titanium_UI_3DMatrix.getM12
	 * @return {Float}
	 */
	this.getM12 = function() { return this.m12; }
	/**
	 * Set the The entry at position [1,2] in the matrix.
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_3DMatrix.setM12
	 */
	this.setM12 = function(value) { this.m12 = value; }
	/**
	 * The entry at position [1,3] in the matrix.
	 * @alias Titanium_UI_3DMatrix.m13
	 * @property {Float}
	 */
	this.m13 = 0.0
	/**
	 * Get the The entry at position [1,3] in the matrix.
	 * @alias Titanium_UI_3DMatrix.getM13
	 * @return {Float}
	 */
	this.getM13 = function() { return this.m13; }
	/**
	 * Set the The entry at position [1,3] in the matrix.
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_3DMatrix.setM13
	 */
	this.setM13 = function(value) { this.m13 = value; }
	/**
	 * The entry at position [1,4] in the matrix.
	 * @alias Titanium_UI_3DMatrix.m14
	 * @property {Float}
	 */
	this.m14 = 0.0
	/**
	 * Get the The entry at position [1,4] in the matrix.
	 * @alias Titanium_UI_3DMatrix.getM14
	 * @return {Float}
	 */
	this.getM14 = function() { return this.m14; }
	/**
	 * Set the The entry at position [1,4] in the matrix.
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_3DMatrix.setM14
	 */
	this.setM14 = function(value) { this.m14 = value; }
	/**
	 * The entry at position [2,1] in the matrix.
	 * @alias Titanium_UI_3DMatrix.m21
	 * @property {Float}
	 */
	this.m21 = 0.0
	/**
	 * Get the The entry at position [2,1] in the matrix.
	 * @alias Titanium_UI_3DMatrix.getM21
	 * @return {Float}
	 */
	this.getM21 = function() { return this.m21; }
	/**
	 * Set the The entry at position [2,1] in the matrix.
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_3DMatrix.setM21
	 */
	this.setM21 = function(value) { this.m21 = value; }
	/**
	 * The entry at position [2,2] in the matrix.
	 * @alias Titanium_UI_3DMatrix.m22
	 * @property {Float}
	 */
	this.m22 = 0.0
	/**
	 * Get the The entry at position [2,2] in the matrix.
	 * @alias Titanium_UI_3DMatrix.getM22
	 * @return {Float}
	 */
	this.getM22 = function() { return this.m22; }
	/**
	 * Set the The entry at position [2,2] in the matrix.
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_3DMatrix.setM22
	 */
	this.setM22 = function(value) { this.m22 = value; }
	/**
	 * The entry at position [2,3] in the matrix.
	 * @alias Titanium_UI_3DMatrix.m23
	 * @property {Float}
	 */
	this.m23 = 0.0
	/**
	 * Get the The entry at position [2,3] in the matrix.
	 * @alias Titanium_UI_3DMatrix.getM23
	 * @return {Float}
	 */
	this.getM23 = function() { return this.m23; }
	/**
	 * Set the The entry at position [2,3] in the matrix.
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_3DMatrix.setM23
	 */
	this.setM23 = function(value) { this.m23 = value; }
	/**
	 * The entry at position [2,4] in the matrix.
	 * @alias Titanium_UI_3DMatrix.m24
	 * @property {Float}
	 */
	this.m24 = 0.0
	/**
	 * Get the The entry at position [2,4] in the matrix.
	 * @alias Titanium_UI_3DMatrix.getM24
	 * @return {Float}
	 */
	this.getM24 = function() { return this.m24; }
	/**
	 * Set the The entry at position [2,4] in the matrix.
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_3DMatrix.setM24
	 */
	this.setM24 = function(value) { this.m24 = value; }
	/**
	 * The entry at position [3,1] in the matrix.
	 * @alias Titanium_UI_3DMatrix.m31
	 * @property {Float}
	 */
	this.m31 = 0.0
	/**
	 * Get the The entry at position [3,1] in the matrix.
	 * @alias Titanium_UI_3DMatrix.getM31
	 * @return {Float}
	 */
	this.getM31 = function() { return this.m31; }
	/**
	 * Set the The entry at position [3,1] in the matrix.
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_3DMatrix.setM31
	 */
	this.setM31 = function(value) { this.m31 = value; }
	/**
	 * The entry at position [3,2] in the matrix.
	 * @alias Titanium_UI_3DMatrix.m32
	 * @property {Float}
	 */
	this.m32 = 0.0
	/**
	 * Get the The entry at position [3,2] in the matrix.
	 * @alias Titanium_UI_3DMatrix.getM32
	 * @return {Float}
	 */
	this.getM32 = function() { return this.m32; }
	/**
	 * Set the The entry at position [3,2] in the matrix.
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_3DMatrix.setM32
	 */
	this.setM32 = function(value) { this.m32 = value; }
	/**
	 * The entry at position [3,3] in the matrix.
	 * @alias Titanium_UI_3DMatrix.m33
	 * @property {Float}
	 */
	this.m33 = 0.0
	/**
	 * Get the The entry at position [3,3] in the matrix.
	 * @alias Titanium_UI_3DMatrix.getM33
	 * @return {Float}
	 */
	this.getM33 = function() { return this.m33; }
	/**
	 * Set the The entry at position [3,3] in the matrix.
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_3DMatrix.setM33
	 */
	this.setM33 = function(value) { this.m33 = value; }
	/**
	 * The entry at position [3,4] in the matrix.
	 * @alias Titanium_UI_3DMatrix.m34
	 * @property {Float}
	 */
	this.m34 = 0.0
	/**
	 * Get the The entry at position [3,4] in the matrix.
	 * @alias Titanium_UI_3DMatrix.getM34
	 * @return {Float}
	 */
	this.getM34 = function() { return this.m34; }
	/**
	 * Set the The entry at position [3,4] in the matrix.
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_3DMatrix.setM34
	 */
	this.setM34 = function(value) { this.m34 = value; }
	/**
	 * The entry at position [4,1] in the matrix.
	 * @alias Titanium_UI_3DMatrix.m41
	 * @property {Float}
	 */
	this.m41 = 0.0
	/**
	 * Get the The entry at position [4,1] in the matrix.
	 * @alias Titanium_UI_3DMatrix.getM41
	 * @return {Float}
	 */
	this.getM41 = function() { return this.m41; }
	/**
	 * Set the The entry at position [4,1] in the matrix.
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_3DMatrix.setM41
	 */
	this.setM41 = function(value) { this.m41 = value; }
	/**
	 * The entry at position [4,2] in the matrix.
	 * @alias Titanium_UI_3DMatrix.m42
	 * @property {Float}
	 */
	this.m42 = 0.0
	/**
	 * Get the The entry at position [4,2] in the matrix.
	 * @alias Titanium_UI_3DMatrix.getM42
	 * @return {Float}
	 */
	this.getM42 = function() { return this.m42; }
	/**
	 * Set the The entry at position [4,2] in the matrix.
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_3DMatrix.setM42
	 */
	this.setM42 = function(value) { this.m42 = value; }
	/**
	 * The entry at position [4,3] in the matrix.
	 * @alias Titanium_UI_3DMatrix.m43
	 * @property {Float}
	 */
	this.m43 = 0.0
	/**
	 * Get the The entry at position [4,3] in the matrix.
	 * @alias Titanium_UI_3DMatrix.getM43
	 * @return {Float}
	 */
	this.getM43 = function() { return this.m43; }
	/**
	 * Set the The entry at position [4,3] in the matrix.
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_3DMatrix.setM43
	 */
	this.setM43 = function(value) { this.m43 = value; }
	/**
	 * The entry at position [4,4] in the matrix.
	 * @alias Titanium_UI_3DMatrix.m44
	 * @property {Float}
	 */
	this.m44 = 0.0
	/**
	 * Get the The entry at position [4,4] in the matrix.
	 * @alias Titanium_UI_3DMatrix.getM44
	 * @return {Float}
	 */
	this.getM44 = function() { return this.m44; }
	/**
	 * Set the The entry at position [4,4] in the matrix.
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_3DMatrix.setM44
	 */
	this.setM44 = function(value) { this.m44 = value; }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_3DMatrix.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_3DMatrix.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * Returns a matrix constructed by inverting an existing matrix
	 * @alias Titanium_UI_3DMatrix.invert
	 */
	this.invert = function invert() { }
	/**
	 * Returns a matrix constructed by combining two existing matrix.
	 * @param {Object} t2 The second matrix. This matrix is concatenated to the matrix instance against which the function is invoked.  The result of this function is the first matrix multiplied by the second matrix. You might perform several multiplications in order to create a single matrix that contains the cumulative effects of several transformations. Note that matrix operations are not commutative - the order in which you concatenate matrices is important. That is, the result of multiplying matrix t1 by matrix t2 does not necessarily equal the result of multiplying matrix t2 by matrix t1.
	 * @alias Titanium_UI_3DMatrix.multiply
	 * @return {Object}
	 */
	this.multiply = function multiply(t2) { return {}; }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_3DMatrix.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * Returns a matrix constructed by rotating an existing matrix
	 * @param {Float} angle The angle, in degrees, by which to rotate the matrix. A positive value specifies counterclockwise rotation and a negative value specifies clockwise rotation.
	 * @param {Float} x The x part of the vector about which to rotate
	 * @param {Float} y The y part of the vector about which to rotate
	 * @param {Float} z The z part of the vector about which to rotate
	 * @alias Titanium_UI_3DMatrix.rotate
	 * @return {Object}
	 */
	this.rotate = function rotate(angle,x,y,z) { return {}; }
	/**
	 * Returns a matrix constructed by scaling an existing matrix
	 * @param {Float} sx The value by which to scale x values of the matrix
	 * @param {Float} sy The value by which to scale y values of the matrix
	 * @param {Float} sz The value by which to scale z values of the matrix
	 * @alias Titanium_UI_3DMatrix.scale
	 * @return {Object}
	 */
	this.scale = function scale(sx,sy,sz) { return {}; }
	/**
	 * Returns a matrix constructed by translating an existing matrix
	 * @param {Float} tx The value by which to move x values with the matrix
	 * @param {Float} ty The value by which to move y values with the matrix
	 * @param {Float} tz The value by which to move z values with the matrix
	 * @alias Titanium_UI_3DMatrix.translate
	 * @return {Object}
	 */
	this.translate = function translate(tx,ty,tz) { return {}; }
};

/**
 * An Activity Indicator is created by the method Titanium.UI.createActivityIndicator.  An activity indicator can be used to show the progress of an operation in the UI to let the user know some action is taking place.
 * @since 0.8
 */
function Titanium_UI_ActivityIndicator() {
	/**
	 * the color of the message label
	 * @alias Titanium_UI_ActivityIndicator.color
	 * @property {String}
	 */
	this.color = ''
	/**
	 * Get the the color of the message label
	 * @alias Titanium_UI_ActivityIndicator.getColor
	 * @return {String}
	 */
	this.getColor = function() { return this.color; }
	/**
	 * Set the the color of the message label
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_ActivityIndicator.setColor
	 */
	this.setColor = function(value) { this.color = value; }
	/**
	 * the font object for the activity message label
	 * @alias Titanium_UI_ActivityIndicator.font
	 * @property {Object}
	 */
	this.font = {}
	/**
	 * Get the the font object for the activity message label
	 * @alias Titanium_UI_ActivityIndicator.getFont
	 * @return {Object}
	 */
	this.getFont = function() { return this.font; }
	/**
	 * Set the the font object for the activity message label
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ActivityIndicator.setFont
	 */
	this.setFont = function(value) { this.font = value; }
	/**
	 * the activity message label text
	 * @alias Titanium_UI_ActivityIndicator.message
	 * @property {String}
	 */
	this.message = ''
	/**
	 * Get the the activity message label text
	 * @alias Titanium_UI_ActivityIndicator.getMessage
	 * @return {String}
	 */
	this.getMessage = function() { return this.message; }
	/**
	 * Set the the activity message label text
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_ActivityIndicator.setMessage
	 */
	this.setMessage = function(value) { this.message = value; }
	/**
	 * the style constant of the activity indicator
	 * @alias Titanium_UI_ActivityIndicator.style
	 * @property {Integer}
	 */
	this.style = 0
	/**
	 * Get the the style constant of the activity indicator
	 * @alias Titanium_UI_ActivityIndicator.getStyle
	 * @return {Integer}
	 */
	this.getStyle = function() { return this.style; }
	/**
	 * Set the the style constant of the activity indicator
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_ActivityIndicator.setStyle
	 */
	this.setStyle = function(value) { this.style = value; }
	/**
	 * call hide to make the activity indicator hidden and stop spinning
	 * @alias Titanium_UI_ActivityIndicator.hide
	 */
	this.hide = function hide() { }
	/**
	 * call show to make the activity indicator visible and start spinning
	 * @alias Titanium_UI_ActivityIndicator.show
	 */
	this.show = function show() { }
};

/**
 * The Alert Dialog is created by Titanium.UI.createAlertDialog and allows you to show a modal application dialog.
 * @since 0.8
 */
function Titanium_UI_AlertDialog() {
	/**
	 * array of button names as strings
	 * @alias Titanium_UI_AlertDialog.buttonNames
	 * @property {Array}
	 */
	this.buttonNames = []
	/**
	 * Get the array of button names as strings
	 * @alias Titanium_UI_AlertDialog.getButtonNames
	 * @return {Array}
	 */
	this.getButtonNames = function() { return this.buttonNames; }
	/**
	 * Set the array of button names as strings
	 * @param {Array} value New value to set.
	 * @alias Titanium_UI_AlertDialog.setButtonNames
	 */
	this.setButtonNames = function(value) { this.buttonNames = value; }
	/**
	 * an index to indicate which button should be the cancel button.
	 * @alias Titanium_UI_AlertDialog.cancel
	 * @property {Integer}
	 */
	this.cancel = 0
	/**
	 * Get the an index to indicate which button should be the cancel button.
	 * @alias Titanium_UI_AlertDialog.getCancel
	 * @return {Integer}
	 */
	this.getCancel = function() { return this.cancel; }
	/**
	 * Set the an index to indicate which button should be the cancel button.
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_AlertDialog.setCancel
	 */
	this.setCancel = function(value) { this.cancel = value; }
	/**
	 * the message of the dialog
	 * @alias Titanium_UI_AlertDialog.message
	 * @property {String}
	 */
	this.message = ''
	/**
	 * Get the the message of the dialog
	 * @alias Titanium_UI_AlertDialog.getMessage
	 * @return {String}
	 */
	this.getMessage = function() { return this.message; }
	/**
	 * Set the the message of the dialog
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_AlertDialog.setMessage
	 */
	this.setMessage = function(value) { this.message = value; }
	/**
	 * the title of the dialog
	 * @alias Titanium_UI_AlertDialog.title
	 * @property {String}
	 */
	this.title = ''
	/**
	 * Get the the title of the dialog
	 * @alias Titanium_UI_AlertDialog.getTitle
	 * @return {String}
	 */
	this.getTitle = function() { return this.title; }
	/**
	 * Set the the title of the dialog
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_AlertDialog.setTitle
	 */
	this.setTitle = function(value) { this.title = value; }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_AlertDialog.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_AlertDialog.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_AlertDialog.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * cause the dialog to become visible
	 * @alias Titanium_UI_AlertDialog.show
	 */
	this.show = function show() { }
};

/**
 * A Menu allows you to provide a selection of options that appear when the menu button is pressed on device. The Menu is created by the method Titanium.UI.Android.OptionMenu.createMenu
 * @since 1.1
 */
function Titanium_UI_Android_OptionMenu_Menu() {
	/**
	 * add a menu item. Items will be displayed in the menu based on insertion order.
	 * @param {Object} menuitem the menu item to add. Must be a <a href="Titanium.UI.Android.OptionMenu.MenuItem.html">Titanium.UI.Android.OptionMenu.MenuItem</a>.
	 * @alias Titanium_UI_Android_OptionMenu_Menu.add
	 */
	this.add = function add(menuitem) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_Android_OptionMenu_Menu.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_Android_OptionMenu_Menu.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_Android_OptionMenu_Menu.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
};

/**
 * A MenuItem allows you provide a selectable option with a graphic and titel. The Menu Item is created by the method Titanium.UI.Android.OptionMenu.createMenuItem
 * @since 1.1
 */
function Titanium_UI_Android_OptionMenu_MenuItem() {
	/**
	 * the path to the image to display on the menu option
	 * @alias Titanium_UI_Android_OptionMenu_MenuItem.icon
	 * @property {String}
	 */
	this.icon = ''
	/**
	 * Get the the path to the image to display on the menu option
	 * @alias Titanium_UI_Android_OptionMenu_MenuItem.getIcon
	 * @return {String}
	 */
	this.getIcon = function() { return this.icon; }
	/**
	 * Set the the path to the image to display on the menu option
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Android_OptionMenu_MenuItem.setIcon
	 */
	this.setIcon = function(value) { this.icon = value; }
	/**
	 * the text for the menu option
	 * @alias Titanium_UI_Android_OptionMenu_MenuItem.title
	 * @property {String}
	 */
	this.title = ''
	/**
	 * Get the the text for the menu option
	 * @alias Titanium_UI_Android_OptionMenu_MenuItem.getTitle
	 * @return {String}
	 */
	this.getTitle = function() { return this.title; }
	/**
	 * Set the the text for the menu option
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Android_OptionMenu_MenuItem.setTitle
	 */
	this.setTitle = function(value) { this.title = value; }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_Android_OptionMenu_MenuItem.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_Android_OptionMenu_MenuItem.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_Android_OptionMenu_MenuItem.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
};

/**
 * The Animation object is used for specifying lower-level animation properties and more low-level control of events during an animation. The Animation is created by the method Titanium.UI.createAnimation.
 * @since 0.9
 */
function Titanium_UI_Animation() {
	/**
	 * the property specifies if the animation should be replayed in reverse upon completion
	 * @alias Titanium_UI_Animation.autoreverse
	 * @property {Boolean}
	 */
	this.autoreverse = false
	/**
	 * Get the the property specifies if the animation should be replayed in reverse upon completion
	 * @alias Titanium_UI_Animation.getAutoreverse
	 * @return {Boolean}
	 */
	this.getAutoreverse = function() { return this.autoreverse; }
	/**
	 * Set the the property specifies if the animation should be replayed in reverse upon completion
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Animation.setAutoreverse
	 */
	this.setAutoreverse = function(value) { this.autoreverse = value; }
	/**
	 * value of the backgroundColor property to change during animation
	 * @alias Titanium_UI_Animation.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the value of the backgroundColor property to change during animation
	 * @alias Titanium_UI_Animation.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the value of the backgroundColor property to change during animation
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Animation.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * value of the bottom property to change during animation
	 * @alias Titanium_UI_Animation.bottom
	 * @property {Float}
	 */
	this.bottom = 0.0
	/**
	 * Get the value of the bottom property to change during animation
	 * @alias Titanium_UI_Animation.getBottom
	 * @return {Float}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the value of the bottom property to change during animation
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Animation.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * value of the center property to change during animation
	 * @alias Titanium_UI_Animation.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the value of the center property to change during animation
	 * @alias Titanium_UI_Animation.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the value of the center property to change during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Animation.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * value of the color property to change during animation
	 * @alias Titanium_UI_Animation.color
	 * @property {String}
	 */
	this.color = ''
	/**
	 * Get the value of the color property to change during animation
	 * @alias Titanium_UI_Animation.getColor
	 * @return {String}
	 */
	this.getColor = function() { return this.color; }
	/**
	 * Set the value of the color property to change during animation
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Animation.setColor
	 */
	this.setColor = function(value) { this.color = value; }
	/**
	 * the curve of the animation
	 * @alias Titanium_UI_Animation.curve
	 * @property {Integer}
	 */
	this.curve = 0
	/**
	 * Get the the curve of the animation
	 * @alias Titanium_UI_Animation.getCurve
	 * @return {Integer}
	 */
	this.getCurve = function() { return this.curve; }
	/**
	 * Set the the curve of the animation
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_Animation.setCurve
	 */
	this.setCurve = function(value) { this.curve = value; }
	/**
	 * the duration of time in milliseconds before starting the animation
	 * @alias Titanium_UI_Animation.delay
	 * @property {Float}
	 */
	this.delay = 0.0
	/**
	 * Get the the duration of time in milliseconds before starting the animation
	 * @alias Titanium_UI_Animation.getDelay
	 * @return {Float}
	 */
	this.getDelay = function() { return this.delay; }
	/**
	 * Set the the duration of time in milliseconds before starting the animation
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Animation.setDelay
	 */
	this.setDelay = function(value) { this.delay = value; }
	/**
	 * the duration of time in milliseconds to perform the animation
	 * @alias Titanium_UI_Animation.duration
	 * @property {Float}
	 */
	this.duration = 0.0
	/**
	 * Get the the duration of time in milliseconds to perform the animation
	 * @alias Titanium_UI_Animation.getDuration
	 * @return {Float}
	 */
	this.getDuration = function() { return this.duration; }
	/**
	 * Set the the duration of time in milliseconds to perform the animation
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Animation.setDuration
	 */
	this.setDuration = function(value) { this.duration = value; }
	/**
	 * value of the height property to change during animation
	 * @alias Titanium_UI_Animation.height
	 * @property {Float}
	 */
	this.height = 0.0
	/**
	 * Get the value of the height property to change during animation
	 * @alias Titanium_UI_Animation.getHeight
	 * @return {Float}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the value of the height property to change during animation
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Animation.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * value of the left property to change during animation
	 * @alias Titanium_UI_Animation.left
	 * @property {Float}
	 */
	this.left = 0.0
	/**
	 * Get the value of the left property to change during animation
	 * @alias Titanium_UI_Animation.getLeft
	 * @return {Float}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the value of the left property to change during animation
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Animation.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * value of the opacity property to change during animation
	 * @alias Titanium_UI_Animation.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the value of the opacity property to change during animation
	 * @alias Titanium_UI_Animation.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the value of the opacity property to change during animation
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Animation.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * value of the opaque property to change during animation
	 * @alias Titanium_UI_Animation.opaque
	 * @property {Boolean}
	 */
	this.opaque = false
	/**
	 * Get the value of the opaque property to change during animation
	 * @alias Titanium_UI_Animation.getOpaque
	 * @return {Boolean}
	 */
	this.getOpaque = function() { return this.opaque; }
	/**
	 * Set the value of the opaque property to change during animation
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Animation.setOpaque
	 */
	this.setOpaque = function(value) { this.opaque = value; }
	/**
	 * the number of times the animation should be performed
	 * @alias Titanium_UI_Animation.repeat
	 * @property {Integer}
	 */
	this.repeat = 0
	/**
	 * Get the the number of times the animation should be performed
	 * @alias Titanium_UI_Animation.getRepeat
	 * @return {Integer}
	 */
	this.getRepeat = function() { return this.repeat; }
	/**
	 * Set the the number of times the animation should be performed
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_Animation.setRepeat
	 */
	this.setRepeat = function(value) { this.repeat = value; }
	/**
	 * value of the right property to change during animation
	 * @alias Titanium_UI_Animation.right
	 * @property {Float}
	 */
	this.right = 0.0
	/**
	 * Get the value of the right property to change during animation
	 * @alias Titanium_UI_Animation.getRight
	 * @return {Float}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the value of the right property to change during animation
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Animation.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * value of the top property to change during animation
	 * @alias Titanium_UI_Animation.top
	 * @property {Float}
	 */
	this.top = 0.0
	/**
	 * Get the value of the top property to change during animation
	 * @alias Titanium_UI_Animation.getTop
	 * @return {Float}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the value of the top property to change during animation
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Animation.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * value of the transform property to change during animation
	 * @alias Titanium_UI_Animation.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the value of the transform property to change during animation
	 * @alias Titanium_UI_Animation.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the value of the transform property to change during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Animation.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * during a transition animation, this is the constant to the type of transition to use
	 * @alias Titanium_UI_Animation.transition
	 * @property {Integer}
	 */
	this.transition = 0
	/**
	 * Get the during a transition animation, this is the constant to the type of transition to use
	 * @alias Titanium_UI_Animation.getTransition
	 * @return {Integer}
	 */
	this.getTransition = function() { return this.transition; }
	/**
	 * Set the during a transition animation, this is the constant to the type of transition to use
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_Animation.setTransition
	 */
	this.setTransition = function(value) { this.transition = value; }
	/**
	 * value of the visible property to change during animation
	 * @alias Titanium_UI_Animation.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the value of the visible property to change during animation
	 * @alias Titanium_UI_Animation.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the value of the visible property to change during animation
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Animation.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * value of the width property to change during animation
	 * @alias Titanium_UI_Animation.width
	 * @property {Float}
	 */
	this.width = 0.0
	/**
	 * Get the value of the width property to change during animation
	 * @alias Titanium_UI_Animation.getWidth
	 * @return {Float}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the value of the width property to change during animation
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Animation.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * value of the zIndex property to change during animation
	 * @alias Titanium_UI_Animation.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the value of the zIndex property to change during animation
	 * @alias Titanium_UI_Animation.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the value of the zIndex property to change during animation
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_Animation.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_Animation.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_Animation.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_Animation.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
};

/**
 * A Button is created by the method Titanium.UI.createButton.
 * @since 0.8
 */
function Titanium_UI_Button() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_Button.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_Button.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Button.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_Button.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_Button.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Button.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * the buttons background color
	 * @alias Titanium_UI_Button.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the buttons background color
	 * @alias Titanium_UI_Button.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the buttons background color
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Button.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * url to a button image that is drawn as the background of the button when the button is in the disabled state
	 * @alias Titanium_UI_Button.backgroundDisabledImage
	 * @property {String}
	 */
	this.backgroundDisabledImage = ''
	/**
	 * Get the url to a button image that is drawn as the background of the button when the button is in the disabled state
	 * @alias Titanium_UI_Button.getBackgroundDisabledImage
	 * @return {String}
	 */
	this.getBackgroundDisabledImage = function() { return this.backgroundDisabledImage; }
	/**
	 * Set the url to a button image that is drawn as the background of the button when the button is in the disabled state
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Button.setBackgroundDisabledImage
	 */
	this.setBackgroundDisabledImage = function(value) { this.backgroundDisabledImage = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_Button.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_Button.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Button.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * url to a button image that is drawn as the background of the button
	 * @alias Titanium_UI_Button.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the url to a button image that is drawn as the background of the button
	 * @alias Titanium_UI_Button.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the url to a button image that is drawn as the background of the button
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Button.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_Button.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_Button.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Button.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * url to a button image that is drawn as the background of the button when the button is in the selected state
	 * @alias Titanium_UI_Button.backgroundSelectedImage
	 * @property {String}
	 */
	this.backgroundSelectedImage = ''
	/**
	 * Get the url to a button image that is drawn as the background of the button when the button is in the selected state
	 * @alias Titanium_UI_Button.getBackgroundSelectedImage
	 * @return {String}
	 */
	this.getBackgroundSelectedImage = function() { return this.backgroundSelectedImage; }
	/**
	 * Set the url to a button image that is drawn as the background of the button when the button is in the selected state
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Button.setBackgroundSelectedImage
	 */
	this.setBackgroundSelectedImage = function(value) { this.backgroundSelectedImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_Button.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_Button.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Button.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_Button.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_Button.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Button.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_Button.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_Button.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Button.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_Button.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_Button.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Button.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Button.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Button.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Button.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_Button.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_Button.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Button.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * the foreground color of the button text
	 * @alias Titanium_UI_Button.color
	 * @property {String}
	 */
	this.color = ''
	/**
	 * Get the the foreground color of the button text
	 * @alias Titanium_UI_Button.getColor
	 * @return {String}
	 */
	this.getColor = function() { return this.color; }
	/**
	 * Set the the foreground color of the button text
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Button.setColor
	 */
	this.setColor = function(value) { this.color = value; }
	/**
	 * boolean that indicates if the button is enabled or not
	 * @alias Titanium_UI_Button.enabled
	 * @property {Boolean}
	 */
	this.enabled = false
	/**
	 * Get the boolean that indicates if the button is enabled or not
	 * @alias Titanium_UI_Button.getEnabled
	 * @return {Boolean}
	 */
	this.getEnabled = function() { return this.enabled; }
	/**
	 * Set the boolean that indicates if the button is enabled or not
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Button.setEnabled
	 */
	this.setEnabled = function(value) { this.enabled = value; }
	/**
	 * the font properties of the button
	 * @alias Titanium_UI_Button.font
	 * @property {Object}
	 */
	this.font = {}
	/**
	 * Get the the font properties of the button
	 * @alias Titanium_UI_Button.getFont
	 * @return {Object}
	 */
	this.getFont = function() { return this.font; }
	/**
	 * Set the the font properties of the button
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Button.setFont
	 */
	this.setFont = function(value) { this.font = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_Button.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_Button.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Button.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * the image to display on the button to the left of the title
	 * @alias Titanium_UI_Button.image
	 * @property {String}
	 */
	this.image = ''
	/**
	 * Get the the image to display on the button to the left of the title
	 * @alias Titanium_UI_Button.getImage
	 * @return {String}
	 */
	this.getImage = function() { return this.image; }
	/**
	 * Set the the image to display on the button to the left of the title
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Button.setImage
	 */
	this.setImage = function(value) { this.image = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Button.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Button.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Button.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_Button.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_Button.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Button.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Button.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Button.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Button.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * the selected color of the button text when the button is in the selected state
	 * @alias Titanium_UI_Button.selectedColor
	 * @property {String}
	 */
	this.selectedColor = ''
	/**
	 * Get the the selected color of the button text when the button is in the selected state
	 * @alias Titanium_UI_Button.getSelectedColor
	 * @return {String}
	 */
	this.getSelectedColor = function() { return this.selectedColor; }
	/**
	 * Set the the selected color of the button text when the button is in the selected state
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Button.setSelectedColor
	 */
	this.setSelectedColor = function(value) { this.selectedColor = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_Button.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_Button.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Button.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * style constant for the type of button
	 * @alias Titanium_UI_Button.style
	 * @property {Integer}
	 */
	this.style = 0
	/**
	 * Get the style constant for the type of button
	 * @alias Titanium_UI_Button.getStyle
	 * @return {Integer}
	 */
	this.getStyle = function() { return this.style; }
	/**
	 * Set the style constant for the type of button
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_Button.setStyle
	 */
	this.setStyle = function(value) { this.style = value; }
	/**
	 * button title
	 * @alias Titanium_UI_Button.title
	 * @property {String}
	 */
	this.title = ''
	/**
	 * Get the button title
	 * @alias Titanium_UI_Button.getTitle
	 * @return {String}
	 */
	this.getTitle = function() { return this.title; }
	/**
	 * Set the button title
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Button.setTitle
	 */
	this.setTitle = function(value) { this.title = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Button.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Button.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Button.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_Button.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_Button.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Button.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_Button.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_Button.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Button.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_Button.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_Button.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Button.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_Button.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_Button.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Button.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_Button.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_Button.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_Button.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_Button.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_Button.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_Button.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_Button.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_UI_Button.hide
	 */
	this.hide = function hide() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_Button.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_Button.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_Button.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_Button.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * A Button Bar is created by the method Titanium.UI.createButtonBar.
 * @since 0.8
 */
function Titanium_UI_ButtonBar() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_ButtonBar.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_ButtonBar.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_ButtonBar.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_ButtonBar.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * the background color of the button bar
	 * @alias Titanium_UI_ButtonBar.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the button bar
	 * @alias Titanium_UI_ButtonBar.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the button bar
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_ButtonBar.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_ButtonBar.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_UI_ButtonBar.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_UI_ButtonBar.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_ButtonBar.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_ButtonBar.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_ButtonBar.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_ButtonBar.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_ButtonBar.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_ButtonBar.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_ButtonBar.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_ButtonBar.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_ButtonBar.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_ButtonBar.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ButtonBar.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ButtonBar.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_ButtonBar.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_ButtonBar.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_ButtonBar.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_ButtonBar.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * the selected index
	 * @alias Titanium_UI_ButtonBar.index
	 * @property {Integer}
	 */
	this.index = 0
	/**
	 * Get the the selected index
	 * @alias Titanium_UI_ButtonBar.getIndex
	 * @return {Integer}
	 */
	this.getIndex = function() { return this.index; }
	/**
	 * Set the the selected index
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setIndex
	 */
	this.setIndex = function(value) { this.index = value; }
	/**
	 * the array of labels for the button bar. each object should have the properties title, image, width and enabled.
	 * @alias Titanium_UI_ButtonBar.labels
	 * @property {Array}
	 */
	this.labels = []
	/**
	 * Get the the array of labels for the button bar. each object should have the properties title, image, width and enabled.
	 * @alias Titanium_UI_ButtonBar.getLabels
	 * @return {Array}
	 */
	this.getLabels = function() { return this.labels; }
	/**
	 * Set the the array of labels for the button bar. each object should have the properties title, image, width and enabled.
	 * @param {Array} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setLabels
	 */
	this.setLabels = function(value) { this.labels = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ButtonBar.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ButtonBar.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_ButtonBar.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_ButtonBar.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ButtonBar.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ButtonBar.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_ButtonBar.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_ButtonBar.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * the style of the button bar
	 * @alias Titanium_UI_ButtonBar.style
	 * @property {Integer}
	 */
	this.style = 0
	/**
	 * Get the the style of the button bar
	 * @alias Titanium_UI_ButtonBar.getStyle
	 * @return {Integer}
	 */
	this.getStyle = function() { return this.style; }
	/**
	 * Set the the style of the button bar
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setStyle
	 */
	this.setStyle = function(value) { this.style = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ButtonBar.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ButtonBar.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_ButtonBar.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_ButtonBar.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_ButtonBar.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_ButtonBar.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_ButtonBar.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_ButtonBar.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_ButtonBar.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_ButtonBar.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_ButtonBar.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_ButtonBar.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_ButtonBar.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_ButtonBar.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_ButtonBar.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_ButtonBar.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_ButtonBar.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_UI_ButtonBar.hide
	 */
	this.hide = function hide() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_ButtonBar.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_ButtonBar.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_ButtonBar.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_ButtonBar.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * The Cover Flow view is container for showing  animated, three dimensional images in a nice UI. The Cover Flow view is created by the method Titanium.UI.createCoverFlowView.
 * @since 0.8
 */
function Titanium_UI_CoverFlowView() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_CoverFlowView.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_CoverFlowView.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_CoverFlowView.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_CoverFlowView.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * the background color of the view
	 * @alias Titanium_UI_CoverFlowView.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the view
	 * @alias Titanium_UI_CoverFlowView.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_CoverFlowView.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_CoverFlowView.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_UI_CoverFlowView.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_UI_CoverFlowView.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_CoverFlowView.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_CoverFlowView.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_CoverFlowView.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_CoverFlowView.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_CoverFlowView.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_CoverFlowView.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_CoverFlowView.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_CoverFlowView.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_CoverFlowView.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_CoverFlowView.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_CoverFlowView.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_CoverFlowView.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_CoverFlowView.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_CoverFlowView.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_CoverFlowView.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_CoverFlowView.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * array of images to display in the view
	 * @alias Titanium_UI_CoverFlowView.images
	 * @property {Array}
	 */
	this.images = []
	/**
	 * Get the array of images to display in the view
	 * @alias Titanium_UI_CoverFlowView.getImages
	 * @return {Array}
	 */
	this.getImages = function() { return this.images; }
	/**
	 * Set the array of images to display in the view
	 * @param {Array} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setImages
	 */
	this.setImages = function(value) { this.images = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_CoverFlowView.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_CoverFlowView.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_CoverFlowView.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_CoverFlowView.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_CoverFlowView.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_CoverFlowView.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * index to make selected
	 * @alias Titanium_UI_CoverFlowView.selected
	 * @property {Integer}
	 */
	this.selected = 0
	/**
	 * Get the index to make selected
	 * @alias Titanium_UI_CoverFlowView.getSelected
	 * @return {Integer}
	 */
	this.getSelected = function() { return this.selected; }
	/**
	 * Set the index to make selected
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setSelected
	 */
	this.setSelected = function(value) { this.selected = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_CoverFlowView.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_CoverFlowView.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_CoverFlowView.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_CoverFlowView.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_CoverFlowView.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_CoverFlowView.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_CoverFlowView.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_CoverFlowView.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_CoverFlowView.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_CoverFlowView.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_CoverFlowView.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_CoverFlowView.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_CoverFlowView.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_CoverFlowView.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_CoverFlowView.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_CoverFlowView.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_CoverFlowView.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_CoverFlowView.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_CoverFlowView.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_UI_CoverFlowView.hide
	 */
	this.hide = function hide() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_CoverFlowView.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_CoverFlowView.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * change an image for a index
	 * @param {Integer} index index to change
	 * @param {String} url url to the new image
	 * @alias Titanium_UI_CoverFlowView.setURL
	 */
	this.setURL = function setURL(index,url) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_CoverFlowView.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_CoverFlowView.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * An item that represents a visual icon in the Titanium.UI.DashboardView. The Dashboard Item is created by the method Titanium.UI.createDashboardItem.
 * @since 1.2
 */
function Titanium_UI_DashboardItem() {
	/**
	 * the badge value or 0 to remove the badge
	 * @alias Titanium_UI_DashboardItem.badge
	 * @property {Integer}
	 */
	this.badge = 0
	/**
	 * Get the the badge value or 0 to remove the badge
	 * @alias Titanium_UI_DashboardItem.getBadge
	 * @return {Integer}
	 */
	this.getBadge = function() { return this.badge; }
	/**
	 * Set the the badge value or 0 to remove the badge
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_DashboardItem.setBadge
	 */
	this.setBadge = function(value) { this.badge = value; }
	/**
	 * a boolean to indicate if this item can be deleted when it edit mode
	 * @alias Titanium_UI_DashboardItem.canDelete
	 * @property {Boolean}
	 */
	this.canDelete = false
	/**
	 * Get the a boolean to indicate if this item can be deleted when it edit mode
	 * @alias Titanium_UI_DashboardItem.getCanDelete
	 * @return {Boolean}
	 */
	this.getCanDelete = function() { return this.canDelete; }
	/**
	 * Set the a boolean to indicate if this item can be deleted when it edit mode
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_DashboardItem.setCanDelete
	 */
	this.setCanDelete = function(value) { this.canDelete = value; }
	/**
	 * the URL to the image
	 * @alias Titanium_UI_DashboardItem.image
	 * @property {String}
	 */
	this.image = ''
	/**
	 * Get the the URL to the image
	 * @alias Titanium_UI_DashboardItem.getImage
	 * @return {String}
	 */
	this.getImage = function() { return this.image; }
	/**
	 * Set the the URL to the image
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_DashboardItem.setImage
	 */
	this.setImage = function(value) { this.image = value; }
	/**
	 * the URL to the image to display when the item is depressed (clicked)
	 * @alias Titanium_UI_DashboardItem.selectedImage
	 * @property {String}
	 */
	this.selectedImage = ''
	/**
	 * Get the the URL to the image to display when the item is depressed (clicked)
	 * @alias Titanium_UI_DashboardItem.getSelectedImage
	 * @return {String}
	 */
	this.getSelectedImage = function() { return this.selectedImage; }
	/**
	 * Set the the URL to the image to display when the item is depressed (clicked)
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_DashboardItem.setSelectedImage
	 */
	this.setSelectedImage = function(value) { this.selectedImage = value; }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_DashboardItem.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_DashboardItem.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_DashboardItem.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
};

/**
 * The Dashboard View provides a view that supports the ability to have Springboard-like view of icons which can be reordered by dragging and can contain multiple pages of icons in a scrollable view. The Dashboard View is created by the method Titanium.UI.createDashboardView.
 * @since 1.2
 */
function Titanium_UI_DashboardView() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_DashboardView.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_DashboardView.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_DashboardView.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_DashboardView.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_DashboardView.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_DashboardView.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * the background color of the view
	 * @alias Titanium_UI_DashboardView.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the view
	 * @alias Titanium_UI_DashboardView.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_DashboardView.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_DashboardView.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_DashboardView.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_DashboardView.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_UI_DashboardView.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_UI_DashboardView.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_DashboardView.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_DashboardView.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_DashboardView.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_DashboardView.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_DashboardView.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_DashboardView.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_DashboardView.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_DashboardView.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_DashboardView.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_DashboardView.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_DashboardView.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_DashboardView.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_DashboardView.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_DashboardView.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_DashboardView.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_DashboardView.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_DashboardView.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_DashboardView.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_DashboardView.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_DashboardView.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_DashboardView.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_DashboardView.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * an array of Titanium.UI.DashboardItem objects to display in the view
	 * @alias Titanium_UI_DashboardView.data
	 * @property {Array}
	 */
	this.data = []
	/**
	 * Get the an array of Titanium.UI.DashboardItem objects to display in the view
	 * @alias Titanium_UI_DashboardView.getData
	 * @return {Array}
	 */
	this.getData = function() { return this.data; }
	/**
	 * Set the an array of Titanium.UI.DashboardItem objects to display in the view
	 * @param {Array} value New value to set.
	 * @alias Titanium_UI_DashboardView.setData
	 */
	this.setData = function(value) { this.data = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_DashboardView.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_DashboardView.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_DashboardView.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_DashboardView.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_DashboardView.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_DashboardView.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_DashboardView.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_DashboardView.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_DashboardView.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_DashboardView.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_DashboardView.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_DashboardView.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_DashboardView.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_DashboardView.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_DashboardView.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_DashboardView.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_DashboardView.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_DashboardView.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_DashboardView.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_DashboardView.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_DashboardView.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_DashboardView.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_DashboardView.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_DashboardView.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_DashboardView.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_DashboardView.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_DashboardView.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_DashboardView.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_DashboardView.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_DashboardView.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_DashboardView.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_DashboardView.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_DashboardView.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_DashboardView.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_DashboardView.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_DashboardView.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_DashboardView.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_UI_DashboardView.hide
	 */
	this.hide = function hide() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_DashboardView.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_DashboardView.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_DashboardView.show
	 */
	this.show = function show() { }
	/**
	 * put the dashboard in edit mode
	 * @alias Titanium_UI_DashboardView.startEditing
	 */
	this.startEditing = function startEditing() { }
	/**
	 * cancel editing
	 * @alias Titanium_UI_DashboardView.stopEditing
	 */
	this.stopEditing = function stopEditing() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_DashboardView.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * The Email Dialog is created by Titanium.UI.createEmailDialog and allows you to send in application emails on behalf of the application user.
 * @since 0.8
 */
function Titanium_UI_EmailDialog() {
	/**
	 * the bar color of the email dialog window when opened
	 * @alias Titanium_UI_EmailDialog.barColor
	 * @property {String}
	 */
	this.barColor = ''
	/**
	 * Get the the bar color of the email dialog window when opened
	 * @alias Titanium_UI_EmailDialog.getBarColor
	 * @return {String}
	 */
	this.getBarColor = function() { return this.barColor; }
	/**
	 * Set the the bar color of the email dialog window when opened
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_EmailDialog.setBarColor
	 */
	this.setBarColor = function(value) { this.barColor = value; }
	/**
	 * array of email BCC: recipients
	 * @alias Titanium_UI_EmailDialog.bccRecipients
	 * @property {Array}
	 */
	this.bccRecipients = []
	/**
	 * Get the array of email BCC: recipients
	 * @alias Titanium_UI_EmailDialog.getBccRecipients
	 * @return {Array}
	 */
	this.getBccRecipients = function() { return this.bccRecipients; }
	/**
	 * Set the array of email BCC: recipients
	 * @param {Array} value New value to set.
	 * @alias Titanium_UI_EmailDialog.setBccRecipients
	 */
	this.setBccRecipients = function(value) { this.bccRecipients = value; }
	/**
	 * array of email CC: recipients
	 * @alias Titanium_UI_EmailDialog.ccRecipients
	 * @property {Array}
	 */
	this.ccRecipients = []
	/**
	 * Get the array of email CC: recipients
	 * @alias Titanium_UI_EmailDialog.getCcRecipients
	 * @return {Array}
	 */
	this.getCcRecipients = function() { return this.ccRecipients; }
	/**
	 * Set the array of email CC: recipients
	 * @param {Array} value New value to set.
	 * @alias Titanium_UI_EmailDialog.setCcRecipients
	 */
	this.setCcRecipients = function(value) { this.ccRecipients = value; }
	/**
	 * boolean to indicate whether the email messageBody should be sent as HTML content type. defaults to false
	 * @alias Titanium_UI_EmailDialog.html
	 * @property {Boolean}
	 */
	this.html = false
	/**
	 * Get the boolean to indicate whether the email messageBody should be sent as HTML content type. defaults to false
	 * @alias Titanium_UI_EmailDialog.getHtml
	 * @return {Boolean}
	 */
	this.getHtml = function() { return this.html; }
	/**
	 * Set the boolean to indicate whether the email messageBody should be sent as HTML content type. defaults to false
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_EmailDialog.setHtml
	 */
	this.setHtml = function(value) { this.html = value; }
	/**
	 * the email message body
	 * @alias Titanium_UI_EmailDialog.messageBody
	 * @property {String}
	 */
	this.messageBody = ''
	/**
	 * Get the the email message body
	 * @alias Titanium_UI_EmailDialog.getMessageBody
	 * @return {String}
	 */
	this.getMessageBody = function() { return this.messageBody; }
	/**
	 * Set the the email message body
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_EmailDialog.setMessageBody
	 */
	this.setMessageBody = function(value) { this.messageBody = value; }
	/**
	 * the subject line for the email
	 * @alias Titanium_UI_EmailDialog.subject
	 * @property {String}
	 */
	this.subject = ''
	/**
	 * Get the the subject line for the email
	 * @alias Titanium_UI_EmailDialog.getSubject
	 * @return {String}
	 */
	this.getSubject = function() { return this.subject; }
	/**
	 * Set the the subject line for the email
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_EmailDialog.setSubject
	 */
	this.setSubject = function(value) { this.subject = value; }
	/**
	 * array of email recipients
	 * @alias Titanium_UI_EmailDialog.toRecipients
	 * @property {Array}
	 */
	this.toRecipients = []
	/**
	 * Get the array of email recipients
	 * @alias Titanium_UI_EmailDialog.getToRecipients
	 * @return {Array}
	 */
	this.getToRecipients = function() { return this.toRecipients; }
	/**
	 * Set the array of email recipients
	 * @param {Array} value New value to set.
	 * @alias Titanium_UI_EmailDialog.setToRecipients
	 */
	this.setToRecipients = function(value) { this.toRecipients = value; }
	/**
	 * add an attachment to the email. the attachment can either be a Blob or File object. (Note: Android will only accept one attachment at this time.)
	 * @param {Object} attachment attachment object as either a Blob or File object
	 * @alias Titanium_UI_EmailDialog.addAttachment
	 */
	this.addAttachment = function addAttachment(attachment) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_EmailDialog.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_EmailDialog.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * open the email dialog. the email dialog itself is a modal window
	 * @param {Object} properties object of animation properties. pass <tt>animated</tt> property (as boolean) to indicate if the dialog should be animated on open.
	 * @alias Titanium_UI_EmailDialog.open
	 */
	this.open = function open(properties) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_EmailDialog.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
};

/**
 * An Image View is used to display an image or a series of images in an animation. The Image View is created by the method Titanium.UI.createImageView.
 * @since 0.9
 */
function Titanium_UI_ImageView() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_ImageView.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_ImageView.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ImageView.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_ImageView.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_ImageView.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ImageView.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * readonly boolean to indicate if the animation is animating
	 * @alias Titanium_UI_ImageView.animating
	 * @property {Boolean}
	 */
	this.animating = false
	/**
	 * Get the readonly boolean to indicate if the animation is animating
	 * @alias Titanium_UI_ImageView.getAnimating
	 * @return {Boolean}
	 */
	this.getAnimating = function() { return this.animating; }
	/**
	 * Set the readonly boolean to indicate if the animation is animating
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_ImageView.setAnimating
	 */
	this.setAnimating = function(value) { this.animating = value; }
	/**
	 * the background color of the view
	 * @alias Titanium_UI_ImageView.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the view
	 * @alias Titanium_UI_ImageView.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_ImageView.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_ImageView.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_ImageView.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ImageView.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_UI_ImageView.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_UI_ImageView.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_ImageView.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_ImageView.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_ImageView.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ImageView.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_ImageView.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_ImageView.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ImageView.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_ImageView.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_ImageView.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_ImageView.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_ImageView.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_ImageView.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ImageView.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_ImageView.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_ImageView.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ImageView.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ImageView.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ImageView.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_ImageView.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * allow image to scale (Android)
	 * @alias Titanium_UI_ImageView.canScale
	 * @property {Boolean}
	 */
	this.canScale = false
	/**
	 * Get the allow image to scale (Android)
	 * @alias Titanium_UI_ImageView.getCanScale
	 * @return {Boolean}
	 */
	this.getCanScale = function() { return this.canScale; }
	/**
	 * Set the allow image to scale (Android)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_ImageView.setCanScale
	 */
	this.setCanScale = function(value) { this.canScale = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_ImageView.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_ImageView.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ImageView.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * url to the default image to display while loading a remote image
	 * @alias Titanium_UI_ImageView.defaultImage
	 * @property {String}
	 */
	this.defaultImage = ''
	/**
	 * Get the url to the default image to display while loading a remote image
	 * @alias Titanium_UI_ImageView.getDefaultImage
	 * @return {String}
	 */
	this.getDefaultImage = function() { return this.defaultImage; }
	/**
	 * Set the url to the default image to display while loading a remote image
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_ImageView.setDefaultImage
	 */
	this.setDefaultImage = function(value) { this.defaultImage = value; }
	/**
	 * amount of time in milliseconds to animate one cycle
	 * @alias Titanium_UI_ImageView.duration
	 * @property {Float}
	 */
	this.duration = 0.0
	/**
	 * Get the amount of time in milliseconds to animate one cycle
	 * @alias Titanium_UI_ImageView.getDuration
	 * @return {Float}
	 */
	this.getDuration = function() { return this.duration; }
	/**
	 * Set the amount of time in milliseconds to animate one cycle
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ImageView.setDuration
	 */
	this.setDuration = function(value) { this.duration = value; }
	/**
	 * enable zoom controls on Android. Default is true for backward compatibility. (1.3.0)
	 * @alias Titanium_UI_ImageView.enableZoomControls
	 * @property {Boolean}
	 */
	this.enableZoomControls = false
	/**
	 * Get the enable zoom controls on Android. Default is true for backward compatibility. (1.3.0)
	 * @alias Titanium_UI_ImageView.getEnableZoomControls
	 * @return {Boolean}
	 */
	this.getEnableZoomControls = function() { return this.enableZoomControls; }
	/**
	 * Set the enable zoom controls on Android. Default is true for backward compatibility. (1.3.0)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_ImageView.setEnableZoomControls
	 */
	this.setEnableZoomControls = function(value) { this.enableZoomControls = value; }
	/**
	 * height of the image display
	 * @alias Titanium_UI_ImageView.height
	 * @property {Float}
	 */
	this.height = 0.0
	/**
	 * Get the height of the image display
	 * @alias Titanium_UI_ImageView.getHeight
	 * @return {Float}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the height of the image display
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ImageView.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * image to display either as string url, Blob or File
	 * @alias Titanium_UI_ImageView.image
	 * @property {Object}
	 */
	this.image = {}
	/**
	 * Get the image to display either as string url, Blob or File
	 * @alias Titanium_UI_ImageView.getImage
	 * @return {Object}
	 */
	this.getImage = function() { return this.image; }
	/**
	 * Set the image to display either as string url, Blob or File
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ImageView.setImage
	 */
	this.setImage = function(value) { this.image = value; }
	/**
	 * array of images (either as string url, Blob or File) to display in an animation
	 * @alias Titanium_UI_ImageView.images
	 * @property {Array}
	 */
	this.images = []
	/**
	 * Get the array of images (either as string url, Blob or File) to display in an animation
	 * @alias Titanium_UI_ImageView.getImages
	 * @return {Array}
	 */
	this.getImages = function() { return this.images; }
	/**
	 * Set the array of images (either as string url, Blob or File) to display in an animation
	 * @param {Array} value New value to set.
	 * @alias Titanium_UI_ImageView.setImages
	 */
	this.setImages = function(value) { this.images = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ImageView.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ImageView.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_ImageView.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_ImageView.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_ImageView.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ImageView.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * readonly boolean to indicate if the animation is paused
	 * @alias Titanium_UI_ImageView.paused
	 * @property {Boolean}
	 */
	this.paused = false
	/**
	 * Get the readonly boolean to indicate if the animation is paused
	 * @alias Titanium_UI_ImageView.getPaused
	 * @return {Boolean}
	 */
	this.getPaused = function() { return this.paused; }
	/**
	 * Set the readonly boolean to indicate if the animation is paused
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_ImageView.setPaused
	 */
	this.setPaused = function(value) { this.paused = value; }
	/**
	 * boolean to indicate if the default image should be displaying while loading a remote image
	 * @alias Titanium_UI_ImageView.preventDefaultImage
	 * @property {Boolean}
	 */
	this.preventDefaultImage = false
	/**
	 * Get the boolean to indicate if the default image should be displaying while loading a remote image
	 * @alias Titanium_UI_ImageView.getPreventDefaultImage
	 * @return {Boolean}
	 */
	this.getPreventDefaultImage = function() { return this.preventDefaultImage; }
	/**
	 * Set the boolean to indicate if the default image should be displaying while loading a remote image
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_ImageView.setPreventDefaultImage
	 */
	this.setPreventDefaultImage = function(value) { this.preventDefaultImage = value; }
	/**
	 * number of times to repeat the image animation
	 * @alias Titanium_UI_ImageView.repeatCount
	 * @property {Integer}
	 */
	this.repeatCount = 0
	/**
	 * Get the number of times to repeat the image animation
	 * @alias Titanium_UI_ImageView.getRepeatCount
	 * @return {Integer}
	 */
	this.getRepeatCount = function() { return this.repeatCount; }
	/**
	 * Set the number of times to repeat the image animation
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_ImageView.setRepeatCount
	 */
	this.setRepeatCount = function(value) { this.repeatCount = value; }
	/**
	 * boolean to indicate if the animation should happen in reverse (from last to first)
	 * @alias Titanium_UI_ImageView.reverse
	 * @property {Boolean}
	 */
	this.reverse = false
	/**
	 * Get the boolean to indicate if the animation should happen in reverse (from last to first)
	 * @alias Titanium_UI_ImageView.getReverse
	 * @return {Boolean}
	 */
	this.getReverse = function() { return this.reverse; }
	/**
	 * Set the boolean to indicate if the animation should happen in reverse (from last to first)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_ImageView.setReverse
	 */
	this.setReverse = function(value) { this.reverse = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ImageView.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ImageView.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_ImageView.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_ImageView.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_ImageView.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ImageView.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ImageView.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ImageView.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_ImageView.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_ImageView.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_ImageView.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_ImageView.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_ImageView.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_ImageView.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ImageView.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * url to the image to display
	 * @alias Titanium_UI_ImageView.url
	 * @property {String}
	 */
	this.url = ''
	/**
	 * Get the url to the image to display
	 * @alias Titanium_UI_ImageView.getUrl
	 * @return {String}
	 */
	this.getUrl = function() { return this.url; }
	/**
	 * Set the url to the image to display
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_ImageView.setUrl
	 */
	this.setUrl = function(value) { this.url = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_ImageView.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_ImageView.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_ImageView.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * width of the image display
	 * @alias Titanium_UI_ImageView.width
	 * @property {Float}
	 */
	this.width = 0.0
	/**
	 * Get the width of the image display
	 * @alias Titanium_UI_ImageView.getWidth
	 * @return {Float}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the width of the image display
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ImageView.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_ImageView.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_ImageView.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_ImageView.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_ImageView.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_ImageView.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_ImageView.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_ImageView.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_UI_ImageView.hide
	 */
	this.hide = function hide() { }
	/**
	 * pause a started animation.
	 * @alias Titanium_UI_ImageView.pause
	 */
	this.pause = function pause() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_ImageView.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_ImageView.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_ImageView.show
	 */
	this.show = function show() { }
	/**
	 * start the image animation. this method only works if you set multiple images
	 * @alias Titanium_UI_ImageView.start
	 */
	this.start = function start() { }
	/**
	 * stop a started animation and reset the index to the first image
	 * @alias Titanium_UI_ImageView.stop
	 */
	this.stop = function stop() { }
	/**
	 * return the image as a Blob object
	 * @alias Titanium_UI_ImageView.toBlob
	 */
	this.toBlob = function toBlob() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_ImageView.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * A Label is created by the method Titanium.UI.createLabel.
 * @since 0.8
 */
function Titanium_UI_Label() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_Label.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_Label.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Label.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_Label.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_Label.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Label.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * the background color of the view
	 * @alias Titanium_UI_Label.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the view
	 * @alias Titanium_UI_Label.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Label.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_Label.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_Label.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Label.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * background image for the label
	 * @alias Titanium_UI_Label.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the background image for the label
	 * @alias Titanium_UI_Label.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the background image for the label
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Label.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_Label.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_Label.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Label.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * the number of pixels to extend the background image past the label on the bottom
	 * @alias Titanium_UI_Label.backgroundPaddingBottom
	 * @property {Integer}
	 */
	this.backgroundPaddingBottom = 0
	/**
	 * Get the the number of pixels to extend the background image past the label on the bottom
	 * @alias Titanium_UI_Label.getBackgroundPaddingBottom
	 * @return {Integer}
	 */
	this.getBackgroundPaddingBottom = function() { return this.backgroundPaddingBottom; }
	/**
	 * Set the the number of pixels to extend the background image past the label on the bottom
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_Label.setBackgroundPaddingBottom
	 */
	this.setBackgroundPaddingBottom = function(value) { this.backgroundPaddingBottom = value; }
	/**
	 * the number of pixels to extend the background image past the label on the left
	 * @alias Titanium_UI_Label.backgroundPaddingLeft
	 * @property {Integer}
	 */
	this.backgroundPaddingLeft = 0
	/**
	 * Get the the number of pixels to extend the background image past the label on the left
	 * @alias Titanium_UI_Label.getBackgroundPaddingLeft
	 * @return {Integer}
	 */
	this.getBackgroundPaddingLeft = function() { return this.backgroundPaddingLeft; }
	/**
	 * Set the the number of pixels to extend the background image past the label on the left
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_Label.setBackgroundPaddingLeft
	 */
	this.setBackgroundPaddingLeft = function(value) { this.backgroundPaddingLeft = value; }
	/**
	 * the number of pixels to extend the background image past the label on the right
	 * @alias Titanium_UI_Label.backgroundPaddingRight
	 * @property {Integer}
	 */
	this.backgroundPaddingRight = 0
	/**
	 * Get the the number of pixels to extend the background image past the label on the right
	 * @alias Titanium_UI_Label.getBackgroundPaddingRight
	 * @return {Integer}
	 */
	this.getBackgroundPaddingRight = function() { return this.backgroundPaddingRight; }
	/**
	 * Set the the number of pixels to extend the background image past the label on the right
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_Label.setBackgroundPaddingRight
	 */
	this.setBackgroundPaddingRight = function(value) { this.backgroundPaddingRight = value; }
	/**
	 * the number of pixels to extend the background image past the label on the top
	 * @alias Titanium_UI_Label.backgroundPaddingTop
	 * @property {Integer}
	 */
	this.backgroundPaddingTop = 0
	/**
	 * Get the the number of pixels to extend the background image past the label on the top
	 * @alias Titanium_UI_Label.getBackgroundPaddingTop
	 * @return {Integer}
	 */
	this.getBackgroundPaddingTop = function() { return this.backgroundPaddingTop; }
	/**
	 * Set the the number of pixels to extend the background image past the label on the top
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_Label.setBackgroundPaddingTop
	 */
	this.setBackgroundPaddingTop = function(value) { this.backgroundPaddingTop = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_Label.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_Label.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Label.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_Label.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_Label.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Label.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_Label.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_Label.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Label.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_Label.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_Label.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Label.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Label.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Label.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Label.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_Label.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_Label.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Label.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * the color of the label
	 * @alias Titanium_UI_Label.color
	 * @property {String}
	 */
	this.color = ''
	/**
	 * Get the the color of the label
	 * @alias Titanium_UI_Label.getColor
	 * @return {String}
	 */
	this.getColor = function() { return this.color; }
	/**
	 * Set the the color of the label
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Label.setColor
	 */
	this.setColor = function(value) { this.color = value; }
	/**
	 * the label font object properties
	 * @alias Titanium_UI_Label.font
	 * @property {Object}
	 */
	this.font = {}
	/**
	 * Get the the label font object properties
	 * @alias Titanium_UI_Label.getFont
	 * @return {Object}
	 */
	this.getFont = function() { return this.font; }
	/**
	 * Set the the label font object properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Label.setFont
	 */
	this.setFont = function(value) { this.font = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_Label.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_Label.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Label.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * the color of the label when in the highlighted state
	 * @alias Titanium_UI_Label.highlightedColor
	 * @property {String}
	 */
	this.highlightedColor = ''
	/**
	 * Get the the color of the label when in the highlighted state
	 * @alias Titanium_UI_Label.getHighlightedColor
	 * @return {String}
	 */
	this.getHighlightedColor = function() { return this.highlightedColor; }
	/**
	 * Set the the color of the label when in the highlighted state
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Label.setHighlightedColor
	 */
	this.setHighlightedColor = function(value) { this.highlightedColor = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Label.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Label.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Label.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the minimum font size if the label is auto-adjusting based on its contents
	 * @alias Titanium_UI_Label.minimumFontSize
	 * @property {Integer}
	 */
	this.minimumFontSize = 0
	/**
	 * Get the the minimum font size if the label is auto-adjusting based on its contents
	 * @alias Titanium_UI_Label.getMinimumFontSize
	 * @return {Integer}
	 */
	this.getMinimumFontSize = function() { return this.minimumFontSize; }
	/**
	 * Set the the minimum font size if the label is auto-adjusting based on its contents
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_Label.setMinimumFontSize
	 */
	this.setMinimumFontSize = function(value) { this.minimumFontSize = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_Label.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_Label.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Label.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Label.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Label.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Label.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * the text shadow color
	 * @alias Titanium_UI_Label.shadowColor
	 * @property {String}
	 */
	this.shadowColor = ''
	/**
	 * Get the the text shadow color
	 * @alias Titanium_UI_Label.getShadowColor
	 * @return {String}
	 */
	this.getShadowColor = function() { return this.shadowColor; }
	/**
	 * Set the the text shadow color
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Label.setShadowColor
	 */
	this.setShadowColor = function(value) { this.shadowColor = value; }
	/**
	 * the shadow offset as a dictionary with the properties x and y
	 * @alias Titanium_UI_Label.shadowOffset
	 * @property {Object}
	 */
	this.shadowOffset = {}
	/**
	 * Get the the shadow offset as a dictionary with the properties x and y
	 * @alias Titanium_UI_Label.getShadowOffset
	 * @return {Object}
	 */
	this.getShadowOffset = function() { return this.shadowOffset; }
	/**
	 * Set the the shadow offset as a dictionary with the properties x and y
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Label.setShadowOffset
	 */
	this.setShadowOffset = function(value) { this.shadowOffset = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_Label.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_Label.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Label.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * the text of the label
	 * @alias Titanium_UI_Label.text
	 * @property {String}
	 */
	this.text = ''
	/**
	 * Get the the text of the label
	 * @alias Titanium_UI_Label.getText
	 * @return {String}
	 */
	this.getText = function() { return this.text; }
	/**
	 * Set the the text of the label
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Label.setText
	 */
	this.setText = function(value) { this.text = value; }
	/**
	 * the alignment constant or string value such as left, center or right
	 * @alias Titanium_UI_Label.textAlign
	 * @property {String,Integer}
	 */
	this.textAlign = ''
	/**
	 * Get the the alignment constant or string value such as left, center or right
	 * @alias Titanium_UI_Label.getTextAlign
	 * @return {String,Integer}
	 */
	this.getTextAlign = function() { return this.textAlign; }
	/**
	 * Set the the alignment constant or string value such as left, center or right
	 * @param {String,Integer} value New value to set.
	 * @alias Titanium_UI_Label.setTextAlign
	 */
	this.setTextAlign = function(value) { this.textAlign = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Label.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Label.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Label.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_Label.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_Label.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Label.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_Label.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_Label.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Label.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_Label.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_Label.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Label.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_Label.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_Label.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Label.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_Label.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_Label.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_Label.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_Label.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_Label.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_Label.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_Label.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_UI_Label.hide
	 */
	this.hide = function hide() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_Label.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_Label.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_Label.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_Label.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * The Option Dialog is created by Titanium.UI.createOptionDialog and allows you to show a modal dialog of one or more options to the user.
 * @since 0.8
 */
function Titanium_UI_OptionDialog() {
	/**
	 * an index to indicate which button should be the cancel button
	 * @alias Titanium_UI_OptionDialog.cancel
	 * @property {Integer}
	 */
	this.cancel = 0
	/**
	 * Get the an index to indicate which button should be the cancel button
	 * @alias Titanium_UI_OptionDialog.getCancel
	 * @return {Integer}
	 */
	this.getCancel = function() { return this.cancel; }
	/**
	 * Set the an index to indicate which button should be the cancel button
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_OptionDialog.setCancel
	 */
	this.setCancel = function(value) { this.cancel = value; }
	/**
	 * the destructive button (indicated by a visual clue in the UI)
	 * @alias Titanium_UI_OptionDialog.destructive
	 * @property {Integer}
	 */
	this.destructive = 0
	/**
	 * Get the the destructive button (indicated by a visual clue in the UI)
	 * @alias Titanium_UI_OptionDialog.getDestructive
	 * @return {Integer}
	 */
	this.getDestructive = function() { return this.destructive; }
	/**
	 * Set the the destructive button (indicated by a visual clue in the UI)
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_OptionDialog.setDestructive
	 */
	this.setDestructive = function(value) { this.destructive = value; }
	/**
	 * array of button names as strings
	 * @alias Titanium_UI_OptionDialog.options
	 * @property {Array}
	 */
	this.options = []
	/**
	 * Get the array of button names as strings
	 * @alias Titanium_UI_OptionDialog.getOptions
	 * @return {Array}
	 */
	this.getOptions = function() { return this.options; }
	/**
	 * Set the array of button names as strings
	 * @param {Array} value New value to set.
	 * @alias Titanium_UI_OptionDialog.setOptions
	 */
	this.setOptions = function(value) { this.options = value; }
	/**
	 * the title of the dialog
	 * @alias Titanium_UI_OptionDialog.title
	 * @property {String}
	 */
	this.title = ''
	/**
	 * Get the the title of the dialog
	 * @alias Titanium_UI_OptionDialog.getTitle
	 * @return {String}
	 */
	this.getTitle = function() { return this.title; }
	/**
	 * Set the the title of the dialog
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_OptionDialog.setTitle
	 */
	this.setTitle = function(value) { this.title = value; }
	/**
	 * cause the dialog to become visible
	 * @alias Titanium_UI_OptionDialog.show
	 */
	this.show = function show() { }
};

/**
 * A Picker is created by the method Titanium.UI.createPicker.  A Picker can be used to select one or more fixed values.
 * @since 0.8
 */
function Titanium_UI_Picker() {
	/**
	 * array of column values
	 * @alias Titanium_UI_Picker.columns
	 * @property {Array}
	 */
	this.columns = []
	/**
	 * Get the array of column values
	 * @alias Titanium_UI_Picker.getColumns
	 * @return {Array}
	 */
	this.getColumns = function() { return this.columns; }
	/**
	 * Set the array of column values
	 * @param {Array} value New value to set.
	 * @alias Titanium_UI_Picker.setColumns
	 */
	this.setColumns = function(value) { this.columns = value; }
	/**
	 * the duration value in milliseconds for count down timer pickers
	 * @alias Titanium_UI_Picker.countDownDuration
	 * @property {Double}
	 */
	this.countDownDuration = 0.0
	/**
	 * Get the the duration value in milliseconds for count down timer pickers
	 * @alias Titanium_UI_Picker.getCountDownDuration
	 * @return {Double}
	 */
	this.getCountDownDuration = function() { return this.countDownDuration; }
	/**
	 * Set the the duration value in milliseconds for count down timer pickers
	 * @param {Double} value New value to set.
	 * @alias Titanium_UI_Picker.setCountDownDuration
	 */
	this.setCountDownDuration = function(value) { this.countDownDuration = value; }
	/**
	 * the locale used for displaying Date/Time pickers values
	 * @alias Titanium_UI_Picker.locale
	 * @property {String}
	 */
	this.locale = ''
	/**
	 * Get the the locale used for displaying Date/Time pickers values
	 * @alias Titanium_UI_Picker.getLocale
	 * @return {String}
	 */
	this.getLocale = function() { return this.locale; }
	/**
	 * Set the the locale used for displaying Date/Time pickers values
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Picker.setLocale
	 */
	this.setLocale = function(value) { this.locale = value; }
	/**
	 * the maximum Date/Time for value for date pickers
	 * @alias Titanium_UI_Picker.maxDate
	 * @property {Date}
	 */
	this.maxDate = new Date()
	/**
	 * Get the the maximum Date/Time for value for date pickers
	 * @alias Titanium_UI_Picker.getMaxDate
	 * @return {Date}
	 */
	this.getMaxDate = function() { return this.maxDate; }
	/**
	 * Set the the maximum Date/Time for value for date pickers
	 * @param {Date} value New value to set.
	 * @alias Titanium_UI_Picker.setMaxDate
	 */
	this.setMaxDate = function(value) { this.maxDate = value; }
	/**
	 * the minimum Date/Time for value for date pickers
	 * @alias Titanium_UI_Picker.minDate
	 * @property {Date}
	 */
	this.minDate = new Date()
	/**
	 * Get the the minimum Date/Time for value for date pickers
	 * @alias Titanium_UI_Picker.getMinDate
	 * @return {Date}
	 */
	this.getMinDate = function() { return this.minDate; }
	/**
	 * Set the the minimum Date/Time for value for date pickers
	 * @param {Date} value New value to set.
	 * @alias Titanium_UI_Picker.setMinDate
	 */
	this.setMinDate = function(value) { this.minDate = value; }
	/**
	 * property to set the interval displayed by the minutes wheel (for example, 15 minutes). The interval value must be evenly divided into 60; if it is not, the default value is used. The default and minimum values are 1; the maximum value is 30.
	 * @alias Titanium_UI_Picker.minuteInterval
	 * @property {Integer}
	 */
	this.minuteInterval = 0
	/**
	 * Get the property to set the interval displayed by the minutes wheel (for example, 15 minutes). The interval value must be evenly divided into 60; if it is not, the default value is used. The default and minimum values are 1; the maximum value is 30.
	 * @alias Titanium_UI_Picker.getMinuteInterval
	 * @return {Integer}
	 */
	this.getMinuteInterval = function() { return this.minuteInterval; }
	/**
	 * Set the property to set the interval displayed by the minutes wheel (for example, 15 minutes). The interval value must be evenly divided into 60; if it is not, the default value is used. The default and minimum values are 1; the maximum value is 30.
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_Picker.setMinuteInterval
	 */
	this.setMinuteInterval = function(value) { this.minuteInterval = value; }
	/**
	 * for basic picker, boolean value to indicate whether the visual selection style is shown. On the iPhone, this is a blue selected bar.
	 * @alias Titanium_UI_Picker.selectionIndicator
	 * @property {Boolean}
	 */
	this.selectionIndicator = false
	/**
	 * Get the for basic picker, boolean value to indicate whether the visual selection style is shown. On the iPhone, this is a blue selected bar.
	 * @alias Titanium_UI_Picker.getSelectionIndicator
	 * @return {Boolean}
	 */
	this.getSelectionIndicator = function() { return this.selectionIndicator; }
	/**
	 * Set the for basic picker, boolean value to indicate whether the visual selection style is shown. On the iPhone, this is a blue selected bar.
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Picker.setSelectionIndicator
	 */
	this.setSelectionIndicator = function(value) { this.selectionIndicator = value; }
	/**
	 * the type constant for the picker. One of Titanium.UI.PICKER_TYPE_PLAIN (default), Titanium.UI.PICKER_TYPE_DATE_AND_TIME, Titanium.UI.PICKER_TYPE_DATE, Titanium.UI.PICKER_TYPE_TIME or Titanium.UI.PICKER_TYPE_COUNT_DOWN_TIMER.
	 * @alias Titanium_UI_Picker.type
	 * @property {Integer}
	 */
	this.type = 0
	/**
	 * Get the the type constant for the picker. One of Titanium.UI.PICKER_TYPE_PLAIN (default), Titanium.UI.PICKER_TYPE_DATE_AND_TIME, Titanium.UI.PICKER_TYPE_DATE, Titanium.UI.PICKER_TYPE_TIME or Titanium.UI.PICKER_TYPE_COUNT_DOWN_TIMER.
	 * @alias Titanium_UI_Picker.getType
	 * @return {Integer}
	 */
	this.getType = function() { return this.type; }
	/**
	 * Set the the type constant for the picker. One of Titanium.UI.PICKER_TYPE_PLAIN (default), Titanium.UI.PICKER_TYPE_DATE_AND_TIME, Titanium.UI.PICKER_TYPE_DATE, Titanium.UI.PICKER_TYPE_TIME or Titanium.UI.PICKER_TYPE_COUNT_DOWN_TIMER.
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_Picker.setType
	 */
	this.setType = function(value) { this.type = value; }
	/**
	 * the Date/Time value for date pickers
	 * @alias Titanium_UI_Picker.value
	 * @property {Date}
	 */
	this.value = new Date()
	/**
	 * Get the the Date/Time value for date pickers
	 * @alias Titanium_UI_Picker.getValue
	 * @return {Date}
	 */
	this.getValue = function() { return this.value; }
	/**
	 * Set the the Date/Time value for date pickers
	 * @param {Date} value New value to set.
	 * @alias Titanium_UI_Picker.setValue
	 */
	this.setValue = function(value) { this.value = value; }
	/**
	 * add an array of rows, a single row or a column to the picker
	 * @param {Array,Object} data add an array of rows, a single row or a column to the picker
	 * @alias Titanium_UI_Picker.add
	 */
	this.add = function add(data) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_Picker.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_Picker.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * get the selected row object for column
	 * @param {Integer} index for the column index, return the row object or nil if not found
	 * @alias Titanium_UI_Picker.getSelectedRow
	 * @return {Object}
	 */
	this.getSelectedRow = function getSelectedRow(index) { return {}; }
	/**
	 * causes the picker to reload the values from the new column
	 * @param {Object} column new column to load
	 * @alias Titanium_UI_Picker.reloadColumn
	 */
	this.reloadColumn = function reloadColumn(column) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_Picker.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * set the column's row to the selected state
	 * @param {Integer} column the column index
	 * @param {Integer} row the row index
	 * @param {Boolean} animated boolean to indicate if the selection should be animated (default)
	 * @alias Titanium_UI_Picker.setSelectedRow
	 */
	this.setSelectedRow = function setSelectedRow(column,row,animated) { }
};

/**
 * The picker row object created by Titanium.UI.createPickerColumn.
 * @since 0.9
 */
function Titanium_UI_PickerColumn() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_PickerColumn.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_PickerColumn.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_PickerColumn.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_PickerColumn.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * the background color of the view
	 * @alias Titanium_UI_PickerColumn.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the view
	 * @alias Titanium_UI_PickerColumn.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_PickerColumn.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_PickerColumn.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_UI_PickerColumn.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_UI_PickerColumn.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_PickerColumn.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_PickerColumn.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_PickerColumn.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_PickerColumn.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_PickerColumn.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_PickerColumn.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_PickerColumn.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_PickerColumn.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_PickerColumn.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_PickerColumn.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_PickerColumn.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_PickerColumn.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_PickerColumn.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_PickerColumn.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_PickerColumn.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_PickerColumn.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_PickerColumn.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_PickerColumn.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_PickerColumn.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_PickerColumn.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_PickerColumn.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_PickerColumn.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * number of rows in the column (readonly)
	 * @alias Titanium_UI_PickerColumn.rowCount
	 * @property {Integer}
	 */
	this.rowCount = 0
	/**
	 * Get the number of rows in the column (readonly)
	 * @alias Titanium_UI_PickerColumn.getRowCount
	 * @return {Integer}
	 */
	this.getRowCount = function() { return this.rowCount; }
	/**
	 * Set the number of rows in the column (readonly)
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setRowCount
	 */
	this.setRowCount = function(value) { this.rowCount = value; }
	/**
	 * an array of rows
	 * @alias Titanium_UI_PickerColumn.rows
	 * @property {Array}
	 */
	this.rows = []
	/**
	 * Get the an array of rows
	 * @alias Titanium_UI_PickerColumn.getRows
	 * @return {Array}
	 */
	this.getRows = function() { return this.rows; }
	/**
	 * Set the an array of rows
	 * @param {Array} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setRows
	 */
	this.setRows = function(value) { this.rows = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_PickerColumn.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_PickerColumn.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_PickerColumn.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_PickerColumn.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_PickerColumn.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_PickerColumn.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_PickerColumn.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_PickerColumn.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_PickerColumn.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_PickerColumn.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_PickerColumn.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_PickerColumn.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_PickerColumn.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_PickerColumn.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_PickerColumn.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_PickerColumn.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_PickerColumn.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * a Titanium.UI.PickerRow object to add to the column
	 * @alias Titanium_UI_PickerColumn.addRow
	 */
	this.addRow = function addRow() { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_PickerColumn.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_PickerColumn.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_UI_PickerColumn.hide
	 */
	this.hide = function hide() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_PickerColumn.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_PickerColumn.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * a Titanium.UI.PickerRow object to remove
	 * @alias Titanium_UI_PickerColumn.removeRow
	 */
	this.removeRow = function removeRow() { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_PickerColumn.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_PickerColumn.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * The picker row object created by Titanium.UI.createPickerRow.
 * @since 0.9
 */
function Titanium_UI_PickerRow() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_PickerRow.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_PickerRow.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_PickerRow.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_PickerRow.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_PickerRow.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_PickerRow.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * the background color of the view
	 * @alias Titanium_UI_PickerRow.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the view
	 * @alias Titanium_UI_PickerRow.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_PickerRow.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_PickerRow.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_PickerRow.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_PickerRow.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_UI_PickerRow.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_UI_PickerRow.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_PickerRow.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_PickerRow.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_PickerRow.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_PickerRow.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_PickerRow.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_PickerRow.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_PickerRow.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_PickerRow.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_PickerRow.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_PickerRow.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_PickerRow.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_PickerRow.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_PickerRow.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_PickerRow.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_PickerRow.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_PickerRow.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_PickerRow.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_PickerRow.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_PickerRow.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_PickerRow.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_PickerRow.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_PickerRow.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * the font size when displaying the text. ignored when using a custom view
	 * @alias Titanium_UI_PickerRow.fontSize
	 * @property {Integer}
	 */
	this.fontSize = 0
	/**
	 * Get the the font size when displaying the text. ignored when using a custom view
	 * @alias Titanium_UI_PickerRow.getFontSize
	 * @return {Integer}
	 */
	this.getFontSize = function() { return this.fontSize; }
	/**
	 * Set the the font size when displaying the text. ignored when using a custom view
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_PickerRow.setFontSize
	 */
	this.setFontSize = function(value) { this.fontSize = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_PickerRow.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_PickerRow.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_PickerRow.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_PickerRow.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_PickerRow.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_PickerRow.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_PickerRow.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_PickerRow.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_PickerRow.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_PickerRow.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_PickerRow.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_PickerRow.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * when used in the constructor, set the row to selected on initial display
	 * @alias Titanium_UI_PickerRow.selected
	 * @property {Boolean}
	 */
	this.selected = false
	/**
	 * Get the when used in the constructor, set the row to selected on initial display
	 * @alias Titanium_UI_PickerRow.getSelected
	 * @return {Boolean}
	 */
	this.getSelected = function() { return this.selected; }
	/**
	 * Set the when used in the constructor, set the row to selected on initial display
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_PickerRow.setSelected
	 */
	this.setSelected = function(value) { this.selected = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_PickerRow.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_PickerRow.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_PickerRow.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * the display text
	 * @alias Titanium_UI_PickerRow.title
	 * @property {String}
	 */
	this.title = ''
	/**
	 * Get the the display text
	 * @alias Titanium_UI_PickerRow.getTitle
	 * @return {String}
	 */
	this.getTitle = function() { return this.title; }
	/**
	 * Set the the display text
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_PickerRow.setTitle
	 */
	this.setTitle = function(value) { this.title = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_PickerRow.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_PickerRow.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_PickerRow.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_PickerRow.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_PickerRow.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_PickerRow.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_PickerRow.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_PickerRow.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_PickerRow.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_PickerRow.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_PickerRow.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_PickerRow.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_PickerRow.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_PickerRow.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_PickerRow.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_PickerRow.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_PickerRow.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_PickerRow.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_PickerRow.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_PickerRow.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_PickerRow.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_PickerRow.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_UI_PickerRow.hide
	 */
	this.hide = function hide() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_PickerRow.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_PickerRow.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_PickerRow.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_PickerRow.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * A Progress Bar is created by the method Titanium.UI.createProgressBar.
 * @since 0.8
 */
function Titanium_UI_ProgressBar() {
	/**
	 * the color of the progress bar text
	 * @alias Titanium_UI_ProgressBar.color
	 * @property {String}
	 */
	this.color = ''
	/**
	 * Get the the color of the progress bar text
	 * @alias Titanium_UI_ProgressBar.getColor
	 * @return {String}
	 */
	this.getColor = function() { return this.color; }
	/**
	 * Set the the color of the progress bar text
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_ProgressBar.setColor
	 */
	this.setColor = function(value) { this.color = value; }
	/**
	 * the font object for the progress bar text
	 * @alias Titanium_UI_ProgressBar.font
	 * @property {Object}
	 */
	this.font = {}
	/**
	 * Get the the font object for the progress bar text
	 * @alias Titanium_UI_ProgressBar.getFont
	 * @return {Object}
	 */
	this.getFont = function() { return this.font; }
	/**
	 * Set the the font object for the progress bar text
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ProgressBar.setFont
	 */
	this.setFont = function(value) { this.font = value; }
	/**
	 * the maximum value of the progress bar
	 * @alias Titanium_UI_ProgressBar.max
	 * @property {Float}
	 */
	this.max = 0.0
	/**
	 * Get the the maximum value of the progress bar
	 * @alias Titanium_UI_ProgressBar.getMax
	 * @return {Float}
	 */
	this.getMax = function() { return this.max; }
	/**
	 * Set the the maximum value of the progress bar
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ProgressBar.setMax
	 */
	this.setMax = function(value) { this.max = value; }
	/**
	 * the progress bar message
	 * @alias Titanium_UI_ProgressBar.message
	 * @property {String}
	 */
	this.message = ''
	/**
	 * Get the the progress bar message
	 * @alias Titanium_UI_ProgressBar.getMessage
	 * @return {String}
	 */
	this.getMessage = function() { return this.message; }
	/**
	 * Set the the progress bar message
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_ProgressBar.setMessage
	 */
	this.setMessage = function(value) { this.message = value; }
	/**
	 * the minimum value of the progress bar
	 * @alias Titanium_UI_ProgressBar.min
	 * @property {Float}
	 */
	this.min = 0.0
	/**
	 * Get the the minimum value of the progress bar
	 * @alias Titanium_UI_ProgressBar.getMin
	 * @return {Float}
	 */
	this.getMin = function() { return this.min; }
	/**
	 * Set the the minimum value of the progress bar
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ProgressBar.setMin
	 */
	this.setMin = function(value) { this.min = value; }
	/**
	 * the style of the progress bar
	 * @alias Titanium_UI_ProgressBar.style
	 * @property {Integer}
	 */
	this.style = 0
	/**
	 * Get the the style of the progress bar
	 * @alias Titanium_UI_ProgressBar.getStyle
	 * @return {Integer}
	 */
	this.getStyle = function() { return this.style; }
	/**
	 * Set the the style of the progress bar
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_ProgressBar.setStyle
	 */
	this.setStyle = function(value) { this.style = value; }
	/**
	 * the current value of the progress bar
	 * @alias Titanium_UI_ProgressBar.value
	 * @property {Float}
	 */
	this.value = 0.0
	/**
	 * Get the the current value of the progress bar
	 * @alias Titanium_UI_ProgressBar.getValue
	 * @return {Float}
	 */
	this.getValue = function() { return this.value; }
	/**
	 * Set the the current value of the progress bar
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ProgressBar.setValue
	 */
	this.setValue = function(value) { this.value = value; }
};

/**
 * A Scroll View is used to create a scrollable region of content.  Views added to the Scroll View will be scrolled based on the content size of the Scroll View. The Scroll View is created by the method Titanium.UI.createScrollView. Note: In Android, Scroll Views can only scroll in one direction, either vertical or horizontal, but not both at the same time. See the Titanium.UI.ScrollView.scrollType property
 * @since 0.9
 */
function Titanium_UI_ScrollView() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_ScrollView.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_ScrollView.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ScrollView.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_ScrollView.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_ScrollView.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ScrollView.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * the background color of the view
	 * @alias Titanium_UI_ScrollView.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the view
	 * @alias Titanium_UI_ScrollView.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_ScrollView.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_ScrollView.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_ScrollView.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ScrollView.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_UI_ScrollView.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_UI_ScrollView.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_ScrollView.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_ScrollView.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_ScrollView.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ScrollView.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_ScrollView.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_ScrollView.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ScrollView.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_ScrollView.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_ScrollView.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_ScrollView.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_ScrollView.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_ScrollView.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ScrollView.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_ScrollView.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_ScrollView.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ScrollView.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ScrollView.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ScrollView.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_ScrollView.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_ScrollView.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_ScrollView.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ScrollView.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * the height of the scrollable area
	 * @alias Titanium_UI_ScrollView.contentHeight
	 * @property {Float}
	 */
	this.contentHeight = 0.0
	/**
	 * Get the the height of the scrollable area
	 * @alias Titanium_UI_ScrollView.getContentHeight
	 * @return {Float}
	 */
	this.getContentHeight = function() { return this.contentHeight; }
	/**
	 * Set the the height of the scrollable area
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ScrollView.setContentHeight
	 */
	this.setContentHeight = function(value) { this.contentHeight = value; }
	/**
	 * an object (with x and y properties) to indicate the offset of the content area
	 * @alias Titanium_UI_ScrollView.contentOffset
	 * @property {Object}
	 */
	this.contentOffset = {}
	/**
	 * Get the an object (with x and y properties) to indicate the offset of the content area
	 * @alias Titanium_UI_ScrollView.getContentOffset
	 * @return {Object}
	 */
	this.getContentOffset = function() { return this.contentOffset; }
	/**
	 * Set the an object (with x and y properties) to indicate the offset of the content area
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ScrollView.setContentOffset
	 */
	this.setContentOffset = function(value) { this.contentOffset = value; }
	/**
	 * the width of the scrollable area
	 * @alias Titanium_UI_ScrollView.contentWidth
	 * @property {Float}
	 */
	this.contentWidth = 0.0
	/**
	 * Get the the width of the scrollable area
	 * @alias Titanium_UI_ScrollView.getContentWidth
	 * @return {Float}
	 */
	this.getContentWidth = function() { return this.contentWidth; }
	/**
	 * Set the the width of the scrollable area
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ScrollView.setContentWidth
	 */
	this.setContentWidth = function(value) { this.contentWidth = value; }
	/**
	 * boolean to control bounce during scrolling
	 * @alias Titanium_UI_ScrollView.disableBounce
	 * @property {Boolean}
	 */
	this.disableBounce = false
	/**
	 * Get the boolean to control bounce during scrolling
	 * @alias Titanium_UI_ScrollView.getDisableBounce
	 * @return {Boolean}
	 */
	this.getDisableBounce = function() { return this.disableBounce; }
	/**
	 * Set the boolean to control bounce during scrolling
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_ScrollView.setDisableBounce
	 */
	this.setDisableBounce = function(value) { this.disableBounce = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_ScrollView.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_ScrollView.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_ScrollView.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * boolean to control the horizontal bounce during scrolling
	 * @alias Titanium_UI_ScrollView.horizontalBounce
	 * @property {Boolean}
	 */
	this.horizontalBounce = false
	/**
	 * Get the boolean to control the horizontal bounce during scrolling
	 * @alias Titanium_UI_ScrollView.getHorizontalBounce
	 * @return {Boolean}
	 */
	this.getHorizontalBounce = function() { return this.horizontalBounce; }
	/**
	 * Set the boolean to control the horizontal bounce during scrolling
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_ScrollView.setHorizontalBounce
	 */
	this.setHorizontalBounce = function(value) { this.horizontalBounce = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ScrollView.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ScrollView.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_ScrollView.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the maximum scale of the content
	 * @alias Titanium_UI_ScrollView.maxZoomScale
	 * @property {Float}
	 */
	this.maxZoomScale = 0.0
	/**
	 * Get the the maximum scale of the content
	 * @alias Titanium_UI_ScrollView.getMaxZoomScale
	 * @return {Float}
	 */
	this.getMaxZoomScale = function() { return this.maxZoomScale; }
	/**
	 * Set the the maximum scale of the content
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ScrollView.setMaxZoomScale
	 */
	this.setMaxZoomScale = function(value) { this.maxZoomScale = value; }
	/**
	 * the minimum scale of the content
	 * @alias Titanium_UI_ScrollView.minZoomScale
	 * @property {Float}
	 */
	this.minZoomScale = 0.0
	/**
	 * Get the the minimum scale of the content
	 * @alias Titanium_UI_ScrollView.getMinZoomScale
	 * @return {Float}
	 */
	this.getMinZoomScale = function() { return this.minZoomScale; }
	/**
	 * Set the the minimum scale of the content
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ScrollView.setMinZoomScale
	 */
	this.setMinZoomScale = function(value) { this.minZoomScale = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_ScrollView.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_ScrollView.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ScrollView.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ScrollView.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ScrollView.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_ScrollView.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * (Android only) the type of ScrollView: "vertical" or "horizontal"
	 * @alias Titanium_UI_ScrollView.scrollType
	 * @property {String}
	 */
	this.scrollType = ''
	/**
	 * Get the (Android only) the type of ScrollView: "vertical" or "horizontal"
	 * @alias Titanium_UI_ScrollView.getScrollType
	 * @return {String}
	 */
	this.getScrollType = function() { return this.scrollType; }
	/**
	 * Set the (Android only) the type of ScrollView: "vertical" or "horizontal"
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_ScrollView.setScrollType
	 */
	this.setScrollType = function(value) { this.scrollType = value; }
	/**
	 * boolean to indicate whether the horizontal scroll indicator is visible
	 * @alias Titanium_UI_ScrollView.showHorizontalScrollIndicator
	 * @property {Boolean}
	 */
	this.showHorizontalScrollIndicator = false
	/**
	 * Get the boolean to indicate whether the horizontal scroll indicator is visible
	 * @alias Titanium_UI_ScrollView.getShowHorizontalScrollIndicator
	 * @return {Boolean}
	 */
	this.getShowHorizontalScrollIndicator = function() { return this.showHorizontalScrollIndicator; }
	/**
	 * Set the boolean to indicate whether the horizontal scroll indicator is visible
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_ScrollView.setShowHorizontalScrollIndicator
	 */
	this.setShowHorizontalScrollIndicator = function(value) { this.showHorizontalScrollIndicator = value; }
	/**
	 * boolean to indicate whether the vertical scroll indicator is visible
	 * @alias Titanium_UI_ScrollView.showVerticalScrollIndicator
	 * @property {Boolean}
	 */
	this.showVerticalScrollIndicator = false
	/**
	 * Get the boolean to indicate whether the vertical scroll indicator is visible
	 * @alias Titanium_UI_ScrollView.getShowVerticalScrollIndicator
	 * @return {Boolean}
	 */
	this.getShowVerticalScrollIndicator = function() { return this.showVerticalScrollIndicator; }
	/**
	 * Set the boolean to indicate whether the vertical scroll indicator is visible
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_ScrollView.setShowVerticalScrollIndicator
	 */
	this.setShowVerticalScrollIndicator = function(value) { this.showVerticalScrollIndicator = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_ScrollView.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_ScrollView.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ScrollView.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ScrollView.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ScrollView.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_ScrollView.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_ScrollView.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_ScrollView.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_ScrollView.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_ScrollView.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_ScrollView.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ScrollView.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * boolean to control the vertical bounce during scrolling
	 * @alias Titanium_UI_ScrollView.verticalBounce
	 * @property {Boolean}
	 */
	this.verticalBounce = false
	/**
	 * Get the boolean to control the vertical bounce during scrolling
	 * @alias Titanium_UI_ScrollView.getVerticalBounce
	 * @return {Boolean}
	 */
	this.getVerticalBounce = function() { return this.verticalBounce; }
	/**
	 * Set the boolean to control the vertical bounce during scrolling
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_ScrollView.setVerticalBounce
	 */
	this.setVerticalBounce = function(value) { this.verticalBounce = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_ScrollView.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_ScrollView.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_ScrollView.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_ScrollView.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_ScrollView.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_ScrollView.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_ScrollView.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_ScrollView.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_ScrollView.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * set the zoom scale for the current content area
	 * @alias Titanium_UI_ScrollView.zoomScale
	 * @property {Float}
	 */
	this.zoomScale = 0.0
	/**
	 * Get the set the zoom scale for the current content area
	 * @alias Titanium_UI_ScrollView.getZoomScale
	 * @return {Float}
	 */
	this.getZoomScale = function() { return this.zoomScale; }
	/**
	 * Set the set the zoom scale for the current content area
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ScrollView.setZoomScale
	 */
	this.setZoomScale = function(value) { this.zoomScale = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_ScrollView.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_ScrollView.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_ScrollView.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_ScrollView.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_UI_ScrollView.hide
	 */
	this.hide = function hide() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_ScrollView.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_ScrollView.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * scrollTo a particular point
	 * @param {Float} x the x point within the view
	 * @param {Float} y the y point within the view
	 * @alias Titanium_UI_ScrollView.scrollTo
	 */
	this.scrollTo = function scrollTo(x,y) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_ScrollView.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_ScrollView.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * The Scrollable View provides a view that supports horizontal scrolling on one or more views in a gesture motion.  The Scrollable View also optionally supports a visual paging control to indicate the page that the view is visible. The Scrollable View is created by the method Titanium.UI.createScrollableView.
 * @since 0.8
 */
function Titanium_UI_ScrollableView() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_ScrollableView.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_ScrollableView.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_ScrollableView.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_ScrollableView.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * the background color of the view
	 * @alias Titanium_UI_ScrollableView.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the view
	 * @alias Titanium_UI_ScrollableView.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_ScrollableView.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_ScrollableView.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_UI_ScrollableView.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_UI_ScrollableView.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_ScrollableView.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_ScrollableView.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_ScrollableView.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_ScrollableView.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_ScrollableView.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_ScrollableView.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_ScrollableView.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_ScrollableView.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_ScrollableView.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_ScrollableView.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ScrollableView.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ScrollableView.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_ScrollableView.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_ScrollableView.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * the current page visible in the view
	 * @alias Titanium_UI_ScrollableView.currentPage
	 * @property {Integer}
	 */
	this.currentPage = 0
	/**
	 * Get the the current page visible in the view
	 * @alias Titanium_UI_ScrollableView.getCurrentPage
	 * @return {Integer}
	 */
	this.getCurrentPage = function() { return this.currentPage; }
	/**
	 * Set the the current page visible in the view
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setCurrentPage
	 */
	this.setCurrentPage = function(value) { this.currentPage = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_ScrollableView.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_ScrollableView.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ScrollableView.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ScrollableView.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the maximum zoom scale for the view
	 * @alias Titanium_UI_ScrollableView.maxZoomScale
	 * @property {Float}
	 */
	this.maxZoomScale = 0.0
	/**
	 * Get the the maximum zoom scale for the view
	 * @alias Titanium_UI_ScrollableView.getMaxZoomScale
	 * @return {Float}
	 */
	this.getMaxZoomScale = function() { return this.maxZoomScale; }
	/**
	 * Set the the maximum zoom scale for the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setMaxZoomScale
	 */
	this.setMaxZoomScale = function(value) { this.maxZoomScale = value; }
	/**
	 * the minimum zoom scale for the view
	 * @alias Titanium_UI_ScrollableView.minZoomScale
	 * @property {Float}
	 */
	this.minZoomScale = 0.0
	/**
	 * Get the the minimum zoom scale for the view
	 * @alias Titanium_UI_ScrollableView.getMinZoomScale
	 * @return {Float}
	 */
	this.getMinZoomScale = function() { return this.minZoomScale; }
	/**
	 * Set the the minimum zoom scale for the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setMinZoomScale
	 */
	this.setMinZoomScale = function(value) { this.minZoomScale = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_ScrollableView.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_ScrollableView.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * the color of the paging control. defaults to black.
	 * @alias Titanium_UI_ScrollableView.pagingControlColor
	 * @property {String}
	 */
	this.pagingControlColor = ''
	/**
	 * Get the the color of the paging control. defaults to black.
	 * @alias Titanium_UI_ScrollableView.getPagingControlColor
	 * @return {String}
	 */
	this.getPagingControlColor = function() { return this.pagingControlColor; }
	/**
	 * Set the the color of the paging control. defaults to black.
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setPagingControlColor
	 */
	this.setPagingControlColor = function(value) { this.pagingControlColor = value; }
	/**
	 * the height in pixels of the paging control, if visible. defaults to 20
	 * @alias Titanium_UI_ScrollableView.pagingControlHeight
	 * @property {Float}
	 */
	this.pagingControlHeight = 0.0
	/**
	 * Get the the height in pixels of the paging control, if visible. defaults to 20
	 * @alias Titanium_UI_ScrollableView.getPagingControlHeight
	 * @return {Float}
	 */
	this.getPagingControlHeight = function() { return this.pagingControlHeight; }
	/**
	 * Set the the height in pixels of the paging control, if visible. defaults to 20
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setPagingControlHeight
	 */
	this.setPagingControlHeight = function(value) { this.pagingControlHeight = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ScrollableView.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ScrollableView.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * boolean to indicate whether the paging control UI is visible
	 * @alias Titanium_UI_ScrollableView.showPagingControl
	 * @property {Boolean}
	 */
	this.showPagingControl = false
	/**
	 * Get the boolean to indicate whether the paging control UI is visible
	 * @alias Titanium_UI_ScrollableView.getShowPagingControl
	 * @return {Boolean}
	 */
	this.getShowPagingControl = function() { return this.showPagingControl; }
	/**
	 * Set the boolean to indicate whether the paging control UI is visible
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setShowPagingControl
	 */
	this.setShowPagingControl = function(value) { this.showPagingControl = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_ScrollableView.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_ScrollableView.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ScrollableView.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_ScrollableView.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_ScrollableView.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_ScrollableView.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_ScrollableView.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_ScrollableView.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * array of view objects to place in the view
	 * @alias Titanium_UI_ScrollableView.views
	 * @property {Array}
	 */
	this.views = []
	/**
	 * Get the array of view objects to place in the view
	 * @alias Titanium_UI_ScrollableView.getViews
	 * @return {Array}
	 */
	this.getViews = function() { return this.views; }
	/**
	 * Set the array of view objects to place in the view
	 * @param {Array} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setViews
	 */
	this.setViews = function(value) { this.views = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_ScrollableView.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_ScrollableView.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_ScrollableView.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_ScrollableView.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_ScrollableView.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_ScrollableView.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_ScrollableView.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_ScrollableView.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_ScrollableView.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * add a new view to the Scrollable View
	 * @param {Object} view the view to add
	 * @alias Titanium_UI_ScrollableView.addView
	 */
	this.addView = function addView(view) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_ScrollableView.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_ScrollableView.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_UI_ScrollableView.hide
	 */
	this.hide = function hide() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_ScrollableView.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_ScrollableView.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * remove an existing view from the Scrollable View
	 * @param {Object} view the view to remove
	 * @alias Titanium_UI_ScrollableView.removeView
	 */
	this.removeView = function removeView(view) { }
	/**
	 * scroll to a specific view
	 * @param {Integer,Object} view either an integer index or the view object to bring into view as the currentPage
	 * @alias Titanium_UI_ScrollableView.scrollToView
	 */
	this.scrollToView = function scrollToView(view) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_ScrollableView.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_ScrollableView.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * A Search Bar is created by the method Titanium.UI.createSearchBar.
 * @since 0.8
 */
function Titanium_UI_SearchBar() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_SearchBar.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_SearchBar.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_SearchBar.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_SearchBar.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_SearchBar.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_SearchBar.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * boolean to indicate if the text in the field should be autocapitalized as typed
	 * @alias Titanium_UI_SearchBar.autocapitalization
	 * @property {Boolean}
	 */
	this.autocapitalization = false
	/**
	 * Get the boolean to indicate if the text in the field should be autocapitalized as typed
	 * @alias Titanium_UI_SearchBar.getAutocapitalization
	 * @return {Boolean}
	 */
	this.getAutocapitalization = function() { return this.autocapitalization; }
	/**
	 * Set the boolean to indicate if the text in the field should be autocapitalized as typed
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_SearchBar.setAutocapitalization
	 */
	this.setAutocapitalization = function(value) { this.autocapitalization = value; }
	/**
	 * boolean to indicate if the text in the field should be autocorrected as typed
	 * @alias Titanium_UI_SearchBar.autocorrect
	 * @property {Boolean}
	 */
	this.autocorrect = false
	/**
	 * Get the boolean to indicate if the text in the field should be autocorrected as typed
	 * @alias Titanium_UI_SearchBar.getAutocorrect
	 * @return {Boolean}
	 */
	this.getAutocorrect = function() { return this.autocorrect; }
	/**
	 * Set the boolean to indicate if the text in the field should be autocorrected as typed
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_SearchBar.setAutocorrect
	 */
	this.setAutocorrect = function(value) { this.autocorrect = value; }
	/**
	 * the background color of the view
	 * @alias Titanium_UI_SearchBar.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the view
	 * @alias Titanium_UI_SearchBar.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_SearchBar.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_SearchBar.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_SearchBar.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_SearchBar.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_UI_SearchBar.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_UI_SearchBar.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_SearchBar.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_SearchBar.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_SearchBar.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_SearchBar.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_SearchBar.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_SearchBar.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_SearchBar.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the bar color of the search bar view
	 * @alias Titanium_UI_SearchBar.barColor
	 * @property {String}
	 */
	this.barColor = ''
	/**
	 * Get the the bar color of the search bar view
	 * @alias Titanium_UI_SearchBar.getBarColor
	 * @return {String}
	 */
	this.getBarColor = function() { return this.barColor; }
	/**
	 * Set the the bar color of the search bar view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_SearchBar.setBarColor
	 */
	this.setBarColor = function(value) { this.barColor = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_SearchBar.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_SearchBar.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_SearchBar.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_SearchBar.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_SearchBar.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_SearchBar.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_SearchBar.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_SearchBar.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_SearchBar.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_SearchBar.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_SearchBar.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_SearchBar.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_SearchBar.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_SearchBar.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_SearchBar.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_SearchBar.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_SearchBar.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_SearchBar.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * the text to show when the search bar field is not focused
	 * @alias Titanium_UI_SearchBar.hintText
	 * @property {String}
	 */
	this.hintText = ''
	/**
	 * Get the the text to show when the search bar field is not focused
	 * @alias Titanium_UI_SearchBar.getHintText
	 * @return {String}
	 */
	this.getHintText = function() { return this.hintText; }
	/**
	 * Set the the text to show when the search bar field is not focused
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_SearchBar.setHintText
	 */
	this.setHintText = function(value) { this.hintText = value; }
	/**
	 * the keyboard type constant to use when the field is focused
	 * @alias Titanium_UI_SearchBar.keyboardType
	 * @property {Integer}
	 */
	this.keyboardType = 0
	/**
	 * Get the the keyboard type constant to use when the field is focused
	 * @alias Titanium_UI_SearchBar.getKeyboardType
	 * @return {Integer}
	 */
	this.getKeyboardType = function() { return this.keyboardType; }
	/**
	 * Set the the keyboard type constant to use when the field is focused
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_SearchBar.setKeyboardType
	 */
	this.setKeyboardType = function(value) { this.keyboardType = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_SearchBar.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_SearchBar.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_SearchBar.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_SearchBar.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_SearchBar.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_SearchBar.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * a single line of text displayed at the top of the search bar
	 * @alias Titanium_UI_SearchBar.prompt
	 * @property {String}
	 */
	this.prompt = ''
	/**
	 * Get the a single line of text displayed at the top of the search bar
	 * @alias Titanium_UI_SearchBar.getPrompt
	 * @return {String}
	 */
	this.getPrompt = function() { return this.prompt; }
	/**
	 * Set the a single line of text displayed at the top of the search bar
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_SearchBar.setPrompt
	 */
	this.setPrompt = function(value) { this.prompt = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_SearchBar.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_SearchBar.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_SearchBar.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * boolean indicates whether the cancel button is displayed
	 * @alias Titanium_UI_SearchBar.showCancel
	 * @property {Boolean}
	 */
	this.showCancel = false
	/**
	 * Get the boolean indicates whether the cancel button is displayed
	 * @alias Titanium_UI_SearchBar.getShowCancel
	 * @return {Boolean}
	 */
	this.getShowCancel = function() { return this.showCancel; }
	/**
	 * Set the boolean indicates whether the cancel button is displayed
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_SearchBar.setShowCancel
	 */
	this.setShowCancel = function(value) { this.showCancel = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_SearchBar.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_SearchBar.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_SearchBar.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_SearchBar.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_SearchBar.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_SearchBar.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_SearchBar.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_SearchBar.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_SearchBar.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_SearchBar.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_SearchBar.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_SearchBar.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * the value of the search bar
	 * @alias Titanium_UI_SearchBar.value
	 * @property {String}
	 */
	this.value = ''
	/**
	 * Get the the value of the search bar
	 * @alias Titanium_UI_SearchBar.getValue
	 * @return {String}
	 */
	this.getValue = function() { return this.value; }
	/**
	 * Set the the value of the search bar
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_SearchBar.setValue
	 */
	this.setValue = function(value) { this.value = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_SearchBar.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_SearchBar.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_SearchBar.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_SearchBar.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_SearchBar.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_SearchBar.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_SearchBar.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_SearchBar.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_SearchBar.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_SearchBar.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_SearchBar.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_SearchBar.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * called to force the search bar to lose focus
	 * @alias Titanium_UI_SearchBar.blur
	 */
	this.blur = function blur() { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_SearchBar.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * called to force the search bar to focus
	 * @alias Titanium_UI_SearchBar.focus
	 */
	this.focus = function focus() { }
	/**
	 * hide the view
	 * @alias Titanium_UI_SearchBar.hide
	 */
	this.hide = function hide() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_SearchBar.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_SearchBar.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_SearchBar.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_SearchBar.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * A Slider is created by the method Titanium.UI.createSlider.
 * @since 0.8
 */
function Titanium_UI_Slider() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_Slider.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_Slider.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Slider.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_Slider.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_Slider.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Slider.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * the background color of the view
	 * @alias Titanium_UI_Slider.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the view
	 * @alias Titanium_UI_Slider.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Slider.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_Slider.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_Slider.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Slider.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_UI_Slider.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_UI_Slider.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Slider.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_Slider.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_Slider.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Slider.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_Slider.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_Slider.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Slider.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_Slider.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_Slider.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Slider.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_Slider.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_Slider.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Slider.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_Slider.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_Slider.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Slider.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Slider.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Slider.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Slider.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_Slider.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_Slider.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Slider.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * the image url of the slider left track when in the disabled state
	 * @alias Titanium_UI_Slider.disabledLeftTrackImage
	 * @property {String}
	 */
	this.disabledLeftTrackImage = ''
	/**
	 * Get the the image url of the slider left track when in the disabled state
	 * @alias Titanium_UI_Slider.getDisabledLeftTrackImage
	 * @return {String}
	 */
	this.getDisabledLeftTrackImage = function() { return this.disabledLeftTrackImage; }
	/**
	 * Set the the image url of the slider left track when in the disabled state
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Slider.setDisabledLeftTrackImage
	 */
	this.setDisabledLeftTrackImage = function(value) { this.disabledLeftTrackImage = value; }
	/**
	 * the image url of the slider right track when in the disabled state
	 * @alias Titanium_UI_Slider.disabledRightTrackImage
	 * @property {String}
	 */
	this.disabledRightTrackImage = ''
	/**
	 * Get the the image url of the slider right track when in the disabled state
	 * @alias Titanium_UI_Slider.getDisabledRightTrackImage
	 * @return {String}
	 */
	this.getDisabledRightTrackImage = function() { return this.disabledRightTrackImage; }
	/**
	 * Set the the image url of the slider right track when in the disabled state
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Slider.setDisabledRightTrackImage
	 */
	this.setDisabledRightTrackImage = function(value) { this.disabledRightTrackImage = value; }
	/**
	 * the image url of the slider thumb when in the disabled state
	 * @alias Titanium_UI_Slider.disabledThumbImage
	 * @property {String}
	 */
	this.disabledThumbImage = ''
	/**
	 * Get the the image url of the slider thumb when in the disabled state
	 * @alias Titanium_UI_Slider.getDisabledThumbImage
	 * @return {String}
	 */
	this.getDisabledThumbImage = function() { return this.disabledThumbImage; }
	/**
	 * Set the the image url of the slider thumb when in the disabled state
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Slider.setDisabledThumbImage
	 */
	this.setDisabledThumbImage = function(value) { this.disabledThumbImage = value; }
	/**
	 * boolean to indicate the enabled state of the slider
	 * @alias Titanium_UI_Slider.enabled
	 * @property {Boolean}
	 */
	this.enabled = false
	/**
	 * Get the boolean to indicate the enabled state of the slider
	 * @alias Titanium_UI_Slider.getEnabled
	 * @return {Boolean}
	 */
	this.getEnabled = function() { return this.enabled; }
	/**
	 * Set the boolean to indicate the enabled state of the slider
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Slider.setEnabled
	 */
	this.setEnabled = function(value) { this.enabled = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_Slider.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_Slider.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Slider.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * the image url of the slider left track when in the highlighted state
	 * @alias Titanium_UI_Slider.highlightedLeftTrackImage
	 * @property {String}
	 */
	this.highlightedLeftTrackImage = ''
	/**
	 * Get the the image url of the slider left track when in the highlighted state
	 * @alias Titanium_UI_Slider.getHighlightedLeftTrackImage
	 * @return {String}
	 */
	this.getHighlightedLeftTrackImage = function() { return this.highlightedLeftTrackImage; }
	/**
	 * Set the the image url of the slider left track when in the highlighted state
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Slider.setHighlightedLeftTrackImage
	 */
	this.setHighlightedLeftTrackImage = function(value) { this.highlightedLeftTrackImage = value; }
	/**
	 * the image url of the slider right track when in the highlighted state
	 * @alias Titanium_UI_Slider.highlightedRightTrackImage
	 * @property {String}
	 */
	this.highlightedRightTrackImage = ''
	/**
	 * Get the the image url of the slider right track when in the highlighted state
	 * @alias Titanium_UI_Slider.getHighlightedRightTrackImage
	 * @return {String}
	 */
	this.getHighlightedRightTrackImage = function() { return this.highlightedRightTrackImage; }
	/**
	 * Set the the image url of the slider right track when in the highlighted state
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Slider.setHighlightedRightTrackImage
	 */
	this.setHighlightedRightTrackImage = function(value) { this.highlightedRightTrackImage = value; }
	/**
	 * the image url of the slider thumb when in the highlighted state
	 * @alias Titanium_UI_Slider.highlightedThumbImage
	 * @property {String}
	 */
	this.highlightedThumbImage = ''
	/**
	 * Get the the image url of the slider thumb when in the highlighted state
	 * @alias Titanium_UI_Slider.getHighlightedThumbImage
	 * @return {String}
	 */
	this.getHighlightedThumbImage = function() { return this.highlightedThumbImage; }
	/**
	 * Set the the image url of the slider thumb when in the highlighted state
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Slider.setHighlightedThumbImage
	 */
	this.setHighlightedThumbImage = function(value) { this.highlightedThumbImage = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Slider.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Slider.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Slider.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the image url of the slider left track
	 * @alias Titanium_UI_Slider.leftTrackImage
	 * @property {String}
	 */
	this.leftTrackImage = ''
	/**
	 * Get the the image url of the slider left track
	 * @alias Titanium_UI_Slider.getLeftTrackImage
	 * @return {String}
	 */
	this.getLeftTrackImage = function() { return this.leftTrackImage; }
	/**
	 * Set the the image url of the slider left track
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Slider.setLeftTrackImage
	 */
	this.setLeftTrackImage = function(value) { this.leftTrackImage = value; }
	/**
	 * the maximum slider value
	 * @alias Titanium_UI_Slider.max
	 * @property {Float}
	 */
	this.max = 0.0
	/**
	 * Get the the maximum slider value
	 * @alias Titanium_UI_Slider.getMax
	 * @return {Float}
	 */
	this.getMax = function() { return this.max; }
	/**
	 * Set the the maximum slider value
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Slider.setMax
	 */
	this.setMax = function(value) { this.max = value; }
	/**
	 * the minimum slider value
	 * @alias Titanium_UI_Slider.min
	 * @property {Float}
	 */
	this.min = 0.0
	/**
	 * Get the the minimum slider value
	 * @alias Titanium_UI_Slider.getMin
	 * @return {Float}
	 */
	this.getMin = function() { return this.min; }
	/**
	 * Set the the minimum slider value
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Slider.setMin
	 */
	this.setMin = function(value) { this.min = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_Slider.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_Slider.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Slider.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Slider.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Slider.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Slider.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * the image url of the slider right track
	 * @alias Titanium_UI_Slider.rightTrackImage
	 * @property {String}
	 */
	this.rightTrackImage = ''
	/**
	 * Get the the image url of the slider right track
	 * @alias Titanium_UI_Slider.getRightTrackImage
	 * @return {String}
	 */
	this.getRightTrackImage = function() { return this.rightTrackImage; }
	/**
	 * Set the the image url of the slider right track
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Slider.setRightTrackImage
	 */
	this.setRightTrackImage = function(value) { this.rightTrackImage = value; }
	/**
	 * the image url of the slider left track when in the selected state
	 * @alias Titanium_UI_Slider.selectedLeftTrackImage
	 * @property {String}
	 */
	this.selectedLeftTrackImage = ''
	/**
	 * Get the the image url of the slider left track when in the selected state
	 * @alias Titanium_UI_Slider.getSelectedLeftTrackImage
	 * @return {String}
	 */
	this.getSelectedLeftTrackImage = function() { return this.selectedLeftTrackImage; }
	/**
	 * Set the the image url of the slider left track when in the selected state
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Slider.setSelectedLeftTrackImage
	 */
	this.setSelectedLeftTrackImage = function(value) { this.selectedLeftTrackImage = value; }
	/**
	 * the image url of the slider right track when in the selected state
	 * @alias Titanium_UI_Slider.selectedRightTrackImage
	 * @property {String}
	 */
	this.selectedRightTrackImage = ''
	/**
	 * Get the the image url of the slider right track when in the selected state
	 * @alias Titanium_UI_Slider.getSelectedRightTrackImage
	 * @return {String}
	 */
	this.getSelectedRightTrackImage = function() { return this.selectedRightTrackImage; }
	/**
	 * Set the the image url of the slider right track when in the selected state
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Slider.setSelectedRightTrackImage
	 */
	this.setSelectedRightTrackImage = function(value) { this.selectedRightTrackImage = value; }
	/**
	 * the image url of the slider thumb when in the selected state
	 * @alias Titanium_UI_Slider.selectedThumbImage
	 * @property {String}
	 */
	this.selectedThumbImage = ''
	/**
	 * Get the the image url of the slider thumb when in the selected state
	 * @alias Titanium_UI_Slider.getSelectedThumbImage
	 * @return {String}
	 */
	this.getSelectedThumbImage = function() { return this.selectedThumbImage; }
	/**
	 * Set the the image url of the slider thumb when in the selected state
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Slider.setSelectedThumbImage
	 */
	this.setSelectedThumbImage = function(value) { this.selectedThumbImage = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_Slider.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_Slider.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Slider.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * the image url to the slider thumb
	 * @alias Titanium_UI_Slider.thumbImage
	 * @property {String}
	 */
	this.thumbImage = ''
	/**
	 * Get the the image url to the slider thumb
	 * @alias Titanium_UI_Slider.getThumbImage
	 * @return {String}
	 */
	this.getThumbImage = function() { return this.thumbImage; }
	/**
	 * Set the the image url to the slider thumb
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Slider.setThumbImage
	 */
	this.setThumbImage = function(value) { this.thumbImage = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Slider.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Slider.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Slider.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_Slider.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_Slider.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Slider.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_Slider.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_Slider.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Slider.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * the value of the slider
	 * @alias Titanium_UI_Slider.value
	 * @property {String}
	 */
	this.value = ''
	/**
	 * Get the the value of the slider
	 * @alias Titanium_UI_Slider.getValue
	 * @return {String}
	 */
	this.getValue = function() { return this.value; }
	/**
	 * Set the the value of the slider
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Slider.setValue
	 */
	this.setValue = function(value) { this.value = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_Slider.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_Slider.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Slider.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_Slider.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_Slider.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Slider.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_Slider.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_Slider.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_Slider.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_Slider.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_Slider.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_Slider.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_Slider.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_UI_Slider.hide
	 */
	this.hide = function hide() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_Slider.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_Slider.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_Slider.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_Slider.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * A Switch is created by the method Titanium.UI.createSwitch.
 * @since 0.8
 */
function Titanium_UI_Switch() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_Switch.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_Switch.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Switch.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_Switch.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_Switch.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Switch.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * the background color of the view
	 * @alias Titanium_UI_Switch.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the view
	 * @alias Titanium_UI_Switch.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Switch.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_Switch.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_Switch.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Switch.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_UI_Switch.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_UI_Switch.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Switch.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_Switch.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_Switch.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Switch.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_Switch.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_Switch.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Switch.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_Switch.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_Switch.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Switch.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_Switch.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_Switch.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Switch.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_Switch.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_Switch.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Switch.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Switch.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Switch.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Switch.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_Switch.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_Switch.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Switch.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * boolean for the state of the switch
	 * @alias Titanium_UI_Switch.enabled
	 * @property {Boolean}
	 */
	this.enabled = false
	/**
	 * Get the boolean for the state of the switch
	 * @alias Titanium_UI_Switch.getEnabled
	 * @return {Boolean}
	 */
	this.getEnabled = function() { return this.enabled; }
	/**
	 * Set the boolean for the state of the switch
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Switch.setEnabled
	 */
	this.setEnabled = function(value) { this.enabled = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_Switch.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_Switch.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Switch.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Switch.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Switch.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Switch.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_Switch.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_Switch.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Switch.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Switch.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Switch.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Switch.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_Switch.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_Switch.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Switch.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Switch.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Switch.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Switch.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_Switch.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_Switch.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Switch.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_Switch.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_Switch.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Switch.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * boolean value of the switch where true is the switch is on and false the switch if off
	 * @alias Titanium_UI_Switch.value
	 * @property {Boolean}
	 */
	this.value = false
	/**
	 * Get the boolean value of the switch where true is the switch is on and false the switch if off
	 * @alias Titanium_UI_Switch.getValue
	 * @return {Boolean}
	 */
	this.getValue = function() { return this.value; }
	/**
	 * Set the boolean value of the switch where true is the switch is on and false the switch if off
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Switch.setValue
	 */
	this.setValue = function(value) { this.value = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_Switch.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_Switch.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Switch.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_Switch.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_Switch.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Switch.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_Switch.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_Switch.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_Switch.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_Switch.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_Switch.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_Switch.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_Switch.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_UI_Switch.hide
	 */
	this.hide = function hide() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_Switch.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_Switch.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_Switch.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_Switch.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * A TabGroup Tab instance.  Each Tab instance maintains a stack of tab windows. Only one window within in the Tab can be visible at a time.  When a window is closed, either by the user or by code, the window is removed from the stack, make the previous window visible. The root tab window cannot be removed. The Tab Group is created by the method Titanium.UI.createTab.
 * @since 0.8
 */
function Titanium_UI_Tab() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_Tab.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_Tab.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Tab.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_Tab.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_Tab.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Tab.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * the background color of the view
	 * @alias Titanium_UI_Tab.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the view
	 * @alias Titanium_UI_Tab.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Tab.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_Tab.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_Tab.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Tab.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_UI_Tab.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_UI_Tab.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Tab.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_Tab.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_Tab.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Tab.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_Tab.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_Tab.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Tab.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the badge value for the tab group for this tab. null indicates no badge is value
	 * @alias Titanium_UI_Tab.badge
	 * @property {String}
	 */
	this.badge = ''
	/**
	 * Get the the badge value for the tab group for this tab. null indicates no badge is value
	 * @alias Titanium_UI_Tab.getBadge
	 * @return {String}
	 */
	this.getBadge = function() { return this.badge; }
	/**
	 * Set the the badge value for the tab group for this tab. null indicates no badge is value
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Tab.setBadge
	 */
	this.setBadge = function(value) { this.badge = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_Tab.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_Tab.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Tab.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_Tab.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_Tab.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Tab.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_Tab.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_Tab.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Tab.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Tab.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Tab.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Tab.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_Tab.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_Tab.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Tab.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_Tab.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_Tab.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Tab.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * the icon url for the tab group for this tab
	 * @alias Titanium_UI_Tab.icon
	 * @property {String}
	 */
	this.icon = ''
	/**
	 * Get the the icon url for the tab group for this tab
	 * @alias Titanium_UI_Tab.getIcon
	 * @return {String}
	 */
	this.getIcon = function() { return this.icon; }
	/**
	 * Set the the icon url for the tab group for this tab
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Tab.setIcon
	 */
	this.setIcon = function(value) { this.icon = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Tab.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Tab.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Tab.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_Tab.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_Tab.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Tab.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Tab.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Tab.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Tab.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_Tab.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_Tab.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Tab.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * the title for the tab group for this tab
	 * @alias Titanium_UI_Tab.title
	 * @property {String}
	 */
	this.title = ''
	/**
	 * Get the the title for the tab group for this tab
	 * @alias Titanium_UI_Tab.getTitle
	 * @return {String}
	 */
	this.getTitle = function() { return this.title; }
	/**
	 * Set the the title for the tab group for this tab
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Tab.setTitle
	 */
	this.setTitle = function(value) { this.title = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Tab.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Tab.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Tab.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_Tab.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_Tab.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Tab.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_Tab.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_Tab.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Tab.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_Tab.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_Tab.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Tab.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_Tab.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_Tab.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Tab.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the root level tab window.  all tabs must have at least one root level tab window.
	 * @alias Titanium_UI_Tab.window
	 * @property {Object}
	 */
	this.window = {}
	/**
	 * Get the the root level tab window.  all tabs must have at least one root level tab window.
	 * @alias Titanium_UI_Tab.getWindow
	 * @return {Object}
	 */
	this.getWindow = function() { return this.window; }
	/**
	 * Set the the root level tab window.  all tabs must have at least one root level tab window.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Tab.setWindow
	 */
	this.setWindow = function(value) { this.window = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_Tab.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_Tab.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_Tab.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_Tab.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_Tab.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_Tab.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_Tab.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_UI_Tab.hide
	 */
	this.hide = function hide() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_Tab.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_Tab.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_Tab.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_Tab.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * The Tab Group allows you to manage a tabbed UI of one or more windows. The Tab Group is created by the method Titanium.UI.createTabGroup.
 * @since 0.9
 */
function Titanium_UI_TabGroup() {
	/**
	 * the active tab
	 * @alias Titanium_UI_TabGroup.activeTab
	 * @property {Object}
	 */
	this.activeTab = {}
	/**
	 * Get the the active tab
	 * @alias Titanium_UI_TabGroup.getActiveTab
	 * @return {Object}
	 */
	this.getActiveTab = function() { return this.activeTab; }
	/**
	 * Set the the active tab
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TabGroup.setActiveTab
	 */
	this.setActiveTab = function(value) { this.activeTab = value; }
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_TabGroup.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_TabGroup.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TabGroup.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_TabGroup.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_TabGroup.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TabGroup.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * the background color of the view
	 * @alias Titanium_UI_TabGroup.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the view
	 * @alias Titanium_UI_TabGroup.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TabGroup.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_TabGroup.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_TabGroup.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TabGroup.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_UI_TabGroup.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_UI_TabGroup.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TabGroup.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_TabGroup.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_TabGroup.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TabGroup.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_TabGroup.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_TabGroup.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TabGroup.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the bar color
	 * @alias Titanium_UI_TabGroup.barColor
	 * @property {String}
	 */
	this.barColor = ''
	/**
	 * Get the the bar color
	 * @alias Titanium_UI_TabGroup.getBarColor
	 * @return {String}
	 */
	this.getBarColor = function() { return this.barColor; }
	/**
	 * Set the the bar color
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TabGroup.setBarColor
	 */
	this.setBarColor = function(value) { this.barColor = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_TabGroup.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_TabGroup.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TabGroup.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_TabGroup.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_TabGroup.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TabGroup.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_TabGroup.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_TabGroup.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TabGroup.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TabGroup.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TabGroup.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TabGroup.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_TabGroup.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_TabGroup.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TabGroup.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_TabGroup.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_TabGroup.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TabGroup.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TabGroup.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TabGroup.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TabGroup.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_TabGroup.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_TabGroup.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TabGroup.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TabGroup.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TabGroup.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TabGroup.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_TabGroup.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_TabGroup.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TabGroup.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * array of tab objects that are managed by the tab group
	 * @alias Titanium_UI_TabGroup.tabs
	 * @property {Array}
	 */
	this.tabs = []
	/**
	 * Get the array of tab objects that are managed by the tab group
	 * @alias Titanium_UI_TabGroup.getTabs
	 * @return {Array}
	 */
	this.getTabs = function() { return this.tabs; }
	/**
	 * Set the array of tab objects that are managed by the tab group
	 * @param {Array} value New value to set.
	 * @alias Titanium_UI_TabGroup.setTabs
	 */
	this.setTabs = function(value) { this.tabs = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TabGroup.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TabGroup.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TabGroup.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_TabGroup.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_TabGroup.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TabGroup.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_TabGroup.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_TabGroup.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TabGroup.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_TabGroup.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_TabGroup.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TabGroup.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_TabGroup.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_TabGroup.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TabGroup.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_TabGroup.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_TabGroup.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_TabGroup.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_TabGroup.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_TabGroup.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * add a tab to the tab group
	 * @alias Titanium_UI_TabGroup.addTab
	 */
	this.addTab = function addTab() { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_TabGroup.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * close the tab group and remove it from the UI
	 * @alias Titanium_UI_TabGroup.close
	 */
	this.close = function close() { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_TabGroup.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_UI_TabGroup.hide
	 */
	this.hide = function hide() { }
	/**
	 * open the tab group and make it visible
	 * @alias Titanium_UI_TabGroup.open
	 */
	this.open = function open() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_TabGroup.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_TabGroup.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * remove a tab from the tab group
	 * @alias Titanium_UI_TabGroup.removeTab
	 */
	this.removeTab = function removeTab() { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_TabGroup.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_TabGroup.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * A Tabbed Bar is created by the method Titanium.UI.createTabbedBar. The difference between the Tabbed Bar and the Button Bar is that the tabbed bar visually maintains a state (visually distinguished as a pressed or selected look).
 * @since 0.8
 */
function Titanium_UI_TabbedBar() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_TabbedBar.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_TabbedBar.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_TabbedBar.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_TabbedBar.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * the background color of the tabbed bar
	 * @alias Titanium_UI_TabbedBar.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the tabbed bar
	 * @alias Titanium_UI_TabbedBar.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the tabbed bar
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_TabbedBar.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_TabbedBar.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_UI_TabbedBar.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_UI_TabbedBar.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_TabbedBar.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_TabbedBar.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_TabbedBar.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_TabbedBar.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_TabbedBar.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_TabbedBar.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_TabbedBar.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_TabbedBar.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_TabbedBar.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_TabbedBar.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TabbedBar.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TabbedBar.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_TabbedBar.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_TabbedBar.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_TabbedBar.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_TabbedBar.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * the selected index
	 * @alias Titanium_UI_TabbedBar.index
	 * @property {Integer}
	 */
	this.index = 0
	/**
	 * Get the the selected index
	 * @alias Titanium_UI_TabbedBar.getIndex
	 * @return {Integer}
	 */
	this.getIndex = function() { return this.index; }
	/**
	 * Set the the selected index
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setIndex
	 */
	this.setIndex = function(value) { this.index = value; }
	/**
	 * the array of labels for the tabbed bar. each object should have the properties title, image, width and enabled.
	 * @alias Titanium_UI_TabbedBar.labels
	 * @property {Array}
	 */
	this.labels = []
	/**
	 * Get the the array of labels for the tabbed bar. each object should have the properties title, image, width and enabled.
	 * @alias Titanium_UI_TabbedBar.getLabels
	 * @return {Array}
	 */
	this.getLabels = function() { return this.labels; }
	/**
	 * Set the the array of labels for the tabbed bar. each object should have the properties title, image, width and enabled.
	 * @param {Array} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setLabels
	 */
	this.setLabels = function(value) { this.labels = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TabbedBar.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TabbedBar.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_TabbedBar.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_TabbedBar.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TabbedBar.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TabbedBar.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_TabbedBar.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_TabbedBar.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * the style of the tabbed bar
	 * @alias Titanium_UI_TabbedBar.style
	 * @property {Integer}
	 */
	this.style = 0
	/**
	 * Get the the style of the tabbed bar
	 * @alias Titanium_UI_TabbedBar.getStyle
	 * @return {Integer}
	 */
	this.getStyle = function() { return this.style; }
	/**
	 * Set the the style of the tabbed bar
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setStyle
	 */
	this.setStyle = function(value) { this.style = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TabbedBar.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TabbedBar.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_TabbedBar.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_TabbedBar.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_TabbedBar.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_TabbedBar.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_TabbedBar.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_TabbedBar.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_TabbedBar.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_TabbedBar.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_TabbedBar.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_TabbedBar.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_TabbedBar.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_TabbedBar.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_TabbedBar.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_TabbedBar.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_TabbedBar.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_UI_TabbedBar.hide
	 */
	this.hide = function hide() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_TabbedBar.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_TabbedBar.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_TabbedBar.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_TabbedBar.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * A Table View allows you to create a scrollable table of content in a list-based fashion. The Table View is created by the method Titanium.UI.createTableView.
 * @since 0.8
 */
function Titanium_UI_TableView() {
	/**
	 * true if the rows can be selected
	 * @alias Titanium_UI_TableView.allowsSelection
	 * @property {Boolean}
	 */
	this.allowsSelection = false
	/**
	 * Get the true if the rows can be selected
	 * @alias Titanium_UI_TableView.getAllowsSelection
	 * @return {Boolean}
	 */
	this.getAllowsSelection = function() { return this.allowsSelection; }
	/**
	 * Set the true if the rows can be selected
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TableView.setAllowsSelection
	 */
	this.setAllowsSelection = function(value) { this.allowsSelection = value; }
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_TableView.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_TableView.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TableView.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_TableView.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_TableView.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TableView.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * the background color of the table view
	 * @alias Titanium_UI_TableView.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the table view
	 * @alias Titanium_UI_TableView.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the table view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableView.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_TableView.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_TableView.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TableView.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image to render in the background of the table view
	 * @alias Titanium_UI_TableView.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image to render in the background of the table view
	 * @alias Titanium_UI_TableView.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image to render in the background of the table view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableView.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_TableView.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_TableView.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TableView.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_TableView.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_TableView.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TableView.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_TableView.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_TableView.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableView.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_TableView.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_TableView.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TableView.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_TableView.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_TableView.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TableView.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableView.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableView.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TableView.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_TableView.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_TableView.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TableView.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * the data array of objects to be used for the rows of the table view
	 * @alias Titanium_UI_TableView.data
	 * @property {Array}
	 */
	this.data = []
	/**
	 * Get the the data array of objects to be used for the rows of the table view
	 * @alias Titanium_UI_TableView.getData
	 * @return {Array}
	 */
	this.getData = function() { return this.data; }
	/**
	 * Set the the data array of objects to be used for the rows of the table view
	 * @param {Array} value New value to set.
	 * @alias Titanium_UI_TableView.setData
	 */
	this.setData = function(value) { this.data = value; }
	/**
	 * allow the table view to be editable (this must be true for swipe-to-delete)
	 * @alias Titanium_UI_TableView.editable
	 * @property {Boolean}
	 */
	this.editable = false
	/**
	 * Get the allow the table view to be editable (this must be true for swipe-to-delete)
	 * @alias Titanium_UI_TableView.getEditable
	 * @return {Boolean}
	 */
	this.getEditable = function() { return this.editable; }
	/**
	 * Set the allow the table view to be editable (this must be true for swipe-to-delete)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TableView.setEditable
	 */
	this.setEditable = function(value) { this.editable = value; }
	/**
	 * boolean to control the editing state of the table view
	 * @alias Titanium_UI_TableView.editing
	 * @property {Boolean}
	 */
	this.editing = false
	/**
	 * Get the boolean to control the editing state of the table view
	 * @alias Titanium_UI_TableView.getEditing
	 * @return {Boolean}
	 */
	this.getEditing = function() { return this.editing; }
	/**
	 * Set the boolean to control the editing state of the table view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TableView.setEditing
	 */
	this.setEditing = function(value) { this.editing = value; }
	/**
	 * the filter attribute to be used when searching. this property maps to your data object or a property on the row object
	 * @alias Titanium_UI_TableView.filterAttribute
	 * @property {String}
	 */
	this.filterAttribute = ''
	/**
	 * Get the the filter attribute to be used when searching. this property maps to your data object or a property on the row object
	 * @alias Titanium_UI_TableView.getFilterAttribute
	 * @return {String}
	 */
	this.getFilterAttribute = function() { return this.filterAttribute; }
	/**
	 * Set the the filter attribute to be used when searching. this property maps to your data object or a property on the row object
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableView.setFilterAttribute
	 */
	this.setFilterAttribute = function(value) { this.filterAttribute = value; }
	/**
	 * boolean to indicate if the search should be case sensitive or case insensitive (default)
	 * @alias Titanium_UI_TableView.filterCaseInsensitive
	 * @property {Boolean}
	 */
	this.filterCaseInsensitive = false
	/**
	 * Get the boolean to indicate if the search should be case sensitive or case insensitive (default)
	 * @alias Titanium_UI_TableView.getFilterCaseInsensitive
	 * @return {Boolean}
	 */
	this.getFilterCaseInsensitive = function() { return this.filterCaseInsensitive; }
	/**
	 * Set the boolean to indicate if the search should be case sensitive or case insensitive (default)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TableView.setFilterCaseInsensitive
	 */
	this.setFilterCaseInsensitive = function(value) { this.filterCaseInsensitive = value; }
	/**
	 * the table view footer title
	 * @alias Titanium_UI_TableView.footerTitle
	 * @property {String}
	 */
	this.footerTitle = ''
	/**
	 * Get the the table view footer title
	 * @alias Titanium_UI_TableView.getFooterTitle
	 * @return {String}
	 */
	this.getFooterTitle = function() { return this.footerTitle; }
	/**
	 * Set the the table view footer title
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableView.setFooterTitle
	 */
	this.setFooterTitle = function(value) { this.footerTitle = value; }
	/**
	 * the table view footer as a view that will be rendered instead of a label
	 * @alias Titanium_UI_TableView.footerView
	 * @property {Object}
	 */
	this.footerView = {}
	/**
	 * Get the the table view footer as a view that will be rendered instead of a label
	 * @alias Titanium_UI_TableView.getFooterView
	 * @return {Object}
	 */
	this.getFooterView = function() { return this.footerView; }
	/**
	 * Set the the table view footer as a view that will be rendered instead of a label
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TableView.setFooterView
	 */
	this.setFooterView = function(value) { this.footerView = value; }
	/**
	 * the table view header title
	 * @alias Titanium_UI_TableView.headerTitle
	 * @property {String}
	 */
	this.headerTitle = ''
	/**
	 * Get the the table view header title
	 * @alias Titanium_UI_TableView.getHeaderTitle
	 * @return {String}
	 */
	this.getHeaderTitle = function() { return this.headerTitle; }
	/**
	 * Set the the table view header title
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableView.setHeaderTitle
	 */
	this.setHeaderTitle = function(value) { this.headerTitle = value; }
	/**
	 * the table view header as a view that will be rendered instead of a label
	 * @alias Titanium_UI_TableView.headerView
	 * @property {Object}
	 */
	this.headerView = {}
	/**
	 * Get the the table view header as a view that will be rendered instead of a label
	 * @alias Titanium_UI_TableView.getHeaderView
	 * @return {Object}
	 */
	this.getHeaderView = function() { return this.headerView; }
	/**
	 * Set the the table view header as a view that will be rendered instead of a label
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TableView.setHeaderView
	 */
	this.setHeaderView = function(value) { this.headerView = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_TableView.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_TableView.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TableView.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * an array of objects (with title and index properties) to control the table view index
	 * @alias Titanium_UI_TableView.index
	 * @property {Array}
	 */
	this.index = []
	/**
	 * Get the an array of objects (with title and index properties) to control the table view index
	 * @alias Titanium_UI_TableView.getIndex
	 * @return {Array}
	 */
	this.getIndex = function() { return this.index; }
	/**
	 * Set the an array of objects (with title and index properties) to control the table view index
	 * @param {Array} value New value to set.
	 * @alias Titanium_UI_TableView.setIndex
	 */
	this.setIndex = function(value) { this.index = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableView.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableView.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TableView.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * max row height for table view rows
	 * @alias Titanium_UI_TableView.maxRowHeight
	 * @property {Float}
	 */
	this.maxRowHeight = 0.0
	/**
	 * Get the max row height for table view rows
	 * @alias Titanium_UI_TableView.getMaxRowHeight
	 * @return {Float}
	 */
	this.getMaxRowHeight = function() { return this.maxRowHeight; }
	/**
	 * Set the max row height for table view rows
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TableView.setMaxRowHeight
	 */
	this.setMaxRowHeight = function(value) { this.maxRowHeight = value; }
	/**
	 * min row height for table view rows
	 * @alias Titanium_UI_TableView.minRowHeight
	 * @property {Float}
	 */
	this.minRowHeight = 0.0
	/**
	 * Get the min row height for table view rows
	 * @alias Titanium_UI_TableView.getMinRowHeight
	 * @return {Float}
	 */
	this.getMinRowHeight = function() { return this.minRowHeight; }
	/**
	 * Set the min row height for table view rows
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TableView.setMinRowHeight
	 */
	this.setMinRowHeight = function(value) { this.minRowHeight = value; }
	/**
	 * boolean to control the moveable state of the table view
	 * @alias Titanium_UI_TableView.moving
	 * @property {Boolean}
	 */
	this.moving = false
	/**
	 * Get the boolean to control the moveable state of the table view
	 * @alias Titanium_UI_TableView.getMoving
	 * @return {Boolean}
	 */
	this.getMoving = function() { return this.moving; }
	/**
	 * Set the boolean to control the moveable state of the table view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TableView.setMoving
	 */
	this.setMoving = function(value) { this.moving = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_TableView.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_TableView.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TableView.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableView.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableView.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TableView.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * default row height for table view rows
	 * @alias Titanium_UI_TableView.rowHeight
	 * @property {Float}
	 */
	this.rowHeight = 0.0
	/**
	 * Get the default row height for table view rows
	 * @alias Titanium_UI_TableView.getRowHeight
	 * @return {Float}
	 */
	this.getRowHeight = function() { return this.rowHeight; }
	/**
	 * Set the default row height for table view rows
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TableView.setRowHeight
	 */
	this.setRowHeight = function(value) { this.rowHeight = value; }
	/**
	 * the search field to use for the table view
	 * @alias Titanium_UI_TableView.search
	 * @property {Object}
	 */
	this.search = {}
	/**
	 * Get the the search field to use for the table view
	 * @alias Titanium_UI_TableView.getSearch
	 * @return {Object}
	 */
	this.getSearch = function() { return this.search; }
	/**
	 * Set the the search field to use for the table view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TableView.setSearch
	 */
	this.setSearch = function(value) { this.search = value; }
	/**
	 * boolean to control the visibility of the search field
	 * @alias Titanium_UI_TableView.searchHidden
	 * @property {Boolean}
	 */
	this.searchHidden = false
	/**
	 * Get the boolean to control the visibility of the search field
	 * @alias Titanium_UI_TableView.getSearchHidden
	 * @return {Boolean}
	 */
	this.getSearchHidden = function() { return this.searchHidden; }
	/**
	 * Set the boolean to control the visibility of the search field
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TableView.setSearchHidden
	 */
	this.setSearchHidden = function(value) { this.searchHidden = value; }
	/**
	 * the separator color color as a hex or named value
	 * @alias Titanium_UI_TableView.separatorColor
	 * @property {String}
	 */
	this.separatorColor = ''
	/**
	 * Get the the separator color color as a hex or named value
	 * @alias Titanium_UI_TableView.getSeparatorColor
	 * @return {String}
	 */
	this.getSeparatorColor = function() { return this.separatorColor; }
	/**
	 * Set the the separator color color as a hex or named value
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableView.setSeparatorColor
	 */
	this.setSeparatorColor = function(value) { this.separatorColor = value; }
	/**
	 * the separator style constant. For iPhone, Titanium.UI.iPhone.TableViewSeparatorStyle
	 * @alias Titanium_UI_TableView.separatorStyle
	 * @property {Integer}
	 */
	this.separatorStyle = 0
	/**
	 * Get the the separator style constant. For iPhone, Titanium.UI.iPhone.TableViewSeparatorStyle
	 * @alias Titanium_UI_TableView.getSeparatorStyle
	 * @return {Integer}
	 */
	this.getSeparatorStyle = function() { return this.separatorStyle; }
	/**
	 * Set the the separator style constant. For iPhone, Titanium.UI.iPhone.TableViewSeparatorStyle
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_TableView.setSeparatorStyle
	 */
	this.setSeparatorStyle = function(value) { this.separatorStyle = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_TableView.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_TableView.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TableView.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * iPhone only. the style of the table view. constant from Titanium.UI.iPhone.TableViewStyle
	 * @alias Titanium_UI_TableView.style
	 * @property {Integer}
	 */
	this.style = 0
	/**
	 * Get the iPhone only. the style of the table view. constant from Titanium.UI.iPhone.TableViewStyle
	 * @alias Titanium_UI_TableView.getStyle
	 * @return {Integer}
	 */
	this.getStyle = function() { return this.style; }
	/**
	 * Set the iPhone only. the style of the table view. constant from Titanium.UI.iPhone.TableViewStyle
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_TableView.setStyle
	 */
	this.setStyle = function(value) { this.style = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableView.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableView.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TableView.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_TableView.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_TableView.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TableView.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_TableView.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_TableView.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TableView.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_TableView.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_TableView.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TableView.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_TableView.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_TableView.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TableView.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_TableView.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_TableView.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_TableView.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_TableView.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_TableView.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_TableView.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * append a row to the table, optionally with animation
	 * @param {Object} row row to append
	 * @param {Object} properties animation properties
	 * @alias Titanium_UI_TableView.appendRow
	 */
	this.appendRow = function appendRow(row,properties) { }
	/**
	 * delete an existing row, optionally with animation
	 * @param {Object} row row to delete
	 * @param {Object} properties animation properties
	 * @alias Titanium_UI_TableView.deleteRow
	 */
	this.deleteRow = function deleteRow(row,properties) { }
	/**
	 * programmatically deselect a row
	 * @param {Integer} row row index to deselect
	 * @alias Titanium_UI_TableView.deselectRow
	 */
	this.deselectRow = function deselectRow(row) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_TableView.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_UI_TableView.hide
	 */
	this.hide = function hide() { }
	/**
	 * insert a row before another row, optionally with animation
	 * @param {Integer} index index
	 * @param {Object} row row to insert
	 * @param {Object} properties animation properties
	 * @alias Titanium_UI_TableView.insertRowAfter
	 */
	this.insertRowAfter = function insertRowAfter(index,row,properties) { }
	/**
	 * insert a row after another row, optionally with animation
	 * @param {Integer} index index
	 * @param {Object} row row to insert
	 * @param {Object} properties animation properties
	 * @alias Titanium_UI_TableView.insertRowBefore
	 */
	this.insertRowBefore = function insertRowBefore(index,row,properties) { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_TableView.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_TableView.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * scroll to a specific row index and ensure that that row is on screen
	 * @param {Integer} index index
	 * @param {Object} properties animation properties. <tt>position</tt> property controls the position constant to use for position (on iPhone, use constants from Titanium.UI.iPhone.TableViewScrollPosition).
	 * @alias Titanium_UI_TableView.scrollToIndex
	 */
	this.scrollToIndex = function scrollToIndex(index,properties) { }
	/**
	 * scroll the table to a specific top position where 0 is the topmost y position in the table view
	 * @param {Float} top y position
	 * @param {Object} [properties] optional dictionary with the key <tt>animated</tt> (default, true) as boolean to indicate if the scroll should be animated or immediate
	 * @alias Titanium_UI_TableView.scrollToTop
	 */
	this.scrollToTop = function scrollToTop(top,properties) { }
	/**
	 * programmatically select a row
	 * @param {Integer} row row index to select
	 * @alias Titanium_UI_TableView.selectRow
	 */
	this.selectRow = function selectRow(row) { }
	/**
	 * set the data in the table, optionally with animation
	 * @param {Array} data data array of rows either as objects or row objects
	 * @param {Object} properties animation properties
	 * @alias Titanium_UI_TableView.setData
	 */
	this.setData = function setData(data,properties) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_TableView.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_TableView.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
	/**
	 * update an existing row, optionally with animation
	 * @param {Object} row row data to update
	 * @param {Object} properties animation properties
	 * @alias Titanium_UI_TableView.updateRow
	 */
	this.updateRow = function updateRow(row,properties) { }
};

/**
 * A TableView row object created by the method Titanium.UI.createTableViewRow.
 * @since 0.9
 */
function Titanium_UI_TableViewRow() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_TableViewRow.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_TableViewRow.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_TableViewRow.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_TableViewRow.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * the background cell color
	 * @alias Titanium_UI_TableViewRow.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background cell color
	 * @alias Titanium_UI_TableViewRow.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background cell color
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_TableViewRow.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_TableViewRow.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background cell image
	 * @alias Titanium_UI_TableViewRow.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background cell image
	 * @alias Titanium_UI_TableViewRow.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background cell image
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_TableViewRow.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_TableViewRow.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_TableViewRow.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_TableViewRow.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_TableViewRow.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_TableViewRow.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_TableViewRow.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_TableViewRow.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_TableViewRow.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_TableViewRow.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableViewRow.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableViewRow.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_TableViewRow.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_TableViewRow.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * the class name of the table. each table view cell must have a unique class name if the cell layout is different. however, use the same name for rows that have the same structural layout (even if the content is different) to provide maximum rendering performance.
	 * @alias Titanium_UI_TableViewRow.className
	 * @property {String}
	 */
	this.className = ''
	/**
	 * Get the the class name of the table. each table view cell must have a unique class name if the cell layout is different. however, use the same name for rows that have the same structural layout (even if the content is different) to provide maximum rendering performance.
	 * @alias Titanium_UI_TableViewRow.getClassName
	 * @return {String}
	 */
	this.getClassName = function() { return this.className; }
	/**
	 * Set the the class name of the table. each table view cell must have a unique class name if the cell layout is different. however, use the same name for rows that have the same structural layout (even if the content is different) to provide maximum rendering performance.
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setClassName
	 */
	this.setClassName = function(value) { this.className = value; }
	/**
	 * default color of the row when not selected
	 * @alias Titanium_UI_TableViewRow.color
	 * @property {String}
	 */
	this.color = ''
	/**
	 * Get the default color of the row when not selected
	 * @alias Titanium_UI_TableViewRow.getColor
	 * @return {String}
	 */
	this.getColor = function() { return this.color; }
	/**
	 * Set the default color of the row when not selected
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setColor
	 */
	this.setColor = function(value) { this.color = value; }
	/**
	 * render a system provided check mark in the right image area of the row cell
	 * @alias Titanium_UI_TableViewRow.hasCheck
	 * @property {Boolean}
	 */
	this.hasCheck = false
	/**
	 * Get the render a system provided check mark in the right image area of the row cell
	 * @alias Titanium_UI_TableViewRow.getHasCheck
	 * @return {Boolean}
	 */
	this.getHasCheck = function() { return this.hasCheck; }
	/**
	 * Set the render a system provided check mark in the right image area of the row cell
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setHasCheck
	 */
	this.setHasCheck = function(value) { this.hasCheck = value; }
	/**
	 * render a system provided right arrow in the right image area of the row cell
	 * @alias Titanium_UI_TableViewRow.hasChild
	 * @property {Boolean}
	 */
	this.hasChild = false
	/**
	 * Get the render a system provided right arrow in the right image area of the row cell
	 * @alias Titanium_UI_TableViewRow.getHasChild
	 * @return {Boolean}
	 */
	this.getHasChild = function() { return this.hasChild; }
	/**
	 * Set the render a system provided right arrow in the right image area of the row cell
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setHasChild
	 */
	this.setHasChild = function(value) { this.hasChild = value; }
	/**
	 * render a system provided blue indicator icon in the right image area of the row cell
	 * @alias Titanium_UI_TableViewRow.hasDetail
	 * @property {Boolean}
	 */
	this.hasDetail = false
	/**
	 * Get the render a system provided blue indicator icon in the right image area of the row cell
	 * @alias Titanium_UI_TableViewRow.getHasDetail
	 * @return {Boolean}
	 */
	this.getHasDetail = function() { return this.hasDetail; }
	/**
	 * Set the render a system provided blue indicator icon in the right image area of the row cell
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setHasDetail
	 */
	this.setHasDetail = function(value) { this.hasDetail = value; }
	/**
	 * the height of the row. specify auto to calculate the row height based on the size of the child views of the row
	 * @alias Titanium_UI_TableViewRow.height
	 * @property {Float}
	 */
	this.height = 0.0
	/**
	 * Get the the height of the row. specify auto to calculate the row height based on the size of the child views of the row
	 * @alias Titanium_UI_TableViewRow.getHeight
	 * @return {Float}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the the height of the row. specify auto to calculate the row height based on the size of the child views of the row
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * the indention level for the cell (defaults to 0)
	 * @alias Titanium_UI_TableViewRow.indentionLevel
	 * @property {Integer}
	 */
	this.indentionLevel = 0
	/**
	 * Get the the indention level for the cell (defaults to 0)
	 * @alias Titanium_UI_TableViewRow.getIndentionLevel
	 * @return {Integer}
	 */
	this.getIndentionLevel = function() { return this.indentionLevel; }
	/**
	 * Set the the indention level for the cell (defaults to 0)
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setIndentionLevel
	 */
	this.setIndentionLevel = function(value) { this.indentionLevel = value; }
	/**
	 * the layout algorithm to use for the layout. either absolute (default) or vertical.
	 * @alias Titanium_UI_TableViewRow.layout
	 * @property {String}
	 */
	this.layout = ''
	/**
	 * Get the the layout algorithm to use for the layout. either absolute (default) or vertical.
	 * @alias Titanium_UI_TableViewRow.getLayout
	 * @return {String}
	 */
	this.getLayout = function() { return this.layout; }
	/**
	 * Set the the layout algorithm to use for the layout. either absolute (default) or vertical.
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setLayout
	 */
	this.setLayout = function(value) { this.layout = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableViewRow.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableViewRow.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * image url to render in the left image area of the row cell
	 * @alias Titanium_UI_TableViewRow.leftImage
	 * @property {String}
	 */
	this.leftImage = ''
	/**
	 * Get the image url to render in the left image area of the row cell
	 * @alias Titanium_UI_TableViewRow.getLeftImage
	 * @return {String}
	 */
	this.getLeftImage = function() { return this.leftImage; }
	/**
	 * Set the image url to render in the left image area of the row cell
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setLeftImage
	 */
	this.setLeftImage = function(value) { this.leftImage = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_TableViewRow.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_TableViewRow.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableViewRow.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableViewRow.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * image url to render in the right image area of the row cell
	 * @alias Titanium_UI_TableViewRow.rightImage
	 * @property {String}
	 */
	this.rightImage = ''
	/**
	 * Get the image url to render in the right image area of the row cell
	 * @alias Titanium_UI_TableViewRow.getRightImage
	 * @return {String}
	 */
	this.getRightImage = function() { return this.rightImage; }
	/**
	 * Set the image url to render in the right image area of the row cell
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setRightImage
	 */
	this.setRightImage = function(value) { this.rightImage = value; }
	/**
	 * the background color to render when the row cell is selected
	 * @alias Titanium_UI_TableViewRow.selectedBackgroundColor
	 * @property {String}
	 */
	this.selectedBackgroundColor = ''
	/**
	 * Get the the background color to render when the row cell is selected
	 * @alias Titanium_UI_TableViewRow.getSelectedBackgroundColor
	 * @return {String}
	 */
	this.getSelectedBackgroundColor = function() { return this.selectedBackgroundColor; }
	/**
	 * Set the the background color to render when the row cell is selected
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setSelectedBackgroundColor
	 */
	this.setSelectedBackgroundColor = function(value) { this.selectedBackgroundColor = value; }
	/**
	 * the background image to render when the row cell is selected
	 * @alias Titanium_UI_TableViewRow.selectedBackgroundImage
	 * @property {String}
	 */
	this.selectedBackgroundImage = ''
	/**
	 * Get the the background image to render when the row cell is selected
	 * @alias Titanium_UI_TableViewRow.getSelectedBackgroundImage
	 * @return {String}
	 */
	this.getSelectedBackgroundImage = function() { return this.selectedBackgroundImage; }
	/**
	 * Set the the background image to render when the row cell is selected
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setSelectedBackgroundImage
	 */
	this.setSelectedBackgroundImage = function(value) { this.selectedBackgroundImage = value; }
	/**
	 * color of the row during selection
	 * @alias Titanium_UI_TableViewRow.selectedColor
	 * @property {String}
	 */
	this.selectedColor = ''
	/**
	 * Get the color of the row during selection
	 * @alias Titanium_UI_TableViewRow.getSelectedColor
	 * @return {String}
	 */
	this.getSelectedColor = function() { return this.selectedColor; }
	/**
	 * Set the color of the row during selection
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setSelectedColor
	 */
	this.setSelectedColor = function(value) { this.selectedColor = value; }
	/**
	 * a selection style constant to control the selection color. For iPhone, use the constants from Titanium.UI.iPhone.TableViewCellSelectionStyle
	 * @alias Titanium_UI_TableViewRow.selectionStyle
	 * @property {Integer}
	 */
	this.selectionStyle = 0
	/**
	 * Get the a selection style constant to control the selection color. For iPhone, use the constants from Titanium.UI.iPhone.TableViewCellSelectionStyle
	 * @alias Titanium_UI_TableViewRow.getSelectionStyle
	 * @return {Integer}
	 */
	this.getSelectionStyle = function() { return this.selectionStyle; }
	/**
	 * Set the a selection style constant to control the selection color. For iPhone, use the constants from Titanium.UI.iPhone.TableViewCellSelectionStyle
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setSelectionStyle
	 */
	this.setSelectionStyle = function(value) { this.selectionStyle = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_TableViewRow.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_TableViewRow.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * the title cell value. do not specify if using views as children of the row
	 * @alias Titanium_UI_TableViewRow.title
	 * @property {String}
	 */
	this.title = ''
	/**
	 * Get the the title cell value. do not specify if using views as children of the row
	 * @alias Titanium_UI_TableViewRow.getTitle
	 * @return {String}
	 */
	this.getTitle = function() { return this.title; }
	/**
	 * Set the the title cell value. do not specify if using views as children of the row
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setTitle
	 */
	this.setTitle = function(value) { this.title = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableViewRow.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableViewRow.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_TableViewRow.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_TableViewRow.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_TableViewRow.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_TableViewRow.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_TableViewRow.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_TableViewRow.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_TableViewRow.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_TableViewRow.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_TableViewRow.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_TableViewRow.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_TableViewRow.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_TableViewRow.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_TableViewRow.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_TableViewRow.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_TableViewRow.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_UI_TableViewRow.hide
	 */
	this.hide = function hide() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_TableViewRow.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_TableViewRow.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_TableViewRow.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_TableViewRow.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * A TableView section object created by the method Titanium.UI.createTableViewSection.
 * @since 0.9
 */
function Titanium_UI_TableViewSection() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_TableViewSection.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_TableViewSection.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_TableViewSection.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_TableViewSection.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * the background color of the view
	 * @alias Titanium_UI_TableViewSection.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the view
	 * @alias Titanium_UI_TableViewSection.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_TableViewSection.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_TableViewSection.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_UI_TableViewSection.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_UI_TableViewSection.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_TableViewSection.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_TableViewSection.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_TableViewSection.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_TableViewSection.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_TableViewSection.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_TableViewSection.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_TableViewSection.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_TableViewSection.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_TableViewSection.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_TableViewSection.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableViewSection.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableViewSection.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_TableViewSection.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_TableViewSection.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * the title of the section footer
	 * @alias Titanium_UI_TableViewSection.footerTitle
	 * @property {String}
	 */
	this.footerTitle = ''
	/**
	 * Get the the title of the section footer
	 * @alias Titanium_UI_TableViewSection.getFooterTitle
	 * @return {String}
	 */
	this.getFooterTitle = function() { return this.footerTitle; }
	/**
	 * Set the the title of the section footer
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setFooterTitle
	 */
	this.setFooterTitle = function(value) { this.footerTitle = value; }
	/**
	 * a view to use instead of the default label when rendering the section footer
	 * @alias Titanium_UI_TableViewSection.footerView
	 * @property {Object}
	 */
	this.footerView = {}
	/**
	 * Get the a view to use instead of the default label when rendering the section footer
	 * @alias Titanium_UI_TableViewSection.getFooterView
	 * @return {Object}
	 */
	this.getFooterView = function() { return this.footerView; }
	/**
	 * Set the a view to use instead of the default label when rendering the section footer
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setFooterView
	 */
	this.setFooterView = function(value) { this.footerView = value; }
	/**
	 * the title of the section header
	 * @alias Titanium_UI_TableViewSection.headerTitle
	 * @property {String}
	 */
	this.headerTitle = ''
	/**
	 * Get the the title of the section header
	 * @alias Titanium_UI_TableViewSection.getHeaderTitle
	 * @return {String}
	 */
	this.getHeaderTitle = function() { return this.headerTitle; }
	/**
	 * Set the the title of the section header
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setHeaderTitle
	 */
	this.setHeaderTitle = function(value) { this.headerTitle = value; }
	/**
	 * a view to use instead of the default label when rendering the section header
	 * @alias Titanium_UI_TableViewSection.headerView
	 * @property {Object}
	 */
	this.headerView = {}
	/**
	 * Get the a view to use instead of the default label when rendering the section header
	 * @alias Titanium_UI_TableViewSection.getHeaderView
	 * @return {Object}
	 */
	this.getHeaderView = function() { return this.headerView; }
	/**
	 * Set the a view to use instead of the default label when rendering the section header
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setHeaderView
	 */
	this.setHeaderView = function(value) { this.headerView = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_TableViewSection.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_TableViewSection.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableViewSection.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableViewSection.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_TableViewSection.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_TableViewSection.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableViewSection.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableViewSection.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * the (readonly) number of rows in the section
	 * @alias Titanium_UI_TableViewSection.rowCount
	 * @property {Integer}
	 */
	this.rowCount = 0
	/**
	 * Get the the (readonly) number of rows in the section
	 * @alias Titanium_UI_TableViewSection.getRowCount
	 * @return {Integer}
	 */
	this.getRowCount = function() { return this.rowCount; }
	/**
	 * Set the the (readonly) number of rows in the section
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setRowCount
	 */
	this.setRowCount = function(value) { this.rowCount = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_TableViewSection.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_TableViewSection.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableViewSection.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TableViewSection.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_TableViewSection.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_TableViewSection.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_TableViewSection.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_TableViewSection.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_TableViewSection.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_TableViewSection.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_TableViewSection.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_TableViewSection.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_TableViewSection.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_TableViewSection.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_TableViewSection.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a row to the section
	 * @param {Object} view the view to add to this views hiearchy
	 * @param {Object} row the row object to add to the section
	 * @alias Titanium_UI_TableViewSection.add
	 */
	this.add = function add(view,row) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_TableViewSection.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_TableViewSection.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_TableViewSection.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_UI_TableViewSection.hide
	 */
	this.hide = function hide() { }
	/**
	 * remove a remove from the section
	 * @param {Object} view the view to remove from this views hiearchy
	 * @param {Object} row the row object to remove from the section
	 * @alias Titanium_UI_TableViewSection.remove
	 */
	this.remove = function remove(view,row) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_TableViewSection.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * retrieve the row object at a specific index
	 * @alias Titanium_UI_TableViewSection.rowAtIndex
	 */
	this.rowAtIndex = function rowAtIndex() { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_TableViewSection.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_TableViewSection.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * A Text Area is created by the method Titanium.UI.createTextArea. The Text Area is a multiline field.
 * @since 0.8
 */
function Titanium_UI_TextArea() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_TextArea.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_TextArea.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TextArea.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_TextArea.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_TextArea.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TextArea.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * value of the background color of the field
	 * @alias Titanium_UI_TextArea.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the value of the background color of the field
	 * @alias Titanium_UI_TextArea.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the value of the background color of the field
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TextArea.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_TextArea.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_TextArea.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TextArea.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_UI_TextArea.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_UI_TextArea.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TextArea.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_TextArea.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_TextArea.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TextArea.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_TextArea.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_TextArea.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TextArea.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_TextArea.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_TextArea.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TextArea.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_TextArea.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_TextArea.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TextArea.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_TextArea.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_TextArea.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TextArea.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TextArea.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TextArea.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TextArea.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_TextArea.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_TextArea.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TextArea.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * boolean indicating if the field is editable
	 * @alias Titanium_UI_TextArea.editable
	 * @property {Boolean}
	 */
	this.editable = false
	/**
	 * Get the boolean indicating if the field is editable
	 * @alias Titanium_UI_TextArea.getEditable
	 * @return {Boolean}
	 */
	this.getEditable = function() { return this.editable; }
	/**
	 * Set the boolean indicating if the field is editable
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TextArea.setEditable
	 */
	this.setEditable = function(value) { this.editable = value; }
	/**
	 * boolean indicating the enabled state of the field
	 * @alias Titanium_UI_TextArea.enabled
	 * @property {Boolean}
	 */
	this.enabled = false
	/**
	 * Get the boolean indicating the enabled state of the field
	 * @alias Titanium_UI_TextArea.getEnabled
	 * @return {Boolean}
	 */
	this.getEnabled = function() { return this.enabled; }
	/**
	 * Set the boolean indicating the enabled state of the field
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TextArea.setEnabled
	 */
	this.setEnabled = function(value) { this.enabled = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_TextArea.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_TextArea.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TextArea.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * array of toolbar button objects to be used when the keyboard is displayed
	 * @alias Titanium_UI_TextArea.keyboardToolbar
	 * @property {Array}
	 */
	this.keyboardToolbar = []
	/**
	 * Get the array of toolbar button objects to be used when the keyboard is displayed
	 * @alias Titanium_UI_TextArea.getKeyboardToolbar
	 * @return {Array}
	 */
	this.getKeyboardToolbar = function() { return this.keyboardToolbar; }
	/**
	 * Set the array of toolbar button objects to be used when the keyboard is displayed
	 * @param {Array} value New value to set.
	 * @alias Titanium_UI_TextArea.setKeyboardToolbar
	 */
	this.setKeyboardToolbar = function(value) { this.keyboardToolbar = value; }
	/**
	 * the color of the keyboard toolbar
	 * @alias Titanium_UI_TextArea.keyboardToolbarColor
	 * @property {String}
	 */
	this.keyboardToolbarColor = ''
	/**
	 * Get the the color of the keyboard toolbar
	 * @alias Titanium_UI_TextArea.getKeyboardToolbarColor
	 * @return {String}
	 */
	this.getKeyboardToolbarColor = function() { return this.keyboardToolbarColor; }
	/**
	 * Set the the color of the keyboard toolbar
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TextArea.setKeyboardToolbarColor
	 */
	this.setKeyboardToolbarColor = function(value) { this.keyboardToolbarColor = value; }
	/**
	 * the height of the keyboard toolbar
	 * @alias Titanium_UI_TextArea.keyboardToolbarHeight
	 * @property {Float}
	 */
	this.keyboardToolbarHeight = 0.0
	/**
	 * Get the the height of the keyboard toolbar
	 * @alias Titanium_UI_TextArea.getKeyboardToolbarHeight
	 * @return {Float}
	 */
	this.getKeyboardToolbarHeight = function() { return this.keyboardToolbarHeight; }
	/**
	 * Set the the height of the keyboard toolbar
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TextArea.setKeyboardToolbarHeight
	 */
	this.setKeyboardToolbarHeight = function(value) { this.keyboardToolbarHeight = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TextArea.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TextArea.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TextArea.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_TextArea.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_TextArea.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TextArea.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TextArea.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TextArea.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TextArea.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_TextArea.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_TextArea.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TextArea.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * boolean to indicate if the return key should be suppressed during entry
	 * @alias Titanium_UI_TextArea.suppressReturn
	 * @property {Boolean}
	 */
	this.suppressReturn = false
	/**
	 * Get the boolean to indicate if the return key should be suppressed during entry
	 * @alias Titanium_UI_TextArea.getSuppressReturn
	 * @return {Boolean}
	 */
	this.getSuppressReturn = function() { return this.suppressReturn; }
	/**
	 * Set the boolean to indicate if the return key should be suppressed during entry
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TextArea.setSuppressReturn
	 */
	this.setSuppressReturn = function(value) { this.suppressReturn = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TextArea.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TextArea.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TextArea.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_TextArea.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_TextArea.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TextArea.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_TextArea.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_TextArea.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TextArea.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * value of the field
	 * @alias Titanium_UI_TextArea.value
	 * @property {String}
	 */
	this.value = ''
	/**
	 * Get the value of the field
	 * @alias Titanium_UI_TextArea.getValue
	 * @return {String}
	 */
	this.getValue = function() { return this.value; }
	/**
	 * Set the value of the field
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TextArea.setValue
	 */
	this.setValue = function(value) { this.value = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_TextArea.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_TextArea.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TextArea.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_TextArea.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_TextArea.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TextArea.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_TextArea.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_TextArea.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_TextArea.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_TextArea.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_TextArea.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_TextArea.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * force the field to lose focus
	 * @alias Titanium_UI_TextArea.blur
	 */
	this.blur = function blur() { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_TextArea.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * force the field to gain focus
	 * @alias Titanium_UI_TextArea.focus
	 */
	this.focus = function focus() { }
	/**
	 * return boolean (true) if the field has text
	 * @alias Titanium_UI_TextArea.hasText
	 */
	this.hasText = function hasText() { }
	/**
	 * hide the view
	 * @alias Titanium_UI_TextArea.hide
	 */
	this.hide = function hide() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_TextArea.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_TextArea.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_TextArea.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_TextArea.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * A Text Area is created by the method Titanium.UI.createTextField. The Text Field is a single line field.
 * @since 0.8
 */
function Titanium_UI_TextField() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_TextField.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_TextField.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TextField.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_TextField.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_TextField.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TextField.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * value of the background color of the field
	 * @alias Titanium_UI_TextField.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the value of the background color of the field
	 * @alias Titanium_UI_TextField.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the value of the background color of the field
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TextField.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * the image url to the background image of the field when in the disabled state
	 * @alias Titanium_UI_TextField.backgroundDisabledImage
	 * @property {String}
	 */
	this.backgroundDisabledImage = ''
	/**
	 * Get the the image url to the background image of the field when in the disabled state
	 * @alias Titanium_UI_TextField.getBackgroundDisabledImage
	 * @return {String}
	 */
	this.getBackgroundDisabledImage = function() { return this.backgroundDisabledImage; }
	/**
	 * Set the the image url to the background image of the field when in the disabled state
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TextField.setBackgroundDisabledImage
	 */
	this.setBackgroundDisabledImage = function(value) { this.backgroundDisabledImage = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_TextField.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_TextField.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TextField.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the image url to the background image of the field
	 * @alias Titanium_UI_TextField.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the image url to the background image of the field
	 * @alias Titanium_UI_TextField.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the image url to the background image of the field
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TextField.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_TextField.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_TextField.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TextField.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_TextField.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_TextField.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TextField.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_TextField.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_TextField.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TextField.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_TextField.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_TextField.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TextField.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border style constant for the field
	 * @alias Titanium_UI_TextField.borderStyle
	 * @property {Integer}
	 */
	this.borderStyle = 0
	/**
	 * Get the the border style constant for the field
	 * @alias Titanium_UI_TextField.getBorderStyle
	 * @return {Integer}
	 */
	this.getBorderStyle = function() { return this.borderStyle; }
	/**
	 * Set the the border style constant for the field
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_TextField.setBorderStyle
	 */
	this.setBorderStyle = function(value) { this.borderStyle = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_TextField.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_TextField.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TextField.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TextField.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TextField.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TextField.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_TextField.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_TextField.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TextField.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * the mode constant for how to handle displaying the clear button
	 * @alias Titanium_UI_TextField.clearButtonMode
	 * @property {Integer}
	 */
	this.clearButtonMode = 0
	/**
	 * Get the the mode constant for how to handle displaying the clear button
	 * @alias Titanium_UI_TextField.getClearButtonMode
	 * @return {Integer}
	 */
	this.getClearButtonMode = function() { return this.clearButtonMode; }
	/**
	 * Set the the mode constant for how to handle displaying the clear button
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_TextField.setClearButtonMode
	 */
	this.setClearButtonMode = function(value) { this.clearButtonMode = value; }
	/**
	 * boolean that indicates if the value of the field is cleared upon editing
	 * @alias Titanium_UI_TextField.clearOnEdit
	 * @property {Boolean}
	 */
	this.clearOnEdit = false
	/**
	 * Get the boolean that indicates if the value of the field is cleared upon editing
	 * @alias Titanium_UI_TextField.getClearOnEdit
	 * @return {Boolean}
	 */
	this.getClearOnEdit = function() { return this.clearOnEdit; }
	/**
	 * Set the boolean that indicates if the value of the field is cleared upon editing
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TextField.setClearOnEdit
	 */
	this.setClearOnEdit = function(value) { this.clearOnEdit = value; }
	/**
	 * boolean indicating if the field is editable
	 * @alias Titanium_UI_TextField.editable
	 * @property {Boolean}
	 */
	this.editable = false
	/**
	 * Get the boolean indicating if the field is editable
	 * @alias Titanium_UI_TextField.getEditable
	 * @return {Boolean}
	 */
	this.getEditable = function() { return this.editable; }
	/**
	 * Set the boolean indicating if the field is editable
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TextField.setEditable
	 */
	this.setEditable = function(value) { this.editable = value; }
	/**
	 * boolean indicating the enabled state of the field
	 * @alias Titanium_UI_TextField.enabled
	 * @property {Boolean}
	 */
	this.enabled = false
	/**
	 * Get the boolean indicating the enabled state of the field
	 * @alias Titanium_UI_TextField.getEnabled
	 * @return {Boolean}
	 */
	this.getEnabled = function() { return this.enabled; }
	/**
	 * Set the boolean indicating the enabled state of the field
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TextField.setEnabled
	 */
	this.setEnabled = function(value) { this.enabled = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_TextField.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_TextField.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TextField.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * the hint text to display when the field is unfocused
	 * @alias Titanium_UI_TextField.hintText
	 * @property {String}
	 */
	this.hintText = ''
	/**
	 * Get the the hint text to display when the field is unfocused
	 * @alias Titanium_UI_TextField.getHintText
	 * @return {String}
	 */
	this.getHintText = function() { return this.hintText; }
	/**
	 * Set the the hint text to display when the field is unfocused
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TextField.setHintText
	 */
	this.setHintText = function(value) { this.hintText = value; }
	/**
	 * array of toolbar button objects to be used when the keyboard is displayed
	 * @alias Titanium_UI_TextField.keyboardToolbar
	 * @property {Array}
	 */
	this.keyboardToolbar = []
	/**
	 * Get the array of toolbar button objects to be used when the keyboard is displayed
	 * @alias Titanium_UI_TextField.getKeyboardToolbar
	 * @return {Array}
	 */
	this.getKeyboardToolbar = function() { return this.keyboardToolbar; }
	/**
	 * Set the array of toolbar button objects to be used when the keyboard is displayed
	 * @param {Array} value New value to set.
	 * @alias Titanium_UI_TextField.setKeyboardToolbar
	 */
	this.setKeyboardToolbar = function(value) { this.keyboardToolbar = value; }
	/**
	 * the color of the keyboard toolbar
	 * @alias Titanium_UI_TextField.keyboardToolbarColor
	 * @property {String}
	 */
	this.keyboardToolbarColor = ''
	/**
	 * Get the the color of the keyboard toolbar
	 * @alias Titanium_UI_TextField.getKeyboardToolbarColor
	 * @return {String}
	 */
	this.getKeyboardToolbarColor = function() { return this.keyboardToolbarColor; }
	/**
	 * Set the the color of the keyboard toolbar
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TextField.setKeyboardToolbarColor
	 */
	this.setKeyboardToolbarColor = function(value) { this.keyboardToolbarColor = value; }
	/**
	 * the height of the keyboard toolbar
	 * @alias Titanium_UI_TextField.keyboardToolbarHeight
	 * @property {Float}
	 */
	this.keyboardToolbarHeight = 0.0
	/**
	 * Get the the height of the keyboard toolbar
	 * @alias Titanium_UI_TextField.getKeyboardToolbarHeight
	 * @return {Float}
	 */
	this.getKeyboardToolbarHeight = function() { return this.keyboardToolbarHeight; }
	/**
	 * Set the the height of the keyboard toolbar
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TextField.setKeyboardToolbarHeight
	 */
	this.setKeyboardToolbarHeight = function(value) { this.keyboardToolbarHeight = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TextField.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TextField.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TextField.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the left button view
	 * @alias Titanium_UI_TextField.leftButton
	 * @property {Object}
	 */
	this.leftButton = {}
	/**
	 * Get the the left button view
	 * @alias Titanium_UI_TextField.getLeftButton
	 * @return {Object}
	 */
	this.getLeftButton = function() { return this.leftButton; }
	/**
	 * Set the the left button view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TextField.setLeftButton
	 */
	this.setLeftButton = function(value) { this.leftButton = value; }
	/**
	 * the mode of the left button view
	 * @alias Titanium_UI_TextField.leftButtonMode
	 * @property {Integer}
	 */
	this.leftButtonMode = 0
	/**
	 * Get the the mode of the left button view
	 * @alias Titanium_UI_TextField.getLeftButtonMode
	 * @return {Integer}
	 */
	this.getLeftButtonMode = function() { return this.leftButtonMode; }
	/**
	 * Set the the mode of the left button view
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_TextField.setLeftButtonMode
	 */
	this.setLeftButtonMode = function(value) { this.leftButtonMode = value; }
	/**
	 * the left padding of the space between the button and the edge of the field
	 * @alias Titanium_UI_TextField.leftButtonPadding
	 * @property {Float}
	 */
	this.leftButtonPadding = 0.0
	/**
	 * Get the the left padding of the space between the button and the edge of the field
	 * @alias Titanium_UI_TextField.getLeftButtonPadding
	 * @return {Float}
	 */
	this.getLeftButtonPadding = function() { return this.leftButtonPadding; }
	/**
	 * Set the the left padding of the space between the button and the edge of the field
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TextField.setLeftButtonPadding
	 */
	this.setLeftButtonPadding = function(value) { this.leftButtonPadding = value; }
	/**
	 * the minimum size of the font when the font is sized based on the contents
	 * @alias Titanium_UI_TextField.minimumFontSize
	 * @property {Integer}
	 */
	this.minimumFontSize = 0
	/**
	 * Get the the minimum size of the font when the font is sized based on the contents
	 * @alias Titanium_UI_TextField.getMinimumFontSize
	 * @return {Integer}
	 */
	this.getMinimumFontSize = function() { return this.minimumFontSize; }
	/**
	 * Set the the minimum size of the font when the font is sized based on the contents
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_TextField.setMinimumFontSize
	 */
	this.setMinimumFontSize = function(value) { this.minimumFontSize = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_TextField.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_TextField.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TextField.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * the left padding of the text field
	 * @alias Titanium_UI_TextField.paddingLeft
	 * @property {Float}
	 */
	this.paddingLeft = 0.0
	/**
	 * Get the the left padding of the text field
	 * @alias Titanium_UI_TextField.getPaddingLeft
	 * @return {Float}
	 */
	this.getPaddingLeft = function() { return this.paddingLeft; }
	/**
	 * Set the the left padding of the text field
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TextField.setPaddingLeft
	 */
	this.setPaddingLeft = function(value) { this.paddingLeft = value; }
	/**
	 * the right padding of the text field
	 * @alias Titanium_UI_TextField.paddingRight
	 * @property {Float}
	 */
	this.paddingRight = 0.0
	/**
	 * Get the the right padding of the text field
	 * @alias Titanium_UI_TextField.getPaddingRight
	 * @return {Float}
	 */
	this.getPaddingRight = function() { return this.paddingRight; }
	/**
	 * Set the the right padding of the text field
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TextField.setPaddingRight
	 */
	this.setPaddingRight = function(value) { this.paddingRight = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TextField.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TextField.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TextField.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * the right button view
	 * @alias Titanium_UI_TextField.rightButton
	 * @property {Object}
	 */
	this.rightButton = {}
	/**
	 * Get the the right button view
	 * @alias Titanium_UI_TextField.getRightButton
	 * @return {Object}
	 */
	this.getRightButton = function() { return this.rightButton; }
	/**
	 * Set the the right button view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TextField.setRightButton
	 */
	this.setRightButton = function(value) { this.rightButton = value; }
	/**
	 * the mode of the right button view
	 * @alias Titanium_UI_TextField.rightButtonMode
	 * @property {Integer}
	 */
	this.rightButtonMode = 0
	/**
	 * Get the the mode of the right button view
	 * @alias Titanium_UI_TextField.getRightButtonMode
	 * @return {Integer}
	 */
	this.getRightButtonMode = function() { return this.rightButtonMode; }
	/**
	 * Set the the mode of the right button view
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_TextField.setRightButtonMode
	 */
	this.setRightButtonMode = function(value) { this.rightButtonMode = value; }
	/**
	 * the right padding of the space between the button and the edge of the field
	 * @alias Titanium_UI_TextField.rightButtonPadding
	 * @property {Float}
	 */
	this.rightButtonPadding = 0.0
	/**
	 * Get the the right padding of the space between the button and the edge of the field
	 * @alias Titanium_UI_TextField.getRightButtonPadding
	 * @return {Float}
	 */
	this.getRightButtonPadding = function() { return this.rightButtonPadding; }
	/**
	 * Set the the right padding of the space between the button and the edge of the field
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_TextField.setRightButtonPadding
	 */
	this.setRightButtonPadding = function(value) { this.rightButtonPadding = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_TextField.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_TextField.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TextField.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * boolean to indicate if the return key should be suppressed during entry
	 * @alias Titanium_UI_TextField.suppressReturn
	 * @property {Boolean}
	 */
	this.suppressReturn = false
	/**
	 * Get the boolean to indicate if the return key should be suppressed during entry
	 * @alias Titanium_UI_TextField.getSuppressReturn
	 * @return {Boolean}
	 */
	this.getSuppressReturn = function() { return this.suppressReturn; }
	/**
	 * Set the boolean to indicate if the return key should be suppressed during entry
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TextField.setSuppressReturn
	 */
	this.setSuppressReturn = function(value) { this.suppressReturn = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TextField.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_TextField.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TextField.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_TextField.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_TextField.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TextField.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_TextField.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_TextField.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_TextField.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * value of the field
	 * @alias Titanium_UI_TextField.value
	 * @property {String}
	 */
	this.value = ''
	/**
	 * Get the value of the field
	 * @alias Titanium_UI_TextField.getValue
	 * @return {String}
	 */
	this.getValue = function() { return this.value; }
	/**
	 * Set the value of the field
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_TextField.setValue
	 */
	this.setValue = function(value) { this.value = value; }
	/**
	 * the constant or string value for the fields vertical alignment.
	 * @alias Titanium_UI_TextField.verticalAlign
	 * @property {Integer,String}
	 */
	this.verticalAlign = 0
	/**
	 * Get the the constant or string value for the fields vertical alignment.
	 * @alias Titanium_UI_TextField.getVerticalAlign
	 * @return {Integer,String}
	 */
	this.getVerticalAlign = function() { return this.verticalAlign; }
	/**
	 * Set the the constant or string value for the fields vertical alignment.
	 * @param {Integer,String} value New value to set.
	 * @alias Titanium_UI_TextField.setVerticalAlign
	 */
	this.setVerticalAlign = function(value) { this.verticalAlign = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_TextField.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_TextField.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_TextField.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_TextField.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_TextField.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_TextField.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_TextField.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_TextField.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_TextField.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_TextField.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_TextField.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_TextField.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * force the field to lose focus
	 * @alias Titanium_UI_TextField.blur
	 */
	this.blur = function blur() { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_TextField.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * force the field to gain focus
	 * @alias Titanium_UI_TextField.focus
	 */
	this.focus = function focus() { }
	/**
	 * return boolean (true) if the field has text
	 * @alias Titanium_UI_TextField.hasText
	 */
	this.hasText = function hasText() { }
	/**
	 * hide the view
	 * @alias Titanium_UI_TextField.hide
	 */
	this.hide = function hide() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_TextField.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_TextField.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_TextField.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_TextField.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * A Toolbar is created by the method Titanium.UI.createToolbar.  A Toolbar can be placed at the bottom of a window and contain buttons.
 * @since 0.8
 */
function Titanium_UI_Toolbar() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_Toolbar.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_Toolbar.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Toolbar.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_Toolbar.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_Toolbar.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Toolbar.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * the background color of the view
	 * @alias Titanium_UI_Toolbar.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the view
	 * @alias Titanium_UI_Toolbar.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Toolbar.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_Toolbar.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_Toolbar.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Toolbar.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_UI_Toolbar.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_UI_Toolbar.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Toolbar.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_Toolbar.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_Toolbar.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Toolbar.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_Toolbar.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_Toolbar.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Toolbar.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_Toolbar.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_Toolbar.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Toolbar.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_Toolbar.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_Toolbar.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Toolbar.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_Toolbar.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_Toolbar.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Toolbar.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Toolbar.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Toolbar.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Toolbar.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_Toolbar.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_Toolbar.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Toolbar.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_Toolbar.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_Toolbar.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Toolbar.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Toolbar.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Toolbar.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Toolbar.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_Toolbar.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_Toolbar.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Toolbar.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Toolbar.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Toolbar.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Toolbar.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_Toolbar.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_Toolbar.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Toolbar.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Toolbar.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Toolbar.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Toolbar.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_Toolbar.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_Toolbar.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Toolbar.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_Toolbar.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_Toolbar.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Toolbar.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_Toolbar.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_Toolbar.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Toolbar.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_Toolbar.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_Toolbar.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Toolbar.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_Toolbar.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_Toolbar.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_Toolbar.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_Toolbar.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_Toolbar.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_Toolbar.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_Toolbar.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_UI_Toolbar.hide
	 */
	this.hide = function hide() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_Toolbar.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_Toolbar.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_Toolbar.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_Toolbar.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * The View is an empty drawing surface or container. The View is created by the method Titanium.UI.createView.
 * @since 0.9
 */
function Titanium_UI_View() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_View.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_View.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_View.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_View.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_View.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_View.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * the background color of the view
	 * @alias Titanium_UI_View.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the view
	 * @alias Titanium_UI_View.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_View.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_View.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_View.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_View.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_UI_View.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_UI_View.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_View.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_View.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_View.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_View.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_View.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_View.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_View.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_View.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_View.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_View.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_View.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_View.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_View.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_View.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_View.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_View.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_View.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_View.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_View.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_View.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_View.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_View.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_View.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_View.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_View.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_View.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_View.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_View.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_View.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_View.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_View.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_View.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_View.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_View.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_View.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_View.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_View.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_View.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_View.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_View.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_View.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_View.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_View.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_View.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_View.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_View.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_View.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_View.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_View.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_View.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_View.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_View.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_View.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_View.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_View.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_View.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_View.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_View.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_View.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_UI_View.hide
	 */
	this.hide = function hide() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_View.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_View.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_View.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_View.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * The Web View allows you to open an HTML5 based view which can load either local or remote content. The content can be any valid web content such as HTML, PDF, SVG or other WebKit supported content types. The Web View is created by the method Titanium.UI.createWebView.
 * @since 0.8
 */
function Titanium_UI_WebView() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_WebView.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_WebView.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_WebView.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_WebView.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_WebView.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_WebView.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * the background color for the webview
	 * @alias Titanium_UI_WebView.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color for the webview
	 * @alias Titanium_UI_WebView.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color for the webview
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_WebView.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_WebView.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_WebView.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_WebView.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_UI_WebView.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_UI_WebView.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_WebView.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_WebView.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_WebView.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_WebView.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_WebView.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_WebView.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_WebView.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_WebView.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_WebView.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_WebView.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_WebView.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_WebView.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_WebView.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_WebView.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_WebView.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_WebView.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_WebView.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_WebView.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_WebView.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_WebView.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_WebView.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_WebView.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * a data blob or file that is used to load the web document
	 * @alias Titanium_UI_WebView.data
	 * @property {Object}
	 */
	this.data = {}
	/**
	 * Get the a data blob or file that is used to load the web document
	 * @alias Titanium_UI_WebView.getData
	 * @return {Object}
	 */
	this.getData = function() { return this.data; }
	/**
	 * Set the a data blob or file that is used to load the web document
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_WebView.setData
	 */
	this.setData = function(value) { this.data = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_WebView.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_WebView.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_WebView.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * the html content of the web document
	 * @alias Titanium_UI_WebView.html
	 * @property {String}
	 */
	this.html = ''
	/**
	 * Get the the html content of the web document
	 * @alias Titanium_UI_WebView.getHtml
	 * @return {String}
	 */
	this.getHtml = function() { return this.html; }
	/**
	 * Set the the html content of the web document
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_WebView.setHtml
	 */
	this.setHtml = function(value) { this.html = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_WebView.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_WebView.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_WebView.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * boolean indicating if the webview is loading content
	 * @alias Titanium_UI_WebView.loading
	 * @property {Boolean}
	 */
	this.loading = false
	/**
	 * Get the boolean indicating if the webview is loading content
	 * @alias Titanium_UI_WebView.getLoading
	 * @return {Boolean}
	 */
	this.getLoading = function() { return this.loading; }
	/**
	 * Set the boolean indicating if the webview is loading content
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_WebView.setLoading
	 */
	this.setLoading = function(value) { this.loading = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_WebView.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_WebView.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_WebView.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_WebView.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_WebView.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_WebView.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * whether the webview should scale it's contents or not
	 * @alias Titanium_UI_WebView.scalesPageToFit
	 * @property {Boolean}
	 */
	this.scalesPageToFit = false
	/**
	 * Get the whether the webview should scale it's contents or not
	 * @alias Titanium_UI_WebView.getScalesPageToFit
	 * @return {Boolean}
	 */
	this.getScalesPageToFit = function() { return this.scalesPageToFit; }
	/**
	 * Set the whether the webview should scale it's contents or not
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_WebView.setScalesPageToFit
	 */
	this.setScalesPageToFit = function(value) { this.scalesPageToFit = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_WebView.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_WebView.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_WebView.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_WebView.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_WebView.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_WebView.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_WebView.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_WebView.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_WebView.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_WebView.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_WebView.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_WebView.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * the url to the web document. this property will change as the content of the webview changes (such as from internal hyperlinks, etc)
	 * @alias Titanium_UI_WebView.url
	 * @property {String}
	 */
	this.url = ''
	/**
	 * Get the the url to the web document. this property will change as the content of the webview changes (such as from internal hyperlinks, etc)
	 * @alias Titanium_UI_WebView.getUrl
	 * @return {String}
	 */
	this.getUrl = function() { return this.url; }
	/**
	 * Set the the url to the web document. this property will change as the content of the webview changes (such as from internal hyperlinks, etc)
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_WebView.setUrl
	 */
	this.setUrl = function(value) { this.url = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_WebView.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_WebView.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_WebView.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_WebView.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_WebView.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_WebView.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_WebView.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_WebView.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_WebView.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_WebView.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_WebView.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_WebView.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * returns true if the webview can go back in history
	 * @alias Titanium_UI_WebView.canGoBack
	 * @return {Boolean}
	 */
	this.canGoBack = function canGoBack() { return false; }
	/**
	 * returns true if the webview can go forward in history
	 * @alias Titanium_UI_WebView.canGoForward
	 * @return {Boolean}
	 */
	this.canGoForward = function canGoForward() { return false; }
	/**
	 * invoke JavaScript inside the context of the webview and optionally, return a result
	 * @param {String} content JavaScript code as a string. The code will be evaluated inside the webview context.
	 * @alias Titanium_UI_WebView.evalJS
	 * @return {String}
	 */
	this.evalJS = function evalJS(content) { return ''; }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_WebView.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * go back one entry in history to the previous page
	 * @alias Titanium_UI_WebView.goBack
	 */
	this.goBack = function goBack() { }
	/**
	 * go forward one entry in history to the page before the current page
	 * @alias Titanium_UI_WebView.goForward
	 */
	this.goForward = function goForward() { }
	/**
	 * hide the view
	 * @alias Titanium_UI_WebView.hide
	 */
	this.hide = function hide() { }
	/**
	 * reload the current webpage
	 * @alias Titanium_UI_WebView.reload
	 */
	this.reload = function reload() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_WebView.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_WebView.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * force the webview to repaint its contents
	 * @alias Titanium_UI_WebView.repaint
	 */
	this.repaint = function repaint() { }
	/**
	 * set the basic authentication for the webview instance to be used on subsequent url requests
	 * @param {String} username the username
	 * @param {String} password the password
	 * @alias Titanium_UI_WebView.setBasicAuthentication
	 */
	this.setBasicAuthentication = function setBasicAuthentication(username,password) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_WebView.show
	 */
	this.show = function show() { }
	/**
	 * stop loading a currently loading page
	 * @alias Titanium_UI_WebView.stopLoading
	 */
	this.stopLoading = function stopLoading() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_WebView.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * The Window is an empty drawing surface or container. The Window is created by the method Titanium.UI.createWindow. Unlike Views, Windows can be opened and closed and can have special display properties such as fullscreen or modal.
 * @since 0.9
 */
function Titanium_UI_Window() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_Window.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_Window.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Window.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_Window.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_Window.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Window.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * title for the back button. only available in iPhone. this is only valid when the window is a child of a tab.
	 * @alias Titanium_UI_Window.backButtonTitle
	 * @property {String}
	 */
	this.backButtonTitle = ''
	/**
	 * Get the title for the back button. only available in iPhone. this is only valid when the window is a child of a tab.
	 * @alias Titanium_UI_Window.getBackButtonTitle
	 * @return {String}
	 */
	this.getBackButtonTitle = function() { return this.backButtonTitle; }
	/**
	 * Set the title for the back button. only available in iPhone. this is only valid when the window is a child of a tab.
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Window.setBackButtonTitle
	 */
	this.setBackButtonTitle = function(value) { this.backButtonTitle = value; }
	/**
	 * url to an image to show as the back button.  only available in iPhone. this is only valid when the window is a child of a tab.
	 * @alias Titanium_UI_Window.backButtonTitleImage
	 * @property {String}
	 */
	this.backButtonTitleImage = ''
	/**
	 * Get the url to an image to show as the back button.  only available in iPhone. this is only valid when the window is a child of a tab.
	 * @alias Titanium_UI_Window.getBackButtonTitleImage
	 * @return {String}
	 */
	this.getBackButtonTitleImage = function() { return this.backButtonTitleImage; }
	/**
	 * Set the url to an image to show as the back button.  only available in iPhone. this is only valid when the window is a child of a tab.
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Window.setBackButtonTitleImage
	 */
	this.setBackButtonTitleImage = function(value) { this.backButtonTitleImage = value; }
	/**
	 * the background color of the view
	 * @alias Titanium_UI_Window.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the view
	 * @alias Titanium_UI_Window.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Window.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_Window.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_Window.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Window.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_UI_Window.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_UI_Window.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Window.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_Window.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_Window.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Window.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_Window.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_Window.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Window.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * web named color or hex value for the color of the nav bar. only available in iPhone.
	 * @alias Titanium_UI_Window.barColor
	 * @property {String}
	 */
	this.barColor = ''
	/**
	 * Get the web named color or hex value for the color of the nav bar. only available in iPhone.
	 * @alias Titanium_UI_Window.getBarColor
	 * @return {String}
	 */
	this.getBarColor = function() { return this.barColor; }
	/**
	 * Set the web named color or hex value for the color of the nav bar. only available in iPhone.
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Window.setBarColor
	 */
	this.setBarColor = function(value) { this.barColor = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_Window.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_Window.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Window.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_Window.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_Window.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Window.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_Window.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_Window.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Window.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Window.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Window.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Window.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_Window.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_Window.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Window.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * boolean indicates if the window is fullscreen (no device chrome)
	 * @alias Titanium_UI_Window.fullscreen
	 * @property {Boolean}
	 */
	this.fullscreen = false
	/**
	 * Get the boolean indicates if the window is fullscreen (no device chrome)
	 * @alias Titanium_UI_Window.getFullscreen
	 * @return {Boolean}
	 */
	this.getFullscreen = function() { return this.fullscreen; }
	/**
	 * Set the boolean indicates if the window is fullscreen (no device chrome)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Window.setFullscreen
	 */
	this.setFullscreen = function(value) { this.fullscreen = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_Window.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_Window.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Window.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Window.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Window.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Window.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * view to show in the left nav bar area. only available in iPhone.
	 * @alias Titanium_UI_Window.leftNavButton
	 * @property {Object}
	 */
	this.leftNavButton = {}
	/**
	 * Get the view to show in the left nav bar area. only available in iPhone.
	 * @alias Titanium_UI_Window.getLeftNavButton
	 * @return {Object}
	 */
	this.getLeftNavButton = function() { return this.leftNavButton; }
	/**
	 * Set the view to show in the left nav bar area. only available in iPhone.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Window.setLeftNavButton
	 */
	this.setLeftNavButton = function(value) { this.leftNavButton = value; }
	/**
	 * boolean to indicate if the window should be opened modal in front of other windows
	 * @alias Titanium_UI_Window.modal
	 * @property {Boolean}
	 */
	this.modal = false
	/**
	 * Get the boolean to indicate if the window should be opened modal in front of other windows
	 * @alias Titanium_UI_Window.getModal
	 * @return {Boolean}
	 */
	this.getModal = function() { return this.modal; }
	/**
	 * Set the boolean to indicate if the window should be opened modal in front of other windows
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Window.setModal
	 */
	this.setModal = function(value) { this.modal = value; }
	/**
	 * for modal windows, hide the nav bar (true) or show the nav bar (false, default).
	 * @alias Titanium_UI_Window.navBarHidden
	 * @property {Boolean}
	 */
	this.navBarHidden = false
	/**
	 * Get the for modal windows, hide the nav bar (true) or show the nav bar (false, default).
	 * @alias Titanium_UI_Window.getNavBarHidden
	 * @return {Boolean}
	 */
	this.getNavBarHidden = function() { return this.navBarHidden; }
	/**
	 * Set the for modal windows, hide the nav bar (true) or show the nav bar (false, default).
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Window.setNavBarHidden
	 */
	this.setNavBarHidden = function(value) { this.navBarHidden = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_Window.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_Window.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_Window.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * array of orientation mode constants defined in [Titanium.UI]
	 * @alias Titanium_UI_Window.orientationModes
	 * @property {Array}
	 */
	this.orientationModes = []
	/**
	 * Get the array of orientation mode constants defined in [Titanium.UI]
	 * @alias Titanium_UI_Window.getOrientationModes
	 * @return {Array}
	 */
	this.getOrientationModes = function() { return this.orientationModes; }
	/**
	 * Set the array of orientation mode constants defined in [Titanium.UI]
	 * @param {Array} value New value to set.
	 * @alias Titanium_UI_Window.setOrientationModes
	 */
	this.setOrientationModes = function(value) { this.orientationModes = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Window.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Window.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Window.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * view to show in the right nav bar area. only available in iPhone.
	 * @alias Titanium_UI_Window.rightNavButton
	 * @property {Object}
	 */
	this.rightNavButton = {}
	/**
	 * Get the view to show in the right nav bar area. only available in iPhone.
	 * @alias Titanium_UI_Window.getRightNavButton
	 * @return {Object}
	 */
	this.getRightNavButton = function() { return this.rightNavButton; }
	/**
	 * Set the view to show in the right nav bar area. only available in iPhone.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Window.setRightNavButton
	 */
	this.setRightNavButton = function(value) { this.rightNavButton = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_Window.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_Window.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Window.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * boolean to indicate if the tab bar should be hidden. this is only valid when the window is a child of a tab.
	 * @alias Titanium_UI_Window.tabBarHidden
	 * @property {Boolean}
	 */
	this.tabBarHidden = false
	/**
	 * Get the boolean to indicate if the tab bar should be hidden. this is only valid when the window is a child of a tab.
	 * @alias Titanium_UI_Window.getTabBarHidden
	 * @return {Boolean}
	 */
	this.getTabBarHidden = function() { return this.tabBarHidden; }
	/**
	 * Set the boolean to indicate if the tab bar should be hidden. this is only valid when the window is a child of a tab.
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Window.setTabBarHidden
	 */
	this.setTabBarHidden = function(value) { this.tabBarHidden = value; }
	/**
	 * title of the window.
	 * @alias Titanium_UI_Window.title
	 * @property {String}
	 */
	this.title = ''
	/**
	 * Get the title of the window.
	 * @alias Titanium_UI_Window.getTitle
	 * @return {String}
	 */
	this.getTitle = function() { return this.title; }
	/**
	 * Set the title of the window.
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Window.setTitle
	 */
	this.setTitle = function(value) { this.title = value; }
	/**
	 * view to show in the title area. only available in iPhone.
	 * @alias Titanium_UI_Window.titleControl
	 * @property {Object}
	 */
	this.titleControl = {}
	/**
	 * Get the view to show in the title area. only available in iPhone.
	 * @alias Titanium_UI_Window.getTitleControl
	 * @return {Object}
	 */
	this.getTitleControl = function() { return this.titleControl; }
	/**
	 * Set the view to show in the title area. only available in iPhone.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Window.setTitleControl
	 */
	this.setTitleControl = function(value) { this.titleControl = value; }
	/**
	 * url to a image that show in the title area. only available in iPhone.
	 * @alias Titanium_UI_Window.titleImage
	 * @property {String}
	 */
	this.titleImage = ''
	/**
	 * Get the url to a image that show in the title area. only available in iPhone.
	 * @alias Titanium_UI_Window.getTitleImage
	 * @return {String}
	 */
	this.getTitleImage = function() { return this.titleImage; }
	/**
	 * Set the url to a image that show in the title area. only available in iPhone.
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Window.setTitleImage
	 */
	this.setTitleImage = function(value) { this.titleImage = value; }
	/**
	 * title prompt for the window. only available in iPhone.
	 * @alias Titanium_UI_Window.titlePrompt
	 * @property {String}
	 */
	this.titlePrompt = ''
	/**
	 * Get the title prompt for the window. only available in iPhone.
	 * @alias Titanium_UI_Window.getTitlePrompt
	 * @return {String}
	 */
	this.getTitlePrompt = function() { return this.titlePrompt; }
	/**
	 * Set the title prompt for the window. only available in iPhone.
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Window.setTitlePrompt
	 */
	this.setTitlePrompt = function(value) { this.titlePrompt = value; }
	/**
	 * array of button objects to show in the toolbar of the window. only available in iPhone. this is only valid when the window is a child of a tab.
	 * @alias Titanium_UI_Window.toolbar
	 * @property {Array}
	 */
	this.toolbar = []
	/**
	 * Get the array of button objects to show in the toolbar of the window. only available in iPhone. this is only valid when the window is a child of a tab.
	 * @alias Titanium_UI_Window.getToolbar
	 * @return {Array}
	 */
	this.getToolbar = function() { return this.toolbar; }
	/**
	 * Set the array of button objects to show in the toolbar of the window. only available in iPhone. this is only valid when the window is a child of a tab.
	 * @param {Array} value New value to set.
	 * @alias Titanium_UI_Window.setToolbar
	 */
	this.setToolbar = function(value) { this.toolbar = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Window.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_Window.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Window.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_Window.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_Window.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Window.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_Window.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_Window.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_Window.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * boolean to indicate if the nav bar is translucent. only available in iPhone.
	 * @alias Titanium_UI_Window.translucent
	 * @property {Boolean}
	 */
	this.translucent = false
	/**
	 * Get the boolean to indicate if the nav bar is translucent. only available in iPhone.
	 * @alias Titanium_UI_Window.getTranslucent
	 * @return {Boolean}
	 */
	this.getTranslucent = function() { return this.translucent; }
	/**
	 * Set the boolean to indicate if the nav bar is translucent. only available in iPhone.
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Window.setTranslucent
	 */
	this.setTranslucent = function(value) { this.translucent = value; }
	/**
	 * url to a JavaScript file with the windows instructions. this window will create a new JavaScript sub-context that will run in its own thread and global variable space.
	 * @alias Titanium_UI_Window.url
	 * @property {String}
	 */
	this.url = ''
	/**
	 * Get the url to a JavaScript file with the windows instructions. this window will create a new JavaScript sub-context that will run in its own thread and global variable space.
	 * @alias Titanium_UI_Window.getUrl
	 * @return {String}
	 */
	this.getUrl = function() { return this.url; }
	/**
	 * Set the url to a JavaScript file with the windows instructions. this window will create a new JavaScript sub-context that will run in its own thread and global variable space.
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_Window.setUrl
	 */
	this.setUrl = function(value) { this.url = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_Window.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_Window.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_Window.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_Window.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_Window.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_Window.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_Window.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_Window.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_Window.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_Window.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_Window.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_Window.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * close the window
	 * @param {Object} options close the window with optional animation or display properties
	 * @alias Titanium_UI_Window.close
	 */
	this.close = function close(options) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_Window.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_UI_Window.hide
	 */
	this.hide = function hide() { }
	/**
	 * open the window
	 * @param {Object} options open the window with optional animation or display properties
	 * @alias Titanium_UI_Window.open
	 */
	this.open = function open(options) { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_Window.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_Window.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_Window.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_Window.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * A Popover is used to manage the presentation of content in a popover. You use popovers to present information temporarily but in a way that does not take over the entire screen like a modal view does. The popover content is layered on top of your existing content in a special type of window. The popover remains visible until the user taps outside of the popover window or you explicitly dismiss it. The Popover is created by the method Titanium.UI.iPad.createPopover.
 * @since 1.2
 */
function Titanium_UI_iPad_Popover() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_iPad_Popover.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_iPad_Popover.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_iPad_Popover.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_iPad_Popover.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * return the arrow direction of the popover
	 * @alias Titanium_UI_iPad_Popover.arrowDirection
	 * @property {Integer}
	 */
	this.arrowDirection = 0
	/**
	 * Get the return the arrow direction of the popover
	 * @alias Titanium_UI_iPad_Popover.getArrowDirection
	 * @return {Integer}
	 */
	this.getArrowDirection = function() { return this.arrowDirection; }
	/**
	 * Set the return the arrow direction of the popover
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setArrowDirection
	 */
	this.setArrowDirection = function(value) { this.arrowDirection = value; }
	/**
	 * the background color of the view
	 * @alias Titanium_UI_iPad_Popover.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the view
	 * @alias Titanium_UI_iPad_Popover.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_iPad_Popover.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_iPad_Popover.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_UI_iPad_Popover.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_UI_iPad_Popover.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_iPad_Popover.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_iPad_Popover.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_iPad_Popover.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_iPad_Popover.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_iPad_Popover.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_iPad_Popover.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_iPad_Popover.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_iPad_Popover.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_iPad_Popover.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_iPad_Popover.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPad_Popover.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPad_Popover.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_iPad_Popover.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_iPad_Popover.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * height of the popover
	 * @alias Titanium_UI_iPad_Popover.height
	 * @property {Float}
	 */
	this.height = 0.0
	/**
	 * Get the height of the popover
	 * @alias Titanium_UI_iPad_Popover.getHeight
	 * @return {Float}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the height of the popover
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPad_Popover.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPad_Popover.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the left button in the nav area of the popover
	 * @alias Titanium_UI_iPad_Popover.leftNavButton
	 * @property {Object}
	 */
	this.leftNavButton = {}
	/**
	 * Get the the left button in the nav area of the popover
	 * @alias Titanium_UI_iPad_Popover.getLeftNavButton
	 * @return {Object}
	 */
	this.getLeftNavButton = function() { return this.leftNavButton; }
	/**
	 * Set the the left button in the nav area of the popover
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setLeftNavButton
	 */
	this.setLeftNavButton = function(value) { this.leftNavButton = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_iPad_Popover.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_iPad_Popover.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPad_Popover.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPad_Popover.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * the right button in the nav area of the popover
	 * @alias Titanium_UI_iPad_Popover.rightNavButton
	 * @property {Object}
	 */
	this.rightNavButton = {}
	/**
	 * Get the the right button in the nav area of the popover
	 * @alias Titanium_UI_iPad_Popover.getRightNavButton
	 * @return {Object}
	 */
	this.getRightNavButton = function() { return this.rightNavButton; }
	/**
	 * Set the the right button in the nav area of the popover
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setRightNavButton
	 */
	this.setRightNavButton = function(value) { this.rightNavButton = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_iPad_Popover.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_iPad_Popover.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * the title of the nav area of the popover
	 * @alias Titanium_UI_iPad_Popover.title
	 * @property {String}
	 */
	this.title = ''
	/**
	 * Get the the title of the nav area of the popover
	 * @alias Titanium_UI_iPad_Popover.getTitle
	 * @return {String}
	 */
	this.getTitle = function() { return this.title; }
	/**
	 * Set the the title of the nav area of the popover
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setTitle
	 */
	this.setTitle = function(value) { this.title = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPad_Popover.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPad_Popover.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_iPad_Popover.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_iPad_Popover.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_iPad_Popover.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_iPad_Popover.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * boolean to indicate if the popover is visible
	 * @alias Titanium_UI_iPad_Popover.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the boolean to indicate if the popover is visible
	 * @alias Titanium_UI_iPad_Popover.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the boolean to indicate if the popover is visible
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * width of the popover
	 * @alias Titanium_UI_iPad_Popover.width
	 * @property {Float}
	 */
	this.width = 0.0
	/**
	 * Get the width of the popover
	 * @alias Titanium_UI_iPad_Popover.getWidth
	 * @return {Float}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the width of the popover
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_iPad_Popover.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_iPad_Popover.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_iPad_Popover.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_iPad_Popover.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_iPad_Popover.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_iPad_Popover.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_iPad_Popover.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the popover
	 * @param {Object} options dictionary with optional boolean property <tt>animated</tt> which indicates if the popover should be hidden with animation (defaults to true) or not
	 * @alias Titanium_UI_iPad_Popover.hide
	 */
	this.hide = function hide(options) { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_iPad_Popover.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_iPad_Popover.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * change the height of the popover
	 * @param {Integer,String} height height of the popover
	 * @alias Titanium_UI_iPad_Popover.setHeight
	 */
	this.setHeight = function setHeight(height) { }
	/**
	 * change the width of the popover
	 * @param {Integer,String} width width of the popover
	 * @alias Titanium_UI_iPad_Popover.setWidth
	 */
	this.setWidth = function setWidth(width) { }
	/**
	 * show the popover
	 * @param {Object} options dictionary of the following properties: <tt>rect</tt>, <tt>animated</tt> and <tt>view</tt>. The <tt>view</tt> property should specify the view relative to where the popover should display.  <tt>animated</tt> is a boolean indicating if the showing of the popover should be animated, defaults to true. The property <tt>rect</tt> is a dictionary with the following properties: <tt>x</tt>, <tt>y</tt>, <tt>width</tt> and <tt>height</tt>, where the rectangle in <tt>view</tt> at which to anchor the popover.
	 * @alias Titanium_UI_iPad_Popover.show
	 */
	this.show = function show(options) { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_iPad_Popover.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * A SplitWindow is a window that manages the presentation of two side-by-side view controllers. You use this class to implement a master-detail interface, in which the left-side view presents a list of items and the right-side presents details of the selected item. The SplitView is for use exclusively on iPad devices. The SplitWindow is created by the method Titanium.UI.iPad.createSplitWindow.
 * @since 1.2
 */
function Titanium_UI_iPad_SplitWindow() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_iPad_SplitWindow.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_iPad_SplitWindow.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_iPad_SplitWindow.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_iPad_SplitWindow.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * the background color of the view
	 * @alias Titanium_UI_iPad_SplitWindow.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the view
	 * @alias Titanium_UI_iPad_SplitWindow.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_iPad_SplitWindow.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_iPad_SplitWindow.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_UI_iPad_SplitWindow.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_UI_iPad_SplitWindow.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_iPad_SplitWindow.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_iPad_SplitWindow.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_iPad_SplitWindow.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_iPad_SplitWindow.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_iPad_SplitWindow.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_iPad_SplitWindow.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_iPad_SplitWindow.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_iPad_SplitWindow.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_iPad_SplitWindow.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_iPad_SplitWindow.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPad_SplitWindow.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPad_SplitWindow.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_iPad_SplitWindow.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_iPad_SplitWindow.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * view for the detail view section of the SplitWindow
	 * @alias Titanium_UI_iPad_SplitWindow.detailView
	 * @property {Object}
	 */
	this.detailView = {}
	/**
	 * Get the view for the detail view section of the SplitWindow
	 * @alias Titanium_UI_iPad_SplitWindow.getDetailView
	 * @return {Object}
	 */
	this.getDetailView = function() { return this.detailView; }
	/**
	 * Set the view for the detail view section of the SplitWindow
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setDetailView
	 */
	this.setDetailView = function(value) { this.detailView = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_iPad_SplitWindow.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_iPad_SplitWindow.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPad_SplitWindow.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPad_SplitWindow.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * view for the master view section of the SplitWindow
	 * @alias Titanium_UI_iPad_SplitWindow.masterView
	 * @property {Object}
	 */
	this.masterView = {}
	/**
	 * Get the view for the master view section of the SplitWindow
	 * @alias Titanium_UI_iPad_SplitWindow.getMasterView
	 * @return {Object}
	 */
	this.getMasterView = function() { return this.masterView; }
	/**
	 * Set the view for the master view section of the SplitWindow
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setMasterView
	 */
	this.setMasterView = function(value) { this.masterView = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_iPad_SplitWindow.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_iPad_SplitWindow.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPad_SplitWindow.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPad_SplitWindow.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_iPad_SplitWindow.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_iPad_SplitWindow.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPad_SplitWindow.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPad_SplitWindow.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_iPad_SplitWindow.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_iPad_SplitWindow.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_iPad_SplitWindow.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_iPad_SplitWindow.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_iPad_SplitWindow.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_iPad_SplitWindow.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_iPad_SplitWindow.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_iPad_SplitWindow.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_iPad_SplitWindow.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_iPad_SplitWindow.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_iPad_SplitWindow.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_iPad_SplitWindow.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_iPad_SplitWindow.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_iPad_SplitWindow.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_iPad_SplitWindow.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_UI_iPad_SplitWindow.hide
	 */
	this.hide = function hide() { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_iPad_SplitWindow.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_iPad_SplitWindow.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_iPad_SplitWindow.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_iPad_SplitWindow.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * A Navigation Group implements a specialized view that manages the navigation of hierarchical content. The Navigation Group is created by the method Titanium.UI.iPhone.NavigationGroup.

A Navigation Group is very similar to Tab Bars with the exception that they do not maintain a group of windows with a interface bar at the bottom.
 * @since 1.2
 */
function Titanium_UI_iPhone_NavigationGroup() {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_iPhone_NavigationGroup.anchorPoint
	 * @property {Object}
	 */
	this.anchorPoint = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium_UI_iPhone_NavigationGroup.getAnchorPoint
	 * @return {Object}
	 */
	this.getAnchorPoint = function() { return this.anchorPoint; }
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_iPhone_NavigationGroup.setAnchorPoint
	 */
	this.setAnchorPoint = function(value) { this.anchorPoint = value; }
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_iPhone_NavigationGroup.animatedCenterPoint
	 * @property {Object}
	 */
	this.animatedCenterPoint = {}
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium_UI_iPhone_NavigationGroup.getAnimatedCenterPoint
	 * @return {Object}
	 */
	this.getAnimatedCenterPoint = function() { return this.animatedCenterPoint; }
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_iPhone_NavigationGroup.setAnimatedCenterPoint
	 */
	this.setAnimatedCenterPoint = function(value) { this.animatedCenterPoint = value; }
	/**
	 * the background color of the view
	 * @alias Titanium_UI_iPhone_NavigationGroup.backgroundColor
	 * @property {String}
	 */
	this.backgroundColor = ''
	/**
	 * Get the the background color of the view
	 * @alias Titanium_UI_iPhone_NavigationGroup.getBackgroundColor
	 * @return {String}
	 */
	this.getBackgroundColor = function() { return this.backgroundColor; }
	/**
	 * Set the the background color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_iPhone_NavigationGroup.setBackgroundColor
	 */
	this.setBackgroundColor = function(value) { this.backgroundColor = value; }
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_iPhone_NavigationGroup.backgroundGradient
	 * @property {Object}
	 */
	this.backgroundGradient = {}
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium_UI_iPhone_NavigationGroup.getBackgroundGradient
	 * @return {Object}
	 */
	this.getBackgroundGradient = function() { return this.backgroundGradient; }
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_iPhone_NavigationGroup.setBackgroundGradient
	 */
	this.setBackgroundGradient = function(value) { this.backgroundGradient = value; }
	/**
	 * the background image url of the view
	 * @alias Titanium_UI_iPhone_NavigationGroup.backgroundImage
	 * @property {String}
	 */
	this.backgroundImage = ''
	/**
	 * Get the the background image url of the view
	 * @alias Titanium_UI_iPhone_NavigationGroup.getBackgroundImage
	 * @return {String}
	 */
	this.getBackgroundImage = function() { return this.backgroundImage; }
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_iPhone_NavigationGroup.setBackgroundImage
	 */
	this.setBackgroundImage = function(value) { this.backgroundImage = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_iPhone_NavigationGroup.backgroundLeftCap
	 * @property {Float}
	 */
	this.backgroundLeftCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium_UI_iPhone_NavigationGroup.getBackgroundLeftCap
	 * @return {Float}
	 */
	this.getBackgroundLeftCap = function() { return this.backgroundLeftCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_iPhone_NavigationGroup.setBackgroundLeftCap
	 */
	this.setBackgroundLeftCap = function(value) { this.backgroundLeftCap = value; }
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_iPhone_NavigationGroup.backgroundTopCap
	 * @property {Float}
	 */
	this.backgroundTopCap = 0.0
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium_UI_iPhone_NavigationGroup.getBackgroundTopCap
	 * @return {Float}
	 */
	this.getBackgroundTopCap = function() { return this.backgroundTopCap; }
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_iPhone_NavigationGroup.setBackgroundTopCap
	 */
	this.setBackgroundTopCap = function(value) { this.backgroundTopCap = value; }
	/**
	 * the border color of the view
	 * @alias Titanium_UI_iPhone_NavigationGroup.borderColor
	 * @property {String}
	 */
	this.borderColor = ''
	/**
	 * Get the the border color of the view
	 * @alias Titanium_UI_iPhone_NavigationGroup.getBorderColor
	 * @return {String}
	 */
	this.getBorderColor = function() { return this.borderColor; }
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium_UI_iPhone_NavigationGroup.setBorderColor
	 */
	this.setBorderColor = function(value) { this.borderColor = value; }
	/**
	 * the border radius of the view
	 * @alias Titanium_UI_iPhone_NavigationGroup.borderRadius
	 * @property {Float}
	 */
	this.borderRadius = 0.0
	/**
	 * Get the the border radius of the view
	 * @alias Titanium_UI_iPhone_NavigationGroup.getBorderRadius
	 * @return {Float}
	 */
	this.getBorderRadius = function() { return this.borderRadius; }
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_iPhone_NavigationGroup.setBorderRadius
	 */
	this.setBorderRadius = function(value) { this.borderRadius = value; }
	/**
	 * the border width of the view
	 * @alias Titanium_UI_iPhone_NavigationGroup.borderWidth
	 * @property {Float}
	 */
	this.borderWidth = 0.0
	/**
	 * Get the the border width of the view
	 * @alias Titanium_UI_iPhone_NavigationGroup.getBorderWidth
	 * @return {Float}
	 */
	this.getBorderWidth = function() { return this.borderWidth; }
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_iPhone_NavigationGroup.setBorderWidth
	 */
	this.setBorderWidth = function(value) { this.borderWidth = value; }
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPhone_NavigationGroup.bottom
	 * @property {Float,String}
	 */
	this.bottom = 0.0
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPhone_NavigationGroup.getBottom
	 * @return {Float,String}
	 */
	this.getBottom = function() { return this.bottom; }
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_iPhone_NavigationGroup.setBottom
	 */
	this.setBottom = function(value) { this.bottom = value; }
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_iPhone_NavigationGroup.center
	 * @property {Object}
	 */
	this.center = {}
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium_UI_iPhone_NavigationGroup.getCenter
	 * @return {Object}
	 */
	this.getCenter = function() { return this.center; }
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_iPhone_NavigationGroup.setCenter
	 */
	this.setCenter = function(value) { this.center = value; }
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_iPhone_NavigationGroup.height
	 * @property {Float,String}
	 */
	this.height = 0.0
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium_UI_iPhone_NavigationGroup.getHeight
	 * @return {Float,String}
	 */
	this.getHeight = function() { return this.height; }
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_iPhone_NavigationGroup.setHeight
	 */
	this.setHeight = function(value) { this.height = value; }
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPhone_NavigationGroup.left
	 * @property {Float,String}
	 */
	this.left = 0.0
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPhone_NavigationGroup.getLeft
	 * @return {Float,String}
	 */
	this.getLeft = function() { return this.left; }
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_iPhone_NavigationGroup.setLeft
	 */
	this.setLeft = function(value) { this.left = value; }
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium_UI_iPhone_NavigationGroup.opacity
	 * @property {Float}
	 */
	this.opacity = 0.0
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium_UI_iPhone_NavigationGroup.getOpacity
	 * @return {Float}
	 */
	this.getOpacity = function() { return this.opacity; }
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium_UI_iPhone_NavigationGroup.setOpacity
	 */
	this.setOpacity = function(value) { this.opacity = value; }
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPhone_NavigationGroup.right
	 * @property {Float,String}
	 */
	this.right = 0.0
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPhone_NavigationGroup.getRight
	 * @return {Float,String}
	 */
	this.getRight = function() { return this.right; }
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_iPhone_NavigationGroup.setRight
	 */
	this.setRight = function(value) { this.right = value; }
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_iPhone_NavigationGroup.size
	 * @property {Object}
	 */
	this.size = {}
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium_UI_iPhone_NavigationGroup.getSize
	 * @return {Object}
	 */
	this.getSize = function() { return this.size; }
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_iPhone_NavigationGroup.setSize
	 */
	this.setSize = function(value) { this.size = value; }
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPhone_NavigationGroup.top
	 * @property {Float,String}
	 */
	this.top = 0.0
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium_UI_iPhone_NavigationGroup.getTop
	 * @return {Float,String}
	 */
	this.getTop = function() { return this.top; }
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_iPhone_NavigationGroup.setTop
	 */
	this.setTop = function(value) { this.top = value; }
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_iPhone_NavigationGroup.touchEnabled
	 * @property {Boolean}
	 */
	this.touchEnabled = false
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium_UI_iPhone_NavigationGroup.getTouchEnabled
	 * @return {Boolean}
	 */
	this.getTouchEnabled = function() { return this.touchEnabled; }
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_iPhone_NavigationGroup.setTouchEnabled
	 */
	this.setTouchEnabled = function(value) { this.touchEnabled = value; }
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium_UI_iPhone_NavigationGroup.transform
	 * @property {Object}
	 */
	this.transform = {}
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium_UI_iPhone_NavigationGroup.getTransform
	 * @return {Object}
	 */
	this.getTransform = function() { return this.transform; }
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium_UI_iPhone_NavigationGroup.setTransform
	 */
	this.setTransform = function(value) { this.transform = value; }
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium_UI_iPhone_NavigationGroup.visible
	 * @property {Boolean}
	 */
	this.visible = false
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium_UI_iPhone_NavigationGroup.getVisible
	 * @return {Boolean}
	 */
	this.getVisible = function() { return this.visible; }
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium_UI_iPhone_NavigationGroup.setVisible
	 */
	this.setVisible = function(value) { this.visible = value; }
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_iPhone_NavigationGroup.width
	 * @property {Float,String}
	 */
	this.width = 0.0
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium_UI_iPhone_NavigationGroup.getWidth
	 * @return {Float,String}
	 */
	this.getWidth = function() { return this.width; }
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium_UI_iPhone_NavigationGroup.setWidth
	 */
	this.setWidth = function(value) { this.width = value; }
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium_UI_iPhone_NavigationGroup.zIndex
	 * @property {Integer}
	 */
	this.zIndex = 0
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium_UI_iPhone_NavigationGroup.getZIndex
	 * @return {Integer}
	 */
	this.getZIndex = function() { return this.zIndex; }
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium_UI_iPhone_NavigationGroup.setZIndex
	 */
	this.setZIndex = function(value) { this.zIndex = value; }
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium_UI_iPhone_NavigationGroup.add
	 */
	this.add = function add(view) { }
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium_UI_iPhone_NavigationGroup.addEventListener
	 */
	this.addEventListener = function addEventListener(name,callback) { }
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium_UI_iPhone_NavigationGroup.animate
	 */
	this.animate = function animate(obj,callback) { }
	/**
	 * close a window and remove it from the navigation group
	 * @param {Object} window window to close
	 * @param {Object} [properties] optional dictionary. the only current property supported is <tt>animated</tt> which is a boolean to indicate if the window should be closed animated (default) or not.
	 * @alias Titanium_UI_iPhone_NavigationGroup.close
	 */
	this.close = function close(window,properties) { }
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium_UI_iPhone_NavigationGroup.fireEvent
	 */
	this.fireEvent = function fireEvent(name,event) { }
	/**
	 * hide the view
	 * @alias Titanium_UI_iPhone_NavigationGroup.hide
	 */
	this.hide = function hide() { }
	/**
	 * open a window within the navigation group
	 * @param {Object} window window to open within the tab group
	 * @param {Object} [properties] optional dictionary. the only current property supported is <tt>animated</tt> which is a boolean to indicate if the window should be opened animated (default) or not.
	 * @alias Titanium_UI_iPhone_NavigationGroup.open
	 */
	this.open = function open(window,properties) { }
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium_UI_iPhone_NavigationGroup.remove
	 */
	this.remove = function remove(view) { }
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium_UI_iPhone_NavigationGroup.removeEventListener
	 */
	this.removeEventListener = function removeEventListener(name,callback) { }
	/**
	 * make the view visible
	 * @alias Titanium_UI_iPhone_NavigationGroup.show
	 */
	this.show = function show() { }
	/**
	 * return a Blob image of the rendered view
	 * @param {Function} f function to be invoked upon completion. if non-null, this method will be performed asynchronously. if null, it will be performed immediately
	 * @alias Titanium_UI_iPhone_NavigationGroup.toImage
	 * @return {Object}
	 */
	this.toImage = function toImage(f) { return {}; }
};

/**
 * The top level Titanium module.
 * @since 0.1
 */
Titanium = {
	/**
	 * the user-agent string used by Titanium
	 * @alias Titanium.userAgent
	 * @property {String}
	 */
	userAgent: '',
	/**
	 * Get the the user-agent string used by Titanium
	 * @alias Titanium.getUserAgent
	 * @return {String}
	 */
	getUserAgent: function () { return userAgent; },
	/**
	 * Set the the user-agent string used by Titanium
	 * @param {String} value New value to set.
	 * @alias Titanium.setUserAgent
	 */
	setUserAgent: function () { },
	/**
	 * the version of Titanium that is executing
	 * @alias Titanium.version
	 * @property {String}
	 */
	version: '',
	/**
	 * Get the the version of Titanium that is executing
	 * @alias Titanium.getVersion
	 * @return {String}
	 */
	getVersion: function () { return version; },
	/**
	 * Set the the version of Titanium that is executing
	 * @param {String} value New value to set.
	 * @alias Titanium.setVersion
	 */
	setVersion: function () { },
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium.addEventListener
	 */
	addEventListener: function (name,callback) { },
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium.fireEvent
	 */
	fireEvent: function (name,event) { },
	/**
	 * one or more filenames to include as if the Javascript code was written in place.  This is similar to a C #include function.
	 * @param {String} name filename to include
	 * @alias Titanium.include
	 */
	include: function (name) { },
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium.removeEventListener
	 */
	removeEventListener: function (name,callback) { },
};

/**
 * The top level API module.  The API module is mainly used for logging.
 * @since 0.1
 */
Titanium.API = {
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium.API.addEventListener
	 */
	addEventListener: function (name,callback) { },
	/**
	 * function for logging debug messages
	 * @param {String} message the message to log
	 * @alias Titanium.API.debug
	 */
	debug: function (message) { },
	/**
	 * function for logging error messages
	 * @param {String} message the message to log
	 * @alias Titanium.API.error
	 */
	error: function (message) { },
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium.API.fireEvent
	 */
	fireEvent: function (name,event) { },
	/**
	 * function for logging informational messages
	 * @param {String} message the message to log
	 * @alias Titanium.API.info
	 */
	info: function (message) { },
	/**
	 * function for logging custom severity messages
	 * @param {String} level the log level
	 * @param {String} message the message to log
	 * @alias Titanium.API.log
	 */
	log: function (level,message) { },
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium.API.removeEventListener
	 */
	removeEventListener: function (name,callback) { },
	/**
	 * function for logging warning messages
	 * @param {String} message the message to log
	 * @alias Titanium.API.warn
	 */
	warn: function (message) { },
};

/**
 * The top level Accelerometer module.  The Accelerometer modules contains methods and properties for using the device accelerometer.
 * @since 0.1
 */
Titanium.Accelerometer = {
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium.Accelerometer.addEventListener
	 */
	addEventListener: function (name,callback) { },
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium.Accelerometer.fireEvent
	 */
	fireEvent: function (name,event) { },
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium.Accelerometer.removeEventListener
	 */
	removeEventListener: function (name,callback) { },
};

/**
 * The top level Analytics module.  The Analytics module is used for transmitting developer-defined Analytics event for your application to the Appcelerator Analytics product. It can be used to augment additional context or application-specific information which can then be accessed during analysis using Analytics.
 * @since 0.1
 */
Titanium.Analytics = {
	/**
	 * send a generic event for the application session
	 * @param {String} type the event type
	 * @param {String} name the event name
	 * @param {Object} data event data or null if not specified. the object must be serializable as JSON
	 * @alias Titanium.Analytics.addEvent
	 */
	addEvent: function (type,name,data) { },
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium.Analytics.addEventListener
	 */
	addEventListener: function (name,callback) { },
	/**
	 * send an analytics feature event for the application session
	 * @param {String} name the event name
	 * @param {Object} data event data or null if not specified. the object must be serializable as JSON
	 * @alias Titanium.Analytics.featureEvent
	 */
	featureEvent: function (name,data) { },
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium.Analytics.fireEvent
	 */
	fireEvent: function (name,event) { },
	/**
	 * send an analytics nav event for the application session
	 * @param {String} from the <tt>from</tt> location in the nav event
	 * @param {String} to the <tt>to</tt> location in the nav event
	 * @param {String} name the event name
	 * @param {Object} data event data or null if not specified. the object must be serializable as JSON
	 * @alias Titanium.Analytics.navEvent
	 */
	navEvent: function (from,to,name,data) { },
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium.Analytics.removeEventListener
	 */
	removeEventListener: function (name,callback) { },
	/**
	 * send a analytics settings event for the application session
	 * @param {String} name the event name
	 * @param {Object} data event data or null if not specified. the object must be serializable as JSON
	 * @alias Titanium.Analytics.settingsEvent
	 */
	settingsEvent: function (name,data) { },
	/**
	 * send an analytics timed event for the application session
	 * @param {String} name the event name
	 * @param {Date} start the event start as a Date object
	 * @param {Date} stop the event end as a Date object
	 * @param {Float} duration the event duration
	 * @param {Object} data event data or null if not specified. the object must be serializable as JSON
	 * @alias Titanium.Analytics.timedEvent
	 */
	timedEvent: function (name,start,stop,duration,data) { },
	/**
	 * send an analytics user event for the application session
	 * @param {String} name the event name
	 * @param {Object} data event data or null if not specified. the object must be serializable as JSON
	 * @alias Titanium.Analytics.userEvent
	 */
	userEvent: function (name,data) { },
};

/**
 * The top level App module.  The App module is mainly used for accessing information about the application at runtime.
 * @since 0.1
 */
Titanium.App = {
	/**
	 * the application's copyright
	 * @alias Titanium.App.copyright
	 * @property {String}
	 */
	copyright: '',
	/**
	 * Get the the application's copyright
	 * @alias Titanium.App.getCopyright
	 * @return {String}
	 */
	getCopyright: function () { return copyright; },
	/**
	 * Set the the application's copyright
	 * @param {String} value New value to set.
	 * @alias Titanium.App.setCopyright
	 */
	setCopyright: function () { },
	/**
	 * the application's description
	 * @alias Titanium.App.description
	 * @property {String}
	 */
	description: '',
	/**
	 * Get the the application's description
	 * @alias Titanium.App.getDescription
	 * @return {String}
	 */
	getDescription: function () { return description; },
	/**
	 * Set the the application's description
	 * @param {String} value New value to set.
	 * @alias Titanium.App.setDescription
	 */
	setDescription: function () { },
	/**
	 * the application's globally unique id (this is system generated and consistent through all versions)
	 * @alias Titanium.App.guid
	 * @property {String}
	 */
	guid: '',
	/**
	 * Get the the application's globally unique id (this is system generated and consistent through all versions)
	 * @alias Titanium.App.getGuid
	 * @return {String}
	 */
	getGuid: function () { return guid; },
	/**
	 * Set the the application's globally unique id (this is system generated and consistent through all versions)
	 * @param {String} value New value to set.
	 * @alias Titanium.App.setGuid
	 */
	setGuid: function () { },
	/**
	 * the application's app id as specified in Titanium Developer
	 * @alias Titanium.App.id
	 * @property {String}
	 */
	id: '',
	/**
	 * Get the the application's app id as specified in Titanium Developer
	 * @alias Titanium.App.getId
	 * @return {String}
	 */
	getId: function () { return id; },
	/**
	 * Set the the application's app id as specified in Titanium Developer
	 * @param {String} value New value to set.
	 * @alias Titanium.App.setId
	 */
	setId: function () { },
	/**
	 * property for controlling whether the phone screen will be locked on idle time. Can be set to true to disable the timer
	 * @alias Titanium.App.idleTimerDisabled
	 * @property {Boolean}
	 */
	idleTimerDisabled: false,
	/**
	 * Get the property for controlling whether the phone screen will be locked on idle time. Can be set to true to disable the timer
	 * @alias Titanium.App.getIdleTimerDisabled
	 * @return {Boolean}
	 */
	getIdleTimerDisabled: function () { return idleTimerDisabled; },
	/**
	 * Set the property for controlling whether the phone screen will be locked on idle time. Can be set to true to disable the timer
	 * @param {Boolean} value New value to set.
	 * @alias Titanium.App.setIdleTimerDisabled
	 */
	setIdleTimerDisabled: function () { },
	/**
	 * the application's name
	 * @alias Titanium.App.name
	 * @property {String}
	 */
	name: '',
	/**
	 * Get the the application's name
	 * @alias Titanium.App.getName
	 * @return {String}
	 */
	getName: function () { return name; },
	/**
	 * Set the the application's name
	 * @param {String} value New value to set.
	 * @alias Titanium.App.setName
	 */
	setName: function () { },
	/**
	 * a boolean to indicate whether proximity detection is enabled
	 * @alias Titanium.App.proximityDetection
	 * @property {Boolean}
	 */
	proximityDetection: false,
	/**
	 * Get the a boolean to indicate whether proximity detection is enabled
	 * @alias Titanium.App.getProximityDetection
	 * @return {Boolean}
	 */
	getProximityDetection: function () { return proximityDetection; },
	/**
	 * Set the a boolean to indicate whether proximity detection is enabled
	 * @param {Boolean} value New value to set.
	 * @alias Titanium.App.setProximityDetection
	 */
	setProximityDetection: function () { },
	/**
	 * the state of the device's proximity detector
	 * @alias Titanium.App.proximityState
	 * @property {Integer}
	 */
	proximityState: 0,
	/**
	 * Get the the state of the device's proximity detector
	 * @alias Titanium.App.getProximityState
	 * @return {Integer}
	 */
	getProximityState: function () { return proximityState; },
	/**
	 * Set the the state of the device's proximity detector
	 * @param {Integer} value New value to set.
	 * @alias Titanium.App.setProximityState
	 */
	setProximityState: function () { },
	/**
	 * the application's publisher
	 * @alias Titanium.App.publisher
	 * @property {String}
	 */
	publisher: '',
	/**
	 * Get the the application's publisher
	 * @alias Titanium.App.getPublisher
	 * @return {String}
	 */
	getPublisher: function () { return publisher; },
	/**
	 * Set the the application's publisher
	 * @param {String} value New value to set.
	 * @alias Titanium.App.setPublisher
	 */
	setPublisher: function () { },
	/**
	 * the application url
	 * @alias Titanium.App.url
	 * @property {String}
	 */
	url: '',
	/**
	 * Get the the application url
	 * @alias Titanium.App.getUrl
	 * @return {String}
	 */
	getUrl: function () { return url; },
	/**
	 * Set the the application url
	 * @param {String} value New value to set.
	 * @alias Titanium.App.setUrl
	 */
	setUrl: function () { },
	/**
	 * the application's version
	 * @alias Titanium.App.version
	 * @property {String}
	 */
	version: '',
	/**
	 * Get the the application's version
	 * @alias Titanium.App.getVersion
	 * @return {String}
	 */
	getVersion: function () { return version; },
	/**
	 * Set the the application's version
	 * @param {String} value New value to set.
	 * @alias Titanium.App.setVersion
	 */
	setVersion: function () { },
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium.App.addEventListener
	 */
	addEventListener: function (name,callback) { },
	/**
	 * fire a cross-context application event.  listeners in any Javascript context can receive these events if they have added themselves as a listener with the event name.  NOTE: you can only pass JSON serializable data in the data payload of the event object since the data must be transportable between contexts.
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @param {String} name the event name
	 * @param {Object} [data] optional data payload for the event. NOTE: you can only pass JSON serializable data since the data must be transportable between contexts.
	 * @alias Titanium.App.fireEvent
	 */
	fireEvent: function (name,event,name2,data) { },
	/**
	 * return the arguments passed to the application on startup as a dictionary
	 * @alias Titanium.App.getArguments
	 * @return {Object}
	 */
	getArguments: function () { return {}; },
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium.App.removeEventListener
	 */
	removeEventListener: function (name,callback) { },
};

/**
 * The App Properties module is used for storing application related property/value pairs which persist beyond application sessions.
 * @since 0.5
 */
Titanium.App.Properties = {
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium.App.Properties.addEventListener
	 */
	addEventListener: function (name,callback) { },
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium.App.Properties.fireEvent
	 */
	fireEvent: function (name,event) { },
	/**
	 * return a boolean value
	 * @param {String} property return a boolean value for property
	 * @param {Boolean} [def] optional default value if property is not found
	 * @alias Titanium.App.Properties.getBool
	 * @return {Boolean}
	 */
	getBool: function (property,def) { return false; },
	/**
	 * return a double value
	 * @param {String} property return a double value for property
	 * @param {Double} [def] optional default value if property is not found
	 * @alias Titanium.App.Properties.getDouble
	 * @return {Double}
	 */
	getDouble: function (property,def) { return 0.0; },
	/**
	 * return an integer value
	 * @param {String} property return a integer value for property
	 * @param {Integer} [def] optional default value if property is not found
	 * @alias Titanium.App.Properties.getInt
	 * @return {Integer}
	 */
	getInt: function (property,def) { return 0; },
	/**
	 * return a value as an array
	 * @param {String} property return an array value for property
	 * @param {Array} [def] optional default value if property is not found
	 * @alias Titanium.App.Properties.getList
	 * @return {Array}
	 */
	getList: function (property,def) { return []; },
	/**
	 * return a string value
	 * @param {String} property return a string value for property
	 * @param {String} [def] optional default value if property is not found
	 * @alias Titanium.App.Properties.getString
	 * @return {String}
	 */
	getString: function (property,def) { return ''; },
	/**
	 * returns true if the property exists
	 * @param {String} property property name to check
	 * @alias Titanium.App.Properties.hasProperty
	 * @return {Boolean}
	 */
	hasProperty: function (property) { return false; },
	/**
	 * return an array of property propertys
	 * @alias Titanium.App.Properties.listProperties
	 * @return {Array}
	 */
	listProperties: function () { return []; },
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium.App.Properties.removeEventListener
	 */
	removeEventListener: function (name,callback) { },
	/**
	 * remove an existing property
	 * @param {String} property property name to remove
	 * @alias Titanium.App.Properties.removeProperty
	 */
	removeProperty: function (property) { },
	/**
	 * set a property as a boolean value
	 * @param {String} property property name
	 * @param {Boolean} value value
	 * @alias Titanium.App.Properties.setBool
	 */
	setBool: function (property,value) { },
	/**
	 * set a property as a double value
	 * @param {String} property property name
	 * @param {Double} value value
	 * @alias Titanium.App.Properties.setDouble
	 */
	setDouble: function (property,value) { },
	/**
	 * set a property as an integer value
	 * @param {String} property property name
	 * @param {Integer} value value
	 * @param {String} property property name
	 * @param {Integer} value value
	 * @alias Titanium.App.Properties.setInt
	 */
	setInt: function (property,value) { },
	/**
	 * set a property as an array value
	 * @param {String} property property name
	 * @param {Array} value value
	 * @alias Titanium.App.Properties.setList
	 */
	setList: function (property,value) { },
	/**
	 * set a property as a string value
	 * @param {String} property property name
	 * @param {String} value value
	 * @alias Titanium.App.Properties.setString
	 */
	setString: function (property,value) { },
};

/**
 * The top level Contacts module.  The Contacts module is used accessing the device Address Book.
 * @since 0.8
 */
Titanium.Contacts = {
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium.Contacts.addEventListener
	 */
	addEventListener: function (name,callback) { },
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium.Contacts.fireEvent
	 */
	fireEvent: function (name,event) { },
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium.Contacts.removeEventListener
	 */
	removeEventListener: function (name,callback) { },
};

/**
 * The top level Database module.  The Database module is used for creating and accessing the in-application Database.
 * @since 0.1
 */
Titanium.Database = {
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium.Database.addEventListener
	 */
	addEventListener: function (name,callback) { },
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium.Database.fireEvent
	 */
	fireEvent: function (name,event) { },
	/**
	 * install a database from the application Resources folder (at build time) and return a reference to the opened database. it is safe to call this method multiple times since this method will only install once if it doesn't already exist on the device.
	 * @param {String} path the path (relative to the main application Resources folder at build time) to the db to install. this file must be in the SQLite 3 file format.
	 * @param {String} name the name of the database
	 * @alias Titanium.Database.install
	 * @return {Object}
	 */
	install: function (path,name) { return {}; },
	/**
	 * open a database. if it doesn't yet exist, create it.
	 * @param {String} name the name of the database
	 * @alias Titanium.Database.open
	 * @return {Object}
	 */
	open: function (name) { return {}; },
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium.Database.removeEventListener
	 */
	removeEventListener: function (name,callback) { },
};

/**
 * The Database instance returned by Titanium.Database.open or Titanium.Database.install.
 * @since 0.1
 */
Titanium.Database.DB = {
	/**
	 * the last row identifier by the last INSERT query
	 * @alias Titanium.Database.DB.lastInsertRowId
	 * @property {Integer}
	 */
	lastInsertRowId: 0,
	/**
	 * Get the the last row identifier by the last INSERT query
	 * @alias Titanium.Database.DB.getLastInsertRowId
	 * @return {Integer}
	 */
	getLastInsertRowId: function () { return lastInsertRowId; },
	/**
	 * Set the the last row identifier by the last INSERT query
	 * @param {Integer} value New value to set.
	 * @alias Titanium.Database.DB.setLastInsertRowId
	 */
	setLastInsertRowId: function () { },
	/**
	 * the name of the database
	 * @alias Titanium.Database.DB.name
	 * @property {String}
	 */
	name: '',
	/**
	 * Get the the name of the database
	 * @alias Titanium.Database.DB.getName
	 * @return {String}
	 */
	getName: function () { return name; },
	/**
	 * Set the the name of the database
	 * @param {String} value New value to set.
	 * @alias Titanium.Database.DB.setName
	 */
	setName: function () { },
	/**
	 * the number of rows affected by the last query
	 * @alias Titanium.Database.DB.rowsAffected
	 * @property {Integer}
	 */
	rowsAffected: 0,
	/**
	 * Get the the number of rows affected by the last query
	 * @alias Titanium.Database.DB.getRowsAffected
	 * @return {Integer}
	 */
	getRowsAffected: function () { return rowsAffected; },
	/**
	 * Set the the number of rows affected by the last query
	 * @param {Integer} value New value to set.
	 * @alias Titanium.Database.DB.setRowsAffected
	 */
	setRowsAffected: function () { },
	/**
	 * close the database and release resources from memory. once closed, this instance is no longer valid and must no longer be used.
	 * @alias Titanium.Database.DB.close
	 */
	close: function () { },
	/**
	 * execute a SQL statement against the database and returns a ResultSet
	 * @param {String} sql the SQL to execute
	 * @param {Array,...} vararg one or more optional variable arguments passed to this function or an array of objects to be replaced in the query using <tt>?</tt> substitution.
	 * @alias Titanium.Database.DB.execute
	 * @return {Object}
	 */
	execute: function (sql,vararg) { return {}; },
	/**
	 * remove the database files for this instance from disk. WARNING: this is a destructive operation and cannot be reversed. All data in the database will be lost upon calling this function. Use with caution.
	 * @alias Titanium.Database.DB.remove
	 */
	remove: function () { },
};

/**
 * The ResultSet instance returned by invoking a database SQL execute.
 * @since 0.1
 */
Titanium.Database.ResultSet = {
	/**
	 * the number of rows in the result set
	 * @alias Titanium.Database.ResultSet.rowCount
	 * @property {Integer}
	 */
	rowCount: 0,
	/**
	 * Get the the number of rows in the result set
	 * @alias Titanium.Database.ResultSet.getRowCount
	 * @return {Integer}
	 */
	getRowCount: function () { return rowCount; },
	/**
	 * Set the the number of rows in the result set
	 * @param {Integer} value New value to set.
	 * @alias Titanium.Database.ResultSet.setRowCount
	 */
	setRowCount: function () { },
	/**
	 * returns true if the current row is still valid
	 * @alias Titanium.Database.ResultSet.validRow
	 * @property {Boolean}
	 */
	validRow: false,
	/**
	 * Get the returns true if the current row is still valid
	 * @alias Titanium.Database.ResultSet.getValidRow
	 * @return {Boolean}
	 */
	getValidRow: function () { return validRow; },
	/**
	 * Set the returns true if the current row is still valid
	 * @param {Boolean} value New value to set.
	 * @alias Titanium.Database.ResultSet.setValidRow
	 */
	setValidRow: function () { },
	/**
	 * close the result set and release resources. once closed, this result set must no longer be used
	 * @alias Titanium.Database.ResultSet.close
	 */
	close: function () { },
	/**
	 * retrieve a row value by field index
	 * @param {Integer} index column index (which is zero based)
	 * @alias Titanium.Database.ResultSet.field
	 * @return {Object}
	 */
	field: function (index) { return {}; },
	/**
	 * retrieve a row value by field name
	 * @param {String} name column name from SQL query
	 * @alias Titanium.Database.ResultSet.fieldByName
	 * @return {Object}
	 */
	fieldByName: function (name) { return {}; },
	/**
	 * return the number of columns in the result set
	 * @alias Titanium.Database.ResultSet.fieldCount
	 * @return {Integer}
	 */
	fieldCount: function () { return 0; },
	/**
	 * return the field name for field index
	 * @param {Integer} index field name column index (which is zero based)
	 * @alias Titanium.Database.ResultSet.fieldName
	 * @return {String}
	 */
	fieldName: function (index) { return ''; },
	/**
	 * return true if the row is a valid row
	 * @alias Titanium.Database.ResultSet.isValidRow
	 * @return {Boolean}
	 */
	isValidRow: function () { return false; },
	/**
	 * iterate to the next row in the result set. returns false if no more results are available
	 * @alias Titanium.Database.ResultSet.next
	 * @return {Boolean}
	 */
	next: function () { return false; },
};

/**
 * The top level Facebook module.  The Facebook module is used for connecting your application with 
Facebook through Facebook Connect.
 * @since 0.8
 */
Titanium.Facebook = {
	/**
	 * return true if the user has logged in
	 * @alias Titanium.Facebook.loggedIn
	 * @property {Boolean}
	 */
	loggedIn: false,
	/**
	 * Get the return true if the user has logged in
	 * @alias Titanium.Facebook.getLoggedIn
	 * @return {Boolean}
	 */
	getLoggedIn: function () { return loggedIn; },
	/**
	 * Set the return true if the user has logged in
	 * @param {Boolean} value New value to set.
	 * @alias Titanium.Facebook.setLoggedIn
	 */
	setLoggedIn: function () { },
	/**
	 * return a dictionary of permissions with the keys being the name of the permission and the value being a boolean of true if granted, false if not granted
	 * @alias Titanium.Facebook.permissions
	 * @property {Object}
	 */
	permissions: {},
	/**
	 * Get the return a dictionary of permissions with the keys being the name of the permission and the value being a boolean of true if granted, false if not granted
	 * @alias Titanium.Facebook.getPermissions
	 * @return {Object}
	 */
	getPermissions: function () { return permissions; },
	/**
	 * Set the return a dictionary of permissions with the keys being the name of the permission and the value being a boolean of true if granted, false if not granted
	 * @param {Object} value New value to set.
	 * @alias Titanium.Facebook.setPermissions
	 */
	setPermissions: function () { },
	/**
	 * return the special properties of the session
	 * @alias Titanium.Facebook.session
	 * @property {Object}
	 */
	session: {},
	/**
	 * Get the return the special properties of the session
	 * @alias Titanium.Facebook.getSession
	 * @return {Object}
	 */
	getSession: function () { return session; },
	/**
	 * Set the return the special properties of the session
	 * @param {Object} value New value to set.
	 * @alias Titanium.Facebook.setSession
	 */
	setSession: function () { },
	/**
	 * the unique user id returned from Facebook. returns 0 if not logged in
	 * @alias Titanium.Facebook.userId
	 * @property {long}
	 */
	userId: {},
	/**
	 * Get the the unique user id returned from Facebook. returns 0 if not logged in
	 * @alias Titanium.Facebook.getUserId
	 * @return {long}
	 */
	getUserId: function () { return userId; },
	/**
	 * Set the the unique user id returned from Facebook. returns 0 if not logged in
	 * @param {long} value New value to set.
	 * @alias Titanium.Facebook.setUserId
	 */
	setUserId: function () { },
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium.Facebook.addEventListener
	 */
	addEventListener: function (name,callback) { },
	/**
	 * create and return an instance of Titanium.Facebook.LoginButton
	 * @param {Object} params the parameters for the request. the following keys are valid: <tt>apikey</tt> (the application API key), <tt>secret</tt> (the application API secret or null if using a session proxy), <tt>sessionProxy</tt> (the URL to the application session proxy), <tt>style</tt> (the button style - which is either <tt>normal</tt> or <tt>wide</tt>).
	 * @param {Object} [parameters] (optional) a dictionary object properties defined in <a href="Titanium.Facebook.LoginButton.html">Titanium.Facebook.LoginButton</a>

	 * @alias Titanium.Facebook.createLoginButton
	 * @return {Titanium_Facebook_LoginButton}
	 */
	createLoginButton: function (params,parameters) { return new Titanium_Facebook_LoginButton(); },
	/**
	 * execute a FB API execute request
	 * @param {String} method method to execute
	 * @param {Object} params JSON serializable object or null (if no parameters) to send with the request
	 * @param {Function} callback the callback function to execute upon receiving a response. the result object will contain a <tt>success</tt> boolean to indicate the result.  if <tt>success</tt> is false, the <tt>error</tt> property will give the error message.  the <tt>data</tt> property will contain the result if successfully executed.
	 * @param {Object} data the data payload for the request. Must either null, a string or a Blob object.
	 * @alias Titanium.Facebook.execute
	 */
	execute: function (method,params,callback,data) { },
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium.Facebook.fireEvent
	 */
	fireEvent: function (name,event) { },
	/**
	 * checks the existing permission and returns true if the user has granted the requested permission
	 * @param {String} permission the permission to check
	 * @alias Titanium.Facebook.hasPermission
	 * @return {Boolean}
	 */
	hasPermission: function (permission) { return false; },
	/**
	 * return true if the user has logged in
	 * @alias Titanium.Facebook.isLoggedIn
	 */
	isLoggedIn: function () { },
	/**
	 * execute a stream request to FB
	 * @param {String} title the title of the stream post
	 * @param {Object} data the data to include in the post. Must be JSON serializable or null.
	 * @param {String} target the target user id to publish the stream or null if the logged in users account
	 * @param {Function} callback the callback function to execute upon receiving a response. the result object will contain a <tt>success</tt> boolean to indicate the result.  if <tt>success</tt> is false, the <tt>error</tt> property will give the error message.  the <tt>data</tt> property will contain the result if successfully executed. the <tt>cancel</tt> property will be set to true if the user cancelled the dialog.
	 * @alias Titanium.Facebook.publishStream
	 */
	publishStream: function (title,data,target,callback) { },
	/**
	 * execute a FQL query against the FB API
	 * @param {String} fql the FQL query to execute
	 * @param {Function} callback the callback to execute with results once the query is completed. the result object will contain a <tt>success</tt> boolean to indicate the result.  if <tt>success</tt> is false, the <tt>error</tt> property will give the error message.  the <tt>data</tt> property will contain the result if successfully executed.
	 * @alias Titanium.Facebook.query
	 */
	query: function (fql,callback) { },
	/**
	 * remove a previously added event listener
	 * @param {String} name name of the event
	 * @param {Function} callback callback function passed in addEventListener
	 * @alias Titanium.Facebook.removeEventListener
	 */
	removeEventListener: function (name,callback) { },
	/**
	 * request a special permission from the user
	 * @param {String} permission name of the permission
	 * @param {Function} callback the callback function to execute upon receiving a response. the result object will contain a <tt>success</tt> boolean to indicate the result.  if <tt>success</tt> is false, the <tt>error</tt> property will give the error message.  the <tt>data</tt> property will contain the result if successfully executed. the <tt>cancel</tt> property will be set to true if the user cancelled the dialog.
	 * @alias Titanium.Facebook.requestPermission
	 */
	requestPermission: function (permission,callback) { },
};

/**
 * The Login Button created by Titanium.Facebook.createLoginButton.
 * @since 0.8
 */
Titanium.Facebook.LoginButton = {
	/**
	 * a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium.Facebook.LoginButton.anchorPoint
	 * @property {Object}
	 */
	anchorPoint: {},
	/**
	 * Get the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @alias Titanium.Facebook.LoginButton.getAnchorPoint
	 * @return {Object}
	 */
	getAnchorPoint: function () { return anchorPoint; },
	/**
	 * Set the a dictionary with properties x and y to indicate the anchor point value. anchor specifies the position by which animation should occur. center is 0.5, 0.5
	 * @param {Object} value New value to set.
	 * @alias Titanium.Facebook.LoginButton.setAnchorPoint
	 */
	setAnchorPoint: function () { },
	/**
	 * read-only object with x and y properties of where the view is during animation
	 * @alias Titanium.Facebook.LoginButton.animatedCenterPoint
	 * @property {Object}
	 */
	animatedCenterPoint: {},
	/**
	 * Get the read-only object with x and y properties of where the view is during animation
	 * @alias Titanium.Facebook.LoginButton.getAnimatedCenterPoint
	 * @return {Object}
	 */
	getAnimatedCenterPoint: function () { return animatedCenterPoint; },
	/**
	 * Set the read-only object with x and y properties of where the view is during animation
	 * @param {Object} value New value to set.
	 * @alias Titanium.Facebook.LoginButton.setAnimatedCenterPoint
	 */
	setAnimatedCenterPoint: function () { },
	/**
	 * the background color of the view
	 * @alias Titanium.Facebook.LoginButton.backgroundColor
	 * @property {String}
	 */
	backgroundColor: '',
	/**
	 * Get the the background color of the view
	 * @alias Titanium.Facebook.LoginButton.getBackgroundColor
	 * @return {String}
	 */
	getBackgroundColor: function () { return backgroundColor; },
	/**
	 * Set the the background color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium.Facebook.LoginButton.setBackgroundColor
	 */
	setBackgroundColor: function () { },
	/**
	 * a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium.Facebook.LoginButton.backgroundGradient
	 * @property {Object}
	 */
	backgroundGradient: {},
	/**
	 * Get the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @alias Titanium.Facebook.LoginButton.getBackgroundGradient
	 * @return {Object}
	 */
	getBackgroundGradient: function () { return backgroundGradient; },
	/**
	 * Set the a background gradient for the view with the properties: type,startPoint,endPoint,startRadius,endRadius,backfillStart,backfillEnd,colors.
	 * @param {Object} value New value to set.
	 * @alias Titanium.Facebook.LoginButton.setBackgroundGradient
	 */
	setBackgroundGradient: function () { },
	/**
	 * the background image url of the view
	 * @alias Titanium.Facebook.LoginButton.backgroundImage
	 * @property {String}
	 */
	backgroundImage: '',
	/**
	 * Get the the background image url of the view
	 * @alias Titanium.Facebook.LoginButton.getBackgroundImage
	 * @return {String}
	 */
	getBackgroundImage: function () { return backgroundImage; },
	/**
	 * Set the the background image url of the view
	 * @param {String} value New value to set.
	 * @alias Titanium.Facebook.LoginButton.setBackgroundImage
	 */
	setBackgroundImage: function () { },
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium.Facebook.LoginButton.backgroundLeftCap
	 * @property {Float}
	 */
	backgroundLeftCap: 0.0,
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @alias Titanium.Facebook.LoginButton.getBackgroundLeftCap
	 * @return {Float}
	 */
	getBackgroundLeftCap: function () { return backgroundLeftCap; },
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the left end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The right end cap is therefore computed by adding the size of the left end cap and the middle portion together and then subtracting that value from the width of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium.Facebook.LoginButton.setBackgroundLeftCap
	 */
	setBackgroundLeftCap: function () { },
	/**
	 * End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium.Facebook.LoginButton.backgroundTopCap
	 * @property {Float}
	 */
	backgroundTopCap: 0.0,
	/**
	 * Get the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @alias Titanium.Facebook.LoginButton.getBackgroundTopCap
	 * @return {Float}
	 */
	getBackgroundTopCap: function () { return backgroundTopCap; },
	/**
	 * Set the End caps specify the portion of an image that should not be resized when an image is stretched. This technique is used to implement buttons and other resizable image-based interface elements. When a button with end caps is resized, the resizing occurs only in the middle of the button, in the region between the end caps. The end caps themselves keep their original size and appearance. This property specifies the size of the top end cap. The middle (stretchable) portion is assumed to be 1 pixel wide. The bottom end cap is therefore computed by adding the size of the top end cap and the middle portion together and then subtracting that value from the height of the image
	 * @param {Float} value New value to set.
	 * @alias Titanium.Facebook.LoginButton.setBackgroundTopCap
	 */
	setBackgroundTopCap: function () { },
	/**
	 * the border color of the view
	 * @alias Titanium.Facebook.LoginButton.borderColor
	 * @property {String}
	 */
	borderColor: '',
	/**
	 * Get the the border color of the view
	 * @alias Titanium.Facebook.LoginButton.getBorderColor
	 * @return {String}
	 */
	getBorderColor: function () { return borderColor; },
	/**
	 * Set the the border color of the view
	 * @param {String} value New value to set.
	 * @alias Titanium.Facebook.LoginButton.setBorderColor
	 */
	setBorderColor: function () { },
	/**
	 * the border radius of the view
	 * @alias Titanium.Facebook.LoginButton.borderRadius
	 * @property {Float}
	 */
	borderRadius: 0.0,
	/**
	 * Get the the border radius of the view
	 * @alias Titanium.Facebook.LoginButton.getBorderRadius
	 * @return {Float}
	 */
	getBorderRadius: function () { return borderRadius; },
	/**
	 * Set the the border radius of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium.Facebook.LoginButton.setBorderRadius
	 */
	setBorderRadius: function () { },
	/**
	 * the border width of the view
	 * @alias Titanium.Facebook.LoginButton.borderWidth
	 * @property {Float}
	 */
	borderWidth: 0.0,
	/**
	 * Get the the border width of the view
	 * @alias Titanium.Facebook.LoginButton.getBorderWidth
	 * @return {Float}
	 */
	getBorderWidth: function () { return borderWidth; },
	/**
	 * Set the the border width of the view
	 * @param {Float} value New value to set.
	 * @alias Titanium.Facebook.LoginButton.setBorderWidth
	 */
	setBorderWidth: function () { },
	/**
	 * property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium.Facebook.LoginButton.bottom
	 * @property {Float,String}
	 */
	bottom: 0.0,
	/**
	 * Get the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium.Facebook.LoginButton.getBottom
	 * @return {Float,String}
	 */
	getBottom: function () { return bottom; },
	/**
	 * Set the property for the view bottom position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium.Facebook.LoginButton.setBottom
	 */
	setBottom: function () { },
	/**
	 * a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium.Facebook.LoginButton.center
	 * @property {Object}
	 */
	center: {},
	/**
	 * Get the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @alias Titanium.Facebook.LoginButton.getCenter
	 * @return {Object}
	 */
	getCenter: function () { return center; },
	/**
	 * Set the a dictionary with properties x and y to indicate the center of the views position relative to the parent view
	 * @param {Object} value New value to set.
	 * @alias Titanium.Facebook.LoginButton.setCenter
	 */
	setCenter: function () { },
	/**
	 * property for the view height. can be either float value or a string of the width.
	 * @alias Titanium.Facebook.LoginButton.height
	 * @property {Float,String}
	 */
	height: 0.0,
	/**
	 * Get the property for the view height. can be either float value or a string of the width.
	 * @alias Titanium.Facebook.LoginButton.getHeight
	 * @return {Float,String}
	 */
	getHeight: function () { return height; },
	/**
	 * Set the property for the view height. can be either float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium.Facebook.LoginButton.setHeight
	 */
	setHeight: function () { },
	/**
	 * property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium.Facebook.LoginButton.left
	 * @property {Float,String}
	 */
	left: 0.0,
	/**
	 * Get the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium.Facebook.LoginButton.getLeft
	 * @return {Float,String}
	 */
	getLeft: function () { return left; },
	/**
	 * Set the property for the view left position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium.Facebook.LoginButton.setLeft
	 */
	setLeft: function () { },
	/**
	 * the opacity from 0.0-1.0
	 * @alias Titanium.Facebook.LoginButton.opacity
	 * @property {Float}
	 */
	opacity: 0.0,
	/**
	 * Get the the opacity from 0.0-1.0
	 * @alias Titanium.Facebook.LoginButton.getOpacity
	 * @return {Float}
	 */
	getOpacity: function () { return opacity; },
	/**
	 * Set the the opacity from 0.0-1.0
	 * @param {Float} value New value to set.
	 * @alias Titanium.Facebook.LoginButton.setOpacity
	 */
	setOpacity: function () { },
	/**
	 * property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium.Facebook.LoginButton.right
	 * @property {Float,String}
	 */
	right: 0.0,
	/**
	 * Get the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium.Facebook.LoginButton.getRight
	 * @return {Float,String}
	 */
	getRight: function () { return right; },
	/**
	 * Set the property for the view right position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium.Facebook.LoginButton.setRight
	 */
	setRight: function () { },
	/**
	 * the size of the view as a dictionary of width and height properties
	 * @alias Titanium.Facebook.LoginButton.size
	 * @property {Object}
	 */
	size: {},
	/**
	 * Get the the size of the view as a dictionary of width and height properties
	 * @alias Titanium.Facebook.LoginButton.getSize
	 * @return {Object}
	 */
	getSize: function () { return size; },
	/**
	 * Set the the size of the view as a dictionary of width and height properties
	 * @param {Object} value New value to set.
	 * @alias Titanium.Facebook.LoginButton.setSize
	 */
	setSize: function () { },
	/**
	 * property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium.Facebook.LoginButton.top
	 * @property {Float,String}
	 */
	top: 0.0,
	/**
	 * Get the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @alias Titanium.Facebook.LoginButton.getTop
	 * @return {Float,String}
	 */
	getTop: function () { return top; },
	/**
	 * Set the property for the view top position. this position is relative to the views parent. can be either a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium.Facebook.LoginButton.setTop
	 */
	setTop: function () { },
	/**
	 * a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium.Facebook.LoginButton.touchEnabled
	 * @property {Boolean}
	 */
	touchEnabled: false,
	/**
	 * Get the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @alias Titanium.Facebook.LoginButton.getTouchEnabled
	 * @return {Boolean}
	 */
	getTouchEnabled: function () { return touchEnabled; },
	/**
	 * Set the a boolean indicating if the view should receive touch events (true, default) or forward them to peers (false)
	 * @param {Boolean} value New value to set.
	 * @alias Titanium.Facebook.LoginButton.setTouchEnabled
	 */
	setTouchEnabled: function () { },
	/**
	 * the transformation matrix to apply to the view
	 * @alias Titanium.Facebook.LoginButton.transform
	 * @property {Object}
	 */
	transform: {},
	/**
	 * Get the the transformation matrix to apply to the view
	 * @alias Titanium.Facebook.LoginButton.getTransform
	 * @return {Object}
	 */
	getTransform: function () { return transform; },
	/**
	 * Set the the transformation matrix to apply to the view
	 * @param {Object} value New value to set.
	 * @alias Titanium.Facebook.LoginButton.setTransform
	 */
	setTransform: function () { },
	/**
	 * a boolean of the visibility of the view
	 * @alias Titanium.Facebook.LoginButton.visible
	 * @property {Boolean}
	 */
	visible: false,
	/**
	 * Get the a boolean of the visibility of the view
	 * @alias Titanium.Facebook.LoginButton.getVisible
	 * @return {Boolean}
	 */
	getVisible: function () { return visible; },
	/**
	 * Set the a boolean of the visibility of the view
	 * @param {Boolean} value New value to set.
	 * @alias Titanium.Facebook.LoginButton.setVisible
	 */
	setVisible: function () { },
	/**
	 * property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium.Facebook.LoginButton.width
	 * @property {Float,String}
	 */
	width: 0.0,
	/**
	 * Get the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @alias Titanium.Facebook.LoginButton.getWidth
	 * @return {Float,String}
	 */
	getWidth: function () { return width; },
	/**
	 * Set the property for the view width. can either be `auto`, a float value or a string of the width.
	 * @param {Float,String} value New value to set.
	 * @alias Titanium.Facebook.LoginButton.setWidth
	 */
	setWidth: function () { },
	/**
	 * the z index position relative to other sibling views
	 * @alias Titanium.Facebook.LoginButton.zIndex
	 * @property {Integer}
	 */
	zIndex: 0,
	/**
	 * Get the the z index position relative to other sibling views
	 * @alias Titanium.Facebook.LoginButton.getZIndex
	 * @return {Integer}
	 */
	getZIndex: function () { return zIndex; },
	/**
	 * Set the the z index position relative to other sibling views
	 * @param {Integer} value New value to set.
	 * @alias Titanium.Facebook.LoginButton.setZIndex
	 */
	setZIndex: function () { },
	/**
	 * add a child to the view hierarchy
	 * @param {Object} view the view to add to this views hiearchy
	 * @alias Titanium.Facebook.LoginButton.add
	 */
	add: function (view) { },
	/**
	 * add an event listener for the instance to receive view triggered events
	 * @param {String} name name of the event
	 * @param {Function} callback callback function to invoke when the event is fired
	 * @alias Titanium.Facebook.LoginButton.addEventListener
	 */
	addEventListener: function (name,callback) { },
	/**
	 * animate the view
	 * @param {Object} obj either a dictionary of animation properties or an Animation object
	 * @param {Function} callback function to be invoked upon completion of the animation
	 * @alias Titanium.Facebook.LoginButton.animate
	 */
	animate: function (obj,callback) { },
	/**
	 * fire a synthesized event to the views listener
	 * @param {String} name name of the event
	 * @param {Object} event event object
	 * @alias Titanium.Facebook.LoginButton.fireEvent
	 */
	fireEvent: function (name,event) { },
	/**
	 * hide the view
	 * @alias Titanium.Facebook.LoginButton.hide
	 */
	hide: function () { },
	/**
	 * remove a previously add view from the view hiearchy
	 * @param {Object} view the view to remove from this views hiearchy
	 * @alias Titanium.Facebook.LoginButton