/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core;

import com.aptana.core.IFilter;
import com.aptana.core.IMap;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.IndexRequestJob;
import com.aptana.index.core.IndexUtil;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexContainerJob
extends IndexRequestJob {
    public IndexContainerJob(URI containerURI) {
        super(containerURI);
    }

    public IndexContainerJob(String name, URI containerURI) {
        super(name, containerURI);
    }

    public IStatus run(IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        if (sub.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        Index index = this.getIndex();
        if (index == null) {
            IdeLog.logError((Plugin)IndexPlugin.getDefault(), (String)MessageFormat.format("Index is null for container: {0}", this.getContainerURI()));
            return Status.CANCEL_STATUS;
        }
        try {
            Set<IFileStore> files = IndexUtil.getAllFiles(this.getContainerFileStore(), (IProgressMonitor)sub.newChild(100));
            if (sub.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            files.addAll(this.getContributedFiles(this.getContainerURI()));
            Set<String> documents = index.queryDocumentNames(null);
            sub.worked(25);
            if (sub.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.removeDeletedFiles(index, documents, files, (IProgressMonitor)sub.newChild(75));
            if (CollectionsUtil.isEmpty(files)) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            long timestamp = 0L;
            if (!CollectionsUtil.isEmpty(documents)) {
                timestamp = index.getIndexFile().lastModified();
            }
            if (sub.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            try {
                files = this.filterFilesByTimestamp(timestamp, files);
                sub.worked(50);
                if (!CollectionsUtil.isEmpty(files)) {
                    this.indexFileStores(index, files, (IProgressMonitor)sub.newChild(750));
                }
            }
            catch (CoreException e) {
                IStatus iStatus = e.getStatus();
                return iStatus;
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
            }
        }
        finally {
            try {
                index.save();
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (String)"An error occurred while saving an index", (Throwable)e);
            }
            sub.done();
        }
        return Status.OK_STATUS;
    }

    protected IFileStore getContainerFileStore() throws CoreException {
        return EFS.getStore((URI)this.getContainerURI());
    }

    private void removeDeletedFiles(Index index, Set<String> documents, Set<IFileStore> files, IProgressMonitor monitor) {
        if (CollectionsUtil.isEmpty(documents)) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(files.size() + documents.size()));
        List fileStoreURIs = CollectionsUtil.map(files, (IMap)new IMap<IFileStore, String>(){

            public String map(IFileStore item) {
                return item.toURI().toString();
            }
        });
        HashSet uris = new HashSet(fileStoreURIs);
        sub.worked(files.size());
        for (String docName : documents) {
            if (!uris.contains(docName)) {
                index.remove(URI.create(docName));
            }
            sub.worked(1);
        }
        sub.done();
    }

    protected Set<IFileStore> filterFilesByTimestamp(final long indexLastModified, Set<IFileStore> files) {
        HashSet<IFileStore> filtered = new HashSet<IFileStore>(files.size());
        CollectionsUtil.filter(files, filtered, (IFilter)new IFilter<IFileStore>(){

            public boolean include(IFileStore item) {
                return item.fetchInfo().getLastModified() >= indexLastModified;
            }
        });
        return filtered;
    }
}

