/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.index.core.FileStoreBuildContext;
import com.aptana.index.core.IFileStoreIndexingParticipant;
import com.aptana.index.core.IIndexFileContributor;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.Messages;
import com.aptana.index.core.filter.IIndexFilterParticipant;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class IndexRequestJob
extends Job {
    public static final String INDEX_REQUEST_JOB_FAMILY = "index-request-job-family";
    private URI containerURI;

    protected IndexRequestJob(String name, URI containerURI) {
        super(name);
        this.containerURI = containerURI;
        this.setRule(IndexManager.MUTEX_RULE);
        this.setPriority(40);
    }

    protected IndexRequestJob(URI containerURI) {
        this(MessageFormat.format(Messages.IndexRequestJob_Name, containerURI.toString()), containerURI);
    }

    public boolean belongsTo(Object family) {
        return family == INDEX_REQUEST_JOB_FAMILY;
    }

    protected Set<IFileStore> filterFileStores(Set<IFileStore> fileStores) {
        IndexManager manager;
        if (!CollectionsUtil.isEmpty(fileStores) && (manager = this.getIndexManager()) != null) {
            for (IIndexFilterParticipant filterParticipant : manager.getFilterParticipants()) {
                fileStores = filterParticipant.applyFilter(fileStores);
            }
        }
        return fileStores;
    }

    protected URI getContainerURI() {
        return this.containerURI;
    }

    protected Set<IFileStore> getContributedFiles(URI container) {
        HashSet<IFileStore> result = new HashSet<IFileStore>();
        IndexManager manager = this.getIndexManager();
        if (manager != null) {
            for (IIndexFileContributor contributor : manager.getFileContributors()) {
                Set<IFileStore> files = contributor.getFiles(container);
                if (CollectionsUtil.isEmpty(files)) continue;
                result.addAll(files);
            }
        }
        return result;
    }

    protected Index getIndex() {
        IndexManager manager = this.getIndexManager();
        return manager != null ? manager.getIndex(this.getContainerURI()) : null;
    }

    protected IndexManager getIndexManager() {
        IndexPlugin plugin = IndexPlugin.getDefault();
        return plugin != null ? plugin.getIndexManager() : null;
    }

    protected void indexFileStores(Index index, Set<IFileStore> fileStores, IProgressMonitor monitor) throws CoreException {
        if (index == null) {
            return;
        }
        if (CollectionsUtil.isEmpty(fileStores = this.filterFileStores(fileStores))) {
            return;
        }
        int remaining = fileStores.size();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(remaining * 11));
        try {
            for (IFileStore file : fileStores) {
                if (sub.isCanceled()) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                index.remove(file.toURI());
                sub.worked(1);
                List<IFileStoreIndexingParticipant> indexers = this.getIndexParticipants(file);
                if (!CollectionsUtil.isEmpty(indexers)) {
                    int work = 10 / indexers.size();
                    FileStoreBuildContext context = new FileStoreBuildContext(file);
                    for (IFileStoreIndexingParticipant indexer : indexers) {
                        if (sub.isCanceled()) {
                            throw new CoreException(Status.CANCEL_STATUS);
                        }
                        try {
                            indexer.index(context, index, (IProgressMonitor)sub.newChild(work));
                        }
                        catch (CoreException e) {
                            IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
                        }
                    }
                }
                sub.setWorkRemaining(--remaining * 11);
            }
        }
        finally {
            sub.done();
        }
    }

    protected List<IFileStoreIndexingParticipant> getIndexParticipants(IFileStore file) {
        IndexManager indexManager = this.getIndexManager();
        if (indexManager != null) {
            return indexManager.getIndexParticipants(file.getName());
        }
        return Collections.emptyList();
    }
}

