/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core;

import com.aptana.core.logging.IdeLog;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.IndexRequestJob;
import com.aptana.index.core.Messages;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveIndexOfFilesOfProjectJob
extends IndexRequestJob {
    private final IProject project;
    private final Set<IFile> files;

    public RemoveIndexOfFilesOfProjectJob(IProject project, Set<IFile> files) {
        super(MessageFormat.format(Messages.RemoveIndexOfFilesOfProjectJob_Name, project.getName()), project.getLocationURI());
        this.project = project;
        this.files = files;
    }

    public IStatus run(IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)this.files.size());
        if (sub.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (!this.project.isAccessible() || this.getContainerURI() == null) {
            return Status.CANCEL_STATUS;
        }
        Index index = this.getIndex();
        if (index == null) {
            IdeLog.logError((Plugin)IndexPlugin.getDefault(), (String)MessageFormat.format("Index is null for container: {0}", this.getContainerURI()));
            return Status.CANCEL_STATUS;
        }
        try {
            for (IFile file : this.files) {
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                index.remove(file.getLocationURI());
                sub.worked(1);
            }
        }
        finally {
            try {
                index.save();
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
            }
            sub.done();
        }
        return Status.OK_STATUS;
    }
}

