/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.markdown;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.NonRuleBasedDamagerRepairer;
import com.aptana.editor.common.text.rules.SubPartitionScanner;
import com.aptana.editor.common.text.rules.TagRule;
import com.aptana.editor.common.text.rules.ThemeingDamagerRepairer;
import com.aptana.editor.html.HTMLTagScanner;
import com.aptana.editor.markdown.text.rules.BlockLevelRule;
import com.aptana.editor.markdown.text.rules.HardWrapLineRule;
import com.aptana.editor.markdown.text.rules.MarkdownHeadingScanner;
import com.aptana.editor.markdown.text.rules.MarkdownScanner;
import com.aptana.editor.markdown.text.rules.UnnumberedListScanner;
import java.util.ArrayList;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.source.ISourceViewer;

public class MarkdownSourceConfiguration
implements IPartitioningConfiguration,
ISourceViewerConfiguration {
    public static final String PREFIX = "__md_";
    public static final String DEFAULT = "__md__dftl_partition_content_type";
    public static final String HEADING = "__md_heading";
    public static final String HEADING_1 = "__md_heading.1";
    public static final String HEADING_2 = "__md_heading.2";
    public static final String UNNUMBERED_LIST = "__md_unnumbered_list";
    public static final String NUMBERED_LIST = "__md_numbered_list";
    public static final String SEPARATOR = "__md_separator";
    public static final String QUOTE = "__md_quote";
    public static final String BLOCK = "__md_block";
    public static final String HTML_TAG = "__md_html";
    public static final String[] CONTENT_TYPES = new String[]{"__md__dftl_partition_content_type", "__md_heading", "__md_heading.1", "__md_heading.2", "__md_unnumbered_list", "__md_numbered_list", "__md_separator", "__md_quote", "__md_block", "__md_html"};
    private static final String[][] TOP_CONTENT_TYPES = new String[][]{{"com.aptana.contenttype.markdown"}};
    private static MarkdownSourceConfiguration instance;

    private MarkdownSourceConfiguration() {
    }

    public static MarkdownSourceConfiguration getDefault() {
        if (instance == null) {
            instance = new MarkdownSourceConfiguration();
            IContentTypeTranslator c = CommonEditorPlugin.getDefault().getContentTypeTranslator();
            c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.markdown"}), new QualifiedContentType(new String[]{"text.html.markdown"}));
            c.addTranslation(new QualifiedContentType(new String[]{DEFAULT}), new QualifiedContentType(new String[]{"meta.paragraph.markdown"}));
            c.addTranslation(new QualifiedContentType(new String[]{HEADING}), new QualifiedContentType(new String[]{"markup.heading.markdown"}));
            c.addTranslation(new QualifiedContentType(new String[]{HEADING_1}), new QualifiedContentType(new String[]{"markup.heading.1.markdown"}));
            c.addTranslation(new QualifiedContentType(new String[]{HEADING_2}), new QualifiedContentType(new String[]{"markup.heading.2.markdown"}));
            c.addTranslation(new QualifiedContentType(new String[]{UNNUMBERED_LIST}), new QualifiedContentType(new String[]{"markup.list.unnumbered.markdown"}));
            c.addTranslation(new QualifiedContentType(new String[]{NUMBERED_LIST}), new QualifiedContentType(new String[]{"markup.list.numbered.markdown"}));
            c.addTranslation(new QualifiedContentType(new String[]{SEPARATOR}), new QualifiedContentType(new String[]{"meta.separator.markdown"}));
            c.addTranslation(new QualifiedContentType(new String[]{QUOTE}), new QualifiedContentType(new String[]{"meta.block-level.markdown", "markup.quote.markdown"}));
            c.addTranslation(new QualifiedContentType(new String[]{BLOCK}), new QualifiedContentType(new String[]{"markup.raw.block.markdown"}));
            c.addTranslation(new QualifiedContentType(new String[]{HTML_TAG}), new QualifiedContentType(new String[]{"meta.disable-markdown", "meta.tag.block.any.html"}));
        }
        return instance;
    }

    public String[] getContentTypes() {
        return CONTENT_TYPES;
    }

    public String[][] getTopContentTypes() {
        return TOP_CONTENT_TYPES;
    }

    public IPredicateRule[] getPartitioningRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add((Object)new HardWrapLineRule(">", null, MarkdownSourceConfiguration.getToken(QUOTE)));
        rules.add((Object)new HardWrapLineRule(" >", null, MarkdownSourceConfiguration.getToken(QUOTE)));
        rules.add((Object)new HardWrapLineRule("  >", null, MarkdownSourceConfiguration.getToken(QUOTE)));
        rules.add((Object)new HardWrapLineRule("   >", null, MarkdownSourceConfiguration.getToken(QUOTE)));
        char[] separatorChars = new char[]{'*', '-', '_'};
        int sepCharIdx = 0;
        while (sepCharIdx < separatorChars.length) {
            int initialSpaces = 0;
            while (initialSpaces <= 3) {
                int laterSpaces = 0;
                while (laterSpaces <= 2) {
                    rules.add(this.createSeparatorRule(separatorChars[sepCharIdx], initialSpaces, laterSpaces));
                    ++laterSpaces;
                }
                ++initialSpaces;
            }
            ++sepCharIdx;
        }
        TagRule tagRule = new TagRule("/", MarkdownSourceConfiguration.getToken(HTML_TAG));
        tagRule.setColumnConstraint(0);
        rules.add(tagRule);
        tagRule = new TagRule(MarkdownSourceConfiguration.getToken(HTML_TAG));
        tagRule.setColumnConstraint(0);
        rules.add(tagRule);
        int i = 0;
        while (i <= 3) {
            rules.add(this.createListRule(i, '*'));
            rules.add(this.createListRule(i, '+'));
            rules.add(this.createListRule(i, '-'));
            ++i;
        }
        i = 1;
        while (i <= 100) {
            rules.add((Object)new BlockLevelRule(String.valueOf(i) + ".", null, MarkdownSourceConfiguration.getToken(NUMBERED_LIST)));
            ++i;
        }
        rules.add(this.createSetexHeadingRule('-', 2));
        rules.add(this.createSetexHeadingRule('=', 1));
        i = 6;
        while (i > 0) {
            rules.add(this.createATXHeadingRule(i));
            --i;
        }
        EndOfLineRule rule = new EndOfLineRule("    ", MarkdownSourceConfiguration.getToken(BLOCK));
        rule.setColumnConstraint(0);
        rules.add(rule);
        rule = new EndOfLineRule("\t", MarkdownSourceConfiguration.getToken(BLOCK));
        rule.setColumnConstraint(0);
        rules.add(rule);
        return rules.toArray(new IPredicateRule[rules.size()]);
    }

    private IPredicateRule createSeparatorRule(char c, int leadingSpaces, int spaces2) {
        String string = "";
        int x = 0;
        while (x < leadingSpaces) {
            string = String.valueOf(string) + " ";
            ++x;
        }
        string = String.valueOf(string) + c;
        x = 0;
        while (x < spaces2) {
            string = String.valueOf(string) + " ";
            ++x;
        }
        string = String.valueOf(string) + c;
        x = 0;
        while (x < spaces2) {
            string = String.valueOf(string) + " ";
            ++x;
        }
        string = String.valueOf(string) + c;
        SingleLineRule rule = new SingleLineRule(string, "", MarkdownSourceConfiguration.getToken(SEPARATOR), '\u0000', true);
        rule.setColumnConstraint(0);
        return rule;
    }

    private IPredicateRule createListRule(int leadingSpaces, char c) {
        String str = "";
        int i = 0;
        while (i < leadingSpaces) {
            str = String.valueOf(str) + " ";
            ++i;
        }
        str = String.valueOf(str) + c + " ";
        return new BlockLevelRule(str, null, MarkdownSourceConfiguration.getToken(UNNUMBERED_LIST));
    }

    private SingleLineRule createSetexHeadingRule(char c, int level) {
        String token = HEADING_1;
        if (level == 2) {
            token = HEADING_2;
        }
        SingleLineRule rule = new SingleLineRule("" + c, null, MarkdownSourceConfiguration.getToken(token));
        rule.setColumnConstraint(0);
        return rule;
    }

    private SingleLineRule createATXHeadingRule(int hashes) {
        String header = "";
        int i = 0;
        while (i < hashes) {
            header = String.valueOf(header) + "#";
            ++i;
        }
        SingleLineRule rule = new SingleLineRule(header, header, MarkdownSourceConfiguration.getToken(HEADING), '\u0000', true);
        rule.setColumnConstraint(0);
        return rule;
    }

    public ISubPartitionScanner createSubPartitionScanner() {
        return new SubPartitionScanner(this.getPartitioningRules(), CONTENT_TYPES, MarkdownSourceConfiguration.getToken(DEFAULT));
    }

    public String getDocumentContentType(String contentType) {
        if (contentType.startsWith(PREFIX)) {
            return "com.aptana.contenttype.markdown";
        }
        return null;
    }

    public void setupPresentationReconciler(PresentationReconciler reconciler, ISourceViewer sourceViewer) {
        ThemeingDamagerRepairer dr = new ThemeingDamagerRepairer(this.getMarkdownScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)dr, DEFAULT);
        reconciler.setRepairer((IPresentationRepairer)dr, DEFAULT);
        reconciler.setDamager((IPresentationDamager)dr, NUMBERED_LIST);
        reconciler.setRepairer((IPresentationRepairer)dr, NUMBERED_LIST);
        dr = new ThemeingDamagerRepairer((ITokenScanner)new UnnumberedListScanner());
        reconciler.setDamager((IPresentationDamager)dr, UNNUMBERED_LIST);
        reconciler.setRepairer((IPresentationRepairer)dr, UNNUMBERED_LIST);
        dr = new ThemeingDamagerRepairer(this.getPreProcessorScanner());
        reconciler.setDamager((IPresentationDamager)dr, HEADING);
        reconciler.setRepairer((IPresentationRepairer)dr, HEADING);
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(MarkdownSourceConfiguration.getToken("meta.separator.markdown"));
        reconciler.setDamager((IPresentationDamager)ndr, SEPARATOR);
        reconciler.setRepairer((IPresentationRepairer)ndr, SEPARATOR);
        ndr = new NonRuleBasedDamagerRepairer(MarkdownSourceConfiguration.getToken("markup.raw.block.markdown"));
        reconciler.setDamager((IPresentationDamager)ndr, BLOCK);
        reconciler.setRepairer((IPresentationRepairer)ndr, BLOCK);
        dr = new ThemeingDamagerRepairer((ITokenScanner)new HTMLTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, HTML_TAG);
        reconciler.setRepairer((IPresentationRepairer)dr, HTML_TAG);
    }

    public IContentAssistProcessor getContentAssistProcessor(AbstractThemeableEditor editor, String contentType) {
        return new CommonContentAssistProcessor(editor);
    }

    private ITokenScanner getPreProcessorScanner() {
        return new MarkdownHeadingScanner();
    }

    private ITokenScanner getMarkdownScanner() {
        return new MarkdownScanner();
    }

    private static IToken getToken(String tokenName) {
        return CommonUtil.getToken((String)tokenName);
    }
}

