/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.samples.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.FileUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.ResourceUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.samples.ISampleListener;
import com.aptana.samples.ISamplesManager;
import com.aptana.samples.SamplesPlugin;
import com.aptana.samples.internal.Messages;
import com.aptana.samples.model.IProjectSample;
import com.aptana.samples.model.SampleCategory;
import com.aptana.samples.model.SamplesReference;
import com.aptana.scripting.model.AbstractElement;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.ElementVisibilityListener;
import com.aptana.scripting.model.LoadCycleListener;
import com.aptana.scripting.model.ProjectSampleElement;
import com.aptana.scripting.model.filters.IModelFilter;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamplesManager
implements ISamplesManager {
    private static final String EXTENSION_POINT = "samplespath";
    private static final String ELEMENT_CATEGORY = "category";
    private static final String ELEMENT_SAMPLESINFO = "samplesinfo";
    private static final String ELEMENT_LOCAL = "local";
    private static final String ELEMENT_REMOTE = "remote";
    private static final String ELEMENT_NATURE = "nature";
    private static final String ELEMENT_INCLUDE = "include";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_LOCATION = "location";
    private static final String ATTR_INFOFILE = "infoFile";
    private static final String ATTR_ICON = "icon";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_CATEGORY = "category";
    private static final String BUNDLE_SCRIPT = "bundle.rb";
    private static final String SAMPLES_SCRIPT = "project_samples.rb";
    private Map<String, SampleCategory> categories;
    private Map<String, List<IProjectSample>> sampleRefsByCategory;
    private Map<String, IProjectSample> samplesById;
    private Map<String, List<IProjectSample>> bundleSamplesByCategory;
    private Map<String, IProjectSample> bundleSamplesById;
    private List<ProjectSampleElement> bundleSamples;
    private List<ISampleListener> sampleListeners;
    private LoadCycleListener loadCycleListener = new LoadCycleListener(){

        public void scriptLoaded(File script) {
            if (this.needLoadSamples(script)) {
                SamplesManager.this.loadBundleSampleElements();
            }
        }

        public void scriptReloaded(File script) {
            if (this.needLoadSamples(script)) {
                SamplesManager.this.loadBundleSampleElements();
            }
        }

        public void scriptUnloaded(File script) {
            if (this.needLoadSamples(script)) {
                SamplesManager.this.loadBundleSampleElements();
            }
        }

        private boolean needLoadSamples(File script) {
            String scriptPath = script.toString();
            return scriptPath.endsWith(SamplesManager.BUNDLE_SCRIPT) || scriptPath.endsWith(SamplesManager.SAMPLES_SCRIPT);
        }
    };
    private ElementVisibilityListener elementListener = new ElementVisibilityListener(){

        public void elementBecameHidden(AbstractElement element) {
            if (element instanceof ProjectSampleElement) {
                SamplesManager.this.loadBundleSampleElements();
            }
        }

        public void elementBecameVisible(AbstractElement element) {
            if (element instanceof ProjectSampleElement) {
                SamplesManager.this.addSample((ProjectSampleElement)element);
            }
        }
    };

    public SamplesManager() {
        this.categories = new HashMap<String, SampleCategory>();
        this.sampleRefsByCategory = new HashMap<String, List<IProjectSample>>();
        this.samplesById = new HashMap<String, IProjectSample>();
        this.bundleSamplesByCategory = new HashMap<String, List<IProjectSample>>();
        this.bundleSamplesById = Collections.synchronizedMap(new HashMap());
        this.bundleSamples = new ArrayList<ProjectSampleElement>();
        this.sampleListeners = new ArrayList<ISampleListener>();
        this.readExtensionRegistry();
        this.loadBundleSampleElements();
        BundleManager.getInstance().addLoadCycleListener(this.loadCycleListener);
        BundleManager.getInstance().addElementVisibilityListener(this.elementListener);
    }

    @Override
    public List<SampleCategory> getCategories() {
        ArrayList<SampleCategory> sampleCategories = new ArrayList<SampleCategory>();
        sampleCategories.addAll(this.categories.values());
        Collections.sort(sampleCategories);
        return sampleCategories;
    }

    @Override
    public List<IProjectSample> getSamplesForCategory(String categoryId) {
        ArrayList<IProjectSample> result = new ArrayList<IProjectSample>();
        List<IProjectSample> samples = this.sampleRefsByCategory.get(categoryId);
        if (samples != null) {
            result.addAll(samples);
        }
        if ((samples = this.bundleSamplesByCategory.get(categoryId)) != null) {
            result.addAll(samples);
        }
        return result;
    }

    @Override
    public IProjectSample getSample(String id) {
        IProjectSample sample = this.samplesById.get(id);
        return sample == null ? this.bundleSamplesById.get(id) : sample;
    }

    @Override
    public void addSampleListener(ISampleListener listener) {
        if (!this.sampleListeners.contains(listener)) {
            this.sampleListeners.add(listener);
        }
    }

    @Override
    public void removeSampleListener(ISampleListener listener) {
        this.sampleListeners.remove(listener);
    }

    @Override
    public void addSample(IProjectSample sample) {
        String id;
        IProjectSample existingSample;
        String categoryId = sample.getCategory().getId();
        List<IProjectSample> samples = this.bundleSamplesByCategory.get(categoryId);
        if (samples == null) {
            samples = new ArrayList<IProjectSample>();
            this.bundleSamplesByCategory.put(categoryId, samples);
        }
        if ((existingSample = this.bundleSamplesById.get(id = sample.getId())) != null) {
            samples.remove(existingSample);
        }
        samples.add(sample);
        this.bundleSamplesById.put(id, sample);
        this.fireSampleAdded(sample);
    }

    @Override
    public SampleCategory getCategory(String categoryId) {
        return this.categories.get(categoryId);
    }

    @Override
    public void addSample(ProjectSampleElement sampleElement) {
        String categoryId = sampleElement.getCategory();
        SampleCategory category = this.categories.get(categoryId);
        if (category != null) {
            boolean isRemote;
            String id = sampleElement.getId();
            String name = sampleElement.getDisplayName();
            String location = sampleElement.getLocation();
            IPath destination = sampleElement.getDestinationPath();
            File locationFile = new File(location);
            boolean bl = isRemote = !FileUtil.isZipFile((File)locationFile) && !new File(location).exists();
            if (!isRemote && FileUtil.isZipFile((File)locationFile)) {
                location = new File(sampleElement.getDirectory(), location).getAbsolutePath();
            }
            String description = sampleElement.getDescription();
            Map iconUrls = sampleElement.getIconUrls();
            SamplesReference sample = new SamplesReference(category, id, name, location, isRemote, description, iconUrls, destination, null);
            sample.setNatures(sampleElement.getNatures());
            this.addSample(sample);
        } else {
            IdeLog.logWarning((Plugin)SamplesPlugin.getDefault(), (String)MessageFormat.format("No category ''{0}'' exists", categoryId), (String)"com.aptana.samples/debug/manager");
        }
    }

    private void readExtensionRegistry() {
        EclipseUtil.processConfigurationElements((String)"com.aptana.samples", (String)EXTENSION_POINT, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

            public void processElement(IConfigurationElement element) {
                SamplesManager.this.readElement(element);
            }

            public Set<String> getSupportElementNames() {
                return CollectionsUtil.newInOrderSet((Object[])new String[]{"category", SamplesManager.ELEMENT_SAMPLESINFO});
            }
        });
    }

    private void readElement(IConfigurationElement element) {
        String elementName = element.getName();
        if ("category".equals(elementName)) {
            String id = element.getAttribute(ATTR_ID);
            if (StringUtil.isEmpty((String)id)) {
                return;
            }
            String name = element.getAttribute(ATTR_NAME);
            if (StringUtil.isEmpty((String)name)) {
                return;
            }
            SampleCategory category = new SampleCategory(id, name, element);
            this.categories.put(id, category);
        } else if (ELEMENT_SAMPLESINFO.equals(elementName)) {
            List<IProjectSample> samples;
            String path = null;
            boolean isRemote = false;
            Bundle bundle = Platform.getBundle((String)element.getNamespaceIdentifier());
            IConfigurationElement[] localPaths = element.getChildren(ELEMENT_LOCAL);
            if (localPaths.length > 0) {
                String location = localPaths[0].getAttribute(ATTR_LOCATION);
                URL url = bundle.getEntry(location);
                path = ResourceUtil.resourcePathToString((URL)url);
            } else {
                IConfigurationElement[] remotePaths = element.getChildren(ELEMENT_REMOTE);
                if (remotePaths.length > 0) {
                    path = remotePaths[0].getAttribute(ATTR_LOCATION);
                    isRemote = true;
                }
            }
            if (path == null) {
                return;
            }
            String id = element.getAttribute(ATTR_ID);
            if (StringUtil.isEmpty((String)id)) {
                return;
            }
            String name = element.getAttribute(ATTR_NAME);
            if (StringUtil.isEmpty((String)name)) {
                return;
            }
            String categoryId = element.getAttribute("category");
            SampleCategory category = this.categories.get(categoryId);
            if (category == null && (category = this.categories.get(categoryId = "default")) == null) {
                category = new SampleCategory(categoryId, Messages.SamplesManager_DefaultCategory_Name, element);
            }
            if ((samples = this.sampleRefsByCategory.get(categoryId)) == null) {
                samples = new ArrayList<IProjectSample>();
                this.sampleRefsByCategory.put(categoryId, samples);
            }
            String description = element.getAttribute(ATTR_DESCRIPTION);
            URL iconUrl = null;
            String iconPath = element.getAttribute(ATTR_ICON);
            if (!StringUtil.isEmpty((String)iconPath)) {
                URL url = bundle.getEntry(iconPath);
                try {
                    iconUrl = FileLocator.toFileURL((URL)url);
                }
                catch (Exception e) {
                    IdeLog.logWarning((Plugin)SamplesPlugin.getDefault(), (String)MessageFormat.format("Unable to retrieve the icon at {0} for sample {1}", iconPath, name), (Throwable)e);
                }
            }
            HashMap<String, URL> iconUrls = new HashMap<String, URL>();
            iconUrls.put("default", iconUrl);
            SamplesReference samplesRef = new SamplesReference(category, id, name, path, isRemote, description, iconUrls, null, element);
            samples.add(samplesRef);
            this.samplesById.put(id, samplesRef);
            String infoFile = element.getAttribute(ATTR_INFOFILE);
            if (!StringUtil.isEmpty((String)infoFile)) {
                URL url = bundle.getEntry(infoFile);
                samplesRef.setInfoFile(ResourceUtil.resourcePathToString((URL)url));
            }
            IConfigurationElement[] natures = element.getChildren(ELEMENT_NATURE);
            ArrayList<String> natureIds = new ArrayList<String>();
            IConfigurationElement[] iConfigurationElementArray = natures;
            int n = natures.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement nature = iConfigurationElementArray[n2];
                String natureId = nature.getAttribute(ATTR_ID);
                if (!StringUtil.isEmpty((String)natureId)) {
                    natureIds.add(natureId);
                }
                ++n2;
            }
            samplesRef.setNatures(natureIds.toArray(new String[natureIds.size()]));
            IConfigurationElement[] includes = element.getChildren(ELEMENT_INCLUDE);
            ArrayList<String> includePaths = new ArrayList<String>();
            IConfigurationElement[] iConfigurationElementArray2 = includes;
            int n3 = includes.length;
            int n4 = 0;
            while (n4 < n3) {
                URL url;
                IConfigurationElement include = iConfigurationElementArray2[n4];
                String includePath = include.getAttribute(ATTR_PATH);
                if (!StringUtil.isEmpty((String)includePath) && (path = ResourceUtil.resourcePathToString((URL)(url = bundle.getEntry(includePath)))) != null) {
                    includePaths.add(path);
                }
                ++n4;
            }
            samplesRef.setIncludePaths(includePaths.toArray(new String[includePaths.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBundleSampleElements() {
        ArrayList<IProjectSample> samples;
        List elements = BundleManager.getInstance().getProjectSamples(new IModelFilter(){

            public boolean include(AbstractElement element) {
                return element instanceof ProjectSampleElement;
            }
        });
        Collections.sort(elements);
        if (elements.isEmpty() || this.bundleSamples.equals(elements)) {
            return;
        }
        this.bundleSamples = elements;
        Collection<IProjectSample> bundles = this.bundleSamplesById.values();
        Map<String, IProjectSample> map = this.bundleSamplesById;
        synchronized (map) {
            samples = new ArrayList<IProjectSample>(bundles);
            this.bundleSamplesByCategory.clear();
            this.bundleSamplesById.clear();
        }
        for (IProjectSample sample : samples) {
            this.fireSampleRemoved(sample);
        }
        for (ProjectSampleElement element : this.bundleSamples) {
            this.addSample(element);
        }
    }

    private void fireSampleAdded(IProjectSample sample) {
        if (IdeLog.isInfoEnabled((Plugin)SamplesPlugin.getDefault(), (String)"com.aptana.samples/debug/manager")) {
            IdeLog.logInfo((Plugin)SamplesPlugin.getDefault(), (String)MessageFormat.format("Added sample: id = {0}; name = {1}", sample.getId(), sample.getName()), (String)"com.aptana.samples/debug/manager");
        }
        for (ISampleListener listener : this.sampleListeners) {
            listener.sampleAdded(sample);
        }
    }

    private void fireSampleRemoved(IProjectSample sample) {
        if (IdeLog.isInfoEnabled((Plugin)SamplesPlugin.getDefault(), (String)"com.aptana.samples/debug/manager")) {
            IdeLog.logInfo((Plugin)SamplesPlugin.getDefault(), (String)MessageFormat.format("Removed sample: id = {0}; name = {1}", sample.getId(), sample.getName()), (String)"com.aptana.samples/debug/manager");
        }
        for (ISampleListener listener : this.sampleListeners) {
            listener.sampleRemoved(sample);
        }
    }
}

