/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.samples.model;

import com.aptana.core.util.EclipseUtil;
import com.aptana.samples.handlers.ISampleProjectHandler;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleCategory
implements Comparable<SampleCategory> {
    private static final String ATTR_ICON = "icon";
    private static final String ATTR_PROJECT_HANDLER = "projectHandler";
    private final String id;
    private final String name;
    private final IConfigurationElement configElement;
    private ISampleProjectHandler projectHandler;

    public SampleCategory(String id, String name, IConfigurationElement configElement) {
        this.id = id;
        this.name = name;
        this.configElement = configElement;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public URL getIconFile() {
        return EclipseUtil.getResourceURL((IConfigurationElement)this.configElement, (String)ATTR_ICON);
    }

    public ISampleProjectHandler getProjectHandler() {
        if (this.projectHandler == null) {
            try {
                this.projectHandler = (ISampleProjectHandler)this.configElement.createExecutableExtension(ATTR_PROJECT_HANDLER);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return this.projectHandler;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SampleCategory)) {
            return false;
        }
        SampleCategory category = (SampleCategory)obj;
        return this.id.equals(category.id) && this.name.equals(category.name);
    }

    public int hashCode() {
        return this.id.hashCode() * 31 + this.name.hashCode();
    }

    @Override
    public int compareTo(SampleCategory o) {
        return this.name.compareTo(o.name);
    }
}

