/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.samples.model;

import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.FileUtil;
import com.aptana.core.util.IOUtil;
import com.aptana.core.util.ZipUtil;
import com.aptana.projects.ProjectData;
import com.aptana.samples.handlers.ISamplePreviewHandler;
import com.aptana.samples.handlers.ISampleProjectHandler;
import com.aptana.samples.model.IProjectSample;
import com.aptana.samples.model.SampleCategory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamplesReference
implements IProjectSample {
    public static final String DEFAULT_ICON_KEY = "default";
    private static final String ATTR_PROJECT_HANDLER = "projectHandler";
    private static final String ATTR_PREVIEW_HANDLER = "previewHandler";
    private final SampleCategory category;
    private final String location;
    private final IConfigurationElement configElement;
    private final String id;
    private final String name;
    private String description;
    private boolean isRemote;
    private String infoFile;
    private ISampleProjectHandler projectHandler;
    private ISamplePreviewHandler previewHandler;
    private String[] natures;
    private String[] includePaths;
    private final Map<String, URL> iconUrls;
    private IPath destination;

    public SamplesReference(SampleCategory category, String id, String name, String location, boolean isRemote, String description, Map<String, URL> iconUrls, IPath destination, IConfigurationElement element) {
        this.category = category;
        this.id = id;
        this.name = name;
        this.location = location;
        this.isRemote = isRemote;
        this.description = description;
        this.destination = destination;
        this.iconUrls = new HashMap<String, URL>(iconUrls);
        this.configElement = element;
        this.natures = ArrayUtil.NO_STRINGS;
        this.includePaths = ArrayUtil.NO_STRINGS;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public SampleCategory getCategory() {
        return this.category;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public IPath getDestination() {
        return this.destination;
    }

    public String getInfoFile() {
        return this.infoFile;
    }

    @Override
    public ISampleProjectHandler getProjectHandler() {
        if (this.projectHandler == null && this.configElement != null) {
            try {
                this.projectHandler = (ISampleProjectHandler)this.configElement.createExecutableExtension(ATTR_PROJECT_HANDLER);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return this.projectHandler == null ? this.category.getProjectHandler() : this.projectHandler;
    }

    public ISamplePreviewHandler getPreviewHandler() {
        if (this.previewHandler == null && this.configElement != null) {
            try {
                this.previewHandler = (ISamplePreviewHandler)this.configElement.createExecutableExtension(ATTR_PREVIEW_HANDLER);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return this.previewHandler;
    }

    @Override
    public String[] getNatures() {
        return this.natures;
    }

    public String[] getIncludePaths() {
        return this.includePaths;
    }

    public URL getIconUrl() {
        return this.getIconUrl(DEFAULT_ICON_KEY);
    }

    public URL getIconUrl(String iconSize) {
        return this.iconUrls.get(iconSize);
    }

    @Override
    public boolean isRemote() {
        return this.isRemote;
    }

    public void setInfoFile(String infoFile) {
        this.infoFile = infoFile;
    }

    public void setNatures(String[] natures) {
        this.natures = natures;
    }

    public void setIncludePaths(String[] paths) {
        this.includePaths = paths;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SamplesReference)) {
            return false;
        }
        SamplesReference otherSample = (SamplesReference)obj;
        return this.id.equals(otherSample.id) && this.name.equals(otherSample.name) && this.location.equals(otherSample.location);
    }

    public int hashCode() {
        int hash = this.id.hashCode();
        hash = hash * 31 + this.name.hashCode();
        hash = hash * 31 + this.location.hashCode();
        return hash;
    }

    @Override
    public IStatus createNewProject(IProject project, ProjectData projectData, IProgressMonitor monitor) throws CoreException {
        this.copyFiles(project);
        return Status.OK_STATUS;
    }

    protected void copyFiles(IProject project) throws CoreException {
        File locationFile = new File(this.location);
        IPath projectLocation = project.getLocation();
        IPath destinationDir = this.destination == null ? projectLocation : projectLocation.append(this.destination);
        try {
            if (FileUtil.isZipFile((File)locationFile)) {
                ZipUtil.extract((File)locationFile, (IPath)destinationDir, (ZipUtil.Conflict)ZipUtil.Conflict.PROMPT, (IProgressMonitor)new NullProgressMonitor());
            } else {
                IOUtil.copyDirectory((File)locationFile, (File)destinationDir.toFile());
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.samples", e.getMessage(), (Throwable)e));
        }
    }
}

