/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.core;

import com.aptana.js.core.inferencing.IAliasResolver;
import com.aptana.js.core.node.INodeJS;
import com.aptana.js.core.node.INodeJSService;
import com.aptana.js.core.node.INodePackageManager;
import com.aptana.js.internal.core.index.JSMetadataLoader;
import com.aptana.js.internal.core.inferencing.AliasResolverFactory;
import com.aptana.js.internal.core.node.NodeJSService;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class JSCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.aptana.js.core";
    private static JSCorePlugin PLUGIN;
    private INodeJSService fNodeService;
    private ServiceTracker proxyTracker;
    private AliasResolverFactory fAliasResolverFactory;

    public static JSCorePlugin getDefault() {
        return PLUGIN;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        PLUGIN = this;
        new JSMetadataLoader().schedule();
        this.proxyTracker = new ServiceTracker(this.getBundle().getBundleContext(), IProxyService.class.getName(), null);
        this.proxyTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.proxyTracker != null) {
                this.proxyTracker.close();
            }
        }
        finally {
            this.proxyTracker = null;
            this.fNodeService = null;
            this.fAliasResolverFactory = null;
            PLUGIN = null;
            super.stop(context);
        }
    }

    public synchronized INodeJSService getNodeJSService() {
        if (this.fNodeService == null) {
            this.fNodeService = new NodeJSService();
        }
        return this.fNodeService;
    }

    public synchronized IAliasResolver getAliasResolver() {
        if (this.fAliasResolverFactory == null) {
            this.fAliasResolverFactory = new AliasResolverFactory();
        }
        return this.fAliasResolverFactory;
    }

    public INodePackageManager getNodePackageManager() {
        INodeJS nodeJS = this.getNodeJSService().getValidExecutable();
        if (nodeJS == null) {
            return null;
        }
        return nodeJS.getNPM();
    }

    public IProxyService getProxyService() {
        return (IProxyService)this.proxyTracker.getService();
    }
}

