/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.core.index;

import com.aptana.buildpath.core.BuildPathManager;
import com.aptana.buildpath.core.IBuildPathEntry;
import com.aptana.core.IFilter;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.QueryResult;
import com.aptana.js.core.inferencing.JSTypeUtil;
import com.aptana.js.core.model.EventElement;
import com.aptana.js.core.model.FunctionElement;
import com.aptana.js.core.model.PropertyElement;
import com.aptana.js.core.model.TypeElement;
import com.aptana.js.internal.core.index.JSIndexReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSIndexQueryHelper {
    private static final String DOT_EXPORTS = ".exports";
    private JSIndexReader _reader;
    private List<Index> indices;
    private IProject project;

    public static Index getJSCoreIndex() {
        IndexManager manager = JSIndexQueryHelper.getIndexManager();
        return manager == null ? null : manager.getIndex(URI.create("metadata:/js"));
    }

    protected static IndexManager getIndexManager() {
        IndexPlugin plugin = IndexPlugin.getDefault();
        return plugin == null ? null : plugin.getIndexManager();
    }

    public JSIndexQueryHelper(Index index) {
        this(index, JSIndexQueryHelper.getJSCoreIndex());
    }

    public JSIndexQueryHelper(IProject project) {
        this(JSIndexQueryHelper.getIndices(project));
        this.project = project;
    }

    private JSIndexQueryHelper(Index ... indices) {
        this.indices = CollectionsUtil.filter(Arrays.asList(indices), (IFilter)new IFilter<Index>(){

            public boolean include(Index item) {
                return item != null;
            }
        });
        this._reader = new JSIndexReader();
    }

    private static Index[] getIndices(IProject project) {
        ArrayList<Index> indices = new ArrayList<Index>();
        if (project != null) {
            Set entries = JSIndexQueryHelper.getBuildPathManager().getBuildPaths(project);
            for (IBuildPathEntry entry : entries) {
                Index index = JSIndexQueryHelper.getIndexManager().getIndex(entry.getPath());
                indices.add(index);
            }
            Index index = JSIndexQueryHelper.getIndexManager().getIndex(project.getLocationURI());
            indices.add(index);
        }
        indices.add(JSIndexQueryHelper.getJSCoreIndex());
        indices.trimToSize();
        return indices.toArray(new Index[indices.size()]);
    }

    protected static BuildPathManager getBuildPathManager() {
        return BuildPathManager.getInstance();
    }

    public Collection<PropertyElement> getGlobals(String fileName, String memberName) {
        String globalTypeName = JSTypeUtil.getGlobalType(this.project, fileName);
        List types = CollectionsUtil.newList((Object[])new String[]{"Global"});
        if ("Window".equals(globalTypeName)) {
            types.add(0, "Window");
        }
        ArrayList<PropertyElement> properties = new ArrayList<PropertyElement>();
        for (String type : types) {
            for (Index index : this.indices) {
                properties.addAll(this._reader.getFunctions(index, type, memberName));
                properties.addAll(this._reader.getProperties(index, type, memberName));
            }
        }
        return properties;
    }

    public Collection<PropertyElement> getGlobals(String fileName) {
        String globalType = JSTypeUtil.getGlobalType(this.project, fileName);
        List types = CollectionsUtil.newList((Object[])new String[]{"Global"});
        if ("Window".equals(globalType)) {
            types.add(0, "Window");
        }
        return this.getTypeMembers(types);
    }

    public Collection<TypeElement> getTypes(String typeName, boolean includeMembers) {
        ArrayList<TypeElement> types = new ArrayList<TypeElement>();
        for (Index index : this.indices) {
            types.addAll(this._reader.getType(index, typeName, includeMembers));
        }
        types.trimToSize();
        return types;
    }

    public List<String> getTypeAncestorNames(String typeName) {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        LinkedList<String> queue = new LinkedList<String>();
        queue.offer(typeName);
        while (!queue.isEmpty()) {
            String name = (String)queue.poll();
            Collection<TypeElement> typeList = this.getTypes(name, false);
            if (typeList == null) continue;
            for (TypeElement type : typeList) {
                for (String parentType : type.getParentTypes()) {
                    if (types.contains(parentType)) continue;
                    types.add(parentType);
                    if ("Object".equals(parentType)) continue;
                    queue.offer(parentType);
                }
            }
        }
        return new ArrayList<String>(types);
    }

    public Collection<PropertyElement> getTypeMembers(String typeName, String memberName) {
        ArrayList<PropertyElement> properties = new ArrayList<PropertyElement>();
        for (Index index : this.indices) {
            properties.addAll(this._reader.getFunctions(index, typeName, memberName));
            properties.addAll(this._reader.getProperties(index, typeName, memberName));
        }
        return properties;
    }

    public Collection<PropertyElement> getTypeMembers(List<String> typeNames) {
        if (CollectionsUtil.isEmpty(typeNames)) {
            return Collections.emptyList();
        }
        ArrayList<PropertyElement> properties = new ArrayList<PropertyElement>();
        for (Index index : this.indices) {
            properties.addAll(this._reader.getFunctions(index, typeNames));
            properties.addAll(this._reader.getProperties(index, typeNames));
        }
        properties.trimToSize();
        return properties;
    }

    public Collection<PropertyElement> getTypeProperties(String typeName) {
        if (StringUtil.isEmpty((String)typeName)) {
            return Collections.emptyList();
        }
        ArrayList<PropertyElement> properties = new ArrayList<PropertyElement>();
        for (Index index : this.indices) {
            properties.addAll(this._reader.getProperties(index, typeName));
        }
        properties.trimToSize();
        return properties;
    }

    public List<EventElement> getEvents(String owningType, String eventName) {
        ArrayList<EventElement> events = new ArrayList<EventElement>();
        for (Index index : this.indices) {
            events.addAll(this._reader.getEvents(index, owningType, eventName));
        }
        events.trimToSize();
        return events;
    }

    public String getModuleType(IPath absolutePath) {
        if (absolutePath == null || absolutePath.isEmpty()) {
            return null;
        }
        for (Index index : this.indices) {
            String fileURI;
            List results = index.query(new String[]{"js.module_def"}, "*", 2);
            QueryResult match = (QueryResult)CollectionsUtil.find((Collection)results, (IFilter)new IFilter<QueryResult>(fileURI = absolutePath.toFile().toURI().toString()){
                private final /* synthetic */ String val$fileURI;
                {
                    this.val$fileURI = string;
                }

                public boolean include(QueryResult item) {
                    return item.getDocuments().contains(this.val$fileURI);
                }
            });
            if (match == null) continue;
            return String.valueOf(match.getWord()) + DOT_EXPORTS;
        }
        return null;
    }

    public List<EventElement> getEvents(List<String> owningTypes) {
        ArrayList<EventElement> events = new ArrayList<EventElement>();
        for (Index index : this.indices) {
            events.addAll(this._reader.getEvents(index, owningTypes));
        }
        events.trimToSize();
        return events;
    }

    public List<PropertyElement> getProperties(List<String> allTypes) {
        ArrayList<PropertyElement> properties = new ArrayList<PropertyElement>();
        for (Index index : this.indices) {
            properties.addAll(this._reader.getProperties(index, allTypes));
        }
        properties.trimToSize();
        return properties;
    }

    public List<FunctionElement> getFunctions(String typeName, String propertyName) {
        ArrayList<FunctionElement> functions = new ArrayList<FunctionElement>();
        for (Index index : this.indices) {
            functions.addAll(this._reader.getFunctions(index, typeName, propertyName));
        }
        functions.trimToSize();
        return functions;
    }

    public List<PropertyElement> getProperties(String typeName, String propertyName) {
        ArrayList<PropertyElement> properties = new ArrayList<PropertyElement>();
        for (Index index : this.indices) {
            properties.addAll(this._reader.getProperties(index, typeName, propertyName));
        }
        properties.trimToSize();
        return properties;
    }

    public Collection<String> getTypeNames(String pattern, int matchFlags) {
        ArrayList<String> properties = new ArrayList<String>();
        for (Index index : this.indices) {
            properties.addAll(this._reader.getTypeNames(index, pattern, matchFlags));
        }
        properties.trimToSize();
        return properties;
    }

    public FunctionElement findFunctionInHierarchy(String typeName, String methodName) {
        List<String> types = this.getTypeAncestorNames(typeName);
        types.add(0, typeName);
        for (String type : types) {
            List<FunctionElement> functions = this.getFunctions(type, methodName);
            if (CollectionsUtil.isEmpty(functions)) continue;
            return (FunctionElement)functions.iterator().next();
        }
        return null;
    }

    public IPath getModulePath(String generatedModuleId) {
        if (generatedModuleId == null || generatedModuleId.isEmpty()) {
            return Path.EMPTY;
        }
        if (generatedModuleId.endsWith(DOT_EXPORTS)) {
            generatedModuleId = generatedModuleId.substring(0, generatedModuleId.length() - DOT_EXPORTS.length());
        }
        for (Index index : this.indices) {
            String root;
            QueryResult match;
            Set docs;
            List results = index.query(new String[]{"js.module_def"}, generatedModuleId, 8);
            if (results == null || results.isEmpty() || (docs = (match = (QueryResult)results.get(0)).getDocuments()) == null || docs.isEmpty()) continue;
            String uri = (String)docs.iterator().next();
            if (uri.startsWith(root = index.getRoot().toString())) {
                uri = uri.substring(root.length());
            }
            return Path.fromOSString((String)uri).removeFileExtension();
        }
        return Path.EMPTY;
    }
}

