/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.core.inferencing;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.IOUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.js.core.JSCorePlugin;
import com.aptana.js.core.inferencing.IRequireResolver;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;

public abstract class AbstractRequireResolver
implements IRequireResolver {
    private static final String INDEX = "index";
    private static final String PACKAGE_JSON = "package.json";
    private static final String MAIN = "main";
    protected static final String JS = "js";

    protected IPath loadAsFile(IPath x, String ... extensions) {
        File file = x.toFile();
        if (file.isFile()) {
            return x;
        }
        List ext = CollectionsUtil.newList((Object[])extensions);
        ext.add(0, JS);
        for (String extension : ext) {
            IPath js = x.addFileExtension(extension);
            if (!js.toFile().isFile()) continue;
            return js;
        }
        return null;
    }

    protected IPath loadAsDirectory(IPath x, String ... extensions) {
        File packageJSON = x.append(PACKAGE_JSON).toFile();
        if (packageJSON.isFile()) {
            try {
                IPath m;
                IPath result;
                IFileStore fileStore = EFS.getStore((URI)packageJSON.toURI());
                String rawJSON = IOUtil.read((InputStream)fileStore.openInputStream(0, (IProgressMonitor)new NullProgressMonitor()));
                Map json = (Map)JSON.parse((String)rawJSON);
                String mainFile = (String)json.get(MAIN);
                if (!StringUtil.isEmpty((String)mainFile) && (result = this.loadAsFile(m = x.append(mainFile), new String[0])) != null) {
                    return result;
                }
            }
            catch (CoreException e) {
                IdeLog.log((Plugin)JSCorePlugin.getDefault(), (IStatus)e.getStatus());
            }
        }
        List ext = CollectionsUtil.newList((Object[])extensions);
        ext.add(0, JS);
        IPath index = x.append(INDEX);
        for (String extension : ext) {
            IPath potential = index.addFileExtension(extension);
            if (!potential.toFile().isFile()) continue;
            return potential;
        }
        return null;
    }
}

