/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.core.inferencing;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;

public class JSTypeMapper {
    private static JSTypeMapper INSTANCE;
    private static final String TYPE_MAPS = "typeMaps";
    private static final String TAG_TYPE_MAP = "typeMap";
    private static final String ATTR_SRC_TYPE = "sourceType";
    private static final String ATTR_DST_TYPE = "destinationType";
    private Map<String, String> _map;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JSTypeMapper getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<JSTypeMapper> clazz = JSTypeMapper.class;
        synchronized (JSTypeMapper.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new JSTypeMapper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private JSTypeMapper() {
        this.loadMappings();
    }

    public void addTypeMapping(String type, String mappedType) {
        if (this._map == null) {
            this._map = new HashMap<String, String>();
        }
        this._map.put(type, mappedType);
    }

    public String getMappedType(String type) {
        String result = type;
        if (this._map != null && this._map.containsKey(type)) {
            result = this._map.get(type);
        }
        return result;
    }

    protected void loadMappings() {
        EclipseUtil.processConfigurationElements((String)"com.aptana.js.core", (String)TYPE_MAPS, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

            public void processElement(IConfigurationElement element) {
                String srcType = element.getAttribute(JSTypeMapper.ATTR_SRC_TYPE);
                String dstType = element.getAttribute(JSTypeMapper.ATTR_DST_TYPE);
                if (!StringUtil.isEmpty((String)srcType) && !StringUtil.isEmpty((String)dstType)) {
                    JSTypeMapper.this.addTypeMapping(srcType, dstType);
                }
            }

            public Set<String> getSupportElementNames() {
                return CollectionsUtil.newSet((Object[])new String[]{JSTypeMapper.TAG_TYPE_MAP});
            }
        });
    }
}

