/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.internal.core.index;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexWriter;
import com.aptana.js.core.JSCorePlugin;
import com.aptana.js.core.model.EventElement;
import com.aptana.js.core.model.FunctionElement;
import com.aptana.js.core.model.PropertyElement;
import com.aptana.js.core.model.TypeElement;
import java.net.URI;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.Plugin;

public class JSIndexWriter
extends IndexWriter {
    protected URI getDocumentPath() {
        return URI.create("js.metadata");
    }

    protected void writeEvent(Index index, EventElement event, URI location) {
        String value = StringUtil.join((String)"\u0000", (String[])new String[]{event.getOwningType(), event.getName(), this.serialize(event)});
        if (IdeLog.isTraceEnabled((Plugin)JSCorePlugin.getDefault(), (String)"com.aptana.js.core/debug/show_index_writes")) {
            String message = MessageFormat.format("Writing event ''{0}.{1}'' from location ''{2}'' to index ''{3}''", event.getOwningType(), event.getName(), location.toString(), index.toString());
            IdeLog.logTrace((Plugin)JSCorePlugin.getDefault(), (String)message, (String)"com.aptana.js.core/debug/show_index_writes");
        }
        index.addEntry("js.event", value, location);
    }

    protected void writeFunction(Index index, FunctionElement function, URI location) {
        String value = StringUtil.join((String)"\u0000", (String[])new String[]{function.getOwningType(), function.getName(), this.serialize(function)});
        if (IdeLog.isTraceEnabled((Plugin)JSCorePlugin.getDefault(), (String)"com.aptana.js.core/debug/show_index_writes")) {
            String message = MessageFormat.format("Writing function ''{0}.{1}'' from location ''{2}'' to index ''{3}''", function.getOwningType(), function.getName(), location.toString(), index.toString());
            IdeLog.logTrace((Plugin)JSCorePlugin.getDefault(), (String)message, (String)"com.aptana.js.core/debug/show_index_writes");
        }
        index.addEntry("js.function", value, location);
    }

    public void writeProperty(Index index, PropertyElement property, URI location) {
        String value = StringUtil.join((String)"\u0000", (String[])new String[]{property.getOwningType(), property.getName(), this.serialize(property)});
        if (IdeLog.isTraceEnabled((Plugin)JSCorePlugin.getDefault(), (String)"com.aptana.js.core/debug/show_index_writes")) {
            String message = MessageFormat.format("Writing property ''{0}.{1}'' from location ''{2}'' to index ''{3}''", property.getOwningType(), property.getName(), location.toString(), index.toString());
            IdeLog.logTrace((Plugin)JSCorePlugin.getDefault(), (String)message, (String)"com.aptana.js.core/debug/show_index_writes");
        }
        index.addEntry("js.property", value, location);
    }

    public void writeType(Index index, TypeElement type) {
        this.writeType(index, type, this.getDocumentPath());
    }

    public void writeType(Index index, TypeElement type, URI location) {
        if (index != null && type != null && location != null) {
            List<String> parentTypes = type.getParentTypes();
            String parentType = !parentTypes.isEmpty() ? StringUtil.join((String)",", parentTypes) : (!type.getName().equals("Object") ? "Object" : "");
            String value = StringUtil.join((String)"\u0000", (Object[])new Object[]{type.getName(), parentType, type.getDescription(), Character.valueOf(type.isDeprecated() ? (char)'1' : '0'), Character.valueOf(type.isInternal() ? (char)'1' : '0'), type.hasAllUserAgents() ? "all" : StringUtil.join((String)",", type.getUserAgentNames())});
            if (IdeLog.isTraceEnabled((Plugin)JSCorePlugin.getDefault(), (String)"com.aptana.js.core/debug/show_index_writes")) {
                String message = MessageFormat.format("Writing type ''{0}'' from location ''{1}'' to index ''{2}''", type.getName(), location.toString(), index.toString());
                IdeLog.logTrace((Plugin)JSCorePlugin.getDefault(), (String)message, (String)"com.aptana.js.core/debug/show_index_writes");
            }
            index.addEntry("js.type", value, location);
            for (PropertyElement property : type.getProperties()) {
                if (!property.getOwningType().equals(type.getName())) {
                    IdeLog.logWarning((Plugin)JSCorePlugin.getDefault(), (String)MessageFormat.format("Property is attached to type {0}, but states it's owning type is {1}", type.getName(), property.getOwningType()));
                }
                if (property instanceof FunctionElement) {
                    this.writeFunction(index, (FunctionElement)property, location);
                    continue;
                }
                this.writeProperty(index, property, location);
            }
            for (EventElement event : type.getEvents()) {
                this.writeEvent(index, event, location);
            }
        }
    }
}

