/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.internal.core.index;

import com.aptana.core.logging.IdeLog;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.MetadataLoader;
import com.aptana.js.core.JSCorePlugin;
import com.aptana.js.core.index.JSIndexQueryHelper;
import com.aptana.js.core.model.TypeElement;
import com.aptana.js.internal.core.index.JSIndexWriter;
import com.aptana.js.internal.core.index.JSMetadataReader;
import com.aptana.js.internal.core.index.Messages;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSMetadataLoader
extends MetadataLoader<JSMetadataReader> {
    public JSMetadataLoader() {
        super(Messages.Loading_Metadata);
    }

    protected JSMetadataReader createMetadataReader() {
        return new JSMetadataReader();
    }

    protected Bundle getBundle() {
        return JSCorePlugin.getDefault().getBundle();
    }

    protected double getIndexVersion() {
        return 0.37;
    }

    protected String getIndexVersionKey() {
        return "JS_INDEX_VERSION";
    }

    protected String[] getMetadataFiles() {
        return new String[]{"/metadata/js_core.xml", "/metadata/dom_0.xml", "/metadata/dom_2.xml", "/metadata/dom_3.xml", "/metadata/dom_5.xml"};
    }

    protected String getPluginId() {
        return "com.aptana.js.core";
    }

    protected void postRebuild() {
        super.postRebuild();
        this.rebuildProjectIndexes();
    }

    private void rebuildProjectIndexes() {
        Job job = new Job(Messages.JSMetadataLoader_Rebuilding_Project_Indexes){

            protected IStatus run(IProgressMonitor monitor) {
                IWorkspace ws = ResourcesPlugin.getWorkspace();
                try {
                    ws.build(6, monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected void writeIndex(JSMetadataReader reader) {
        this.getIndexManager().resetIndex(URI.create("metadata:/js"));
        JSIndexWriter indexer = new JSIndexWriter();
        Index index = this.getIndex();
        TypeElement[] typeElementArray = reader.getTypes();
        int n = typeElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeElement type = typeElementArray[n2];
            indexer.writeType(index, type);
            ++n2;
        }
        try {
            index.save();
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)JSCorePlugin.getDefault(), (Throwable)e);
        }
    }

    protected IndexManager getIndexManager() {
        return IndexPlugin.getDefault().getIndexManager();
    }

    protected Index getIndex() {
        return JSIndexQueryHelper.getJSCoreIndex();
    }
}

