/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.internal.core.parsing.sdoc.model;

import beaver.Symbol;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.SourcePrinter;
import com.aptana.core.util.StringUtil;
import com.aptana.js.internal.core.parsing.sdoc.model.Tag;
import com.aptana.js.internal.core.parsing.sdoc.model.TagType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentationBlock
extends Symbol {
    private String _text;
    private List<Tag> _tags;

    public DocumentationBlock(List<Tag> tags) {
        this("", tags);
    }

    public DocumentationBlock(String text) {
        this(text, new ArrayList<Tag>());
    }

    public DocumentationBlock(String text, List<Tag> tags) {
        this._text = text;
        this._tags = tags;
    }

    public List<Tag> getTags() {
        List<Tag> result = this._tags;
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public List<Tag> getTags(EnumSet<TagType> tagSelector) {
        List<Tag> result;
        if (!CollectionsUtil.isEmpty(this._tags)) {
            result = new ArrayList();
            for (Tag tag : this._tags) {
                if (!tagSelector.contains((Object)tag.getType())) continue;
                result.add(tag);
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    public List<Tag> getTags(TagType type) {
        return this.getTags(EnumSet.of(type));
    }

    public String getText() {
        return this._text;
    }

    public boolean hasTag(TagType type) {
        boolean result = false;
        if (type != null && !CollectionsUtil.isEmpty(this._tags)) {
            for (Tag tag : this._tags) {
                if (tag.getType() != type) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean hasTags() {
        return this._tags != null && !this._tags.isEmpty();
    }

    public void setRange(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public String toSource() {
        SourcePrinter writer = new SourcePrinter(" * ");
        this.toSource(writer);
        return writer.toString();
    }

    public void toSource(SourcePrinter writer) {
        writer.println("/**").increaseIndent();
        if (this._text != null && !StringUtil.isEmpty((String)this._text)) {
            writer.printlnWithIndent(this._text);
            if (this.hasTags()) {
                writer.printIndent().println();
            }
        }
        if (this.hasTags()) {
            for (Tag tag : this._tags) {
                writer.printIndent();
                tag.toSource(writer);
                writer.println();
            }
        }
        writer.decreaseIndent().println(" */");
    }
}

