/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.internal.core.preferences;

import com.aptana.core.build.IBuildParticipant;
import com.aptana.core.build.IProblem;
import com.aptana.core.build.PreferenceUtil;
import com.aptana.core.util.ArrayUtil;
import java.text.MessageFormat;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    public static final boolean DEFAULT_COMMENT_INDENT_USE_STAR = true;

    public void initializeDefaultPreferences() {
        IEclipsePreferences prefs = DefaultScope.INSTANCE.getNode("com.aptana.js.core");
        prefs.putDouble("JS_INDEX_VERSION", 0.0);
        prefs.put("missing_semicolon_severity", IProblem.Severity.WARNING.id());
        prefs.putBoolean(PreferenceUtil.getEnablementPreferenceKey((String)"com.aptana.js.core.JSParserValidator", (IBuildParticipant.BuildType)IBuildParticipant.BuildType.BUILD), true);
        prefs.putBoolean(PreferenceUtil.getEnablementPreferenceKey((String)"com.aptana.js.core.JSParserValidator", (IBuildParticipant.BuildType)IBuildParticipant.BuildType.RECONCILE), true);
        prefs.put("jsLintOptions", "{\n  \"laxLineEnd\": true,\n  \"undef\": true,\n  \"browser\": true,\n  \"jscript\": true,\n  \"debug\": true,\n  \"maxerr\": 100000,\n  \"white\": true,\n  \"predef\": [\n    \"Ti\",\n    \"Titanium\",\n    \"alert\",\n    \"require\",\n    \"exports\",\n    \"native\",\n    \"implements\",\n  ]\n}");
        String[] defaultJSLintFilters = new String[]{"Missing space between .+", "Unexpected '\\(space\\)'\\.", "Expected '.+' at column \\d+, not column \\d+\\.", "Unexpected space between .+", "Expected exactly one space between .+"};
        prefs.put(PreferenceUtil.getFiltersKey((String)"com.aptana.js.core.JSLintValidator"), PreferenceUtil.serializeFilters((String[])defaultJSLintFilters));
        IEclipsePreferences cepPrefs = InstanceScope.INSTANCE.getNode("com.aptana.editor.common");
        String oldKey = MessageFormat.format("{0}:{1}", "com.aptana.contenttype.js", "com.aptana.editor.common.filterExpressions");
        String oldFilters = cepPrefs.get(oldKey, null);
        if (oldFilters != null) {
            try {
                String[] oldFilterArray = oldFilters.split("####");
                String[] combined = (String[])ArrayUtil.flatten((Object[][])new String[][]{oldFilterArray, defaultJSLintFilters});
                IEclipsePreferences newPrefs = InstanceScope.INSTANCE.getNode("com.aptana.js.core");
                newPrefs.put(PreferenceUtil.getFiltersKey((String)"com.aptana.js.core.JSLintValidator"), PreferenceUtil.serializeFilters((String[])combined));
                newPrefs.flush();
                cepPrefs.remove(oldKey);
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
    }
}

