/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui;

import com.aptana.core.resources.IProjectContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PortalUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.aptana.portal.ui";
    public static final String PORTAL_ID = "com.aptana.portal.main";
    public static final String RUBY_IMAGE = "/icons/wizban/ruby.png";
    public static final String XAMPP_IMAGE = "/icons/wizban/xampp.png";
    public static final String JS_IMAGE = "/icons/wizban/js.png";
    public static final String PYTHON_IMAGE = "/icons/wizban/python.png";
    private static PortalUIPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static BundleContext getContext() {
        return PortalUIPlugin.getDefault().getBundle().getBundleContext();
    }

    public static PortalUIPlugin getDefault() {
        return plugin;
    }

    public static IProject getActiveProject() {
        final IProject[] projects = new IProject[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                IWorkbenchPage page = window.getActivePage();
                if (page == null) {
                    return;
                }
                IViewReference[] refs = page.getViewReferences();
                if (refs == null) {
                    return;
                }
                IViewReference[] iViewReferenceArray = refs;
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject activeProject;
                    IProjectContext view;
                    IViewReference ref = iViewReferenceArray[n2];
                    if (ref != null && ref.getId().equals("com.aptana.explorer.view") && (view = (IProjectContext)ref.getPart(false)) != null && (activeProject = view.getActiveProject()) != null) {
                        projects[0] = activeProject;
                        return;
                    }
                    ++n2;
                }
                IEditorPart activeEditor = page.getActiveEditor();
                if (activeEditor != null) {
                    IResource resource = null;
                    if (activeEditor.getEditorInput().getPersistable() != null) {
                        resource = (IResource)activeEditor.getEditorInput().getAdapter(IResource.class);
                    } else {
                        IEditorReference[] editorReferences;
                        IEditorReference[] iEditorReferenceArray = editorReferences = page.getEditorReferences();
                        int n3 = editorReferences.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IEditorReference reference = iEditorReferenceArray[n4];
                            IEditorPart editor = reference.getEditor(false);
                            if (editor != null && (resource = (IResource)editor.getEditorInput().getAdapter(IResource.class)) != null) break;
                            ++n4;
                        }
                    }
                    if (resource != null) {
                        projects[0] = resource.getProject();
                        return;
                    }
                }
            }
        });
        if (projects[0] != null) {
            return projects[0];
        }
        IPreferencesService preferencesService = Platform.getPreferencesService();
        String activeProjectName = preferencesService.getString("com.aptana.explorer", "activeProject", null, null);
        IProject result = null;
        if (activeProjectName != null) {
            result = ResourcesPlugin.getWorkspace().getRoot().getProject(activeProjectName);
        }
        return result;
    }

    public static Image getImage(String string) {
        if (PortalUIPlugin.getImageDescriptor(string) != null) {
            return PortalUIPlugin.getDefault().getImageRegistry().get(string);
        }
        return null;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        ImageDescriptor imageDescriptor = PortalUIPlugin.getDefault().getImageRegistry().getDescriptor(path);
        if (imageDescriptor == null && (imageDescriptor = PortalUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path)) != null) {
            PortalUIPlugin.getDefault().getImageRegistry().put(path, imageDescriptor);
        }
        return imageDescriptor;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put(RUBY_IMAGE, PortalUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)RUBY_IMAGE));
        reg.put(XAMPP_IMAGE, PortalUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)XAMPP_IMAGE));
        reg.put(JS_IMAGE, PortalUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)JS_IMAGE));
        reg.put(PYTHON_IMAGE, PortalUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)PYTHON_IMAGE));
    }
}

