/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch;

import com.aptana.core.logging.IdeLog;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.dispatch.IActionController;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;

public class ActionControllerProxy
implements IActionController {
    private IConfigurationElement element;
    private IActionController contributorClass;
    private static final String ATT_CLASS = "class";
    private static final String ATT_CONFGURATION_PROCESSOR_ID = "configurationProcessor";

    public ActionControllerProxy(IConfigurationElement element) {
        this.element = element;
    }

    private synchronized void loadElement() throws CoreException {
        if (this.contributorClass == null) {
            this.contributorClass = (IActionController)this.element.createExecutableExtension(ATT_CLASS);
            this.contributorClass.setConfigurationProcessorId(this.element.getAttribute(ATT_CONFGURATION_PROCESSOR_ID));
        }
    }

    public String[] getActions() {
        try {
            this.loadElement();
            return this.contributorClass.getActions();
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
            return new String[0];
        }
    }

    public boolean hasAction(String action) {
        try {
            this.loadElement();
            return this.contributorClass.hasAction(action);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
            return false;
        }
    }

    public Object invokeAction(String action, Object args) {
        try {
            this.loadElement();
            return this.contributorClass.invokeAction(action, args);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    public void setConfigurationProcessorId(String id) {
        try {
            this.loadElement();
            this.contributorClass.setConfigurationProcessorId(id);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
        }
    }

    public String getConfigurationProcessorId() {
        try {
            this.loadElement();
            return this.contributorClass.getConfigurationProcessorId();
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
            return "";
        }
    }
}

