/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch.browserFunctions;

import com.aptana.core.logging.IdeLog;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.dispatch.BrowserInteractionRegistry;
import com.aptana.portal.ui.dispatch.BrowserNotifier;
import com.aptana.portal.ui.dispatch.IActionController;
import com.aptana.portal.ui.dispatch.browserFunctions.Messages;
import com.aptana.portal.ui.internal.IBrowserFunctionHandler;
import com.aptana.usage.AnalyticsEvent;
import com.aptana.usage.FeatureEvent;
import com.aptana.usage.IStudioAnalytics;
import com.aptana.usage.UsagePlugin;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;

public class DispatcherBrowserFunction
implements IBrowserFunctionHandler {
    public Object function(Object[] arguments) {
        Object args;
        String action;
        IActionController controller;
        String controllerID;
        block11: {
            block12: {
                if (arguments == null || arguments.length != 1 || arguments[0] == null) {
                    return BrowserNotifier.toJSONErrorNotification("Argument Error", Messages.DispatcherBrowserFunction_wrongOrMissingArguments);
                }
                Object jsonObject = JSON.parse((String)arguments[0].toString());
                if (!(jsonObject instanceof Map)) {
                    return BrowserNotifier.toJSONErrorNotification("Argument Error", Messages.DispatcherBrowserFunction_expectedJSONMap);
                }
                Map event = (Map)jsonObject;
                controllerID = (String)event.get("controller");
                controller = BrowserInteractionRegistry.getInstance().getActionController(controllerID);
                if (controller == null) {
                    return BrowserNotifier.toJSONErrorNotification("Unknown Controller", String.valueOf(Messages.DispatcherBrowserFunction_unknownController) + controllerID);
                }
                action = (String)event.get("action");
                if (action == null || !controller.hasAction(action)) {
                    return BrowserNotifier.toJSONErrorNotification("Unknown Action", String.valueOf(Messages.DispatcherBrowserFunction_unknownAction) + action);
                }
                args = event.get("args");
                if (args == null) break block11;
                if (this.isSupportedPlatform(args)) break block12;
                return "";
            }
            try {
                if (!(args instanceof Map)) {
                    args = JSON.parse((String)args.toString());
                }
                if (!(args instanceof Object[])) {
                    args = new Object[]{args};
                }
                if (DispatcherBrowserFunction.isAllNulls((Object[])args)) {
                    args = null;
                }
            }
            catch (IllegalStateException ise) {
                IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)"The dispatch arguments were probably not passed as a valid JSON. Please check your JavaScript code.", (Throwable)ise);
                return BrowserNotifier.toJSONErrorNotification("Argument Error", ise.getMessage());
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
                return BrowserNotifier.toJSONErrorNotification("Argument Error", e.getMessage());
            }
        }
        this.sendEvent(new FeatureEvent(MessageFormat.format("{0}.{1}", controllerID, action), null));
        return this.dispatch(controller, action, args);
    }

    protected boolean isSupportedPlatform(Object browserArgs) {
        if (browserArgs instanceof String) {
            String mobileweb = "MobileWeb";
            String format1 = MessageFormat.format("\"{0}\"", mobileweb);
            String format2 = MessageFormat.format("[\"{0}\"]", mobileweb);
            if (browserArgs.equals(format1) || browserArgs.equals(format2)) {
                return false;
            }
        }
        return true;
    }

    private void sendEvent(FeatureEvent featureEvent) {
        UsagePlugin plugin = UsagePlugin.getDefault();
        if (plugin == null) {
            return;
        }
        IStudioAnalytics analytics = plugin.getStudioAnalytics();
        if (analytics == null) {
            return;
        }
        analytics.sendEvent((AnalyticsEvent)featureEvent);
    }

    protected Object dispatch(IActionController controller, String action, Object arguments) {
        return controller.invokeAction(action, arguments);
    }

    private static boolean isAllNulls(Object[] array) {
        if (array == null) {
            return true;
        }
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj != null && !"null".equals(obj.toString())) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

