/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch.configurationProcessors;

import com.aptana.configurations.processor.AbstractConfigurationProcessor;
import com.aptana.configurations.processor.ConfigurationStatus;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.InputStreamGobbler;
import com.aptana.core.util.VersionUtil;
import com.aptana.ide.core.io.downloader.DownloadManager;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.dispatch.configurationProcessors.Messages;
import com.aptana.ui.util.UIUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.framework.Version;

public abstract class InstallerConfigurationProcessor
extends AbstractConfigurationProcessor {
    protected static final String APTANA_PROPERTIES_FILE_NAME = ".aptana";
    protected static final String NAME_ATTRIBUTE = "name";
    protected static final String INSTALL_DIR_ATTRIBUTE = "install_dir";
    protected List<IPath> downloadedPaths;

    public ConfigurationStatus computeStatus(IProgressMonitor progressMonitor, Object attributes) {
        return this.configurationStatus;
    }

    protected abstract String getApplicationName();

    public IStatus download(String[] URLs, IProgressMonitor progressMonitor) {
        if (URLs.length == 0) {
            String err = Messages.InstallerConfigurationProcessor_missingDownloadTargets;
            this.applyErrorAttributes(err);
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)"We expected an array of URLs, but got an empty array.", (Throwable)new Exception(err));
            return new Status(4, "com.aptana.portal.ui", err);
        }
        this.downloadedPaths = null;
        DownloadManager downloadManager = new DownloadManager();
        ArrayList<URI> urlsList = new ArrayList<URI>(URLs.length);
        int i = 0;
        while (i < URLs.length) {
            try {
                urlsList.add(new URI(this.urls[i]));
            }
            catch (URISyntaxException mue) {
                IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)mue);
            }
            ++i;
        }
        try {
            downloadManager.addURIs(urlsList);
            IStatus status = downloadManager.start(progressMonitor);
            if (status.isOK()) {
                this.downloadedPaths = downloadManager.getContentsLocations();
            }
            return status;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
            return Status.CANCEL_STATUS;
        }
    }

    public void cacheVersion(String installDir, String versionedFileLocation, String appName) {
        IPreferenceStore preferenceStore = PortalUIPlugin.getDefault().getPreferenceStore();
        String versions = preferenceStore.getString("com.aptana.portal.ui.cached_versions");
        Map versionsMap = null;
        versionsMap = versions == null || versions.equals("") ? new HashMap() : (Map)JSON.parse((String)versions);
        HashMap<String, String> appVersionMap = new HashMap<String, String>();
        Version version = VersionUtil.parseVersion((String)versionedFileLocation);
        if (!VersionUtil.isEmpty((Version)version)) {
            appVersionMap.put("version", version.toString());
            appVersionMap.put("location", installDir);
            versionsMap.put(appName.toLowerCase(), appVersionMap);
            preferenceStore.setValue("com.aptana.portal.ui.cached_versions", JSON.toString(versionsMap));
        } else {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)MessageFormat.format("Could not cache the location and version for {0}. Install dir: {1}, versionedFileLocation: {2}", appName, installDir, versionedFileLocation), (Throwable)new Exception());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IStatus extractWin(IPath sfxZip, IPath targetFolder) {
        Status status;
        String output;
        block12: {
            IStatus iStatus;
            block11: {
                Status errorStatus = new Status(4, "com.aptana.portal.ui", Messages.InstallerConfigurationProcessor_unableToExtractZip);
                if (!"win32".equals(Platform.getOS())) {
                    IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)"Unable to extract the Zip file. A Windows OS extractor was called for a non-Windows platform.", (Throwable)new Exception());
                    return errorStatus;
                }
                if (sfxZip == null || targetFolder == null) {
                    IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)"Undefined zip file or target folder", (Throwable)new Exception());
                    return errorStatus;
                }
                File destinationFolder = targetFolder.toFile();
                if (!destinationFolder.exists() && !destinationFolder.mkdirs()) {
                    IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)("Failed to create destination directory " + destinationFolder), (Throwable)new Exception());
                    return errorStatus;
                }
                ProcessBuilder processBuilder = new ProcessBuilder(sfxZip.toOSString(), "-o" + targetFolder.toOSString(), "-y", sfxZip.toOSString());
                processBuilder.directory(destinationFolder);
                processBuilder.redirectErrorStream(true);
                output = null;
                try {
                    Process process = processBuilder.start();
                    InputStreamGobbler errorGobbler = new InputStreamGobbler(process.getErrorStream(), "\n", null);
                    InputStreamGobbler outputGobbler = new InputStreamGobbler(process.getInputStream(), "\n", null);
                    outputGobbler.start();
                    errorGobbler.start();
                    process.waitFor();
                    outputGobbler.interrupt();
                    errorGobbler.interrupt();
                    outputGobbler.join();
                    errorGobbler.join();
                    output = outputGobbler.getResult();
                    String errors = errorGobbler.getResult();
                    int exitVal = process.exitValue();
                    if (exitVal == 0) {
                        iStatus = Status.OK_STATUS;
                        if (output == null) return iStatus;
                        break block11;
                    }
                    IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)("Zip extraction failed. The process returned " + exitVal), (Throwable)new Exception("Process output:\n" + errors));
                    status = errorStatus;
                    if (output == null) return status;
                    break block12;
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
                    Status status2 = errorStatus;
                    return status2;
                }
            }
            IdeLog.logInfo((Plugin)PortalUIPlugin.getDefault(), (String)output);
            return iStatus;
        }
        IdeLog.logInfo((Plugin)PortalUIPlugin.getDefault(), (String)output);
        return status;
        finally {
            if (output != null) {
                IdeLog.logInfo((Plugin)PortalUIPlugin.getDefault(), output);
            }
        }
    }

    public void displayMessageInUIThread(int kind, String title, String message) {
        UIUtils.showMessageDialogFromBgThread((int)kind, (String)title, (String)message, null);
    }

    protected void finalizeInstallation(String installDir) {
        this.deleteDownloadedPaths();
        if (installDir != null) {
            this.cacheVersion(installDir, this.urls[0], this.getApplicationName());
        }
    }

    protected void deleteDownloadedPaths() {
        if (!CollectionsUtil.isEmpty(this.downloadedPaths)) {
            for (IPath f : this.downloadedPaths) {
                File toDelete = f.toFile();
                if (!toDelete.exists()) continue;
                toDelete.deleteOnExit();
            }
        }
    }
}

