/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch.configurationProcessors;

import com.aptana.configurations.processor.ConfigurationStatus;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.ide.core.io.LockUtils;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.dispatch.configurationProcessors.InstallerConfigurationProcessor;
import com.aptana.portal.ui.dispatch.configurationProcessors.Messages;
import com.aptana.portal.ui.dispatch.configurationProcessors.installer.InstallerOptionsDialog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonInstallProcessor
extends InstallerConfigurationProcessor {
    protected static final String PYTHON_DEFAULT_INSTALL_DIR = "C:\\Python";
    protected static final String INSTALL_FOR_ALL_USERS_ATTR = "install_for_all";
    private static final String PYTHON = "Python";
    protected static final int PYTHON_INSTALLER_PROCESS_CANCEL_CODE = 1602;
    private static boolean installationInProgress;
    private String installDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationStatus configure(IProgressMonitor progressMonitor, Object attributes) {
        block29: {
            block28: {
                Class<?> clazz;
                ConfigurationStatus configurationStatus;
                Class<?> clazz2 = ((Object)((Object)this)).getClass();
                synchronized (clazz2) {
                    if (installationInProgress) {
                        return this.configurationStatus;
                    }
                    installationInProgress = true;
                }
                if (!"win32".equals(Platform.getOS())) {
                    String err = "The Python installer processor is designed to work on Windows.";
                    IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(err));
                    this.applyErrorAttributes(err);
                    installationInProgress = false;
                    return this.configurationStatus;
                }
                try {
                    this.configurationStatus.removeAttribute("configurations");
                    this.clearErrorAttributes();
                    IStatus loadingStatus = this.loadAttributes(attributes);
                    if (loadingStatus.isOK()) break block28;
                    String message = loadingStatus.getMessage();
                    this.applyErrorAttributes(message);
                    IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(message));
                    configurationStatus = this.configurationStatus;
                    clazz = ((Object)((Object)this)).getClass();
                }
                catch (Throwable throwable) {
                    Class<?> clazz3 = ((Object)((Object)this)).getClass();
                    synchronized (clazz3) {
                        installationInProgress = false;
                    }
                    throw throwable;
                }
                synchronized (clazz) {
                    installationInProgress = false;
                }
                return configurationStatus;
            }
            if (this.urls.length == 1) break block29;
            String err = NLS.bind((String)Messages.InstallProcessor_wrongNumberOfInstallLinks, (Object[])new Object[]{PYTHON, 1, this.urls.length});
            this.applyErrorAttributes(err);
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(err));
            ConfigurationStatus configurationStatus = this.configurationStatus;
            Class<?> clazz = ((Object)((Object)this)).getClass();
            synchronized (clazz) {
                installationInProgress = false;
            }
            return configurationStatus;
        }
        this.installDir = (String)this.attributesMap.get("install_dir");
        if (this.installDir == null) {
            this.installDir = PYTHON_DEFAULT_INSTALL_DIR;
        }
        this.configurationStatus.setStatus("processing");
        IStatus status = this.download(this.urls, progressMonitor);
        if (status.isOK()) {
            status = this.install(progressMonitor);
        }
        switch (status.getSeverity()) {
            case 0: 
            case 1: 
            case 2: {
                this.displayMessageInUIThread(2, NLS.bind((String)Messages.InstallProcessor_installerTitle, (Object)PYTHON), NLS.bind((String)Messages.InstallProcessor_installationSuccessful, (Object)PYTHON));
                this.configurationStatus.setStatus("ok");
                break;
            }
            case 4: {
                this.configurationStatus.setStatus("error");
                break;
            }
            case 8: {
                this.configurationStatus.setStatus("incomplete");
                break;
            }
            default: {
                this.configurationStatus.setStatus("unknown");
            }
        }
        ConfigurationStatus configurationStatus = this.configurationStatus;
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            installationInProgress = false;
        }
        return configurationStatus;
    }

    @Override
    protected String getApplicationName() {
        return PYTHON;
    }

    protected IStatus install(IProgressMonitor progressMonitor) {
        if (CollectionsUtil.isEmpty((Collection)this.downloadedPaths)) {
            String failureMessge = Messages.InstallProcessor_couldNotLocateInstaller;
            String err = NLS.bind((String)Messages.InstallProcessor_failedToInstall, (Object)PYTHON);
            this.displayMessageInUIThread(1, Messages.InstallProcessor_installationErrorTitle, String.valueOf(err) + ' ' + failureMessge);
            return new Status(4, "com.aptana.portal.ui", String.valueOf(err) + ' ' + failureMessge);
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)Messages.InstallProcessor_installerProgressInfo, (int)-1);
        final HashMap<String, Object> installationAttributes = new HashMap<String, Object>();
        try {
            subMonitor.beginTask(NLS.bind((String)Messages.InstallProcessor_installingTaskName, (Object)PYTHON), -1);
            String[] installDir = new String[1];
            UIJob installPythonDialog = new UIJob("Python installer options"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    PythonInstallerOptionsDialog dialog = new PythonInstallerOptionsDialog();
                    if (dialog.open() == 0) {
                        installationAttributes.putAll(dialog.getAttributes());
                        return Status.OK_STATUS;
                    }
                    return Status.CANCEL_STATUS;
                }
            };
            installPythonDialog.schedule();
            try {
                installPythonDialog.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            IStatus result = installPythonDialog.getResult();
            if (!result.isOK()) {
                IStatus iStatus = result;
                return iStatus;
            }
            IStatus status = this.installPYTHON(installationAttributes);
            if (!status.isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
            IdeLog.logInfo((Plugin)PortalUIPlugin.getDefault(), (String)MessageFormat.format("Successfully installed PYTHON into {0}. PYTHON installation completed.", installDir[0]));
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)"Error while installing PYTHON", (Throwable)e);
            Status status = new Status(4, "com.aptana.portal.ui", NLS.bind((String)Messages.InstallProcessor_errorWhileInstalling, (Object)PYTHON));
            return status;
        }
        finally {
            subMonitor.done();
        }
    }

    protected IStatus installPYTHON(final Map<String, Object> installationAttributes) {
        Job job = new Job(NLS.bind((String)Messages.InstallProcessor_installerJobName, (Object)("Python " + Messages.InstallProcessor_installerGroupTitle))){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    String installDir = (String)installationAttributes.get("install_dir");
                    installDir = installDir.replaceAll("/", "\\\\");
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
                    subMonitor.beginTask(NLS.bind((String)Messages.InstallProcessor_installingTaskName, (Object)PythonInstallProcessor.PYTHON), -1);
                    IdeLog.logInfo((Plugin)PortalUIPlugin.getDefault(), (String)("Installing Python into " + installDir));
                    IStatus fileLockStatus = LockUtils.waitForLockRelease((String)((IPath)PythonInstallProcessor.this.downloadedPaths.get(0)).toOSString(), (long)10000L);
                    if (!fileLockStatus.isOK()) {
                        Status status = new Status(4, "com.aptana.portal.ui", NLS.bind((String)Messages.InstallProcessor_failedToInstallSeeLog, (Object)PythonInstallProcessor.PYTHON));
                        return status;
                    }
                    ArrayList<String> command = new ArrayList<String>(4);
                    command.add("msiexec");
                    command.add("/i");
                    command.add(((IPath)PythonInstallProcessor.this.downloadedPaths.get(0)).toOSString());
                    command.add("/qr");
                    command.add("TARGETDIR=\"" + installDir + '\"');
                    if (Boolean.FALSE.toString().equals(PythonInstallProcessor.this.attributesMap.get(PythonInstallProcessor.INSTALL_FOR_ALL_USERS_ATTR))) {
                        command.add("ALLUSERS=0");
                    } else {
                        command.add("ALLUSERS=1");
                    }
                    ProcessBuilder processBuilder = new ProcessBuilder(command);
                    Process process = processBuilder.start();
                    int res = process.waitFor();
                    if (res == 1602) {
                        IdeLog.logInfo((Plugin)PortalUIPlugin.getDefault(), (String)"Python installation cancelled");
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    if (res != 0) {
                        IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)("Failed to install Python. The PYTHON installer process returned a termination code of " + res));
                        Status status = new Status(4, "com.aptana.portal.ui", res, NLS.bind((String)Messages.InstallProcessor_installationErrorMessage, (Object)PythonInstallProcessor.PYTHON, (Object)PythonInstallProcessor.PYTHON), null);
                        return status;
                    }
                    if (!new File(installDir).exists()) {
                        IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)("Failed to install Python. The " + installDir + " directory was not created"), null);
                        Status status = new Status(4, "com.aptana.portal.ui", res, NLS.bind((String)Messages.InstallProcessor_installationError_installDirMissing, (Object)PythonInstallProcessor.PYTHON), null);
                        return status;
                    }
                    PythonInstallProcessor.this.finalizeInstallation(installDir);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
                    Status status = new Status(4, "com.aptana.portal.ui", NLS.bind((String)Messages.InstallProcessor_failedToInstallSeeLog, (Object)PythonInstallProcessor.PYTHON), (Throwable)e);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.schedule(1000L);
        try {
            job.join();
        }
        catch (InterruptedException e) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
            return Status.CANCEL_STATUS;
        }
        return job.getResult();
    }

    @Override
    protected void finalizeInstallation(String installDir) {
        block12: {
            super.finalizeInstallation(installDir);
            File propertiesFile = new File(installDir, ".aptana");
            Properties properties = new Properties();
            properties.put("PYTHON_install", this.urls[0]);
            FileOutputStream fileOutputStream = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream(propertiesFile);
                    properties.store(fileOutputStream, NLS.bind((String)Messages.InstallProcessor_aptanaInstallationComment, (Object)PYTHON));
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
                    if (fileOutputStream == null) break block12;
                    try {
                        fileOutputStream.flush();
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.flush();
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private class PythonInstallerOptionsDialog
    extends InstallerOptionsDialog {
        private Button installForAllUsersBt;

        public PythonInstallerOptionsDialog() {
            super(Display.getDefault().getActiveShell(), PythonInstallProcessor.PYTHON);
            this.setTitleImage(PortalUIPlugin.getDefault().getImageRegistry().get("/icons/wizban/python.png"));
        }

        protected void setAttributes() {
            this.attributes.put("install_dir", PythonInstallProcessor.this.installDir);
            this.attributes.put(PythonInstallProcessor.INSTALL_FOR_ALL_USERS_ATTR, Boolean.TRUE);
        }

        protected Composite createInstallerGroupControls(Composite group) {
            Composite control = super.createInstallerGroupControls(group);
            this.installForAllUsersBt = new Button(group, 32);
            this.installForAllUsersBt.setText(Messages.InstallProcessor_InstallForAllUsers);
            this.installForAllUsersBt.setSelection(true);
            this.installForAllUsersBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PythonInstallerOptionsDialog.this.attributes.put(PythonInstallProcessor.INSTALL_FOR_ALL_USERS_ATTR, PythonInstallerOptionsDialog.this.installForAllUsersBt.getSelection());
                }
            });
            return control;
        }
    }
}

