/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch.configurationProcessors;

import com.aptana.configurations.processor.ConfigurationStatus;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.ide.core.io.LockUtils;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.dispatch.configurationProcessors.InstallerConfigurationProcessor;
import com.aptana.portal.ui.dispatch.configurationProcessors.Messages;
import com.aptana.portal.ui.dispatch.configurationProcessors.installer.InstallerOptionsDialog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XAMPPInstallProcessor
extends InstallerConfigurationProcessor {
    protected static final String XAMPP_DEFAULT_INSTALL_DIR = "C:\\";
    protected static final String EXECUTE_SETUP_SCRIPT_ATTR = "execute_setup_script";
    private static final String XAMPP_DEFAULT_FOLDER = "xampp\\";
    private static final String XAMPP_CONTROL = "xampp-control.exe";
    private static final String XAMPP = "XAMPP";
    protected static final int XAMPP_INSTALLER_PROCESS_CANCEL_CODE = 255;
    private static boolean installationInProgress;
    private String installDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationStatus configure(IProgressMonitor progressMonitor, Object attributes) {
        block29: {
            block28: {
                Class<?> clazz;
                ConfigurationStatus configurationStatus;
                Class<?> clazz2 = ((Object)((Object)this)).getClass();
                synchronized (clazz2) {
                    if (installationInProgress) {
                        return this.configurationStatus;
                    }
                    installationInProgress = true;
                }
                if (!"win32".equals(Platform.getOS())) {
                    String err = "The XAMPP installer processor is designed to work on Windows.";
                    IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(err));
                    this.applyErrorAttributes(err);
                    installationInProgress = false;
                    return this.configurationStatus;
                }
                try {
                    this.configurationStatus.removeAttribute("configurations");
                    this.clearErrorAttributes();
                    IStatus loadingStatus = this.loadAttributes(attributes);
                    if (loadingStatus.isOK()) break block28;
                    String message = loadingStatus.getMessage();
                    this.applyErrorAttributes(message);
                    IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(message));
                    configurationStatus = this.configurationStatus;
                    clazz = ((Object)((Object)this)).getClass();
                }
                catch (Throwable throwable) {
                    Class<?> clazz3 = ((Object)((Object)this)).getClass();
                    synchronized (clazz3) {
                        installationInProgress = false;
                    }
                    throw throwable;
                }
                synchronized (clazz) {
                    installationInProgress = false;
                }
                return configurationStatus;
            }
            if (this.urls.length == 1) break block29;
            String err = NLS.bind((String)Messages.InstallProcessor_wrongNumberOfInstallLinks, (Object[])new Object[]{XAMPP, 1, this.urls.length});
            this.applyErrorAttributes(err);
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(err));
            ConfigurationStatus configurationStatus = this.configurationStatus;
            Class<?> clazz = ((Object)((Object)this)).getClass();
            synchronized (clazz) {
                installationInProgress = false;
            }
            return configurationStatus;
        }
        this.installDir = (String)this.attributesMap.get("install_dir");
        if (this.installDir == null) {
            this.installDir = XAMPP_DEFAULT_INSTALL_DIR;
        }
        this.configurationStatus.setStatus("processing");
        IStatus status = this.download(this.urls, progressMonitor);
        if (status.isOK()) {
            status = this.install(progressMonitor);
        }
        switch (status.getSeverity()) {
            case 0: 
            case 1: 
            case 2: {
                this.displayMessageInUIThread(2, NLS.bind((String)Messages.InstallProcessor_installerTitle, (Object)XAMPP), NLS.bind((String)Messages.InstallProcessor_installationSuccessful, (Object)XAMPP));
                this.configurationStatus.setStatus("ok");
                break;
            }
            case 4: {
                this.configurationStatus.setStatus("error");
                break;
            }
            case 8: {
                this.configurationStatus.setStatus("incomplete");
                break;
            }
            default: {
                this.configurationStatus.setStatus("unknown");
            }
        }
        ConfigurationStatus configurationStatus = this.configurationStatus;
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            installationInProgress = false;
        }
        return configurationStatus;
    }

    @Override
    protected String getApplicationName() {
        return XAMPP;
    }

    protected IStatus install(IProgressMonitor progressMonitor) {
        if (CollectionsUtil.isEmpty((Collection)this.downloadedPaths) || CollectionsUtil.getFirstElement((List)this.downloadedPaths) == null) {
            String failureMessge = Messages.InstallProcessor_couldNotLocateInstaller;
            String err = NLS.bind((String)Messages.InstallProcessor_failedToInstall, (Object)XAMPP);
            this.displayMessageInUIThread(1, Messages.InstallProcessor_installationErrorTitle, String.valueOf(err) + ' ' + failureMessge);
            return new Status(4, "com.aptana.portal.ui", String.valueOf(err) + ' ' + failureMessge);
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)Messages.InstallProcessor_installerProgressInfo, (int)-1);
        final HashMap<String, Object> installationAttributes = new HashMap<String, Object>();
        try {
            subMonitor.beginTask(NLS.bind((String)Messages.InstallProcessor_installingTaskName, (Object)XAMPP), -1);
            String[] installDir = new String[1];
            UIJob installXAMPPDialog = new UIJob("XAMPP installer options"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    XAMPPInstallerOptionsDialog dialog = new XAMPPInstallerOptionsDialog();
                    if (dialog.open() == 0) {
                        installationAttributes.putAll(dialog.getAttributes());
                        return Status.OK_STATUS;
                    }
                    return Status.CANCEL_STATUS;
                }
            };
            installXAMPPDialog.schedule();
            try {
                installXAMPPDialog.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            IStatus result = installXAMPPDialog.getResult();
            if (!result.isOK()) {
                IStatus iStatus = result;
                return iStatus;
            }
            IStatus status = this.installXAMPP(installationAttributes);
            if (!status.isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
            IdeLog.logInfo((Plugin)PortalUIPlugin.getDefault(), (String)("Successfully installed XAMPP into " + installDir[0] + ". XAMPP installation completed."));
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)"Error while installing XAMPP", (Throwable)e);
            Status status = new Status(4, "com.aptana.portal.ui", NLS.bind((String)Messages.InstallProcessor_errorWhileInstalling, (Object)XAMPP));
            return status;
        }
        finally {
            subMonitor.done();
        }
    }

    protected IStatus installXAMPP(final Map<String, Object> installationAttributes) {
        Job job = new Job(NLS.bind((String)Messages.InstallProcessor_installerJobName, (Object)("XAMPP " + Messages.InstallProcessor_installerGroupTitle))){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ProcessBuilder processBuilder;
                    Process process;
                    int res;
                    String installDir = (String)installationAttributes.get("install_dir");
                    boolean runAutoInstallScript = (Boolean)installationAttributes.get(XAMPPInstallProcessor.EXECUTE_SETUP_SCRIPT_ATTR);
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
                    subMonitor.beginTask(NLS.bind((String)Messages.InstallProcessor_installingTaskName, (Object)XAMPPInstallProcessor.XAMPP), -1);
                    IdeLog.logInfo((Plugin)PortalUIPlugin.getDefault(), (String)("Installing XAMPP into " + installDir));
                    IPath downloadPath = (IPath)XAMPPInstallProcessor.this.downloadedPaths.get(0);
                    IStatus fileLockStatus = LockUtils.waitForLockRelease((String)downloadPath.toOSString(), (long)10000L);
                    if (!fileLockStatus.isOK()) {
                        Status status = new Status(4, "com.aptana.portal.ui", NLS.bind((String)Messages.InstallProcessor_failedToInstallSeeLog, (Object)XAMPPInstallProcessor.XAMPP));
                        return status;
                    }
                    ArrayList<String> command = new ArrayList<String>(4);
                    command.add(downloadPath.toOSString());
                    command.add("-d" + installDir);
                    command.add("-s2");
                    if (runAutoInstallScript) {
                        command.add("-spauto");
                    }
                    if ((res = (process = (processBuilder = new ProcessBuilder(command)).start()).waitFor()) == 255) {
                        IdeLog.logInfo((Plugin)PortalUIPlugin.getDefault(), (String)"XAMPP installation cancelled");
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    if (res != 0) {
                        IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)("Failed to install XAMPP. The XAMPP installer process returned a termination code of " + res));
                        Status status = new Status(4, "com.aptana.portal.ui", res, NLS.bind((String)Messages.InstallProcessor_installationErrorMessage, (Object)XAMPPInstallProcessor.XAMPP, (Object)XAMPPInstallProcessor.XAMPP), null);
                        return status;
                    }
                    if (!new File(installDir).exists()) {
                        IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)("Failed to install XAMPP. The " + installDir + " directory was not created"));
                        Status status = new Status(4, "com.aptana.portal.ui", res, NLS.bind((String)Messages.InstallProcessor_installationError_installDirMissing, (Object)XAMPPInstallProcessor.XAMPP), null);
                        return status;
                    }
                    if (runAutoInstallScript) {
                        XAMPPInstallProcessor.this.openXAMPPConsole(String.valueOf(installDir) + XAMPPInstallProcessor.XAMPP_DEFAULT_FOLDER);
                    }
                    XAMPPInstallProcessor.this.finalizeInstallation(String.valueOf(installDir) + XAMPPInstallProcessor.XAMPP_DEFAULT_FOLDER);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
                    Status status = new Status(4, "com.aptana.portal.ui", NLS.bind((String)Messages.InstallProcessor_failedToInstallSeeLog, (Object)XAMPPInstallProcessor.XAMPP), (Throwable)e);
                    return status;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.schedule(1000L);
        try {
            job.join();
        }
        catch (InterruptedException e) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
            return Status.CANCEL_STATUS;
        }
        return job.getResult();
    }

    protected void openXAMPPConsole(final String installDir) {
        Job job = new Job(Messages.XAMPPInstallProcessor_openXAMPPConsoleJobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ProcessBuilder processBuilder = new ProcessBuilder(String.valueOf(installDir) + XAMPPInstallProcessor.XAMPP_CONTROL);
                    int attempts = 5;
                    long timeOut = 3000L;
                    Throwable lastException = null;
                    while (!monitor.isCanceled()) {
                        try {
                            processBuilder.start();
                            lastException = null;
                            break;
                        }
                        catch (Throwable t) {
                            lastException = t;
                            Thread.sleep(timeOut);
                            if (--attempts > 0) continue;
                        }
                    }
                    if (lastException != null) {
                        IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), lastException);
                    }
                }
                catch (Throwable t) {
                    IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)t);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule(3000L);
    }

    @Override
    protected void finalizeInstallation(String installDir) {
        block12: {
            super.finalizeInstallation(installDir);
            File propertiesFile = new File(installDir, ".aptana");
            Properties properties = new Properties();
            properties.put("xampp_install", this.urls[0]);
            FileOutputStream fileOutputStream = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream(propertiesFile);
                    properties.store(fileOutputStream, NLS.bind((String)Messages.InstallProcessor_aptanaInstallationComment, (Object)XAMPP));
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
                    if (fileOutputStream == null) break block12;
                    try {
                        fileOutputStream.flush();
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.flush();
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private class XAMPPInstallerOptionsDialog
    extends InstallerOptionsDialog {
        private Button executeScriptBt;

        public XAMPPInstallerOptionsDialog() {
            super(Display.getDefault().getActiveShell(), XAMPPInstallProcessor.XAMPP);
            this.setTitleImage(PortalUIPlugin.getDefault().getImageRegistry().get("/icons/wizban/xampp.png"));
        }

        protected void setAttributes() {
            this.attributes.put("install_dir", XAMPPInstallProcessor.this.installDir);
            this.attributes.put(XAMPPInstallProcessor.EXECUTE_SETUP_SCRIPT_ATTR, Boolean.TRUE);
        }

        protected Composite createInstallerGroupControls(Composite group) {
            Composite control = super.createInstallerGroupControls(group);
            this.executeScriptBt = new Button(group, 32);
            this.executeScriptBt.setText(Messages.XAMPPInstallProcessor_executeXAMPPAutoSetup);
            this.executeScriptBt.setSelection(true);
            this.executeScriptBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    XAMPPInstallerOptionsDialog.this.attributes.put(XAMPPInstallProcessor.EXECUTE_SETUP_SCRIPT_ATTR, XAMPPInstallerOptionsDialog.this.executeScriptBt.getSelection());
                }
            });
            return control;
        }
    }
}

