/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch.configurationProcessors.installer;

import com.aptana.core.CoreStrings;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.portal.ui.dispatch.configurationProcessors.Messages;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InstallerOptionsDialog
extends TitleAreaDialog {
    public static final String INSTALL_DIR_ATTR = "install_dir";
    protected Map<String, Object> attributes;
    protected Text path;
    private String installerName;
    private boolean createInstallDir;

    public InstallerOptionsDialog(Shell parentShell, String installerName) {
        this(parentShell, installerName, false);
    }

    public InstallerOptionsDialog(Shell parentShell, String installerName, boolean createInstallDir) {
        super(Display.getDefault().getActiveShell());
        this.installerName = installerName;
        this.setBlockOnOpen(true);
        this.setHelpAvailable(false);
        this.attributes = new HashMap<String, Object>();
        this.setAttributes();
        this.createInstallDir = createInstallDir;
    }

    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    protected abstract void setAttributes();

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.InstallProcessor_installerShellTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginLeft = 4;
        layout.marginRight = 4;
        layout.marginTop = 4;
        layout.marginBottom = 4;
        inner.setLayout((Layout)layout);
        Group group = new Group(inner, 0);
        group.setText(Messages.InstallProcessor_installerGroupTitle);
        group.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(1808);
        group.setLayoutData((Object)layoutData);
        this.createInstallerGroupControls((Composite)group);
        this.createExtendedControls(inner);
        this.setTitle(NLS.bind((String)Messages.InstallProcessor_installerTitle, (Object)this.installerName));
        return composite;
    }

    protected String getInstallerMessage() {
        return NLS.bind((String)Messages.InstallProcessor_installerMessage, (Object)this.installerName);
    }

    protected Composite createInstallerGroupControls(Composite group) {
        Label l = new Label(group, 64);
        l.setText(this.getInstallerMessage());
        Composite installLocation = new Composite(group, 0);
        installLocation.setLayoutData((Object)new GridData(768));
        installLocation.setLayout((Layout)new GridLayout(2, false));
        this.path = new Text(installLocation, 2052);
        this.path.setLayoutData((Object)new GridData(768));
        this.path.setText(this.attributes.get(INSTALL_DIR_ATTR).toString());
        this.path.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                InstallerOptionsDialog.this.attributes.put(InstallerOptionsDialog.INSTALL_DIR_ATTR, PlatformUtil.expandEnvironmentStrings((String)InstallerOptionsDialog.this.path.getText().trim()));
                InstallerOptionsDialog.this.validatePath();
            }

            public void keyPressed(KeyEvent e) {
                InstallerOptionsDialog.this.attributes.put(InstallerOptionsDialog.INSTALL_DIR_ATTR, PlatformUtil.expandEnvironmentStrings((String)InstallerOptionsDialog.this.path.getText().trim()));
                InstallerOptionsDialog.this.validatePath();
            }
        });
        Button browse = new Button(installLocation, 8);
        browse.setText(StringUtil.ellipsify((String)CoreStrings.BROWSE));
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dirDialog = new DirectoryDialog(InstallerOptionsDialog.this.getParentShell());
                String dir = dirDialog.open();
                if (dir != null) {
                    InstallerOptionsDialog.this.path.setText(dir);
                    InstallerOptionsDialog.this.attributes.put(InstallerOptionsDialog.INSTALL_DIR_ATTR, dir);
                    InstallerOptionsDialog.this.validatePath();
                }
            }
        });
        this.validatePath();
        return group;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validatePath();
    }

    protected void okPressed() {
        File f;
        if (this.createInstallDir && !(f = new File(PlatformUtil.expandEnvironmentStrings((String)this.path.getText()))).exists() && !f.mkdirs()) {
            MessageDialog.openError((Shell)this.getParentShell(), (String)Messages.InstallerOptionsDialog_creatingDirectoriesErrorTitle, (String)Messages.InstallerOptionsDialog_creatingDirectoriesErrorMessage);
            return;
        }
        super.okPressed();
    }

    protected void validatePath() {
        String pathText = this.path.getText().trim();
        if (pathText.length() == 0) {
            this.setErrorMessage(Messages.InstallerOptionsDialog_emptyPathError);
            return;
        }
        if (!new File(pathText = PlatformUtil.expandEnvironmentStrings((String)pathText)).exists()) {
            if (this.createInstallDir) {
                this.setMessage(Messages.InstallerOptionsDialog_inputDirectoryWillBeCreated, 1);
            } else {
                this.setErrorMessage(Messages.InstallerOptionsDialog_nonExistingPathError);
                return;
            }
        }
        this.setErrorMessage(null);
    }

    public void setErrorMessage(String newErrorMessage) {
        super.setErrorMessage(newErrorMessage);
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(newErrorMessage == null);
        }
    }

    protected Composite createExtendedControls(Composite parent) {
        return parent;
    }

    protected static String capitalize(String word) {
        if (word != null && word.length() > 0) {
            return String.valueOf(Character.toUpperCase(word.charAt(0))) + word.substring(1);
        }
        return word;
    }
}

