/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch.configurationProcessors.installer;

import com.aptana.core.CoreStrings;
import com.aptana.core.util.StringUtil;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.dispatch.configurationProcessors.Messages;
import com.aptana.portal.ui.dispatch.configurationProcessors.installer.InstallerOptionsDialog;
import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class JavaScriptImporterOptionsDialog
extends InstallerOptionsDialog {
    public static final String ACTIVE_PROJECT_ATTR = "active_project";
    private static final String RAILS_NATURE = "org.radrails.rails.core.railsnature";
    private static final String RAILS_JS_PATH = "/public/javascripts";
    private static final String JS_PATH = "/javascripts";
    private Combo projectsCombo;
    private Button useDefaultsButton;
    private Text path;
    private Label locationLb;
    private Button browseBt;
    private String selectedLocation;

    public JavaScriptImporterOptionsDialog(Shell parentShell, String libraryName) {
        super(Display.getDefault().getActiveShell(), JavaScriptImporterOptionsDialog.capitalize(libraryName));
        this.setTitleImage(PortalUIPlugin.getDefault().getImageRegistry().get("/icons/wizban/js.png"));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.InstallProcessor_installerShellTitle);
    }

    protected void setAttributes() {
        this.attributes.put(ACTIVE_PROJECT_ATTR, PortalUIPlugin.getActiveProject());
    }

    public String getSelectedLocation() {
        return this.selectedLocation;
    }

    protected void okPressed() {
        this.selectedLocation = this.path.getText();
        super.okPressed();
    }

    public void setErrorMessage(String newErrorMessage) {
        super.setErrorMessage(newErrorMessage);
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(newErrorMessage == null);
        }
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.validatePath();
        return c;
    }

    protected Composite createInstallerGroupControls(Composite group) {
        int columns = 3;
        Composite projectGroup = new Composite(group, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectSelectionLable = new Label(projectGroup, 0);
        projectSelectionLable.setText(Messages.ImportJavaScriptLibraryDialog_projectLable);
        this.projectsCombo = new Combo(projectGroup, 12);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.projectsCombo.setLayoutData((Object)gd);
        this.useDefaultsButton = new Button(projectGroup, 131104);
        this.useDefaultsButton.setText(Messages.ImportJavaScriptLibraryDialog_useDefaultLocation);
        this.useDefaultsButton.setSelection(true);
        gd = new GridData();
        gd.horizontalSpan = columns;
        this.useDefaultsButton.setLayoutData((Object)gd);
        this.createUserPathArea(projectGroup, true);
        this.useDefaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useDefaults = JavaScriptImporterOptionsDialog.this.useDefaultsButton.getSelection();
                JavaScriptImporterOptionsDialog.this.path.setText(TextProcessor.process((String)JavaScriptImporterOptionsDialog.this.getDefaultPath()));
                JavaScriptImporterOptionsDialog.this.setPathAreaEnabled(!useDefaults);
            }
        });
        this.setPathAreaEnabled(false);
        this.initProjectsCombo(this.projectsCombo);
        return group;
    }

    private void initProjectsCombo(final Combo combo) {
        String activeProjectName;
        IProject[] allProjects;
        IProject[] iProjectArray = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                combo.add(project.getName());
                combo.setData(project.getName(), (Object)project);
            }
            ++n2;
        }
        if (combo.getItemCount() == 0) {
            return;
        }
        IProject activeProject = PortalUIPlugin.getActiveProject();
        String string = activeProjectName = activeProject != null ? activeProject.getName() : null;
        if (activeProject != null && activeProject.isAccessible()) {
            int index = combo.indexOf(activeProjectName);
            combo.select(Math.max(0, index));
            this.attributes.put(ACTIVE_PROJECT_ATTR, activeProject);
        } else if (combo.getItemCount() > 0) {
            combo.select(0);
            this.attributes.put(ACTIVE_PROJECT_ATTR, combo.getData(combo.getText()));
        }
        this.path.setText(TextProcessor.process((String)this.getDefaultPath()));
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaScriptImporterOptionsDialog.this.attributes.put(JavaScriptImporterOptionsDialog.ACTIVE_PROJECT_ATTR, combo.getData(combo.getText()));
                JavaScriptImporterOptionsDialog.this.path.setText(TextProcessor.process((String)JavaScriptImporterOptionsDialog.this.getDefaultPath()));
            }
        });
    }

    private void createUserPathArea(Composite composite, boolean defaultEnabled) {
        this.locationLb = new Label(composite, 0);
        this.locationLb.setText(Messages.ImportJavaScriptLibraryDialog_locationLabel);
        this.path = new Text(composite, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.path.setLayoutData((Object)data);
        this.browseBt = new Button(composite, 8);
        this.browseBt.setText(StringUtil.ellipsify((String)CoreStrings.BROWSE));
        this.browseBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(JavaScriptImporterOptionsDialog.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setBlockOnOpen(true);
                dialog.setAllowMultiple(false);
                dialog.setHelpAvailable(false);
                dialog.setTitle(Messages.ImportJavaScriptLibraryDialog_folderSelectionDialogTitle);
                dialog.setMessage(Messages.ImportJavaScriptLibraryDialog_folderSelectionDialogMessage);
                final IProject project = (IProject)JavaScriptImporterOptionsDialog.this.attributes.get(JavaScriptImporterOptionsDialog.ACTIVE_PROJECT_ATTR);
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                dialog.addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        if (parentElement instanceof IResource) {
                            if (element instanceof IProject) {
                                return element.equals(project);
                            }
                            IProject parentProject = ((IResource)parentElement).getProject();
                            if (!parentProject.equals((Object)project)) {
                                return false;
                            }
                            if (element instanceof IResource) {
                                IResource resource = (IResource)element;
                                if (resource.isHidden()) {
                                    return false;
                                }
                                if (resource.getLocation().toFile().isDirectory()) {
                                    return true;
                                }
                            }
                        }
                        return false;
                    }
                });
                int buttonId = dialog.open();
                if (buttonId == 0) {
                    IResource resource = (IResource)dialog.getFirstResult();
                    JavaScriptImporterOptionsDialog.this.path.setText(TextProcessor.process((String)(String.valueOf(project.getName()) + '/' + resource.getProjectRelativePath().toString())));
                }
            }
        });
        this.path.setText(TextProcessor.process((String)this.getDefaultPath()));
        this.path.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaScriptImporterOptionsDialog.this.validatePath();
            }
        });
    }

    protected String getDefaultPath() {
        IProject project = (IProject)this.attributes.get(ACTIVE_PROJECT_ATTR);
        if (project == null) {
            return "";
        }
        boolean isRails = false;
        try {
            isRails = project.hasNature(RAILS_NATURE);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return String.valueOf(project.getName()) + (isRails ? RAILS_JS_PATH : JS_PATH);
    }

    protected void validatePath() {
        IProject project;
        String pathString = this.path.getText();
        String errorMsg = null;
        if (this.projectsCombo.getItemCount() == 0) {
            errorMsg = Messages.ImportJavaScriptLibraryDialog_noAccessibleProjectsError;
        }
        if (errorMsg == null && pathString.length() == 0) {
            errorMsg = Messages.ImportJavaScriptLibraryDialog_emptyPathError;
        }
        URI uri = URIUtil.toURI((String)pathString);
        if (errorMsg == null && uri == null) {
            errorMsg = Messages.ImportJavaScriptLibraryDialog_invalidPathError;
        }
        if (errorMsg == null && (project = (IProject)this.attributes.get(ACTIVE_PROJECT_ATTR)) != null) {
            String projectPath = project.getFullPath().toString();
            String uriPath = uri.getPath();
            if (uriPath != null && !uriPath.startsWith("/")) {
                uriPath = String.valueOf('/') + uriPath;
            }
            if (uriPath == null || !uriPath.startsWith(String.valueOf(projectPath) + '/')) {
                errorMsg = Messages.ImportJavaScriptLibraryDialog_wrongProjectRootError;
            }
        }
        this.setErrorMessage(errorMsg);
    }

    private void setPathAreaEnabled(boolean enabled) {
        this.locationLb.setEnabled(enabled);
        this.path.setEnabled(enabled);
        this.browseBt.setEnabled(enabled);
    }
}

