/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.URLUtil;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.browser.AbstractPortalBrowserEditor;
import com.aptana.theme.IThemeManager;
import com.aptana.theme.ThemePlugin;
import com.aptana.ui.util.UIUtils;
import com.aptana.usage.UsagePlugin;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.browser.WebBrowserEditorInput;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Portal {
    public static final String BASE_URL_PREFIX = "http://toolbox.aptana.com/toolbox";
    protected static final String BASE_REMOTE_URL = "http://toolbox.aptana.com/toolbox";
    protected static final String BASE_LOCAL_URL = "/content/index.html";
    public static final String ACTIVE_PROJECT_KEY = "activeProject";
    protected static final String RAILS_NATURE = "org.radrails.rails.core.railsnature";
    protected static final String PHP_NATURE = "com.aptana.editor.php.phpnature";
    protected static final String WEB_NATURE = "com.aptana.projects.webnature";
    protected static final String PYDEV_NATURE = "org.python.pydev.pythonNature";
    private final Map<String, AbstractPortalBrowserEditor> portalBrowsers = new HashMap<String, AbstractPortalBrowserEditor>();
    private static Portal instance;

    private Portal() {
    }

    public static Portal getInstance() {
        if (instance == null) {
            instance = new Portal();
        }
        return instance;
    }

    public boolean shouldOpenPortal() {
        IPreferenceStore preferenceStore = PortalUIPlugin.getDefault().getPreferenceStore();
        return preferenceStore.getBoolean("open_developer_toolbox");
    }

    public void openPortal(URL url, String browserEditorId) {
        this.openPortal(url, browserEditorId, true, null);
    }

    public void openPortal(URL url, final String browserEditorId, final boolean bringToTop, Map<String, String> additionalParameters) {
        try {
            if (url == null) {
                url = this.getDefaultURL();
            } else if (!this.isConnected(url)) {
                URL localURL = FileLocator.toFileURL((URL)Portal.class.getResource(BASE_LOCAL_URL));
                url = URLUtil.appendParameters((URL)localURL, (String[])new String[]{"url", url.toString()});
            }
            Map<String, String> parameters = this.getURLParametersForProject(PortalUIPlugin.getActiveProject());
            if (additionalParameters != null) {
                parameters.putAll(additionalParameters);
            }
            url = URLUtil.appendParameters((URL)url, parameters, (boolean)false);
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
            return;
        }
        final URL finalURL = url;
        UIJob job = new UIJob("Launching the Studio portal..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IEditorPart activeEditor;
                IEditorReference[] refs;
                IWorkbenchWindow workbenchWindow = UIUtils.getActiveWorkbenchWindow();
                if (workbenchWindow == null) {
                    return Status.OK_STATUS;
                }
                IWorkbenchPage activePage = workbenchWindow.getActivePage();
                IEditorReference[] iEditorReferenceArray = refs = activePage.getEditorReferences();
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference ref = iEditorReferenceArray[n2];
                    String editorId = ref.getId();
                    if ("org.eclipse.ui.internal.emptyEditorTab".equals(editorId)) {
                        activePage.closeEditors(new IEditorReference[]{ref}, false);
                    }
                    ++n2;
                }
                AbstractPortalBrowserEditor portalBrowser = (AbstractPortalBrowserEditor)((Object)Portal.this.portalBrowsers.get(browserEditorId));
                if (portalBrowser != null && !portalBrowser.isDisposed()) {
                    IEditorSite editorSite = portalBrowser.getEditorSite();
                    IWorkbenchPart part = editorSite.getPart();
                    editorSite.getPage().activate(part);
                    portalBrowser.setURL(finalURL);
                    return Status.OK_STATUS;
                }
                WebBrowserEditorInput input = new WebBrowserEditorInput(finalURL, 0, "com.aptana.portal.main");
                IWorkbenchPage page = UIUtils.getActivePage();
                if (page == null) {
                    IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)"Cannot open the Studio portal page. No active workbench page is found.");
                    return Status.CANCEL_STATUS;
                }
                if (!bringToTop && (activeEditor = page.getActiveEditor()) != null) {
                    try {
                        IEditorReference[] editors = page.openEditors(new IEditorInput[]{activeEditor.getEditorInput(), input}, new String[]{activeEditor.getEditorSite().getId(), browserEditorId}, 1);
                        portalBrowser = (AbstractPortalBrowserEditor)editors[1].getEditor(true);
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)"Could not open the Studio portal as a 'non-focused' editor", (Throwable)e);
                    }
                }
                try {
                    if (portalBrowser == null) {
                        portalBrowser = (AbstractPortalBrowserEditor)page.openEditor((IEditorInput)input, browserEditorId);
                    }
                    if (portalBrowser != null) {
                        portalBrowser.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                Portal.this.portalBrowsers.remove(browserEditorId);
                            }
                        });
                    }
                }
                catch (PartInitException e) {
                    IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)"Failed to open the Studio portal", (Throwable)e);
                }
                if (portalBrowser != null) {
                    Portal.this.portalBrowsers.put(browserEditorId, portalBrowser);
                }
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.schedule();
    }

    protected URL getDefaultURL() throws IOException {
        return this.getDefaultURL(new URL("http://toolbox.aptana.com/toolbox"), Portal.class.getResource(BASE_LOCAL_URL));
    }

    protected URL getDefaultURL(URL desiredUrl, URL fallbackUrl) throws IOException {
        if (fallbackUrl == null) {
            throw new IllegalArgumentException("Fallback URL must not be null");
        }
        if (this.isConnected(desiredUrl)) {
            return desiredUrl;
        }
        return FileLocator.toFileURL((URL)fallbackUrl);
    }

    private boolean isConnected(URL url) {
        boolean connected = false;
        HttpURLConnection connection = null;
        try {
            if ("file".equalsIgnoreCase(url.getProtocol())) {
                return true;
            }
            try {
                connection = this.getConnection(url);
                connection.setConnectTimeout(4000);
                connection.setRequestMethod("HEAD");
                connection.setAllowUserInteraction(false);
                connection.connect();
                connected = true;
            }
            catch (Exception e) {
                connected = false;
                IdeLog.logWarning((Plugin)PortalUIPlugin.getDefault(), (String)"Could not establish a connection to the remote portal. Using the local content.", (Throwable)e);
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return connected;
    }

    protected HttpsURLConnection getConnection(URL httpsURL) throws Exception {
        SSLContext sc = SSLContext.getInstance("TLSv1.2");
        sc.init(null, null, new SecureRandom());
        HttpsURLConnection con = (HttpsURLConnection)httpsURL.openConnection();
        con.setSSLSocketFactory(sc.getSocketFactory());
        return con;
    }

    protected Map<String, String> getURLParametersForProject(IProject activeProject) {
        final HashMap<String, String> builder = new HashMap<String, String>();
        builder.putAll(URLUtil.getDefaultParameters());
        builder.put("bg", this.toHex(this.getThemeManager().getCurrentTheme().getBackground()));
        builder.put("fg", this.toHex(this.getThemeManager().getCurrentTheme().getForeground()));
        UIUtils.getDisplay().syncExec(new Runnable(){

            public void run() {
                Color color = PlatformUI.getWorkbench().getDisplay().getSystemColor(22);
                builder.put("ch", Portal.this.toHex(color.getRGB()));
            }
        });
        builder.put("p", String.valueOf(this.getProjectType(activeProject)));
        builder.put("ts", String.valueOf(System.currentTimeMillis()));
        builder.put("id", this.getGUID());
        builder.putAll(this.getDeployParam(activeProject));
        return builder;
    }

    protected Map<String, String> getDeployParam(IProject selectedProject) {
        HashMap<String, String> builder = new HashMap<String, String>();
        if (selectedProject != null && selectedProject.exists()) {
            IFile file = selectedProject.getFile("deploy/default.rb");
            if (file.exists()) {
                builder.put("dep", "ch");
            }
            if ((file = selectedProject.getFile("deploy/solo.rb")).exists()) {
                builder.put("dep", "cs");
            }
            if ((file = selectedProject.getFile("Capfile")).exists()) {
                builder.put("dep", "cap");
            }
            if ((file = selectedProject.getFile("capfile")).exists()) {
                builder.put("dep", "cap");
            }
        }
        return builder;
    }

    protected IThemeManager getThemeManager() {
        return ThemePlugin.getDefault().getThemeManager();
    }

    protected String getGUID() {
        return UsagePlugin.getApplicationId();
    }

    protected char getProjectType(IProject selectedProject) {
        if (selectedProject != null && selectedProject.isAccessible()) {
            block9: {
                block8: {
                    block7: {
                        if (!selectedProject.hasNature(WEB_NATURE)) break block7;
                        return 'W';
                    }
                    if (!selectedProject.hasNature(RAILS_NATURE)) break block8;
                    return 'R';
                }
                if (!selectedProject.hasNature(PHP_NATURE)) break block9;
                return 'P';
            }
            try {
                if (selectedProject.hasNature(PYDEV_NATURE)) {
                    return 'D';
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
            }
        }
        return 'O';
    }

    private String toHex(RGB rgb) {
        return MessageFormat.format("{0}{1}{2}", StringUtil.pad((String)Integer.toHexString(rgb.red), (int)2, (char)'0'), StringUtil.pad((String)Integer.toHexString(rgb.green), (int)2, (char)'0'), StringUtil.pad((String)Integer.toHexString(rgb.blue), (int)2, (char)'0'));
    }
}

