/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.yaml;

import com.aptana.editor.common.text.rules.ExtendedWordRule;
import com.aptana.editor.common.text.rules.SingleCharacterRule;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YAMLCodeScanner
extends BufferedRuleBasedScanner {
    public YAMLCodeScanner() {
        List<IRule> rules = this.createRules();
        this.setRules(rules.toArray(new IRule[rules.size()]));
        this.setDefaultReturnToken((IToken)new Token((Object)"string.unquoted.yaml"));
    }

    protected List<IRule> createRules() {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        ExtendedWordRule rule = new YAMLKeyRule(new YAMLKeyDetector(), (IToken)new Token((Object)"entity.name.tag.yaml"), false);
        rule.setColumnConstraint(0);
        rules.add((IRule)rule);
        rule = new WordRule((IWordDetector)new YAMLVariableDetector(), (IToken)new Token((Object)"variable.other.yaml"));
        rules.add((IRule)rule);
        rule = new YAMLNumberRule(new YAMLNumberDetector(), (IToken)new Token((Object)"constant.numeric.yaml"), false);
        rules.add((IRule)rule);
        rule = new YAMLDateRule(new YAMLDateDetector(), (IToken)new Token((Object)"constant.other.date.yaml"), false);
        rules.add((IRule)rule);
        rule = new WordRule((IWordDetector)new YAMLUnquotedWordDetector(), (IToken)new Token((Object)"string.unquoted.yaml"));
        rules.add((IRule)rule);
        rule = new YAMLDirectiveSeparatorRule((IToken)new Token((Object)"meta.separator.yaml"));
        rules.add((IRule)rule);
        rule = new YAMLDocumentSeparatorRule((IToken)new Token((Object)"meta.separator.yaml"));
        rules.add((IRule)rule);
        rules.add((IRule)new SingleCharacterRule('-', (IToken)new Token((Object)"keyword.operator.symbol")));
        return rules;
    }

    private static final class SingleCharacterDetector
    implements IWordDetector {
        private char fChar;

        SingleCharacterDetector(char c) {
            this.fChar = c;
        }

        public boolean isWordStart(char c) {
            return c == this.fChar;
        }

        public boolean isWordPart(char c) {
            return c == this.fChar;
        }
    }

    private static class YAMLDateDetector
    implements IWordDetector {
        private YAMLDateDetector() {
        }

        public boolean isWordStart(char c) {
            return Character.isDigit(c);
        }

        public boolean isWordPart(char c) {
            return this.isWordStart(c) || c == '-';
        }
    }

    private static final class YAMLDateRule
    extends ExtendedWordRule {
        private Pattern pattern;

        private YAMLDateRule(IWordDetector detector, IToken defaultToken, boolean ignoreCase) {
            super(detector, defaultToken, ignoreCase);
        }

        protected boolean wordOK(String word, ICharacterScanner scanner) {
            if (word.length() != 10) {
                return false;
            }
            return this.getPattern().matcher(word).matches();
        }

        private synchronized Pattern getPattern() {
            if (this.pattern == null) {
                this.pattern = Pattern.compile("([0-9]{4}-[0-9]{2}-[0-9]{2})");
            }
            return this.pattern;
        }
    }

    private static final class YAMLDirectiveSeparatorRule
    extends ExtendedWordRule {
        private YAMLDirectiveSeparatorRule(IToken defaultToken) {
            super((IWordDetector)new SingleCharacterDetector('-'), defaultToken, false);
            this.setColumnConstraint(0);
        }

        protected boolean wordOK(String word, ICharacterScanner scanner) {
            return word.length() == 3;
        }
    }

    private static final class YAMLDocumentSeparatorRule
    extends ExtendedWordRule {
        private YAMLDocumentSeparatorRule(IToken defaultToken) {
            super((IWordDetector)new SingleCharacterDetector('.'), defaultToken, false);
            this.setColumnConstraint(0);
        }

        protected boolean wordOK(String word, ICharacterScanner scanner) {
            return word.length() == 3;
        }
    }

    private static class YAMLKeyDetector
    implements IWordDetector {
        boolean stop = false;

        private YAMLKeyDetector() {
        }

        public boolean isWordStart(char c) {
            this.stop = false;
            switch (c) {
                case '\n': 
                case '\r': 
                case ',': 
                case ':': 
                case '?': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    return false;
                }
            }
            return true;
        }

        public boolean isWordPart(char c) {
            if (this.stop) {
                this.stop = false;
                return false;
            }
            switch (c) {
                case ':': {
                    this.stop = true;
                    return true;
                }
                case '\n': 
                case '\r': 
                case ',': 
                case '?': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    return false;
                }
            }
            return true;
        }
    }

    private static final class YAMLKeyRule
    extends ExtendedWordRule {
        private YAMLKeyRule(IWordDetector detector, IToken defaultToken, boolean ignoreCase) {
            super(detector, defaultToken, ignoreCase);
        }

        protected boolean wordOK(String word, ICharacterScanner scanner) {
            return word.length() >= 2 && word.charAt(word.length() - 1) == ':';
        }
    }

    private static class YAMLNumberDetector
    implements IWordDetector {
        private YAMLNumberDetector() {
        }

        public boolean isWordStart(char c) {
            return Character.isDigit(c) || c == '.' || c == '-' || c == '+';
        }

        public boolean isWordPart(char c) {
            if (this.isWordStart(c)) {
                return true;
            }
            return (c = Character.toLowerCase(c)) == 'x' || c == 'a' || c == 'b' || c == 'c' || c == 'd' || c == 'e' || c == 'f' || c == 'l' || c == 'u' || c == 'o';
        }
    }

    private static final class YAMLNumberRule
    extends ExtendedWordRule {
        private Pattern pattern;

        private YAMLNumberRule(IWordDetector detector, IToken defaultToken, boolean ignoreCase) {
            super(detector, defaultToken, ignoreCase);
        }

        protected boolean wordOK(String word, ICharacterScanner scanner) {
            return this.getPattern().matcher(word).matches();
        }

        private synchronized Pattern getPattern() {
            if (this.pattern == null) {
                this.pattern = Pattern.compile("(\\+|-)?((0(x|X|o|O)[0-9a-fA-F]*)|(([0-9]+\\.?[0-9]*)|(\\.[0-9]+))((e|E)(\\+|-)?[0-9]+)?)(L|l|UL|ul|u|U|F|f)?");
            }
            return this.pattern;
        }
    }

    private static final class YAMLUnquotedWordDetector
    implements IWordDetector {
        private YAMLUnquotedWordDetector() {
        }

        public boolean isWordStart(char c) {
            return Character.isLetterOrDigit(c);
        }

        public boolean isWordPart(char c) {
            return this.isWordStart(c) || c == '-' || c == '_' || c == '/' || c == '.';
        }
    }

    private static class YAMLVariableDetector
    implements IWordDetector {
        private YAMLVariableDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '&' || c == '*';
        }

        public boolean isWordPart(char c) {
            return Character.isLetterOrDigit(c) || c == '_' || c == '-';
        }
    }
}

