/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.svg;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.TextUtils;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.text.SingleTokenScanner;
import com.aptana.editor.common.text.rules.CommentScanner;
import com.aptana.editor.common.text.rules.ExtendedToken;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.TagRule;
import com.aptana.editor.common.text.rules.ThemeingDamagerRepairer;
import com.aptana.editor.css.CSSSourceConfiguration;
import com.aptana.editor.js.JSSourceConfiguration;
import com.aptana.editor.svg.SVGSubPartitionerScanner;
import com.aptana.editor.svg.contentassist.SVGContentAssistProcessor;
import com.aptana.editor.xml.XMLScanner;
import com.aptana.editor.xml.XMLTagScanner;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.source.ISourceViewer;

public class SVGSourceConfiguration
implements IPartitioningConfiguration,
ISourceViewerConfiguration {
    public static final String PREFIX = "__svg_";
    public static final String DEFAULT = "__svg__dftl_partition_content_type";
    public static final String COMMENT = "__svg_comment";
    public static final String CDATA = "__svg_cdata";
    public static final String PRE_PROCESSOR = "__svg_processing_instruction";
    public static final String TAG = "__svg_tag";
    public static final String DOCTYPE = "__svg_doctype";
    public static final String SCRIPT = "__svg_script";
    public static final String STYLE = "__svg_style";
    public static final String[] CONTENT_TYPES = new String[]{"__svg__dftl_partition_content_type", "__svg_comment", "__svg_cdata", "__svg_processing_instruction", "__svg_doctype", "__svg_script", "__svg_style", "__svg_tag"};
    private static final String[][] TOP_CONTENT_TYPES = new String[][]{{"com.aptana.contenttype.svg"}, {"com.aptana.contenttype.svg", "com.aptana.contenttype.js"}, {"com.aptana.contenttype.svg", "com.aptana.contenttype.css"}};
    private IPredicateRule[] partitioningRules = new IPredicateRule[]{new MultiLineRule("<!DOCTYPE", ">", SVGSourceConfiguration.getToken("__svg_cdata")), new MultiLineRule("<?", "?>", SVGSourceConfiguration.getToken("__svg_processing_instruction")), new MultiLineRule("<!--", "-->", SVGSourceConfiguration.getToken("__svg_comment"), '\u0000', true), new MultiLineRule("<![CDATA[", "]]>", SVGSourceConfiguration.getToken("__svg_cdata")), new TagRule("script", (IToken)new ExtendedToken(SVGSourceConfiguration.getToken("__svg_script"))), new TagRule("style", (IToken)new ExtendedToken(SVGSourceConfiguration.getToken("__svg_style"))), new TagRule("/", SVGSourceConfiguration.getToken("__svg_tag")), new TagRule((IToken)new ExtendedToken(SVGSourceConfiguration.getToken("__svg_tag")))};
    private static SVGSourceConfiguration instance;

    static {
        IContentTypeTranslator c = CommonEditorPlugin.getDefault().getContentTypeTranslator();
        c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.svg"}), new QualifiedContentType(new String[]{"text.xml.svg"}));
        c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.svg", "com.aptana.contenttype.js"}), new QualifiedContentType(new String[]{"text.xml.svg", "source.js.embedded.svg"}));
        c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.svg", "com.aptana.contenttype.css"}), new QualifiedContentType(new String[]{"text.xml.svg", "source.css.embedded.svg"}));
        c.addTranslation(new QualifiedContentType(new String[]{COMMENT}), new QualifiedContentType(new String[]{"comment.block.xml.svg"}));
        c.addTranslation(new QualifiedContentType(new String[]{PRE_PROCESSOR}), new QualifiedContentType(new String[]{"meta.tag.preprocessor.xml.svg"}));
        c.addTranslation(new QualifiedContentType(new String[]{TAG}), new QualifiedContentType(new String[]{"meta.tag.xml.svg"}));
        c.addTranslation(new QualifiedContentType(new String[]{SCRIPT}), new QualifiedContentType(new String[]{"meta.tag.block.any.xml.svg"}));
        c.addTranslation(new QualifiedContentType(new String[]{STYLE}), new QualifiedContentType(new String[]{"meta.tag.block.any.xml.svg"}));
        c.addTranslation(new QualifiedContentType(new String[]{CDATA}), new QualifiedContentType(new String[]{"string.unquoted.cdata.xml.svg"}));
        c.addTranslation(new QualifiedContentType(new String[]{DOCTYPE}), new QualifiedContentType(new String[]{"meta.tag.sgml.doctype.xml.svg"}));
    }

    private SVGSourceConfiguration() {
    }

    public static SVGSourceConfiguration getDefault() {
        if (instance == null) {
            instance = new SVGSourceConfiguration();
        }
        return instance;
    }

    public ISubPartitionScanner createSubPartitionScanner() {
        return new SVGSubPartitionerScanner();
    }

    private ITokenScanner getCDATAScanner() {
        return new SingleTokenScanner(SVGSourceConfiguration.getToken("string.unquoted.cdata.xml.svg"));
    }

    private ITokenScanner getCommentScanner() {
        return new CommentScanner(SVGSourceConfiguration.getToken("comment.block.xml.svg"));
    }

    public String[] getContentTypes() {
        return TextUtils.combine((String[][])new String[][]{CONTENT_TYPES, JSSourceConfiguration.CONTENT_TYPES, CSSSourceConfiguration.CONTENT_TYPES});
    }

    public String getDocumentContentType(String contentType) {
        if (contentType.startsWith(PREFIX)) {
            return "org.eclipse.core.runtime.xml";
        }
        String result = JSSourceConfiguration.getDefault().getDocumentContentType(contentType);
        if (result == null) {
            result = CSSSourceConfiguration.getDefault().getDocumentContentType(contentType);
        }
        return result;
    }

    public IPredicateRule[] getPartitioningRules() {
        return this.partitioningRules;
    }

    private ITokenScanner getPreProcessorScanner() {
        XMLTagScanner preProcessorScanner = new XMLTagScanner();
        preProcessorScanner.setDefaultReturnToken(SVGSourceConfiguration.getToken("meta.tag.preprocessor.xml.svg"));
        return preProcessorScanner;
    }

    private static IToken getToken(String tokenName) {
        return CommonUtil.getToken((String)tokenName);
    }

    public String[][] getTopContentTypes() {
        return TOP_CONTENT_TYPES;
    }

    private ITokenScanner getXMLScanner() {
        return new XMLScanner();
    }

    private ITokenScanner getXMLTagScanner() {
        return new XMLTagScanner();
    }

    public void setupPresentationReconciler(PresentationReconciler reconciler, ISourceViewer sourceViewer) {
        JSSourceConfiguration.getDefault().setupPresentationReconciler(reconciler, sourceViewer);
        CSSSourceConfiguration.getDefault().setupPresentationReconciler(reconciler, sourceViewer);
        ThemeingDamagerRepairer dr = new ThemeingDamagerRepairer(this.getXMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)dr, DEFAULT);
        reconciler.setRepairer((IPresentationRepairer)dr, DEFAULT);
        ThemeingDamagerRepairer preprocessorScanner = new ThemeingDamagerRepairer(this.getPreProcessorScanner());
        reconciler.setDamager((IPresentationDamager)preprocessorScanner, PRE_PROCESSOR);
        reconciler.setRepairer((IPresentationRepairer)preprocessorScanner, PRE_PROCESSOR);
        ThemeingDamagerRepairer cdataScanner = new ThemeingDamagerRepairer(this.getCDATAScanner());
        reconciler.setDamager((IPresentationDamager)cdataScanner, CDATA);
        reconciler.setRepairer((IPresentationRepairer)cdataScanner, CDATA);
        ThemeingDamagerRepairer tagScanner = new ThemeingDamagerRepairer(this.getXMLTagScanner());
        reconciler.setDamager((IPresentationDamager)tagScanner, SCRIPT);
        reconciler.setRepairer((IPresentationRepairer)tagScanner, SCRIPT);
        reconciler.setDamager((IPresentationDamager)tagScanner, STYLE);
        reconciler.setRepairer((IPresentationRepairer)tagScanner, STYLE);
        reconciler.setDamager((IPresentationDamager)tagScanner, TAG);
        reconciler.setRepairer((IPresentationRepairer)tagScanner, TAG);
        ThemeingDamagerRepairer commentScanner = new ThemeingDamagerRepairer(this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)commentScanner, "__xml_comment");
        reconciler.setRepairer((IPresentationRepairer)commentScanner, "__xml_comment");
    }

    public IContentAssistProcessor getContentAssistProcessor(AbstractThemeableEditor editor, String contentType) {
        if (contentType.startsWith("__js_")) {
            return JSSourceConfiguration.getDefault().getContentAssistProcessor(editor, contentType);
        }
        if (contentType.startsWith("__css_")) {
            return CSSSourceConfiguration.getDefault().getContentAssistProcessor(editor, contentType);
        }
        return new SVGContentAssistProcessor(editor);
    }
}

