/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.s3;

import com.amazon.s3.Response;
import com.amazon.s3.Utils;
import java.io.IOException;
import java.net.HttpURLConnection;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class LocationResponse
extends Response {
    String location;

    public LocationResponse(HttpURLConnection connection) throws IOException {
        super(connection);
        if (connection.getResponseCode() < 400) {
            try {
                XMLReader xr = Utils.createXMLReader();
                LocationResponseHandler handler = new LocationResponseHandler();
                xr.setContentHandler(handler);
                xr.setErrorHandler(handler);
                xr.parse(new InputSource(connection.getInputStream()));
                this.location = handler.location;
            }
            catch (SAXException e) {
                throw new RuntimeException("Unexpected error parsing ListAllMyBuckets xml", e);
            }
        } else {
            this.location = "<error>";
        }
    }

    public String getLocation() {
        return this.location;
    }

    static class LocationResponseHandler
    extends DefaultHandler {
        String location = null;
        private StringBuffer currText = null;

        LocationResponseHandler() {
        }

        public void startDocument() {
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("LocationConstraint")) {
                this.currText = new StringBuffer();
            }
        }

        public void endElement(String uri, String name, String qName) {
            if (name.equals("LocationConstraint")) {
                this.location = this.currText.toString();
                this.currText = null;
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (this.currText != null) {
                this.currText.append(ch, start, length);
            }
        }
    }
}

