/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.ruby;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.text.SingleTokenScanner;
import com.aptana.editor.common.text.rules.CommentScanner;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.PartitionerSwitchingIgnoreRule;
import com.aptana.editor.common.text.rules.SubPartitionScanner;
import com.aptana.editor.common.text.rules.ThemeingDamagerRepairer;
import com.aptana.editor.ruby.RubyCodeScanner;
import com.aptana.editor.ruby.RubyRegexpScanner;
import com.aptana.editor.ruby.internal.contentassist.RubyCommentContentAssistProcessor;
import com.aptana.editor.ruby.internal.contentassist.RubyContentAssistProcessor;
import com.aptana.editor.ruby.internal.contentassist.RubyDoubleQuotedStringContentAssistProcessor;
import com.aptana.editor.ruby.internal.contentassist.RubyRegexpContentAssistProcessor;
import com.aptana.editor.ruby.internal.text.LineContinuationDamagerRepairer;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.source.ISourceViewer;

public class RubySourceConfiguration
implements IPartitioningConfiguration,
ISourceViewerConfiguration {
    public static final String PREFIX = "__rb_";
    public static final String DEFAULT = "__rb__dftl_partition_content_type";
    public static final String SINGLE_LINE_COMMENT = "__rb_singleline_comment";
    public static final String MULTI_LINE_COMMENT = "__rb_multiline_comment";
    public static final String REGULAR_EXPRESSION = "__rb_regular_expression";
    public static final String COMMAND = "__rb_command";
    public static final String STRING_SINGLE = "__rb_string_single";
    public static final String STRING_DOUBLE = "__rb_string_double";
    public static final String[] CONTENT_TYPES = new String[]{"__rb__dftl_partition_content_type", "__rb_singleline_comment", "__rb_multiline_comment", "__rb_regular_expression", "__rb_command", "__rb_string_single", "__rb_string_double"};
    private static final String[] SPELLING_CONTENT_TYPES = new String[]{"__rb_singleline_comment", "__rb_multiline_comment", "__rb_string_single", "__rb_string_double"};
    private static final String[][] TOP_CONTENT_TYPES = new String[][]{{"com.aptana.contenttype.ruby"}};
    private final IPredicateRule[] partitioningRules = new IPredicateRule[]{new PartitionerSwitchingIgnoreRule((IPredicateRule)new EndOfLineRule("#", RubySourceConfiguration.getToken("__rb_singleline_comment"))), new PartitionerSwitchingIgnoreRule((IPredicateRule)new MultiLineRule("=begin", "=end", RubySourceConfiguration.getToken("__rb_multiline_comment"), '\u0000', true)), new SingleLineRule("/", "/", RubySourceConfiguration.getToken("__rb_regular_expression"), '\\'), new SingleLineRule("\"", "\"", RubySourceConfiguration.getToken("__rb_string_double"), '\\'), new SingleLineRule("'", "'", RubySourceConfiguration.getToken("__rb_string_single"), '\\')};
    private static RubySourceConfiguration instance;

    static {
        IContentTypeTranslator c = CommonEditorPlugin.getDefault().getContentTypeTranslator();
        c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.ruby"}), new QualifiedContentType(new String[]{"source.ruby.rails"}));
        c.addTranslation(new QualifiedContentType(new String[]{STRING_SINGLE}), new QualifiedContentType(new String[]{"string.quoted.single.ruby"}));
        c.addTranslation(new QualifiedContentType(new String[]{STRING_DOUBLE}), new QualifiedContentType(new String[]{"string.quoted.double.ruby"}));
        c.addTranslation(new QualifiedContentType(new String[]{SINGLE_LINE_COMMENT}), new QualifiedContentType(new String[]{"comment.line.number-sign.ruby"}));
        c.addTranslation(new QualifiedContentType(new String[]{MULTI_LINE_COMMENT}), new QualifiedContentType(new String[]{"comment.block.documentation.ruby"}));
        c.addTranslation(new QualifiedContentType(new String[]{REGULAR_EXPRESSION}), new QualifiedContentType(new String[]{"string.regexp.classic.ruby"}));
        c.addTranslation(new QualifiedContentType(new String[]{COMMAND}), new QualifiedContentType(new String[]{"string.interpolated.ruby"}));
    }

    private RubySourceConfiguration() {
    }

    public static synchronized RubySourceConfiguration getDefault() {
        if (instance == null) {
            instance = new RubySourceConfiguration();
        }
        return instance;
    }

    public String[] getContentTypes() {
        return CONTENT_TYPES;
    }

    public String[][] getTopContentTypes() {
        return TOP_CONTENT_TYPES;
    }

    public String[] getSpellingContentTypes() {
        return SPELLING_CONTENT_TYPES;
    }

    public IPredicateRule[] getPartitioningRules() {
        return this.partitioningRules;
    }

    public ISubPartitionScanner createSubPartitionScanner() {
        return new SubPartitionScanner(this.partitioningRules, CONTENT_TYPES, RubySourceConfiguration.getToken(DEFAULT));
    }

    public String getDocumentContentType(String contentType) {
        if (contentType.startsWith(PREFIX)) {
            return "com.aptana.contenttype.ruby";
        }
        return null;
    }

    public void setupPresentationReconciler(PresentationReconciler reconciler, ISourceViewer sourceViewer) {
        LineContinuationDamagerRepairer dr = new LineContinuationDamagerRepairer(this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)dr, DEFAULT);
        reconciler.setRepairer((IPresentationRepairer)dr, DEFAULT);
        dr = new ThemeingDamagerRepairer(this.getSingleLineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, SINGLE_LINE_COMMENT);
        reconciler.setRepairer((IPresentationRepairer)dr, SINGLE_LINE_COMMENT);
        dr = new ThemeingDamagerRepairer(this.getMultiLineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, MULTI_LINE_COMMENT);
        reconciler.setRepairer((IPresentationRepairer)dr, MULTI_LINE_COMMENT);
        dr = new ThemeingDamagerRepairer(this.getRegexpScanner());
        reconciler.setDamager((IPresentationDamager)dr, REGULAR_EXPRESSION);
        reconciler.setRepairer((IPresentationRepairer)dr, REGULAR_EXPRESSION);
        dr = new ThemeingDamagerRepairer(this.getCommandScanner());
        reconciler.setDamager((IPresentationDamager)dr, COMMAND);
        reconciler.setRepairer((IPresentationRepairer)dr, COMMAND);
        dr = new ThemeingDamagerRepairer(this.getSingleQuotedStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, STRING_SINGLE);
        reconciler.setRepairer((IPresentationRepairer)dr, STRING_SINGLE);
        dr = new ThemeingDamagerRepairer(this.getDoubleQuotedStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, STRING_DOUBLE);
        reconciler.setRepairer((IPresentationRepairer)dr, STRING_DOUBLE);
    }

    public IContentAssistProcessor getContentAssistProcessor(AbstractThemeableEditor editor, String contentType) {
        if (DEFAULT.equals(contentType) || "__dftl_partition_content_type".equals(contentType)) {
            return new RubyContentAssistProcessor(editor);
        }
        if (STRING_DOUBLE.equals(contentType) || COMMAND.equals(contentType)) {
            return new RubyDoubleQuotedStringContentAssistProcessor(editor);
        }
        if (REGULAR_EXPRESSION.equals(contentType)) {
            return new RubyRegexpContentAssistProcessor(editor);
        }
        if (MULTI_LINE_COMMENT.equals(contentType) || SINGLE_LINE_COMMENT.equals(contentType)) {
            return new RubyCommentContentAssistProcessor(editor);
        }
        return null;
    }

    private ITokenScanner getCodeScanner() {
        return new RubyCodeScanner();
    }

    private ITokenScanner getMultiLineCommentScanner() {
        return new CommentScanner(RubySourceConfiguration.getToken("comment.block.documentation.ruby"));
    }

    private ITokenScanner getSingleLineCommentScanner() {
        return new CommentScanner(RubySourceConfiguration.getToken("comment.line.number-sign.ruby"));
    }

    private ITokenScanner getRegexpScanner() {
        return new RubyRegexpScanner();
    }

    private ITokenScanner getCommandScanner() {
        return new SingleTokenScanner(RubySourceConfiguration.getToken("string.interpolated.ruby"));
    }

    private ITokenScanner getSingleQuotedStringScanner() {
        return new SingleTokenScanner(RubySourceConfiguration.getToken("string.quoted.single.ruby"));
    }

    private ITokenScanner getDoubleQuotedStringScanner() {
        return new SingleTokenScanner(RubySourceConfiguration.getToken("string.quoted.double.ruby"));
    }

    private static IToken getToken(String tokenName) {
        return CommonUtil.getToken((String)tokenName);
    }
}

