/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.ruby;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.ruby.QueuedToken;
import com.aptana.editor.ruby.RubyEditorPlugin;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.jrubyparser.CompatVersion;
import org.jrubyparser.IRubyWarnings;
import org.jrubyparser.Parser;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.CommentNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.lexer.HeredocTerm;
import org.jrubyparser.lexer.Lexer;
import org.jrubyparser.lexer.LexerSource;
import org.jrubyparser.lexer.StrTerm;
import org.jrubyparser.lexer.SyntaxException;
import org.jrubyparser.parser.ParserConfiguration;
import org.jrubyparser.parser.ParserResult;
import org.jrubyparser.parser.ParserSupport;

public class RubySourcePartitionScanner
implements IPartitionTokenScanner {
    private static final String INDENTED_HEREDOC_MARKER_PREFIX = "<<-";
    private static final String HEREDOC_MARKER_PREFIX = "<<";
    private static final String DEFAULT_FILENAME = "filename";
    private static final String BEGIN = "=begin";
    private Lexer lexer;
    private ParserSupport parserSupport;
    private ParserResult result;
    private String fContents;
    private LexerSource lexerSource;
    private Reader reader;
    private int origOffset;
    private int origLength;
    private int fLength;
    private int fOffset;
    private List<QueuedToken> fQueue = new ArrayList<QueuedToken>();
    private String fContentType = "__rb__dftl_partition_content_type";
    private boolean inSingleQuote;
    private String fOpeningString;

    public RubySourcePartitionScanner() {
        this.lexer = new Lexer();
        this.parserSupport = new ParserSupport();
        ParserConfiguration config = new ParserConfiguration(0, CompatVersion.BOTH);
        this.parserSupport.setConfiguration(config);
        this.result = new ParserResult();
        this.parserSupport.setResult(this.result);
        this.lexer.setParserSupport(this.parserSupport);
        this.lexer.setWarnings((IRubyWarnings)new Parser.NullWarnings());
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        this.reset();
        int myOffset = offset;
        if (contentType != null) {
            int diff = offset - partitionOffset;
            myOffset = partitionOffset;
            length += diff;
            this.fContentType = contentType;
            if (this.fContentType.equals("__rb_singleline_comment") || this.fContentType.equals("__dftl_partition_content_type")) {
                this.fContentType = "__rb__dftl_partition_content_type";
            }
        }
        if (myOffset == -1) {
            myOffset = 0;
        }
        ParserConfiguration config = new ParserConfiguration(0, CompatVersion.BOTH);
        try {
            this.fContents = document.get(myOffset, length);
        }
        catch (BadLocationException badLocationException) {
            this.fContents = "";
        }
        this.reader = new BufferedReader(new StringReader(this.fContents));
        this.lexerSource = LexerSource.getSource((String)DEFAULT_FILENAME, (Reader)this.reader, (ParserConfiguration)config);
        this.lexer.setSource(this.lexerSource);
        if (partitionOffset > 0) {
            try {
                ITypedRegion region = document.getPartition(partitionOffset - 1);
                if ("__rb_string_double".equals(region.getType()) || "__rb_string_single".equals(region.getType()) || "__rb_regular_expression".equals(region.getType()) || "__rb_command".equals(region.getType())) {
                    this.lexer.setLexState(Lexer.LexState.EXPR_END);
                }
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)RubyEditorPlugin.getDefault(), (String)("Unable to get previous partition at offset: " + offset), (Throwable)e);
            }
        }
        this.origOffset = myOffset;
        this.origLength = length;
    }

    public int getTokenLength() {
        return this.fLength;
    }

    public int getTokenOffset() {
        return this.fOffset;
    }

    public IToken nextToken() {
        if (!this.fQueue.isEmpty()) {
            return this.popTokenOffQueue();
        }
        this.setOffset(this.getAdjustedOffset());
        this.setLength(0);
        IToken returnValue = this.createToken(this.fContentType);
        boolean isEOF = false;
        try {
            boolean bl = isEOF = !this.lexer.advance();
            if (isEOF) {
                returnValue = Token.EOF;
            } else {
                StrTerm strTerm;
                int lexerToken = this.lexer.token();
                if (this.isSingleVariableStringInterpolation(lexerToken)) {
                    return this.handleSingleVariableStringInterpolation();
                }
                if (this.isStringInterpolation(lexerToken)) {
                    return this.handleStringInterpolation();
                }
                if ((lexerToken == 365 || lexerToken == 367 || lexerToken == 366 || lexerToken == 369 || lexerToken == 368 || lexerToken == 364) && (strTerm = this.lexer.getStrTerm()) != null) {
                    strTerm.splitEmbeddedTokens();
                }
                returnValue = this.getToken(lexerToken);
            }
            List comments = this.result.getCommentNodes();
            if (comments != null && !comments.isEmpty()) {
                this.parseOutComments(comments);
                this.addQueuedToken(returnValue);
                comments.clear();
                return this.popTokenOffQueue();
            }
        }
        catch (SyntaxException se) {
            if ("embedded document meets end of file".equals(se.getMessage())) {
                return this.handleUnterminedMultilineComment(se);
            }
            if (se.getPid().equals((Object)SyntaxException.PID.STRING_MARKER_MISSING) || se.getPid().equals((Object)SyntaxException.PID.STRING_HITS_EOF)) {
                return this.handleUnterminatedString(se);
            }
            if (this.lexerSource.getOffset() - this.origLength == 0) {
                return Token.EOF;
            }
            this.setLength(this.getAdjustedOffset() - this.fOffset);
            return this.createToken("__rb__dftl_partition_content_type");
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)RubyEditorPlugin.getDefault(), (Throwable)e);
        }
        if (!isEOF) {
            this.setLength(this.getAdjustedOffset() - this.fOffset);
            if (this.fLength == 0 && (returnValue.getData().equals("__rb_string_double") || returnValue.getData().equals("__rb_string_single"))) {
                return this.nextToken();
            }
        }
        return returnValue;
    }

    private boolean isSingleVariableStringInterpolation(int lexerToken) {
        return !this.inSingleQuote && lexerToken == 371;
    }

    private boolean isStringInterpolation(int lexerToken) {
        return !this.inSingleQuote && lexerToken == 370;
    }

    private void setLength(int newLength) {
        this.fLength = newLength;
        Assert.isTrue((this.fLength >= 0 ? 1 : 0) != 0);
    }

    private IToken handleUnterminedMultilineComment(SyntaxException se) {
        return this.handleUnterminatedPartition(se.getPosition().getStartOffset(), "__rb_multiline_comment");
    }

    private IToken handleUnterminatedString(SyntaxException se) {
        return this.handleUnterminatedPartition(se.getPosition().getStartOffset(), this.fContentType);
    }

    private IToken handleUnterminatedPartition(int start, String contentType) {
        int length = this.fContents.length() - start;
        QueuedToken qtoken = new QueuedToken(this.createToken(contentType), start + this.origOffset, length);
        if (this.fOffset == this.origOffset) {
            IToken token;
            RubySourcePartitionScanner scanner = new RubySourcePartitionScanner();
            String possible = new String(this.fContents.substring(0, start));
            Document document = new Document(possible);
            scanner.setRange((IDocument)document, this.origOffset, possible.length());
            while (!(token = scanner.nextToken()).isEOF()) {
                this.push(new QueuedToken(token, scanner.getTokenOffset() + this.fOffset, scanner.getTokenLength()));
            }
        }
        this.push(qtoken);
        this.push(new QueuedToken(Token.EOF, start + this.origOffset + length, 0));
        return this.popTokenOffQueue();
    }

    private IToken handleSingleVariableStringInterpolation() throws IOException {
        this.addPoundToken();
        int start = this.lexerSource.getOffset();
        this.lexer.nextToken();
        int end = this.lexerSource.getOffset();
        String content = this.fContents.substring(start, end);
        this.push(new QueuedToken(this.createToken("__rb__dftl_partition_content_type"), this.fOffset, content.length()));
        this.setOffset(this.fOffset + content.length());
        return this.popTokenOffQueue();
    }

    private IToken handleStringInterpolation() throws IOException {
        this.addPoundBraceToken();
        int start = this.lexerSource.getOffset();
        this.lexer.nextToken();
        int end = this.lexerSource.getOffset();
        String content = this.fContents.substring(start, end);
        this.scanTokensInsideDynamicPortion(content);
        return this.popTokenOffQueue();
    }

    public void setRange(IDocument document, int offset, int length) {
        this.setPartialRange(document, offset, length, "__rb__dftl_partition_content_type", 0);
    }

    private void reset() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {}
            this.reader = null;
        }
        this.lexer.reset();
        this.lexer.setState(Lexer.LexState.EXPR_BEG);
        this.lexer.setPreserveSpaces(true);
        this.parserSupport.initTopLocalVariables();
        this.fQueue.clear();
        this.inSingleQuote = false;
        this.fContentType = "__rb__dftl_partition_content_type";
    }

    private void setOffset(int offset) {
        this.fOffset = offset;
    }

    private void addPoundToken() {
        this.addStringToken(1);
    }

    private void scanTokensInsideDynamicPortion(String content) {
        IToken token;
        RubySourcePartitionScanner scanner = new RubySourcePartitionScanner();
        Document document = new Document(content);
        scanner.setRange((IDocument)document, 0, content.length());
        while (!(token = scanner.nextToken()).isEOF()) {
            this.push(new QueuedToken(token, scanner.getTokenOffset() + this.fOffset, scanner.getTokenLength()));
        }
        this.setOffset(this.fOffset + content.length());
    }

    private void addPoundBraceToken() {
        this.addStringToken(2);
    }

    private void addStringToken(int length) {
        String contentType = this.getStringType();
        if ("__rb__dftl_partition_content_type".equals(contentType)) {
            contentType = "__rb_string_double";
        }
        this.push(new QueuedToken(this.createToken(contentType), this.fOffset, length));
        this.setOffset(this.fOffset + length);
    }

    private void parseOutComments(List<CommentNode> comments) {
        for (CommentNode comment : comments) {
            int offset = this.correctOffset(comment);
            int length = comment.getContent().length();
            if (this.isCommentMultiLine(comment)) {
                length = this.origOffset + comment.getPosition().getEndOffset() - offset;
                if (comment.getContent().charAt(0) != '=') {
                    ++length;
                }
            }
            IToken token = this.createToken(this.getContentType(comment));
            this.push(new QueuedToken(token, offset, length));
        }
    }

    private IToken popTokenOffQueue() {
        QueuedToken token = this.fQueue.remove(0);
        this.setOffset(token.getOffset());
        this.setLength(token.getLength());
        return token.getToken();
    }

    private IToken getToken(int i) {
        if (this.fContentType.equals("__rb_string_double") && this.insideHeredoc() && this.reachedEndOfHeredoc()) {
            this.fContentType = "__rb__dftl_partition_content_type";
            this.inSingleQuote = false;
            return this.createToken("__rb_string_double");
        }
        if (this.fContentType.equals("__rb_multiline_comment") && i != 382) {
            this.fContentType = "__rb__dftl_partition_content_type";
        }
        switch (i) {
            case 32: 
            case 382: {
                return this.createToken(this.getStringType());
            }
            case 381: {
                return this.createToken("__rb_singleline_comment");
            }
            case 383: {
                this.fContentType = "__rb_multiline_comment";
                return this.createToken("__rb_multiline_comment");
            }
            case 377: {
                this.fContentType = this.getStringType();
                return this.createToken(this.fContentType);
            }
            case 365: {
                String opening = this.getOpeningString();
                if ("%".equals(opening)) {
                    return this.createToken(this.fContentType);
                }
                this.fOpeningString = opening;
                if (this.fOpeningString.equals("'") || this.fOpeningString.startsWith("%q")) {
                    this.inSingleQuote = true;
                    this.fContentType = "__rb_string_single";
                } else {
                    if (this.fOpeningString.startsWith(HEREDOC_MARKER_PREFIX)) {
                        this.fOpeningString = this.generateOpeningStringForHeredocMarker(this.fOpeningString);
                        if (this.fOpeningString.length() > 0 && this.fOpeningString.charAt(0) == '\'') {
                            return this.createToken("__rb_string_single");
                        }
                        return this.createToken("__rb_string_double");
                    }
                    this.fContentType = "__rb_string_double";
                }
                return this.createToken(this.fContentType);
            }
            case 366: {
                this.fOpeningString = this.getOpeningString();
                this.fContentType = "__rb_command";
                return this.createToken("__rb_command");
            }
            case 368: 
            case 369: {
                this.fOpeningString = this.getOpeningString();
                this.fContentType = "__rb_string_single";
                if (this.fOpeningString.length() > 1 && this.fOpeningString.charAt(0) == '%' && Character.isUpperCase(this.fOpeningString.charAt(1))) {
                    this.fContentType = "__rb_string_double";
                }
                return this.createToken(this.fContentType);
            }
            case 372: {
                String oldContentType = this.fContentType;
                this.fContentType = "__rb__dftl_partition_content_type";
                return this.createToken(oldContentType);
            }
            case 367: {
                this.fOpeningString = this.getOpeningString();
                this.fContentType = "__rb_regular_expression";
                return this.createToken("__rb_regular_expression");
            }
            case 380: {
                this.fContentType = "__rb__dftl_partition_content_type";
                return this.createToken("__rb_regular_expression");
            }
            case 364: {
                int charAt = this.fOffset - this.origOffset;
                char c = this.fContents.charAt(charAt);
                int nextCharOffset = this.fOffset + 1;
                while (c == ' ') {
                    ++nextCharOffset;
                    c = this.fContents.charAt(++charAt);
                }
                if (this.fContents.length() <= charAt + 1) {
                    return this.createToken("__rb__dftl_partition_content_type");
                }
                if (c == '%') {
                    this.fOpeningString = this.getOpeningString();
                    this.fContentType = "__rb_string_single";
                } else if (c == ':') {
                    if (this.fContents.length() <= charAt + 1) {
                        return this.createToken("__rb__dftl_partition_content_type");
                    }
                    ++nextCharOffset;
                    if ((c = this.fContents.charAt(++charAt)) == '\"') {
                        this.fOpeningString = "\"";
                        this.push(new QueuedToken(this.createToken("__rb_string_double"), nextCharOffset - 1, 1));
                        this.fContentType = "__rb_string_double";
                    }
                }
                return this.createToken("__rb__dftl_partition_content_type");
            }
        }
        return this.createToken(this.fContentType);
    }

    protected IToken createToken(String tokenName) {
        return CommonUtil.getToken((String)tokenName);
    }

    private String getStringType() {
        StrTerm strTerm = this.lexer.getStrTerm();
        if (strTerm != null) {
            if (strTerm instanceof HeredocTerm) {
                strTerm.splitEmbeddedTokens();
            }
            if (strTerm.isSubstituting()) {
                if ("__rb_regular_expression".equals(this.fContentType) || "__rb_command".equals(this.fContentType)) {
                    return this.fContentType;
                }
                return "__rb_string_double";
            }
            this.inSingleQuote = true;
            return "__rb_string_single";
        }
        return this.fContentType;
    }

    private boolean insideHeredoc() {
        return this.fOpeningString != null && this.fOpeningString.endsWith("\n");
    }

    private boolean reachedEndOfHeredoc() {
        return this.fContents.startsWith(this.fOpeningString.trim(), this.fOffset - this.origOffset);
    }

    private String generateOpeningStringForHeredocMarker(String marker) {
        if (marker.startsWith(INDENTED_HEREDOC_MARKER_PREFIX)) {
            marker = marker.substring(3);
        } else if (marker.startsWith(HEREDOC_MARKER_PREFIX)) {
            marker = marker.substring(2);
        }
        return String.valueOf(marker) + "\n";
    }

    private String getOpeningString() {
        return this.getUntrimmedOpeningString().trim();
    }

    private String getUntrimmedOpeningString() {
        int start = this.fOffset - this.origOffset;
        List comments = this.result.getCommentNodes();
        if (comments != null && !comments.isEmpty()) {
            int end;
            Node comment = (Node)comments.get(comments.size() - 1);
            start = end = comment.getPosition().getEndOffset();
        }
        return new String(this.fContents.substring(start, this.lexerSource.getOffset()));
    }

    private int correctOffset(CommentNode comment) {
        return this.origOffset + comment.getPosition().getStartOffset();
    }

    private boolean isCommentMultiLine(CommentNode comment) {
        String src = RubySourcePartitionScanner.getSource(this.fContents, (Node)comment);
        return src != null && src.startsWith(BEGIN);
    }

    private String getContentType(CommentNode comment) {
        if (this.isCommentMultiLine(comment)) {
            return "__rb_multiline_comment";
        }
        return "__rb_singleline_comment";
    }

    private void addQueuedToken(IToken returnValue) {
        QueuedToken token = this.peek();
        this.setOffset(token.getOffset() + token.getLength());
        int length = this.getAdjustedOffset() - this.fOffset;
        if (length < 0) {
            length = 0;
        }
        this.push(new QueuedToken(returnValue, this.fOffset, length));
    }

    private QueuedToken peek() {
        return this.fQueue.get(this.fQueue.size() - 1);
    }

    private void push(QueuedToken token) {
        Assert.isTrue((token.getLength() >= 0 ? 1 : 0) != 0);
        this.fQueue.add(token);
    }

    private int getAdjustedOffset() {
        return this.lexerSource.getOffset() + this.origOffset;
    }

    private static String getSource(String contents, Node node) {
        if (node == null || contents == null) {
            return null;
        }
        SourcePosition pos = node.getPosition();
        if (pos == null) {
            return null;
        }
        if (pos.getStartOffset() >= contents.length()) {
            return null;
        }
        if (pos.getEndOffset() > contents.length()) {
            return null;
        }
        return new String(contents.substring(pos.getStartOffset(), pos.getEndOffset()));
    }
}

