/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.ruby.hyperlink;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.ruby.RubyEditorPlugin;
import com.aptana.ruby.core.codeassist.ResolutionTarget;
import com.aptana.ui.util.UIUtils;
import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class ResolutionTargetHyperlink
implements IHyperlink {
    private IRegion region;
    private ResolutionTarget target;

    public ResolutionTargetHyperlink(IRegion region, ResolutionTarget target) {
        this.region = region;
        this.target = target;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return MessageFormat.format("{0}, {1}", this.target.getURI().toString(), this.target.getRange().toString());
    }

    public void open() {
        try {
            IWorkbenchPage page = UIUtils.getActivePage();
            IFileStore store = EFS.getStore((URI)this.target.getURI());
            if (store == null) {
                return;
            }
            IEditorPart editor = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)store);
            this.setEditorToRange(editor);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)RubyEditorPlugin.getDefault(), (Throwable)e);
        }
    }

    private void setEditorToRange(IEditorPart editorPart) {
        if (!(editorPart instanceof ITextEditor)) {
            return;
        }
        ITextEditor textEditor = (ITextEditor)editorPart;
        textEditor.selectAndReveal(this.target.getRange().getStartingOffset(), this.target.getRange().getLength());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolutionTargetHyperlink)) {
            return false;
        }
        ResolutionTargetHyperlink other = (ResolutionTargetHyperlink)obj;
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals((Object)other.target));
    }
}

