/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.ruby.internal.contentassist;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;

public class RubyRegexpContentAssistProcessor
extends CommonContentAssistProcessor {
    private static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];
    private static final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private static final Map<String, String> PROPOSALS = new TreeMap<String, String>();

    static {
        PROPOSALS.put("$", "End of line");
        PROPOSALS.put("()", "Grouping");
        PROPOSALS.put("*", "Zero or more repetitions of preceding");
        PROPOSALS.put("+", "One or more repetitions of preceding");
        PROPOSALS.put("?", "At most one repetition of preceding");
        PROPOSALS.put("[:alnum:]", "Alphanumeric character class");
        PROPOSALS.put("[:alpha:]", "Uppercase or lowercase letter");
        PROPOSALS.put("[:blank:]", "Blank and tab");
        PROPOSALS.put("[:cntrl:]", "Control characters (at least 0x00-0x1f,0x7f)");
        PROPOSALS.put("[:digit:]", "Digit");
        PROPOSALS.put("[:graph:]", "Printable character excluding space");
        PROPOSALS.put("[:lower:]", "Lowercase letter");
        PROPOSALS.put("[:print:]", "Any printable character (including space)");
        PROPOSALS.put("[:punct:]", "Printable character excluding space and alp");
        PROPOSALS.put("[:space:]", "Whitespace (same as \\s)");
        PROPOSALS.put("[:upper:]", "Uppercase letter");
        PROPOSALS.put("[:xdigit:]", "Hex digit (0-9, a-f, A-F)");
        PROPOSALS.put("\\A", "Beginning of string");
        PROPOSALS.put("\\B", "Non-word boundary");
        PROPOSALS.put("\\D", "Non-digit character");
        PROPOSALS.put("\\S", "Non-space character");
        PROPOSALS.put("\\W", "Neither letter or digit");
        PROPOSALS.put("\\Z", "End of string (except \\n)");
        PROPOSALS.put("\\b", "Word boundary (outside range specification); Backspace (0x08) (if in a range specification)");
        PROPOSALS.put("\\d", "Digit character; same as [0-9]");
        PROPOSALS.put("\\s", "Space character; same as [ \\t\\n\\r\\f]");
        PROPOSALS.put("\\w", "Letter or digit; same as [0-9A-Za-z]");
        PROPOSALS.put("\\z", "End of string");
        PROPOSALS.put("^", "Start of line");
        PROPOSALS.put("{m, n}", "At least <i>m</i> and at most <i>n</i> repetitions of the preceding");
        PROPOSALS.put("|", "Either preceding or next expression may match");
    }

    public RubyRegexpContentAssistProcessor(AbstractThemeableEditor editor) {
        super(editor);
    }

    protected ICompletionProposal[] doComputeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
        try {
            String prefix = this.getPrefix(viewer, offset);
            ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
            for (Map.Entry<String, String> entry : PROPOSALS.entrySet()) {
                if (!entry.getKey().startsWith(prefix)) continue;
                result.add(this.createProposal(entry.getKey(), prefix, offset - prefix.length(), entry.getValue()));
            }
            return result.toArray(new ICompletionProposal[result.size()]);
        }
        catch (BadLocationException badLocationException) {
            return NO_PROPOSALS;
        }
    }

    private ICompletionProposal createProposal(String proposal, String prefix, int offset, String description) {
        CommonCompletionProposal p = new CommonCompletionProposal(proposal, offset, prefix.length(), proposal.length(), null, proposal, null, description);
        return p;
    }

    private String getPrefix(ITextViewer viewer, int offset) throws BadLocationException {
        IDocument doc = viewer.getDocument();
        if (doc == null || offset > doc.getLength()) {
            return null;
        }
        int length = 0;
        while (--offset >= 0 && this.isPrefixChar(doc.getChar(offset))) {
            ++length;
        }
        return doc.get(offset + 1, length);
    }

    private boolean isPrefixChar(char c) {
        switch (c) {
            case '\\': {
                return true;
            }
        }
        return false;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return NO_CONTEXTS;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'\\'};
    }
}

