/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.launching;

import com.aptana.core.ShellExecutable;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ExecutableUtil;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.ProcessUtil;
import com.aptana.filewatcher.FileWatcher;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.contentobjects.jnotify.JNotifyException;
import net.contentobjects.jnotify.JNotifyListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class RubyLaunchingPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.aptana.ruby.launching";
    private static final String GEM_COMMAND = "gem";
    private static final String RUBYW = "rubyw";
    private static final String RBENV = "rbenv";
    public static final String RUBY = "ruby";
    public static final String RAKE = "rake";
    public static final String RAKEFILE = "Rakefile";
    private static Map<IProject, String> projectToVersion = new HashMap<IProject, String>();
    private static Map<IPath, IPath> workingDirToRubyExe = new HashMap<IPath, IPath>();
    private static Map<String, Set<IPath>> rubyToLoadPaths = new HashMap<String, Set<IPath>>();
    private static Map<String, Set<IPath>> rubyToGemPaths = new HashMap<String, Set<IPath>>();
    private static Map<IPath, String> pathToVersion = new HashMap<IPath, String>();
    protected static RubyLaunchingPlugin plugin;
    private static RbenvVersionListener rbEnvVersionListener;
    private static Map<IPath, Integer> filewatcherIds;

    static {
        filewatcherIds = new HashMap<IPath, Integer>();
    }

    public static IPath getRakePath(IPath workingDir) {
        return RubyLaunchingPlugin.getBinaryScriptPath(RAKE, workingDir);
    }

    public static IPath resolveRBENVShimPath(IPath rbenvShimPath, IPath workingDir) {
        IStatus status;
        IPath rbEnvPath;
        if (rbenvShimPath == null) {
            return null;
        }
        if (!"win32".equals(Platform.getOS()) && rbenvShimPath.toOSString().contains("/.rbenv/") && (rbEnvPath = ExecutableUtil.find((String)RBENV, (boolean)false, null, (IPath)workingDir)) != null && (status = ProcessUtil.runInBackground((String)rbEnvPath.toOSString(), (IPath)workingDir, (String[])new String[]{"which", rbenvShimPath.lastSegment()})).isOK()) {
            return Path.fromOSString((String)status.getMessage());
        }
        return rbenvShimPath;
    }

    public static IPath rubyExecutablePath(IPath workingDir) {
        Path pathKey;
        Object object = pathKey = workingDir == null ? Path.ROOT : workingDir;
        if (!workingDirToRubyExe.containsKey(pathKey)) {
            IPath resolved;
            IPath path = null;
            if ("win32".equals(Platform.getOS())) {
                path = ExecutableUtil.find((String)RUBYW, (boolean)true, RubyLaunchingPlugin.getCommonRubyBinaryLocations(RUBYW), (IPath)workingDir);
            }
            if (path == null && (resolved = RubyLaunchingPlugin.resolveRBENVShimPath(path = ExecutableUtil.find((String)RUBY, (boolean)true, RubyLaunchingPlugin.getCommonRubyBinaryLocations(RUBY), (IPath)workingDir), workingDir)) != null) {
                if (workingDir != null && !resolved.equals((Object)path)) {
                    try {
                        Integer watchId;
                        if (rbEnvVersionListener == null) {
                            rbEnvVersionListener = new RbenvVersionListener();
                        }
                        if ((watchId = filewatcherIds.get(pathKey)) == null) {
                            watchId = FileWatcher.addWatch((String)workingDir.toOSString(), (int)15, (boolean)false, (JNotifyListener)rbEnvVersionListener);
                            filewatcherIds.put((IPath)pathKey, watchId);
                        }
                    }
                    catch (JNotifyException e) {
                        IdeLog.logError((Plugin)RubyLaunchingPlugin.getDefault(), (Throwable)e);
                    }
                }
                path = resolved;
            }
            if (IdeLog.isInfoEnabled((Plugin)RubyLaunchingPlugin.getDefault(), (String)"com.aptana.ruby.launching/debug")) {
                IdeLog.logInfo((Plugin)RubyLaunchingPlugin.getDefault(), (String)MessageFormat.format("Found ruby executable ''{0}'' for working directory: {1}", path, pathKey));
            }
            workingDirToRubyExe.put((IPath)pathKey, path);
        }
        return workingDirToRubyExe.get(pathKey);
    }

    private static List<IPath> getCommonRubyBinaryLocations(String binaryName) {
        ArrayList<IPath> locations = new ArrayList<IPath>();
        if ("win32".equals(Platform.getOS())) {
            locations.add(Path.fromOSString((String)"C:\\ruby\\bin").append(binaryName).addFileExtension("exe"));
        } else {
            locations.add(Path.fromOSString((String)PlatformUtil.expandEnvironmentStrings((String)("~/.rvm/bin/" + binaryName))));
            locations.add(Path.fromOSString((String)"/opt/local/bin/").append(binaryName));
            locations.add(Path.fromOSString((String)"/usr/local/bin/").append(binaryName));
            locations.add(Path.fromOSString((String)"/usr/bin/").append(binaryName));
        }
        if ("macosx".equals(Platform.getOS())) {
            locations.add(Path.fromOSString((String)"/System/Library/Frameworks/Ruby.framework/Versions/Current/usr/bin/").append(binaryName));
        }
        return locations;
    }

    public static synchronized String getRubyVersionForProject(IProject project) {
        if (project == null) {
            return null;
        }
        if (projectToVersion.containsKey(project)) {
            return projectToVersion.get(project);
        }
        IPath rubyExe = RubyLaunchingPlugin.rubyExecutablePath(project.getLocation());
        String version = RubyLaunchingPlugin.getRubyVersion(rubyExe);
        projectToVersion.put(project, version);
        return version;
    }

    public static synchronized Set<IPath> getLoadpaths(IProject project) {
        Set<IPath> result;
        String rubyExe;
        IPath workingDir = project == null ? null : project.getLocation();
        IPath rubyPath = RubyLaunchingPlugin.rubyExecutablePath(workingDir);
        String string = rubyExe = rubyPath == null ? RUBY : rubyPath.toOSString();
        if (!rubyToLoadPaths.containsKey(rubyExe)) {
            String rawLoadPathOutput;
            Map env = null;
            if (!"win32".equals(Platform.getOS())) {
                env = ShellExecutable.getEnvironment((IPath)workingDir);
            }
            if ((rawLoadPathOutput = ProcessUtil.outputForCommand((String)rubyExe, null, (Map)env, (String[])new String[]{"-e", "puts $:"})) == null) {
                rubyToLoadPaths.put(rubyExe, null);
            } else {
                HashSet<Path> paths = new HashSet<Path>();
                String[] loadpaths = rawLoadPathOutput.split("\r\n|\r|\n");
                if (loadpaths != null) {
                    String[] stringArray = loadpaths;
                    int n = loadpaths.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String loadpath = stringArray[n2];
                        if (!".".equals(loadpath)) {
                            paths.add(new Path(loadpath));
                        }
                        ++n2;
                    }
                }
                rubyToLoadPaths.put(rubyExe, paths);
            }
        }
        if ((result = rubyToLoadPaths.get(rubyExe)) == null) {
            return Collections.emptySet();
        }
        return result;
    }

    public static IPath getBinaryScriptPath(String binary, List<IPath> pathsToSearch, IPath workingDirectory) {
        IPath path = ExecutableUtil.find((String)binary, (boolean)false, pathsToSearch, (IPath)workingDirectory);
        if ("win32".equals(Platform.getOS())) {
            return path;
        }
        return RubyLaunchingPlugin.resolveRBENVShimPath(path, workingDirectory);
    }

    public static IPath getBinaryScriptPath(String binary, IPath workingDirectory) {
        return RubyLaunchingPlugin.getBinaryScriptPath(binary, null, workingDirectory);
    }

    public static synchronized Set<IPath> getGemPaths(IProject project) {
        Set<IPath> result;
        String rubyPathString;
        IPath wd = project == null ? null : project.getLocation();
        IPath rubyPath = RubyLaunchingPlugin.rubyExecutablePath(wd);
        String string = rubyPathString = rubyPath == null ? RUBY : rubyPath.toOSString();
        if (!rubyToGemPaths.containsKey(rubyPathString)) {
            IPath gemBinPath = RubyLaunchingPlugin.getBinaryScriptPath(GEM_COMMAND, wd);
            String gemCommand = gemBinPath == null ? GEM_COMMAND : gemBinPath.toOSString();
            Map env = null;
            if (!"win32".equals(Platform.getOS())) {
                env = ShellExecutable.getEnvironment((IPath)wd);
            }
            IStatus status = ProcessUtil.runInBackground((String)rubyPathString, (IPath)wd, (Map)env, (String[])new String[]{gemCommand, "env", "gempath"});
            String gemEnvOutput = null;
            if (status.isOK()) {
                gemEnvOutput = status.getMessage();
            }
            if (gemEnvOutput == null) {
                rubyToGemPaths.put(rubyPathString, null);
            } else {
                HashSet<IPath> paths = new HashSet<IPath>();
                String[] gemPaths = gemEnvOutput.split(File.pathSeparator);
                if (gemPaths != null) {
                    String[] stringArray = gemPaths;
                    int n = gemPaths.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String gemPath = stringArray[n2];
                        IPath gemsPath = new Path(gemPath).append("gems");
                        paths.add(gemsPath);
                        ++n2;
                    }
                }
                rubyToGemPaths.put(rubyPathString, paths);
            }
        }
        if ((result = rubyToGemPaths.get(rubyPathString)) == null) {
            return Collections.emptySet();
        }
        return result;
    }

    public static Plugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        try {
            for (Map.Entry<IPath, Integer> entry : filewatcherIds.entrySet()) {
                try {
                    FileWatcher.removeWatch((int)entry.getValue());
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)RubyLaunchingPlugin.getDefault(), (Throwable)e);
                }
            }
        }
        finally {
            filewatcherIds = null;
            plugin = null;
            projectToVersion = null;
            workingDirToRubyExe = null;
            rubyToLoadPaths = null;
            pathToVersion = null;
            super.stop(context);
        }
    }

    public static String getPluginIdentifier() {
        return PLUGIN_ID;
    }

    public static synchronized String getRubyVersion(IPath rubyExe) {
        if (!pathToVersion.containsKey(rubyExe)) {
            String rubyPath = rubyExe == null ? RUBY : rubyExe.toOSString();
            Map env = null;
            if (!"win32".equals(Platform.getOS())) {
                env = ShellExecutable.getEnvironment();
            }
            String version = ProcessUtil.outputForCommand((String)rubyPath, null, (Map)env, (String[])new String[]{"-v"});
            pathToVersion.put(rubyExe, version);
        }
        return pathToVersion.get(rubyExe);
    }

    private static class RbenvVersionListener
    implements JNotifyListener {
        private static final String RBENV_VERSION_FILENAME = ".rbenv-version";

        private RbenvVersionListener() {
        }

        public void fileRenamed(int wd, String rootPath, String oldName, String newName) {
            if (newName.equals(RBENV_VERSION_FILENAME)) {
                this.fileCreated(wd, rootPath, newName);
            } else if (oldName.equals(RBENV_VERSION_FILENAME)) {
                this.fileDeleted(wd, rootPath, oldName);
            }
        }

        public void fileModified(int wd, String rootPath, String name) {
            if (name.equals(RBENV_VERSION_FILENAME)) {
                IPath path = Path.fromOSString((String)rootPath);
                workingDirToRubyExe.remove(path);
                pathToVersion.remove(path);
            }
        }

        public void fileDeleted(int wd, String rootPath, String name) {
            this.fileModified(wd, rootPath, name);
        }

        public void fileCreated(int wd, String rootPath, String name) {
            this.fileModified(wd, rootPath, name);
        }
    }
}

